-- SCRIPT SQL COMPLEMENTAR ADICIONADO EM 18:21 04-04-2013

insert into scripts (idscript, nome, descricao, sqlquery, tipo, datainicio) 
values (1, 'Consulta erros de rotina de scripts', 'Consulta os erros que ocorreram durante a execuo automtica de scripts feita durante a inicializao do sistema', 'select scripts.descricao, scripts.sqlquery, versao.nomeversao from scripts inner join versao on scripts.idversao = versao.idversao where scripts.idversao is not null and scripts.descricao like ''ERRO%'';', 'consulta', '2013-04-04');

insert into scripts (idscript, nome, descricao, sqlquery, tipo, datainicio) 
values (3, 'Limpa erros de rotina de scripts', 'Limpa o registro de erros que ocorreram durante a execuo automtica de scripts feita durante a inicializao do sistema', 'update scripts set descricao = concat(''CORRIGIDO '', descricao) where idversao is not null and descricao like ''ERRO%'' and idscript > 0;', 'update', '2013-04-04');

alter table scripts alter column tipo type character varying(10);

insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('B', 'Baixa');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('I', 'Intermediria');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('M', 'Mediana');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('A', 'Alta');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('E', 'Especialista');

-- INICIO - MODULO DE MUDANCA
alter table requisicaomudanca add column nomecategoriamudanca varchar(15);

alter table grupo add column comiteconsultivomudanca varchar(1) null ;

drop table tipomudanca;

create table tipomudanca (
   idtipomudanca integer not null,
   idtipofluxo integer null,
   idmodeloemailcriacao integer null,
   idmodeloemailfinalizacao integer null,
   idmodeloemailacoes integer null,
   idgrupoexecutor integer null,
   idcalendario integer null,
   nometipomudanca varchar(100) null,
   datainicio date null,
   datafim date null,
   primary key (idtipomudanca),
   foreign key (idtipofluxo) references bpm_tipofluxo (idtipofluxo),
   foreign key (idmodeloemailcriacao) references modelosemails (idmodeloemail),
   foreign key (idmodeloemailfinalizacao) references modelosemails (idmodeloemail),
   foreign key (idmodeloemailacoes) references modelosemails (idmodeloemail),
   foreign key (idgrupoexecutor) references grupo (idgrupo),
   foreign key (idcalendario) references calendario (idcalendario)
);

alter table requisicaomudanca

drop constraint requisicaomudanca_idcategoriamudanca_fkey;

-- alter table requisicaomudanca drop column tipo;

alter table requisicaomudanca rename idcategoriamudanca to idtipomudanca;

alter table requisicaomudanca 
add constraint fk_requisic_reference_tipomudanca foreign key (idtipomudanca) references tipomudanca (idtipomudanca);

alter table requisicaomudanca 
add column idcontrato int not null,
add column idunidade int,
add column idcontatorequisicaomudanca int;

create table contatorequisicaomudanca (
    idcontatorequisicaomudanca int not null,
    nomecontato varchar(100),
    telefonecontato varchar(100),
    emailcontato varchar(200),
    observacao text,
    idlocalidade int,
    ramal varchar(5),
    primary key ( idcontatorequisicaomudanca)
);

alter table requisicaomudanca add column idgrupocomite int null;

alter table requisicaomudanca add constraint fk_requisic_reference_grupo_comite 
foreign key (idgrupocomite) references grupo (idgrupo);

create table aprovacaomudanca (
   idaprovacaomudanca int not null,
   idrequisicaomudanca int null,
   idempregado int null,
   nomeempregado varchar(45) null,
   voto char(1) null,
   comentario varchar(200) null
);

alter table aprovacaomudanca add primary key (idaprovacaomudanca);

alter table aprovacaomudanca add constraint fk_requisicaomudanca_aprovacao 
foreign key (idrequisicaomudanca) references requisicaomudanca (idrequisicaomudanca);

alter table aprovacaomudanca add constraint fk_empregado_aprovacao foreign key (idempregado) 
references empregados (idempregado);

create index fk_empregado_idx on aprovacaomudanca (idempregado asc);

create index fk_requisicaomudanca_idx on aprovacaomudanca (idrequisicaomudanca asc);

alter table requisicaomudanca add column enviaemailgrupocomite varchar(1) null;

alter table ocorrenciamudanca
add column idcategoriaocorrencia int,
add column idorigemocorrencia int;

alter table requisicaomudanca 
add column datahorainicioagendada timestamp null default '1970-01-01 00:00:00', 
add column datahoraterminoagendada timestamp null default '1970-01-01 00:00:00';

alter table requisicaomudanca add column idlocalidade int;

alter table aprovacaomudanca add column datahorainicio timestamp null;

create table justificativamudanca (
   idjustificativamudanca int not null,
   descricaojustificativa varchar(100) not null,
   suspensao char(1) not null,
   situacao char(1) not null,
   aprovacao char(1) default null,
   deleted char(1) default null,
   primary key (idjustificativamudanca)
);

create table anexomudanca (
    idanexomudanca int not null primary key,
    idmudanca int,
    datainicio date,
    datafim date,
    nome varchar(256),
    link varchar(256),
    extensao varchar(10),
    descricao varchar(256)
);

alter table requisicaomudanca add column fechamento text null ;

alter table requisicaomudanca alter column datahoraconclusao set not null;

alter table requisicaomudanca alter column datahoraconclusao set default '1970-01-01 00:00:00';

alter table requisicaomudanca alter column datahoraconclusao drop not null;
alter table requisicaomudanca alter column datahoraconclusao set default null;
 
alter table requisicaomudanca alter column datahorainicio drop not null;
alter table requisicaomudanca alter column datahorainicio set default null;
 
alter table requisicaomudanca alter column datahoratermino drop not null;
alter table requisicaomudanca alter column datahoratermino set default null;
 
alter table requisicaomudanca alter column datahoracaptura drop not null;
alter table requisicaomudanca alter column datahoracaptura set default null;
 
alter table requisicaomudanca alter column datahorareativacao drop not null;
alter table requisicaomudanca alter column datahorareativacao set default null;
 
alter table requisicaomudanca alter column datahorasuspensao drop not null;
alter table requisicaomudanca alter column datahorasuspensao set default null;
 
alter table requisicaomudanca alter column datahorainicioagendada drop not null;
alter table requisicaomudanca alter column datahorainicioagendada set default null;
 
alter table requisicaomudanca alter column datahoraterminoagendada drop not null;
alter table requisicaomudanca alter column datahoraterminoagendada set default null;

-- EXCLUINDO A TRIGGER RESPONSAVEL PELO COMPORTAMENTO DE CONFIGURAR A DATA ATUAL POR PADRAO.
drop trigger add_current_date_to_requisicaomudanca on requisicaomudanca;

-- FIM - MODULO DE MUDANCA

-- Incio rodrigo.oliveira

alter table atividadesos add column contabilizar char(1);
alter table atividadesos alter column contabilizar set default null;

alter table atividadesos add column idservicocontratocontabil bigint;
alter table atividadesos alter column idservicocontratocontabil set default null;

alter table atividadesservicocontrato add column contabilizar char(1);
alter table atividadesservicocontrato alter column contabilizar set default null;

alter table atividadesservicocontrato add column idservicocontratocontabil bigint;
alter table atividadesservicocontrato alter column idservicocontratocontabil set default null;

create  table vinculaosincidente (
   idos int not null,
   idsolicitacaoservico bigint not null,
   idatividadesos bigint not null 
);

alter table vinculaosincidente add primary key (idos, idsolicitacaoservico);

-- fim rodrigo.oliveira

-- INICIO - MODULO DE PROBLEMA
alter table problema alter column datahoralimite drop not null;
alter table problema alter column datahoralimite set default null;

alter table problema alter column datahorasolicitacao drop not null;
alter table problema alter column datahorasolicitacao set default null;
   
-- FIM - MODULO DE PROBLEMA

-- Postgres - Flvio Jnior - 15/04

DROP TRIGGER add_current_date_to_slarequisitosla ON slarequisitosla;
DROP FUNCTION update_slarequisitosla();

CREATE LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION update_slarequisitosla() RETURNS TRIGGER 
LANGUAGE plpgsql AS
$$
BEGIN
    NEW.dataultmodificacao := CURRENT_TIMESTAMP; 
    RETURN NEW; 
END; 
$$;

CREATE TRIGGER add_current_date_to_slarequisitosla BEFORE INSERT OR UPDATE ON slarequisitosla
FOR EACH ROW EXECUTE PROCEDURE update_slarequisitosla();

ALTER TABLE slarequisitosla
   ALTER COLUMN dataultmodificacao SET DEFAULT now();
   
-- SCRIPTS GERADOS APARTIR DO DIA 26/04, NO SERO USADOS AT QUE O VALDOLO LIBERE.

alter table categoriagaleriaimagem add column datafim date;

alter table categoriagaleriaimagem add column datainicio date;
   
-- inicio murilo.rodrigues - 29-04-2013
ALTER TABLE processamentobatch ALTER COLUMN descricao TYPE character varying(256);
-- fim murilo.rodrigues

-- SCRIPTS GERADOS A PARTIR DO DIA 30/04
alter table baseconhecimento add column erroconhecido char(1) null;

-- INICIO CLEDSON.JUNIOR 30-04-2013
ALTER TABLE valorservicocontrato ALTER COLUMN valorservico TYPE numeric(18,2);
-- FIM

-- deploy_compras_carlos_16 SCRIPT GERADO NO DIA 02/05
alter table projetos add column idprojetopai int null, 
add constraint fk_idprojetopai                                                   
  foreign key (idprojetopai )                                                      
  references projetos (idprojeto );
  
alter table cotacao alter column datahoracadastro drop not null;
alter table cotacao alter column datahoracadastro type timestamp ;

alter table limitealcada 
rename column limitevaloritem to limiteitemusointerno  ;

alter table limitealcada 
rename column limitevalormensal to limitemensalusointerno  ;

alter table limitealcada 
add column limiteitematendcliente numeric(8,2) DEFAULT NULL, 
add column limitemensalatendcliente numeric(8,2) DEFAULT NULL;
