insert into scripts (idscript, nome, descricao, sqlquery, tipo, datainicio) 
values (1, 'Consulta erros de rotina de scripts', 'Consulta os erros que ocorreram durante a execuo automatica de scripts feita durante a inicializao do sistema', 'select scripts.descricao, scripts.sqlquery, versao.nomeversao from scripts inner join versao on scripts.idversao = versao.idversao where scripts.idversao is not null and scripts.descricao like ''ERRO%'';', 'consulta', '2013-04-04');

insert into scripts (idscript, nome, descricao, sqlquery, tipo, datainicio)
values (3, 'Limpa erros de rotina de scripts', 'Limpa o registro de erros que ocorreram durante a execuo automatica de scripts feita durante a inicializao do sistema', 'update scripts set descricao = ''CORRIGIDO '' + convert(varchar,descricao) where idversao is not null and descricao like ''ERRO%'' and idscript > 0;', 'update', '2013-04-04');

insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('B', 'Baixa');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('I', 'Intermediria');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('M', 'Mediana');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('A', 'Alta');
insert into tipocomplexidade (complexidade, desctipocomplexidade) values ('E', 'Especialista');

--Inicio do Modulo de mudanca

alter table requisicaomudanca add  nomecategoriamudanca varchar(15);

alter table grupo add  comiteconsultivomudanca varchar(1) null;

create table tipomudanca (
    idtipomudanca integer not null,
    idtipofluxo integer null,
    idmodeloemailcriacao integer null,
    idmodeloemailfinalizacao integer null,
    idmodeloemailacoes integer null,
    idgrupoexecutor integer null,
    idcalendario integer null,
    nometipomudanca varchar(100) null,
    datainicio date null,
    datafim date null,
    primary key (idtipomudanca),
    CONSTRAINT idtipofluxo foreign key (idtipofluxo) references bpm_tipofluxo (idtipofluxo),
    constraint idmodeloemailcriacao foreign key (idmodeloemailcriacao) references modelosemails (idmodeloemail),
    constraint idmodeloemailfinalizacao foreign key (idmodeloemailfinalizacao) references modelosemails (idmodeloemail),
    constraint idmodeloemailacoes foreign key (idmodeloemailacoes) references modelosemails (idmodeloemail),
    constraint idgrupoexecutor foreign key (idgrupoexecutor) references grupo (idgrupo),
    constraint idcalendario foreign key (idcalendario) references calendario (idcalendario)
);

alter table requisicaomudanca drop  CONSTRAINT  fk_requisic_reference_cat;

exec sp_rename 'requisicaomudanca.idcategoriamudanca', 'idtipomudanca', 'COLUMN';

alter table requisicaomudanca alter column  idtipomudanca  integer null;


alter table requisicaomudanca add constraint fk_requisic_reference_tipomudanca 
foreign key (idtipomudanca) references tipomudanca (idtipomudanca);

alter table requisicaomudanca add  idcontrato integer not null;
alter table requisicaomudanca add  idunidade integer;
alter table requisicaomudanca add  idcontatorequisicaomudanca integer;

create table contatorequisicaomudanca (
    idcontatorequisicaomudanca integer not null primary key,
    nomecontato varchar(100),
    telefonecontato varchar(100),
    emailcontato varchar(200),
    observacao text,
    idlocalidade integer,
    ramal varchar(5)
) ;


alter table requisicaomudanca add  idgrupocomite integer null;

alter table requisicaomudanca add constraint fk_requisic_reference_grupo_comite foreign key (idgrupocomite) references grupo (idgrupo);

create table aprovacaomudanca (
    idaprovacaomudanca integer not null,
    idrequisicaomudanca integer null,
    idempregado integer null,
    nomeempregado varchar(45) null,
    voto char(1) null,
    comentario varchar(200) null,
    primary key (idaprovacaomudanca),
    constraint  fk_requisicaomudanca foreign key (idrequisicaomudanca) references requisicaomudanca (idrequisicaomudanca) ,
    constraint fk_empregado foreign key (idempregado) references empregados (idempregado) 
) ;

create index fk_requisicaomudanca_idx on aprovacaomudanca (idrequisicaomudanca);
create index fk_empregado_idx on aprovacaomudanca (idempregado);

alter table requisicaomudanca add  enviaemailgrupocomite varchar(1) null;

alter table ocorrenciamudanca add  idcategoriaocorrencia integer;
alter table ocorrenciamudanca add  idorigemocorrencia integer;

alter table requisicaomudanca add  datahorainicioagendada datetime null default '0000-00-00 00:00:00';
alter table requisicaomudanca add  datahoraterminoagendada  datetime null default '0000-00-00 00:00:00';

alter table requisicaomudanca add  idlocalidade integer;

alter table aprovacaomudanca add  datahorainicio datetime null;

create table justificativamudanca (
    idjustificativamudanca integer not null,
    descricaojustificativa varchar(100) not null,
    suspensao char(1) not null,
    situacao char(1) not null,
    aprovacao char(1) default null,
    deleted char(1) default null,
    primary key (idjustificativamudanca)
) ;

create table anexomudanca (
    idanexomudanca integer not null primary key,
    idmudanca integer,
    datainicio date,
    datafim date,
    nome varchar(256),
    link varchar(256),
    extensao varchar(10),
    descricao varchar(256)
) ;


alter table requisicaomudanca alter  column  datahoraconclusao datetime not null;

alter table requisicaomudanca add  fechamento text null;

-- SCRIPT ADICIONAL PARA RESOLVER O PROBLEMA DE ADICAO DA DATA ATUAL NOS CAMPOS DA TABELA.
alter table requisicaomudanca alter column  datahoraconclusao datetime null;
alter table requisicaomudanca alter column  datahorainicio datetime null;
alter table requisicaomudanca alter column  datahoratermino datetime null;
alter table requisicaomudanca alter column  datahoracaptura datetime null;
alter table requisicaomudanca alter column  datahorareativacao datetime null;
alter table requisicaomudanca alter column  datahorasuspensao datetime null;
alter table requisicaomudanca alter column  datahorainicioagendada datetime null;
alter table requisicaomudanca alter column  datahoraterminoagendada datetime null;

--autor rodrigo.oliveira
alter table atividadesos add  contabilizar char(1) null ;
alter table atividadesos add  idservicocontratocontabil bigint null ;

alter table atividadesservicocontrato add  contabilizar char(1) null ;
alter table atividadesservicocontrato add  idservicocontratocontabil bigint null;

create  table vinculaosincidente (
   idos integer not null,
   idsolicitacaoservico bigint not null,
   idatividadesos bigint not null,
   primary key (idos, idsolicitacaoservico) 
) ;

-- INICIO - MODULO DE PROBLEMA
alter table problema alter column datahoralimite datetime null ;
alter table problema alter column datahorasolicitacao  datetime null;
--Fim modulo de problema
 
-- Trigger DDL Statements

CREATE TRIGGER add_current_date_to_slarequisitosla_insert ON  slarequisitosla
FOR UPDATE
AS
BEGIN
       SET NOCOUNT ON; 
       UPDATE tbl
       SET dataultmodificacao = GETDATE()
       FROM slarequisitosla AS tbl
       INNER JOIN inserted AS i
             ON tbl.idrequisitosla = i.idrequisitosla; 
END;

CREATE TRIGGER add_current_date_to_slarequisitosla_update ON  slarequisitosla
FOR INSERT
AS
BEGIN
       SET NOCOUNT ON; 
       UPDATE tbl
       SET dataultmodificacao = GETDATE()
       FROM slarequisitosla AS tbl
       INNER JOIN inserted AS i
             ON tbl.idrequisitosla = i.idrequisitosla; 
END;

-- SCRIPTS GERADOS APARTIR DO DIA 26/04, NO SERO USADOS ATE QUE O VALDOILO LIBERE.

alter table categoriagaleriaimagem add  datafim date;

alter table categoriagaleriaimagem add  datainicio date;

-- SCRIPTS GERADOS A PARTIR DO DIA 30/04
alter table baseconhecimento add  erroconhecido char(1) null;

-- INICIO CLEDSON.JUNIOR SCRIPT GERADO NO DIA 02/05
alter table valorservicocontrato alter column valorservico decimal(18,2);
-- FIM

-- deploy_compras_carlos_16 SCRIPT GERADO NO DIA 02/05
alter table projetos add  idprojetopai integer null;
alter table projetos add constraint fk_idprojetopai  foreign key (idprojetopai ) references projetos (idprojeto );
create index fk_idprojetopai_idx on   projetos  (idprojetopai );


exec sp_rename 'limitealcada.limitevaloritem', 'limiteitemusointerno', 'COLUMN';



alter table limitealcada alter column  limiteitemusointerno decimal(11,2) null ;
alter table limitealcada alter column limitevalormensal  decimal(11,2) null   ;
alter table limitealcada add  limiteitematendcliente decimal(11,2) null  ;
alter table limitealcada add  limitemensalatendcliente decimal(11,2) null   ;

-- deploy_compras_carlos_17 SCRIPT GERADO NO DIA 02/05 -- INICIO

alter table itemrequisicaoproduto alter column situacao  varchar(30) null  ;

create table historicoitemrequisicao (
  idhistorico integer not null,
  iditemrequisicao integer not null,
  idresponsavel integer not null,
  datahora timestamp null default null,
  situacao varchar(30) not null,
  complemento text,
  primary key (idhistorico),
  constraint historicoitemrequisicao_ibfk_1 foreign key (iditemrequisicao) references itemrequisicaoproduto (iditemrequisicaoproduto),
  constraint historicoitemrequisicao_ibfk_2 foreign key (idresponsavel) references empregados (idempregado)
) ;

create index iditemrequisicao on historicoitemrequisicao (iditemrequisicao);
create index idresponsavel on historicoitemrequisicao (idresponsavel);


-- FIM

-- INICIO - MURILO GABRIEL - 03-05-2013
alter table solicitacaoservico alter column datahorafim datetime null;
-- FIM

