-- Oracle

set define off;

-- Incio Carlos Santos 16/05/13 autorizado 28/06/13

alter table templatesolicitacaoservico  drop constraint fk_questionario;

alter table solicitacaoservicoquestionario  drop constraint  fk_solquest_questionario;

drop table respostaitemquestionarioanexos;
drop table respostaitemquestionarioopcoes;
drop table opcaorespostaquestionario;
drop table respostaitemquestionario;
drop table questaoquestionario;
drop table grupoquestionario;
drop table questionario;

create table questionario (
   idquestionario     integer not null,
   idquestionarioorigem integer,
   idcategoriaquestionario integer not  null,
   nomequestionario   varchar2(50) not null,
   idempresa          integer not null,
   ativo              char(1) default 'S' not null,
   javascript         clob
);

alter table questionario add constraint pk_questionario primary key (idquestionario);

alter table questionario add constraint fk_question_reference_categori foreign key (idcategoriaquestionario) references categoriaquestionario (idcategoriaquestionario);

alter table questionario add constraint fk_questionarioorigem foreign key (idquestionarioorigem) references questionario (idquestionario);

create table grupoquestionario (
   idgrupoquestionario integer not null,
   idquestionario integer not null,
   nomegrupoquestionario varchar2(80) not null,
   ordem smallint
);

alter table grupoquestionario add constraint pk_grupoquestionario primary key (idgrupoquestionario);

alter table grupoquestionario add constraint fk_grupoque_reference_question foreign key (idquestionario) references questionario (idquestionario);

create table questaoquestionario (
   idquestaoquestionario integer not null,
   idgrupoquestionario integer,
   idquestaoagrupadora integer,
   idquestaoorigem    integer,
   tipo               char(1) not null,
   tituloquestaoquestionario clob not null,
   tipoquestao        char(1) not null,
   sequenciaquestao   integer not null,
   valordefault       clob,
   textoinicial       clob,
   tamanho            integer,
   decimais           integer,
   inforesposta       char(1)                        
      constraint ckc_inforesposta_questaoq check (inforesposta is null or (inforesposta in ('L','B'))),
   valoresreferencia  clob,
   unidade            clob,
   obrigatoria        char(1) not null
      constraint ckc_obrigatoria_questaoq check (obrigatoria in ('S','N')),
   ponderada          char(1),
   qtdelinhas         integer,
   qtdecolunas        integer,
   cabecalholinhas    char(1),
   cabecalhocolunas   char(1),
   nomelistagem       varchar2(30),
   ultimovalor        char(1),
   idsubquestionario  integer,
   abaresultsubform   varchar2(200),
   sigla              varchar2(100),
   imprime            char(1),
   calculada          char(1),
   editavel           char(1),
   valorpermitido1    number(15,5),
   valorpermitido2    number(15,5),
   idimagem           integer
);

alter table questaoquestionario add constraint pk_questaoquestionario primary key (idquestaoquestionario);

alter table questaoquestionario add constraint fk_questaoagrupadora foreign key (idquestaoagrupadora) references questaoquestionario (idquestaoquestionario);

alter table questaoquestionario add constraint fk_questaoq_reference_question foreign key (idsubquestionario) references questionario (idquestionario);

alter table questaoquestionario add constraint fk_questaoq_reference_grupoque foreign key (idgrupoquestionario) references grupoquestionario (idgrupoquestionario);

create table respostaitemquestionario (
   idrespostaitemquestionario integer not null,
   ididentificadorresposta integer not null,
   idquestaoquestionario integer not null,
   sequencialresposta integer,
   respostatextual    clob,
   respostapercentual number(15,5),
   respostavalor      number(15,5),
   respostavalor2     number(15,5),
   respostanumero     number(8,0),
   respostanumero2    number(8,0),
   respostadata       date,
   respostahora       varchar2(4),
   respostames        smallint,
   respostaano        smallint,
   respostaidlistagem varchar2(10),
   respostadia        smallint
);

alter table respostaitemquestionario add constraint pk_respostaitemquestionario primary key (idrespostaitemquestionario);

alter table respostaitemquestionario add constraint fk_resposta_reference_questaoq foreign key (idquestaoquestionario) references questaoquestionario (idquestaoquestionario);

create index ix_ident_questao on respostaitemquestionario (
   ididentificadorresposta asc,
   idquestaoquestionario asc
);

create index  ix_idquestao on  respostaitemquestionario (
   idquestaoquestionario asc
);

create table opcaorespostaquestionario (
   idopcaorespostaquestionario integer not null,
   idquestaoquestionario integer not null,
   titulo             varchar2(255) not null,
   peso               integer,
   valor              varchar2(50),
   geraalerta         char(1),
   exibecomplemento   char(1),
   idquestaocomplemento integer
);

alter table opcaorespostaquestionario add constraint pk_opcaorespostaquestionario primary key (idopcaorespostaquestionario);

alter table opcaorespostaquestionario add constraint fk_opcaores_reference_questaoq foreign key (idquestaocomplemento) references questaoquestionario (idquestaoquestionario);

alter table opcaorespostaquestionario add constraint fk_opcaores_ref_questaoq foreign key (idquestaoquestionario) references questaoquestionario (idquestaoquestionario) on delete cascade;

create index ix_sigla_questao on questaoquestionario (
   sigla asc
);

create index ix_idquestaoorigem on questaoquestionario (
   idquestaoorigem asc
);

create table respostaitemquestionarioopcoes (
   idrespostaitemquestionario integer not null,
   idopcaorespostaquestionario integer not null
);

alter table respostaitemquestionarioopcoes add constraint pk_respostaitemquestionarioopc primary key (idrespostaitemquestionario, idopcaorespostaquestionario);

alter table respostaitemquestionarioopcoes add constraint fk_rspta_q_reference_rspta_itm foreign key (idrespostaitemquestionario) references respostaitemquestionario (idrespostaitemquestionario) on delete cascade;

alter table respostaitemquestionarioopcoes add constraint fk_resposta_reference_opcaores foreign key (idopcaorespostaquestionario) references opcaorespostaquestionario (idopcaorespostaquestionario);

create table respostaitemquestionarioanexos (
   idrespostaitmquestionarioanexo integer not null,
   idrespostaitemquestionario integer not null,
   caminhoanexo varchar2(255) not null,
   observacao clob
);

alter table respostaitemquestionarioanexos add constraint pk_respostaitemquestionarioane primary key (idrespostaitmquestionarioanexo);

alter table respostaitemquestionarioanexos add constraint fk_rspt_anx_reference_rspt_itm foreign key (idrespostaitemquestionario) references respostaitemquestionario (idrespostaitemquestionario) on delete cascade;

create table requisicaoquestionario (
	idrequisicaoquestionario NUMBER(10,0),
	idquestionario NUMBER(10,0), 
	idtiporequisicao NUMBER(10,0),
	idtipoaba NUMBER(10,0),
	idrequisicao NUMBER(10,0),
	dataquestionario DATE,
	idresponsavel NUMBER(10,0),
	idtarefa NUMBER(38,0),
	aba varchar(100),
	situacao varchar(1), 
	datahoragrav DATE,
	conteudoimpresso clob, 
	confirmacao varchar(1), 
	CONSTRAINT req_pkey PRIMARY KEY (idrequisicaoquestionario),
	CONSTRAINT req_idquestionario_fkey FOREIGN KEY (idquestionario) REFERENCES questionario (idquestionario),
	CONSTRAINT req_idtarefa_fkey FOREIGN KEY (idtarefa) REFERENCES bpm_itemtrabalhofluxo (iditemtrabalho)
);

INSERT INTO templatesolicitacaoservico (idtemplate, identificacao,nometemplate,nomeclassedto,nomeclasseaction,nomeclasseservico,urlrecuperacao,scriptaposrecuperacao,habilitadirecionamento,habilitasituacao,habilitasolucao,alturadiv,habilitaurgenciaimpacto,habilitanotificacaoemail,habilitaproblema,habilitamudanca,habilitaitemconfiguracao,habilitasolicitacaorelacionada,habilitagravarecontinuar) VALUES (13,'ChecklistQuestionario','Checklist Questionario',' ','br.com.centralit.citcorpore.ajaxForms.ChecklistQuestionario','br.com.centralit.citcorpore.negocio.ChecklistQuestionarioServiceEjb','/pages/checklistQuestionario/checklistQuestionario.load', '','N','S','N',820,'N','N','N','N','N','N','S');

INSERT INTO categoriaquestionario (idcategoriaquestionario,nomecategoriaquestionario, idempresa) VALUES (1,'CONTRATOS',1);

-- Fim Carlos Santos

-- Incio Maycon

create table requisicaoliberacaomidia (
  idRequisicaoLiberacaoMidia int not null,
  idMidiaSoftware int not null,
  idRequisicaoLiberacao int not null
);

alter table requisicaoliberacaomidia add constraint pk_requisicaoliberacaomidia primary key (idRequisicaoLiberacaoMidia);

-- Riubbe Oliveira -- 14/06/2013 - inicio
alter table itemconfiguracao add(idliberacao number(10,0) null);
alter table itemconfiguracao add constraint fk_itemconfiguracao_liberacao foreign key(idliberacao) references liberacao(idliberacao);

INSERT INTO grupoitemconfiguracao (idgrupoitemconfiguracao, nomegrupoitemconfiguracao, datainicio, datafim, email, emailgrupoitemconfiguracao, idGrupoItemConfiguracaoPai) VALUES (1001,'Desenvolvimento - Padro','12-06-2013',NULL,NULL,NULL,997);
INSERT INTO grupoitemconfiguracao (idgrupoitemconfiguracao, nomegrupoitemconfiguracao, datainicio, datafim, email, emailgrupoitemconfiguracao, idGrupoItemConfiguracaoPai) VALUES (1002,'Homologao - Padro','12-06-2013',NULL,NULL,NULL,999);
INSERT INTO grupoitemconfiguracao (idgrupoitemconfiguracao, nomegrupoitemconfiguracao, datainicio, datafim, email, emailgrupoitemconfiguracao, idGrupoItemConfiguracaoPai) VALUES (1003,'Produo - Padro','12-06-2013',NULL,NULL,NULL,998);

-- Riubbe Oliveira -- 14/06/2013 - fim

-- inicio requisicaoliberacaoresponsavel - Thiago Matias
CREATE TABLE REQUISICAOLIBERACAORESPONSAVEL(
	IDREQUISICAOLIBERACAORESP NUMBER(10,0),
	IDRESPONSAVEL NUMBER(10,0),
	IDREQUISICAOLIBERACAO NUMBER(10,0),
	PAPELRESPONSAVEL VARCHAR2(200 CHAR)
);

-- fim requisicaoliberacaoresponsavel - Thiago Matias
alter table historicoic add origemmodificacao varchar2(20) null;
alter table historicoic add idmodificacao number(10,0) null;
-- Fim Thiago

-- Mdulo de Liberao
-- Geber Costa 21/06/2013
create table situacaoliberacaomudanca (
	idsituacaoliberacaomudanca number(10,0) not null, 
	situacao varchar(45)
);

alter table situacaoliberacaomudanca add constraint pk_situacaoliberacaomudanca primary key (idsituacaoliberacaomudanca);

insert into situacaoliberacaomudanca values(1,'Em Execuo');
insert into situacaoliberacaomudanca values(2,'Resolvida');
insert into situacaoliberacaomudanca values(3,'No Resolvida');
insert into situacaoliberacaomudanca values(4,'Cancelada');

alter table liberacaomudanca add (status VARCHAR2(45));
alter table liberacaomudanca add (situacaoliberacao VARCHAR2(45));

-- Fim Geber

-- Incio Bruno Mudana 24/06/13
CREATE TABLE requisicaomudancaresponsavel(
       idRequisicaoMudancaResp NUMBER(10,0) NOT NULL,
       idResponsavel NUMBER(10,0),
       idRequisicaoMudanca NUMBER(10,0),
       papelResponsavel VARCHAR2(200 CHAR)
);

alter table requisicaomudancaresponsavel add constraint pk_requisicaomudancaresp primary key (idRequisicaoMudancaResp);
alter table requisicaomudancaresponsavel add constraint fk_requisicaomudancaresp_resp foreign key (idResponsavel) references empregados (idempregado);

-- Fim Bruno

-- Incio Thiago Fernandes 24/06/13
ALTER TABLE ocorrenciamudanca drop CONSTRAINT fk_ocorrenc_reference_justific;
ALTER TABLE ocorrenciamudanca ADD CONSTRAINT fk_ocorrenc_reference_justific FOREIGN KEY (idjustificativa) REFERENCES justificativamudanca (idjustificativamudanca);

-- Fim Thiago Fernandes

-- Incio Thiago Matias 26/06/13

CREATE TABLE REQUISICAOLIBERACAOCOMPRAS(
	IDREQUISICAOLIBERACAOCOMPRAS NUMBER (10,0),	  
	IDSOLICITACAOSERVICO NUMBER (10,0),
	IDREQUISICAOLIBERACAO NUMBER (10,0)
);

-- Fim Thiago Matias

-- Incio Maycon 26/06/13

create table requisicaoliberacaomidia (
  idRequisicaoLiberacaoMidia number(10,0) not null,
  idMidiaSoftware number(10,0) not null,
  idRequisicaoLiberacao number(10,0) not null,
  constraint pk_requisicaoliberacaomidia primary key (idRequisicaoLiberacaoMidia),
  constraint fk_requesteM_midia FOREIGN KEY (idmidiasoftware) REFERENCES midiasoftware (idmidiasoftware),
  constraint  fk_requesteM_liberacao FOREIGN KEY (idrequisicaoliberacao) REFERENCES liberacao (idliberacao)
);

-- Fim Maycon

-- Incio Murilo Pacheco 02/07/13

create table ligacao_historico_ged (
    idligacao_historico_ged NUMBER(10,0) not null,
    idcontroleged NUMBER(10,0),
    idrequisicaoliberacao NUMBER(10,0),
    idhistoricoliberacao NUMBER(10,0),
    idtabela NUMBER(10,0),
    datafim DATE DEFAULT NULL,
    primary key (idligacao_historico_ged)
);

create table ligacao_lib_hist_midia (
    idligacao_lib_hist_midia  NUMBER(10,0) not null,
    idrequisicaoliberacaomidia NUMBER(10,0),
    idrequisicaoliberacao    NUMBER(10,0),
    idhistoricoliberacao      NUMBER(10,0),
    primary key (idligacao_lib_hist_midia)
);

ALTER TABLE requisicaoliberacaomidia ADD (DATAFIM DATE DEFAULT NULL);

create table ligacao_lib_hist_resp (
    idligacao_lib_hist_resp  NUMBER(10,0) not null,
    idrequisicaoliberacaoresp NUMBER(10,0),
    idrequisicaoliberacao    NUMBER(10,0),
    idhistoricoliberacao      NUMBER(10,0),
    primary key (idligacao_lib_hist_resp)
);

ALTER TABLE requisicaoliberacaoresponsavel ADD (datafim DATE DEFAULT NULL);

create table ligacaolibhistcompras (
    idligacaolibhistcompras  NUMBER(10,0) not null,
    idRequisicaoLiberacaoCompras NUMBER(10,0),
    idrequisicaoliberacao NUMBER(10,0),
    idhistoricoliberacao NUMBER(10,0),
    primary key (idligacaolibhistcompras)
);

ALTER TABLE requisicaoliberacaocompras ADD(datafim DATE DEFAULT NULL);

-- Fim Murilo Pacheco

-- Incio Danillo Sardinha 04/07/13

drop index primary_161;

-- Fim Danillo Sardinha

-- CLEDSON JUNIOR - 11/06/2013
alter table origematendimento add (datainicio date);

alter table origematendimento add (datafim date);

-- FIM

-- Cleison Ferreira - 13/06/2013
CREATE UNIQUE INDEX "INDEX_EMP_NOMEPROC" ON "EMPREGADOS" ("NOMEPROCURA");
-- Fim

-- Carlos Santos - 09/06/2013
ALTER TABLE cargos ADD iddescricaocargo INTEGER;
-- Fim

-- Incio rodrigo.oliveira - 14/06/2013

create table prioridadeservicousuario (
  idusuario number(10,0) not null,
  idacordonivelservico number(19,0) not null,
  idprioridade number(19,0) default null,
  idservicocontrato number(19,0) default null,
  datainicio date not null,
  datafim date default null
);

alter table prioridadeservicousuario add constraint pk_prioridadeservicousuario primary key (idusuario, idacordonivelservico);

-- Fim rodrigo.oliveira
