-- SQLServer

-- Incio Carlos Santos 16/05/13 autorizado 28/06/13

ALTER TABLE solicitacaoservicoquestionario DROP CONSTRAINT pk_solicitacaoservquest;

ALTER TABLE solicitacaoservicoquestionario DROP CONSTRAINT fk_solquest_questionario;

DROP TABLE respostaitemquestionarioanexos;
DROP TABLE respostaitemquestionarioopcoes;
DROP TABLE opcaorespostaquestionario;
DROP TABLE respostaitemquestionario;
DROP TABLE questaoquestionario;
DROP TABLE grupoquestionario;
DROP TABLE questionario;

create table questionario (
   idquestionario			integer		not null,
   idquestionarioorigem		integer		null,
   idcategoriaquestionario	integer		not null,
   nomequestionario			varchar(50) not null,
   idempresa				integer     not null,
   ativo					char(1)     not null default 'S',
   javascript				text        null
);

alter table questionario  add constraint pk_questionario primary key (idquestionario);

create table respostaitemquestionarioopcoes (
	idrespostaitemquestionario integer  not null,
	idopcaorespostaquestionario integer not null
);

alter table respostaitemquestionarioopcoes add constraint pk_respostaitemquestionarioopc primary key (idrespostaitemquestionario, idopcaorespostaquestionario);

create table grupoquestionario (
   idgrupoquestionario  integer not null,
   idquestionario       integer not null,
   nomegrupoquestionario varchar(80) not null,
   ordem                integer null
);

alter table grupoquestionario  add constraint pk_grupoquestionario primary key (idgrupoquestionario);

create table questaoquestionario (
   idquestaoquestionario 		integer not null,
   idgrupoquestionario  		integer null,
   idquestaoagrupadora  		integer null,
   idquestaoorigem      		integer null,
   tipo                 		char(1) not null,
   tituloquestaoquestionario 	text    not null,
   tipoquestao          		char(1) not null,
   sequenciaquestao     		integer not null,
   valordefault         		text    null,
   textoinicial         		text    null,
   tamanho             			integer null,
   decimais             		integer null,
   inforesposta         		char(1) null  constraint ckc_inforesposta_questaoq check (inforesposta is null or (inforesposta in ('L','B'))),
   valoresreferencia    		text    null,
   unidade              		text    null,
   obrigatoria         		char(1) not null constraint ckc_obrigatoria_questaoq check (obrigatoria in ('S','N', '')),
   ponderada            		char(1) null,
   qtdelinhas           		integer null,
   qtdecolunas          		integer null,
   cabecalholinhas      		char(1) null,
   cabecalhocolunas     		char(1) null,
   nomelistagem         		varchar(30) null,
   ultimovalor          		char(1) null,
   idsubquestionario    		integer  null,
   abaresultsubform     		varchar(200) null,
   sigla                		varchar(100) null,
   imprime              		char(1) null,
   calculada            		char(1) null,
   editavel             		char(1) null,
   valorpermitido1      		numeric(15,5) null,
   valorpermitido2      		numeric(15,5) null,
   idimagem             		integer       null
);

alter table questaoquestionario   add constraint pk_questaoquestionario primary key (idquestaoquestionario);

create  index ix_sigla_questao  on questaoquestionario (sigla);
create  index ix_idquestaoorigem on questaoquestionario (idquestaoorigem);

create table respostaitemquestionario (
   idrespostaitemquestionario	integer not null,
   ididentificadorresposta		integer not null,
   idquestaoquestionario		integer not null,
   sequencialresposta			integer null,
   respostatextual				text null,
   respostapercentual			numeric(15,5) null,
   respostavalor				numeric(15,5) null,
   respostavalor2				numeric(15,5) null,
   respostanumero				numeric(8,0)  null,
   respostanumero2				numeric(8,0)  null,
   respostadata					date          null,
   respostahora					varchar(4)    null,
   respostames					integer       null,
   respostaano					integer       null,
   respostaidlistagem			varchar(10)   null,
   respostadia					integer       null
);

alter table respostaitemquestionario add constraint pk_respostaitemquestionario primary key (idrespostaitemquestionario);

create  index ix_ident_questao on respostaitemquestionario (ididentificadorresposta, idquestaoquestionario);
create  index ix_idquestao on respostaitemquestionario (idquestaoquestionario);

create table opcaorespostaquestionario (
   idopcaorespostaquestionario integer not null,
   idquestaoquestionario integer not null,
   titulo                varchar(255) not null,
   peso                  integer      null,
   valor                 varchar(50)  null,
   geraalerta            char(1)      null,
   exibecomplemento      char(1)      null,
   idquestaocomplemento  integer      null
);

alter table opcaorespostaquestionario add constraint pk_opcaorespostaquestionario primary key (idopcaorespostaquestionario);

create table respostaitemquestionarioanexos (
   idrespostaitmquestionarioanexo	integer      not null,
   idrespostaitemquestionario		integer      not null,
   caminhoanexo				varchar(255) not null,
   observacao					text         null
);

alter table respostaitemquestionarioanexos  add constraint pk_respostaitemquestionarioane primary key (idrespostaitmquestionarioanexo);

alter table grupoquestionario add constraint fk_grupoque_reference_question foreign key (idquestionario)  references questionario (idquestionario)    on delete no action on update no action;
alter table opcaorespostaquestionario add constraint fk_opcaores_reference_questaoq foreign key (idquestaocomplemento)   references questaoquestionario (idquestaoquestionario) on delete no action on update no action;
alter table opcaorespostaquestionario add constraint fk_opcaores_ref_questaoq foreign key (idquestaoquestionario)    references questaoquestionario (idquestaoquestionario)   on delete cascade on update no action;
alter table questaoquestionario add constraint fk_questaoagrupadora foreign key (idquestaoagrupadora) references questaoquestionario (idquestaoquestionario)  on delete no action on update no action;
alter table questaoquestionario add constraint fk_questaoq_reference_question foreign key (idsubquestionario)  references questionario (idquestionario) on delete no action on update no action;
alter table questaoquestionario add constraint fk_questaoq_reference_grupoque foreign key (idgrupoquestionario)  references grupoquestionario (idgrupoquestionario)  on delete no action on update no action;
alter table questionario add constraint fk_question_reference_categori foreign key (idcategoriaquestionario)  references categoriaquestionario (idcategoriaquestionario) on delete no action on update no action;
alter table questionario add constraint fk_questionarioorigem foreign key (idquestionarioorigem) references questionario (idquestionario) on delete no action on update no action;
alter table respostaitemquestionario add constraint fk_resposta_reference_questaoq foreign key (idquestaoquestionario)   references questaoquestionario (idquestaoquestionario)  on delete no action on update no action;
alter table respostaitemquestionarioanexos add constraint fk_rspt_anx_reference_rspt_itm foreign key (idrespostaitemquestionario)  references respostaitemquestionario (idrespostaitemquestionario)  on delete cascade on update no action;
alter table respostaitemquestionarioopcoes add constraint fk_rspta_q_reference_rspta_itm foreign key (idrespostaitemquestionario)   references respostaitemquestionario (idrespostaitemquestionario)  on delete cascade on update no action;
alter table respostaitemquestionarioopcoes add constraint fk_resposta_reference_opcaores foreign key (idopcaorespostaquestionario)   references opcaorespostaquestionario (idopcaorespostaquestionario)  on delete no action on update no action;

ALTER TABLE solicitacaoservicoquestionario ADD CONSTRAINT pk_solicitacaoservquest PRIMARY KEY (idsolicitacaoquestionario);

ALTER TABLE solicitacaoservicoquestionario ADD CONSTRAINT fk_solquest_questionario FOREIGN KEY (idquestionario) REFERENCES questionario(idquestionario);

CREATE TABLE requisicaoquestionario (
  idrequisicaoquestionario integer not null,
  idquestionario integer not null,
  idtiporequisicao integer DEFAULT NULL,
  idtipoaba integer DEFAULT NULL,
  idrequisicao integer NOT NULL,
  dataquestionario datetime NOT NULL DEFAULT sysdatetime(),
  idresponsavel integer NOT NULL,
  idtarefa bigint DEFAULT NULL,
  aba varchar(100) DEFAULT NULL,
  situacao char(1) NOT NULL,
  datahoragrav datetime NOT NULL DEFAULT sysdatetime(),
  conteudoimpresso text,
  confirmacao varchar(1) DEFAULT NULL,
  PRIMARY KEY (idrequisicaoquestionario),
  CONSTRAINT fk_requesteq_empregado FOREIGN KEY (idresponsavel) REFERENCES empregados (idempregado),
  CONSTRAINT fk_requesteq_tarefa FOREIGN KEY (idtarefa) REFERENCES bpm_itemtrabalhofluxo (iditemtrabalho),
  CONSTRAINT fk_requesteq_questionario FOREIGN KEY (idquestionario) REFERENCES questionario (idquestionario)
);

INSERT INTO categoriaquestionario (idcategoriaquestionario,nomecategoriaquestionario) VALUES (1,'CONTRATOS');

INSERT INTO templatesolicitacaoservico (idtemplate, identificacao,nometemplate,nomeclassedto,nomeclasseaction,nomeclasseservico,urlrecuperacao,scriptaposrecuperacao,habilitadirecionamento,habilitasituacao,habilitasolucao,alturadiv,habilitaurgenciaimpacto,habilitanotificacaoemail,habilitaproblema,habilitamudanca,habilitaitemconfiguracao,habilitasolicitacaorelacionada,habilitagravarecontinuar) VALUES (13,'ChecklistQuestionario','Checklist Questionario','','br.com.centralit.citcorpore.ajaxForms.ChecklistQuestionario','br.com.centralit.citcorpore.negocio.ChecklistQuestionarioServiceEjb','/pages/checklistQuestionario/checklistQuestionario.load','','N','S','N',820,'N','N','N','N','N','N','S');

-- Fim Carlos Santos

-- Incio Maycon

create table requisicaoliberacaomidia (
  idRequisicaoLiberacaoMidia integer not null,
  idMidiaSoftware integer not null,
  idRequisicaoLiberacao integer not null
);

alter table requisicaoliberacaomidia add constraint pk_requisicaoliberacaomidia primary key (idRequisicaoLiberacaoMidia);

-- Fim Maycon

-- danillo.lisboa
-- altera os os campos datahorareativacao e datahorasuspensao para aceitar null.
alter table historicoliberacao alter column datahorareativacao datetime  null;
alter table historicoliberacao alter column datahorasuspensao datetime  null;

-- Riubbe Oliveira -- 14/06/2013 - inicio

alter table itemconfiguracao add idliberacao int null;
alter table itemconfiguracao add constraint fk_itemconfiguracao_liberacao foreign key(idliberacao) references liberacao(idliberacao);

INSERT INTO grupoitemconfiguracao (idgrupoitemconfiguracao, nomegrupoitemconfiguracao, datainicio, datafim, email, emailgrupoitemconfiguracao, idGrupoItemConfiguracaoPai) VALUES (1001,'Desenvolvimento - Padro','2013-06-12',NULL,NULL,NULL,997);
INSERT INTO grupoitemconfiguracao (idgrupoitemconfiguracao, nomegrupoitemconfiguracao, datainicio, datafim, email, emailgrupoitemconfiguracao, idGrupoItemConfiguracaoPai) VALUES (1002,'Homologao - Padro','2013-06-12',NULL,NULL,NULL,999);
INSERT INTO grupoitemconfiguracao (idgrupoitemconfiguracao, nomegrupoitemconfiguracao, datainicio, datafim, email, emailgrupoitemconfiguracao, idGrupoItemConfiguracaoPai) VALUES (1003,'Produo - Padro','2013-06-12',NULL,NULL,NULL,998);

-- Riubbe Oliveira -- 14/06/2013 - fim

-- inicio requisicaoliberacaoresponsavel - thiago matias
CREATE TABLE requisicaoliberacaoresponsavel(
	idRequisicaoLiberacaoResp integer NULL,
	idResponsavel integer NULL,
	idRequisicaoLiberacao integer NULL,
	papelResponsavel varchar(200) NULL
);
-- fim requisicaoliberacaoresponsavel - thiago matias

alter table historicoic add origemmodificacao varchar(20) null;
alter table historicoic add idmodificacao int null;

-- Fim

-- Mdulo de Liberao
-- Geber Costa 21/06/2013

CREATE TABLE situacaoliberacaomudanca (
	idsituacaoliberacaomudanca INTEGER NOT NULL PRIMARY KEY,
	situacao VARCHAR(45)
);

INSERT INTO situacaoliberacaomudanca VALUES
(1,'Em Execuo'),
(2,'Resolvida'),
(3,'No Resolvida'),
(4,'Cancelada');

ALTER TABLE liberacaomudanca add status VARCHAR(45);
ALTER TABLE liberacaomudanca add situacaoliberacao VARCHAR(45);
-- Fim

-- Incio Bruno Mudana 24/06/13
CREATE TABLE requisicaomudancaresponsavel(
	idRequisicaoMudancaResp int NOT NULL,
	idResponsavel int NULL,
	idRequisicaoMudanca int NULL,
	papelResponsavel varchar(200) NULL
);

alter table requisicaomudancaresponsavel add constraint pk_requisicaomudancaresponsavel primary key (idRequisicaoMudancaResp);
alter table requisicaomudancaresponsavel add constraint fk_requisicaomudancaresp_resp foreign key (idResponsavel) references empregados (idempregado);

-- Fim Bruno

-- Incio Thiago Fernandes 24/06/13
ALTER TABLE ocorrenciamudanca drop CONSTRAINT fk_ocorrenc_reference_justific;
ALTER TABLE ocorrenciamudanca ADD CONSTRAINT fk_ocorrenc_reference_justific FOREIGN KEY (idjustificativa) REFERENCES justificativamudanca (idjustificativamudanca);

-- Fim Thiago Fernandes

-- Incio Thiago Matias 26/06/13

CREATE TABLE requisicaoliberacaocompras (
  idRequisicaoLiberacaoCompras integer NULL,
  idSolicitacaoServico integer NULL,
  idRequisicaoLiberacao integer NULL
);

-- Fim Thiago Matias

-- Incio Maycon 26/06/13

create table requisicaoliberacaomidia (
  idRequisicaoLiberacaoMidia integer not null,
  idMidiaSoftware integer not null,
  idRequisicaoLiberacao integer not null,
  constraint pk_requisicaoliberacaomidia primary key (idRequisicaoLiberacaoMidia),
  constraint fk_requesteM_midia FOREIGN KEY (idMidiaSoftware) REFERENCES midiasoftware (idMidiaSoftware),
  constraint  fk_requesteM_liberacao FOREIGN KEY (idRequisicaoLiberacao) REFERENCES liberacao (idliberacao)
);

-- Fim Maycon

-- Incio Murilo Pacheco 02/07/13

create table ligacao_lib_hist_midia (
    idligacao_lib_hist_midia integer not null,
    idrequisicaoliberacaomidia integer,
    idrequisicaoliberacao integer,
    idhistoricoliberacao integer
);

alter table ligacao_lib_hist_midia add constraint pk_ligacao_lib_hist_midia primary key (idligacao_lib_hist_midia);

alter table requisicaoliberacaomidia add datafim date default null;

create table ligacao_lib_hist_resp (
    idligacao_lib_hist_resp integer not null,
    idrequisicaoliberacaoresp integer,
    idrequisicaoliberacao integer,
    idhistoricoliberacao integer
);

alter table ligacao_lib_hist_resp add constraint pk_ligacao_lib_hist_resp primary key (idligacao_lib_hist_resp);

alter table requisicaoliberacaoresponsavel add datafim date default null;

create table ligacaolibhistcompras (
    idligacaolibhistcompras  integer not null,
    idRequisicaoLiberacaoCompras integer,
    idrequisicaoliberacao integer,
    idhistoricoliberacao integer
);

alter table ligacaolibhistcompras add constraint pk_ligacaolibhistcompras primary key (idligacaolibhistcompras);

alter table requisicaoliberacaocompras add datafim date default null;

create table ligacao_historico_ged (
    idligacao_historico_ged integer not null,
    idcontroleged integer,
    idrequisicaoliberacao integer,
    idhistoricoliberacao integer,
    idtabela integer,
    datafim date default null
);

alter table ligacao_historico_ged add constraint pk_ligacao_historico_ged primary key (idligacao_historico_ged);

-- Fim Murilo Pacheco

-- Incio Pedro Lino 03/07/13

-- danillo.lisboa
-- deleta a CONSTRAINT da tabela liberacaoproblema
ALTER TABLE liberacaoproblema DROP CONSTRAINT [DF__liberacao__idhis__5125ECB4];

-- deleta a CONSTRAINT da tabela liberacaoproblema
DECLARE @SQL VARCHAR(4000)
SET @SQL = 'alter table liberacaoproblema DROP CONSTRAINT |ConstraintName| '
SET @SQL = REPLACE(@SQL, '|ConstraintName|', ( select name from sysobjects where parent_obj = OBJECT_ID('liberacaoproblema')))
EXEC (@SQL);

-- Fim Pedro Lino

-- Incio Maycon 04/07/13

alter table ocorrencialiberacao drop CONSTRAINT ocorrencialiberacao_idjustificativa_fkey;

alter table ocorrencialiberacao add CONSTRAINT ocorrencialiberacao_idjustificativa_fkey FOREIGN KEY (idjustificativa) REFERENCES justificativaliberacao (idjustificativaliberacao);

-- Fim Maycon

-- CLEDSON JUNIOR - 11/06/2013
alter table origematendimento add datainicio datetime;
alter table origematendimento add datafim datetime;

-- FIM

-- Carlos Santos - 09/06/2013
ALTER TABLE cargos ADD iddescricaocargo INT;
-- Fim

-- Cleison Ferreira - 13/06/2013
CREATE NONCLUSTERED INDEX [INDEX_EMP_NOMEPROC] ON [empregados] 
(
  [nomeprocura] ASC
)ON [PRIMARY];
-- Fim

-- Incio rodrigo.oliveira - 14/06/2013

create table prioridadeservicousuario (
  idusuario integer not null,
  idacordonivelservico bigint not null,
  idprioridade bigint default null,
  idservicocontrato bigint default null,
  datainicio date not null,
  datafim date default null,
  PRIMARY KEY (idusuario, idacordonivelservico)
);

alter table prioridadeservicousuario add constraint pk_prioridadeservicousuario primary key (idusuario, idacordonivelservico);

-- Fim rodrigo.oliveira

