-- Incio Mrio 05/09/2013

CREATE TABLE gruporequisicaomudanca (
  idgruporequisicaomudanca NUMBER(10,0) NOT NULL,
  idgrupo NUMBER(10,0) NOT NULL,
  idrequisicaomudanca NUMBER(10,0) NOT NULL,
  PRIMARY KEY (idgruporequisicaomudanca),
  foreign key (idgrupo) references grupo (idgrupo),
  foreign key (idrequisicaomudanca) references requisicaomudanca (idrequisicaomudanca)
);

ALTER TABLE gruporequisicaomudanca ADD (nomegrupo VARCHAR2(250) null);
ALTER TABLE gruporequisicaomudanca ADD (datafim date default null);

CREATE TABLE ligacao_mud_his_gru
(
  idligacao_mud_his_gru NUMBER(10,0) NOT NULL,
  idgruporequisicaomudanca NUMBER(10,0),
  idrequisicaomudanca NUMBER(10,0),
  idhistoricomudanca NUMBER(10,0),
  constraint pk_ligacao_mud_his_gru primary key (idligacao_mud_his_gru)
);

-- Fim Mrio

-- Incio Murilo Gabriel 07/09/2013

alter table historicoic add (idcontrato number(11,0) default null);
alter table historicoic add (idliberacao number(11,0) default null);
alter table historicoic add (idresponsavel number(11,0) default null);
alter table historicoic add (ativofixo varchar2(255) default null);

-- Fim Murilo Gabriel

-- Inicio Ronnie Mikihiro 10/09/2013

CREATE TABLE softwareslistanegra (
    idsoftwareslistanegra NUMBER NOT NULL,
    nomesoftwareslistanegra varchar(100) NOT NULL
);
ALTER TABLE softwareslistanegra ADD CONSTRAINT pk_softwareslistanegra PRIMARY KEY(idsoftwareslistanegra);
CREATE INDEX fk_idx_softwareslistanegra ON softwareslistanegra(idsoftwareslistanegra);

CREATE TABLE softwareslistanegraencontrados (
    idsoftwareslistanegraencontrad NUMBER NOT NULL,
    iditemconfiguracao NUMBER NOT NULL,
    idsoftwareslistanegra NUMBER NOT NULL,
    softwarelistanegraencontrado varchar(200) NOT NULL,
	data timestamp NOT NULL
);
ALTER TABLE softwareslistanegraencontrados ADD CONSTRAINT pk_softlistencont PRIMARY KEY(idsoftwareslistanegraencontrad);
ALTER TABLE softwareslistanegraencontrados ADD CONSTRAINT fk_softlistencont_itemconf FOREIGN KEY(iditemconfiguracao) REFERENCES itemconfiguracao(iditemconfiguracao);
ALTER TABLE softwareslistanegraencontrados ADD CONSTRAINT fk_softlistencont_softlist FOREIGN KEY (idsoftwareslistanegra) REFERENCES softwareslistanegra(idsoftwareslistanegra);
CREATE INDEX fk_idx_softlistnegrencontr ON softwareslistanegraencontrados(idsoftwareslistanegraencontrad);

-- Fim Ronnie Mikihiro 10/09/2013

-- Incio Bruno 10/09/2013

alter table solicitacaoservico add (vencendo varchar(1) default NULL);
alter table solicitacaoservico add (criouproblemaautomatico varchar(1) default NULL);

-- Fim Bruno

-- Incio Euler 10/09/2013

CREATE  TABLE regraescalonamento (
  idregraescalonamento NUMBER(10,0) NOT NULL ,
  idtipogerenciamento NUMBER(10,0) NOT NULL ,
  idservico NUMBER(10,0) NULL ,
  idcontrato NUMBER(10,0) NULL ,
  idsolicitante NUMBER(10,0) NULL ,
  idgrupo NUMBER(10,0) NULL ,
  idtipodemandaservico NUMBER(10,0) NULL ,
  urgencia VARCHAR(1) NULL ,
  impacto VARCHAR(1) NULL ,
  tempoexecucao NUMBER(10,0) NOT NULL ,
  intervalonotificacao NUMBER(10,0) NOT NULL ,
  enviaremail VARCHAR(1),
  criaproblema VARCHAR(1),
  prazocriarproblema NUMBER(10,0) NULL ,
  datainicio date null,
  datafim date null,
  PRIMARY KEY (idregraescalonamento) ,
  foreign key (idtipodemandaservico) references tipodemandaservico (idtipodemandaservico),
  foreign key (idservico) references servico (idservico),
  foreign key (idcontrato) references contratos (idcontrato),
  foreign key (idgrupo) references grupo (idgrupo)
);

CREATE  TABLE escalonamento (
  idescalonamento integer NOT NULL ,
  idregraescalonamento integer NOT NULL ,
  idgrupoexecutor integer NOT NULL ,
  prazoexecucao integer NOT NULL ,
  datainicio date null,
  datafim date null,
  PRIMARY KEY (idescalonamento) ,
  foreign key (idgrupoexecutor) references grupo (idgrupo),
  foreign key (idregraescalonamento) references regraescalonamento (idregraescalonamento)
);

alter table regraescalonamento add tipodataescalonamento number(11,0);
update regraescalonamento set tipodataescalonamento = 1 where tipodataescalonamento is null;
alter table regraescalonamento modify (tipodataescalonamento not null);
alter table escalonamento add idprioridade number(11,0);

-- Fim Euler

-- Incio Emauri 11/09/2013

ALTER TABLE netmap ADD (hardware VARCHAR(255));
ALTER TABLE netmap ADD (sistemaoper VARCHAR(255));
ALTER TABLE netmap ADD (uptime VARCHAR(20));

-- Fim Emauri 11/09/2013

-- Inicio Cleison 12/09/2013

ALTER TABLE itemrequisicaoproduto MODIFY (situacao VARCHAR2(50) DEFAULT NULL);

-- Fim Cleison

-- Inicio Mrio Haysaki Jnior 12/09/2013

ALTER TABLE projetos ADD (deleted varchar2(1) DEFAULT NULL);

-- Fim Mrio Haysaki Jnior

-- Inicio Bruno Franco 12/09/2013

CREATE TABLE relEscalonamentoSolServico
(
   idsolicitacaoservico integer, 
   idescalonamento integer, 
   CONSTRAINT pk_escalonamento_solicitacao PRIMARY KEY (idsolicitacaoservico, idescalonamento), 
   CONSTRAINT fk_solicitacaoservico FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico), 
   CONSTRAINT fk_escalonamento FOREIGN KEY (idescalonamento) REFERENCES escalonamento (idescalonamento)
);

-- Fim Bruno Franco

-- Inicio - Bruno Franco 13/09/2013

alter table requisicaomudanca add (vencendo varchar(1) default NULL);

insert into modelosemails (idmodeloemail, titulo, texto, situacao, identificador) values ($id_modeloemail_escalonamento,'Prazo para resoluo terminando - ${IDSOLICITACAOSERVICO}','Senhor(a) ${NOMECONTATO},<br /><br />Informamos que o prazo para resolu&ccedil;&atilde;o da solicita&ccedil;&atilde;o&nbsp;${IDSOLICITACAOSERVICO} &nbsp;est&aacute; terminando.<br /><br /><strong>N&uacute;mero:</strong> ${IDSOLICITACAOSERVICO}<br /><strong>Tipo:</strong> ${DEMANDA}<br /><strong>Servi&ccedil;o:</strong> ${SERVICO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><br />Atenciosamente,<br /><br />Central IT&nbsp;Tecnologia da Informa&ccedil;&atilde;o Ltda<br />','A','PrazoSolicitacao');

-- Fim - Bruno Franco

-- Inicio - Ronnie Mikihiro Sato Lopes 13/09/2013

INSERT INTO modelosemails
(idmodeloemail,
titulo,
texto,
situacao,
identificador)
VALUES
($id_listanegraemail,
'Softwares Irregulares Encontrados Perante Lista Negra',
'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que foram encontrados softwares irregulares instalados perante a Lista Negra de Softwares, como segue a tabela abaixo:<strong><br /><br /></strong><div style="text-align: left;"><strong>TABELA DE SOFTWARES IRREGULARES PERANTE LISTA NEGRA<br /><br /></strong>${TABELALISTANEGRA}</div><div style="text-align: center;">&nbsp;</div><br /><br />Atenciosamente,<br /><font face="Calibri"><font size="1"><b><span style="COLOR: #31849b; FONT-SIZE: 14pt">Central</span></b><b><span style="FONT-SIZE: 14pt">IT</span></b></font></font>',
'A',
'softwaresListaNegra');

-- Fim - Ronnie Mikihiro Sato Lopes

-- Incio Maycon 13/09/2013 

CREATE TABLE auditoriaitemconfig
(
  idauditoriaitemConfig number(10,0)  NOT NULL,
  iditemconfiguracao number(10,0) ,
  iditemconfiguracaopai number(10,0) ,
  idhistoricoic number(10,0) ,
  idhistoricovalor number(10,0) ,
  idvalor number(10,0) ,
  idusuario number(10,0) ,
  datahoraalteracao timestamp,
  tipoalteracao VARCHAR(20),
  primary key (idauditoriaitemconfig) 
);

alter table itemconfiguracao add (datahoradesinstalacao TIMESTAMP);

-- Fim Maycon

-- Inicio - Bruno Franco 13/09/2013

CREATE TABLE relEscalonamentomudanca
(
   idrequisicaomudanca integer, 
   idescalonamento integer, 
   CONSTRAINT pk_escalonamento_mudanca PRIMARY KEY (idrequisicaomudanca, idescalonamento), 
   CONSTRAINT fk_requisicaomudanca FOREIGN KEY (idrequisicaomudanca) REFERENCES requisicaomudanca (idrequisicaomudanca), 
   CONSTRAINT fk_escalonamento FOREIGN KEY (idescalonamento) REFERENCES escalonamento (idescalonamento)
);

CREATE TABLE relEscalonamentoproblema
(
   idproblema integer, 
   idescalonamento integer, 
   CONSTRAINT pk_escalonamento_problema PRIMARY KEY (idproblema, idescalonamento), 
   CONSTRAINT fk_ problema FOREIGN KEY (idproblema) REFERENCES problema (idproblema) , 
   CONSTRAINT fk_escalonamento FOREIGN KEY (idescalonamento) REFERENCES escalonamento (idescalonamento)
);

-- Fim - Bruno Franco

-- Inicio - Bruno Franco 16/09/2013

alter table problema add (vencendo varchar(1) default NULL);

-- Fim - Bruno Franco

-- Inicio - Riubbe Da Silva Oliveira 16/09/2013

ALTER TABLE tipomovimfinanceiraviagem ADD CONSTRAINT pk_tipomovimfinanviagem PRIMARY KEY(idtipomovimfinanceiraviagem);
ALTER TABLE requisicaoviagem  ADD  tarefainiciada varchar2(1) NULL;

CREATE TABLE controlefinanceiroviagem (
	idcontrolefinanceiroviagem NUMBER(19,0)NOT NULL,
	idresponsavel NUMBER(10,0) DEFAULT NULL,
	idmoeda NUMBER(10,0) DEFAULT NULL,
	datahora date NULL,
	situacao varchar2(20)DEFAULT NULL,
	observacoes clob DEFAULT NULL
);

ALTER TABLE controlefinanceiroviagem ADD CONSTRAINT pk_controlefinanceiroviagem PRIMARY KEY(idcontrolefinanceiroviagem);
ALTER TABLE controlefinanceiroviagem ADD CONSTRAINT fk_controlefinanceiroviagem_em FOREIGN KEY (idresponsavel) REFERENCES empregados(idempregado);
ALTER TABLE controlefinanceiroviagem ADD CONSTRAINT fk_controlefinanceiroviagem_mo FOREIGN KEY (idmoeda) REFERENCES moedas(idmoeda);
create index fk_idx_controlefinanceiroviag on controlefinanceiroviagem(idcontrolefinanceiroviagem);

CREATE TABLE adiantamentoviagem (
	idadiantamentoviagem NUMBER(19, 0) NOT NULL,
	idresponsavel NUMBER(10,0) DEFAULT NULL,
	idsolicitacaoservico NUMBER(19, 0) DEFAULT NULL,
	idempregado NUMBER(10,0) DEFAULT NULL,
	datahora DATE,
	valortotaladiantado FLOAT,
	situacao varchar2(20)NOT NULL,
	observacoes clob DEFAULT NULL
);

ALTER TABLE adiantamentoviagem ADD CONSTRAINT pk_adiantamentoviagem PRIMARY KEY(idadiantamentoviagem);
ALTER TABLE adiantamentoviagem ADD CONSTRAINT fk_adiantamentoviagem_empregad FOREIGN KEY(idresponsavel) REFERENCES empregados(idempregado);
ALTER TABLE adiantamentoviagem ADD CONSTRAINT fk_adiantamentoviagem_integran FOREIGN KEY(idsolicitacaoservico, idempregado) 
REFERENCES integranteviagem(idsolicitacaoservico, idempregado);
CREATE INDEX fk_idx_adiantamentoviagem on adiantamentoviagem(idadiantamentoviagem);

CREATE TABLE itemcontrolefinanceiroviagem (
	iditemcontrolefinanceiroviagem NUMBER(19,0) NOT NULL,
	idcontrolefinanceiroviagem NUMBER(19,0) DEFAULT NULL,
	idformapagamento  NUMBER(10,0) DEFAULT NULL,
	idadiantamentoviagem NUMBER(19,0) DEFAULT NULL,
	idfornecedor NUMBER(19,0) DEFAULT NULL,
	idjustificativa NUMBER(10,0) DEFAULT NULL,
	idsolicitacaoservico NUMBER(19,0) DEFAULT NULL,
	idempregado NUMBER(10,0) DEFAULT NULL,
	idtipomovimfinanceiraviagem NUMBER(19,0) DEFAULT NULL,
	complementojustificativa clob DEFAULT NULL,
	quantidade numeric(8,2) DEFAULT NULL,
	valorunitario float DEFAULT NULL,
	valoradiantamento float DEFAULT NULL,
	tipopassagem varchar2(20) DEFAULT NULL,
	localizador varchar2(50) DEFAULT NULL,
	assento varchar2(20) DEFAULT NULL,
	situacao varchar2(20) DEFAULT NULL,
	datafim DATE NULL DEFAULT NULL,
	prazocotacao DATE NULL DEFAULT NULL,
	observacao clob NULL,
	dataexecucao DATE NULL DEFAULT NULL,
	datahoraprazocotacao DATE NULL DEFAULT NULL
);

ALTER TABLE itemcontrolefinanceiroviagem ADD CONSTRAINT pk_itemcontrolefinanceiroviage PRIMARY KEY(iditemcontrolefinanceiroviagem);
ALTER TABLE itemcontrolefinanceiroviagem ADD CONSTRAINT fk_itemctrlfinan_ctrlfinan FOREIGN KEY(idcontrolefinanceiroviagem) REFERENCES controlefinanceiroviagem(idcontrolefinanceiroviagem);
ALTER TABLE itemcontrolefinanceiroviagem ADD CONSTRAINT fk_itemctrlfinan_formapagam FOREIGN KEY(idformapagamento) REFERENCES formapagamento(idformapagamento);
ALTER TABLE itemcontrolefinanceiroviagem ADD CONSTRAINT fk_itemctrlfinan_adiantviag FOREIGN KEY(idadiantamentoviagem) REFERENCES adiantamentoviagem(idadiantamentoviagem);
ALTER TABLE itemcontrolefinanceiroviagem ADD CONSTRAINT fk_itemctrlfinan_fornecedor FOREIGN KEY(idfornecedor) REFERENCES fornecedor(idfornecedor);
ALTER TABLE itemcontrolefinanceiroviagem ADD CONSTRAINT fk_itemctrlfinan_justificsoli FOREIGN KEY(idjustificativa) REFERENCES justificativasolicitacao(idjustificativa);
ALTER TABLE itemcontrolefinanceiroviagem ADD CONSTRAINT fk_itemctrlfinan_soliserv_em FOREIGN KEY(idsolicitacaoservico, idempregado) REFERENCES integranteviagem(idsolicitacaoservico, idempregado);
ALTER TABLE itemcontrolefinanceiroviagem ADD CONSTRAINT fk_itemctrlfinan_tipomovfinan FOREIGN KEY(idtipomovimfinanceiraviagem) REFERENCES tipomovimfinanceiraviagem(idtipoMovimFinanceiraViagem);
create index fk_idx_itemctrlfinanviagem on itemcontrolefinanceiroviagem(iditemcontrolefinanceiroviagem);


CREATE TABLE prestacaocontasviagem (
  idprestacaocontasviagem NUMBER(19,0) NOT NULL,
  idresponsavel  NUMBER(10,0) DEFAULT NULL,
  idaprovacao NUMBER(10,0) DEFAULT NULL,
  idsolicitacaoservico NUMBER(19,0) DEFAULT NULL,
  idempregado  NUMBER(10,0) DEFAULT NULL,
  datahora DATE NULL,
  situacao varchar2(35) DEFAULT NULL,
  iditemtrabalho NUMBER(20,0) DEFAULT NULL
);

ALTER TABLE prestacaocontasviagem ADD CONSTRAINT pk_prestacaocontasviagem PRIMARY KEY (idprestacaocontasviagem);
ALTER TABLE prestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_respo FOREIGN KEY (idresponsavel) REFERENCES empregados (idempregado);
ALTER TABLE prestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_aprov FOREIGN KEY (idaprovacao) REFERENCES parecer (idparecer);
ALTER TABLE prestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_empre FOREIGN KEY (idsolicitacaoservico, idempregado) REFERENCES integranteviagem (idsolicitacaoservico, idempregado);
CREATE INDEX fk_idx_prestacaocontasviagem on prestacaocontasviagem(idprestacaocontasviagem);

CREATE TABLE itemprestacaocontasviagem (
  iditemprestcontasviagem NUMBER(19,0) NOT NULL,
  idprestacaocontasviagem NUMBER(19,0) DEFAULT NULL,
  iditemdespesaviagem NUMBER(19,0) DEFAULT NULL,
  idfornecedor NUMBER(19,0) DEFAULT NULL,
  data DATE DEFAULT NULL,
  nomefornecedor VARCHAR2(100) DEFAULT NULL,
  numeroDocumento VARCHAR2(50) DEFAULT NULL,
  descricao VARCHAR2(200) DEFAULT NULL,
  valor FLOAT NOT NULL
);

ALTER TABLE itemprestacaocontasviagem ADD CONSTRAINT pk_itemprestacaocontasviagem PRIMARY KEY (iditemprestcontasviagem);
ALTER TABLE itemprestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_prest FOREIGN KEY (idprestacaocontasviagem) REFERENCES prestacaocontasviagem (idprestacaocontasviagem);
ALTER TABLE itemprestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_itemd FOREIGN KEY (iditemdespesaviagem) REFERENCES itemcontrolefinanceiroviagem (iditemcontrolefinanceiroviagem);
ALTER TABLE itemprestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_forne FOREIGN KEY(idfornecedor) REFERENCES fornecedor (idfornecedor);
CREATE INDEX fk_idx_itemprestacaocontasviag on itemprestacaocontasviagem(iditemprestcontasviagem);

alter table controlefinanceiroviagem add idresponsavelcompras number(11,0) null;

-- Fim - Riubbe Da Silva Oliveira

-- Inicio - Bruno Franco 18/09/2013

alter table regraescalonamento modify (tempoexecucao null);

-- Fim - Bruno Franco

-- Inicio - Uelen Paulo - 23/09/2013

create index idx_datahorafinalizacao on bpm_itemtrabalhofluxo(datahorafinalizacao);

-- Fim - Uelen Paulo

-- Inicio - Bruno Franco 24/09/2013

ALTER TABLE problema MODIFY(descricao varchar2(3000));

-- Fim - Bruno Franco

-- Inicio Maycon 25/09/2013

alter table solicitacaoservico add (idusuarioresponsavelatual number(10,0));

-- Fim Maycon

-- Inicio - Bruno Franco 04/10/2013

ALTER TABLE baseconhecimento ADD (idsolicitacaoservico number(11,0) default null);

-- Fim Bruno Franco

-- Inicio - Maycon 09/10/2013

ALTER TABLE parametrocorpore add ( tipodado varchar2(50) NULL);

-- Fim Maycon

-- Inicio - Rodrigo Pecci Acorse 17/10/2013

CREATE INDEX INDEX_GRUPO ON GRUPOSEMPREGADOS (IDGRUPO ASC);
CREATE INDEX INDEX_CONTRATOSGRUPOS_GRUPO ON CONTRATOSGRUPOS (IDGRUPO ASC);
CREATE INDEX INDEX_CONTRATOSGRUPOS_CONTRATO ON CONTRATOSGRUPOS (IDCONTRATO ASC);

-- Fim - Rodrigo Pecci Acorse

-- Inicio - Euler 23/10/2013

delete from menu where nome = '$menu.esconder';
delete from parametrocorpore where idparametrocorpore in (20,21);

-- Fim - Euler

-- Inicio - Rodrigo Pecci Acorse 28/10/2013

CREATE INDEX idx_idelementoorigem ON bpm_sequenciafluxo (idelementoorigem ASC);

-- Fim - Rodrigo Pecci Acorse

-- Inicio - Murilo Gabriel Rodrigues 31/10/2013

INSERT INTO lingua (idlingua, nome, sigla, datainicio, datafim) VALUES ($id_ligua_espanhol, 'Espaol', 'ES', to_date('2013-10-31', 'yyyy-mm-dd'), NULL);

-- Fim - Murilo Gabriel Rodrigues

-- Inicio - Bruno Carvalho de Aquino 01/11/2013

CREATE TABLE historicoitemrequisicao ( 
     idhistorico      NUMBER (10, 0) NOT NULL, 
     iditemrequisicao NUMBER (10, 0) NOT NULL, 
     idresponsavel    NUMBER (10, 0) NOT NULL, 
     datahora         TIMESTAMP NOT NULL, 
     acao             VARCHAR(100), 
     situacao         NUMBER (10, 0) NOT NULL, 
     complemento      VARCHAR2(400), 
     PRIMARY KEY (idhistorico, iditemrequisicao, idresponsavel), 
     FOREIGN KEY (iditemrequisicao) REFERENCES itemrequisicaoproduto (iditemrequisicaoproduto), 
     FOREIGN KEY (idresponsavel) REFERENCES empregados (idempregado) 
);

-- Fim - Bruno Carvalho de Aquino 01/11/2013

-- INICIO Thiago Fernandes Oliveira 01/11/2013

alter table motivosuspensaoativid add datafim date;

-- FIM Thiago Fernandes Oliveira

-- INICIO Emauri 05/11/2013

CREATE TABLE bi_categorias 
  ( 
     idcategoria    NUMBER(10,0) NOT NULL, 
     idcategoriapai NUMBER(10,0) NULL, 
     nomecategoria  VARCHAR2(80) NOT NULL, 
     identificacao  VARCHAR2(70) NOT NULL, 
     situacao       CHAR(1) NOT NULL, 
     PRIMARY KEY (idcategoria),
	 FOREIGN KEY (idcategoriapai) references bi_categorias (idcategoria)
  );

CREATE INDEX ix_bi_identcatg ON bi_categorias (identificacao ASC);

CREATE TABLE bi_consulta 
  ( 
     idconsulta     NUMBER(10,0) NOT NULL, 
     idcategoria    NUMBER(10,0) NOT NULL, 
     identificacao  VARCHAR2(70) NOT NULL, 
     nomeconsulta   VARCHAR2(255) NOT NULL, 
     tipoconsulta   CHAR(1) NOT NULL, 
     textosql       CLOB NULL, 
     acaocruzado    CHAR(1) NULL, 
     situacao       CHAR(1) NULL, 
     template       CLOB NULL, 
     scriptexec     CLOB NULL, 
     parametros     CLOB NULL, 
     naoatualizbase CHAR(1) NULL, 
     PRIMARY KEY (idconsulta),
     FOREIGN KEY (idcategoria) references bi_categorias (idcategoria)
  );

CREATE INDEX ix_bi_ident ON bi_consulta (identificacao ASC);
CREATE INDEX ix_bi_categ ON bi_consulta (idcategoria ASC);

CREATE TABLE bi_consultacolunas 
  ( 
     idconsultacoluna NUMBER(10,0) NOT NULL, 
     idconsulta       NUMBER(10,0) NOT NULL, 
     nomecoluna       VARCHAR2(90) NOT NULL, 
     tipofiltro       CHAR(1) NULL, 
     ordem            NUMBER(10,0) NULL, 
     PRIMARY KEY (idconsultacoluna),
     FOREIGN KEY (idconsulta) references bi_consulta (idconsulta)
  );
  
CREATE INDEX ix_bi_idconscols ON bi_consultacolunas (idconsulta ASC);

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (1,NULL,'Incidentes/Requisies','INCREQ001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (2,NULL,'Ativos e Configurao','ATVCFG001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (3,NULL,'Base de Conhecimento','BASECG001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (4,NULL,'Nveis de Servio','NIVELS001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (5,NULL,'Problemas','PROBL001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (6,NULL,'Mudanas','MUDAN001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (7,NULL,'Liberaes','LIBER001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (8,NULL,'Catalogo de Servios','CATAL001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (9,NULL,'Projetos','PROJET001','A');

-- FIM Emauri

-- INICIO Murilo Gabriel Rodrigues 01/11/2013

delete from menu where link like '/inventario/inventario.load';

-- FIM Murilo Gabriel Rodrigues

-- INICIO - MURILO PACHECO 12/11/2013

CREATE TABLE rh_experienciaprofissionalcurr (
  idexperienciaprofissional NUMBER(10,0) NOT NULL,
  periodo VARCHAR2(100) NULL,
  funcao VARCHAR2(100) NULL,
  localidade VARCHAR2(100) NULL,
  idcurriculo VARCHAR2(100) NULL,
  idrequisicaomudanca NUMBER(10,0) NOT NULL,
  descricaoempresa VARCHAR2(100) NULL,
  PRIMARY KEY (idexperienciaprofissional)
);

CREATE TABLE rh_competencia (
  idcompetencia NUMBER(10,0) NOT NULL,
  descricaocompetencia VARCHAR2(100) NULL,
  idcurriculo NUMBER(10,0) NULL,
  PRIMARY KEY (idcompetencia)
);

CREATE TABLE rh_justificativaacaocurriculo (
  idjustificativaacaocurriculo NUMBER(10,0) NOT NULL,
  nomejustificativaacaocurriculo VARCHAR2(250) NULL,
  PRIMARY KEY (idjustificativaacaocurriculo)
);

create table rh_historicoacaocurriculo (
  idhistoricoacaocurriculo NUMBER(10,0) NOT NULL,
  idcurriculo NUMBER(10,0) NULL,
  idjustificativaacaocurriculo NUMBER(10,0),
  complementojustificativa VARCHAR2(250),
  datahora TIMESTAMP,
  acao CHAR(1),
  primary key (idhistoricoacaocurriculo)
);

CREATE TABLE rh_conhecimento (
  idConhecimento NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) DEFAULT NULL,
  detalhe VARCHAR2(100) DEFAULT NULL,
  PRIMARY KEY (idConhecimento)
);

CREATE TABLE rh_experienciainformatica (
  idExperienciaInformatica NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  detalhe VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idExperienciaInformatica)
);

CREATE TABLE rh_habilidade (
  idHabilidade NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  detalhe VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idHabilidade)
);

CREATE TABLE rh_descricaocargo (
  iddescricaocargo NUMBER(10,0) NOT NULL,
  nomecargo VARCHAR2(100) NOT NULL,
  idcbo NUMBER(10,0) DEFAULT NULL,
  atividades VARCHAR2(100) NOT NULL,
  situacao CHAR(1) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) DEFAULT NULL,
  observacoes CLOB,
  idParecerValidacao NUMBER(10,0) DEFAULT NULL,
  PRIMARY KEY (iddescricaocargo)
);

CREATE TABLE rh_atitudeindividual (
  idAtitudeIndividual NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  detalhe VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idAtitudeIndividual)
);

CREATE TABLE rh_cargoatitudeindividual (
  idatitudeindividual NUMBER(10,0) NOT NULL,
  iddescricaocargo NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (idatitudeindividual,iddescricaocargo),
  CONSTRAINT fk_reference_722 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_723 FOREIGN KEY (idatitudeindividual) REFERENCES rh_atitudeindividual (idAtitudeIndividual)
);

CREATE TABLE rh_atitudeorganizacional (
  idatitudeorganizacional NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(200) NOT NULL,
  detalhe CLOB,
  PRIMARY KEY (idatitudeorganizacional)
);

CREATE TABLE rh_entrevistacandidato (
  identrevista NUMBER(10,0) NOT NULL,
  idcurriculo NUMBER(10,0) NOT NULL,
  identrevistador NUMBER(10,0) NOT NULL,
  tipoentrevista VARCHAR2(20) NOT NULL,
  datahora TIMESTAMP NOT NULL,
  caracteristicas CLOB,
  possuioutraatividade CHAR(1) NOT NULL,
  outraatividade CLOB,
  concordaexclusividade CHAR(1) NOT NULL,
  salarioatual FLOAT DEFAULT NULL,
  pretensaosalarial FLOAT DEFAULT NULL,
  datadisponibilidade date DEFAULT NULL,
  competencias CLOB,
  observacoes CLOB,
  resultado CHAR(1) NOT NULL,
  idtriagem NUMBER(10,0) DEFAULT NULL,
  trabalhoemequipe CLOB,
  cargoPretendido VARCHAR2(100) DEFAULT NULL,
  planoCarreira VARCHAR2(100) NOT NULL,
  metodosadicionais CLOB,
  notaavaliacao FLOAT,
  PRIMARY KEY (identrevista)
);

alter table rh_entrevistacandidato add (classificacao CHAR(1));

CREATE TABLE rh_atitudecandidato (
  identrevista NUMBER(10,0) NOT NULL,
  idatitudeorganizacional NUMBER(10,0) NOT NULL,
  avaliacao CHAR(1) DEFAULT NULL,
  PRIMARY KEY (identrevista,idatitudeorganizacional),
  CONSTRAINT fk_reference_entrevista FOREIGN KEY (identrevista) REFERENCES rh_entrevistacandidato (identrevista),
  CONSTRAINT fk_reference_atitudorg FOREIGN KEY (idatitudeorganizacional) REFERENCES rh_atitudeorganizacional (idatitudeorganizacional)
);

CREATE TABLE rh_cargoexperienciaanterior (
  iddescricaocargo NUMBER(10,0) NOT NULL,
  idconhecimento NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,idconhecimento)
);

CREATE TABLE rh_certificacao (
  idCertificacao NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  detalhe VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idCertificacao)
);

CREATE TABLE rh_certificacaocurriculo (
  idcertificacao NUMBER(10,0) NOT NULL,
  idcurriculo NUMBER(10,0) NOT NULL,
  versao VARCHAR2(100) NOT NULL,
  validade NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idcertificacao)
);

CREATE TABLE rh_certificacaorequisicaopesso (
  idcertificacao NUMBER(10,0) NOT NULL,
  versaocertificacao VARCHAR2(100) NOT NULL,
  validadecertificacao VARCHAR2(100) NOT NULL,
  descricaocertificacao VARCHAR2(100) NOT NULL,
  idcurriculo NUMBER(10,0) NOT NULL,
  PRIMARY KEY (idcertificacao)
);

CREATE TABLE rh_curriculo (
  idcurriculo NUMBER(10,0) NOT NULL,
  portadorNecessidadeEspecial CHAR(1) NOT NULL,
  iditemlistatipodeficiencia NUMBER(10,0) DEFAULT NULL,
  qtdefilhos NUMBER(10,0) DEFAULT NULL,
  nome VARCHAR2(100) NOT NULL,
  sexo CHAR(1) NOT NULL,
  cpf VARCHAR2(15) NOT NULL,
  estadoCivil NUMBER(10,0) NOT NULL,
  dataNascimento DATE NOT NULL,
  filhos CHAR(1) NOT NULL,
  cidadeNatal VARCHAR2(100) NOT NULL,
  idNaturalidade NUMBER(10,0) NOT NULL,
  observacoesEntrevista VARCHAR2(100) DEFAULT NULL,
  PRIMARY KEY (idcurriculo)
);

alter table rh_curriculo add (listanegra CHAR(1));

CREATE TABLE rh_curso (
  idCurso NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  detalhe VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idCurso)
);

CREATE TABLE rh_emailcurriculo (
  idemail NUMBER(10,0) NOT NULL,
  idcurriculo NUMBER(10,0) NOT NULL,
  principal CHAR(1) NOT NULL,
  descricaoemail VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idemail)
);

CREATE TABLE rh_enderecocurriculo (
  idendereco NUMBER(10,0) NOT NULL,
  idbairro NUMBER(10,0) NOT NULL,
  idcidade NUMBER(10,0) NOT NULL,
  iduf NUMBER(10,0) NOT NULL,
  idcurriculo NUMBER(10,0) NOT NULL,
  idtipoendereco NUMBER(10,0) NOT NULL,
  cep VARCHAR2(20) NOT NULL,
  complemento VARCHAR2(100) NOT NULL,
  correspondencia CHAR(1) NOT NULL,
  nomecidade VARCHAR2(100) NOT NULL,
  nomebairro VARCHAR2(100) NOT NULL,
  logradouro VARCHAR2(45) DEFAULT NULL,
  PRIMARY KEY (idendereco)
);

CREATE TABLE rh_formacaoacademica (
  idFormacaoAcademica NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  detalhe VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idFormacaoAcademica)
);

CREATE TABLE rh_formacaocurriculo (
  idformacao NUMBER(10,0) NOT NULL,
  idtipoformacao NUMBER(10,0) NOT NULL,
  idsituacao NUMBER(10,0) NOT NULL,
  idcurriculo NUMBER(10,0) NOT NULL,
  instituicao VARCHAR2(100) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idformacao)
);

CREATE TABLE rh_jornadadetrabalho (
  idjornada NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  escala CHAR(1) NOT NULL,
  considerarferiados CHAR(1) NOT NULL,
  PRIMARY KEY (idjornada)
);

CREATE TABLE rh_idioma (
  idIdioma NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  detalhe VARCHAR2(100) NOT NULL,
  PRIMARY KEY (idIdioma)
);

CREATE TABLE rh_requisicaoatitudeindividual (
  idatitudeindividual NUMBER(10,0) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (idatitudeindividual,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaocertificacao (
  idcertificacao NUMBER(10,0) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) DEFAULT NULL,
  PRIMARY KEY (idcertificacao,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaoconhecimento (
  idconhecimento NUMBER(10,0) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) DEFAULT NULL,
  PRIMARY KEY (idconhecimento,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaocurso (
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  idcurso NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) DEFAULT NULL,
  PRIMARY KEY (idsolicitacaoservico,idcurso)
);

CREATE TABLE rh_requisicaoexperienciaanteri (
  idconhecimento NUMBER(10,0) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) DEFAULT NULL,
  PRIMARY KEY (idconhecimento,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaoexperienciainform (
  idexperienciainformatica NUMBER(10,0) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) DEFAULT NULL,
  PRIMARY KEY (idexperienciainformatica,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaoformacaoacademica (
  idformacaoacademica NUMBER(10,0) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) DEFAULT NULL,
  PRIMARY KEY (idformacaoacademica,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaopessoal (
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  idCargo VARCHAR2(100) NOT NULL,
  vagas NUMBER(10,0) NOT NULL,
  motivoContratacao CHAR(1) DEFAULT NULL,
  salario DOUBLE PRECISION NOT NULL,
  idCentroCusto NUMBER(10,0) NOT NULL,
  idProjeto NUMBER(10,0) NOT NULL,
  rejeitada CHAR(1) DEFAULT NULL,
  idParecerValidacao NUMBER(10,0) DEFAULT NULL,
  situacao CHAR(1) DEFAULT NULL,
  confidencial CHAR(1) NOT NULL,
  dataAbertura DATE NOT NULL,
  beneficios VARCHAR2(100) DEFAULT NULL,
  folgas VARCHAR2(100) DEFAULT NULL,
  horario VARCHAR2(100) DEFAULT NULL,
  iduf NUMBER(10,0),
  tipocontratacao CHAR(11),
  idpais NUMBER(10,0),
  PRIMARY KEY (idsolicitacaoservico)
);

alter table rh_requisicaopessoal add (prerequisitoentrevistagestor CHAR(1));

CREATE TABLE rh_telefonecurriculo (
  idtelefone NUMBER(10,0) NOT NULL,
  idtipotelefone NUMBER(10,0) NOT NULL,
  ddd NUMBER(10,0) NOT NULL,
  numerotelefone VARCHAR2(15) NOT NULL,
  idcurriculo NUMBER(10,0) NOT NULL,
  PRIMARY KEY (idtelefone)
);

CREATE TABLE rh_triagemrequisicaopessoal (
  idtriagem NUMBER(10,0) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  idcurriculo NUMBER(10,0) NOT NULL,
  iditemtrabalhoentrevistarh NUMBER(10,0) DEFAULT NULL,
  iditemtrabalhoentrevistagestor NUMBER(10,0) DEFAULT NULL,
  PRIMARY KEY (idtriagem),
  CONSTRAINT fk_reference_743 FOREIGN KEY (idsolicitacaoservico) REFERENCES rh_requisicaopessoal (idsolicitacaoservico),
  CONSTRAINT fk_reference_744 FOREIGN KEY (idcurriculo) REFERENCES rh_curriculo (idcurriculo)
);

CREATE TABLE rh_cargocertificacao (
  iddescricaocargo NUMBER(10,0) NOT NULL,
  idcertificacao NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,idcertificacao),
  CONSTRAINT fk_reference_726 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_727 FOREIGN KEY (idcertificacao) REFERENCES rh_certificacao (idCertificacao)
);

CREATE TABLE rh_cargoconhecimento (
  iddescricaocargo NUMBER(10,0) NOT NULL,
  idconhecimento NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,idconhecimento),
  CONSTRAINT fk_reference_724 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_725 FOREIGN KEY (idconhecimento) REFERENCES rh_conhecimento (idConhecimento)
);

CREATE TABLE rh_cargocurso (
  iddescricaocargo NUMBER(10,0) NOT NULL,
  idcurso NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,idcurso),
  CONSTRAINT fk_reference_728 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_729 FOREIGN KEY (idcurso) REFERENCES rh_curso (idCurso)
);

CREATE TABLE rh_cargoexperienciainformatica (
  idexperienciainformatica NUMBER(10,0) NOT NULL,
  iddescricaocargo NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (idexperienciainformatica,iddescricaocargo),
  CONSTRAINT fk_reference_732 FOREIGN KEY (idexperienciainformatica) REFERENCES rh_experienciainformatica (idExperienciaInformatica),
  CONSTRAINT fk_reference_733 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo)
);

CREATE TABLE rh_cargoformacaoacademica (
  idformacaoacademica NUMBER(10,0) NOT NULL,
  iddescricaocargo NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (idformacaoacademica,iddescricaocargo),
  CONSTRAINT fk_reference_734 FOREIGN KEY (idformacaoacademica) REFERENCES rh_formacaoacademica (idFormacaoAcademica),
  CONSTRAINT fk_reference_735 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo)
);

CREATE TABLE rh_cargohabilidade (
  idhabilidade NUMBER(10,0) NOT NULL,
  iddescricaocargo NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (idhabilidade,iddescricaocargo),
  CONSTRAINT fk_reference_736 FOREIGN KEY (idhabilidade) REFERENCES rh_habilidade (idHabilidade),
  CONSTRAINT fk_reference_737 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo)
);

CREATE TABLE rh_cargoidioma (
  iddescricaocargo NUMBER(10,0) NOT NULL,
  ididioma NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,ididioma),
  CONSTRAINT fk_reference_730 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_731 FOREIGN KEY (ididioma) REFERENCES rh_idioma (idIdioma)
);

CREATE TABLE rh_requisicaohabilidade (
  idhabilidade NUMBER(10,0) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) DEFAULT NULL,
  PRIMARY KEY (idhabilidade,idsolicitacaoservico),
  CONSTRAINT fk_reference_738 FOREIGN KEY (idhabilidade) REFERENCES rh_habilidade (idHabilidade),
  CONSTRAINT fk_reference_739 FOREIGN KEY (idsolicitacaoservico) REFERENCES rh_requisicaopessoal (idsolicitacaoservico)
);

CREATE TABLE rh_requisicaoidioma (
  ididioma NUMBER(10,0) NOT NULL,
  idsolicitacaoservico NUMBER(10,0) NOT NULL,
  obrigatorio CHAR(1) DEFAULT NULL,
  PRIMARY KEY (ididioma,idsolicitacaoservico),
  CONSTRAINT fk_reference_740 FOREIGN KEY (ididioma) REFERENCES rh_idioma (idIdioma),
  CONSTRAINT fk_reference_741 FOREIGN KEY (idsolicitacaoservico) REFERENCES rh_requisicaopessoal (idsolicitacaoservico)
);

CREATE TABLE rh_jornadaempregado (
  idjornada NUMBER(10,0) NOT NULL,
  descricao VARCHAR2(100) NOT NULL,
  escala CHAR(1) NOT NULL,
  considerarferiados CHAR(1) NOT NULL,
  PRIMARY KEY (idjornada)
);


-- #####################################

ALTER TABLE rh_requisicaopessoal ADD (adimitido NUMBER(1) DEFAULT 0);
ALTER TABLE rh_requisicaopessoal ADD (qtdcandidatosaprovados NUMBER(10,0));

-- FIM - MURILO PACHECO 12/11/2013

-- INICIO - MURILO GABRIEL RODRIGUES - 18/11/2013

delete from menu where link like '/monitoramentoServicos/monitoramentoServicos.load';

-- FIM - MURILO GABRIEL RODRIGUES - 18/11/2013
