-- Incio Mrio 05/09/2013

CREATE TABLE gruporequisicaomudanca (
  idgruporequisicaomudanca int NOT NULL,
  idgrupo int NOT NULL,
  idrequisicaomudanca int NOT NULL,
  PRIMARY KEY (idgruporequisicaomudanca),
  foreign key (idgrupo) references grupo (idgrupo),
  foreign key (idrequisicaomudanca) references requisicaomudanca (idrequisicaomudanca)
);

ALTER TABLE gruporequisicaomudanca ADD COLUMN nomegrupo VARCHAR(250);
ALTER TABLE gruporequisicaomudanca ADD COLUMN datafim date default null;

CREATE TABLE ligacao_mud_his_gru
(
  idligacao_mud_his_gru int4 NOT NULL,
  idgruporequisicaomudanca int4,
  idrequisicaomudanca int4,
  idhistoricomudanca int4,
  constraint pk_ligacao_mud_his_gru primary key (idligacao_mud_his_gru)
);

-- Fim Mrio

-- Incio Murilo Gabriel 07/09/2013

alter table historicoic add column idcontrato int null;
alter table historicoic add column idliberacao int null;
alter table historicoic add column idresponsavel int null;
alter table historicoic add column ativofixo varchar(255) null;

-- Fim Murilo Gabriel

-- Incio Ronnie Mikihiro 10/09/2013

CREATE TABLE softwareslistanegra (
    idsoftwareslistanegra int NOT NULL,
    nomesoftwareslistanegra varchar(100) NOT NULL
);
ALTER TABLE softwareslistanegra ADD CONSTRAINT pk_softwareslistanegra PRIMARY KEY(idsoftwareslistanegra);
CREATE INDEX fk_idx_softwareslistanegra ON softwareslistanegra(idsoftwareslistanegra);


CREATE TABLE softwareslistanegraencontrados (
    idsoftwareslistanegraencontrad int NOT NULL,
    iditemconfiguracao int NOT NULL,
    idsoftwareslistanegra int NOT NULL,
    softwarelistanegraencontrado varchar(200) NOT NULL,
	data timestamp NOT NULL
);
ALTER TABLE softwareslistanegraencontrados ADD CONSTRAINT pk_softwareslistanegraencontrados PRIMARY KEY(idsoftwareslistanegraencontrad);
ALTER TABLE softwareslistanegraencontrados ADD CONSTRAINT fk_softwareslistanegraencontrados_itemconfiguracao FOREIGN KEY(iditemconfiguracao) REFERENCES itemconfiguracao(iditemconfiguracao);
ALTER TABLE softwareslistanegraencontrados ADD CONSTRAINT fk_softwareslistanegraencontrados_softwareslistanegra FOREIGN KEY (idsoftwareslistanegra) REFERENCES softwareslistanegra(idsoftwareslistanegra);
CREATE INDEX fk_idx_softwareslistanegraencontrados ON softwareslistanegraencontrados(idsoftwareslistanegraencontrad);

-- Fim Ronnie Mikihiro 10/09/2013

-- Incio Bruno 10/09/2013

alter table solicitacaoservico add column vencendo varchar(1) NULL;
alter table solicitacaoservico add column criouproblemaautomatico varchar(1) NULL;

-- Fim Bruno

-- Incio Euler 10/09/2013

CREATE  TABLE regraescalonamento (
  idregraescalonamento integer NOT NULL ,
  idtipogerenciamento integer NOT NULL ,
  idservico integer NULL ,
  idcontrato integer NULL ,
  idsolicitante integer NULL ,
  idgrupo integer NULL ,
  idtipodemandaservico integer NULL ,
  urgencia VARCHAR(1) NULL ,
  impacto VARCHAR(1) NULL ,
  tempoexecucao integer NOT NULL ,
  intervalonotificacao integer NOT NULL ,
  enviaremail VARCHAR(1),
  criaproblema VARCHAR(1),
  prazocriarproblema integer NULL ,
  datainicio date null,
  datafim date null,
  PRIMARY KEY (idregraescalonamento) ,
  foreign key (idtipodemandaservico) references tipodemandaservico (idtipodemandaservico),
  foreign key (idservico) references servico (idservico),
  foreign key (idcontrato) references contratos (idcontrato),
  foreign key (idgrupo) references grupo (idgrupo)
);

CREATE  TABLE escalonamento (
  idescalonamento integer NOT NULL ,
  idregraescalonamento integer NOT NULL ,
  idgrupoexecutor integer NOT NULL ,
  prazoexecucao integer NOT NULL ,
  datainicio date null,
  datafim date null,
  PRIMARY KEY (idescalonamento) ,
  foreign key (idgrupoexecutor) references grupo (idgrupo),
  foreign key (idregraescalonamento) references regraescalonamento (idregraescalonamento)
);

alter table regraescalonamento add tipodataescalonamento integer;
update regraescalonamento set tipodataescalonamento = 1 where tipodataescalonamento is null;
alter table regraescalonamento alter tipodataescalonamento set not null;
alter table escalonamento add idprioridade integer null;

-- Fim Euler 

-- Incio Emauri 11/09/2013

ALTER TABLE netmap ADD column hardware VARCHAR(255);
ALTER TABLE netmap ADD column sistemaoper VARCHAR(255);
ALTER TABLE netmap ADD column uptime VARCHAR(20);

-- Fim Emauri 11/09/2013

-- Inicio Cleison 12/09/2013

ALTER TABLE itemrequisicaoproduto ALTER COLUMN situacao TYPE VARCHAR(50);

-- Fim Cleison

-- Inicio Mrio Haysaki Jnior 12/09/2013

ALTER TABLE projetos ADD COLUMN deleted varchar(1) DEFAULT NULL;

-- Fim Mrio Haysaki Jnior

-- Inicio Bruno Franco 12/09/2013

CREATE TABLE relEscalonamentoSolServico
(
   idsolicitacaoservico bigint, 
   idescalonamento integer,
   CONSTRAINT pk_escalonamento_solicitacao PRIMARY KEY (idsolicitacaoservico, idescalonamento),
   CONSTRAINT fk_solicitacaoservico FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico) ON UPDATE NO ACTION ON DELETE NO ACTION,
   CONSTRAINT fk_escalonamento FOREIGN KEY (idescalonamento) REFERENCES escalonamento (idescalonamento) ON UPDATE NO ACTION ON DELETE NO ACTION
);

-- Fim Bruno Franco

-- Inicio Maycon Fernandes 12/09/2013

CREATE TABLE auditoriaitemconfig
(
  idauditoriaitemConfig int NOT NULL,
  iditemconfiguracao int,
  iditemconfiguracaopai int,
  idhistoricoic int,
  idhistoricovalor int,
  idvalor int,
  idusuario int,
  datahoraalteracao timestamp,
  tipoalteracao VARCHAR(20),
  primary key (idauditoriaitemconfig) 
);

alter table itemconfiguracao ADD COLUMN datahoradesinstalacao TIMESTAMP;

-- Fim Maycon

-- Inicio - Bruno Franco 13/09/2013

alter table requisicaomudanca add column vencendo varchar(1) NULL;

insert into modelosemails (idmodeloemail, titulo, texto, situacao, identificador) values ($id_modeloemail_escalonamento,'Prazo para resoluo terminando - ${IDSOLICITACAOSERVICO}','Senhor(a) ${NOMECONTATO},<br /><br />Informamos que o prazo para resolu&ccedil;&atilde;o da solicita&ccedil;&atilde;o&nbsp;${IDSOLICITACAOSERVICO} &nbsp;est&aacute; terminando.<br /><br /><strong>N&uacute;mero:</strong> ${IDSOLICITACAOSERVICO}<br /><strong>Tipo:</strong> ${DEMANDA}<br /><strong>Servi&ccedil;o:</strong> ${SERVICO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><br />Atenciosamente,<br /><br />Central IT&nbsp;Tecnologia da Informa&ccedil;&atilde;o Ltda<br />','A','PrazoSolicitacao');

-- Fim - Bruno Franco

-- Inicio - Ronnie Mikihiro Sato Lopes 13/09/2013

INSERT INTO modelosemails
(idmodeloemail,
titulo,
texto,
situacao,
identificador)
VALUES
($id_listanegraemail,
'Softwares Irregulares Encontrados Perante Lista Negra',
'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que foram encontrados softwares irregulares instalados perante a Lista Negra de Softwares, como segue a tabela abaixo:<strong><br /><br /></strong><div style="text-align: left;"><strong>TABELA DE SOFTWARES IRREGULARES PERANTE LISTA NEGRA<br /><br /></strong>${TABELALISTANEGRA}</div><div style="text-align: center;">&nbsp;</div><br /><br />Atenciosamente,<br /><font face="Calibri"><font size="1"><b><span style="COLOR: #31849b; FONT-SIZE: 14pt">Central</span></b><b><span style="FONT-SIZE: 14pt">IT</span></b></font></font>',
'A',
'softwaresListaNegra');

-- Fim - Ronnie Mikihiro Sato Lopes

-- Incio Maycon 13/09/2013 

CREATE TABLE auditoriaitemconfig
(
  idauditoriaitemConfig int NOT NULL,
  iditemconfiguracao int,
  iditemconfiguracaopai int,
  idhistoricoic int,
  idhistoricovalor int,
  idvalor int,
  idusuario int,
  datahoraalteracao timestamp,
  tipoalteracao VARCHAR(20),
  primary key (idauditoriaitemconfig) 
);

alter table itemconfiguracao ADD COLUMN datahoradesinstalacao TIMESTAMP;

-- Fim Maycon

-- Inicio - Bruno Franco 13/09/2013

CREATE TABLE relEscalonamentomudanca
(
   idrequisicaomudanca bigint, 
   idescalonamento integer, 
   CONSTRAINT pk_escalonamento_mudanca PRIMARY KEY (idrequisicaomudanca, idescalonamento), 
   CONSTRAINT fk_requisicaomudanca FOREIGN KEY (idrequisicaomudanca) REFERENCES requisicaomudanca(idrequisicaomudanca) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_escalonamento FOREIGN KEY (idescalonamento) REFERENCES escalonamento (idescalonamento) ON UPDATE NO ACTION ON DELETE NO ACTION
);

CREATE TABLE relEscalonamentoproblema
(
   idproblema bigint, 
   idescalonamento integer, 
   CONSTRAINT pk_escalonamento_problema PRIMARY KEY (idproblema, idescalonamento), 
   CONSTRAINT fk_problema FOREIGN KEY (idproblema) REFERENCES problema (idproblema) ON UPDATE NO ACTION ON DELETE NO ACTION, 
   CONSTRAINT fk_escalonamento FOREIGN KEY (idescalonamento) REFERENCES escalonamento (idescalonamento) ON UPDATE NO ACTION ON DELETE NO ACTION
);

-- Fim - Bruno Franco

-- Inicio - Bruno Franco 16/09/2013

alter table problema add column vencendo varchar(1) NULL;

-- Fim - Bruno Franco

-- Inicio - Riubbe Da Silva Oliveira 16/09/2013

create table controlefinanceiroviagem (
    idcontrolefinanceiroviagem bigint not null,
    idresponsavel int default null,
    idmoeda int default null,
    datahora timestamp null,
    situacao varchar default null,
    observacoes text default null
);

alter table controlefinanceiroviagem add constraint pk_controlefinanceiroviagem primary key(idcontrolefinanceiroviagem);
alter table controlefinanceiroviagem add constraint fk_controlefinanceiroviagem_empregados foreign key (idresponsavel) references empregados(idempregado);
alter table controlefinanceiroviagem add constraint fk_controlefinanceiroviagem_moedas foreign key (idmoeda) references moedas(idmoeda);
create index fk_idx_controlefinanceiroviagem on controlefinanceiroviagem(idcontrolefinanceiroviagem);

create table adiantamentoviagem (
	idadiantamentoviagem bigint not null,
	idresponsavel int default null,
	idsolicitacaoservico bigint default null,
	idempregado int default null,
	datahora timestamp default null,
	valortotaladiantado decimal(8,2) default null,
	situacao varchar(20)not null,
	observacoes text default null
);

alter table adiantamentoviagem add constraint pk_adiantamentoviagem primary key(idadiantamentoviagem);
alter table adiantamentoviagem add constraint fk_adiantamentoviagem_empregados foreign key(idresponsavel) references empregados(idempregado);
alter table adiantamentoviagem add constraint fk_adiantamentoviagem_integranteviagem foreign key(idsolicitacaoservico, idempregado) references integranteviagem(idsolicitacaoservico, idempregado);
create index fk_idx_adiantamentoviagem on adiantamentoviagem(idadiantamentoviagem);

create table itemcontrolefinanceiroviagem (
	iditemcontrolefinanceiroviagem bigint not null,
	idcontrolefinanceiroviagem bigint default null,
	idformapagamento int default null,
	idadiantamentoviagem bigint default null,
	idfornecedor bigint default null,
	idjustificativa int default null,
	idsolicitacaoservico bigint default null,
	idempregado int default null,
	idtipomovimfinanceiraviagem bigint default null,
	complementojustificativa text default null,
	quantidade numeric(8,2) default null,
	valorunitario decimal(8,2) default null,
	valoradiantamento decimal(8,2) default null,
	tipopassagem varchar(20) default null,
	localizador varchar(50) default null,
	assento varchar(20) default null,
	situacao varchar(20) default null,
	datafim date default null,
	prazocotacao date default null,
	observacao TEXT NULL,
	dataexecucao timestamp default null,
	datahoraprazocotacao timestamp default null
);

alter table itemcontrolefinanceiroviagem add constraint pk_itemcontrolefinanceiroviagem primary key(iditemcontrolefinanceiroviagem);
alter table itemcontrolefinanceiroviagem add constraint fk_itemcontrolefinaceiroviagem_controlefinanceiroviagem foreign key(idcontrolefinanceiroviagem) references controlefinanceiroviagem(idcontrolefinanceiroviagem);
alter table itemcontrolefinanceiroviagem add constraint fk_itemcontrolefinaceiroviagem_formapagamento foreign key(idformapagamento) references formapagamento(idformapagamento);
alter table itemcontrolefinanceiroviagem add constraint fk_itemcontrolefinaceiroviagem_adiantamentoviagem foreign key(idadiantamentoviagem) references adiantamentoviagem(idadiantamentoviagem);
alter table itemcontrolefinanceiroviagem add constraint fk_itemcontrolefinaceiroviagem_fornecedor foreign key(idfornecedor) references fornecedor(idfornecedor);
alter table itemcontrolefinanceiroviagem add constraint fk_itemcontrolefinaceiroviagem_justificativasolicitacao foreign key(idjustificativa) references justificativasolicitacao(idjustificativa);
alter table itemcontrolefinanceiroviagem add constraint fk_itemcontrolefinaceiroviagem_solicitacaoservico_empregado foreign key(idsolicitacaoservico, idempregado) references integranteviagem(idsolicitacaoservico, idempregado);
alter table itemcontrolefinanceiroviagem add constraint fk_itemcontrolefinaceiroviagem_tipomovimfinanceiraviagem foreign key(idtipomovimfinanceiraviagem) references tipomovimfinanceiraviagem(idtipomovimfinanceiraviagem);
create index fk_idx_itemcontrolefinanceiroviagem on itemcontrolefinanceiroviagem(iditemcontrolefinanceiroviagem);


CREATE TABLE prestacaocontasviagem (
  idprestacaocontasviagem bigint NOT NULL,
  idresponsavel int DEFAULT NULL,
  idaprovacao int DEFAULT NULL,
  idsolicitacaoservico bigint DEFAULT NULL,
  idempregado int DEFAULT NULL,
  datahora timestamp NULL,
  situacao varchar(35) DEFAULT NULL,
  iditemtrabalho bigint DEFAULT NULL
);

ALTER TABLE prestacaocontasviagem ADD CONSTRAINT pk_prestacaocontasviagem PRIMARY KEY (idprestacaocontasviagem);
ALTER TABLE prestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_responsavel FOREIGN KEY (idresponsavel) REFERENCES empregados (idempregado);
ALTER TABLE prestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_aprovacao FOREIGN KEY (idaprovacao) REFERENCES parecer (idparecer);
ALTER TABLE prestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_solicitacaoservico_empregado FOREIGN KEY (idsolicitacaoservico, idempregado) REFERENCES integranteviagem (idsolicitacaoservico, idempregado);
CREATE INDEX fk_idx_prestacaocontasviagem on prestacaocontasviagem(idprestacaocontasviagem);
  
CREATE TABLE itemprestacaocontasviagem (
  iditemprestcontasviagem bigint NOT NULL,
  idprestacaocontasviagem bigint DEFAULT NULL,
  iditemdespesaviagem bigint DEFAULT NULL,
  idfornecedor bigint DEFAULT NULL,
  data date DEFAULT NULL,
  nomefornecedor varchar(100) DEFAULT NULL,
  numeroDocumento varchar(50) DEFAULT NULL,
  descricao varchar(200) DEFAULT NULL,
  valor decimal(8,2) NOT NULL
);

ALTER TABLE itemprestacaocontasviagem ADD CONSTRAINT pk_itemprestacaocontasviagem PRIMARY KEY (iditemprestcontasviagem);
ALTER TABLE itemprestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_prestacaocontasviagem FOREIGN KEY (idprestacaocontasviagem) REFERENCES prestacaocontasviagem (idprestacaocontasviagem);
ALTER TABLE itemprestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_itemdespesaviagem FOREIGN KEY (iditemdespesaviagem) REFERENCES itemcontrolefinanceiroviagem (iditemcontrolefinanceiroviagem);
ALTER TABLE itemprestacaocontasviagem ADD CONSTRAINT fk_prestacaocontasviagem_fornecedor FOREIGN KEY(idfornecedor) REFERENCES fornecedor (idfornecedor);
CREATE INDEX fk_idx_itemprestacaocontasviagem on itemprestacaocontasviagem(iditemprestcontasviagem);

ALTER TABLE controlefinanceiroviagem ADD COLUMN idresponsavelcompras INT NULL;


-- Fim - Riubbe Da Silva Oliveira

-- Inicio - Bruno Franco 18/09/2013

ALTER TABLE regraescalonamento ALTER COLUMN tempoexecucao DROP NOT NULL;

-- Fim - Bruno Franco

-- Inicio - Uelen Paulo - 23/09/2013

create index idx_datahorafinalizacao on bpm_itemtrabalhofluxo(datahorafinalizacao);

-- Fim - Uelen Paulo

-- Inicio - Bruno Franco 24/09/2013

ALTER TABLE problema ALTER COLUMN descricao TYPE text;

-- Fim - Bruno Franco

-- Inicio Maycon 25/09/2013

ALTER TABLE solicitacaoservico ADD COLUMN idusuarioresponsavelatual INT;

-- Fim Maycon

-- Inicio - Bruno Franco 04/10/2013

ALTER TABLE baseconhecimento ADD COLUMN  idsolicitacaoservico int null;

-- Fim Bruno Franco

-- inicio murilo pacheco

CREATE TABLE rh_experienciaprofissionalcurriculo (
  idexperienciaprofissional int NOT NULL,
  periodo VARCHAR(100) NULL,
  funcao VARCHAR(100) NULL,
  localidade varchar(100) NULL,
  idcurriculo varchar(100) NULL,
  idrequisicaomudanca int NOT NULL,
  descricaoempresa varchar(100) NULL,
  PRIMARY KEY (idexperienciaprofissional) );

CREATE TABLE rh_competencia (
  idcompetencia int NOT NULL,
  descricaocompetencia VARCHAR(100) NULL,
  idcurriculo int NULL,
  PRIMARY KEY (idcompetencia)
);


CREATE TABLE rh_justificativaacaocurriculo (
  idjustificativaacaocurriculo INTEGER NOT NULL,
 nomejustificativaacaocurriculo VARCHAR(250) NULL,
  PRIMARY KEY (idjustificativaacaocurriculo) );


create table rh_historicoacaocurriculo
(
  idhistoricoacaocurriculo integer not null,
  idcurriculo integer null,
  idjustificativaacaocurriculo integer,
 complementojustificativa varchar(250),
  datahora             timestamp,
  acao                 char(1),
  primary key (idhistoricoacaocurriculo) );

CREATE TABLE rh_conhecimento (
  idConhecimento Integer NOT NULL,
  descricao character varying(100) DEFAULT NULL,
  detalhe character varying(100) DEFAULT NULL,
  PRIMARY KEY (idConhecimento)
);

CREATE TABLE rh_experienciainformatica (
  idExperienciaInformatica Integer NOT NULL,
  descricao character varying(100) NOT NULL,
  detalhe character varying(100) NOT NULL,
  PRIMARY KEY (idExperienciaInformatica)
);

CREATE TABLE rh_habilidade (
  idHabilidade Integer NOT NULL,
  descricao character varying(100) NOT NULL,
  detalhe character varying(100) NOT NULL,
  PRIMARY KEY (idHabilidade)
);

CREATE TABLE rh_descricaocargo (
  iddescricaocargo Integer NOT NULL,
  nomecargo character varying(100) NOT NULL,
  idcbo Integer DEFAULT NULL,
  atividades character varying(100) NOT NULL,
  situacao char(1) NOT NULL,
  idsolicitacaoservico Integer DEFAULT NULL,
  observacoes text,
  idParecerValidacao Integer DEFAULT NULL,
  PRIMARY KEY (iddescricaocargo)
);

CREATE TABLE rh_atitudeindividual (
  idAtitudeIndividual Integer NOT NULL,
  descricao character varying(100) NOT NULL,
  detalhe character varying(100) NOT NULL,
  PRIMARY KEY (idAtitudeIndividual)
);

CREATE TABLE rh_cargoatitudeindividual (
  idatitudeindividual Integer NOT NULL,
  iddescricaocargo Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (idatitudeindividual,iddescricaocargo),
  CONSTRAINT fk_reference_722 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_723 FOREIGN KEY (idatitudeindividual) REFERENCES rh_atitudeindividual (idAtitudeIndividual)
);

CREATE TABLE rh_atitudeorganizacional (
  idatitudeorganizacional Integer NOT NULL,
  descricao character varying(200) NOT NULL,
  detalhe text,
  PRIMARY KEY (idatitudeorganizacional)
);

CREATE TABLE rh_entrevistacandidato (
  identrevista Integer NOT NULL,
  idcurriculo Integer NOT NULL,
  identrevistador Integer NOT NULL,
  tipoentrevista character varying(20) NOT NULL,
  datahora timestamp NOT NULL,
  caracteristicas text,
  possuioutraatividade char(1) NOT NULL,
  outraatividade text,
  concordaexclusividade char(1) NOT NULL,
  salarioatual decimal(6,2) DEFAULT NULL,
  pretensaosalarial decimal(6,2) DEFAULT NULL,
  datadisponibilidade date DEFAULT NULL,
  competencias text,
  observacoes text,
  resultado char(1) NOT NULL ,
  idtriagem Integer DEFAULT NULL,
  trabalhoemequipe text,
  cargoPretendido character varying(100) DEFAULT NULL,
  planoCarreira character varying(100) NOT NULL,
  metodosadicionais TEXT,
  notaavaliacao decimal(6,2),
  PRIMARY KEY (identrevista)
);

ALTER TABLE rh_entrevistacandidato ADD COLUMN classificacao CHAR(1);

CREATE TABLE rh_atitudecandidato (
  identrevista Integer NOT NULL,
  idatitudeorganizacional Integer NOT NULL,
  avaliacao char(1) DEFAULT NULL,
  PRIMARY KEY (identrevista,idatitudeorganizacional),
  CONSTRAINT fk_reference_entrevista FOREIGN KEY (identrevista) REFERENCES rh_entrevistacandidato (identrevista),
  CONSTRAINT fk_reference_atitudorg FOREIGN KEY (idatitudeorganizacional) REFERENCES rh_atitudeorganizacional (idatitudeorganizacional)
);

CREATE TABLE rh_cargoexperienciaanterior (
  iddescricaocargo Integer NOT NULL,
  idconhecimento Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,idconhecimento)
);

CREATE TABLE rh_certificacao (
  idCertificacao Integer NOT NULL,
  descricao character varying(100) NOT NULL,
  detalhe character varying(100) NOT NULL,
  PRIMARY KEY (idCertificacao)
);

CREATE TABLE rh_certificacaocurriculo (
  idcertificacao Integer NOT NULL,
  idcurriculo Integer NOT NULL,
  versao character varying(100) NOT NULL,
  validade Integer NOT NULL,
  descricao character varying(100) NOT NULL,
  PRIMARY KEY (idcertificacao)
);

CREATE TABLE rh_certificacaorequisicaopessoal (
  idcertificacao Integer NOT NULL,
  versaocertificacao character varying(100) NOT NULL,
  validadecertificacao character varying(100) NOT NULL,
  descricaocertificacao character varying(100) NOT NULL,
  idcurriculo Integer NOT NULL,
  PRIMARY KEY (idcertificacao)
);

CREATE TABLE rh_curriculo (
  idcurriculo Integer NOT NULL,
  portadorNecessidadeEspecial char(1) NOT NULL,
  iditemlistatipodeficiencia Integer DEFAULT NULL,
  qtdefilhos Integer DEFAULT NULL,
  nome character varying(100) NOT NULL,
  sexo char(1) NOT NULL,
  cpf character varying(15) NOT NULL,
  estadoCivil int2 NOT NULL,
  dataNascimento date NOT NULL,
  filhos char(1) NOT NULL,
  cidadeNatal character varying(100) NOT NULL,
  idNaturalidade Integer NOT NULL,
  observacoesEntrevista character varying(100) DEFAULT NULL,
  PRIMARY KEY (idcurriculo)
);

ALTER TABLE rh_curriculo ADD COLUMN listanegra CHAR(1);

CREATE TABLE rh_curso (
  idCurso Integer NOT NULL,
  descricao character varying(100) NOT NULL,
  detalhe character varying(100) NOT NULL,
  PRIMARY KEY (idCurso)
);

CREATE TABLE rh_emailcurriculo (
idemail Integer NOT NULL,
idcurriculo Integer NOT NULL,
principal char(1) NOT NULL,
descricaoemail character varying(100) NOT NULL,
PRIMARY KEY (idemail)
);

CREATE TABLE rh_enderecocurriculo (
  idendereco Integer NOT NULL,
  idbairro Integer NOT NULL,
  idcidade Integer NOT NULL,
  iduf Integer NOT NULL,
  idcurriculo Integer NOT NULL,
  idtipoendereco Integer NOT NULL,
  cep character varying(20) NOT NULL,
  complemento character varying(100) NOT NULL,
  correspondencia char(1) NOT NULL,
  nomecidade character varying(100) NOT NULL,
  nomebairro character varying(100) NOT NULL,
  logradouro character varying(45) DEFAULT NULL,
  PRIMARY KEY (idendereco)
);

CREATE TABLE rh_formacaoacademica (
  idFormacaoAcademica Integer NOT NULL,
  descricao character varying(100) NOT NULL,
  detalhe character varying(100) NOT NULL,
  PRIMARY KEY (idFormacaoAcademica)
);

CREATE TABLE rh_formacaocurriculo (
  idformacao Integer NOT NULL,
  idtipoformacao Integer NOT NULL,
  idsituacao Integer NOT NULL,
  idcurriculo Integer NOT NULL,
  instituicao varchar(100) NOT NULL,
  descricao varchar(100) NOT NULL,
  PRIMARY KEY (idformacao)
);

CREATE TABLE rh_jornadadetrabalho (
  idjornada Integer NOT NULL,
  descricao character varying(100) NOT NULL,
  escala char(1) NOT NULL,
  considerarferiados char(1) NOT NULL,
  PRIMARY KEY (idjornada)
);

CREATE TABLE rh_idioma (
  idIdioma Integer NOT NULL,
  descricao character varying(100) NOT NULL,
  detalhe character varying(100) NOT NULL,
  PRIMARY KEY (idIdioma)
);

CREATE TABLE rh_requisicaoatitudeindividual (
  idatitudeindividual Integer NOT NULL,
  idsolicitacaoservico Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (idatitudeindividual,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaocertificacao (
  idcertificacao Integer NOT NULL,
  idsolicitacaoservico Integer NOT NULL,
  obrigatorio char(1) DEFAULT NULL,
  PRIMARY KEY (idcertificacao,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaoconhecimento (
  idconhecimento Integer NOT NULL,
  idsolicitacaoservico Integer NOT NULL,
  obrigatorio char(1) DEFAULT NULL,
  PRIMARY KEY (idconhecimento,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaocurso (
  idsolicitacaoservico Integer NOT NULL,
  idcurso Integer NOT NULL,
  obrigatorio char(1) DEFAULT NULL,
  PRIMARY KEY (idsolicitacaoservico,idcurso)
);

CREATE TABLE rh_requisicaoexperienciaanterior (
  idconhecimento Integer NOT NULL,
  idsolicitacaoservico Integer NOT NULL,
  obrigatorio char(1) DEFAULT NULL,
  PRIMARY KEY (idconhecimento,idsolicitacaoservico)
);


CREATE TABLE rh_requisicaoexperienciainformatica (
  idexperienciainformatica Integer NOT NULL,
  idsolicitacaoservico Integer NOT NULL,
  obrigatorio char(1) DEFAULT NULL,
  PRIMARY KEY (idexperienciainformatica,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaoformacaoacademica (
  idformacaoacademica Integer NOT NULL,
  idsolicitacaoservico Integer NOT NULL,
  obrigatorio char(1) DEFAULT NULL,
  PRIMARY KEY (idformacaoacademica,idsolicitacaoservico)
);

CREATE TABLE rh_requisicaopessoal (
  idsolicitacaoservico Integer NOT NULL,
  idCargo character varying(100) NOT NULL,
  vagas Integer NOT NULL,
  motivoContratacao char(1) DEFAULT NULL,
  salario double precision NOT NULL,
  idCentroCusto Integer NOT NULL,
  idProjeto Integer NOT NULL,
  rejeitada char(1) DEFAULT NULL,
  idParecerValidacao Integer DEFAULT NULL,
  situacao char(1) DEFAULT NULL,
  confidencial char(1) NOT NULL,
  dataAbertura date NOT NULL,
  beneficios character varying(100) DEFAULT NULL,
  folgas character varying(100) DEFAULT NULL,
  horario character varying(100) DEFAULT NULL,
  iduf Integer,
  idpais Integer,
  PRIMARY KEY (idsolicitacaoservico)
);

alter table rh_requisicaopessoal add column prerequisitoentrevistagestor char(1);

CREATE TABLE rh_telefonecurriculo (
  idtelefone Integer NOT NULL,
  idtipotelefone Integer NOT NULL,
  ddd Integer NOT NULL,
  numerotelefone character varying(15) NOT NULL,
  idcurriculo Integer NOT NULL,
  PRIMARY KEY (idtelefone)
);

CREATE TABLE rh_triagemrequisicaopessoal (
  idtriagem Integer NOT NULL,
  idsolicitacaoservico Integer NOT NULL,
  idcurriculo Integer NOT NULL,
  iditemtrabalhoentrevistarh Integer DEFAULT NULL,
  iditemtrabalhoentrevistagestor Integer DEFAULT NULL,
  PRIMARY KEY (idtriagem),
  CONSTRAINT fk_reference_743 FOREIGN KEY (idsolicitacaoservico) REFERENCES rh_requisicaopessoal (idsolicitacaoservico),
  CONSTRAINT fk_reference_744 FOREIGN KEY (idcurriculo) REFERENCES rh_curriculo (idcurriculo)
);

CREATE TABLE rh_cargocertificacao (
  iddescricaocargo Integer NOT NULL,
  idcertificacao Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,idcertificacao),
  CONSTRAINT fk_reference_726 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_727 FOREIGN KEY (idcertificacao) REFERENCES rh_certificacao (idCertificacao)
);

CREATE TABLE rh_cargoconhecimento (
  iddescricaocargo Integer NOT NULL,
  idconhecimento Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,idconhecimento),
  CONSTRAINT fk_reference_724 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_725 FOREIGN KEY (idconhecimento) REFERENCES rh_conhecimento (idConhecimento)
);

CREATE TABLE rh_cargocurso (
  iddescricaocargo Integer NOT NULL,
  idcurso Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,idcurso),
  CONSTRAINT fk_reference_728 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_729 FOREIGN KEY (idcurso) REFERENCES rh_curso (idCurso)
);

CREATE TABLE rh_cargoexperienciainformatica (
  idexperienciainformatica Integer NOT NULL,
  iddescricaocargo Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (idexperienciainformatica,iddescricaocargo),
  CONSTRAINT fk_reference_732 FOREIGN KEY (idexperienciainformatica) REFERENCES rh_experienciainformatica (idExperienciaInformatica),
  CONSTRAINT fk_reference_733 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo)
);

CREATE TABLE rh_cargoformacaoacademica (
  idformacaoacademica Integer NOT NULL,
  iddescricaocargo Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (idformacaoacademica,iddescricaocargo),
  CONSTRAINT fk_reference_734 FOREIGN KEY (idformacaoacademica) REFERENCES rh_formacaoacademica (idFormacaoAcademica),
  CONSTRAINT fk_reference_735 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo)
);

CREATE TABLE rh_cargohabilidade (
  idhabilidade Integer NOT NULL,
  iddescricaocargo Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (idhabilidade,iddescricaocargo),
  CONSTRAINT fk_reference_736 FOREIGN KEY (idhabilidade) REFERENCES rh_habilidade (idHabilidade),
  CONSTRAINT fk_reference_737 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo)
);

CREATE TABLE rh_cargoidioma (
  iddescricaocargo Integer NOT NULL,
  ididioma Integer NOT NULL,
  obrigatorio char(1) NOT NULL,
  PRIMARY KEY (iddescricaocargo,ididioma),
  CONSTRAINT fk_reference_730 FOREIGN KEY (iddescricaocargo) REFERENCES rh_descricaocargo (iddescricaocargo),
  CONSTRAINT fk_reference_731 FOREIGN KEY (ididioma) REFERENCES rh_idioma (idIdioma)
);

CREATE TABLE rh_requisicaohabilidade (
  idhabilidade Integer NOT NULL,
  idsolicitacaoservico Integer NOT NULL,
  obrigatorio char(1) DEFAULT NULL,
  PRIMARY KEY (idhabilidade,idsolicitacaoservico),
  CONSTRAINT fk_reference_738 FOREIGN KEY (idhabilidade) REFERENCES rh_habilidade (idHabilidade),
  CONSTRAINT fk_reference_739 FOREIGN KEY (idsolicitacaoservico) REFERENCES rh_requisicaopessoal (idsolicitacaoservico)
);

CREATE TABLE rh_requisicaoidioma (
  ididioma Integer NOT NULL,
  idsolicitacaoservico Integer NOT NULL,
  obrigatorio char(1) DEFAULT NULL,
  PRIMARY KEY (ididioma,idsolicitacaoservico),
  CONSTRAINT fk_reference_740 FOREIGN KEY (ididioma) REFERENCES rh_idioma (idIdioma),
  CONSTRAINT fk_reference_741 FOREIGN KEY (idsolicitacaoservico) REFERENCES rh_requisicaopessoal (idsolicitacaoservico)
);

CREATE TABLE rh_jornadaempregado (
  idjornada INTEGER NOT NULL,
  descricao char(100) NOT NULL,
  escala char(1) NOT NULL,
  considerarferiados char(1) NOT NULL,
  PRIMARY KEY (idjornada)
);

-- fim murilo pacheco modulo RH

-- Inicio - Maycon 09/10/2013

ALTER TABLE parametrocorpore add column tipodado character varying(50);

-- Fim Maycon

-- Inicio - Rodrigo Pecci Acorse 17/10/2013

CREATE INDEX empregados_idempregado_idx ON empregados USING btree (idempregado);
CREATE INDEX gruposempregados_idgrupo_idx ON gruposempregados USING btree (idgrupo);
CREATE INDEX contratosgrupos_idgrupo_idx ON contratosgrupos USING btree (idgrupo);
CREATE INDEX contratosgrupos_idcontrato_idx ON contratosgrupos USING btree (idcontrato);

-- Fim - Rodrigo Pecci Acorse

-- Inicio - Euler 23/10/2013

delete from menu where nome = '$menu.esconder';
delete from parametrocorpore where idparametrocorpore in (20,21);

-- Fim - Euler

-- Inicio - Rodrigo Pecci Acorse 28/10/2013

CREATE INDEX idx_idatribuicao ON bpm_atribuicaofluxo USING btree (idatribuicao);
CREATE INDEX idx_idelemento ON bpm_elementofluxo USING btree (idelemento);
CREATE INDEX idx_idfluxo ON bpm_fluxo USING btree (idfluxo);
CREATE INDEX idx_idhistoricoitemtrabalho ON bpm_historicoitemtrabalho USING btree (idhistoricoitemtrabalho);
CREATE INDEX idx_idinstancia ON bpm_instanciafluxo USING btree (idinstancia);
CREATE INDEX idx_iditemtrabalho ON bpm_itemtrabalhofluxo USING btree (iditemtrabalho);
CREATE INDEX idx_idobjetoinstancia ON bpm_objetoinstanciafluxo USING btree (idobjetoinstancia);
CREATE INDEX idx_idelementoorigem ON bpm_sequenciafluxo USING btree (idelementoorigem);
CREATE INDEX idx_idtipofluxo ON bpm_tipofluxo USING btree (idtipofluxo);

-- Fim - Rodrigo Pecci Acorse

-- Inicio - Murilo Gabriel Rodrigues 31/10/2013

INSERT INTO lingua (idlingua, nome, sigla, datainicio, datafim) VALUES ($id_ligua_espanhol, 'Espaol', 'ES', '2013-10-31', NULL);

-- Fim - Murilo Gabriel Rodrigues

-- Inicio - Bruno Carvalho de Aquino 01/11/2013

ALTER TABLE itemrequisicaoproduto ADD PRIMARY KEY (iditemrequisicaoproduto);

CREATE TABLE historicoitemrequisicao ( 
     idhistorico      INT NOT NULL, 
     iditemrequisicao INT NOT NULL, 
     idresponsavel    INT NOT NULL, 
     datahora         TIMESTAMP NULL DEFAULT NULL, 
     acao             VARCHAR(100), 
     situacao         VARCHAR(30) NOT NULL, 
     complemento      TEXT, 
     PRIMARY KEY (idhistorico, iditemrequisicao, idresponsavel), 
     FOREIGN KEY (iditemrequisicao) REFERENCES itemrequisicaoproduto ( 
     iditemrequisicaoproduto), 
     FOREIGN KEY (idresponsavel) REFERENCES empregados (idempregado) 
);

-- Fim - Bruno Carvalho de Aquino 01/11/2013

-- Inicio - murilo pacheco 01/11/2013

ALTER TABLE rh_entrevistacandidato ADD COLUMN adimitido BOOLEAN DEFAULT FALSE;
ALTER TABLE rh_entrevistacandidato ADD COLUMN notaavaliacao DECIMAL(6,2);
ALTER TABLE rh_requisicaopessoal ADD COLUMN qtdcandidatosaprovados INTEGER;
ALTER TABLE rh_requisicaopessoal ADD COLUMN tipocontratacao CHAR(11);

-- Fim - murilo pacheco 01/11/2013

-- INICIO Thiago Fernandes Oliveira 01/11/2013

alter table motivosuspensaoativid add column datafim date;

-- FIM Thiago Fernandes Oliveira

-- INICIO Emauri 05/11/2013

CREATE TABLE bi_categorias 
  ( 
     idcategoria    INT8 NOT NULL, 
     idcategoriapai INT8 NULL, 
     nomecategoria  VARCHAR(80) NOT NULL, 
     identificacao  VARCHAR(70) NOT NULL, 
     situacao       CHAR(1) NOT NULL, 
     CONSTRAINT pk_bi_categorias PRIMARY KEY (idcategoria) 
  );

CREATE UNIQUE INDEX ix_bi_identcatg ON bi_categorias (identificacao);

ALTER TABLE bi_categorias 
  ADD CONSTRAINT fk_bi_categ_reference_bi_categ FOREIGN KEY (idcategoriapai) 
  REFERENCES bi_categorias (idcategoria) ON DELETE restrict ON UPDATE restrict;

CREATE TABLE bi_consulta 
  ( 
     idconsulta     INT8 NOT NULL, 
     idcategoria    INT8 NOT NULL, 
     identificacao  VARCHAR(70) NOT NULL, 
     nomeconsulta   VARCHAR(255) NOT NULL, 
     tipoconsulta   CHAR(1) NOT NULL, 
     textosql       TEXT NULL, 
     acaocruzado    CHAR(1) NULL, 
     situacao       CHAR(1) NULL, 
     template       TEXT NULL, 
     scriptexec     TEXT NULL, 
     parametros     TEXT NULL, 
     naoatualizbase CHAR(1) NULL, 
     CONSTRAINT pk_bi_consulta PRIMARY KEY (idconsulta) 
  );

CREATE UNIQUE INDEX ix_bi_ident ON bi_consulta (identificacao);

CREATE INDEX ix_bi_categ ON bi_consulta (idcategoria);

ALTER TABLE bi_consulta 
  ADD CONSTRAINT fk_bi_consu_reference_bi_categ FOREIGN KEY (idcategoria) 
  REFERENCES bi_categorias (idcategoria) ON DELETE restrict ON UPDATE restrict;

CREATE TABLE bi_consultacolunas 
  ( 
     idconsultacoluna INT8 NOT NULL, 
     idconsulta       INT8 NOT NULL, 
     nomecoluna       VARCHAR(90) NOT NULL, 
     tipofiltro       CHAR(1) NULL, 
     ordem            INT4 NULL, 
     CONSTRAINT pk_bi_consultacolunas PRIMARY KEY (idconsultacoluna) 
  );

CREATE INDEX ix_bi_idconscols ON bi_consultacolunas (idconsulta);

ALTER TABLE bi_consultacolunas 
  ADD CONSTRAINT fk_bi_consu_reference_bi_consu FOREIGN KEY (idconsulta) 
  REFERENCES bi_consulta (idconsulta) ON DELETE restrict ON UPDATE restrict;

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (1,NULL,'Incidentes/Requisies','INCREQ001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (2,NULL,'Ativos e Configurao','ATVCFG001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (3,NULL,'Base de Conhecimento','BASECG001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (4,NULL,'Nveis de Servio','NIVELS001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (5,NULL,'Problemas','PROBL001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (6,NULL,'Mudanas','MUDAN001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (7,NULL,'Liberaes','LIBER001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (8,NULL,'Catalogo de Servios','CATAL001','A');

INSERT INTO bi_categorias 
            (idcategoria,idcategoriapai,nomecategoria,identificacao,situacao) 
VALUES      (9,NULL,'Projetos','PROJET001','A');

-- FIM Emauri

-- INICIO Murilo Gabriel Rodrigues 01/11/2013

delete from menu where link like '/inventario/inventario.load';

-- FIM Murilo Gabriel Rodrigues

-- INICIO - Flvio 14/11/2013

CREATE TABLE instalacao (
   idinstalacao integer NOT NULL,
   sucesso character(1), 
   passo character varying
);

ALTER TABLE ONLY instalacao ADD CONSTRAINT instalacao_pkey PRIMARY KEY (idinstalacao);

-- FIM - Flvio 14/11/2013

-- INICIO - MURILO GABRIEL RODRIGUES - 18/11/2013

delete from menu where link like '/monitoramentoServicos/monitoramentoServicos.load';

-- FIM - MURILO GABRIEL RODRIGUES - 18/11/2013
