DROP TABLE ameacariscocont;
DROP TABLE riscocont;
ALTER TABLE planejamentoorganizacionalgrp ADD datafim DATE;
ALTER TABLE conscientizacaoregistro ADD datafim DATE;

ALTER TABLE auditoriaesttestmedrecup MODIFY nometemplatecontinuidade VARCHAR(200) NULL;

ALTER TABLE calendarioeventoteste ADD situacao char(1);

ALTER TABLE analiseimpactonegocio MODIFY maxtoleravelinatividade VARCHAR(8) NULL;
ALTER TABLE analiseimpactonegocio MODIFY objvtemporec VARCHAR(8) NULL;
ALTER TABLE analiseimpactonegocio MODIFY objvpontorec VARCHAR(8) NULL;

ALTER TABLE auditoriaContAnalImpacNegocio MODIFY maxtoleravelinatividade VARCHAR(8) NULL;
ALTER TABLE auditoriaContAnalImpacNegocio MODIFY objtemporecuperacao VARCHAR(8) NULL;
ALTER TABLE auditoriaContAnalImpacNegocio MODIFY objpontorecuperacao VARCHAR(8) NULL;

-- INCIO - deborah.ferreira - 10.05.2016
ALTER TABLE impactoain MODIFY COLUMN datahorafim TIMESTAMP NULL DEFAULT NULL;
ALTER TABLE analiseimpactonegocio MODIFY COLUMN datahorafim TIMESTAMP NULL DEFAULT NULL;
-- FIM - deborah.ferreira - 10.05.2016

-- INCIO - joao.morais - 11.05.2016
RENAME TABLE INDICADORESCAPACIDADESERVICO TO indicadorescapacidadeservico;
RENAME TABLE INDICADORESCAPACIDADEIC TO indicadorescapacidadeic;
RENAME TABLE INDICADORCAPACIDADE TO indicadorcapacidade;
RENAME TABLE PROBLEMASERVICONEGOCIO TO problemaserviconegocio;
RENAME TABLE HABILIDADESERVICO TO habilidadeservico;
RENAME TABLE ATRIBUTODEMANDASERVICO TO atributodemandaservico;
RENAME TABLE ATRIBUTODEMANDAIC TO atributodemandaic;
RENAME TABLE ATRIBUTODEMANDA TO atributodemanda;
-- FIM - joao.morais - 11.05.2016


-- INCIO - gustavo.gomes - 11.05.2016
ALTER TABLE ocorrenciaservicoprocessonegocio ADD nomecliente VARCHAR(255) NOT NULL;

ALTER TABLE auditoriacontavalriscorisco ADD idcenariorisco BIGINT NOT NULL;
ALTER TABLE auditoriacontavalriscorisco ADD idrisco INT NOT NULL;

ALTER TABLE ameaca DROP FOREIGN KEY fk_categoriaameaca;
ALTER TABLE categoriaameaca CHANGE idameaca idcategoriaameaca bigint NOT NULL;
ALTER TABLE ameaca ADD CONSTRAINT fk_categoriaameaca FOREIGN KEY (idcategoriaameaca) REFERENCES categoriaameaca(idcategoriaameaca);
ALTER TABLE categoriaameaca CHANGE nomeameaca nomecategoriaameaca varchar(255) not null;

ALTER TABLE cenarioriscotratativa ADD medidarecuperacao text;
-- FIM - gustavo.gomes - 12.05.2016


-- INICIO - gilberto.nery - 24.05.2016
DROP PROCEDURE IF EXISTS pr_relaciona_solicitacao_itemtrabalho_sit;

CREATE PROCEDURE pr_relaciona_solicitacao_itemtrabalho_sit (situacao char(15),solicitante bigint,vinculado_contrato char(1))
body:BEGIN 
	DROP TEMPORARY TABLE IF EXISTS tab_solicitacao_sit;
    CREATE TEMPORARY TABLE tab_solicitacao_sit(
        idsolicitacaoservico bigint, 
        PRIMARY KEY  (idsolicitacaoservico)
    ) ENGINE=Memory;
	
	SET @sql_text = 'INSERT INTO tab_solicitacao_sit (idsolicitacaoservico) SELECT DISTINCT ss.idsolicitacaoservico FROM solicitacaoservico ss '; 
	
	IF vinculado_contrato IS NOT NULL 
	   THEN 
	       IF vinculado_contrato =  'S'
				THEN 
					SET	@sql_text = concat(@sql_text,' INNER JOIN servicocontrato sc ON sc.idservicocontrato = ss.idservicocontrato ');
					SET	@sql_text = concat(@sql_text,' INNER JOIN contratos c ON c.idcontrato = sc.idcontrato ');
					SET	@sql_text = concat(@sql_text,' INNER JOIN contratosgrupos cg ON c.idcontrato = cg.idcontrato ');
					SET	@sql_text = concat(@sql_text,' INNER JOIN gruposempregados ge ON cg.idgrupo = ge.idgrupo ');
	       END IF;
	END IF; 

	IF solicitante IS NOT NULL 
		THEN 
			SET @sql_text = concat(@sql_text,' WHERE ss.idsolicitante = ', solicitante); 
			IF situacao IS NOT NULL
				THEN 
					SET	@sql_text = concat(@sql_text,'  and (ss.situacao = ''', situacao, ''')');
			END IF;
	END IF;

	SET @sql_text = concat(@sql_text,' ORDER BY idsolicitacaoservico'); 
    PREPARE stm FROM @sql_text; 
    EXECUTE stm; 
    DEALLOCATE PREPARE stm; 
 	DROP TEMPORARY TABLE IF EXISTS tab_solicitacao_itemtrabalho_sit; 
    CREATE TEMPORARY TABLE tab_solicitacao_itemtrabalho_sit( 
        idsolicitacaoservico bigint, 
		iditemtrabalho bigint, 
        PRIMARY KEY  (idsolicitacaoservico,iditemtrabalho) 
    ) ENGINE=Memory; 
 	BLOCK1: begin 
		DECLARE v_idsolicitacao bigint; 
		DECLARE pararLoop BOOLEAN DEFAULT FALSE; 
		DECLARE cursorSolicitacoes CURSOR FOR  SELECT idsolicitacaoservico FROM tab_solicitacao_sit; 
		DECLARE CONTINUE HANDLER FOR NOT FOUND SET pararLoop = TRUE; 
		OPEN cursorSolicitacoes; 
 		the_loop1: LOOP 
			FETCH cursorSolicitacoes INTO v_idsolicitacao; 
			IF pararLoop 
				THEN 
					CLOSE cursorSolicitacoes; 
					LEAVE the_loop1; 
			END IF; 
 			BLOCK2: begin 
 				DECLARE v_inseriu BOOLEAN DEFAULT FALSE; 
				DECLARE v_iditem bigint; 
				DECLARE pararLoop2 BOOLEAN DEFAULT FALSE; 
				DECLARE cursorItens CURSOR FOR SELECT DISTINCT it.iditemtrabalho 
											   FROM execucaosolicitacao ex JOIN bpm_itemtrabalhofluxo it ON ex.idsolicitacaoservico = v_idsolicitacao AND ex.idinstanciafluxo = it.idinstancia and it.idStatus in (2, 3)  
																		   JOIN bpm_elementofluxo e ON e.idelemento = it.idelemento AND e.idtype = 2  
																		   JOIN bpm_atribuicaofluxo a ON it.iditemtrabalho = a.iditemtrabalho AND a.idtype in (1,3);  
				DECLARE CONTINUE HANDLER FOR NOT FOUND SET pararLoop2 = TRUE; 
				OPEN cursorItens; 
 				the_loop2: LOOP 
 					FETCH cursorItens INTO v_iditem; 
					IF pararLoop2 
						THEN 
							CLOSE cursorItens; 
							LEAVE the_loop2; 
					END IF; 
					INSERT INTO tab_solicitacao_itemtrabalho_sit VALUES (v_idsolicitacao, v_iditem); 
					IF NOT v_inseriu 
						THEN 
							SET v_inseriu := TRUE; 
					END IF; 
 				END LOOP the_loop2; 
				IF NOT v_inseriu 
					THEN 
						BLOCK3: begin 
							DECLARE pararLoop3 BOOLEAN DEFAULT FALSE; 
							DECLARE cursorItens3 CURSOR FOR SELECT it.iditemtrabalho 
															FROM execucaosolicitacao ex JOIN bpm_itemtrabalhofluxo it ON ex.idsolicitacaoservico = v_idsolicitacao AND ex.idinstanciafluxo = it.idinstancia 
																					    JOIN bpm_elementofluxo e ON e.idelemento = it.idelemento AND e.idtype = 2 
																						JOIN bpm_atribuicaofluxo a ON it.iditemtrabalho = a.iditemtrabalho AND a.idtype in (1,3) 
															ORDER BY datahorafinalizacao DESC LIMIT 1; 
							DECLARE CONTINUE HANDLER FOR NOT FOUND SET pararLoop3 = TRUE; 
							OPEN cursorItens3; 
 							the_loop3: LOOP 
 								FETCH cursorItens3 INTO v_iditem; 
								IF pararLoop3 
									THEN 
										CLOSE cursorItens3; 
										LEAVE the_loop3; 
								END IF; 
								INSERT INTO tab_solicitacao_itemtrabalho_sit VALUES (v_idsolicitacao, v_iditem); 
							END LOOP the_loop3; 
						end BLOCK3; 
				END IF; 
			end BLOCK2; 
		END LOOP the_loop1; 
	end BLOCK1; 
	select 1; 
END;
-- FIM - gilberto.nery - 24.05.2016

-- INCIO - joao.morais - 31.05.2016

alter table estrategiafuncaovital drop datainicio;
alter table estrategiafuncaovital drop datafim;

-- FIM - joao.morais - 31.05.2016

-- INICIO - gilberto.nery - 24.05.2016
ALTER TABLE evm_linha_g_g_nagios MODIFY host VARCHAR(50) NULL;
ALTER TABLE evm_linha_g_g_nagios MODIFY service VARCHAR(50) NULL;
-- FIM - gilberto.nery - 24.05.2016