set sql_safe_updates = 0;
set global innodb_buffer_pool_size=402653184;
set net_read_timeout=60000;

-- Tipo de elemento em bpm_elementofluxo
alter table bpm_elementofluxo add column idtype smallint;
alter table bpm_elementofluxo add column idsubtype smallint;
update bpm_elementofluxo set idtype = 1 where tipoelemento = 'Inicio';
update bpm_elementofluxo set idtype = 2 where tipoelemento = 'Tarefa';
update bpm_elementofluxo set idtype = 3 where tipoelemento = 'Script';
update bpm_elementofluxo set idtype = 4 where tipoelemento = 'Email';
update bpm_elementofluxo set idtype = 5 where tipoelemento = 'Porta';
update bpm_elementofluxo set idtype = 6 where tipoelemento = 'Evento';
update bpm_elementofluxo set idtype = 7 where tipoelemento = 'Finalizacao';
update bpm_elementofluxo set idsubtype = 1 where subtipo = 'Decisao';
update bpm_elementofluxo set idsubtype = 2 where subtipo = 'Paralela';
update bpm_elementofluxo set idsubtype = 3 where subtipo = 'Convergente';
alter table bpm_elementofluxo modify idtype smallint not null;
alter table bpm_elementofluxo modify tipoelemento varchar(20);

-- Ao em bpm_historicoitemtrabalho
alter table bpm_historicoitemtrabalho add column idaction smallint;
update bpm_historicoitemtrabalho set idaction = 1 where acao = 'Iniciar';
update bpm_historicoitemtrabalho set idaction = 2 where acao = 'Executar';
update bpm_historicoitemtrabalho set idaction = 3 where acao = 'Delegar';
update bpm_historicoitemtrabalho set idaction = 4 where acao = 'Suspender';
update bpm_historicoitemtrabalho set idaction = 5 where acao = 'Cancelar';
alter table bpm_historicoitemtrabalho modify idaction smallint not null;
alter table bpm_historicoitemtrabalho modify acao varchar(10);

-- Situao em bpm_instanciafluxo
alter table bpm_instanciafluxo add column idstatus smallint;
update bpm_instanciafluxo set idstatus = 1 where situacao = 'Aberta';
update bpm_instanciafluxo set idstatus = 2 where situacao = 'Suspensa';
update bpm_instanciafluxo set idstatus = 3 where situacao = 'Cancelada';
update bpm_instanciafluxo set idstatus = 4 where situacao = 'Encerrada';
alter table bpm_instanciafluxo modify idstatus smallint not null;
alter table bpm_instanciafluxo modify situacao varchar(20);

-- Situao em bpm_itemtrabalhofluxo
alter table bpm_itemtrabalhofluxo add column idstatus smallint;
update bpm_itemtrabalhofluxo set idstatus = 1 where situacao = 'Criado';
update bpm_itemtrabalhofluxo set idstatus = 2 where situacao = 'Disponivel';
update bpm_itemtrabalhofluxo set idstatus = 3 where situacao = 'EmAndamento';
update bpm_itemtrabalhofluxo set idstatus = 4 where situacao = 'Suspenso';
update bpm_itemtrabalhofluxo set idstatus = 5 where situacao = 'Cancelado';
update bpm_itemtrabalhofluxo set idstatus = 6 where situacao = 'Encerrado';
update bpm_itemtrabalhofluxo set idstatus = 7 where situacao = 'Executado';
alter table bpm_itemtrabalhofluxo modify idstatus smallint not null;
alter table bpm_itemtrabalhofluxo modify situacao varchar(20);

-- Tipo de atribuio em bpm_atribuicaofluxo
alter table bpm_atribuicaofluxo add column idtype smallint;
update bpm_atribuicaofluxo set idtype = 1 where tipo = 'Automatica';
update bpm_atribuicaofluxo set idtype = 2 where tipo = 'Acompanhamento';
update bpm_atribuicaofluxo set idtype = 3 where tipo = 'Delegacao';
alter table bpm_atribuicaofluxo modify idtype smallint not null;
alter table bpm_atribuicaofluxo modify tipo varchar(20);

-- Situao em solicitacaoservico
alter table solicitacaoservico add column idstatus smallint;
update solicitacaoservico set idstatus = 1 where situacao = 'EmAndamento';
update solicitacaoservico set idstatus = 2 where situacao = 'Suspensa';
update solicitacaoservico set idstatus = 3 where situacao = 'Cancelada';
update solicitacaoservico set idstatus = 4 where situacao = 'Resolvida';
update solicitacaoservico set idstatus = 5 where situacao = 'Reaberta';
update solicitacaoservico set idstatus = 6 where situacao = 'Fechada';
update solicitacaoservico set idstatus = 7 where situacao = 'ReClassificada';
alter table solicitacaoservico modify idstatus smallint not null;
alter table solicitacaoservico modify situacao varchar(20);

-- Situao em ocorrenciasolicitacao
update ocorrenciasolicitacao set  dadossolicitacao = replace(dadossolicitacao,'"situacao":"EmAndamento"','"situacao":"EmAndamento","idStatus":1');
update ocorrenciasolicitacao set  dadossolicitacao = replace(dadossolicitacao,'"situacao":"Suspensa"','"situacao":"Suspensa","idStatus":2');
update ocorrenciasolicitacao set  dadossolicitacao = replace(dadossolicitacao,'"situacao":"Cancelada"','"situacao":"Cancelada","idStatus":3');
update ocorrenciasolicitacao set  dadossolicitacao = replace(dadossolicitacao,'"situacao":"Resolvida"','"situacao":"Resolvida","idStatus":4');
update ocorrenciasolicitacao set  dadossolicitacao = replace(dadossolicitacao,'"situacao":"Reaberta"','"situacao":"Reaberta","idStatus":5');
update ocorrenciasolicitacao set  dadossolicitacao = replace(dadossolicitacao,'"situacao":"Fechada"','"situacao":"Fechada","idStatus":6');
update ocorrenciasolicitacao set  dadossolicitacao = replace(dadossolicitacao,'"situacao":"ReClassificada"','"situacao":"ReClassificada","idStatus":7');

-- categoria em  ocorrenciamudanca
alter table  ocorrenciasolicitacao add column idOccurrenceCategory smallint;
update  ocorrenciasolicitacao set idOccurrenceCategory = 1 where categoria = 'Criacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 2 where categoria = 'Acompanhamento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 3 where categoria = 'Atualizacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 4 where categoria = 'Diagnostico';
update  ocorrenciasolicitacao set idOccurrenceCategory = 5 where categoria = 'Investigacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 6 where categoria = 'Memorando';
update  ocorrenciasolicitacao set idOccurrenceCategory = 7 where categoria = 'Informacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 8 where categoria = 'Retorno';
update  ocorrenciasolicitacao set idOccurrenceCategory = 9 where categoria = 'Sintoma';
update  ocorrenciasolicitacao set idOccurrenceCategory = 10 where categoria = 'Contorno';
update  ocorrenciasolicitacao set idOccurrenceCategory = 11 where categoria = 'Execucao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 12 where categoria = 'MudancaSLA';
update  ocorrenciasolicitacao set idOccurrenceCategory = 13 where categoria = 'Reclassificacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 14 where categoria = 'Agendamento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 15 where categoria = 'Suspensao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 16 where categoria = 'Reativacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 17 where categoria = 'Encerramento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 18 where categoria = 'Reabertura';
update  ocorrenciasolicitacao set idOccurrenceCategory = 19 where categoria = 'Direcionamento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 20 where categoria = 'Compartilhamento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 21 where categoria = 'CancelamentoTarefa';
update  ocorrenciasolicitacao set idOccurrenceCategory = 22 where categoria = 'InicioSLA';
update  ocorrenciasolicitacao set idOccurrenceCategory = 23 where categoria = 'SuspensaoSLA';
update  ocorrenciasolicitacao set idOccurrenceCategory = 24 where categoria = 'Aprovar';
update  ocorrenciasolicitacao set idOccurrenceCategory = 25 where categoria = 'ReativacaoSLA';
update  ocorrenciasolicitacao set idOccurrenceCategory = 26 where categoria = 'Outras';

-- Situao em invocacao
alter table invocacao add column idstatus smallint;
update invocacao set idstatus = 1 where situacao = 'EmAndamento';
update invocacao set idstatus = 2 where situacao = 'Suspensa';
update invocacao set idstatus = 3 where situacao = 'Cancelada';
update invocacao set idstatus = 4 where situacao = 'Resolvida';
update invocacao set idstatus = 5 where situacao = 'Reaberta';
update invocacao set idstatus = 6 where situacao = 'Fechada';
update invocacao set idstatus = 7 where situacao = 'ReClassificada';
alter table invocacao modify idstatus smallint not null;
alter table invocacao modify situacao varchar(20);

-- Situao em auditoriacontinvocacao
alter table auditoriacontinvocacao add column idstatus smallint;
update auditoriacontinvocacao set idstatus = 1 where situacao = 'EmAndamento';
update auditoriacontinvocacao set idstatus = 2 where situacao = 'Suspensa';
update auditoriacontinvocacao set idstatus = 3 where situacao = 'Cancelada';
update auditoriacontinvocacao set idstatus = 4 where situacao = 'Resolvida';
update auditoriacontinvocacao set idstatus = 5 where situacao = 'Reaberta';
update auditoriacontinvocacao set idstatus = 6 where situacao = 'Fechada';
update auditoriacontinvocacao set idstatus = 7 where situacao = 'ReClassificada';
alter table auditoriacontinvocacao modify idstatus smallint not null;
alter table auditoriacontinvocacao modify situacao varchar(20);

-- status em problema
alter table problema add column idstatus smallint;
update problema set idstatus = 1 where status = 'Registrada';
update problema set idstatus = 2 where status = 'Em andamento';
update problema set idstatus = 3 where status = 'Aprovada';
update problema set idstatus = 4 where status = 'Planejada';
update problema set idstatus = 5 where status = 'Em execuo';
update problema set idstatus = 6 where status = 'Executada';
update problema set idstatus = 7 where status = 'Suspensa';
update problema set idstatus = 8 where status = 'Cancelada';
update problema set idstatus = 9 where status = 'Rejeitada';
update problema set idstatus = 10 where status = 'Resolvida';
update problema set idstatus = 11 where status = 'Reaberta';
update problema set idstatus = 12 where status = 'Reclassificada';
update problema set idstatus = 13 where status = 'Fechada';
update problema set idstatus = 14 where status = 'Concluda';
update problema set idstatus = 15 where status = 'Em Investigao';
update problema set idstatus = 16 where status = 'Soluo de Contorno';
update problema set idstatus = 17 where status = 'Revisado';
update problema set idstatus = 18 where status = 'Resoluo';
update problema set idstatus = 19 where status = 'Encerramento';
update problema set idstatus = 20 where status = 'Revisar';
update problema set idstatus = 21 where status = 'Registro de Erro Conhecido';
alter table problema modify idstatus smallint not null;
alter table problema modify status varchar(40);

-- status em ocorrenciaproblema
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Registrada"','"status":"Registrada","idStatus":1');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Em andamento"','"status":"Em andamento","idStatus":2');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Aprovada"','"status":"Aprovada","idStatus":3');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Planejada"','"status":"Planejada","idStatus":4');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Em execuo"','"status":"Em execuo","idStatus":5');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Executada"','"status":"Executada","idStatus":6');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Suspensa"','"status":"Suspensa","idStatus":7');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Cancelada"','"status":"Cancelada","idStatus":8');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Rejeitada"','"status":"Rejeitada","idStatus":9');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Resolvida"','"status":"Resolvida","idStatus":10');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Reaberta"','"status":"Reaberta","idStatus":11');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Reclassificada"','"status":"Reclassificada","idStatus":12');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Fechada"','"status":"Fechada","idStatus":13');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Concluda"','"status":"Concluda","idStatus":14');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Em Investigao"','"status":"Em Investigao","idStatus":15');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Soluo de Contorno"','"status":"Soluo de Contorno","idStatus":16');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Revisado"','"status":"Revisado","idStatus":17');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Resoluo"','"status":"Resoluo","idStatus":18');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Encerramento"','"status":"Encerramento","idStatus":19');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Revisar"','"status":"Revisar","idStatus":20');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"status":"Registro de Erro Conhecido"','"status":"Registro de Erro Conhecido","idStatus":21');

-- fase em problema
alter table problema add column idphase smallint;
update problema set idphase = 1 where fase = 'Registrada';
update problema set idphase = 2 where fase = 'Aprovao';
update problema set idphase = 3 where fase = 'Planejamento';
update problema set idphase = 4 where fase = 'Execuo';
update problema set idphase = 5 where fase = 'Avaliao';
update problema set idphase = 6 where fase = 'Em Investigao';
update problema set idphase = 7 where fase = 'Soluo de Contorno';
update problema set idphase = 8 where fase = 'Revisado';
update problema set idphase = 9 where fase = 'Resoluo';
update problema set idphase = 10 where fase = 'Encerramento';
update problema set idphase = 11 where fase = 'Revisar';
update problema set idphase = 12 where fase = 'Registro de Erro Conhecido';

-- fase em ocorrenciaproblema
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Registrada"','"fase":"Registrada","idPhase":1');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Aprovao"','"fase":"Aprovao","idPhase":2');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Aprovacao"','"fase":"Aprovacao","idPhase":2');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Planejamento"','"fase":"Planejamento","idPhase":3');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Execuo"','"fase":"Execuo","idPhase":4');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Execucao"','"fase":"Execucao","idPhase":4');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Avaliao"','"fase":"Avaliao","idPhase":5');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Avaliacao"','"fase":"Avaliacao","idPhase":5');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Em Investigao"','"fase":"Em Investigao","idPhase":6');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"EmInvestigacao"','"fase":"EmInvestigacao","idPhase":6');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Soluo de Contorno"','"fase":"Soluo de Contorno","idPhase":7');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"SolucaoContorno"','"fase":"SolucaoContorno","idPhase":7');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Revisado"','"fase":"Revisado","idPhase":8');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Resoluo"','"fase":"Resoluo","idPhase":9');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Resolucao"','"fase":"Resolucao","idPhase":9');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Encerramento"','"fase":"Encerramento","idPhase":10');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Revisar"','"fase":"Revisar","idPhase":11');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"Registro de Erro Conhecido"','"fase":"Registro de Erro Conhecido","idPhase":12');
update ocorrenciaproblema set dadosproblema = replace(dadosproblema,'"fase":"RegistroErroConhecido"','"fase":"RegistroErroConhecido","idPhase":12');

-- categoria em ocorrenciaproblema
alter table ocorrenciaproblema add column idOccurrenceCategory smallint;
update ocorrenciaproblema set idOccurrenceCategory = 1 where categoria = 'Criacao';
update ocorrenciaproblema set idOccurrenceCategory = 2 where categoria = 'Acompanhamento';
update ocorrenciaproblema set idOccurrenceCategory = 3 where categoria = 'Atualizacao';
update ocorrenciaproblema set idOccurrenceCategory = 4 where categoria = 'Diagnostico';
update ocorrenciaproblema set idOccurrenceCategory = 5 where categoria = 'Investigacao';
update ocorrenciaproblema set idOccurrenceCategory = 6 where categoria = 'Memorando';
update ocorrenciaproblema set idOccurrenceCategory = 7 where categoria = 'Informacao';
update ocorrenciaproblema set idOccurrenceCategory = 8 where categoria = 'Retorno';
update ocorrenciaproblema set idOccurrenceCategory = 9 where categoria = 'Sintoma';
update ocorrenciaproblema set idOccurrenceCategory = 10 where categoria = 'Contorno';
update ocorrenciaproblema set idOccurrenceCategory = 11 where categoria = 'Execucao';
update ocorrenciaproblema set idOccurrenceCategory = 12 where categoria = 'MudancaSLA';
update ocorrenciaproblema set idOccurrenceCategory = 13 where categoria = 'Reclassificacao';
update ocorrenciaproblema set idOccurrenceCategory = 14 where categoria = 'Agendamento';
update ocorrenciaproblema set idOccurrenceCategory = 15 where categoria = 'Suspensao';
update ocorrenciaproblema set idOccurrenceCategory = 16 where categoria = 'Reativacao';
update ocorrenciaproblema set idOccurrenceCategory = 17 where categoria = 'Encerramento';
update ocorrenciaproblema set idOccurrenceCategory = 18 where categoria = 'Reabertura';
update ocorrenciaproblema set idOccurrenceCategory = 19 where categoria = 'Direcionamento';
update ocorrenciaproblema set idOccurrenceCategory = 20 where categoria = 'Compartilhamento';
update ocorrenciaproblema set idOccurrenceCategory = 21 where categoria = 'CancelamentoTarefa';
update ocorrenciaproblema set idOccurrenceCategory = 22 where categoria = 'InicioSLA';
update ocorrenciaproblema set idOccurrenceCategory = 23 where categoria = 'SuspensaoSLA';
update ocorrenciaproblema set idOccurrenceCategory = 24 where categoria = 'Aprovar';
update ocorrenciaproblema set idOccurrenceCategory = 25 where categoria = 'ReativacaoSLA';
update ocorrenciaproblema set idOccurrenceCategory = 26 where categoria = 'Outras';

-- status em liberacao
alter table liberacao add column idstatus smallint;
update liberacao set idstatus = 1 where status = 'Registrada';
update liberacao set idstatus = 2 where status = 'NaoResolvida';
update liberacao set idstatus = 3 where status = 'Aprovada';
update liberacao set idstatus = 4 where status = 'Planejada';
update liberacao set idstatus = 5 where status = 'EmExecucao';
update liberacao set idstatus = 6 where status = 'Executada';
update liberacao set idstatus = 7 where status = 'Suspensa';
update liberacao set idstatus = 8 where status = 'Cancelada';
update liberacao set idstatus = 9 where status = 'Rejeitada';
update liberacao set idstatus = 10 where status = 'Resolvida';
update liberacao set idstatus = 11 where status = 'Reaberta';
update liberacao set idstatus = 12 where status = 'Fechada';
update liberacao set idstatus = 13 where status = 'Concluida';
alter table liberacao modify idstatus smallint not null;
alter table liberacao modify status varchar(45);
alter table liberacao modify situacao char(1);

alter table historicoliberacao add column idstatus smallint;
update historicoliberacao set idstatus = 1 where status = 'Registrada';
update historicoliberacao set idstatus = 2 where status = 'NaoResolvida';
update historicoliberacao set idstatus = 3 where status = 'Aprovada';
update historicoliberacao set idstatus = 4 where status = 'Planejada';
update historicoliberacao set idstatus = 5 where status = 'EmExecucao';
update historicoliberacao set idstatus = 6 where status = 'Executada';
update historicoliberacao set idstatus = 7 where status = 'Suspensa';
update historicoliberacao set idstatus = 8 where status = 'Cancelada';
update historicoliberacao set idstatus = 9 where status = 'Rejeitada';
update historicoliberacao set idstatus = 10 where status = 'Resolvida';
update historicoliberacao set idstatus = 11 where status = 'Reaberta';
update historicoliberacao set idstatus = 12 where status = 'Fechada';
update historicoliberacao set idstatus = 13 where status = 'Concluida';
alter table historicoliberacao modify idstatus smallint not null;
alter table historicoliberacao modify status varchar(45);
alter table historicoliberacao modify situacao char(1);

-- status em ocorrencialiberacao
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Registrada"','"status":"Registrada","idStatus":1');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"NaoResolvida"','"status":"NaoResolvida","idStatus":2');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Aprovada"','"status":"Aprovada","idStatus":3');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Planejada"','"status":"Planejada","idStatus":4');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"EmExecucao"','"status":"EmExecucao","idStatus":5');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Executada"','"status":"Executada","idStatus":6');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Suspensa"','"status":"Suspensa","idStatus":7');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Cancelada"','"status":"Cancelada","idStatus":8');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Rejeitada"','"status":"Rejeitada","idStatus":9');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Resolvida"','"status":"Resolvida","idStatus":10');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Reaberta"','"status":"Reaberta","idStatus":11');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Fechada"','"status":"Fechada","idStatus":12');
update ocorrencialiberacao set dadosliberacao = replace(dadosliberacao,'"status":"Concluida"','"status":"Concluida","idStatus":13');

-- categoria em ocorrencialiberacao
alter table ocorrencialiberacao add column idOccurrenceCategory smallint;
update ocorrencialiberacao set idOccurrenceCategory = 1 where categoria = 'Criacao';
update ocorrencialiberacao set idOccurrenceCategory = 2 where categoria = 'Acompanhamento';
update ocorrencialiberacao set idOccurrenceCategory = 3 where categoria = 'Atualizacao';
update ocorrencialiberacao set idOccurrenceCategory = 4 where categoria = 'Diagnostico';
update ocorrencialiberacao set idOccurrenceCategory = 5 where categoria = 'Investigacao';
update ocorrencialiberacao set idOccurrenceCategory = 6 where categoria = 'Memorando';
update ocorrencialiberacao set idOccurrenceCategory = 7 where categoria = 'Informacao';
update ocorrencialiberacao set idOccurrenceCategory = 8 where categoria = 'Retorno';
update ocorrencialiberacao set idOccurrenceCategory = 9 where categoria = 'Sintoma';
update ocorrencialiberacao set idOccurrenceCategory = 10 where categoria = 'Contorno';
update ocorrencialiberacao set idOccurrenceCategory = 11 where categoria = 'Execucao';
update ocorrencialiberacao set idOccurrenceCategory = 12 where categoria = 'MudancaSLA';
update ocorrencialiberacao set idOccurrenceCategory = 13 where categoria = 'Reclassificacao';
update ocorrencialiberacao set idOccurrenceCategory = 14 where categoria = 'Agendamento';
update ocorrencialiberacao set idOccurrenceCategory = 15 where categoria = 'Suspensao';
update ocorrencialiberacao set idOccurrenceCategory = 16 where categoria = 'Reativacao';
update ocorrencialiberacao set idOccurrenceCategory = 17 where categoria = 'Encerramento';
update ocorrencialiberacao set idOccurrenceCategory = 18 where categoria = 'Reabertura';
update ocorrencialiberacao set idOccurrenceCategory = 19 where categoria = 'Direcionamento';
update ocorrencialiberacao set idOccurrenceCategory = 20 where categoria = 'Compartilhamento';
update ocorrencialiberacao set idOccurrenceCategory = 21 where categoria = 'CancelamentoTarefa';
update ocorrencialiberacao set idOccurrenceCategory = 22 where categoria = 'InicioSLA';
update ocorrencialiberacao set idOccurrenceCategory = 23 where categoria = 'SuspensaoSLA';
update ocorrencialiberacao set idOccurrenceCategory = 24 where categoria = 'Aprovar';
update ocorrencialiberacao set idOccurrenceCategory = 25 where categoria = 'ReativacaoSLA';
update ocorrencialiberacao set idOccurrenceCategory = 26 where categoria = 'Outras';

-- situacaoliberacao em liberacaomudanca
alter table liberacaomudanca add column idReleaseStatus smallint;
update liberacaomudanca set idReleaseStatus = 1 where situacaoLiberacao = 'Registrada';
update liberacaomudanca set idReleaseStatus = 2 where situacaoLiberacao = 'NaoResolvida';
update liberacaomudanca set idReleaseStatus = 2 where situacaoLiberacao = 'No Resolvida';
update liberacaomudanca set idReleaseStatus = 3 where situacaoLiberacao = 'Aprovada';
update liberacaomudanca set idReleaseStatus = 4 where situacaoLiberacao = 'Planejada';
update liberacaomudanca set idReleaseStatus = 5 where situacaoLiberacao = 'EmExecucao';
update liberacaomudanca set idReleaseStatus = 5 where situacaoLiberacao = 'Em Execuo';
update liberacaomudanca set idReleaseStatus = 5 where situacaoLiberacao = 'Em execuo';
update liberacaomudanca set idReleaseStatus = 6 where situacaoLiberacao = 'Executada';
update liberacaomudanca set idReleaseStatus = 7 where situacaoLiberacao = 'Suspensa';
update liberacaomudanca set idReleaseStatus = 8 where situacaoLiberacao = 'Cancelada';
update liberacaomudanca set idReleaseStatus = 9 where situacaoLiberacao = 'Rejeitada';
update liberacaomudanca set idReleaseStatus = 10 where situacaoLiberacao = 'Resolvida';
update liberacaomudanca set idReleaseStatus = 11 where situacaoLiberacao = 'Reaberta';
update liberacaomudanca set idReleaseStatus = 12 where situacaoLiberacao = 'Fechada';
update liberacaomudanca set idReleaseStatus = 13 where situacaoLiberacao = 'Concluida';

-- status em requisicaomudanca
alter table requisicaomudanca add column idstatus smallint;
update requisicaomudanca set idstatus = 1 where status = 'Registrada';
update requisicaomudanca set idstatus = 2 where status = 'Proposta';
update requisicaomudanca set idstatus = 2 where status = 'Aguardando Aprovao';
update requisicaomudanca set idstatus = 3 where status = 'Aprovada';
update requisicaomudanca set idstatus = 4 where status = 'Planejada';
update requisicaomudanca set idstatus = 5 where status = 'EmExecucao';
update requisicaomudanca set idstatus = 5 where status = 'Em Execuo';
update requisicaomudanca set idstatus = 5 where status = 'Em execuo';
update requisicaomudanca set idstatus = 6 where status = 'Executada';
update requisicaomudanca set idstatus = 7 where status = 'Suspensa';
update requisicaomudanca set idstatus = 8 where status = 'Cancelada';
update requisicaomudanca set idstatus = 9 where status = 'Rejeitada';
update requisicaomudanca set idstatus = 10 where status = 'Resolvida';
update requisicaomudanca set idstatus = 11 where status = 'Reaberta';
update requisicaomudanca set idstatus = 12 where status = 'Concluida';
update requisicaomudanca set idstatus = 12 where status = 'Concluda';
alter table requisicaomudanca modify idstatus smallint not null;
alter table requisicaomudanca modify status varchar(45);

delete from scripts where sqlquery like '%historicomudanca%idstatus%';

alter table historicomudanca add column idstatus smallint;
update historicomudanca set idstatus = 1 where status = 'Registrada';
update historicomudanca set idstatus = 2 where status = 'Proposta';
update historicomudanca set idstatus = 2 where status = 'Aguardando Aprovao';
update historicomudanca set idstatus = 3 where status = 'Aprovada';
update historicomudanca set idstatus = 4 where status = 'Planejada';
update historicomudanca set idstatus = 5 where status = 'EmExecucao';
update historicomudanca set idstatus = 5 where status = 'Em Execuo';
update historicomudanca set idstatus = 5 where status = 'Em execuo';
update historicomudanca set idstatus = 6 where status = 'Executada';
update historicomudanca set idstatus = 7 where status = 'Suspensa';
update historicomudanca set idstatus = 8 where status = 'Cancelada';
update historicomudanca set idstatus = 9 where status = 'Rejeitada';
update historicomudanca set idstatus = 10 where status = 'Resolvida';
update historicomudanca set idstatus = 11 where status = 'Reaberta';
update historicomudanca set idstatus = 12 where status = 'Concluida';
update historicomudanca set idstatus = 12 where status = 'Concluda';
alter table historicomudanca modify idstatus smallint not null;
alter table historicomudanca modify status varchar(45);

-- status em  ocorrenciamudanca
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Registrada"','"status":"Registrada","idStatus":1');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Proposta"','"status":"Proposta","idStatus":2');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Aguardando Aprovao"','"status":"Aguardando Aprovao","idStatus":2');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Aprovada"','"status":"Aprovada","idStatus":3');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Planejada"','"status":"Planejada","idStatus":4');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"EmExecucao"','"status":"EmExecucao","idStatus":5');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Em Execuo"','"status":"Em Execuo","idStatus":5');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Em execuo"','"status":"Em execuo","idStatus":5');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Executada"','"status":"Executada","idStatus":6');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Suspensa"','"status":"Suspensa","idStatus":7');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Cancelada"','"status":"Cancelada","idStatus":8');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Rejeitada"','"status":"Rejeitada","idStatus":9');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Resolvida"','"status":"Resolvida","idStatus":10');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Reaberta"','"status":"Reaberta","idStatus":11');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Concluida"','"status":"Concluida","idStatus":12');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"status":"Concluda"','"status":"Concluda","idStatus":12');

-- fase em requisicaomudanca
alter table requisicaomudanca add column idphase smallint;
update requisicaomudanca set idphase = 1 where fase = 'Registrada';
update requisicaomudanca set idphase = 2 where fase = 'Proposta';
update requisicaomudanca set idphase = 3 where fase = 'Aprovacao';
update requisicaomudanca set idphase = 3 where fase = 'Aprovao';
update requisicaomudanca set idphase = 4 where fase = 'Planejamento';
update requisicaomudanca set idphase = 5 where fase = 'Execucao';
update requisicaomudanca set idphase = 5 where fase = 'Execuo';
update requisicaomudanca set idphase = 6 where fase = 'Avaliacao';
update requisicaomudanca set idphase = 6 where fase = 'Avaliao';

alter table historicomudanca add column idphase smallint;
update historicomudanca set idphase = 1 where fase = 'Registrada';
update historicomudanca set idphase = 2 where fase = 'Proposta';
update historicomudanca set idphase = 3 where fase = 'Aprovacao';
update historicomudanca set idphase = 3 where fase = 'Aprovao';
update historicomudanca set idphase = 4 where fase = 'Planejamento';
update historicomudanca set idphase = 5 where fase = 'Execucao';
update historicomudanca set idphase = 5 where fase = 'Execuo';
update historicomudanca set idphase = 6 where fase = 'Avaliacao';
update historicomudanca set idphase = 6 where fase = 'Avaliao';

-- fase em  ocorrenciamudanca
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"fase":"Registrada"','"fase":"Registrada","idPhase":1');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"fase":"Proposta"','"fase":"Proposta","idPhase":2');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"fase":"Aprovacao"','"fase":"Aprovacao","idPhase":3');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"fase":"Aprovao"','"fase":"Aprovao","idPhase":3');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"fase":"Planejamento"','"fase":"Planejamento","idPhase":4');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"fase":"Execucao"','"fase":"Execucao","idPhase":5');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"fase":"Execuo"','"fase":"Execuo","idPhase":5');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"fase":"Avaliacao"','"fase":"Avaliacao","idPhase":6');
update  ocorrenciamudanca set dadosmudanca = replace(dadosmudanca,'"fase":"Avaliao"','"fase":"Avaliao","idPhase":6');

-- categoria em  ocorrenciamudanca
alter table  ocorrenciamudanca add column idOccurrenceCategory smallint;
update  ocorrenciamudanca set idOccurrenceCategory = 1 where categoria = 'Criacao';
update  ocorrenciamudanca set idOccurrenceCategory = 2 where categoria = 'Acompanhamento';
update  ocorrenciamudanca set idOccurrenceCategory = 3 where categoria = 'Atualizacao';
update  ocorrenciamudanca set idOccurrenceCategory = 4 where categoria = 'Diagnostico';
update  ocorrenciamudanca set idOccurrenceCategory = 5 where categoria = 'Investigacao';
update  ocorrenciamudanca set idOccurrenceCategory = 6 where categoria = 'Memorando';
update  ocorrenciamudanca set idOccurrenceCategory = 7 where categoria = 'Informacao';
update  ocorrenciamudanca set idOccurrenceCategory = 8 where categoria = 'Retorno';
update  ocorrenciamudanca set idOccurrenceCategory = 9 where categoria = 'Sintoma';
update  ocorrenciamudanca set idOccurrenceCategory = 10 where categoria = 'Contorno';
update  ocorrenciamudanca set idOccurrenceCategory = 11 where categoria = 'Execucao';
update  ocorrenciamudanca set idOccurrenceCategory = 12 where categoria = 'MudancaSLA';
update  ocorrenciamudanca set idOccurrenceCategory = 13 where categoria = 'Reclassificacao';
update  ocorrenciamudanca set idOccurrenceCategory = 14 where categoria = 'Agendamento';
update  ocorrenciamudanca set idOccurrenceCategory = 15 where categoria = 'Suspensao';
update  ocorrenciamudanca set idOccurrenceCategory = 16 where categoria = 'Reativacao';
update  ocorrenciamudanca set idOccurrenceCategory = 17 where categoria = 'Encerramento';
update  ocorrenciamudanca set idOccurrenceCategory = 18 where categoria = 'Reabertura';
update  ocorrenciamudanca set idOccurrenceCategory = 19 where categoria = 'Direcionamento';
update  ocorrenciamudanca set idOccurrenceCategory = 20 where categoria = 'Compartilhamento';
update  ocorrenciamudanca set idOccurrenceCategory = 21 where categoria = 'CancelamentoTarefa';
update  ocorrenciamudanca set idOccurrenceCategory = 22 where categoria = 'InicioSLA';
update  ocorrenciamudanca set idOccurrenceCategory = 23 where categoria = 'SuspensaoSLA';
update  ocorrenciamudanca set idOccurrenceCategory = 24 where categoria = 'Aprovar';
update  ocorrenciamudanca set idOccurrenceCategory = 25 where categoria = 'ReativacaoSLA';
update  ocorrenciamudanca set idOccurrenceCategory = 26 where categoria = 'Outras';

set net_read_timeout=600;
set sql_safe_updates = 1;