-- Tipo de elemento em bpm_elementofluxo
alter table bpm_elementofluxo add idtype smallint;
alter table bpm_elementofluxo add idsubtype smallint;
update bpm_elementofluxo set idtype = 1 where tipoelemento = 'Inicio';
update bpm_elementofluxo set idtype = 2 where tipoelemento = 'Tarefa';
update bpm_elementofluxo set idtype = 3 where tipoelemento = 'Script';
update bpm_elementofluxo set idtype = 4 where tipoelemento = 'Email';
update bpm_elementofluxo set idtype = 5 where tipoelemento = 'Porta';
update bpm_elementofluxo set idtype = 6 where tipoelemento = 'Evento';
update bpm_elementofluxo set idtype = 7 where tipoelemento = 'Finalizacao';
update bpm_elementofluxo set idsubtype = 1 where subtipo = 'Decisao';
update bpm_elementofluxo set idsubtype = 2 where subtipo = 'Paralela';
update bpm_elementofluxo set idsubtype = 3 where subtipo = 'Convergente';
alter table bpm_elementofluxo alter column idtype smallint not null;
alter table bpm_elementofluxo alter column tipoelemento varchar(20) null;

-- Ao em bpm_historicoitemtrabalho
alter table bpm_historicoitemtrabalho add idaction smallint;
update bpm_historicoitemtrabalho set idaction = 1 where acao = 'Iniciar';
update bpm_historicoitemtrabalho set idaction = 2 where acao = 'Executar';
update bpm_historicoitemtrabalho set idaction = 3 where acao = 'Delegar';
update bpm_historicoitemtrabalho set idaction = 4 where acao = 'Suspender';
update bpm_historicoitemtrabalho set idaction = 5 where acao = 'Cancelar';
alter table bpm_historicoitemtrabalho alter column idaction smallint not null;
alter table bpm_historicoitemtrabalho alter column acao varchar(10) null;

-- Situao em bpm_instanciafluxo
alter table bpm_instanciafluxo add idstatus smallint;
update bpm_instanciafluxo set idstatus = 1 where situacao = 'Aberta';
update bpm_instanciafluxo set idstatus = 2 where situacao = 'Suspensa';
update bpm_instanciafluxo set idstatus = 3 where situacao = 'Cancelada';
update bpm_instanciafluxo set idstatus = 4 where situacao = 'Encerrada';
alter table bpm_instanciafluxo alter column idstatus smallint not null;
alter table bpm_instanciafluxo alter column situacao varchar(20) null;

-- Situao em bpm_itemtrabalhofluxo
alter table bpm_itemtrabalhofluxo add idstatus smallint;
update bpm_itemtrabalhofluxo set idstatus = 1 where situacao = 'Criado';
update bpm_itemtrabalhofluxo set idstatus = 2 where situacao = 'Disponivel';
update bpm_itemtrabalhofluxo set idstatus = 3 where situacao = 'EmAndamento';
update bpm_itemtrabalhofluxo set idstatus = 4 where situacao = 'Suspenso';
update bpm_itemtrabalhofluxo set idstatus = 5 where situacao = 'Cancelado';
update bpm_itemtrabalhofluxo set idstatus = 6 where situacao = 'Encerrado';
update bpm_itemtrabalhofluxo set idstatus = 7 where situacao = 'Executado';
alter table bpm_itemtrabalhofluxo alter column idstatus smallint not null;
create index idx_idStatus ON bpm_itemtrabalhofluxo (idstatus);
drop index bpm_itemtrabalhofluxo.idx_situacao;
alter table bpm_itemtrabalhofluxo alter column situacao varchar(20) null;

-- Tipo de atribuio em bpm_atribuicaofluxo
alter table bpm_atribuicaofluxo add idtype smallint;
update bpm_atribuicaofluxo set idtype = 1 where tipo = 'Automatica';
update bpm_atribuicaofluxo set idtype = 2 where tipo = 'Acompanhamento';
update bpm_atribuicaofluxo set idtype = 3 where tipo = 'Delegacao';
alter table bpm_atribuicaofluxo alter column idtype smallint not null;
create index idx_idtype ON bpm_atribuicaofluxo (idtype);
drop index bpm_atribuicaofluxo.idx_tipo;
alter table bpm_atribuicaofluxo alter column tipo varchar(20) null;

-- Situao em solicitacaoservico
alter table solicitacaoservico add idstatus smallint;
update solicitacaoservico set idstatus = 1 where situacao = 'EmAndamento';
update solicitacaoservico set idstatus = 2 where situacao = 'Suspensa';
update solicitacaoservico set idstatus = 3 where situacao = 'Cancelada';
update solicitacaoservico set idstatus = 4 where situacao = 'Resolvida';
update solicitacaoservico set idstatus = 5 where situacao = 'Reaberta';
update solicitacaoservico set idstatus = 6 where situacao = 'Fechada';
update solicitacaoservico set idstatus = 7 where situacao = 'ReClassificada';
alter table solicitacaoservico alter column idstatus smallint not null;
alter table solicitacaoservico alter column situacao varchar(20) null;

--Situao em ocorrenciasolicitacao
update ocorrenciasolicitacao set  dadossolicitacao = replace(convert(varchar(max), dadossolicitacao),'"situacao":"EmAndamento"','"situacao":"EmAndamento","idStatus":1');
update ocorrenciasolicitacao set  dadossolicitacao = replace(convert(varchar(max), dadossolicitacao),'"situacao":"Suspensa"','"situacao":"Suspensa","idStatus":2');
update ocorrenciasolicitacao set  dadossolicitacao = replace(convert(varchar(max), dadossolicitacao),'"situacao":"Cancelada"','"situacao":"Cancelada","idStatus":3');
update ocorrenciasolicitacao set  dadossolicitacao = replace(convert(varchar(max), dadossolicitacao),'"situacao":"Resolvida"','"situacao":"Resolvida","idStatus":4');
update ocorrenciasolicitacao set  dadossolicitacao = replace(convert(varchar(max), dadossolicitacao),'"situacao":"Reaberta"','"situacao":"Reaberta","idStatus":5');
update ocorrenciasolicitacao set  dadossolicitacao = replace(convert(varchar(max), dadossolicitacao),'"situacao":"Fechada"','"situacao":"Fechada","idStatus":6');
update ocorrenciasolicitacao set  dadossolicitacao = replace(convert(varchar(max), dadossolicitacao),'"situacao":"ReClassificada"','"situacao":"ReClassificada","idStatus":7');

-- categoria em  ocorrenciasolicitacao
alter table  ocorrenciasolicitacao add idOccurrenceCategory smallint;
update  ocorrenciasolicitacao set idOccurrenceCategory = 1 where categoria = 'Criacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 2 where categoria = 'Acompanhamento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 3 where categoria = 'Atualizacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 4 where categoria = 'Diagnostico';
update  ocorrenciasolicitacao set idOccurrenceCategory = 5 where categoria = 'Investigacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 6 where categoria = 'Memorando';
update  ocorrenciasolicitacao set idOccurrenceCategory = 7 where categoria = 'Informacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 8 where categoria = 'Retorno';
update  ocorrenciasolicitacao set idOccurrenceCategory = 9 where categoria = 'Sintoma';
update  ocorrenciasolicitacao set idOccurrenceCategory = 10 where categoria = 'Contorno';
update  ocorrenciasolicitacao set idOccurrenceCategory = 11 where categoria = 'Execucao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 12 where categoria = 'MudancaSLA';
update  ocorrenciasolicitacao set idOccurrenceCategory = 13 where categoria = 'Reclassificacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 14 where categoria = 'Agendamento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 15 where categoria = 'Suspensao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 16 where categoria = 'Reativacao';
update  ocorrenciasolicitacao set idOccurrenceCategory = 17 where categoria = 'Encerramento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 18 where categoria = 'Reabertura';
update  ocorrenciasolicitacao set idOccurrenceCategory = 19 where categoria = 'Direcionamento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 20 where categoria = 'Compartilhamento';
update  ocorrenciasolicitacao set idOccurrenceCategory = 21 where categoria = 'CancelamentoTarefa';
update  ocorrenciasolicitacao set idOccurrenceCategory = 22 where categoria = 'InicioSLA';
update  ocorrenciasolicitacao set idOccurrenceCategory = 23 where categoria = 'SuspensaoSLA';
update  ocorrenciasolicitacao set idOccurrenceCategory = 24 where categoria = 'Aprovar';
update  ocorrenciasolicitacao set idOccurrenceCategory = 25 where categoria = 'ReativacaoSLA';
update  ocorrenciasolicitacao set idOccurrenceCategory = 26 where categoria = 'Outras';

-- Situao em invocacao
alter table invocacao add idstatus smallint;
update invocacao set idstatus = 1 where situacao = 'EmAndamento';
update invocacao set idstatus = 2 where situacao = 'Suspensa';
update invocacao set idstatus = 3 where situacao = 'Cancelada';
update invocacao set idstatus = 4 where situacao = 'Resolvida';
update invocacao set idstatus = 5 where situacao = 'Reaberta';
update invocacao set idstatus = 6 where situacao = 'Fechada';
update invocacao set idstatus = 7 where situacao = 'ReClassificada';
alter table invocacao alter column idstatus smallint not null;
alter table invocacao alter column situacao varchar(20) null;

-- Situao em auditoriacontinvocacao
alter table auditoriacontinvocacao add idstatus smallint;
update auditoriacontinvocacao set idstatus = 1 where situacao = 'EmAndamento';
update auditoriacontinvocacao set idstatus = 2 where situacao = 'Suspensa';
update auditoriacontinvocacao set idstatus = 3 where situacao = 'Cancelada';
update auditoriacontinvocacao set idstatus = 4 where situacao = 'Resolvida';
update auditoriacontinvocacao set idstatus = 5 where situacao = 'Reaberta';
update auditoriacontinvocacao set idstatus = 6 where situacao = 'Fechada';
update auditoriacontinvocacao set idstatus = 7 where situacao = 'ReClassificada';
alter table auditoriacontinvocacao alter column idstatus smallint not null;
alter table auditoriacontinvocacao alter column situacao varchar(20) null;

-- status em problema
alter table problema add idstatus smallint;
update problema set idstatus = 1 where status = 'Registrada';
update problema set idstatus = 2 where status = 'Em andamento';
update problema set idstatus = 3 where status = 'Aprovada';
update problema set idstatus = 4 where status = 'Planejada';
update problema set idstatus = 5 where status = 'Em execuo';
update problema set idstatus = 6 where status = 'Executada';
update problema set idstatus = 7 where status = 'Suspensa';
update problema set idstatus = 8 where status = 'Cancelada';
update problema set idstatus = 9 where status = 'Rejeitada';
update problema set idstatus = 10 where status = 'Resolvida';
update problema set idstatus = 11 where status = 'Reaberta';
update problema set idstatus = 12 where status = 'Reclassificada';
update problema set idstatus = 13 where status = 'Fechada';
update problema set idstatus = 14 where status = 'Concluda';
update problema set idstatus = 15 where status = 'Em Investigao';
update problema set idstatus = 16 where status = 'Soluo de Contorno';
update problema set idstatus = 17 where status = 'Revisado';
update problema set idstatus = 18 where status = 'Resoluo';
update problema set idstatus = 19 where status = 'Encerramento';
update problema set idstatus = 20 where status = 'Revisar';
update problema set idstatus = 21 where status = 'Registro de Erro Conhecido';
alter table problema alter column idstatus smallint not null;
alter table problema alter column status varchar(40) null;

-- status em ocorrenciaproblema
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Registrada"','"status":"Registrada","idStatus":1');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Em andamento"','"status":"Em andamento","idStatus":2');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Aprovada"','"status":"Aprovada","idStatus":3');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Planejada"','"status":"Planejada","idStatus":4');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Em execuo"','"status":"Em execuo","idStatus":5');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Executada"','"status":"Executada","idStatus":6');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Suspensa"','"status":"Suspensa","idStatus":7');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Cancelada"','"status":"Cancelada","idStatus":8');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Rejeitada"','"status":"Rejeitada","idStatus":9');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Resolvida"','"status":"Resolvida","idStatus":10');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Reaberta"','"status":"Reaberta","idStatus":11');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Reclassificada"','"status":"Reclassificada","idStatus":12');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Fechada"','"status":"Fechada","idStatus":13');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Concluda"','"status":"Concluda","idStatus":14');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Em Investigao"','"status":"Em Investigao","idStatus":15');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Soluo de Contorno"','"status":"Soluo de Contorno","idStatus":16');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Revisado"','"status":"Revisado","idStatus":17');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Resoluo"','"status":"Resoluo","idStatus":18');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Encerramento"','"status":"Encerramento","idStatus":19');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Revisar"','"status":"Revisar","idStatus":20');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"status":"Registro de Erro Conhecido"','"status":"Registro de Erro Conhecido","idStatus":21');

-- fase em problema
alter table problema add idphase smallint;
update problema set idphase = 1 where fase = 'Registrada';
update problema set idphase = 2 where fase = 'Aprovao';
update problema set idphase = 3 where fase = 'Planejamento';
update problema set idphase = 4 where fase = 'Execuo';
update problema set idphase = 5 where fase = 'Avaliao';
update problema set idphase = 6 where fase = 'Em Investigao';
update problema set idphase = 7 where fase = 'Soluo de Contorno';
update problema set idphase = 8 where fase = 'Revisado';
update problema set idphase = 9 where fase = 'Resoluo';
update problema set idphase = 10 where fase = 'Encerramento';
update problema set idphase = 11 where fase = 'Revisar';
update problema set idphase = 12 where fase = 'Registro de Erro Conhecido';

-- fase em ocorrenciaproblema
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Registrada"','"fase":"Registrada","idPhase":1');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Aprovao"','"fase":"Aprovao","idPhase":2');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Aprovacao"','"fase":"Aprovacao","idPhase":2');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Planejamento"','"fase":"Planejamento","idPhase":3');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Execuo"','"fase":"Execuo","idPhase":4');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Execucao"','"fase":"Execucao","idPhase":4');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Avaliao"','"fase":"Avaliao","idPhase":5');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Avaliacao"','"fase":"Avaliacao","idPhase":5');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Em Investigao"','"fase":"Em Investigao","idPhase":6');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"EmInvestigacao"','"fase":"EmInvestigacao","idPhase":6');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Soluo de Contorno"','"fase":"Soluo de Contorno","idPhase":7');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"SolucaoContorno"','"fase":"SolucaoContorno","idPhase":7');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Revisado"','"fase":"Revisado","idPhase":8');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Resoluo"','"fase":"Resoluo","idPhase":9');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Resolucao"','"fase":"Resolucao","idPhase":9');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Encerramento"','"fase":"Encerramento","idPhase":10');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Revisar"','"fase":"Revisar","idPhase":11');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"Registro de Erro Conhecido"','"fase":"Registro de Erro Conhecido","idPhase":12');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"fase":"RegistroErroConhecido"','"fase":"RegistroErroConhecido","idPhase":12');

-- fase em ocorrenciaproblema
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Registrada"','"faseAtual":"Registrada","idActualPhase":1');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Aprovao"','"faseAtual":"Aprovao","idActualPhase":2');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Aprovacao"','"faseAtual":"Aprovacao","idActualPhase":2');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Planejamento"','"faseAtual":"Planejamento","idActualPhase":3');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Execuo"','"faseAtual":"Execuo","idActualPhase":4');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Execucao"','"faseAtual":"Execucao","idActualPhase":4');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Avaliao"','"faseAtual":"Avaliao","idActualPhase":5');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Avaliacao"','"faseAtual":"Avaliacao","idActualPhase":5');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Em Investigao"','"faseAtual":"Em Investigao","idActualPhase":6');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"EmInvestigacao"','"faseAtual":"EmInvestigacao","idActualPhase":6');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Soluo de Contorno"','"faseAtual":"Soluo de Contorno","idActualPhase":7');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"SolucaoContorno"','"faseAtual":"SolucaoContorno","idActualPhase":7');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Revisado"','"faseAtual":"Revisado","idActualPhase":8');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Resoluo"','"faseAtual":"Resoluo","idActualPhase":9');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Resolucao"','"faseAtual":"Resolucao","idActualPhase":9');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Encerramento"','"faseAtual":"Encerramento","idActualPhase":10');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Revisar"','"faseAtual":"Revisar","idActualPhase":11');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"Registro de Erro Conhecido"','"faseAtual":"Registro de Erro Conhecido","idActualPhase":12');
update ocorrenciaproblema set dadosproblema = replace(convert(varchar(max), dadosproblema),'"faseAtual":"RegistroErroConhecido"','"faseAtual":"RegistroErroConhecido","idActualPhase":12');

-- categoria em ocorrenciaproblema
alter table ocorrenciaproblema add idOccurrenceCategory smallint;
update ocorrenciaproblema set idOccurrenceCategory = 1 where categoria = 'Criacao';
update ocorrenciaproblema set idOccurrenceCategory = 2 where categoria = 'Acompanhamento';
update ocorrenciaproblema set idOccurrenceCategory = 3 where categoria = 'Atualizacao';
update ocorrenciaproblema set idOccurrenceCategory = 4 where categoria = 'Diagnostico';
update ocorrenciaproblema set idOccurrenceCategory = 5 where categoria = 'Investigacao';
update ocorrenciaproblema set idOccurrenceCategory = 6 where categoria = 'Memorando';
update ocorrenciaproblema set idOccurrenceCategory = 7 where categoria = 'Informacao';
update ocorrenciaproblema set idOccurrenceCategory = 8 where categoria = 'Retorno';
update ocorrenciaproblema set idOccurrenceCategory = 9 where categoria = 'Sintoma';
update ocorrenciaproblema set idOccurrenceCategory = 10 where categoria = 'Contorno';
update ocorrenciaproblema set idOccurrenceCategory = 11 where categoria = 'Execucao';
update ocorrenciaproblema set idOccurrenceCategory = 12 where categoria = 'MudancaSLA';
update ocorrenciaproblema set idOccurrenceCategory = 13 where categoria = 'Reclassificacao';
update ocorrenciaproblema set idOccurrenceCategory = 14 where categoria = 'Agendamento';
update ocorrenciaproblema set idOccurrenceCategory = 15 where categoria = 'Suspensao';
update ocorrenciaproblema set idOccurrenceCategory = 16 where categoria = 'Reativacao';
update ocorrenciaproblema set idOccurrenceCategory = 17 where categoria = 'Encerramento';
update ocorrenciaproblema set idOccurrenceCategory = 18 where categoria = 'Reabertura';
update ocorrenciaproblema set idOccurrenceCategory = 19 where categoria = 'Direcionamento';
update ocorrenciaproblema set idOccurrenceCategory = 20 where categoria = 'Compartilhamento';
update ocorrenciaproblema set idOccurrenceCategory = 21 where categoria = 'CancelamentoTarefa';
update ocorrenciaproblema set idOccurrenceCategory = 22 where categoria = 'InicioSLA';
update ocorrenciaproblema set idOccurrenceCategory = 23 where categoria = 'SuspensaoSLA';
update ocorrenciaproblema set idOccurrenceCategory = 24 where categoria = 'Aprovar';
update ocorrenciaproblema set idOccurrenceCategory = 25 where categoria = 'ReativacaoSLA';
update ocorrenciaproblema set idOccurrenceCategory = 26 where categoria = 'Outras';

-- status em liberacao
alter table liberacao add idstatus smallint;
update liberacao set idstatus = 1 where status = 'Registrada';
update liberacao set idstatus = 2 where status = 'NaoResolvida';
update liberacao set idstatus = 3 where status = 'Aprovada';
update liberacao set idstatus = 4 where status = 'Planejada';
update liberacao set idstatus = 5 where status = 'EmExecucao';
update liberacao set idstatus = 6 where status = 'Executada';
update liberacao set idstatus = 7 where status = 'Suspensa';
update liberacao set idstatus = 8 where status = 'Cancelada';
update liberacao set idstatus = 9 where status = 'Rejeitada';
update liberacao set idstatus = 10 where status = 'Resolvida';
update liberacao set idstatus = 11 where status = 'Reaberta';
update liberacao set idstatus = 12 where status = 'Fechada';
update liberacao set idstatus = 13 where status = 'Concluida';
alter table liberacao alter column idstatus smallint not null;
alter table liberacao alter column status varchar(45) null;
alter table liberacao alter column situacao char(1) null;

alter table historicoliberacao add idstatus smallint;
update historicoliberacao set idstatus = 1 where status = 'Registrada';
update historicoliberacao set idstatus = 2 where status = 'NaoResolvida';
update historicoliberacao set idstatus = 3 where status = 'Aprovada';
update historicoliberacao set idstatus = 4 where status = 'Planejada';
update historicoliberacao set idstatus = 5 where status = 'EmExecucao';
update historicoliberacao set idstatus = 6 where status = 'Executada';
update historicoliberacao set idstatus = 7 where status = 'Suspensa';
update historicoliberacao set idstatus = 8 where status = 'Cancelada';
update historicoliberacao set idstatus = 9 where status = 'Rejeitada';
update historicoliberacao set idstatus = 10 where status = 'Resolvida';
update historicoliberacao set idstatus = 11 where status = 'Reaberta';
update historicoliberacao set idstatus = 12 where status = 'Fechada';
update historicoliberacao set idstatus = 13 where status = 'Concluida';
alter table historicoliberacao alter column idstatus smallint not null;
alter table historicoliberacao alter column status varchar(45) null;
alter table historicoliberacao alter column situacao char(1) null;

-- status em ocorrencialiberacao
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Registrada"','"status":"Registrada","idStatus":1');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"NaoResolvida"','"status":"NaoResolvida","idStatus":2');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Aprovada"','"status":"Aprovada","idStatus":3');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Planejada"','"status":"Planejada","idStatus":4');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"EmExecucao"','"status":"EmExecucao","idStatus":5');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Executada"','"status":"Executada","idStatus":6');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Suspensa"','"status":"Suspensa","idStatus":7');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Cancelada"','"status":"Cancelada","idStatus":8');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Rejeitada"','"status":"Rejeitada","idStatus":9');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Resolvida"','"status":"Resolvida","idStatus":10');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Reaberta"','"status":"Reaberta","idStatus":11');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Fechada"','"status":"Fechada","idStatus":12');
update ocorrencialiberacao set dadosliberacao = replace(convert(varchar(max), dadosliberacao),'"status":"Concluida"','"status":"Concluida","idStatus":13');

-- categoria em ocorrencialiberacao
alter table ocorrencialiberacao add idOccurrenceCategory smallint;
update ocorrencialiberacao set idOccurrenceCategory = 1 where categoria = 'Criacao';
update ocorrencialiberacao set idOccurrenceCategory = 2 where categoria = 'Acompanhamento';
update ocorrencialiberacao set idOccurrenceCategory = 3 where categoria = 'Atualizacao';
update ocorrencialiberacao set idOccurrenceCategory = 4 where categoria = 'Diagnostico';
update ocorrencialiberacao set idOccurrenceCategory = 5 where categoria = 'Investigacao';
update ocorrencialiberacao set idOccurrenceCategory = 6 where categoria = 'Memorando';
update ocorrencialiberacao set idOccurrenceCategory = 7 where categoria = 'Informacao';
update ocorrencialiberacao set idOccurrenceCategory = 8 where categoria = 'Retorno';
update ocorrencialiberacao set idOccurrenceCategory = 9 where categoria = 'Sintoma';
update ocorrencialiberacao set idOccurrenceCategory = 10 where categoria = 'Contorno';
update ocorrencialiberacao set idOccurrenceCategory = 11 where categoria = 'Execucao';
update ocorrencialiberacao set idOccurrenceCategory = 12 where categoria = 'MudancaSLA';
update ocorrencialiberacao set idOccurrenceCategory = 13 where categoria = 'Reclassificacao';
update ocorrencialiberacao set idOccurrenceCategory = 14 where categoria = 'Agendamento';
update ocorrencialiberacao set idOccurrenceCategory = 15 where categoria = 'Suspensao';
update ocorrencialiberacao set idOccurrenceCategory = 16 where categoria = 'Reativacao';
update ocorrencialiberacao set idOccurrenceCategory = 17 where categoria = 'Encerramento';
update ocorrencialiberacao set idOccurrenceCategory = 18 where categoria = 'Reabertura';
update ocorrencialiberacao set idOccurrenceCategory = 19 where categoria = 'Direcionamento';
update ocorrencialiberacao set idOccurrenceCategory = 20 where categoria = 'Compartilhamento';
update ocorrencialiberacao set idOccurrenceCategory = 21 where categoria = 'CancelamentoTarefa';
update ocorrencialiberacao set idOccurrenceCategory = 22 where categoria = 'InicioSLA';
update ocorrencialiberacao set idOccurrenceCategory = 23 where categoria = 'SuspensaoSLA';
update ocorrencialiberacao set idOccurrenceCategory = 24 where categoria = 'Aprovar';
update ocorrencialiberacao set idOccurrenceCategory = 25 where categoria = 'ReativacaoSLA';
update ocorrencialiberacao set idOccurrenceCategory = 26 where categoria = 'Outras';

-- situacaoliberacao em liberacaomudanca
alter table liberacaomudanca add idReleaseStatus smallint;
update liberacaomudanca set idReleaseStatus = 1 where situacaoLiberacao = 'Registrada';
update liberacaomudanca set idReleaseStatus = 2 where situacaoLiberacao = 'NaoResolvida';
update liberacaomudanca set idReleaseStatus = 2 where situacaoLiberacao = 'No Resolvida';
update liberacaomudanca set idReleaseStatus = 3 where situacaoLiberacao = 'Aprovada';
update liberacaomudanca set idReleaseStatus = 4 where situacaoLiberacao = 'Planejada';
update liberacaomudanca set idReleaseStatus = 5 where situacaoLiberacao = 'EmExecucao';
update liberacaomudanca set idReleaseStatus = 5 where situacaoLiberacao = 'Em Execuo';
update liberacaomudanca set idReleaseStatus = 5 where situacaoLiberacao = 'Em execuo';
update liberacaomudanca set idReleaseStatus = 6 where situacaoLiberacao = 'Executada';
update liberacaomudanca set idReleaseStatus = 7 where situacaoLiberacao = 'Suspensa';
update liberacaomudanca set idReleaseStatus = 8 where situacaoLiberacao = 'Cancelada';
update liberacaomudanca set idReleaseStatus = 9 where situacaoLiberacao = 'Rejeitada';
update liberacaomudanca set idReleaseStatus = 10 where situacaoLiberacao = 'Resolvida';
update liberacaomudanca set idReleaseStatus = 11 where situacaoLiberacao = 'Reaberta';
update liberacaomudanca set idReleaseStatus = 12 where situacaoLiberacao = 'Fechada';
update liberacaomudanca set idReleaseStatus = 13 where situacaoLiberacao = 'Concluida';

-- status em requisicaomudanca
alter table requisicaomudanca add idstatus smallint;
update requisicaomudanca set idstatus = 1 where status = 'Registrada';
update requisicaomudanca set idstatus = 2 where status = 'Proposta';
update requisicaomudanca set idstatus = 2 where status = 'Aguardando Aprovao';
update requisicaomudanca set idstatus = 3 where status = 'Aprovada';
update requisicaomudanca set idstatus = 4 where status = 'Planejada';
update requisicaomudanca set idstatus = 5 where status = 'EmExecucao';
update requisicaomudanca set idstatus = 5 where status = 'Em Execuo';
update requisicaomudanca set idstatus = 5 where status = 'Em execuo';
update requisicaomudanca set idstatus = 6 where status = 'Executada';
update requisicaomudanca set idstatus = 7 where status = 'Suspensa';
update requisicaomudanca set idstatus = 8 where status = 'Cancelada';
update requisicaomudanca set idstatus = 9 where status = 'Rejeitada';
update requisicaomudanca set idstatus = 10 where status = 'Resolvida';
update requisicaomudanca set idstatus = 11 where status = 'Reaberta';
update requisicaomudanca set idstatus = 12 where status = 'Concluida';
update requisicaomudanca set idstatus = 12 where status = 'Concluda';
alter table requisicaomudanca alter column idstatus smallint not null;
alter table requisicaomudanca alter column status varchar(45) null;

delete from scripts where sqlquery like '%historicomudanca%idstatus%';

alter table historicomudanca add idstatus smallint;
update historicomudanca set idstatus = 1 where status = 'Registrada';
update historicomudanca set idstatus = 2 where status = 'Proposta';
update historicomudanca set idstatus = 2 where status = 'Aguardando Aprovao';
update historicomudanca set idstatus = 3 where status = 'Aprovada';
update historicomudanca set idstatus = 4 where status = 'Planejada';
update historicomudanca set idstatus = 5 where status = 'EmExecucao';
update historicomudanca set idstatus = 5 where status = 'Em Execuo';
update historicomudanca set idstatus = 5 where status = 'Em execuo';
update historicomudanca set idstatus = 6 where status = 'Executada';
update historicomudanca set idstatus = 7 where status = 'Suspensa';
update historicomudanca set idstatus = 8 where status = 'Cancelada';
update historicomudanca set idstatus = 9 where status = 'Rejeitada';
update historicomudanca set idstatus = 10 where status = 'Resolvida';
update historicomudanca set idstatus = 11 where status = 'Reaberta';
update historicomudanca set idstatus = 12 where status = 'Concluida';
update historicomudanca set idstatus = 12 where status = 'Concluda';
alter table historicomudanca alter column idstatus smallint not null;
alter table historicomudanca alter column status varchar(45) null;

-- status em  ocorrenciamudanca
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Registrada"','"status":"Registrada","idStatus":1');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Proposta"','"status":"Proposta","idStatus":2');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Aguardando Aprovao"','"status":"Aguardando Aprovao","idStatus":2');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Aprovada"','"status":"Aprovada","idStatus":3');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Planejada"','"status":"Planejada","idStatus":4');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"EmExecucao"','"status":"EmExecucao","idStatus":5');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Em Execuo"','"status":"Em Execuo","idStatus":5');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Em execuo"','"status":"Em execuo","idStatus":5');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Executada"','"status":"Executada","idStatus":6');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Suspensa"','"status":"Suspensa","idStatus":7');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Cancelada"','"status":"Cancelada","idStatus":8');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Rejeitada"','"status":"Rejeitada","idStatus":9');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Resolvida"','"status":"Resolvida","idStatus":10');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Reaberta"','"status":"Reaberta","idStatus":11');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Concluida"','"status":"Concluida","idStatus":12');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"status":"Concluda"','"status":"Concluda","idStatus":12');

-- fase em requisicaomudanca
alter table requisicaomudanca add idphase smallint;
update requisicaomudanca set idphase = 1 where fase = 'Registrada';
update requisicaomudanca set idphase = 2 where fase = 'Proposta';
update requisicaomudanca set idphase = 3 where fase = 'Aprovacao';
update requisicaomudanca set idphase = 3 where fase = 'Aprovao';
update requisicaomudanca set idphase = 4 where fase = 'Planejamento';
update requisicaomudanca set idphase = 5 where fase = 'Execucao';
update requisicaomudanca set idphase = 5 where fase = 'Execuo';
update requisicaomudanca set idphase = 6 where fase = 'Avaliacao';
update requisicaomudanca set idphase = 6 where fase = 'Avaliao';

alter table historicomudanca add idphase smallint;
update historicomudanca set idphase = 1 where fase = 'Registrada';
update historicomudanca set idphase = 2 where fase = 'Proposta';
update historicomudanca set idphase = 3 where fase = 'Aprovacao';
update historicomudanca set idphase = 3 where fase = 'Aprovao';
update historicomudanca set idphase = 4 where fase = 'Planejamento';
update historicomudanca set idphase = 5 where fase = 'Execucao';
update historicomudanca set idphase = 5 where fase = 'Execuo';
update historicomudanca set idphase = 6 where fase = 'Avaliacao';
update historicomudanca set idphase = 6 where fase = 'Avaliao';

-- fase em  ocorrenciamudanca
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"fase":"Registrada"','"fase":"Registrada","idPhase":1');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"fase":"Proposta"','"fase":"Proposta","idPhase":2');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"fase":"Aprovacao"','"fase":"Aprovacao","idPhase":3');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"fase":"Aprovao"','"fase":"Aprovao","idPhase":3');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"fase":"Planejamento"','"fase":"Planejamento","idPhase":4');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"fase":"Execucao"','"fase":"Execucao","idPhase":5');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"fase":"Execuo"','"fase":"Execuo","idPhase":5');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"fase":"Avaliacao"','"fase":"Avaliacao","idPhase":6');
update  ocorrenciamudanca set dadosmudanca = replace(convert(varchar(max), dadosmudanca),'"fase":"Avaliao"','"fase":"Avaliao","idPhase":6');

-- categoria em  ocorrenciamudanca
alter table  ocorrenciamudanca add idOccurrenceCategory smallint;
update  ocorrenciamudanca set idOccurrenceCategory = 1 where categoria = 'Criacao';
update  ocorrenciamudanca set idOccurrenceCategory = 2 where categoria = 'Acompanhamento';
update  ocorrenciamudanca set idOccurrenceCategory = 3 where categoria = 'Atualizacao';
update  ocorrenciamudanca set idOccurrenceCategory = 4 where categoria = 'Diagnostico';
update  ocorrenciamudanca set idOccurrenceCategory = 5 where categoria = 'Investigacao';
update  ocorrenciamudanca set idOccurrenceCategory = 6 where categoria = 'Memorando';
update  ocorrenciamudanca set idOccurrenceCategory = 7 where categoria = 'Informacao';
update  ocorrenciamudanca set idOccurrenceCategory = 8 where categoria = 'Retorno';
update  ocorrenciamudanca set idOccurrenceCategory = 9 where categoria = 'Sintoma';
update  ocorrenciamudanca set idOccurrenceCategory = 10 where categoria = 'Contorno';
update  ocorrenciamudanca set idOccurrenceCategory = 11 where categoria = 'Execucao';
update  ocorrenciamudanca set idOccurrenceCategory = 12 where categoria = 'MudancaSLA';
update  ocorrenciamudanca set idOccurrenceCategory = 13 where categoria = 'Reclassificacao';
update  ocorrenciamudanca set idOccurrenceCategory = 14 where categoria = 'Agendamento';
update  ocorrenciamudanca set idOccurrenceCategory = 15 where categoria = 'Suspensao';
update  ocorrenciamudanca set idOccurrenceCategory = 16 where categoria = 'Reativacao';
update  ocorrenciamudanca set idOccurrenceCategory = 17 where categoria = 'Encerramento';
update  ocorrenciamudanca set idOccurrenceCategory = 18 where categoria = 'Reabertura';
update  ocorrenciamudanca set idOccurrenceCategory = 19 where categoria = 'Direcionamento';
update  ocorrenciamudanca set idOccurrenceCategory = 20 where categoria = 'Compartilhamento';
update  ocorrenciamudanca set idOccurrenceCategory = 21 where categoria = 'CancelamentoTarefa';
update  ocorrenciamudanca set idOccurrenceCategory = 22 where categoria = 'InicioSLA';
update  ocorrenciamudanca set idOccurrenceCategory = 23 where categoria = 'SuspensaoSLA';
update  ocorrenciamudanca set idOccurrenceCategory = 24 where categoria = 'Aprovar';
update  ocorrenciamudanca set idOccurrenceCategory = 25 where categoria = 'ReativacaoSLA';
update  ocorrenciamudanca set idOccurrenceCategory = 26 where categoria = 'Outras';

-- insero dos fluxos
alter table bpm_elementofluxo alter column modeloemail varchar(50);

-- Requisio de Mudana Emergencial
INSERT INTO bpm_tipofluxo (idtipofluxo, nomefluxo, descricao, nomeclassefluxo, idprocessonegocio) VALUES ($id_tipofluxo_01,'RequisicaoMudancaEmergencialNovo','NOVO - Requisicao de Mudanca Emergencial','br.com.centralit.citcorpore.bpm.negocio.ExecucaoMudanca', null);
INSERT INTO bpm_fluxo(idfluxo, versao, idtipofluxo, variaveis, datainicio) VALUES ($id_fluxo_01, '1.0', $id_tipofluxo_01, 'requisicaoMudanca;requisicaoMudanca.idStatus;requisicaoMudanca.nomeGrupoAtual', CAST(GETDATE() AS DATE));

INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_01, $id_fluxo_01, '', '', '', '', '', '', 90, 139, 32, 32, 1);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_02, $id_fluxo_01, 'Executar', 'Executar', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=5', '#{requisicaoMudanca.nomeGrupoAtual}', '', 181, 123, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_03, $id_fluxo_01, 'Avaliar', 'Avaliar', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=6', '#{requisicaoMudanca.nomeGrupoAtual}', '', 397, 123, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_04, $id_fluxo_01, 'Encerrar', '', '', '', '', '#{execucaoFluxo}.encerra();', 603, 123, 65, 140, 3);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_05, $id_fluxo_01, '', '', '', '', '', '', 822, 140, 32, 32, 7);

INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada) VALUES ($id_elementofluxo_01, $id_elementofluxo_02, $id_fluxo_01, 1, 3, 151.5, 155.25, 'N');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada) VALUES ($id_elementofluxo_02, $id_elementofluxo_03, $id_fluxo_01, 1, 3, 359, 155.5, 'N');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada) VALUES ($id_elementofluxo_03, $id_elementofluxo_04, $id_fluxo_01, 1, 3, 570, 155.5, 'N');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada) VALUES ($id_elementofluxo_04, $id_elementofluxo_05, $id_fluxo_01, 1, 3, 782.5, 155.75, 'N');

-- Requisio de Mudana Padro
INSERT INTO bpm_tipofluxo (idtipofluxo, nomefluxo, descricao, nomeclassefluxo, idprocessonegocio) VALUES ($id_tipofluxo_02,'RequisicaoMudancaPadraoNovo','NOVO - Requisicao de Mudanca Padrao','br.com.centralit.citcorpore.bpm.negocio.ExecucaoMudanca', null);
INSERT INTO bpm_fluxo(idfluxo, versao, idtipofluxo, variaveis, datainicio) VALUES ($id_fluxo_02, '1.0', $id_tipofluxo_02, 'requisicaoMudanca;requisicaoMudanca.idStatus;requisicaoMudanca.nomeGrupoAtual', CAST(GETDATE() AS DATE));

INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_06, $id_fluxo_02, '', '', '', '', '', '', 71, 117, 32, 32, 1);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_07, $id_fluxo_02, 'Aprovar', 'Aprovar', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=3', '#{requisicaoMudanca.nomeGrupoAtual}', '', 139, 100, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_08, $id_fluxo_02, 'Executar', 'Executar', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=5', '#{requisicaoMudanca.nomeGrupoAtual}', '', 342, 100, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_09, $id_fluxo_02, 'Avaliar', 'Avaliar', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=6', '#{requisicaoMudanca.nomeGrupoAtual}', '', 534, 100, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_10, $id_fluxo_02, 'Encerrar', '', '', '', '', '#{execucaoFluxo}.encerra();', 733, 100, 65, 140, 3);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_11, $id_fluxo_02, '', '', '', '', '', '', 946, 117, 32, 32, 7);

INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada) VALUES ($id_elementofluxo_06, $id_elementofluxo_07, $id_fluxo_02, 1, 3, 121, 132.25, 'N');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada) VALUES ($id_elementofluxo_07, $id_elementofluxo_08, $id_fluxo_02, 1, 3, 310.5, 132.5, 'N');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada) VALUES ($id_elementofluxo_08, $id_elementofluxo_09, $id_fluxo_02, 1, 3, 508, 132.5, 'N');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada) VALUES ($id_elementofluxo_09, $id_elementofluxo_10, $id_fluxo_02, 1, 3, 703.5, 132.5, 'N');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada) VALUES ($id_elementofluxo_10, $id_elementofluxo_11, $id_fluxo_02, 1, 3, 909.5, 132.75, 'N');

-- Requisio de Mudana Normal
INSERT INTO bpm_tipofluxo (idtipofluxo, nomefluxo, descricao, nomeclassefluxo, idprocessonegocio) VALUES ($id_tipofluxo_03,'RequisicaoMudancaNormalNovo','NOVO - Requisicao de Mudanca Normal','br.com.centralit.citcorpore.bpm.negocio.ExecucaoMudanca', null);
INSERT INTO bpm_fluxo(idfluxo, versao, idtipofluxo, variaveis, datainicio) VALUES ($id_fluxo_03, '1.0', $id_tipofluxo_03, 'requisicaoMudanca;requisicaoMudanca.idStatus;requisicaoMudanca.nomeGrupoAtual', CAST(GETDATE() AS DATE));

INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_12, $id_fluxo_03, '', '', '', '', '', '', 21, 109, 32, 32, 1);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_13, $id_fluxo_03, 'Aprovar Requisicao', 'Aprovar Requisicao', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=3', '#{requisicaoMudanca.nomeGrupoAtual}', '', 313, 93, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_14, $id_fluxo_03, 'Planejar', 'Planejar', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=4', '#{requisicaoMudanca.nomeGrupoAtual}', '', 619, 85, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_15, $id_fluxo_03, 'Executar', 'Executar', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=5', '#{requisicaoMudanca.nomeGrupoAtual}', '', 808, 85, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_16, $id_fluxo_03, 'Avaliar', 'Avaliar', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=6', '#{requisicaoMudanca.nomeGrupoAtual}', '', 996, 85, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_17, $id_fluxo_03, 'Proposta', 'Proposta', 'U', 'pages/requisicaoMudanca/requisicaoMudanca.load?alterarSituacao=N&idPhase=2', '#{requisicaoMudanca.nomeGrupoAtual}', '', 66, 307, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_18, $id_fluxo_03, 'Encerrar', '', '', '', '', '#{execucaoFluxo}.encerra();', 1303, 85, 65, 140, 3);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_19, $id_fluxo_03, '', '', '', '', '', '', 117, 105, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_20, $id_fluxo_03, '', '', '', '', '', '', 366, 318, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_21, $id_fluxo_03, '', '', '', '', '', '', 667, 224, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_22, $id_fluxo_03, '', '', '', '', '', '', 1355, 318, 32, 32, 7);

INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_12, $id_elementofluxo_19, $id_fluxo_03, '', 1, 3, 85, 125.5, '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_19, $id_elementofluxo_17, $id_fluxo_03, '#{requisicaoMudanca}.ehProposta();', 2, 0, 137, 227, 'ehProposta');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_17, $id_elementofluxo_20, $id_fluxo_03, '', 1, 3, 286, 339.25, '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_20, $id_elementofluxo_22, $id_fluxo_03, '!#{requisicaoMudanca}.votacaoPropostaAprovada();', 1, 3, 811, 338, 'propostaRejeitada');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_20, $id_elementofluxo_13, $id_fluxo_03, '#{requisicaoMudanca}.votacaoPropostaAprovada();', 0, 2, 386, 236, 'propostaAprovada');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_19, $id_elementofluxo_13, $id_fluxo_03, '!#{requisicaoMudanca}.ehProposta();', 1, 3, 236, 125.75, 'isNotProposal');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_21, $id_elementofluxo_14, $id_fluxo_03, '#{requisicaoMudanca}.votacaoRequisicaoAprovada();', 0, 2, 688.5, 187, 'requisicaoAprovada');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_14, $id_elementofluxo_15, $id_fluxo_03, '', 1, 3, 783, 117, '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_15, $id_elementofluxo_16, $id_fluxo_03, '', 1, 3, 950, 118, '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_16, $id_elementofluxo_18, $id_fluxo_03, '', 1, 3, 1214, 119, '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_18, $id_elementofluxo_22, $id_fluxo_03, '', 2, 0, 1371, 231, '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_21, $id_elementofluxo_22, $id_fluxo_03, '!#{requisicaoMudanca}.votacaoRequisicaoAprovada();', 1, 3, 1032, 289.5, 'requisicaoRejeitada');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, nome) VALUES ($id_elementofluxo_13, $id_elementofluxo_21, $id_fluxo_03, '', 1, 3, 466, 127, '');

-- Liberacao Deploy
INSERT INTO bpm_tipofluxo (idtipofluxo, nomefluxo, descricao, nomeclassefluxo, idprocessonegocio) VALUES ($id_tipo_fluxo_04,'LiberacaoDeployNovo','NOVO - Liberacao Deploy','br.com.centralit.citcorpore.bpm.negocio.ExecucaoLiberacao', null);
INSERT INTO bpm_fluxo(idfluxo, versao, idtipofluxo, variaveis, datainicio) VALUES ($id_fluxo_04, '1.0', $id_tipo_fluxo_04, 'requisicaoLiberacao;requisicaoLiberacao.idStatus;requisicaoLiberacao.nomeGrupoAtual', CAST(GETDATE() AS DATE));

INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_23, $id_fluxo_04, '', '', '', '', '', '', 98, 144, 32, 32, 1);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_24, $id_fluxo_04, 'Liberacao', 'Liberacao', 'U', 'pages/requisicaoLiberacao/requisicaoLiberacao.load?escalar=S&alterarSituacao=S', '#{requisicaoLiberacao.nomeGrupoAtual}', '', 243, 127, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_25, $id_fluxo_04, 'Execucao', 'Execucao', 'U', 'pages/requisicaoLiberacao/requisicaoLiberacao.load?escalar=S&alterarSituacao=S', '#{requisicaoLiberacao.nomeGrupoAtual}', '', 579, 0, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_26, $id_fluxo_04, 'Teste', 'Teste', 'U', 'pages/requisicaoLiberacao/requisicaoLiberacao.load?escalar=S&alterarSituacao=S', '#{requisicaoLiberacao.nomeGrupoAtual}', '', 808, 51, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_27, $id_fluxo_04, 'Homologacao', 'Homologacao', 'U', 'pages/requisicaoLiberacao/requisicaoLiberacao.load?escalar=S&alterarSituacao=S', '#{requisicaoLiberacao.nomeGrupoAtual}', '', 621, 249, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_28, $id_fluxo_04, 'Resolvida', 'Resolvida', 'U', 'pages/requisicaoLiberacao/requisicaoLiberacao.load?escalar=S&alterarSituacao=S', '', '', 70, 328, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_29, $id_fluxo_04, '', '', '', '', '', '', 561, 137, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_30, $id_fluxo_04, '', '', '', '', '', '', 856, 215, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_31, $id_fluxo_04, '', '', '', '', '', '', 294, 340, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_32, $id_fluxo_04, '', '', '', '', '', '', 670, 337, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_33, $id_fluxo_04, '', '', '', '', '', '', 292, 45, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_34, $id_fluxo_04, '', '', '', '', '', '', 123, 241, 32, 32, 7);

INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_33, $id_elementofluxo_25, $id_fluxo_04, '', 0, 3, 440, 32.75, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_32, $id_elementofluxo_31, $id_fluxo_04, '#{requisicaoLiberacao}.liberada();', 3, 1, 503, 359.5, 'N', 'Liberacao');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_32, $id_elementofluxo_30, $id_fluxo_04, '#{requisicaoLiberacao}.emAtendimento();', 1, 1, 914, 359, 'S', 'Em Execucao');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_31, $id_elementofluxo_28, $id_fluxo_04, '#{requisicaoLiberacao}.atendida();', 3, 1, 252, 360.75, 'N', 'Resolvida');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_31, $id_elementofluxo_24, $id_fluxo_04, '!#{requisicaoLiberacao}.atendida();', 0, 2, 314, 266, 'N', 'Nao Resolvida');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_30, $id_elementofluxo_24, $id_fluxo_04, '#{requisicaoLiberacao}.naoResolvida();', 3, 1, 395, 238, 'S', 'Nao Resolvida');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_30, $id_elementofluxo_27, $id_fluxo_04, '!#{requisicaoLiberacao}.naoResolvida();', 2, 1, 878, 280, 'S', 'Em Execucao');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_29, $id_elementofluxo_24, $id_fluxo_04, '#{requisicaoLiberacao}.naoResolvida();', 3, 1, 472, 158.75, 'N', 'Nao Resolvida');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_29, $id_elementofluxo_26, $id_fluxo_04, '!#{requisicaoLiberacao}.naoResolvida();', 2, 3, 799, 189, 'S', 'Em Execucao');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_28, $id_elementofluxo_34, $id_fluxo_04, '', 0, 2, 139.5, 300.5, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_27, $id_elementofluxo_32, $id_fluxo_04, '', 2, 0, 691, 325.5, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_26, $id_elementofluxo_30, $id_fluxo_04, '', 2, 0, 877.5, 165.5, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_25, $id_elementofluxo_29, $id_fluxo_04, '', 2, 1, 649, 159, 'S', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_23, $id_elementofluxo_24, $id_fluxo_04, '', 1, 3, 186.5, 159.75, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_24, $id_elementofluxo_33, $id_fluxo_04, '', 0, 2, 313, 107, 'N', '');

-- Problema Padrao
INSERT INTO bpm_tipofluxo (idtipofluxo, nomefluxo, descricao, nomeclassefluxo, idprocessonegocio) VALUES ($id_tipo_fluxo_05,'ProblemaPadraoNovo','NOVO - Problema Padrao','br.com.centralit.citcorpore.bpm.negocio.ExecucaoProblema', null);
INSERT INTO bpm_fluxo(idfluxo, versao, idtipofluxo, variaveis, datainicio) VALUES ($id_fluxo_05, '1.0', $id_tipo_fluxo_05, 'problema;problema.idStatus;problema.nomeGrupoAtual', CAST(GETDATE() AS DATE));

INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_35, $id_fluxo_05, '', '', '', '', '', '', 66, 216, 32, 32, 1);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_36, $id_fluxo_05, 'Registrado', 'Registrado', 'U', 'pages/problema/problema.load?alterarSituacao=N&idActualPhase=1&idPhase=6', '#{problema.nomeGrupoAtual}', '', 174, 200, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_37, $id_fluxo_05, 'Investigacao e diagnostico', 'Investigacao e diagnostico', 'U', 'pages/problema/problema.load?alterarSituacao=N&idActualPhase=6&idPhase=12', '#{problema.nomeGrupoAtual}', '', 398, 200, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_38, $id_fluxo_05, 'Registro de erro conhecido', 'Registro de erro conhecido', 'U', 'pages/problema/problema.load?alterarSituacao=N&idActualPhase=12&idPhase=9', '#{problema.nomeGrupoAtual}', '', 629, 202, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_39, $id_fluxo_05, 'Resolucao', 'Resolucao', 'U', 'pages/problema/problema.load?alterarSituacao=N&idActualPhase=9', '#{problema.nomeGrupoAtual}', '', 843, 202, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_40, $id_fluxo_05, 'Encerrar', '', '', '', '', '#{execucaoFluxo}.close();', 1072, 202, 65, 140, 3);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, script, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_41, $id_fluxo_05, '', '', '', '', '', '', 1295, 218, 32, 32, 7);

INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_40, $id_elementofluxo_41, $id_fluxo_05, '', 1, 3, 1257, 234, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_39, $id_elementofluxo_40, $id_fluxo_05, '', 1, 3, 1027, 235, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_38, $id_elementofluxo_39, $id_fluxo_05, '', 1, 3, 811, 235, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_37, $id_elementofluxo_38, $id_fluxo_05, '', 1, 3, 606.5, 234, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_36, $id_elementofluxo_37, $id_fluxo_05, '', 1, 3, 364, 232.5, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_35, $id_elementofluxo_36, $id_fluxo_05, '', 1, 3, 138, 232.25, 'N', '');

-- Solicitacao de Servico
INSERT INTO bpm_tipofluxo (idtipofluxo, nomefluxo, descricao, nomeclassefluxo, idprocessonegocio) VALUES ($id_tipo_fluxo_06,'SolicitacaoServicoNovo','NOVO - Solicitacao de Servico','br.com.centralit.citcorpore.bpm.negocio.ExecucaoSolicitacao', null);
INSERT INTO bpm_fluxo(idfluxo, versao, idtipofluxo, variaveis, datainicio) VALUES ($id_fluxo_06, '1.0', $id_tipo_fluxo_06, 'solicitacaoServico;solicitacaoServico.idStatus;solicitacaoServico.grupoAtual;solicitacaoServico.grupoNivel1', CAST(GETDATE() AS DATE));

INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_42, $id_fluxo_06, '', '', '', '', '', 32, 21, 32, 32, 1);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_43, $id_fluxo_06, 'Direcionar atendimento', 'Direcionar atendimento', 'U', 'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?escalar=S&alterarSituacao=S', '#{solicitacaoServico.grupoNivel1}', 276, 106, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_44, $id_fluxo_06, 'Atender solicitacao', 'Atender solicitacao', 'U', 'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?escalar=S&alterarSituacao=S', '#{solicitacaoServico.grupoAtual}', 276, 304, 65, 140, 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_45, $id_fluxo_06, '', '', '', '', '', 120, 16, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_46, $id_fluxo_06, '', '', '', '', '', 119, 117, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_47, $id_fluxo_06, '', '', '', '', '', 325, 220, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_48, $id_fluxo_06, '', '', '', '', '', 608, 317, 42, 42, 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, idtype) VALUES ($id_elementofluxo_49, $id_fluxo_06, '', '', '', '', '', 611, 21, 32, 32, 7);

INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_48, $id_elementofluxo_49, $id_fluxo_06, '#{solicitacaoServico}.atendida();', 0, 2, 628, 185, 'N', 'atendida');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_48, $id_elementofluxo_44, $id_fluxo_06, '!#{solicitacaoServico}.atendida();', 2, 2, 629, 380, 'S', 'nao atendida');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_47, $id_elementofluxo_44, $id_fluxo_06, '!#{solicitacaoServico}.atendida();', 2, 0, 346, 283, 'N', 'nao atendida');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_46, $id_elementofluxo_44, $id_fluxo_06, '#{solicitacaoServico}.escalada();', 2, 3, 138, 338, 'S', 'direcionada');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_46, $id_elementofluxo_43, $id_fluxo_06, '!#{solicitacaoServico}.escalada();', 1, 3, 218.5, 138.25, 'N', 'nao direcionada');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_45, $id_elementofluxo_49, $id_fluxo_06, '#{solicitacaoServico}.atendida();', 1, 3, 386.5, 37, 'N', 'atendida');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_45, $id_elementofluxo_46, $id_fluxo_06, '!#{solicitacaoServico}.atendida();', 2, 0, 140.5, 87.5, 'N', 'nao atendida');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_44, $id_elementofluxo_48, $id_fluxo_06, '', 1, 3, 512, 337.25, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_43, $id_elementofluxo_47, $id_fluxo_06, '', 2, 0, 346, 195.5, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_42, $id_elementofluxo_45, $id_fluxo_06, '', 1, 3, 92, 37, 'N', '');

-- Procedimento de Continuidade
INSERT INTO bpm_tipofluxo (idTipoFluxo,nomeFluxo,descricao,nomeClasseFluxo,idProcessoNegocio) VALUES ($id_tipo_fluxo_07, 'ProcedimentoContinuidadeNovo', 'NOVO - Procedimento de Continuidade', 'br.com.centralit.citcorpore.bpm.negocio.ExecucaoSolicitacao', null);
INSERT INTO bpm_fluxo (idFluxo,idTipoFluxo,versao,variaveis,conteudoXml,dataInicio) VALUES ($id_fluxo_07, $id_tipo_fluxo_07, 1.0, 'solicitacaoServico;solicitacaoServico.idStatus;solicitacaoServico.grupoAtual;solicitacaoServico.grupoNivel1;solicitacaoServico.idSolicitacaoRelacionada', null, CAST(GETDATE() AS DATE));

INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_50, $id_fluxo_07, '', '', '', '', '', 905, 737, 32, 32, '', '', '', '', 7);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_51, $id_fluxo_07, '', '', '', '', '', 900, 362, 42, 42, '', '', '', '', 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_52, $id_fluxo_07, '', '', '', '', '#{solicitacaoServico.grupoAtual}', 906, 651, 22, 31, 'procContinuidadeFinalizado', '', '', '', 4);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_53, $id_fluxo_07, '', '', '', '', '#{solicitacaoServico.grupoAtual}', 543, 372, 22, 31, 'procContinuidadeReiniciado', '', '', '', 4);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_54, $id_fluxo_07, '', '', '', '', '#{solicitacaoServico.grupoAtual}', 538, 245, 22, 31, 'procContinuidadeExecutado', '', '', '', 4);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_55, $id_fluxo_07, '', '', '', '', '#{solicitacaoServico.grupoAtual}', 242, 244, 22, 31, 'procContinuidadeIniciado', '', '', '', 4);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_56, $id_fluxo_07, 'finalizarProcedimento', 'Finalizar Procedimento', 'U', 'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?escalar=S&alterarSituacao=S', '#{solicitacaoServico.grupoNivel1}', 852, 505, 65, 140, '', '', 'N', 'S', 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_57, $id_fluxo_07, 'validacao', 'Verifique a situacao e se e possvel voltar ao normal', 'U', 'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?escalar=S&alterarSituacao=S', '#{solicitacaoServico.grupoNivel1}', 852, 223, 65, 140, '', 'AprovacaoSolicitacaoServico', 'N', 'S', 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_58, $id_fluxo_07, 'avaliacaoDados', 'Avaliao de dados e paradas', 'U', 'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?escalar=S&alterarSituacao=S', '#{solicitacaoServico.grupoNivel1}', 641, 223, 65, 140, '', '', 'N', 'S', 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_59, $id_fluxo_07, 'executarProcedimento', 'Executar o Procedimento de Continuidade para restaurar o servico.', 'U', 'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?escalar=S&alterarSituacao=S', '#{solicitacaoServico.grupoNivel1}', 333, 223, 65, 140, '', '', 'N', 'S', 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_60, $id_fluxo_07, '', '', '', '', '', 155, 239, 32, 32, '', '', '', '', 1);

INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_51, $id_elementofluxo_53, $id_fluxo_07, '!#{solicitacaoServico}.aprovada();', 3, 1, 737, 383, 'N', 'Servico fora da normalidade');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_51, $id_elementofluxo_56, $id_fluxo_07, '#{solicitacaoServico}.aprovada();', 2, 0, 921.5, 454.5, 'N', 'Servico normal');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_52, $id_elementofluxo_50, $id_fluxo_07, '', 2, 0, 921.25, 705, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_53, $id_elementofluxo_59, $id_fluxo_07, '', 3, 2, 403, 382, 'S', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_54, $id_elementofluxo_58, $id_fluxo_07, '', 1, 3, 605, 255.75, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_55, $id_elementofluxo_59, $id_fluxo_07, '', 1, 3, 303, 255.25, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_56, $id_elementofluxo_52, $id_fluxo_07, '', 2, 0, 921.75, 610.5, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_57, $id_elementofluxo_51, $id_fluxo_07, '', 2, 0, 921.5, 325, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_58, $id_elementofluxo_57, $id_fluxo_07, '', 1, 3, 816.5, 255.5, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_59, $id_elementofluxo_54, $id_fluxo_07, '', 1, 3, 505.5, 255.75, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_60, $id_elementofluxo_55, $id_fluxo_07, '', 1, 3, 214.5, 255, 'N', '');

-- Incidente Critico
INSERT INTO bpm_tipofluxo (idTipoFluxo,nomeFluxo,descricao,nomeClasseFluxo,idProcessoNegocio) VALUES ($id_tipo_fluxo_08, 'IncidenteCriticoNovo', 'NOVO - Incidente Critico', 'br.com.centralit.citcorpore.bpm.negocio.ExecucaoSolicitacao', null);
INSERT INTO bpm_fluxo (idFluxo,idTipoFluxo,versao,variaveis,conteudoXml,dataInicio) VALUES ($id_fluxo_08, $id_tipo_fluxo_08, 1.0, 'solicitacaoServico;solicitacaoServico.idStatus;solicitacaoServico.grupoAtual;solicitacaoServico.grupoNivel1', null, CAST(GETDATE() AS DATE));

INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_61, $id_fluxo_08, '', '', '', '', '', 735, 355, 32, 32, '', '', '', '', 7);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_62, $id_fluxo_08, '', '', '', '', '', 457, 209, 42, 42, '', '', '', '', 5);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_63, $id_fluxo_08, '', '', '', '', '#{solicitacaoServico.grupoAtual}', 574, 219, 22, 31, 'IncidenteCriticoApr', '', '', '', 4);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_64, $id_fluxo_08, '', '', '', '', '#{solicitacaoServico.grupoAtual}', 181, 218, 22, 31, 'IncidenteCriticoCri', '', '', '', 4);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_65, $id_fluxo_08, 'Autorizar', 'Autorizar', 'U', 'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?escalar=S&alterarSituacao=S', '#{solicitacaoServico.grupoNivel1}', 681, 198, 65, 140, '', '', 'N', 'N', 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_66, $id_fluxo_08, 'Aprovar incidente critico', 'Aprovar incidente critico', 'U', 'pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load', 'script:#{execucaoFluxo}.recuperaGrupoAprovador();', 266, 197, 65, 140, '', 'AprovacaoSolicitacaoServico', 'N', 'S', 2);
INSERT INTO bpm_elementofluxo (idelemento, idfluxo, nome, documentacao, tipointeracao, url, grupos, posx, posy, altura, largura, modeloemail, template, multiplasinstancias, contabilizasla, idtype) VALUES ($id_elementofluxo_67, $id_fluxo_08, '', '', '', '', '', 79, 213, 32, 32, '', '', '', '', 1);

INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_62, $id_elementofluxo_61, $id_fluxo_08, '!#{solicitacaoServico}.aprovada();', 2, 3, 600.5, 317, 'N', 'Nao Autorizar');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_62, $id_elementofluxo_63, $id_fluxo_08, '#{solicitacaoServico}.aprovada();', 1, 3, 536.5, 230, 'N', 'Autorizar');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_63, $id_elementofluxo_65, $id_fluxo_08, '', 1, 3, 643, 230.25, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_64, $id_elementofluxo_66, $id_fluxo_08, '', 1, 3, 239, 229.25, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_65, $id_elementofluxo_61, $id_fluxo_08, '', 2, 0, 751, 309, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_66, $id_elementofluxo_62, $id_fluxo_08, '', 1, 3, 431.5, 229.75, 'N', '');
INSERT INTO bpm_sequenciafluxo (idelementoorigem, idelementodestino, idfluxo, condicao, idconexaoorigem, idconexaodestino, bordax, borday, posicaoalterada, nome) VALUES ($id_elementofluxo_67, $id_elementofluxo_64, $id_fluxo_08, '', 1, 3, 146, 229, 'N', '');

-- modelos de email
insert into modelosemails ( idmodeloemail , titulo , texto , situacao , identificador , idprocesso) values (26, 'Requisio de Mudana em andamento - ${IDREQUISICAOMUDANCA}', 'Senhor(a) ${NOMESOLICITANTE}, <br /><br />Informamos que a requisi&ccedil;&atilde;o de mudan&ccedil;a registrada em ${DATAHORAINICIOSTR} est&aacute; em atendimento, conforme os dados abaixo:<br /><br /><strong>N&uacute;mero:</strong>&nbsp;${IDREQUISICAOMUDANCA}<br /><strong>T&iacute;tulo:</strong>&nbsp;${TITULO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong>&nbsp;<br />${TITULO}<br /><strong><br /></strong>${DESCRICAO}<br /><br /><strong>Grupo de atendimento:</strong>&nbsp;${NOMEGRUPOATUAL}<br /><br />Atenciosamente, <br /><br />Central IT&nbsp;Tecnologia da Informa&ccedil;&atilde;o Ltda', 'A', 'AndamentoReqMud', 3);
insert into modelosemails ( idmodeloemail , titulo , texto , situacao , identificador , idprocesso) values (27, 'Requisio de Mudana registrada - ${IDREQUISICAOMUDANCA}', 'Senhor(a) ${NOMESOLICITANTE}, <br /><br />Informamos que a sua Requisi&ccedil;&atilde;o de mudan&ccedil;a foi registrada em ${DATAHORAINICIOSTR}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong> ${IDREQUISICAOMUDANCA}<br /><strong>Tipo:</strong> ${TIPO}<br /><strong>T&iacute;tulo:</strong> ${TITULO}<br /><br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><br />Atenciosamente, <br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', 'A', 'AberturaReqMud', 3);
insert into modelosemails ( idmodeloemail , titulo , texto , situacao , identificador , idprocesso) values (28, 'Requisio de Mudana finalizada - ${IDREQUISICAOMUDANCA}', 'Senhor(a) ${NOMESOLICITANTE}, <br /><br />Informamos que a sua Requisi&ccedil;&atilde;o de mudan&ccedil;a foi finalizada em ${DATAHORACONCLUSAO}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong> ${IDREQUISICAOMUDANCA}<br /><strong>Tipo:</strong> ${TIPO}<br /><strong>T&iacute;tulo:</strong> ${TITULO}<br /><br /><strong>Status:</strong>${STATUS}<br /><strong>Descri&ccedil;&atilde;o:</strong> <br />${DESCRICAO}<br /><br /><br />Atenciosamente, <br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.', 'A', 'FinalizadaReqMud', 3);
insert into modelosemails ( idmodeloemail , titulo , texto , situacao , identificador , idprocesso) values (29, 'Requisio encaminhada para o COMIT CONSULTIVO DE MUDANA ', '&nbsp;A Requisi&ccedil;&atilde;o de Mudan&ccedil;a abaixo foi encaminhada para o Comit&ecirc; Consultivo de Mudan&ccedil;a do qual o Senhor(a) faz parte:<div>&nbsp;</div><div><strong>N&uacute;mero</strong>: ${IDREQUISICAOMUDANCA}</div><div><strong>Tipo</strong>: ${TIPO}</div><div><strong>T&iacute;tulo</strong>: ${TITULO}</div><div>&nbsp;</div><div><strong>Descri&ccedil;&atilde;o</strong>:&nbsp;</div><div>${DESCRICAO}</div><div>&nbsp;</div><div>Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.</div>', 'A', 'emailCCM', 3);
insert into modelosemails ( idmodeloemail , titulo , texto , situacao , identificador , idprocesso) values (30, 'Requisio Mudana encaminhada para seu GRUPO DE TRABALHO', '<div>&nbsp; A &nbsp;requisi&ccedil;&atilde;o mudan&ccedil;a abaixo foi encaminhada para seu Grupo de Trabalho:</div><div>&nbsp;</div><div>N&uacute;mero: ${IDREQUISICAOMUDANCA}</div><div>Tipo: ${TIPO}</div><div>Titulo: ${TITULO}</div><div>&nbsp;</div><div>Descri&ccedil;&atilde;o:&nbsp;</div><div>${DESCRICAO}</div><div>&nbsp;</div><div>Atenciosamente, <br /><br />Central IT&nbsp;Tecnologia da Informa&ccedil;&atilde;o Ltda.</div>', 'A', 'ReqMudancaGrupo', 3);

-- tipos de mudana
insert into tipomudanca (idtipomudanca, idtipofluxo, idmodeloemailcriacao, idmodeloemailfinalizacao, idmodeloemailacoes, idgrupoexecutor, idcalendario, nometipomudanca, datainicio, datafim) values ($id_tipomudanca_01, $id_tipofluxo_01, 27, 28, 26, 1, 1, 'Emergencial', now(), null);
insert into tipomudanca (idtipomudanca, idtipofluxo, idmodeloemailcriacao, idmodeloemailfinalizacao, idmodeloemailacoes, idgrupoexecutor, idcalendario, nometipomudanca, datainicio, datafim) values ($id_tipomudanca_02, $id_tipofluxo_02, 27, 28, 26, 1, 1, 'Padro', now(), null);
insert into tipomudanca (idtipomudanca, idtipofluxo, idmodeloemailcriacao, idmodeloemailfinalizacao, idmodeloemailacoes, idgrupoexecutor, idcalendario, nometipomudanca, datainicio, datafim) values ($id_tipomudanca_03, $id_tipofluxo_03, 27, 28, 26, 1, 1, 'Normal', now(), null);

-- tipo de liberao
insert into tipoliberacao (idtipoliberacao, idtipofluxo, idmodeloemailcriacao, idmodeloemailfinalizacao, idmodeloemailacoes, idgrupoexecutor, idcalendario, nometipoliberacao, datainicio, datafim) values ($id_tipoliberacao_01, $id_tipofluxo_04, 51, 52, 53, 1, 1, 'Liberao', now(), null);

-- categoria de problema
insert into categoriaproblema(idcategoriaproblema, idtipofluxo, idgrupoexecutor, datainicio, datafim, nomecategoriaproblema, impacto, urgencia) values ($id_categoriaproblema_01, $id_tipofluxo_05,1, now(), null, 'Problema', 'B', 'B');

-- update fluxos de mudana
update bpm_fluxo set variaveis = replace(convert(varchar(max), variaveis), 'requisicaoMudanca.status', 'requisicaoMudanca.idStatus') where variaveis like '%requisicaoMudanca.status%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Registrada', 'idPhase=1') where url like '%requisicaoMudanca.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Proposta', 'idPhase=2') where url like '%requisicaoMudanca.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Aprovacao', 'idPhase=3') where url like '%requisicaoMudanca.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Planejamento', 'idPhase=4') where url like '%requisicaoMudanca.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Execucao', 'idPhase=5') where url like '%requisicaoMudanca.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Avaliacao', 'idPhase=6') where url like '%requisicaoMudanca.load%';

-- update fluxos de liberao
update bpm_fluxo set variaveis = replace(convert(varchar(max), variaveis), 'requisicaoLiberacao.status', 'requisicaoLiberacao.idStatus') where variaveis like '%requisicaoLiberacao.status%';

-- update fluxos de problema
update bpm_fluxo set variaveis = replace(convert(varchar(max), variaveis), 'problema.status', 'problema.idStatus') where variaveis like '%problema.status%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Registrada', 'idPhase=1') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Aprovacao', 'idPhase=2') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Planejamento', 'idPhase=3') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Execucao', 'idPhase=4') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Avaliacao', 'idPhase=5') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=EmInvestigacao', 'idPhase=6') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=SolucaoDeContorno', 'idPhase=7') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Revisado', 'idPhase=8') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Resolucao', 'idPhase=9') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Encerramento', 'idPhase=10') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=Revisar', 'idPhase=11') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'fase=RegistroErroConhecido', 'idPhase=12') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=Registrada', 'idActualPhase=1') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=Aprovacao', 'idActualPhase=2') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=Planejamento', 'idActualPhase=3') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=Execucao', 'idActualPhase=4') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=Avaliacao', 'idActualPhase=5') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=EmInvestigacao', 'idActualPhase=6') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=SolucaoDeContorno', 'idActualPhase=7') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=Revisado', 'idActualPhase=8') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=Resolucao', 'idActualPhase=9') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=Encerramento', 'idActualPhase=10') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=Revisar', 'idActualPhase=11') where url like '%problema.load%';
update bpm_elementofluxo set url = replace(convert(varchar(max), url), 'faseAtual=RegistroErroConhecido', 'idActualPhase=12') where url like '%problema.load%';

-- update fluxos de solicitao de servio
update bpm_fluxo set variaveis = replace(convert(varchar(max), variaveis), 'solicitacaoServico.situacao', 'solicitacaoServico.idStatus') where variaveis like '%solicitacaoServico.situacao%';