set sql_safe_updates = 0;

--INCIO - [rodrigo.acorse] - 21/01/2015

alter table evm_gerente add urgenciaup char(1) null;
alter table evm_gerente add urgenciadown char(1) null;
alter table evm_gerente add impactoup char(1) null;
alter table evm_gerente add impactodown char(1) null;

alter table evm_gerenciado_inventory add urgenciainformation char(1) null;
alter table evm_gerenciado_inventory add impactoinformation char(1) null;
alter table evm_gerenciado_inventory add urgenciawarning char(1) null;
alter table evm_gerenciado_inventory add impactowarning char(1) null;
alter table evm_gerenciado_inventory add urgenciaexception char(1) null;
alter table evm_gerenciado_inventory add impactoexception char(1) null;

alter table evm_gerenciado_nagios add urgenciainformation char(1) null;
alter table evm_gerenciado_nagios add impactoinformation char(1) null;
alter table evm_gerenciado_nagios add urgenciawarning char(1) null;
alter table evm_gerenciado_nagios add impactowarning char(1) null;
alter table evm_gerenciado_nagios add urgenciaexception char(1) null;
alter table evm_gerenciado_nagios add impactoexception char(1) null;

alter table evm_gerenciado_zabbix add urgenciainformation char(1) null;
alter table evm_gerenciado_zabbix add impactoinformation char(1) null;
alter table evm_gerenciado_zabbix add urgenciawarning char(1) null;
alter table evm_gerenciado_zabbix add impactowarning char(1) null;
alter table evm_gerenciado_zabbix add urgenciaexception char(1) null;
alter table evm_gerenciado_zabbix add impactoexception char(1) null;

alter table evm_linha_g_g_nagios add urgenciaup char(1) null;
alter table evm_linha_g_g_nagios add urgenciadown char(1) null;
alter table evm_linha_g_g_nagios add impactoup char(1) null;
alter table evm_linha_g_g_nagios add impactodown char(1) null;

alter table evm_linha_g_g_nagios add urgenciainformation char(1) null;
alter table evm_linha_g_g_nagios add impactoinformation char(1) null;
alter table evm_linha_g_g_nagios add urgenciawarning char(1) null;
alter table evm_linha_g_g_nagios add impactowarning char(1) null;
alter table evm_linha_g_g_nagios add urgenciaexception char(1) null;
alter table evm_linha_g_g_nagios add impactoexception char(1) null;

alter table evm_gerente_correlacao add urgenciainformation char(1) null;
alter table evm_gerente_correlacao add impactoinformation char(1) null;
alter table evm_gerente_correlacao add urgenciawarning char(1) null;
alter table evm_gerente_correlacao add impactowarning char(1) null;
alter table evm_gerente_correlacao add urgenciaexception char(1) null;
alter table evm_gerente_correlacao add impactoexception char(1) null;

-- FIM - [rodrigo.acorse] - 21/01/2015

-- INCIO - [deborah.ferreira] - 21/01/2016

CREATE TABLE ocorrenciaservico (
	idocorrenciaservico BIGINT NOT NULL,
	idservico BIGINT NOT NULL,
	nomeusuario VARCHAR(255) NOT NULL,
	datacriacao TIMESTAMP NOT NULL,
	categoriaocorrencia VARCHAR(10) NOT NULL,
	tipoocorrencia VARCHAR(10) NOT NULL,
	descricaoocorrencia TEXT,
	PRIMARY KEY (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicodetalhes
(
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nomeservico VARCHAR(255) NOT NULL,
	nomecategoriaservico VARCHAR(255) NOT NULL,
	faseservico VARCHAR(255) NOT NULL,
	tipodeinvestimento VARCHAR(255),
	nometiposervico VARCHAR(255) NULL,
	detalheservico VARCHAR(255) NOT NULL,
	processodeiniciacao VARCHAR(255) NOT NULL,
	datainicio DATE NOT NULL,
	statusservico VARCHAR(255) NOT NULL,
	nomeimportancianegocio VARCHAR(255) NOT NULL,
	nomelocalexecucaoservico VARCHAR(255) NOT NULL,
	objetivo TEXT,
	valoresdoservico TEXT,
	nometemplateservico VARCHAR(200),
	criticidadeservico INT,
	demandaservico INT,
	retornofinanceiroservico INT,
	deleted CHAR(1) DEFAULT 'N',
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicorequisitosnivelservico (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	datacriacao DATE NOT NULL,
	datainicioservico DATE,
	donodoservico TEXT,
	especificacao TEXT,
	contexto TEXT,
	funcionalidadesessenciais TEXT,
	seguranca TEXT,
	disponibilidade TEXT,
	capacidade TEXT,
	continuidadedonegocio TEXT,
	performancedesempenho TEXT,
	interrupcoesplanejadas TEXT,
	gestaodeincidentes TEXT,
	gestaodeproblemas TEXT,
	gestaodemudancas TEXT,
	conformidadeinterna TEXT,
	conformidadeexterna TEXT,
	datafim DATE,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicocasonegocio (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nomecasonegocio varchar(100) DEFAULT NULL,
	descricaosumarioexecutivo TEXT,
	descricaocenarios TEXT,
	descricaoproblemaoportunidade TEXT,
	descricaopropostasolucao TEXT,
	descricaoanalisefinanceira TEXT,
	descricaoanaliserisco TEXT,
	descricaostakeholderentidade TEXT,
	descricaoviabilidadetecnica TEXT,
	descricaoconclusao TEXT,
	datafim DATE,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicoatributosfinanceiros (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idatributosfinanceiros BIGINT NOT NULL,
	categoriaatributosfinanceiros VARCHAR(255) NOT NULL,
	tipoatributosfinanceiros VARCHAR(1) NOT NULL,
	valoratributosfinanceiros INT(20) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicoprocessonegocio (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idprocessonegocio INT(11) NOT NULL,
  	nomeprocessonegocio VARCHAR(100) NOT NULL,
  	nomecliente VARCHAR(255) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicodononegocio (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	iddononegocio INT(11) NOT NULL,
	nomedononegocio VARCHAR(256) NOT NULL,
	tipodononegocio INT(11) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicousernegocio (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idusuarionegocio INT(11) NOT NULL,
	nomeusuarionegocio VARCHAR(256) NOT NULL,
	tipousuarionegocio INT(11) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicorelacionado (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idservicorelacionado BIGINT NOT NULL,
  	nomeservicorelacionado VARCHAR(500) NOT NULL,
  	faseservicorelacionado VARCHAR(2),
	statusservicorelacionado VARCHAR(5),
	tiposervicorelacionado VARCHAR(1) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicoaplicacao
(
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idaplicacao INT(11) NOT NULL,
	nomeaplicacao VARCHAR(256) NOT NULL,
	nomeresponsavelaplicacao VARCHAR(256) DEFAULT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicocontrato (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idcontrato INT(11) NOT NULL,
    descricaocontrato TEXT NOT NULL,
    clientecontrato VARCHAR(70) NOT NULL,
	fornecedorcontrato VARCHAR(100) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicoproprietarios (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idproprietario INT(11) NOT NULL,
	nomeproprietario VARCHAR(256) NOT NULL,
	tipoproprietario INT(11) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicoesquemadados (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idesquemadados BIGINT NOT NULL,
	detalhesesquemadados TEXT NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicoanexos (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idanexo INT(11) NOT NULL,
	nomeanexo VARCHAR(255) NOT NULL,
	descricaoanexo VARCHAR(255) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicomapaservico (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	iditemmapaservico INT(11) NOT NULL,
	iconeitemmapaservico VARCHAR(256),
	nomeitemmapaservico VARCHAR(500) NOT NULL,
	tipoitemmapaservico CHAR(2) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);
-- FIM - [deborah.ferreira] - 21/01/2016


-- INCIO [douglas.japiassu] 29.01.2016

create table templateservico (
	idtemplateservico int not null,
	identificacao varchar(255) not null,
	nometemplate varchar(200) not null,
	nomeclassedto varchar(255),
	nomeclasseaction varchar(255),
	nomeclasseservico varchar(255),
	urlrecuperacao varchar(255),
	alturadiv int not null,
	idquestionario int(11),
	scriptaposrecuperacao text,
	primary key (idtemplateservico),
	constraint templateservico_questionario_fk foreign key (idquestionario) references questionario (idquestionario)
) ENGINE=InnoDB;

alter table servico engine=InnoDB;
alter table servico add valoresdoservico text;
alter table servico add idtemplateservico int;
alter table servico add constraint servico_templateservico_fk foreign key (idtemplateservico) references templateservico (idtemplateservico);

create table servicoquestionario (
	idservicoquestionario int(11) not null,
	idquestionario int(11) not null,
	idservico bigint not null,
	dataquestionario timestamp not null,
	situacao char(1) not null,
	datahoragrav timestamp not null,
	primary key (idservicoquestionario),
	constraint fk_servquest_servico foreign key (idservico) references servico (idservico) on delete no action on update no action,
	constraint fk_servquest_quest foreign key (idquestionario) references questionario (idquestionario) on delete no action on update no action
) ENGINE=InnoDB;
-- FIM [douglas.japiassu] 29.01.2016

-- INCIO [gilmar.junior] 29.01.2016
alter table servico add criticidadeservico int;
alter table servico add demandaservico int;
alter table servico add retornofinanceiroservico int;
-- FIM [gilmar.junior] 29.01.2016

-- INCIO [joao.morais] 02.02.2016
create table habilidade (
	idhabilidade bigint(20) not null,
	nomehabilidade varchar(255) not null,
	descricao varchar(255) not null,
	datahorainicio datetime not null,
	datahorafim datetime,
	primary key (idhabilidade)
)ENGINE=InnoDB;

create table vinculohabilidade (
	idvinculocolaborador bigint(20) not null,
	idempregado int(11) not null,
	idhabilidade bigint(20) not null,
	dataFim Date,
	primary key (idvinculocolaborador),
	constraint fk_habilidadeVinculo foreign key (idhabilidade) references habilidade (idhabilidade),
	constraint fk_empregadoHabilidade foreign key (idempregado) references empregados (idempregado)
)ENGINE=InnoDB;
-- FIM [joao.morais] 02.02.2016

-- INICIO - thyen.chang - 02/02/2016

alter table tipofinanceiroservico add classificacao int;
alter table financeiroservico add classificacao int;

-- FIM - thyen.chang - 02/02-2016

-- INICIO [joao.morais] 10.02.2016
create table habilidadeservico(
	idhabilidade bigint(20) not null,
	idservico bigint(20) not null,
	idhabilidadevinculo bigint(20) not null,
	datafim Date,
	primary key (idhabilidadevinculo),
	constraint fk_servicohabilidade foreign key (idservico) references servico (idservico)
) ENGINE=InnoDB;
-- FIM - [joao.morais] - 10/02/2016

-- INCIO - [deborah.ferreira] - 10/02/2016

CREATE TABLE auditoriaeventos (
	idauditoriaeventos BIGINT NOT NULL,
	nomeusuario VARCHAR(255) NOT NULL,
	datacriacao TIMESTAMP NOT NULL,
	categoria VARCHAR(10)  NOT NULL,
	tipo VARCHAR(10) NOT NULL,
	descricao TEXT,	
	PRIMARY KEY (idauditoriaeventos)
);
-- FIM - [deborah.ferreira] - 10/02/2016

-- INCIO - [pedro.francisco] - 11/02/2016
CREATE TABLE kpiobjetivomonitoramento (
	idkpiobjetivomonitoramento int(11) NOT NULL,
	idobjetivomonitoramento int(11) NOT NULL,
	kpi varchar(255) NOT NULL,
	criadopor varchar(255) NOT NULL,
	CONSTRAINT kpiobjetivomonitoramento_objetivomonitoramento_FK FOREIGN KEY (idobjetivomonitoramento) REFERENCES objetivomonitoramento(idobjetivomonitoramento) ON DELETE RESTRICT ON UPDATE RESTRICT
)  ENGINE=InnoDB;

ALTER TABLE objetivoplanomelhoria ADD idrespobj int(11);
ALTER TABLE objetivoplanomelhoria ADD idgruporespobj int(11);
ALTER TABLE acaoplanomelhoria ADD idrespacao int(11);
ALTER TABLE acaoplanomelhoria ADD idgruporespacao int(11);
ALTER TABLE objetivomonitoramento ADD idrespmon int(11);
ALTER TABLE objetivomonitoramento ADD idgruporespmon int(11);
-- FIM - [pedro.francisco] - 11/02/2016

-- INICIO [joao.morais] - 11/02/2016
update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.gerenciaEventos') as tbl) 
where nome = '$menu.nome.evm.acoesAutomaticas' 
or nome = '$menu.nome.evm.ferramentasmonitoracao'
or nome = '$menu.nome.evm.horario'
or nome = '$menu.nome.evm.citsmartInventory'
or nome = '$menu.nome.evm.citsmartevm'
or nome = '$menu.nome.evm.categoriaOcorrencia'
or nome = '$menu.nome.evm.gerenciamentoeventos'
or nome = '$menu.nome.evm.conexoes'
or nome = '$menu.nome.evm.gerente.nagios'
or nome = '$menu.nome.evm.gerente.zabbix'
or nome = '$menu.nome.evm.gerente.inventory'
or nome = '$menu.nome.evm.gerente.correlacao'
or nome = '$menu.nome.evm.gerente.generico.nagios'
or nome = '$menu.nome.evm.acaoAutomatica'
or nome = '$menu.nome.evm.cadAcaoAutoIncReq'
or nome = '$menu.nome.evm.acoesNotificacao'
or nome = '$menu.nome.evm.acoesMudanca'
or nome = 'menu.nome.evm.conexoes'
or nome = '$menu.nome.evm.check'
or nome = '$menu.nome.evm.statusinventory';

update menu set datafim = now() 
where nome in(
	'$menu.nome.evm.acoesAutomaticas',
	'$menu.nome.metaNivelServico',
	'$menu.nome.cadastrosRH',
	'$menu.nome.configuracaoSolicitacaoProduto',
	'$menu.nome.evm.citsmartInventory',
	'$menu.nome.evm.citsmartevm',
	'$menu.nome.evm.conexoes',
	'$menu.nome.pesquisa', 
	'$menu.nome.alcadaCentroResultado',
	'$menu.nome.monitoramento',
	'$menu.nome.monitoramentoNagios',
	'$menu.nome.eventoMonitoramento',
	'$menu.nome.recurso',
	'$menu.nome.disponibilidadeRecurso',
	'$menu.nome.grupoRecursos',
	'$menu.nome.evm.conexoes',
	'$menu.nome.cadastroContratos',
	'$menu.nome.mostraStatusCapturaInventario',
	'$menu.nome.monitoramentoativos');

update menu set ordem = 0 where nome = '$menu.nome.evm.acaoAutomatica';
update menu set ordem = 1 where nome = '$menu.nome.evm.acoesNotificacao';
update menu set ordem = 2 where nome = '$menu.nome.evm.acoesMudanca';
update menu set ordem = 3 where nome = '$menu.nome.evm.acoesProblema';
update menu set ordem = 4 where nome = '$menu.nome.evm.cadAcaoAutoIncReq';
update menu set ordem = 5 where nome = '$menu.nome.evm.ferramentasmonitoracao';
update menu set ordem = 6 where nome = '$menu.nome.evm.horario';
update menu set ordem = 7 where nome = '$menu.nome.evm.conexoesInventory';
update menu set ordem = 8 where nome = '$menu.nome.evm.conexoesEventMonitor';
update menu set ordem = 9 where nome = '$menu.nome.evm.check';
update menu set ordem = 10 where nome = '$menu.nome.evm.statusinventory';
update menu set ordem = 11 where nome = '$menu.nome.evm.gerente.nagios';
update menu set ordem = 12 where nome = '$menu.nome.evm.gerente.zabbix';
update menu set ordem = 13 where nome = '$menu.nome.evm.gerente.inventory';
update menu set ordem = 14 where nome = '$menu.nome.evm.gerente.correlacao';
update menu set ordem = 15 where nome = '$menu.nome.evm.gerente.generico.nagios';
update menu set ordem = 16 where nome = '$menu.nome.evm.gerenciamentoeventos';
update menu set ordem = 17 where nome = '$menu.nome.evm.categoriaOcorrencia';
update menu set ordem = 18 where nome = '$menu.nome.evm.trilhaAuditoria';

update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.gerenciaNivelServico') as tbl) 
where nome = '$menu.nome.avaliacaoContrato' 
or nome = '$menu.nome.avaliarSLA'
or nome = '$menu.nome.avaliacaoPorFornecedor'
or nome = '$menu.nome.planoMelhoria'
or nome = '$menu.nome.acordoNivelServico'
or nome = '$menu.nome.metaNivelServico'
or nome = '$menu.nome.tempoAtendimento';

update menu set ordem = 0 where nome = '$menu.nome.tempoAtendimento';
update menu set ordem = 1 where nome = '$menu.nome.acordoNivelServico';
update menu set ordem = 2 where nome = '$menu.nome.avaliarSLA';
update menu set ordem = 3 where nome = '$menu.nome.avaliacaoPorFornecedor';
update menu set ordem = 4 where nome = '$menu.nome.avaliacaoContrato';
update menu set ordem = 5 where nome = '$menu.nome.planoMelhoria';

update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.recursosHumanos') as tbl) 
where nome = '$menu.nome.cadastrosRH.idioma' 
or nome = '$menu.nome.pesquisaCurrriculo';

update menu set datafim = now() 
where nome in('$menu.nome.atitudeIndividual',
	'$menu.nome.certificacao',
	'$menu.nome.conhecimento',
	'$menu.nome.curriculo',
	'$menu.nome.curso',
	'$menu.nome.experienciaInformatica',
	'$menu.nome.formacaoAcademica',
	'$menu.nome.habilidade',
	'$menu.nome.horarioTrabalho',
	'$ManualFuncao.Titulo',
	'$menu.nome.justificativaRequisicaoFuncao',
	'$rh.justificativaListaNegra',
	'$menu.nome.experiencia',
	'$menu.nome.atribuicaoRequisicaoFuncao',
	'$menu.nome.comportamentoAtitude',
	'$menu.nome.comportamento',
	'$rh.historicoFuncional',
	'$menu.nome.dicionario');

update menu set ordem = 0 where nome = '$menu.nome.cadastrosRH.idioma';
update menu set ordem = 1 where nome = '$menu.nome.pesquisaCurrriculo';

update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.compras') as tbl) 
where nome = '$menu.nome.unidadeMedida' 
or nome = '$menu.nome.categoriaProduto'
or nome = '$menu.nome.tipoProduto'
or nome = '$menu.nome.produto'
or nome = '$menu.nome.justificativaParecer'
or nome = '$menu.nome.cotacao'
or nome = '$menu.nome.criterioAvaliacao'
or nome = '$menu.nome.marca'
or nome = '$menu.nome.avaliacaoFornecedor'
or nome = '$menu.nome.nivelAutoridade'
or nome = '$menu.nome.projeto';

update menu set ordem = 0 where nome = '$menu.nome.categoriaProduto';
update menu set ordem = 1 where nome = '$menu.nome.unidadeMedida';
update menu set ordem = 2 where nome = '$menu.nome.tipoProduto';
update menu set ordem = 3 where nome = '$menu.nome.produto';
update menu set ordem = 4 where nome = '$menu.nome.justificativaParecer';
update menu set ordem = 5 where nome = '$menu.nome.cotacao';
update menu set ordem = 6 where nome = '$menu.nome.criterioAvaliacao';
update menu set ordem = 7 where nome = '$menu.nome.marca';
update menu set ordem = 8 where nome = '$menu.nome.avaliacaoFornecedor';
update menu set ordem = 9 where nome = '$menu.nome.nivelAutoridade';
update menu set ordem = 10 where nome = '$menu.nome.projeto';
update menu set ordem = 11 where nome = '$menu.nome.limiteAprovacao';
update menu set ordem = 12 where nome = '$menu.nome.centroResultado';
update menu set ordem = 13 where nome = '$menu.nome.delegacaoCentroResultado';
update menu set ordem = 14 where nome = '$menu.nome.delegacaoCentroResultadoResp';
update menu set ordem = 15 where nome = '$menu.nome.simulacaoAlcada';
update menu set ordem = 16 where nome = '$menu.nome.qualificacaoFornecedor';

update menu set datafim = now() where link in ('%dinamicViews.load?identificacao=ReqSLA%');
-- FIM - [joao.morais] - 11/02/2016

-- INCIO - [deborah.ferreira] - 12/02/2016

CREATE TABLE auditoriaeventosgerentes (
	id INT(11) NOT NULL,
	idauditoriaeventos BIGINT NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idgerente INT(11) NOT NULL,
	tipogerente CHAR(1) NULL,
	nomegerente VARCHAR(255) NOT NULL,
	conexao VARCHAR(50) NOT NULL,
	agendador VARCHAR(50) NOT NULL,
	ativarautocorrecao CHAR(1) NOT NULL,
	qtdexecucoesagendador INT(11),
	nomeitemconfiguracaopai TEXT,
	host VARCHAR(50),
	grupocategoriaocorrencia VARCHAR(200),
	categoriaocorrencia VARCHAR(200),
	gerarocorrenciasup CHAR(1) NULL,
	acaoup VARCHAR(255) NULL,
	urgenciaup CHAR(1) NULL,
	impactoup CHAR(1) NULL,
	gerarocorrenciasdown CHAR(1) NULL,
	acaodown VARCHAR(255) NULL,
	urgenciadown CHAR(1) NULL,
	impactodown CHAR(1) NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventos) REFERENCES auditoriaeventos (idauditoriaeventos)
);

-- FIM - [deborah.ferreira] - 12/02/2016

-- INICIO - [joao.morais] - 23/05/2016
alter table itemconfiguracao ENGINE=InnoDB;
-- FIM - [joao.morais] - 23/05/2016

-- INICIO - thyen.chang - 12.02.2016

CREATE TABLE itemconfiguracaovalor(
  iditemconfiguracaovalor BIGINT NOT NULL,
  iditemconfiguracao INT(11) NOT NULL,
  datainiciovalor DATE NOT NULL,
  datafimvalor DATE,
  datafim DATE,
  valor DOUBLE NOT NULL,
  PRIMARY KEY (iditemconfiguracaovalor),
  CONSTRAINT fk_itemconfiguracaovalor FOREIGN KEY (iditemconfiguracao) REFERENCES itemconfiguracao (iditemconfiguracao)
) ENGINE=InnoDB;

-- FIM - thyen.chang - 12.02.2016

--INICIO - joao.morais - 15/02/2016
create table categoriaameaca(
	idcategoriaameaca bigint(20) not null,
	nomecategoriaameaca varchar(255) not null,
	datafim date,
	primary key (idcategoriaameaca)
) ENGINE=InnoDB;
-- FIM - joao.morais - 15/02/2016

--INICIO - [rodrigo.acorse] - 16/02/2015

create table continuidade (
	idcontinuidade bigint not null,
	nomeregistrocontinuidade varchar(500),
	idcliente int(11) not NULL,
	datainicio date not null,
	datafim date,
	primary key (idcontinuidade),
	constraint cliente_continuidade_pkey foreign key (idcliente) references  clientes(idcliente)
) ENGINE=InnoDB;

-- FIM - [rodrigo.acorse] - 16/02/2015

-- INICIO - joao.morais - 16/02/2016
create table ameaca(
	idameaca bigint(20) not null,
	nomeameaca varchar (255) not null,
	idcategoriaameaca bigint(20) not null,
	datafim date,
	primary key(idameaca),
	constraint fk_categoriaameaca foreign key (idcategoriaameaca) references categoriaameaca (idcategoriaameaca)
) ENGINE=InnoDB;
-- FIM - joao.morais - 16/02/2016

-- INCIO - [pedro.francisco] - 16/02/2016
alter table planomelhoria change datafim datafimplano date;
alter table planomelhoria change datainicio datainicioplano date;

alter table acaoplanomelhoria change datainicio datainicioacao date;
alter table acaoplanomelhoria change datafim datafimacao date;

alter table planomelhoria add datafim date;
-- FIM - [pedro.francisco] - 16/02/2016

-- INICIO - [deborah.ferreira] - 16/02/2016

ALTER TABLE ocorrenciaservicoatributosfinanceiros ADD classificacaoAtributosFinan INT;

CREATE TABLE ocorrenciaservicobaseconhecim (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idbaseconhecimento INT(11) NOT NULL,
  	nomebaseconhecimento VARCHAR(256) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

CREATE TABLE ocorrenciaservicohabilidade (
	id INT(11) NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idhabilidade BIGINT(11) NOT NULL,
  	nomehabilidade VARCHAR(255) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
) ENGINE=InnoDB;

-- FIM - [deborah.ferreira] - 16/02/2016
-- INICIO - rodrigo.acorse - 10/02/2016

delete from menu where nome = '$menu.nome.graficoTempoReal';
delete from menu where nome = '$menu.nome.monitoramento.incidente';

-- FIM - rodrigo.acorse - 10/02/2016

-- INICIO - gilmar.junior - 19/02/2016
ALTER TABLE processonegocio ADD idcliente int(11);
ALTER TABLE processonegocio ADD CONSTRAINT processonegocio_idcliente_fk FOREIGN KEY (idcliente) REFERENCES clientes (idcliente);
-- FIM - gilmar.junior - 19/02/2016
 
-- INICIO - [pedro.francisco] - 22/02/2016
create table iniciacaoescopo (
	idescopo INT(11) NOT NULL,
	idcontinuidade BIGINT NOT NULL,
	descricao varchar(255) not null,
	sumarioexecutivo varchar(255) not null,
	validade date not null,
	primary key (idescopo),
	constraint fk_cont_escopo foreign key (idcontinuidade) references continuidade (idcontinuidade)
) ENGINE=InnoDB;
alter table iniciacaoescopo add constraint continuidade_fk foreign key (idcontinuidade) references continuidade(idcontinuidade);
-- FIM - [pedro.francisco] - 22/02/2016

-- INICIO - joao.morais - 22/02/2016
create table iniciacaopolitica(
	idpolitica bigint not null,
	idcontinuidade bigint(20) not null,
	idgruporesponsavel int(11),
	idresponsavel int(11),
	titulo varchar(255) not null,
	datacriacao date not null,
	datavalidade date not null,
	descricao varchar(255),
	responsavel varchar(255),
	gruporesponsavel varchar(255),
	versao varchar(20) not null,
	datafim date,
	primary key(idpolitica),
	constraint fk_cont_politica foreign key (idcontinuidade) references continuidade(idcontinuidade),
	constraint fk_grupo_resp_politica foreign key (idgruporesponsavel) references grupo(idgrupo),
	constraint fk_responsavel_politica foreign key (idresponsavel) references empregados(idempregado)
) ENGINE=InnoDB;

alter table iniciacaopolitica change titulo tituloiniciacaopolitica varchar(255);
alter table iniciacaopolitica change versao versaoiniciacaopolitica varchar(20);
alter table iniciacaopolitica change descricao descricaoiniciacaopolitica varchar(255);
alter table iniciacaopolitica change datavalidade datavalidadeiniciacaopolitica date;
alter table iniciacaopolitica change responsavel responsaveliniciacaopolitica varchar(255);
-- FIM - joao.morais - 22/02/2016

-- INCIO - gilmar.junior - 11-05-2016
ALTER TABLE iniciacaopolitica DROP FOREIGN KEY fk_responsavel_politica;
ALTER TABLE iniciacaopolitica CHANGE idresponsavel idresponsaveliniciacaopolitica int(11);
ALTER TABLE iniciacaopolitica ADD CONSTRAINT fk_responsavel_politica FOREIGN KEY (idresponsaveliniciacaopolitica) REFERENCES empregados(idempregado);
ALTER TABLE iniciacaopolitica DROP FOREIGN KEY fk_grupo_resp_politica;
ALTER TABLE iniciacaopolitica CHANGE idgruporesponsavel idgruporespiniciacaopolitica int(11);
ALTER TABLE iniciacaopolitica ADD CONSTRAINT fk_grupo_resp_politica FOREIGN KEY (idgruporespiniciacaopolitica) REFERENCES grupo(idgrupo);
-- FIM - gilmar.junior - 11-05-2106

-- INCIO - [deborah.ferreira] - 22/02/2016

CREATE TABLE auditoriaeventosgerentesserv (
	id INT NOT NULL,
	idauditoriaeventosgerentes INT NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	nomeservico VARCHAR(255),
	nomeconfiguracao VARCHAR(400),
	nometipoconfiguracao VARCHAR(255),
	checkconfiguracao VARCHAR(255),
	grupocategoriaocorrencia VARCHAR(200),
	categoriaocorrencia VARCHAR(200),
	gerarocorrenciasinformation CHAR(1),
	eplinformation TEXT,
	condicaoinformation VARCHAR(50),
	valorcondicaoinformation VARCHAR(50),
	acaoinformation VARCHAR(255),
	urgenciainformation CHAR(1),
	impactoinformation CHAR(1),
	gerarocorrenciaswarning CHAR(1),
	eplwarning TEXT,
	condicaowarning VARCHAR(50),
	valorcondicaowarning VARCHAR(50),
	acaowarning VARCHAR(255),
	urgenciawarning CHAR(1),
	impactowarning CHAR(1),
	gerarocorrenciasexception CHAR(1),
	eplexception TEXT,
	condicaoexception VARCHAR(50),
	valorcondicaoexception VARCHAR(50),
	acaoexception VARCHAR(255),
	urgenciaexception CHAR(1),
	impactoexception CHAR(1),
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventosgerentes) REFERENCES auditoriaeventosgerentes (id)
) ENGINE=InnoDB;

CREATE TABLE auditoriaeventosgergennagios (
	id INT NOT NULL,
	idauditoriaeventos BIGINT NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idgerente INT NOT NULL,
	nomegerente VARCHAR(255) NOT NULL,
	conexao VARCHAR(50) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventos) REFERENCES auditoriaeventos (idauditoriaeventos)
) ENGINE=InnoDB;

CREATE TABLE auditoriaeventosgergennagserv (
	id INT NOT NULL,
	idauditoriaeventosgergennagios INT NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idlinha INT NOT NULL,
	hostservico VARCHAR(50),
	nomeservico VARCHAR(50),
	grupocategoriaocorrencia VARCHAR(200) NOT NULL,
	categoriaocorrencia VARCHAR(200) NOT NULL,
	agendador VARCHAR(50) NOT NULL,
	servicoativo CHAR(1) NULL,
	gerarocorrenciasup CHAR(1) NULL,
	acaoup VARCHAR(255) NULL,
	urgenciaup CHAR(1) NULL,
	impactoup CHAR(1) NULL,
	gerarocorrenciasdown CHAR(1) NULL,
	acaodown VARCHAR(255) NULL,
	urgenciadown CHAR(1) NULL,
	impactodown CHAR(1) NULL,
	gerarocorrenciasinformation CHAR(1),
	acaoinformation VARCHAR(255),
	urgenciainformation CHAR(1),
	impactoinformation CHAR(1),
	gerarocorrenciaswarning CHAR(1),
	acaowarning VARCHAR(255),
	urgenciawarning CHAR(1),
	impactowarning CHAR(1),
	gerarocorrenciasexception CHAR(1),
	acaoexception VARCHAR(255),
	urgenciaexception CHAR(1),
	impactoexception CHAR(1),
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventosgergennagios) REFERENCES auditoriaeventosgergennagios (id)
) ENGINE=InnoDB;


CREATE TABLE auditoriaeventosgerentecorrel (
	id INT NOT NULL,
	idauditoriaeventos BIGINT NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idgerente INT NOT NULL,
	nomegerente VARCHAR(255) NOT NULL,
	conexao VARCHAR(50) NOT NULL,
	grupocategoriaocorrencia VARCHAR(200) NOT NULL,
	categoriaocorrencia VARCHAR(200) NOT NULL,
	acaoinformation VARCHAR(255),
	urgenciainformation CHAR(1),
	impactoinformation CHAR(1),
	eplinformation TEXT,
	acaowarning VARCHAR(255),
	urgenciawarning CHAR(1),
	impactowarning CHAR(1),
	eplwarning TEXT,
	acaoexception VARCHAR(255),
	urgenciaexception CHAR(1),
	impactoexception CHAR(1),
	eplexception TEXT,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventos) REFERENCES auditoriaeventos (idauditoriaeventos)
) ENGINE=InnoDB;

-- FIM - [deborah.ferreira] - 22/02/2016

-- INICIO - [pedro.francisco] - 24/02/2016
create table funcoesvitais (
	idfuncaovital int not null,
	idcontinuidade bigint not null,
	nome varchar(255) not null,
	idprocessonegocio int not null,
	prioridade int not null,
	datafim DATE,
	primary key (idfuncaovital),
	constraint fk_fvital2 foreign key (idcontinuidade) references continuidade(idcontinuidade),
	constraint fk_fvital_pn1 foreign key (idprocessonegocio) references processonegocio(idprocessonegocio)
) ENGINE=InnoDB;
-- FIM - [pedro.francisco] - 24/02/2016

-- INCIO [gustavo.gomes] 03.02.2016
CREATE TABLE servicobaseconhecimento
(
	idservicobaseconhecimento bigint not null,
	idservico bigint not null,
	idbaseconhecimento int(11) not null,
	PRIMARY KEY (idservicobaseconhecimento) ,
	constraint fk_servbase_servico foreign key (idservico) references servico (idservico)
);

CREATE TABLE categoriarisco
(
	idcategoriarisco bigint NOT NULL,
	nome VARCHAR(255) NOT NULL ,
	tag VARCHAR(255),
	cor VARCHAR(255),
	icone VARCHAR(255),
	datafim DATE,
	PRIMARY KEY (idcategoriarisco)
);

ALTER TABLE risco ADD (idcategoriarisco bigint);
ALTER TABLE risco ADD FOREIGN KEY (idcategoriarisco) REFERENCES categoriarisco(idcategoriarisco);
ALTER TABLE ameaca ADD (tipo VARCHAR(1));

CREATE TABLE ameacarisco
(
	idameacariscocont bigint NOT NULL,
	idrisco bigint NOT NULL,
	idameaca bigint NOT NULL,
	PRIMARY KEY (idameacariscocont)
);
-- FIM [gustavo.gomes] 17.02.2016
-- INICIO - [thyen.chang] - 25.02.2016
	
CREATE TABLE problemaserviconegocio(
  idproblemaserviconegocio INT NOT NULL
  ,idproblema INT(11) NOT NULL
  ,idservico BIGINT(20) NOT NULL
  ,PRIMARY KEY (idproblemaserviconegocio)
  ,FOREIGN KEY (idproblema) REFERENCES problema (idproblema)
  ,FOREIGN KEY (idservico) REFERENCES servico (idservico)
) ENGINE=InnoDB;

-- FIM - [thyen.chang] - 25.02.2016

-- INICIO [deborah.ferreira] - 26.02.2016

CREATE TABLE iniciacaoprojeto (
	idiniciacaoprojeto INT NOT NULL,
	idcontinuidadeiniciacaoprojeto BIGINT NOT NULL,
	idprojetoiniciacaoprojeto INT NOT NULL,
	PRIMARY KEY (idiniciacaoprojeto),
	FOREIGN KEY (idcontinuidadeiniciacaoprojeto) REFERENCES continuidade (idcontinuidade),
	FOREIGN KEY (idprojetoiniciacaoprojeto) REFERENCES projetos (idprojeto)
) ENGINE=InnoDB;

-- FIM [deborah.ferreira] - 26.02.2016
-- INICIO - euler.ramos - 18/02/2016

CREATE TABLE configdestinatario 
( 
  idconfigdestinatario bigint(20) NOT NULL, 
  nomeconfigdestinatario varchar(254) NOT NULL, 
  datahorafim timestamp, 
  CONSTRAINT pkconfigdestinatario PRIMARY KEY (idconfigdestinatario) 
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE destinatarioempregados 
( 
  idconfigdestinatario bigint(20) NOT NULL, 
  idempregado int(11) NOT NULL, 
  CONSTRAINT pkdestinatarioempregados PRIMARY KEY (idconfigdestinatario, idempregado), 
  CONSTRAINT fkconfigdestempdest FOREIGN KEY (idconfigdestinatario) 
      REFERENCES configdestinatario (idconfigdestinatario) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
  CONSTRAINT fkconfigdestempemp FOREIGN KEY (idempregado) 
      REFERENCES empregados (idempregado) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT 
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE destinatariogrupos 
( 
  idconfigdestinatario bigint(20) NOT NULL, 
  idgrupo int(11) NOT NULL, 
  CONSTRAINT pkdestinatariogrupos PRIMARY KEY (idconfigdestinatario, idgrupo), 
  CONSTRAINT fkconfigdestgrpdest FOREIGN KEY (idconfigdestinatario) 
      REFERENCES configdestinatario (idconfigdestinatario) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
 CONSTRAINT fkconfigdestgrpgrp FOREIGN KEY (idgrupo) 
      REFERENCES grupo (idgrupo) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT 
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE configeventonotificacao 
( 
  idconfigeventonotificacao bigint(20) NOT NULL, 
  identificador varchar(254) NOT NULL, 
  classenegocio varchar(254) NOT NULL, 
  descricao varchar(254) NOT NULL, 
  epl text NOT NULL, 
  nivelalerta varchar(254) NOT NULL, 
  prazoconfirmacao integer, 
  prazoalerta integer, 
  prazoescalonamento integer, 
  idconfigdestinatarioinicial bigint(20) not null, 
  idmodeloemailinicial int(11) NOT NULL, 
  idconfigdestinatarioescalon bigint(20) null, 
  idmodeloemailescalonamento int(11), 
  datahorafim timestamp, 
  exigeconfirmacao character(1) NOT NULL, 
  CONSTRAINT pkconfigeventonotificacao PRIMARY KEY (idconfigeventonotificacao), 
  CONSTRAINT fkconfigevnotmailini FOREIGN KEY (idmodeloemailinicial) 
      REFERENCES modelosemails (idmodeloemail) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
  CONSTRAINT fkconfigevnotmailesc FOREIGN KEY (idmodeloemailescalonamento) 
      REFERENCES modelosemails (idmodeloemail) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
  CONSTRAINT fkconfigevnotdestini FOREIGN KEY (idconfigdestinatarioinicial) 
      REFERENCES configdestinatario (idconfigdestinatario) MATCH SIMPLE  
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
  CONSTRAINT fkconfigevnotdestesc FOREIGN KEY (idconfigdestinatarioescalon) 
      REFERENCES configdestinatario (idconfigdestinatario) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT 
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE modeloepl 
( 
  idmodeloepl integer NOT NULL, 
  descricao varchar(255) NOT NULL, 
  modeloepl text NOT NULL, 
  datahorafim timestamp, 
  CONSTRAINT modeloepl_pkey PRIMARY KEY (idmodeloepl) 
);

-- FIM - euler.ramos - 18/02/2016

-- INICIO - thyen.chang - 29.02.2016

CREATE TABLE indicadorcapacidade( 
	idindicadorcapacidade INTEGER NOT NULL, 
	nome VARCHAR(255) NOT NULL, 
	valor VARCHAR(255) NOT NULL, 
	datahorafim TIMESTAMP NULL, 
	CONSTRAINT PK_INDICADORCAPACIDADE PRIMARY KEY (idindicadorcapacidade) 
)ENGINE=InnoDB;

CREATE TABLE indicadorescapacidadeservico(
	idindicadorcapacidadeservico INTEGER NOT NULL
	,idindicadorcapacidade INTEGER NOT NULL
	,idservico INTEGER NOT NULL
	,CONSTRAINT pk_capser PRIMARY KEY (idindicadorcapacidadeservico)
	,CONSTRAINT fk_capser_indcap FOREIGN KEY (idindicadorcapacidade) REFERENCES indicadorcapacidade (idindicadorcapacidade) 
)ENGINE=InnoDB;

-- FIM - thyen.chang - 29.02.2016

-- INICIO - douglas.japiassu - 01.03.2016
alter table servico add incidentecritico char(1) null;
-- FIM - douglas.japiassu - 01.03.2016

-- INICIO - thyen.chang - 01.03.2016

CREATE TABLE atributodemanda( 
	idatributodemanda INTEGER NOT NULL, 
	nome VARCHAR(255) NOT NULL, 
	valor VARCHAR(255) NOT NULL, 
	datahorafim TIMESTAMP NULL, 
	CONSTRAINT PK_ATRIBUTODEMANDA PRIMARY KEY (idatributodemanda) 
)ENGINE=InnoDB;

CREATE TABLE atributodemandaservico(
	idatributodemandaservico INTEGER NOT NULL
	,idatributodemanda INTEGER NOT NULL
	,idservico INTEGER NOT NULL
	,CONSTRAINT pk_demser PRIMARY KEY (idatributodemandaservico)
	,CONSTRAINT fk_demser_atrdem FOREIGN KEY (idatributodemanda) REFERENCES atributodemanda (idatributodemanda) 
)ENGINE=InnoDB;

-- FIM - thyen.chang - 01.03.2016

-- INICIO [rodrigo.acorse] - 29.02.2016

CREATE TABLE cenario (
	idcenario bigint not null,
	nomecenario varchar(255) not null,
	idfuncaovital int not null,
	idcontinuidade bigint not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenario),
	FOREIGN KEY (idfuncaovital) REFERENCES funcoesvitais (idfuncaovital),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
) ENGINE=InnoDB;

CREATE TABLE cenariorisco (
	idcenariorisco bigint not null,
	idcenario bigint not null,
	idrisco int not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenariorisco),
	FOREIGN KEY (idcenario) REFERENCES cenario (idcenario),
	FOREIGN KEY (idrisco) REFERENCES risco (idrisco)
) ENGINE=InnoDB;

CREATE TABLE cenarioservico (
	idcenarioservico bigint not null,
	idcenario bigint not null,
	idservico bigint not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenarioservico),
	FOREIGN KEY (idcenario) REFERENCES cenario (idcenario),
	FOREIGN KEY (idservico) REFERENCES servico (idservico)
) ENGINE=InnoDB;

CREATE TABLE tratativa (
	idtratativa bigint not null,
	nometratativa varchar(255) not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idtratativa)
) ENGINE=InnoDB;

CREATE TABLE cenarioriscoameaca (
	idcenarioriscoameaca bigint not null,
	idcenariorisco bigint not null,
	idameaca bigint not null,
	probabilidade int not null,
	impacto decimal(10,2) not null,
	justificativa text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenarioriscoameaca),
	FOREIGN KEY (idcenariorisco) REFERENCES cenariorisco (idcenariorisco),
	FOREIGN KEY (idameaca) REFERENCES ameaca (idameaca)
) ENGINE=InnoDB;

CREATE TABLE cenarioriscotratativa (
	idcenarioriscotratativa bigint not null,
	idcenariorisco bigint not null,
	idtratativa bigint not null,
	probabilidade int not null,
	impacto decimal(10,2) not null,
	medidarecuperacao text,
	planomitigacao text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenarioriscotratativa),
	FOREIGN KEY (idcenariorisco) REFERENCES cenariorisco (idcenariorisco),
	FOREIGN KEY (idtratativa) REFERENCES tratativa (idtratativa)
) ENGINE=InnoDB;

CREATE TABLE cenarioriscotratativaameaca (
	idtratativaameaca bigint not null,
	idcenarioriscotratativa bigint not null,
	idcenarioriscoameaca bigint not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idtratativaameaca),
	FOREIGN KEY (idcenarioriscotratativa) REFERENCES cenarioriscotratativa (idcenarioriscotratativa),
	FOREIGN KEY (idcenarioriscoameaca) REFERENCES cenarioriscoameaca (idcenarioriscoameaca)
) ENGINE=InnoDB;

-- FIM [rodrigo.acorse] - 29.02.2016

-- INICIO [gilmar.junior] - 02.03.2016
CREATE TABLE impactoain
(
  idimpactoain bigint NOT NULL,
  impactoain character varying(255) NOT NULL,
  datahorafim timestamp NULL DEFAULT NULL,
  PRIMARY KEY (idimpactoain)
)ENGINE=InnoDB;

CREATE TABLE analiseimpactonegocio
(
  idanaliseimpactonegocio bigint NOT NULL,
  idcontinuidade bigint NOT NULL,
  idfuncaovital int NOT NULL,
  impacto character varying(255),
  severidade char(1),
  custohora double precision,
  custoimpacto double precision,
  maxtoleravelinatividade varchar(8),
  objvtemporec varchar(8),
  objvpontorec varchar(8),
  estrategia1 text,
  estrategia2 text,
  estrategia3 text,
  datahorafim timestamp NULL DEFAULT NULL,
  PRIMARY KEY (idanaliseimpactonegocio)
)ENGINE=InnoDB;

alter table analiseimpactonegocio add constraint continuidade_fk foreign key (idcontinuidade) references continuidade(idcontinuidade);
alter table analiseimpactonegocio add constraint funcoesvitais_fk foreign key (idfuncaovital) references funcoesvitais(idfuncaovital);

-- FIM [gilmar.junior] - 02.03.2016

-- INICIO [deborah.ferreira] - 03.03.2016

CREATE TABLE planejamentoorganizacional (
	id INT(11) NOT NULL,
	idcontinuidade BIGINT NOT NULL,
	sumarioexecutivo TEXT NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE planejamentoorganizacionalgrp (
	id INT(11) NOT NULL,
	idplanejamentoorganizacional INT(11) NOT NULL,
	idgrupo INT(11) NOT NULL,
	tipogrupo CHAR(5) NOT NULL,
	responsabilidade VARCHAR(255) NOT NULL,
	datafim DATE,
	PRIMARY KEY (id),
	FOREIGN KEY (idplanejamentoorganizacional) REFERENCES planejamentoorganizacional (id)
);

-- FIM [deborah.ferreira] - 03.03.2016

-- INICIO [rodrigo.acorse] - 07.03.2016

CREATE TABLE calendarioevento (
	idevento bigint not null,
	idcontinuidade bigint not null,
	nomeevento varchar(255) not null,
	detalhesevento text,
	datainicioevento timestamp not null,
	datafimevento timestamp not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idevento)
) ENGINE=InnoDB;

CREATE TABLE calendarioeventogrupo (
	ideventogrupo bigint not null,
	idevento bigint not null,
	idgrupo int not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventogrupo),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idgrupo) REFERENCES grupo (idgrupo)
) ENGINE=InnoDB;

CREATE TABLE calendarioeventoempregado (
	ideventoempregado bigint not null,
	idevento bigint not null,
	idempregado int not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventoempregado),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idempregado) REFERENCES empregados (idempregado)
) ENGINE=InnoDB;

-- FIM [rodrigo.acorse] - 07.03.2016

-- INICIO [gilberto.ney] - 07.03.2016

CREATE TABLE liberacaobaseconhecimento (
	idliberacao INT(11) NOT NULL,
	idbaseconhecimento INT(11) NOT NULL,
	FOREIGN KEY (idliberacao) REFERENCES liberacao (idliberacao)
);

-- FIM [gilberto.ney] - 07.03.2016

-- INICIO [euler.ramos] - 08.03.2016

CREATE TABLE conhecimentomidiasoftware( 
  idconhecimentomidiasoftware bigint NOT NULL, 
  idmidiasoftware INT(11) NOT NULL, 
  idbaseconhecimento INT(11) NOT NULL, 
  datafim date, 
  CONSTRAINT pkconhecimentomidiasoftware PRIMARY KEY (idconhecimentomidiasoftware), 
  CONSTRAINT fk_conhmsoft_midiasoftware FOREIGN KEY (idmidiasoftware) 
      REFERENCES midiasoftware (idmidiasoftware) MATCH SIMPLE 
      ON UPDATE NO ACTION ON DELETE NO ACTION 
);

-- FIM [euler.ramos] - 08.03.2016

-- INICIO - thyen.chang - 08.03.2016

CREATE TABLE indicadorescapacidadeic(
	idindicadorcapacidadeic INTEGER NOT NULL
	,idindicadorcapacidade INTEGER NOT NULL
	,iditemconfiguracao INTEGER NOT NULL
	,CONSTRAINT pk_capic PRIMARY KEY (idindicadorcapacidadeic)
	,CONSTRAINT fk_capic_indcap FOREIGN KEY (idindicadorcapacidade) REFERENCES indicadorcapacidade (idindicadorcapacidade) 
	,CONSTRAINT fk_capic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES itemconfiguracao (iditemconfiguracao) 
)ENGINE=InnoDB;

-- FIM - thyen.chang - 08.03.2016


-- INICIO [deborah.ferreira] - 08.03.2016

CREATE TABLE conscientizacao (
	idconscientizacao INT(11) NOT NULL,
	idcontinuidade BIGINT NOT NULL,
	sumarioexecutivo TEXT NOT NULL,
	PRIMARY KEY (idconscientizacao),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE conscientizacaoregistro (
	idconscientizacaoregistro INT(11) NOT NULL,
	idconscientizacao INT(11) NOT NULL,
	analisecriticaacao TEXT NOT NULL,
	tipoatividade CHAR(5) NOT NULL,
	status CHAR(5) NOT NULL,
	datafim DATE NULL,
	PRIMARY KEY (idconscientizacaoregistro),
	FOREIGN KEY (idconscientizacao) REFERENCES conscientizacao (idconscientizacao)
);

-- FIM [deborah.ferreira] - 08.03.2016

-- INCIO [douglas.japiassu] - 09.03.2016

CREATE TABLE estrategiacontinuidade (
	idestrategiacontinuidade bigint not null,
	idcontinuidade bigint not null,
	sumarioexecutivo text,
	objetivo text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idestrategiacontinuidade),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
) ENGINE=InnoDB;

CREATE TABLE estrategiafuncaovital (
	idestrategiafuncaovital bigint not null,
	idestrategiacontinuidade bigint not null,
	idfuncaovital int not null,
	PRIMARY KEY (idestrategiafuncaovital),
	FOREIGN KEY (idestrategiacontinuidade) REFERENCES estrategiacontinuidade (idestrategiacontinuidade),
	FOREIGN KEY (idfuncaovital) REFERENCES funcoesvitais (idfuncaovital)
) ENGINE=InnoDB;

CREATE TABLE medidaresposta (
	idmedidaresposta bigint not null,
	idestrategiacontinuidade bigint not null,
	idcenarioriscotratativa bigint not null,
	nome varchar(255) not null,
	justificativa text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idmedidaresposta),
	FOREIGN KEY (idestrategiacontinuidade) REFERENCES estrategiacontinuidade (idestrategiacontinuidade),
	FOREIGN KEY (idcenarioriscotratativa) REFERENCES cenarioriscotratativa (idcenarioriscotratativa)
) ENGINE=InnoDB;

CREATE TABLE medidarespostaprojeto (
	idmedidarespostaprojeto bigint not null,
	idmedidaresposta bigint not null,
	idprojeto int not null,
	PRIMARY KEY (idmedidarespostaprojeto),
	FOREIGN KEY (idmedidaresposta) REFERENCES medidaresposta (idmedidaresposta),
	FOREIGN KEY (idprojeto) REFERENCES projetos (idprojeto)
) ENGINE=InnoDB;

CREATE TABLE medidarecuperacao (
	idmedidarecuperacao bigint not null,
	idestrategiacontinuidade bigint not null,
	idcenarioriscotratativa bigint not null,
	nome varchar(255) not null,
	tiporecuperacao varchar(2) not null,
	justificativa text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idmedidarecuperacao),
	FOREIGN KEY (idestrategiacontinuidade) REFERENCES estrategiacontinuidade (idestrategiacontinuidade),
	FOREIGN KEY (idcenarioriscotratativa) REFERENCES cenarioriscotratativa (idcenarioriscotratativa)
) ENGINE=InnoDB;

CREATE TABLE medidarecuperacaobaseconhec (
	idmedidarecuperacaobaseconhec bigint not null,
	idmedidarecuperacao bigint not null,
	idbaseconhecimento int(11) not null,
	PRIMARY KEY (idmedidarecuperacaobaseconhec),
	FOREIGN KEY (idmedidarecuperacao) REFERENCES medidarecuperacao (idmedidarecuperacao)
) ENGINE=InnoDB;

-- FIM [douglas.japiassu] - 09.03.2016

-- INICIO - thyen.chang - 09.03.2016

CREATE TABLE atributodemandaic(
	idatributodemandaic INTEGER NOT NULL
	,idatributodemanda INTEGER NOT NULL
	,iditemconfiguracao INTEGER NOT NULL
	,PRIMARY KEY (idatributodemandaic)
	,CONSTRAINT fk_dmdic_atrdm FOREIGN KEY (idatributodemanda) REFERENCES atributodemanda (idatributodemanda)
	,CONSTRAINT fk_dmdic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES itemconfiguracao (iditemconfiguracao)
)ENGINE=InnoDB;

-- FIM - thyen.chang - 09.03.2016

-- INICIO [gilberto.ney] - 09.03.2016

CREATE TABLE mudancabaseconhecimento (
	idrequisicaomudanca INT(11) NOT NULL,
	idbaseconhecimento INT(11) NOT NULL,
	FOREIGN KEY (idrequisicaomudanca) REFERENCES requisicaomudanca (idrequisicaomudanca)
);

-- FIM [gilberto.ney] - 09.03.2016
--INICIO [gustavo.gomes] - 07.03.2016

CREATE TABLE auditoriacontinuidade(
	idauditoriacontinuidade BIGINT NOT NULL,
	idcontinuidade BIGINT NOT NULL,
	usuario VARCHAR(255) NOT NULL,
	datacriacao TIMESTAMP NOT NULL,
	categoriaauditoria VARCHAR(10) NOT NULL,
	tipoauditoria VARCHAR(10) NOT NULL,
	descricaoauditoria TEXT,
	PRIMARY KEY (idauditoriacontinuidade)
) ENGINE=InnoDB;

CREATE TABLE auditoriacontpolitica(
	idauditoriacontpolitica BIGINT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	titulopolitica VARCHAR(255),
	versaopolitica VARCHAR(20),
	datavalidadepolitica DATE,
	descricaopolitica VARCHAR(255),
	responsavelpolitica VARCHAR(255),
	PRIMARY KEY (idauditoriacontpolitica),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
) ENGINE=InnoDB;

CREATE TABLE auditoriacontescopo(
	idauditoriacontescopo BIGINT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoAuditoria CHAR(1) NULL,
	sumarioexecutivo VARCHAR(255),
	descricaoescopo VARCHAR(255),
	datavalidadeescopo DATE,
	PRIMARY KEY (idauditoriacontescopo),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
) ENGINE=InnoDB;

CREATE TABLE auditoriacontprojeto(
	idauditoriacontprojeto BIGINT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idprojeto BIGINT,
	nomeprojeto VARCHAR(255),
	PRIMARY KEY (idauditoriacontprojeto),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
) ENGINE=InnoDB;

--FIM [gustavo.gomes] 09.03.2016 
-- INICIO [gilberto.ney] - 10.03.2016

SET @maxId = (select idtipodemandaservico + 1 from tipodemandaservico order by idtipodemandaservico desc limit 1);
INSERT INTO tipodemandaservico (@maxId,nometipodemandaservico,classificacao,deleted) VALUES (9999,'Procedimento','P',NULL);

-- FIM [gilberto.ney] - 10.03.2016
-- INICIO [deborah.ferreira] - 11.03.2016

CREATE TABLE auditoriacontinuidadeanexos (
	idauditoriacontinuidadeanexos INT(11) NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idanexo INT(11) NOT NULL,
	idregistro INT(11) NOT NULL,
	nomeanexo VARCHAR(255) NOT NULL,
	descricaoanexo VARCHAR(255) NOT NULL,
	PRIMARY KEY (idauditoriacontinuidadeanexos),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
) ENGINE=InnoDB;

CREATE TABLE auditoriacontfuncaovital(
	idauditoriacontfuncaovital INT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idfuncaovital INT NOT NULL,
	nomefuncaovital VARCHAR(255) NOT NULL,
	nomeprocessonegocio VARCHAR(100) NOT NULL,
	prioridadefuncaovital INT NOT NULL,
	PRIMARY KEY (idauditoriacontfuncaovital),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

-- FIM [deborah.ferreira] - 11.03.2016

-- INICIO [joao.morais] - 14.03.2016

CREATE TABLE auditoriacontavalrisco(
	idauditoriacontavalrisco INT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenario BIGINT NOT NULL,
	nomecenario varchar(255) NOT NULL,
	nomefuncaovital varchar(255) NOT NULL,
	PRIMARY KEY (idauditoriacontavalrisco),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
)ENGINE=InnoDB;

CREATE TABLE auditoriacontavalriscoserv(
	idauditoriacontavalriscoserv INT NOT NULL,
	idauditoriacontavalrisco INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenarioservico BIGINT NOT NULL,
	idservico bigint(20) NOT NULL,
	nomeservico VARCHAR(500) NOT NULL,
	PRIMARY KEY (idauditoriacontavalriscoserv),
	FOREIGN KEY (idauditoriacontavalrisco) REFERENCES auditoriacontavalrisco (idauditoriacontavalrisco)
)ENGINE=InnoDB;

CREATE TABLE auditoriacontavalriscorisco(
	idauditoriacontavalriscorisco INT NOT NULL,
	idauditoriacontavalrisco INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenariorisco BIGINT not null,
	idrisco INT NOT NULL,
	nomerisco VARCHAR(150) NOT NULL,
	PRIMARY KEY (idauditoriacontavalriscorisco),
	FOREIGN KEY (idauditoriacontavalrisco) REFERENCES auditoriacontavalrisco (idauditoriacontavalrisco)
)ENGINE=InnoDB;

CREATE TABLE auditoriacontavalriscotrata(
	idauditoriacontavalriscotrata INT NOT NULL,
	idauditoriacontavalriscorisco INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenarioriscotratativa BIGINT NOT NULL,
	idtratativa BIGINT NOT NULL,
	nometratativa VARCHAR(255) NOT NULL,
	probabilidade INT NOT NULL,
	impacto DECIMAL(10,2) NOT NULL,
	propostamedidarecuperacao TEXT,
	propostaplanomitigacao TEXT,
	ameacasrelacionadas TEXT,
	PRIMARY KEY (idauditoriacontavalriscotrata),
	FOREIGN KEY (idauditoriacontavalriscorisco) REFERENCES auditoriacontavalriscorisco (idauditoriacontavalriscorisco)
)ENGINE=InnoDB;

CREATE TABLE auditoriacontavalriscoameaca(
	idauditoriacontavalriscameaca INT NOT NULL,
	idauditoriacontavalriscorisco INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenarioriscoameaca BIGINT NOT NULL,
	idameaca BIGINT(20) NOT NULL,
	nomeameaca VARCHAR (255) NOT NULL,
	nomecategoriaameaca VARCHAR(255) NOT NULL,
	probabilidade INT NOT NULL,
	impacto DECIMAL(10,2) NOT NULL,
	justificativa TEXT,
	PRIMARY KEY (idauditoriacontavalriscameaca),
	FOREIGN KEY (idauditoriacontavalriscorisco) REFERENCES auditoriacontavalriscorisco (idauditoriacontavalriscorisco)
)ENGINE=InnoDB;

CREATE TABLE auditoriaestcontservico(
	idauditoriaestcontservico INT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idestrategiacontinuidade BIGINT NOT NULL,
	sumarioexecutivo TEXT,
	objetivo TEXT,
	PRIMARY KEY (idauditoriaestcontservico),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
)ENGINE=InnoDB;

CREATE TABLE auditoriaestcontservfuncvital(
	idauditoriaestcontservfuncvit INT4 NOT NULL,
	idauditoriaestcontservico INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idfuncaovital INT NOT NULL,
	nomefuncaovital VARCHAR(255),
	PRIMARY KEY (idauditoriaestcontservfuncvit),
	FOREIGN KEY (idauditoriaestcontservico) REFERENCES auditoriaestcontservico (idauditoriaestcontservico)
)ENGINE=InnoDB;

CREATE TABLE auditoriaestcontservmedidarec(
	idauditoriaestcontservmedrec INT NOT NULL,
	idauditoriaestcontservico INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	nometratativa VARCHAR(255) NOT NULL,
	idmedidarecuperacao BIGINT NOT NULL,
	nomemedidarecuperacao VARCHAR(255) NOT NULL,
	tiporecuperacao VARCHAR(2) NOT NULL,
	medidarecuperacao TEXT,
	justificativamedidarecuperacao TEXT,
	PRIMARY KEY (idauditoriaestcontservmedrec),
	FOREIGN KEY (idauditoriaestcontservico) REFERENCES auditoriaestcontservico (idauditoriaestcontservico)
)ENGINE=InnoDB;

CREATE TABLE auditoriaestcontservbaseconhec(
	idauditoriaestcontservbaseconh INT NOT NULL,
	idauditoriaestcontservmedrec INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idmedidarecuperacaobaseconhec BIGINT NOT NULL,
	nomebaseconhecimento varchar(256) NOT NULL,
	PRIMARY KEY (idauditoriaestcontservbaseconh),
	FOREIGN KEY (idauditoriaestcontservmedrec) REFERENCES auditoriaestcontservmedidarec (idauditoriaestcontservmedrec)
)ENGINE=InnoDB;

CREATE TABLE auditoriaestcontservmedresp(
	idauditoriaestcontservmedresp INT NOT NULL,
	idauditoriaestcontservico INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	nometratativa VARCHAR(255) NOT NULL,
	idmedidaresposta BIGINT NOT NULL,
	nomemedidaresposta VARCHAR(255) NOT NULL,
	planomitigacao TEXT,
	justificativa TEXT,
	nomeprojeto TEXT,
	PRIMARY KEY (idauditoriaestcontservmedresp),
	FOREIGN KEY (idauditoriaestcontservico) REFERENCES auditoriaestcontservico (idauditoriaestcontservico)
)ENGINE=InnoDB;

CREATE TABLE auditoriaplanocontinuidade(
	idauditoriaplanocontinuidade INT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanodecontinuidade INT NOT NULL,
	tituloplanocontinuidade varchar(255) NOT NULL,
	statusplanocontinuidade INT NOT NULL,
	descricaoplanocontinuidade varchar(255) NOT NULL,
	nomeprocedimentocontinuidade varchar(254) NOT NULL,
	nomeresponsavel varchar(256) DEFAULT NULL,
	datavalidade DATE NOT NULL,
	autorizacao INT NOT NULL,
	nomemudanca TEXT,
	PRIMARY KEY (idauditoriaplanocontinuidade),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
)ENGINE=InnoDB;

CREATE TABLE auditoriaplanocontconhecimento(
	idauditoriaplancontconheciment INT NOT NULL,
	idauditoriaplanocontinuidade INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanocontinuidadeconheciment BIGINT NOT NULL,
	nomeconhecimento varchar(256) NOT NULL,
	PRIMARY KEY (idauditoriaplancontconheciment),
	FOREIGN KEY (idauditoriaplanocontinuidade) REFERENCES auditoriaplanocontinuidade (idauditoriaplanocontinuidade)
)ENGINE=InnoDB;

CREATE TABLE auditoriaplanocontmedidarec(
	idauditoriaplanocontmedidarec INT NOT NULL,
	idauditoriaplanocontinuidade INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanocontinuidademedidarec BIGINT NOT NULL,
	medidarecuperacao varchar(255) not null,
	PRIMARY KEY (idauditoriaplanocontmedidarec),
	FOREIGN KEY (idauditoriaplanocontinuidade) REFERENCES auditoriaplanocontinuidade (idauditoriaplanocontinuidade)
)ENGINE=InnoDB;

CREATE TABLE auditoriacontplanorganiza(
	idauditoriacontplanorganiza INT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanejamentoorganizacional INT(11) NOT NULL,
	sumarioexecutivo TEXT NOT NULL,
	PRIMARY KEY (idauditoriacontplanorganiza),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
)ENGINE=InnoDB;

CREATE TABLE auditoriacontplanorggrupo(
	idauditoriacontplanorggrupo INT NOT NULL,
	idauditoriacontplanorganiza INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanorganizacionalgrp INT(11) NOT NULL,
	tipogrupo CHAR(5) NOT NULL,
	nomegrupo VARCHAR(255) NOT NULL,
	responsabilidade VARCHAR(255) NOT NULL,
	PRIMARY KEY(idauditoriacontplanorggrupo),
	FOREIGN KEY(idauditoriacontplanorganiza) REFERENCES auditoriacontplanorganiza (idauditoriacontplanorganiza)
)ENGINE=InnoDB;

CREATE TABLE auditoriacontconscientizacao(
	idauditoriacontconscientizacao INT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idconscientizacao INT(11) NOT NULL,
	sumarioexecutivo TEXT NOT NULL,
	PRIMARY KEY(idauditoriacontconscientizacao),
	FOREIGN KEY(idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
)ENGINE=InnoDB;

CREATE TABLE auditoriacontconscientregistro(
	idauditoriacontconscientregist INT NOT NULL,
	idauditoriacontconscientizacao INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idconscientizacaoregistro INT(11) NOT NULL,
	analisecriticaacao TEXT NOT NULL,
	tipoatividade CHAR(5) NOT NULL,
	status CHAR(5) NOT NULL,
	PRIMARY KEY(idauditoriacontconscientregist),
	FOREIGN KEY(idauditoriacontconscientizacao) REFERENCES auditoriacontconscientizacao (idauditoriacontconscientizacao)
)ENGINE=InnoDB;

CREATE TABLE auditoriaestrategiatestes(
	idauditoriaestrategiatestes INT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria char(1) null,
	idestrategiatestes BIGINT NOT NULL,
	nomeestrategiateste varchar(254) not null,
	sumarioexecutivoestteste text,
	PRIMARY KEY (idauditoriaestrategiatestes),
	FOREIGN KEY(idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
)ENGINE=InnoDB;

CREATE TABLE auditoriaesttestmedrecup(
	idauditoriaesttestmedrecup INT NOT NULL,
	idauditoriaestrategiatestes INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idmedidarecuperacao BIGINT NOT NULL,
	nomemedidarecuperacao varchar(255) NOT NULL,
	idplanoteste BIGINT NOT NULL,
	nomeplanoteste VARCHAR(255),
	descplanoteste TEXT,
	datainicio DATETIME DEFAULT NULL,
	datatermino DATETIME DEFAULT NULL,
	tipoteste VARCHAR(255) NULL,
	idtemplatecontinuidade INT NULL,
	nometemplatecontinuidade VARCHAR(200) NULL,
	PRIMARY KEY (idauditoriaesttestmedrecup),
	FOREIGN KEY (idauditoriaestrategiatestes) REFERENCES auditoriaestrategiatestes (idauditoriaestrategiatestes)
)ENGINE=InnoDB;

CREATE TABLE auditoriaestrtestplantestgrp(
	idauditoriaestrtestplantestgrp INT NOT NULL,
	idauditoriaesttestmedrecup INT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	planotestegrupo BIGINT NOT NULL,
	idgrupo INT(11) NOT NULL,
	nomegrupo VARCHAR(255) NOT NULL,
	tipo INTEGER NULL,
	PRIMARY KEY (idauditoriaestrtestplantestgrp),
	FOREIGN KEY (idauditoriaesttestmedrecup) REFERENCES auditoriaesttestmedrecup (idauditoriaesttestmedrecup)
)ENGINE=InnoDB;

-- FIM [joao.morais] - 14.03.2016

-- INICIO [joao.morais] - 19.03.2016

CREATE TABLE auditoriaconttestes(
	idauditoriaconttestes INT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	idevento BIGINT NOT NULL,
	nomeevento varchar(255) NOT NULL,
	detalhesevento TEXT,
	datainicioevento DATETIME NOT NULL,
	datafimevento DATETIME NOT NULL,
	acaoauditoria CHAR(1) null,
	PRIMARY KEY (idauditoriaconttestes),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
)ENGINE=InnoDB;

CREATE TABLE auditoriaconttesteventgrp(
	idauditoriaconttesteventgrp INT NOT NULL,
	idauditoriaconttestes INT NOT NULL,
	idgrupo INT(11) NOT NULL,
	nomegrupo varchar(255) NOT NULL,
	acaoauditoria CHAR(1) null,
	PRIMARY KEY (idauditoriaconttesteventgrp),
	FOREIGN KEY (idauditoriaconttestes) REFERENCES auditoriaconttestes (idauditoriaconttestes)
)ENGINE=InnoDB;

CREATE TABLE auditoriaconttesteventemp(
	idauditoriaconttesteventemp INT NOT NULL,
	idauditoriaconttestes INT NOT NULL,
	idempregado INT(11) NOT NULL,
	nomeempregado varchar(255) NOT NULL,
	acaoauditoria char(1) null,
	PRIMARY KEY (idauditoriaconttesteventemp),
	FOREIGN KEY (idauditoriaconttestes) REFERENCES auditoriaconttestes (idauditoriaconttestes)
)ENGINE=InnoDB;

CREATE TABLE auditoriaconttesteventevid(
	idauditoriaconttesteventevid INT NOT NULL,
	idauditoriaconttestes INT NOT NULL,
	nomeevidencia varchar(256) NOT NULL,
	acaoauditoria char(1) null,
	PRIMARY KEY (idauditoriaconttesteventevid),
	FOREIGN KEY (idauditoriaconttestes) REFERENCES auditoriaconttestes (idauditoriaconttestes)
)ENGINE=InnoDB;

CREATE TABLE auditoriacontinvocacao(
	idauditoriacontinvocacao INT not null,
	idauditoriacontinuidade BIGINT not null,
	acaoauditoria CHAR(1) null,
	idsolicitacaoservicoincidente BIGINT(20) NOT NULL,
	idsolicitacaoservicoprocedimen BIGINT(20) NOT NULL,
	nomeIncidente varchar(500) NOT NULL,
	nomeprocedimento varchar(500) NOT NULL,
	nomeresponsavel varchar(255) NOT NULL,
	nomegrupoatual varchar(255) NOT NULL,
	situacao varchar(100) NOT NULL,
	PRIMARY KEY (idauditoriacontinvocacao),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
)ENGINE=InnoDB;

-- FIM [joao.morais] - 19.03.2016

-- INICIO - thyen.chang - 12.03.2016

ALTER TABLE baseconhecimento ADD tipodocumento VARCHAR(3);

UPDATE baseconhecimento SET tipodocumento = (CASE WHEN faq = 'S' THEN 'F' WHEN erroconhecido = 'S' THEN 'E' ELSE 'D' END)

-- FIM - thyen.chang - 12.03.2016

-- INICIO [gilberto.ney] - 13.03.2016

SET @maxId = (select idmodeloemail + 1 from modelosemails order by idmodeloemail desc limit 1);
-- Cadastrar email de criacao de incidente critico 
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values (@maxid, 'CITSMART - Incidente Crtico criado. Nmero: ${IDSOLICITACAOSERVICO}',
'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que foi criado um incidente cr&iacute;tico. Incidente registrada em ${DATAHORASOLICITACAO}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Servi&ccedil;o:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'IncidenteCriticoCri');

-- Cadastrar email de aprovacao de incidente critico
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values (@maxid+1, 'CITSMART - Incidente Crtico aprovado. Nmero: ${IDSOLICITACAOSERVICO}',
'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que foi aprovado o incidente cr&iacute;tico n&uacute;mero: ${IDSOLICITACAOSERVICO}. Registrada em ${DATAHORASOLICITACAO}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Servi&ccedil;o:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'IncidenteCriticoApr');

-- Cadastrar email de criacao de incidente critico 
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values ((select idmodeloemail + 1 from modelosemails order by idmodeloemail desc limit 1), 'CITSMART - Critical Incident created. Number: ${IDSOLICITACAOSERVICO}',
'Mr(s) ${NOMECONTATO},<br /><br />Please be advised that the critical incident number ${IDSOLICITACAOSERVICO} was created. Registered on ${DATAHORASOLICITACAO}, as the data below:<br /><strong><br />Number:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Service:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Best regards,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'CriticalIncidentCreated');

-- Cadastrar email de aprovacao de incidente critico
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values ((select idmodeloemail + 1 from modelosemails order by idmodeloemail desc limit 1), 'CITSMART - Critical Incident approved. Number: ${IDSOLICITACAOSERVICO}', 
'Mr(s) ${NOMECONTATO},<br /><br />Please be advised that the critical incident number ${IDSOLICITACAOSERVICO} has been approved . Registered on ${DATAHORASOLICITACAO}, as the data below:<br /><strong><br />Number:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Service:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Best regards,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'CriticalIncidentApproved');

-- FIM [gilberto.ney] - 13.03.2016
-- INICIO [pedro.francisco] - 11.03.2016

create table planocontinuidade(
	idplanodecontinuidade int not null,
	idcontinuidade bigint not null,
	
	titulo varchar(255) not null,
	status integer not null,
	descricao varchar(255) not null,
	validade date not null,
	autorizacao integer not null,
	
	idresponsavel int,
	idresponsavelgrupo int,
	idprocedimentodecontinuidade bigint not null,
	
	datafim date,
	
	primary key(idplanodecontinuidade),
	constraint fk_resp_grupo_pc foreign key (idresponsavelgrupo) references grupo(idgrupo),
	constraint fk_resp_pc foreign key (idresponsavel) references empregados(idempregado),
	constraint fk_continuidade foreign key (idcontinuidade) references continuidade(idcontinuidade)
) ENGINE=InnoDB;

-- FIM [pedro.francisco] - 11.03.2016

-- INICIO - thyen.chang - 13.03.2016

CREATE TABLE planocontinuidadeconhecimento(
	idplanocontinuidadeconheciment BIGINT NOT NULL,
	idplanodecontinuidade int not null,
	idbaseconhecimento int not null,
	CONSTRAINT fk_pcc_pc FOREIGN KEY (idplanodecontinuidade) REFERENCES planocontinuidade (idplanodecontinuidade)
) ENGINE=InnoDB;

CREATE TABLE planocontinuidademudanca(
	idplanocontinuidademudanca BIGINT NOT NULL,
	idplanodecontinuidade int not null,
	idrequisicaomudanca int not null,
	CONSTRAINT fk_pcm_pc FOREIGN KEY (idplanodecontinuidade) REFERENCES planocontinuidade (idplanodecontinuidade),
	CONSTRAINT fk_pcm_rm FOREIGN KEY (idrequisicaomudanca) REFERENCES requisicaomudanca (idrequisicaomudanca)
) ENGINE=InnoDB;

CREATE TABLE planocontinuidademedidarec(
	idplanocontinuidademedidarec BIGINT NOT NULL,
	idplanodecontinuidade int not null,
	idmedidarecuperacao bigint not null,
	CONSTRAINT fk_pcmr_pc FOREIGN KEY (idplanodecontinuidade) REFERENCES planocontinuidade (idplanodecontinuidade),
	CONSTRAINT fk_pcmr_mr FOREIGN KEY (idmedidarecuperacao) REFERENCES medidarecuperacao (idmedidarecuperacao)
) ENGINE=InnoDB;

-- FIM - thyen.chang - 13.03.2016

--INCIO - [douglas.japiassu] - 13/03/2016

create table templatecontinuidade (
	idtemplatecontinuidade int not null,
	identificacao varchar(255) not null,
	nometemplate varchar(200) not null,
	tipotemplate varchar(3) not null,
	nomeclassedto varchar(255),
	nomeclasseaction varchar(255),
	nomeclasseservico varchar(255),
	urlrecuperacao varchar(255),
	alturadiv int not null,
	idquestionario int(11),
	scriptaposrecuperacao text,
	primary key (idtemplatecontinuidade),
	constraint templatecontinuidade_questionario_fk foreign key (idquestionario) references questionario (idquestionario)
) ENGINE=InnoDB;

create table calendarioeventoquestionario (
	idcalendarioeventoquestionario int(11) not null,
	idquestionario int(11) not null,
	idevento bigint not null,
	dataquestionario timestamp not null,
	situacao char(1) not null,
	datahoragrav timestamp not null,
	primary key (idcalendarioeventoquestionario),
	constraint fk_calevtquest_evy foreign key (idevento) references calendarioevento (idevento) on delete no action on update no action,
	constraint fk_servquest_quest foreign key (idquestionario) references questionario (idquestionario) on delete no action on update no action
) ENGINE=InnoDB;

--FIM - [douglas.japiassu] - 13/03/2016

-- INICIO - gilmar.junior - 14.03.2016
CREATE TABLE estrategiatestes 
(
  idestrategiateste bigint not null,
  idcontinuidade bigint not null,
  sumarioexecutivo text null,
  nomeiet varchar(254) not null,
  datahorafim datetime default null,
  primary key (idestrategiateste),
  constraint fk_strtst_cont foreign key (idcontinuidade) references continuidade(idcontinuidade)
)ENGINE=InnoDB;

CREATE TABLE planoteste 
(
  idplanoteste bigint not null,
  idmedidarecuperacao bigint not null,
  idestrategiateste bigint not null,
  nomeplanoteste varchar(255) null,
  descplanoteste text null,
  tipoteste varchar(255) null,
  datainicio datetime default null,
  datatermino datetime default null,
  idtemplatecontinuidade int null,
  datahorafim datetime default null,
  primary key (idplanoteste),
  constraint fk_pltst_strtst foreign key (idestrategiateste) references estrategiatestes(idestrategiateste),
  constraint fk_pltst_medrec foreign key (idmedidarecuperacao) references medidarecuperacao(idmedidarecuperacao),
  constraint fk_pltst_tempcont foreign key (idtemplatecontinuidade) references templatecontinuidade(idtemplatecontinuidade)
)ENGINE=InnoDB;

CREATE TABLE planotestegrupo 
(
  idplanotestegrupo bigint not null,
  idgrupo int(11) not null,
  idplanoteste bigint not null,
  tipo integer null,
  datahorafim datetime default null,
  primary key (idplanotestegrupo),
  constraint fk_pltstgrp_medrec foreign key (idplanoteste) references planoteste(idplanoteste),
  constraint fk_pltstgrp_grupo foreign key (idgrupo) references grupo(idgrupo)
)ENGINE=InnoDB;
-- FIM - gilmar.junior - 14.03.2016

-- INICIO [deborah.ferreira] - 14.03.2016

CREATE TABLE auditoriacontanalimpacnegocio (
	id INT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idanaliseimpactonegocio BIGINT NOT NULL,
	idfuncaovital INT NOT NULL,
	nomefuncaovital VARCHAR(255) NOT NULL,
	impacto CHARACTER VARYING(255),
	severidade CHAR(1),
	custohora DOUBLE PRECISION,
	custoimpacto DOUBLE PRECISION,
	maxtoleravelinatividade VARCHAR(8),
	objtemporecuperacao VARCHAR(8),
	objpontorecuperacao VARCHAR(8),
	estrategia1 TEXT,
	estrategia2 TEXT,
	estrategia3 TEXT,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
)ENGINE=InnoDB;

-- FIM [deborah.ferreira] - 14.03.2016

-- INICIO - rodrigo.acorse - 14.03.2016

CREATE TABLE calendarioeventoteste (
	ideventoteste bigint not null,
	idevento bigint not null,
	idplanoteste bigint not null,
	situacao char(1),
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventoteste),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idplanoteste) REFERENCES planoteste (idplanoteste)
) ENGINE=InnoDB;

CREATE TABLE calendarioeventoconhecimento (
	ideventoconhecimento bigint not null,
	idevento bigint not null,
	idbaseconhecimento int not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventoconhecimento),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idbaseconhecimento) REFERENCES baseconhecimento (idbaseconhecimento)
) ENGINE=InnoDB;

-- FIM - rodrigo.acorse - 14.03.2016

-- INICIO - thyen.chang - 15.03.2016

ALTER TABLE historicobaseconhecimento ADD tipodocumento VARCHAR(3);

ALTER TABLE historicobaseconhecimento ADD erroconhecido VARCHAR(1);

UPDATE historicobaseconhecimento SET tipodocumento = (CASE WHEN faq = 'S' THEN 'F' WHEN erroconhecido = 'S' THEN 'E' ELSE 'D' END)

ALTER TABLE conhecimentoic DROP FOREIGN KEY fk_ref_conhic_bc;

ALTER TABLE conhecimentomudanca DROP FOREIGN KEY fk_ref_conhmud_bc;

ALTER TABLE conhecimentoproblema DROP FOREIGN KEY fk_ref_conhpb_bc;

ALTER TABLE conhecimentosolicitacaoservico DROP FOREIGN KEY fk_ref_conhss_bc;

CREATE TABLE grupoiccalendario (
	idgrupoitemconfiguracao INTEGER NOT NULL
	,idcalendario INTEGER NOT NULL
	,constraint fk_grpiccld_grpic foreign key (idgrupoitemconfiguracao) references grupoitemconfiguracao (idgrupoitemconfiguracao)
	,constraint fk_grpiccld_cld foreign key (idcalendario) references calendario (idcalendario)
) ENGINE=InnoDB;

CREATE TABLE grupoiccacordonivelservico (
	idgrupoitemconfiguracao INTEGER NOT NULL
	,idacordonivelservico BIGINT NOT NULL
	,constraint fk_grpicans_grpic foreign key (idgrupoitemconfiguracao) references grupoitemconfiguracao (idgrupoitemconfiguracao)
	,constraint fk_grpicans_ans foreign key (idacordonivelservico) references acordonivelservico (idacordonivelservico)
) ENGINE=InnoDB;

CREATE TABLE iccalendario (
	iditemconfiguracao INTEGER NOT NULL
	,idcalendario INTEGER NOT NULL
	,constraint fk_iccld_grpic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao)
	,constraint fk_iccld_cld foreign key (idcalendario) references calendario (idcalendario)
) ENGINE=InnoDB;

CREATE TABLE iccacordonivelservico (
	iditemconfiguracao INTEGER NOT NULL
	,idacordonivelservico BIGINT NOT NULL
	,constraint fk_icans_grpic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao)
	,constraint fk_icans_ans foreign key (idacordonivelservico) references acordonivelservico (idacordonivelservico)
) ENGINE=InnoDB;

-- FIM - thyen.chang - 15.03.2016

-- INICIO - gustavo.gomes - 14.03.2016

CREATE TABLE ocorrenciaservicodemanda(
	idocorrenciaservicodemanda BIGINT NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nome VARCHAR(255) NOT NULL,
	valor VARCHAR(255) NOT NULL,
	PRIMARY KEY (idocorrenciaservicodemanda),
	constraint fk_idocorenciaservico foreign key (idocorrenciaservico) references ocorrenciaservico(idocorrenciaservico)

);

CREATE TABLE ocorrenciaservicocapacidade(
	idocorrenciaservicocapacidade BIGINT NOT NULL,
	idocorrenciaservico INT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nome VARCHAR(255) NOT NULL,
	valor VARCHAR(255) NOT NULL,
	PRIMARY KEY (idocorrenciaservicocapacidade),
	constraint fk_idocorenciaservico foreign key (idocorrenciaservico) references ocorrenciaservico(idocorrenciaservico)

);

-- FIM - gustavo.gomes - 14.03.2016

-- INCIO - douglas.japiassu - 21.03.2016

alter table situacaoservico add ativo integer not null default 2;

update situacaoservico set ativo = (case when (upper(nomesituacaoservico) = upper('ativo') or upper(nomesituacaoservico) = upper('active')) then 1 else 2 end);

update menu set datafim = now() where nome = '$menu.nome.ligacoesExternas';

update menu set datafim = now() where nome in ('$menu.nome.pesquisaFAQ', '$menu.nome.pesquisaErroConhecido');

alter table requisicaomudanca add column votacaorequisicaoaprovadaaux char(1);

-- FIM - douglas.japiassu - 21.03.2016

-- INICIO - joao.morais - 22/03/2016

ALTER TABLE planocontinuidade MODIFY COLUMN descricao TYPE TEXT;

-- FIM - joao.morais - 22/03/2016

-- INCIO - thyen.chang - 22.03.2016

ALTER TABLE auditoriaitemconfig ADD idtipoitemconfiguracao INT;

-- FIM - thyen.chang - 22.03.2016

-- INICIO - [euler.ramos] - 22.03.2016
-- Modelos e-mail para Fluxo de Procedimento

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedure Started - Number: ${IDSOLICITACAOSERVICO}', 
'COMMUNICATION<br /><br />Please be advised that started the ${IDSOLICITACAOSERVICO} continuity procedure to solve the ${IDSOLICITACAORELACIONADA} critic icident, <br />as the data below:<br /><br />Number: <strong>${IDSOLICITACAOSERVICO}</strong><br />Procedure: <strong>${SERVICO}</strong><br />Date/Hour: <strong>${DATAHORASOLICITACAO}</strong><br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Best regards,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'startedContinuityPr');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedure executed - Number: ${IDSOLICITACAOSERVICO}', 
'COMMUNICATION<br /><br />Please be advised that the ${IDSOLICITACAOSERVICO} continuity procedure it was executed,<br />as the data below:<br /><br />Number: ${IDSOLICITACAOSERVICO}<br />Procedure: ${SERVICO}<br />Date/Hour: ${DATAHORASOLICITACAO}<br />Critic Icident: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Best regards,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'executedContinuityPr');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Continuty Procedure it was restarted - Number: ${IDSOLICITACAOSERVICO}', 
'Exception<br /><br />Please be advised that the ${IDSOLICITACAOSERVICO} continuity procedure failed and it was restarted,<br />as the data below:<br /><br />Number: ${IDSOLICITACAOSERVICO}<br />Procedure: ${SERVICO}<br />Date/Hour: ${DATAHORASOLICITACAO}<br />Critic Icident: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Best regards,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'failProcedureCont');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Continuty Procedure it was finished - Number: ${IDSOLICITACAOSERVICO}', 
'COMMUNICATION<br /><br />Please be advised that the ${IDSOLICITACAOSERVICO} continuity procedure it was finished,<br />as the data below:<br /><br />Number: ${IDSOLICITACAOSERVICO}<br />Procedure: ${SERVICO}<br />Date/Hour: ${DATAHORASOLICITACAO}<br />Critic Icident: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Best regards,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'finishContinuityProc');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedimento iniciado - Nmero: ${IDSOLICITACAOSERVICO}', 
'AVISO<br /><br />Por favor, esteja ciente que foi iniciado o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} afim de resolver o incidente crtico ${IDSOLICITACAORELACIONADA}, <br />conforme os dados abaixo:<br /><br />Nmero: <strong>${IDSOLICITACAOSERVICO}</strong><br />Procedimento: <strong>${SERVICO}</strong><br />Data/Hora: <strong>${DATAHORASOLICITACAO}</strong><br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeIniciado');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedimento executado - Nmero: ${IDSOLICITACAOSERVICO}', 
'AVISO<br /><br />Por favor, esteja ciente que o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} foi executado,<br />conforme os dados abaixo:<br /><br />Nmero: ${IDSOLICITACAOSERVICO}<br />Procedimento: ${SERVICO}<br />Data/Hora: ${DATAHORASOLICITACAO}<br />Incidente Crtico: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Atenciosamente,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeExecutado');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedimento de Continuidade foi reiniciado - Nmero: ${IDSOLICITACAOSERVICO}', 
'Exceo<br /><br />Por favor, esteja ciente que o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} falhou e foi reiniciado,<br />conforme os dados abaixo:<br /><br />Nmero: ${IDSOLICITACAOSERVICO}<br />Procedimento: ${SERVICO}<br />Data/Hora: ${DATAHORASOLICITACAO}<br />Incidente Crtico: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Atenciosamente,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeReiniciado');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedimento de Continuidade foi finalizado - Nmero: ${IDSOLICITACAOSERVICO}', 
'AVISO<br /><br />Por favor, esteja ciente que o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} foi finalizado,<br />conforme os dados abaixo:<br /><br />Nmero: ${IDSOLICITACAOSERVICO}<br />Procedimento: ${SERVICO}<br />Data/Hora: ${DATAHORASOLICITACAO}<br />Incidente Crtico: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Atenciosamente,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeFinalizado');

CREATE TABLE liberacaosolicitacaoservico 
( 
  idliberacaosolicitacaoservico bigint(20) NOT NULL, 
  idliberacao int(11) NOT NULL, 
  idsolicitacaoservico bigint(20) NOT NULL, 
  datafim date, 
  PRIMARY KEY (idliberacaosolicitacaoservico), 
  FOREIGN KEY (idliberacao) REFERENCES liberacao (idliberacao) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT, 
  FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT 
);

-- FIM [euler.ramos] - 22.03.2016

-- INCIO - deborah.ferreira - 22.03.2016

CREATE TABLE invocacao(
	idinvocacao BIGINT NOT NULL,
	idcontinuidade BIGINT NOT NULL,
	idcliente INT(11),
	idsolicitacaorelacionado BIGINT,
	idsolicitacao BIGINT NOT NULL,
	nomeservico VARCHAR(255),
	idgrupoexecutor INT(11),
	idgrupoaprovador INT(11),
	idresponsavel INT(11),
	situacao VARCHAR(20),
	PRIMARY KEY (idinvocacao),
	CONSTRAINT fk_invocacao_continuidade FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade),
	CONSTRAINT fk_invocacao_cliente FOREIGN KEY (idcliente) REFERENCES clientes (idcliente),
	CONSTRAINT fk_invocacao_solicitacao FOREIGN KEY (idsolicitacao) REFERENCES solicitacaoservico (idsolicitacaoservico),
	CONSTRAINT fk_invocacao_solicitacao_rel FOREIGN KEY (idsolicitacaorelacionado) REFERENCES solicitacaoservico (idsolicitacaoservico),
	CONSTRAINT fk_invocacao_grupo_ex FOREIGN KEY (idgrupoexecutor) REFERENCES grupo (idgrupo),
	CONSTRAINT fk_invocacao_grupo_ap FOREIGN KEY (idgrupoaprovador) REFERENCES grupo (idgrupo),
	CONSTRAINT fk_invocacao_usuario FOREIGN KEY (idresponsavel) REFERENCES usuario (idusuario)
) ENGINE=InnoDB;


ALTER TABLE auditoriacontinvocacao CHANGE nomegrupoatual nomegrupoexecutor VARCHAR(255);
ALTER TABLE auditoriacontinvocacao ADD nomegrupoaprovador VARCHAR(255);
ALTER TABLE auditoriacontinvocacao MODIFY nomeresponsavel VARCHAR(256) NULL;

ALTER TABLE planocontinuidade ADD versao DOUBLE PRECISION NOT NULL DEFAULT 1.0;
ALTER TABLE auditoriaplanocontinuidade ADD versao DOUBLE PRECISION;

ALTER TABLE acordonivelservico ADD sazonalidade VARCHAR(255);
-- FIM - deborah.ferreira - 22.03.2016

-- INCIO - [douglas.japiassu] - 28.03.2016

ALTER TABLE escalonamento ADD tipodataescalonamento integer;
UPDATE escalonamento SET tipodataescalonamento = (select re.tipodataescalonamento from regraescalonamento re where re.idregraescalonamento = escalonamento.idregraescalonamento);
ALTER TABLE regraescalonamento ADD tipodatanotificacaoemail integer;
UPDATE regraescalonamento SET tipodatanotificacaoemail = 1;
ALTER TABLE regraescalonamento ADD tipodataproblema integer;
UPDATE regraescalonamento SET tipodatanotificacaoemail = 2;

-- FIM - [douglas.japiassu] - 28.03.2016 

-- INCIO - [gilmar.jnior] - 28.03.2016

CREATE TABLE baseconhecimentosla (
	idbaseconhecimentosla bigint not null,
	idbaseconhecimento int not null,
	idacordonivelservico bigint not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idbaseconhecimentosla),
	FOREIGN KEY (idbaseconhecimento) REFERENCES baseconhecimento (idbaseconhecimento),
	FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico)
) ENGINE=InnoDB;


-- FIM - [gilmar.jnior] - 28.03.2016

-- INCIO - [douglas.japiassu] - 30.03.2016

CREATE TABLE permissaoacessopagina (
	idperfilacesso integer not null,
	caminho varchar(255) not null,
	pesquisa char(1),
	grava char(1),
	deleta char(1),
	tipoperfilacesso smallint,
	ordem smallint,
	PRIMARY KEY (idperfilacesso,caminho),
	CONSTRAINT fk_perfilacesso FOREIGN KEY (idperfilacesso) REFERENCES perfilacesso (idperfil)
);

CREATE TABLE servicocontratoans (
	idservicocontratoans integer not null,
	idservicocontrato bigint  not null,
	idacordonivelservico bigint not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idservicocontratoans),
	CONSTRAINT fk_servicocontrato FOREIGN KEY (idservicocontrato) REFERENCES servicocontrato (idservicocontrato),
	CONSTRAINT fk_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico)
);

-- FIM - [douglas.japiassu] - 30.03.2016 

-- INCIO - [pedro.francisco] - 29.03.2016

ALTER TABLE modelosemails ADD idprocesso integer;

-- FIM - [pedro.francisco] - 29.03.2016

-- INCIO - [rodrigo.acorse] - 01.04.2016

alter table itemconfiguracao add custohoraindisponibilidade decimal(10,2);
alter table historicoic add custohoraindisponibilidade decimal(10,2);

-- FIM - [rodrigo.acorse] - 01.04.2016

-- INCIO - [deborah.ferreira] - 02.04.2016

ALTER TABLE servicocontrato ADD custohoraindisponibilidade DECIMAL(10,2);

CREATE TABLE servicocontratocalendario (
	idservicocontratocalendario INT(11) NOT NULL,
	idservicocontrato BIGINT NOT NULL,
	idcalendario INT(11) NOT NULL,
	datainicio DATE NOT NULL,
	datafim DATE,
	PRIMARY KEY (idservicocontratocalendario),
	CONSTRAINT fk_contratocal_servicocontrato FOREIGN KEY (idservicocontrato) REFERENCES servicocontrato (idservicocontrato),
	CONSTRAINT fk_contratocal_calendario FOREIGN KEY (idcalendario) REFERENCES calendario (idcalendario)
) ENGINE=InnoDB;

ALTER TABLE jornadatrabalho ADD tipohorario INTEGER DEFAULT 1 NOT NULL;

-- FIM - [deborah.ferreira] - 02.04.2016

-- INICIO - thyen.chang - 02.04.2016

CREATE TABLE grupodisponibilidade (
	idgrupodisponibilidade INTEGER NOT NULL
	, nome VARCHAR(255) NOT NULL
	, acordodisponibilidade DOUBLE NOT NULL
	, valor DOUBLE NOT NULL
	, idcalendario INTEGER NOT NULL
	, datafim DATE
	, PRIMARY KEY (idgrupodisponibilidade)
	, CONSTRAINT fk_grpdisp_calend FOREIGN KEY (idcalendario) REFERENCES calendario (idcalendario)
);

CREATE TABLE grupodisponibilidadeic (
	idgrupodisponibilidadeic INTEGER NOT NULL
	, idgrupodisponibilidade INTEGER NOT NULL
	, iditemconfiguracao INTEGER NOT NULL
	, PRIMARY KEY (idgrupodisponibilidadeic)
	, CONSTRAINT fk_grpdispic_grpdisp FOREIGN KEY (idgrupodisponibilidade) REFERENCES grupodisponibilidade (idgrupodisponibilidade)
	, CONSTRAINT fk_grpdispic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES itemconfiguracao (iditemconfiguracao)
);

CREATE TABLE grupoicvalorindisp (
	idgrupoicvalorindisp INTEGER NOT NULL
	, idgrupoitemconfiguracao INTEGER NOT NULL
	, valor DOUBLE NOT NULL
	, PRIMARY KEY (idgrupoicvalorindisp)
);

ALTER TABLE grupoiccalendario DROP FOREIGN KEY fk_grpiccld_grpic;

ALTER TABLE grupoiccacordonivelservico DROP FOREIGN KEY fk_grpicans_grpic;

-- FIM - thyen.chang - 02.04.2016

-- INCIO - gilmar.junior - 06.04.2016
ALTER TABLE clientes modify cpfcnpj varchar(255) default null;

ALTER TABLE dadosbancariosintegrante modify cpf varchar(255) default null;

ALTER TABLE empregados modify cpf varchar(255) default null;

ALTER TABLE fornecedor modify cnpj varchar(255) default null;

ALTER TABLE pessoa modify cpf varchar(255) default null;

ALTER TABLE rh_candidato modify cpf varchar(255) default null;

ALTER TABLE rh_curriculo modify cpf varchar(255) default null;

ALTER TABLE rh_funcionario modify cpf varchar(255) default null;
-- FIM - gilmar.junior - 06.04.2016

-- INICIO - gustavo.gomes - 07.04.2016
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.incidente' WHERE idmodulosistema = 1;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.requisicao' WHERE idmodulosistema = 2;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.mudanca' WHERE idmodulosistema = 3;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.evento' WHERE idmodulosistema = 4;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.continuidade' WHERE idmodulosistema = 5;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.conhecimento' WHERE idmodulosistema = 6;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.sla' WHERE idmodulosistema = 7;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.problema' WHERE idmodulosistema = 8;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.capacidade' WHERE idmodulosistema = 9;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.portfolio' WHERE idmodulosistema = 10;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.aivosconf' WHERE idmodulosistema = 11;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.gerencservicos' WHERE idmodulosistema = 12;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.liberacao' WHERE idmodulosistema = 13;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.disponibilidade' WHERE idmodulosistema = 14;
-- FIM - gustavo.gomes - 07.04.2016

-- INCIO - gilmar.junior - 07.04.2016
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.incidentesRequisicoes' WHERE identificacao LIKE 'INCREQ001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.ativosConfiguracao' WHERE identificacao LIKE 'ATVCFG001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.baseConhecimento' WHERE identificacao LIKE 'BASECG001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.niveisServico' WHERE identificacao LIKE 'NIVELS001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.problemas' WHERE identificacao LIKE 'PROBL001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.mudancas' WHERE identificacao LIKE 'MUDAN001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.liberacao' WHERE identificacao LIKE 'LIBER001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.catalogoServicos' WHERE identificacao LIKE 'CATAL001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.projetos' WHERE identificacao LIKE 'PROJET001';
-- FIM - gilmar.junior - 07.04.2016

-- INCIO - gilmar.junior - 12.04.2016
UPDATE programacaoatividade SET tipoagendamento = '1' WHERE tipoagendamento LIKE 'D';
UPDATE programacaoatividade SET tipoagendamento = '2' WHERE tipoagendamento LIKE 'S';
UPDATE programacaoatividade SET tipoagendamento = '3' WHERE tipoagendamento LIKE 'M';
UPDATE programacaoatividade SET tipoagendamento = '4' WHERE tipoagendamento LIKE 'U';
-- FIM - gilmar.junior - 12.04.2016
-- INCIO - joao.morais - 13.04.2016

ALTER TABLE controlecontrato ADD COLUMN datainicio2 DATE DEFAULT NULL; 
UPDATE controlecontrato SET datainicio2 = STR_TO_DATE(datainicio, '%Y-%m-%d');
ALTER TABLE controlecontrato DROP COLUMN datainicio;
ALTER TABLE controlecontrato CHANGE datainicio2 datainicio DATE;

-- FIM - joao.morais - 13.04.2016

-- INCIO - gustavo.gomes - 13.04.2016
ALTER TABLE regraescalonamento MODIFY COLUMN tipodataescalonamento INTEGER null;
-- FIM - gustavo.gomes - 13.04.2016

-- INCIO - joao.morais - 30.05.2016

alter table evm_acao_incidenterequisicao add column idcategoriaservico int(11) null;
alter table evm_acao_incidenterequisicao add column idtipocatalogoservicosoli varchar(1) null;
alter table evm_acao_incidenterequisicao add column idServicoNegocioTecBusc bigint(20) null;
alter table evm_acao_incidenterequisicao add column utilizaCategoriaServico varchar(1) null;

update menu set datafim = now() 
where nome in(
	'$menu.nome.gerenciaBaseConhecimento',
	'$menu.nome.gerenciaConfiguracaoIncidenteRequisicoes');
	
-- FIM - joao.morais - 30.05.2016

-- INCIO - deborah.ferreira - 13.06.2016

ALTER TABLE permissaoacessopagina ADD tipoperfilacesso smallint;
ALTER TABLE permissaoacessopagina ADD ordem smallint;

-- FIM - deborah.ferreira - 13.06.2016

-- INICIO - joao.morais - 16.06.2016

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacao.jsp', 'S', 'S', 'S', 1, 1);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacaoPolitica.jsp', 'S', 'S', 'S', 1, 2);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacaoEscopo.jsp', 'S', 'S', 'S', 1, 3);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacaoProjeto.jsp', 'S', 'S', 'S', 1, 4);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategia.jsp', 'S', 'S', 'S', 1, 5);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaFuncoesVitais.jsp', 'S', 'S', 'S', 1, 6);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaImpactoNegocio.jsp', 'S', 'S', 'S', 1, 7);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaAvaliacaoRiscos.jsp', 'S', 'S', 'S', 1, 8);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaEstrategiaContinuidade.jsp', 'S', 'S', 'S', 1, 9);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacao.jsp', 'S', 'S', 'S', 1, 10);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacaoPlanosContinuidade.jsp', 'S', 'S', 'S', 1, 11);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacaoPlanejamentoOrganizacional.jsp', 'S', 'S', 'S', 1, 12);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacaoEstrategiaTestes.jsp', 'S', 'S', 'S', 1, 13);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinua.jsp', 'S', 'S', 'S', 1, 14);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaConscientizacao.jsp', 'S', 'S', 'S', 1, 15);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaRevisaoAuditoria.jsp', 'S', 'S', 'S', 1, 16);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaTestes.jsp', 'S', 'S', 'S', 1, 17);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaInvocacao.jsp', 'S', 'S', 'S', 1, 18);

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroPortfolio/gerenciamentoPortfolioCadastroPortfolio.jsp', 'S', 'S', 'S', 2, 1);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoServicoNegocio/gerenciamentoPortfolioInfoServicoNegocio.jsp', 'S', 'S', 'S', 2, 2);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoNegocio/gerenciamentoPortfolioCadastroServicoNegocio.jsp', 'S', 'S', 'S', 2, 3);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioRNS/gerenciamentoPortfolioRNS.jsp', 'S', 'S', 'S', 2, 4);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAtributosFinanceiros/gerenciamentoPortfolioAtributosFinanceiros.jsp', 'S', 'S', 'S', 2, 5);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCasoNegocio/gerenciamentoPortfolioCasoNegocio.jsp', 'S', 'S', 'S', 2, 6);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoNegocio/gerenciamentoPortfolioMapaDesenhoNegocio.jsp', 'S', 'S', 'S', 2, 7);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioProcessoNegocio/gerenciamentoPortfolioProcessoNegocio.jsp', 'S', 'S', 'S', 2, 8);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoio/gerenciamentoPortfolioServicoApoio.jsp', 'S', 'S', 'S', 2, 9);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioDonoNegocio/gerenciamentoPortfolioDonoNegocio.jsp', 'S', 'S', 'S', 2, 10);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioBusinessUser/gerenciamentoPortfolioBusinessUser.jsp', 'S', 'S', 'S', 2, 11);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoRequisicaoNegocio/gerenciamentoPortfolioServicoRequisicaoNegocio.jsp', 'S', 'S', 'S', 2, 12);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAplicacoes/gerenciamentoPortfolioAplicacoes.jsp', 'S', 'S', 'S', 2, 13);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioEsquemaDados/gerenciamentoPortfolioEsquemaDados.jsp', 'S', 'S', 'S', 2, 14);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoIncidenteNegocio/gerenciamentoPortfolioServicoIncidenteNegocio.jsp', 'S', 'S', 'S', 2, 15);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoProcedimento/gerenciamentoPortfolioServicoProcedimento.jsp', 'S', 'S', 'S', 2, 16);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratos/gerenciamentoPortfolioContratos.jsp', 'S', 'S', 'S', 2, 17);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioProprietarios/gerenciamentoPortfolioProprietarios.jsp', 'S', 'S', 'S', 2, 18);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioConhecimento/gerenciamentoPortfolioConhecimento.jsp', 'S', 'S', 'S', 2, 19);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioHabilidade/gerenciamentoPortfolioHabilidade.jsp', 'S', 'S', 'S', 2, 20);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioIndicadorCapacidade/gerenciamentoPortfolioIndicadorCapacidade.jsp', 'S', 'S', 'S', 2, 21);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAtributoDemanda/gerenciamentoPortfolioAtributoDemanda.jsp', 'S', 'S', 'S', 2, 22);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioOcorrenciasServico/gerenciamentoPortfolioOcorrenciasServico.jsp', 'S', 'S', 'S', 2, 23);

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoServicoApoio/gerenciamentoPortfolioInfoServicoApoio.jsp', 'S', 'S', 'S', 2, 24);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/gerenciamentoPortfolioCadastroServicoApoio.jsp', 'S', 'S', 'S', 2, 25);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoApoio/gerenciamentoPortfolioMapaDesenhoApoio.jsp', 'S', 'S', 'S', 2, 26);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoioApoio/gerenciamentoPortfolioServicoApoioApoio.jsp', 'S', 'S', 'S', 2, 27);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoRequisicaoApoio/gerenciamentoPortfolioServicoRequisicaoApoio.jsp', 'S', 'S', 'S', 2, 28);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoIncidenteApoio/gerenciamentoPortfolioServicoIncidenteApoio.jsp', 'S', 'S', 'S', 2, 29);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosApoio/gerenciamentoPortfolioContratosApoio.jsp', 'S', 'S', 'S', 2, 30);

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoContrato/gerenciamentoPortfolioInfoContrato.jsp', 'S', 'S', 'S', 2, 31);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosDetalhes/gerenciamentoPortfolioContratosDetalhes.jsp', 'S', 'S', 'S', 2, 32);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoRequisicao/gerenciamentoPortfolioContratosServicoRequisicao.jsp', 'S', 'S', 'S', 2, 33);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoIncidente/gerenciamentoPortfolioContratosServicoIncidente.jsp', 'S', 'S', 'S', 2, 34);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoProcedimento/gerenciamentoPortfolioContratosServicoProcedimento.jsp', 'S', 'S', 'S', 2, 35);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosCustoDisponibilidade/gerenciamentoPortfolioContratosCustoDisponibilidade.jsp', 'S', 'S', 'S', 2, 36);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoContratoANS/gerenciamentoPortfolioServicoContratoANS.jsp', 'S', 'S', 'S', 2, 37);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosCalendario/gerenciamentoPortfolioContratosCalendario.jsp', 'S', 'S', 'S', 2, 38);

-- FIM - joao.morais - 16.06.2016

-- INICIO - euler.ramos - 22.06.2016

alter table unidade add idcalendario INT;

-- FIM - euler.ramos - 22.06.2016

-- INICIO - deborah.ferreira - 06.07.2016

DELETE FROM menu WHERE nome = '$menu.nome.cargaCatalogoServico';

-- FIM - deborah.ferreira - 06.07.2016

set sql_safe_updates = 1;