--INCIO - [rodrigo.acorse] - 21/01/2015

alter table evm_gerente add urgenciaup char(1);
alter table evm_gerente add urgenciadown char(1);
alter table evm_gerente add impactoup char(1);
alter table evm_gerente add impactodown char(1);

alter table evm_gerenciado_inventory add urgenciainformation char(1);
alter table evm_gerenciado_inventory add impactoinformation char(1);
alter table evm_gerenciado_inventory add urgenciawarning char(1);
alter table evm_gerenciado_inventory add impactowarning char(1);
alter table evm_gerenciado_inventory add urgenciaexception char(1);
alter table evm_gerenciado_inventory add impactoexception char(1);

alter table evm_gerenciado_nagios add urgenciainformation char(1);
alter table evm_gerenciado_nagios add impactoinformation char(1);
alter table evm_gerenciado_nagios add urgenciawarning char(1);
alter table evm_gerenciado_nagios add impactowarning char(1);
alter table evm_gerenciado_nagios add urgenciaexception char(1);
alter table evm_gerenciado_nagios add impactoexception char(1);

alter table evm_gerenciado_zabbix add urgenciainformation char(1);
alter table evm_gerenciado_zabbix add impactoinformation char(1);
alter table evm_gerenciado_zabbix add urgenciawarning char(1);
alter table evm_gerenciado_zabbix add impactowarning char(1);
alter table evm_gerenciado_zabbix add urgenciaexception char(1);
alter table evm_gerenciado_zabbix add impactoexception char(1);

alter table evm_linha_g_g_nagios add urgenciaup char(1);
alter table evm_linha_g_g_nagios add urgenciadown char(1);
alter table evm_linha_g_g_nagios add impactoup char(1);
alter table evm_linha_g_g_nagios add impactodown char(1);

alter table evm_linha_g_g_nagios add urgenciainformation char(1);
alter table evm_linha_g_g_nagios add impactoinformation char(1);
alter table evm_linha_g_g_nagios add urgenciawarning char(1);
alter table evm_linha_g_g_nagios add impactowarning char(1);
alter table evm_linha_g_g_nagios add urgenciaexception char(1);
alter table evm_linha_g_g_nagios add impactoexception char(1);

alter table evm_gerente_correlacao add urgenciainformation char(1);
alter table evm_gerente_correlacao add impactoinformation char(1);
alter table evm_gerente_correlacao add urgenciawarning char(1);
alter table evm_gerente_correlacao add impactowarning char(1);
alter table evm_gerente_correlacao add urgenciaexception char(1);
alter table evm_gerente_correlacao add impactoexception char(1);

-- FIM - [rodrigo.acorse] - 21/01/2015

-- INCIO - [deborah.ferreira] - 21/01/2016

CREATE TABLE ocorrenciaservico
(
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	idservico  NUMBER(24,0) NOT NULL,
	nomeusuario VARCHAR(255) NOT NULL,
	datacriacao TIMESTAMP NOT NULL,
	categoriaocorrencia VARCHAR(10) NOT NULL,
	tipoocorrencia VARCHAR(10) NOT NULL,
	descricaoocorrencia CLOB,
	PRIMARY KEY (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicodetalhes
(
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nomeservico VARCHAR(255) NOT NULL,
	nomecategoriaservico VARCHAR(255) NOT NULL,
	faseservico VARCHAR(255) NOT NULL,
	tipodeinvestimento VARCHAR(255),
	nometiposervico VARCHAR(255) NULL,
	detalheservico VARCHAR(255),
	processodeiniciacao VARCHAR(255),
	datainicio DATE NOT NULL,
	statusservico VARCHAR(255) NOT NULL,
	nomeimportancianegocio VARCHAR(255),
	nomelocalexecucaoservico VARCHAR(255),
	objetivo CLOB,
	valoresdoservico CLOB,
	nometemplateservico VARCHAR(200),
	criticidadeservico NUMBER,
	demandaservico NUMBER,
	retornofinanceiroservico NUMBER,
	deleted CHAR(1) DEFAULT 'N',
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

-- ocorrenciaservicorequisitosnivelservico
CREATE TABLE ocorrenciaservreqsnivelserv (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	datacriacao DATE NOT NULL,
	datainicioservico DATE,
	donodoservico CLOB,
	especificacao CLOB,
	contexto CLOB,
	funcionalidadesessenciais CLOB,
	seguranca CLOB,
	disponibilidade CLOB,
	capacidade CLOB,
	continuidadedonegocio CLOB,
	performancedesempenho CLOB,
	interrupcoesplanejadas CLOB,
	gestaodeincidentes CLOB,
	gestaodeproblemas CLOB,
	gestaodemudancas CLOB,
	conformidadeinterna CLOB,
	conformidadeexterna CLOB,
	datafim DATE,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicocasonegocio (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nomecasonegocio VARCHAR2(100) DEFAULT NULL,
	descricaosumarioexecutivo CLOB,
	descricaocenarios CLOB,
	descricaoproblemaoportunidade CLOB,
	descricaopropostasolucao CLOB,
	descricaoanalisefinanceira CLOB,
	descricaoanaliserisco CLOB,
	descricaostakeholderentidade CLOB,
	descricaoviabilidadetecnica CLOB,
	descricaoconclusao CLOB,
	datafim DATE,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

-- ocorrenciaservicoatributosfinanceiros
CREATE TABLE ocorrenciaservatrfinan (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idatributosfinanceiros NUMBER(24,0) NOT NULL,
	categoriaatributosfinanceiros VARCHAR(255) NOT NULL,
	tipoatributosfinanceiros VARCHAR(1) NOT NULL,
	valoratributosfinanceiros NUMBER(20, 2) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

-- ocorrenciaservicoprocessonegocio
CREATE TABLE ocorrenciaservprocessonegocio (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idprocessonegocio INT NOT NULL,
    nomeprocessonegocio VARCHAR(100) NOT NULL,
    nomecliente VARCHAR2(255) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicodononegocio (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	iddononegocio NUMBER NOT NULL,
	nomedononegocio VARCHAR2(255) NOT NULL,
	tipodononegocio NUMBER NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicousernegocio (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idusuarionegocio NUMBER NOT NULL,
	nomeusuarionegocio VARCHAR2(255) NOT NULL,
	tipousuarionegocio NUMBER NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicorelacionado (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idservicorelacionado NUMBER(24,0) NOT null,
    nomeservicorelacionado VARCHAR(500) NOT NULL,
    faseservicorelacionado VARCHAR(2),
	statusservicorelacionado VARCHAR(5),
	tiposervicorelacionado CHAR(1) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoaplicacao (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idaplicacao NUMBER(10,0) NOT NULL,
    nomeaplicacao VARCHAR2(255) NOT NULL,
	nomeresponsavelaplicacao VARCHAR2(255),
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicocontrato (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idcontrato NUMBER(10,0) NOT NULL,
    descricaocontrato CLOB NOT NULL,
    clientecontrato VARCHAR2(70) NOT NULL,
	fornecedorcontrato VARCHAR2(100) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoproprietarios (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idproprietario NUMBER(24,0) NOT NULL,
	nomeproprietario VARCHAR2(255) NOT NULL,
	tipoproprietario NUMBER(24,0) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoesquemadados (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idesquemadados NUMBER(24,0) NOT NULL,
	detalhesesquemadados CLOB NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoanexos (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idanexo NUMBER(10,0) NOT NULL,
	nomeanexo VARCHAR(255) NOT NULL,
	descricaoanexo VARCHAR(255) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicomapaservico (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	iditemmapaservico NUMBER(10,0) NOT NULL,
	iconeitemmapaservico VARCHAR(256),
	nomeitemmapaservico VARCHAR(500) NOT NULL,
	tipoitemmapaservico CHAR(2) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);
-- FIM - [deborah.ferreira] - 21/01/2016

-- INCIO [douglas.japiassu] 29.01.2016

create table templateservico (
	idtemplateservico number(10,0) not null,
	identificacao varchar(255) not null,
	nometemplate varchar(200) not null,
	nomeclassedto varchar(255),
	nomeclasseaction varchar(255),
	nomeclasseservico varchar(255),
	urlrecuperacao varchar(255),
	alturadiv number(10,0) not null,
	idquestionario integer,
	scriptaposrecuperacao clob,
	constraint templateservico_pk primary key (idtemplateservico) enable,
	constraint tempserv_questionario_fk foreign key (idquestionario) references questionario (idquestionario)
);

alter table servico add valoresdoservico clob;
alter table servico add idtemplateservico number(10,0);
alter table servico add constraint servico_templateservico_fk foreign key (idtemplateservico) references templateservico (idtemplateservico) enable;

create table servicoquestionario (
	idservicoquestionario number not null,
	idquestionario number not null,
	idservico number not null,
	dataquestionario timestamp not null,
	situacao char(1) not null,
	datahoragrav timestamp not null,
	constraint servicoquestionario_pk primary key (idservicoquestionario),
	constraint tempcont_questionario_fk foreign key (idquestionario) references questionario (idquestionario),
	constraint servicoquestionario_servico_fk foreign key (idservico) references servico (idservico)
);
-- FIM [douglas.japiassu] 29.01.2016

-- INCIO [gilmar.junior] 29.01.2016
alter table SERVICO add CRITICIDADESERVICO NUMBER;
alter table SERVICO add DEMANDASERVICO NUMBER;
alter table SERVICO add RETORNOFINANCEIROSERVICO NUMBER;
-- FIM [gilmar.junior] 29.01.2016

-- INCIO [joao.morais] 02.02.2016
create table habilidade (
	idhabilidade number(10,0) not null,
	nomehabilidade varchar(255) not null,
	descricao varchar(255),
	datahorainicio TIMESTAMP not null,
	datahorafim TIMESTAMP,
	primary key (idhabilidade)
);

create table vinculohabilidade (
	idvinculocolaborador number(10,0) not null,
	idempregado number(10,0) not null,
	idhabilidade number(10,0) not null,
	dataFim Date,
	primary key (idvinculocolaborador),
	constraint fk_habilidadeVinculo foreign key (idhabilidade) references habilidade (idhabilidade),
	constraint fk_empregadoHabilidade foreign key (idempregado) references empregados (idempregado)
);
-- FIM [joao.morais] 02.02.2016

-- INICIO - thyen.chang - 02/02/2016

alter table TIPOFINANCEIROSERVICO add classificacao NUMBER;
alter table FINANCEIROSERVICO add classificacao NUMBER;

-- FIM - thyen.chang - 02/02-2016

-- INICIO [joao.morais] 10.02.2016
create table HABILIDADESERVICO(
	idhabilidade number(10,0) not null,
	idservico number(24,0) not null,
	idhabilidadevinculo number(10,0) not null,
	datafim Date,
	primary key (idhabilidadevinculo),
	constraint fk_servicohabilidade foreign key (idservico) references servico (idservico)
);
-- FIM - [joao.morais] - 10/02/2016

-- INCIO - [deborah.ferreira] - 10/02/2016

CREATE TABLE auditoriaeventos (
	idauditoriaeventos NUMBER(24,0) NOT NULL,
	nomeusuario VARCHAR(255) NOT NULL,
	datacriacao TIMESTAMP NOT NULL,
	categoria VARCHAR(10)  NOT NULL,
	tipo VARCHAR(10) NOT NULL,
	descricao CLOB,	
	PRIMARY KEY (idauditoriaeventos)
);
-- FIM - [deborah.ferreira] - 10/02/2016

-- INCIO - [pedro.francisco] - 11/02/2016
CREATE TABLE kpiobjetivomonitoramento (
	idkpiobjetivomonitoramento NUMBER(10,0) NOT NULL,
	idobjetivomonitoramento NUMBER(10,0) NOT NULL,
	kpi varchar(255) NOT NULL,
	criadopor varchar(255) NOT NULL,
	constraint kpiobjetivomonitorament_FK foreign key (idobjetivomonitoramento) references objetivomonitoramento(idobjetivomonitoramento)
);

ALTER TABLE objetivoplanomelhoria ADD idrespobj NUMBER(10,0);
ALTER TABLE objetivoplanomelhoria ADD idgruporespobj NUMBER(10,0);
ALTER TABLE acaoplanomelhoria ADD idrespacao NUMBER(10,0);
ALTER TABLE acaoplanomelhoria ADD idgruporespacao NUMBER(10,0);
ALTER TABLE objetivomonitoramento ADD idrespmon NUMBER(10,0);
ALTER TABLE objetivomonitoramento ADD idgruporespmon NUMBER(10,0);
-- FIM - [pedro.francisco] - 11/02/2016

-- INICIO [joao.morais] - 11/02/2016
update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.gerenciaEventos')) 
where nome = '$menu.nome.evm.acoesAutomaticas' 
or nome = '$menu.nome.evm.ferramentasmonitoracao'
or nome = '$menu.nome.evm.horario'
or nome = '$menu.nome.evm.citsmartInventory'
or nome = '$menu.nome.evm.citsmartevm'
or nome = '$menu.nome.evm.categoriaOcorrencia'
or nome = '$menu.nome.evm.gerenciamentoeventos'
or nome = '$menu.nome.evm.conexoes'
or nome = '$menu.nome.evm.gerente.nagios'
or nome = '$menu.nome.evm.gerente.zabbix'
or nome = '$menu.nome.evm.gerente.inventory'
or nome = '$menu.nome.evm.gerente.correlacao'
or nome = '$menu.nome.evm.gerente.generico.nagios'
or nome = '$menu.nome.evm.acaoAutomatica'
or nome = '$menu.nome.evm.cadAcaoAutoIncReq'
or nome = '$menu.nome.evm.acoesNotificacao'
or nome = '$menu.nome.evm.acoesMudanca'
or nome = 'menu.nome.evm.conexoes'
or nome = '$menu.nome.evm.check'
or nome = '$menu.nome.evm.statusinventory';

update menu set datafim = systimestamp 
where nome in(
	'$menu.nome.evm.acoesAutomaticas',
	'$menu.nome.metaNivelServico',
	'$menu.nome.cadastrosRH',
	'$menu.nome.configuracaoSolicitacaoProduto',
	'$menu.nome.evm.citsmartInventory',
	'$menu.nome.evm.citsmartevm',
	'$menu.nome.evm.conexoes',
	'$menu.nome.pesquisa', 
	'$menu.nome.alcadaCentroResultado',
	'$menu.nome.monitoramento',
	'$menu.nome.monitoramentoNagios',
	'$menu.nome.eventoMonitoramento',
	'$menu.nome.recurso',
	'$menu.nome.disponibilidadeRecurso',
	'$menu.nome.grupoRecursos',
	'$menu.nome.evm.conexoes',
	'$menu.nome.cadastroContratos',
	'$menu.nome.mostraStatusCapturaInventario',
	'$menu.nome.monitoramentoativos');

update menu set ordem = 0 where nome = '$menu.nome.evm.acaoAutomatica';
update menu set ordem = 1 where nome = '$menu.nome.evm.acoesNotificacao';
update menu set ordem = 2 where nome = '$menu.nome.evm.acoesMudanca';
update menu set ordem = 3 where nome = '$menu.nome.evm.acoesProblema';
update menu set ordem = 4 where nome = '$menu.nome.evm.cadAcaoAutoIncReq';
update menu set ordem = 5 where nome = '$menu.nome.evm.ferramentasmonitoracao';
update menu set ordem = 6 where nome = '$menu.nome.evm.horario';
update menu set ordem = 7 where nome = '$menu.nome.evm.conexoesInventory';
update menu set ordem = 8 where nome = '$menu.nome.evm.conexoesEventMonitor';
update menu set ordem = 9 where nome = '$menu.nome.evm.check';
update menu set ordem = 10 where nome = '$menu.nome.evm.statusinventory';
update menu set ordem = 11 where nome = '$menu.nome.evm.gerente.nagios';
update menu set ordem = 12 where nome = '$menu.nome.evm.gerente.zabbix';
update menu set ordem = 13 where nome = '$menu.nome.evm.gerente.inventory';
update menu set ordem = 14 where nome = '$menu.nome.evm.gerente.correlacao';
update menu set ordem = 15 where nome = '$menu.nome.evm.gerente.generico.nagios';
update menu set ordem = 16 where nome = '$menu.nome.evm.gerenciamentoeventos';
update menu set ordem = 17 where nome = '$menu.nome.evm.categoriaOcorrencia';
update menu set ordem = 18 where nome = '$menu.nome.evm.trilhaAuditoria';

update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.gerenciaNivelServico')) 
where nome = '$menu.nome.avaliacaoContrato' 
or nome = '$menu.nome.avaliarSLA'
or nome = '$menu.nome.avaliacaoPorFornecedor'
or nome = '$menu.nome.planoMelhoria'
or nome = '$menu.nome.acordoNivelServico'
or nome = '$menu.nome.metaNivelServico'
or nome = '$menu.nome.tempoAtendimento';

update menu set ordem = 0 where nome = '$menu.nome.tempoAtendimento';
update menu set ordem = 1 where nome = '$menu.nome.acordoNivelServico';
update menu set ordem = 2 where nome = '$menu.nome.avaliarSLA';
update menu set ordem = 3 where nome = '$menu.nome.avaliacaoPorFornecedor';
update menu set ordem = 4 where nome = '$menu.nome.avaliacaoContrato';
update menu set ordem = 5 where nome = '$menu.nome.planoMelhoria';

update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.recursosHumanos')) 
where nome = '$menu.nome.cadastrosRH.idioma' 
or nome = '$menu.nome.pesquisaCurrriculo';

update menu set datafim = systimestamp 
where nome in('$menu.nome.atitudeIndividual',
	'$menu.nome.certificacao',
	'$menu.nome.conhecimento',
	'$menu.nome.curriculo',
	'$menu.nome.curso',
	'$menu.nome.experienciaInformatica',
	'$menu.nome.formacaoAcademica',
	'$menu.nome.habilidade',
	'$menu.nome.horarioTrabalho',
	'$ManualFuncao.Titulo',
	'$menu.nome.justificativaRequisicaoFuncao',
	'$rh.justificativaListaNegra',
	'$menu.nome.experiencia',
	'$menu.nome.atribuicaoRequisicaoFuncao',
	'$menu.nome.comportamentoAtitude',
	'$menu.nome.comportamento',
	'$rh.historicoFuncional',
	'$menu.nome.dicionario');

update menu set ordem = 0 where nome = '$menu.nome.cadastrosRH.idioma';
update menu set ordem = 1 where nome = '$menu.nome.pesquisaCurrriculo';

update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.compras')) 
where nome = '$menu.nome.unidadeMedida' 
or nome = '$menu.nome.categoriaProduto'
or nome = '$menu.nome.tipoProduto'
or nome = '$menu.nome.produto'
or nome = '$menu.nome.justificativaParecer'
or nome = '$menu.nome.cotacao'
or nome = '$menu.nome.criterioAvaliacao'
or nome = '$menu.nome.marca'
or nome = '$menu.nome.avaliacaoFornecedor'
or nome = '$menu.nome.nivelAutoridade'
or nome = '$menu.nome.projeto';

update menu set ordem = 0 where nome = '$menu.nome.categoriaProduto';
update menu set ordem = 1 where nome = '$menu.nome.unidadeMedida';
update menu set ordem = 2 where nome = '$menu.nome.tipoProduto';
update menu set ordem = 3 where nome = '$menu.nome.produto';
update menu set ordem = 4 where nome = '$menu.nome.justificativaParecer';
update menu set ordem = 5 where nome = '$menu.nome.cotacao';
update menu set ordem = 6 where nome = '$menu.nome.criterioAvaliacao';
update menu set ordem = 7 where nome = '$menu.nome.marca';
update menu set ordem = 8 where nome = '$menu.nome.avaliacaoFornecedor';
update menu set ordem = 9 where nome = '$menu.nome.nivelAutoridade';
update menu set ordem = 10 where nome = '$menu.nome.projeto';
update menu set ordem = 11 where nome = '$menu.nome.limiteAprovacao';
update menu set ordem = 12 where nome = '$menu.nome.centroResultado';
update menu set ordem = 13 where nome = '$menu.nome.delegacaoCentroResultado';
update menu set ordem = 14 where nome = '$menu.nome.delegacaoCentroResultadoResp';
update menu set ordem = 15 where nome = '$menu.nome.simulacaoAlcada';
update menu set ordem = 16 where nome = '$menu.nome.qualificacaoFornecedor';

update menu set datafim = systimestamp where link in ('%dinamicViews.load?identificacao=ReqSLA%');
-- FIM - [joao.morais] - 11/02/2016

-- INCIO - [deborah.ferreira] - 12/02/2016

CREATE TABLE auditoriaeventosgerentes (
	id NUMBER(10,0) NOT NULL,
	idauditoriaeventos NUMBER(24,0) NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idgerente NUMBER(10,0) NOT NULL,
	tipogerente CHAR(1) NULL,
	nomegerente VARCHAR2(255) NOT NULL,
	conexao VARCHAR2(50) NOT NULL,
	agendador VARCHAR2(50) NOT NULL,
	ativarautocorrecao CHAR(1) NOT NULL,
	qtdexecucoesagendador NUMBER(10,0),
	nomeitemconfiguracaopai VARCHAR2(400),
	host VARCHAR2(50),
	grupocategoriaocorrencia VARCHAR2(200),
	categoriaocorrencia VARCHAR2(200),
	gerarocorrenciasup CHAR(1) NULL,
	acaoup VARCHAR2(255) NULL,
	urgenciaup CHAR(1) NULL,
	impactoup CHAR(1) NULL,
	gerarocorrenciasdown CHAR(1) NULL,
	acaodown VARCHAR2(255) NULL,
	urgenciadown CHAR(1) NULL,
	impactodown CHAR(1) NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventos) REFERENCES auditoriaeventos (idauditoriaeventos)
);

-- FIM - [deborah.ferreira] - 12/02/2016
-- INICIO - thyen.chang - 12.02.2016

CREATE TABLE ITEMCONFIGURACAOVALOR(
  IDITEMCONFIGURACAOVALOR NUMBER(24,0) NOT NULL,
  IDITEMCONFIGURACAO NUMBER(24,0) NOT NULL,
  DATAINICIOVALOR DATE NOT NULL,
  DATAFIMVALOR DATE,
  DATAFIM DATE,
  VALOR FLOAT NOT NULL,
   PRIMARY KEY (IDITEMCONFIGURACAOVALOR),
  CONSTRAINT FK_ITEMCONFIGURACAOVALOR FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO (IDITEMCONFIGURACAO)
);

-- FIM - thyen.chang - 12.02.2016

--INICIO - joao.morais - 15/02/2016
create table categoriaameaca(
	idcategoriaameaca number(10,0) not null,
	nomecategoriaameaca varchar(255) not null,
	datafim date,
	primary key (idcategoriaameaca)
);
-- FIM - joao.morais - 15/02/2016

--INICIO - [rodrigo.acorse] - 16/02/2015

create table continuidade (
	idcontinuidade number not null,
	nomeregistrocontinuidade varchar2(500),
	idcliente number(10,0) not NULL,
	datainicio date not null,
	datafim date,
	constraint continuidade_pk primary key (idcontinuidade) enable,
	constraint cliente_continuidade_pkey foreign key (idcliente) references  clientes(idcliente)
);

-- FIM - [rodrigo.acorse] - 16/02/2015

-- INICIO - joao.morais - 16/02/2016
create table ameaca(
	idameaca number(10, 0) not null,
	nomeameaca varchar (255) not null,
	idcategoriaameaca number(10, 0) not null,
	datafim date,
	primary key(idameaca),
	constraint fk_categoriaameaca foreign key (idcategoriaameaca) references categoriaameaca (idcategoriaameaca)
);
-- FIM - joao.morais - 16/02/2016

-- INCIO - [pedro.francisco] - 16/02/2016
alter table planomelhoria rename column datainicio to datainicioplano;
alter table planomelhoria rename column datafim to datafimplano;

alter table acaoplanomelhoria rename column datainicio to datainicioacao;
alter table acaoplanomelhoria rename column datafim to datafimacao;

alter table planomelhoria add datafim date;
-- FIM - [pedro.francisco] - 16/02/2016

-- INICIO - [deborah.ferreira] - 16/02/2016

-- ocorrenciaservicoatributosfinanceiros
ALTER TABLE ocorrenciaservatrfinan ADD classificacaoAtributosFinan NUMBER;

CREATE TABLE ocorrenciaservicobaseconhecim (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idbaseconhecimento NUMBER(10,0) NOT NULL,
	nomebaseconhecimento VARCHAR2(256) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicohabilidade (
	id NUMBER(10,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idhabilidade NUMBER(10,0) NOT NULL,
	nomehabilidade VARCHAR2(255) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);
-- FIM - [deborah.ferreira] - 16/02/2016-- FIM - thyen.chang - 02/02-2016

-- INICIO - rodrigo.acorse - 10/02/2016

delete from menu where nome = '$menu.nome.graficoTempoReal';
delete from menu where nome = '$menu.nome.monitoramento.incidente';

-- FIM - rodrigo.acorse - 10/02/2016

-- INICIO - gilmar.junior - 19/02/2016
ALTER TABLE processonegocio ADD idcliente NUMBER(24,0);
ALTER TABLE processonegocio ADD CONSTRAINT processonegocio_idcliente_fk FOREIGN KEY (idcliente) REFERENCES clientes (idcliente);
-- FIM - gilmar.junior - 19/02/2016

-- INICIO - [pedro.francisco] - 19/02/2016
create table iniciacaoescopo (
	idescopo NUMBER(10,0) NOT NULL,
	idcontinuidade number NOT NULL,
	descricao varchar2(255) not null,
	sumarioexecutivo varchar2(255) not null,
	validade date not null,
	primary key (idescopo),
	constraint fk_cont_escopo foreign key (idcontinuidade) references continuidade(idcontinuidade)
);
-- FIM - [pedro.francisco] - 19/02/2016


-- INICIO - joao.morais - 22/02/2016
create table iniciacaopolitica(
	idpolitica number(10,0) not null,
	idcontinuidade number not null,
	idgruporesponsavel number(10,0),
	idresponsavel number(10,0),
	titulo varchar(255) not null,
	datacriacao date not null,
	datavalidade date not null,
	descricao varchar(255),
	responsavel varchar(255),
	gruporesponsavel varchar(255),
	versao varchar(20) not null,
	datafim date,
	primary key(idpolitica),
	constraint fk_cont_politica foreign key (idcontinuidade) references continuidade(idcontinuidade),
	constraint fk_grupo_resp_politica foreign key (idgruporesponsavel) references grupo(idgrupo),
	constraint fk_responsavel_politica foreign key (idresponsavel) references empregados(idempregado)
);

alter table iniciacaopolitica rename column titulo to tituloiniciacaopolitica;
alter table iniciacaopolitica rename column versao to versaoiniciacaopolitica;
alter table iniciacaopolitica rename column descricao to descricaoiniciacaopolitica;
alter table iniciacaopolitica rename column datavalidade to datavalidadeiniciacaopolitica;
alter table iniciacaopolitica rename column responsavel to responsaveliniciacaopolitica;
alter table iniciacaopolitica rename column idresponsavel to idresponsaveliniciacaopolitica;
alter table iniciacaopolitica rename column idgruporesponsavel to idgruporespiniciacaopolitica;
-- FIM - joao.morais - 22/02/2016

-- INCIO - [deborah.ferreira] - 22/02/2016

CREATE TABLE auditoriaeventosgerentesserv (
	id NUMBER(10,0) NOT NULL,
	idauditoriaeventosgerentes NUMBER(10,0) NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	nomeservico VARCHAR(255),
	nomeconfiguracao VARCHAR(400),
	nometipoconfiguracao VARCHAR(255),
	checkconfiguracao VARCHAR(255),
	grupocategoriaocorrencia VARCHAR(200),
	categoriaocorrencia VARCHAR(200),
	gerarocorrenciasinformation CHAR(1),
	eplinformation CLOB,
	condicaoinformation VARCHAR(50),
	valorcondicaoinformation VARCHAR(50),
	acaoinformation VARCHAR(255),
	urgenciainformation CHAR(1),
	impactoinformation CHAR(1),
	gerarocorrenciaswarning CHAR(1),
	eplwarning CLOB,
	condicaowarning VARCHAR(50),
	valorcondicaowarning VARCHAR(50),
	acaowarning VARCHAR(255),
	urgenciawarning CHAR(1),
	impactowarning CHAR(1),
	gerarocorrenciasexception CHAR(1),
	eplexception CLOB,
	condicaoexception VARCHAR(50),
	valorcondicaoexception VARCHAR(50),
	acaoexception VARCHAR(255),
	urgenciaexception CHAR(1),
	impactoexception CHAR(1),
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventosgerentes) REFERENCES auditoriaeventosgerentes (id)
);

CREATE TABLE auditoriaeventosgergennagios (
	id NUMBER(10,0) NOT NULL,
	idauditoriaeventos NUMBER(24,0) NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idgerente NUMBER(10,0) NOT NULL,
	nomegerente VARCHAR(255) NOT NULL,
	conexao VARCHAR(50) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventos) REFERENCES auditoriaeventos (idauditoriaeventos)
);

CREATE TABLE auditoriaeventosgergennagserv (
	id NUMBER(10,0) NOT NULL,
	idauditoriaeventosgergennagios NUMBER(10,0) NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idlinha NUMBER(10,0) NOT NULL,
	hostservico VARCHAR2(50),
	nomeservico VARCHAR2(50),
	grupocategoriaocorrencia VARCHAR(200) NOT NULL,
	categoriaocorrencia VARCHAR(200) NOT NULL,
	agendador VARCHAR(50) NOT NULL,
	servicoativo CHAR(1) NULL,
	gerarocorrenciasup CHAR(1) NULL,
	acaoup VARCHAR(255) NULL,
	urgenciaup CHAR(1) NULL,
	impactoup CHAR(1) NULL,
	gerarocorrenciasdown CHAR(1) NULL,
	acaodown VARCHAR(255) NULL,
	urgenciadown CHAR(1) NULL,
	impactodown CHAR(1) NULL,
	gerarocorrenciasinformation CHAR(1),
	acaoinformation VARCHAR(255),
	urgenciainformation CHAR(1),
	impactoinformation CHAR(1),
	gerarocorrenciaswarning CHAR(1),
	acaowarning VARCHAR(255),
	urgenciawarning CHAR(1),
	impactowarning CHAR(1),
	gerarocorrenciasexception CHAR(1),
	acaoexception VARCHAR(255),
	urgenciaexception CHAR(1),
	impactoexception CHAR(1),
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventosgergennagios) REFERENCES auditoriaeventosgergennagios (id)
);

CREATE TABLE auditoriaeventosgerentecorrel (
	id NUMBER(10,0) NOT NULL,
	idauditoriaeventos NUMBER(24,0) NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idgerente NUMBER(10,0) NOT NULL,
	nomegerente VARCHAR(255) NOT NULL,
	conexao VARCHAR(50) NOT NULL,
	grupocategoriaocorrencia VARCHAR(200) NOT NULL,
	categoriaocorrencia VARCHAR(200) NOT NULL,
	acaoinformation VARCHAR(255),
	urgenciainformation CHAR(1),
	impactoinformation CHAR(1),
	eplinformation CLOB,
	acaowarning VARCHAR(255),
	urgenciawarning CHAR(1),
	impactowarning CHAR(1),
	eplwarning CLOB,
	acaoexception VARCHAR(255),
	urgenciaexception CHAR(1),
	impactoexception CHAR(1),
	eplexception CLOB,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventos) REFERENCES auditoriaeventos (idauditoriaeventos)
);
-- FIM - [deborah.ferreira] - 22/02/2016

-- INICIO - [pedro.francisco] - 24/02/2016
create table funcoesvitais (
	idfuncaovital number not null,
	idcontinuidade number not null,
	nome varchar(255) not null,
	idprocessonegocio number not null,
	prioridade int not null,
	datafim DATE,
	primary key (idfuncaovital),
	constraint fk_fvital foreign key (idcontinuidade) references continuidade(idcontinuidade),
	constraint fk_fvital_pn foreign key (idprocessonegocio) references processonegocio(idprocessonegocio)
);
-- FIM - [pedro.francisco] - 24/02/2016

-- INCIO [gustavo.gomes] 03.02.2016
CREATE TABLE servicobaseconhecimento
(
	idservicobaseconhecimento NUMBER(24,0) NOT NULL,
	idservico  NUMBER(24,0) NOT NULL,
	idbaseconhecimento  NUMBER(24,0) NOT NULL,
	PRIMARY KEY (idservicobaseconhecimento) ,
	FOREIGN KEY (idservico) REFERENCES Servico (idservico)
);

CREATE TABLE categoriarisco
(
	idcategoriarisco NUMBER(24,0) NOT NULL,
	nome VARCHAR(255) NOT NULL ,
	tag VARCHAR(255),
	cor VARCHAR(255),
	icone VARCHAR(255),
	datafim DATE,
	PRIMARY KEY (idcategoriarisco)
);

ALTER TABLE risco ADD (idcategoriarisco NUMBER(24,0));
ALTER TABLE risco ADD FOREIGN KEY (idcategoriarisco) REFERENCES categoriarisco(idcategoriarisco);
ALTER TABLE ameaca ADD (tipo VARCHAR(1));

CREATE TABLE ameacarisco
(
	idameacariscocont NUMBER(24,0) NOT NULL,
	idrisco NUMBER(24,0) NOT NULL,
	idameaca NUMBER(24,0) NOT NULL,
	PRIMARY KEY (idameacariscocont)
);
-- FIM [gustavo.gomes] 24.02.2016

-- INICIO - [thyen.chang] - 25.02.2016

CREATE TABLE PROBLEMASERVICONEGOCIO(
  idproblemaserviconegocio NUMBER NOT NULL
  ,idproblema NUMBER NOT NULL
  ,idservico NUMBER NOT NULL
  ,PRIMARY KEY (idproblemaserviconegocio)
  ,CONSTRAINT fk_probserv_prob FOREIGN KEY (idproblema) REFERENCES PROBLEMA (idproblema)
  ,CONSTRAINT fk_probserv_serv FOREIGN KEY (idservico) REFERENCES SERVICO (idservico)
);

-- FIM - [thyen.chang] - 25.02.2016

-- INICIO [deborah.ferreira] - 26.02.2016

CREATE TABLE iniciacaoprojeto (
	idiniciacaoprojeto NUMBER(10,0) NOT NULL,
	idcontinuidadeiniciacaoprojeto NUMBER NOT NULL,
	idprojetoiniciacaoprojeto NUMBER(10,0) NOT NULL,
	PRIMARY KEY (idiniciacaoprojeto),
	FOREIGN KEY (idcontinuidadeiniciacaoprojeto) REFERENCES continuidade (idcontinuidade),
	FOREIGN KEY (idprojetoiniciacaoprojeto) REFERENCES projetos (idprojeto)
);

-- FIM [deborah.ferreira] - 26.02.2016

-- INICIO - euler.ramos - 18/02/2016

-- CRIANDO A TABELA configdestinatario
CREATE TABLE configdestinatario(
  idconfigdestinatario NUMBER(19) NOT NULL,
  nomeconfigdestinatario  VARCHAR2(255 CHAR) NOT NULL,
  datahorafim DATE not null,
  primary key (idconfigdestinatario)
);
-- FIM DA CRIAO DA TABELA configdestinatario

-- CRIANDO A TABELA destinatarioempregados
CREATE TABLE destinatarioempregados(
  idconfigdestinatario NUMBER(19) NOT NULL,
  idempregado NUMBER(10,0), 
  PRIMARY KEY (idconfigdestinatario, idempregado));

alter table destinatarioempregados add constraint fkconfigdestempdest foreign key (idconfigdestinatario) references configdestinatario(idconfigdestinatario);
alter table destinatarioempregados add constraint fkconfigdestempemp foreign key (IDEMPREGADO) references empregados(IDEMPREGADO);
-- FIM DA CRIAO DA TABELA destinatarioempregados

-- CRIANDO A TABELA destinatarioempregados
CREATE TABLE destinatariogrupos(
  idconfigdestinatario NUMBER(19) NOT NULL,
  idgrupo  NUMBER(10,0), 
  PRIMARY KEY (idconfigdestinatario, idgrupo)
);
alter table destinatariogrupos add constraint fkconfigdestgrpdest foreign key (idconfigdestinatario) references configdestinatario(idconfigdestinatario);
alter table destinatariogrupos add constraint fkconfigdestgrpgrp foreign key (idgrupo) references grupo(idgrupo);
-- FIM DA CRIAO DA TABELA destinatariogrupos

-- CRIANDO A TABELA configeventonotificacao
CREATE TABLE configeventonotificacao (
idconfigeventonotificacao NUMBER(19) not null,
  identificador varchar2(254)NOT NULL,
  classenegocio varchar2(254) NOT NULL,
  descricao varchar2(254) NOT NULL,
  epl clob NOT NULL,
  nivelalerta varchar2(254) NOT NULL, 
  prazoconfirmacao NUMBER(10,0),
  prazoalerta NUMBER(10,0),
  prazoescalonamento NUMBER(10,0),
  idconfigdestinatarioinicial NUMBER(19) not null,
  idmodeloemailinicial NUMBER(19) NOT NULL,
  idconfigdestinatarioescalon NUMBER(19) null,
  idmodeloemailescalonamento NUMBER(19),
  datahorafim DATE,
  exigeconfirmacao char(1) NOT NULL);
  
alter table configeventonotificacao add primary key (idconfigeventonotificacao);
alter table configeventonotificacao add constraint fkconfigevnotmailini foreign key (idmodeloemailinicial) references modelosemails(idmodeloemail);
alter table configeventonotificacao add constraint fkconfigevnotmailesc foreign key (idmodeloemailescalonamento) references modelosemails(idmodeloemail);
alter table configeventonotificacao add constraint fkconfigevnotdestini foreign key (idconfigdestinatarioinicial) references configdestinatario(idconfigdestinatario);
alter table configeventonotificacao add constraint fkconfigevnotdestesc foreign key (idconfigdestinatarioescalon) references configdestinatario(idconfigdestinatario);
-- FIM DA CRIAO DA TABELA configeventonotificacao

CREATE TABLE modeloepl 
( 
  idmodeloepl NUMBER(10,0) NOT NULL, 
  descricao varchar2(255) NOT NULL, 
  modeloepl clob NOT NULL, 
  datahorafim DATE, 
  CONSTRAINT modeloepl_pkey PRIMARY KEY (idmodeloepl) 
);

-- FIM - euler.ramos - 18/02/2016

-- INICIO - thyen.chang - 29.02.2016

CREATE TABLE INDICADORCAPACIDADE( 
	idindicadorcapacidade NUMBER(10,0) NOT NULL, 
	nome VARCHAR2(255) NOT NULL, 
	valor VARCHAR2(255) NOT NULL, 
	datahorafim TIMESTAMP, 
	CONSTRAINT PK_INDICADORCAPACIDADE PRIMARY KEY (idindicadorcapacidade) 
);

CREATE TABLE INDICADORESCAPACIDADESERVICO(
	idindicadorcapacidadeservico NUMBER(10,0) NOT NULL
	,idindicadorcapacidade NUMBER(10,0) NOT NULL
	,idservico NUMBER(10,0) NOT NULL
	,PRIMARY KEY (idindicadorcapacidadeservico)
	,CONSTRAINT fk_capser_indcap FOREIGN KEY (idindicadorcapacidade) REFERENCES INDICADORCAPACIDADE (idindicadorcapacidade)
	,CONSTRAINT fk_capser_ser FOREIGN KEY (idservico) REFERENCES SERVICO (idservico)
);

-- FIM - thyen.chang - 29.02.2016

-- INICIO - douglas.japiassu - 01.03.2016
alter table servico add incidentecritico char(1);
-- FIM - douglas.japiassu - 01.03.2016

-- INICIO - thyen.chang - 01.03.2016

CREATE TABLE ATRIBUTODEMANDA( 
	idatributodemanda NUMBER(10,0) NOT NULL, 
	nome VARCHAR2(255) NOT NULL, 
	valor VARCHAR2(255) NOT NULL, 
	datahorafim TIMESTAMP, 
	CONSTRAINT PK_ATRIBUTODEMANDA PRIMARY KEY (idatributodemanda) 
);

CREATE TABLE ATRIBUTODEMANDASERVICO(
	idatributodemandaservico NUMBER(10,0) NOT NULL
	,idatributodemanda NUMBER(10,0) NOT NULL
	,idservico NUMBER(10,0) NOT NULL
	,PRIMARY KEY (idatributodemandaservico)
	,CONSTRAINT fk_demser_atrdem FOREIGN KEY (idatributodemanda) REFERENCES ATRIBUTODEMANDA (idatributodemanda)
	,CONSTRAINT fk_demser_ser FOREIGN KEY (idservico) REFERENCES SERVICO (idservico)
);

-- FIM - thyen.chang - 01.03.2016

-- INICIO [rodrigo.acorse] - 29.02.2016

CREATE TABLE cenario (
	idcenario number not null,
	nomecenario varchar2(255) not null,
	idfuncaovital number not null,
	idcontinuidade number not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenario),
	FOREIGN KEY (idfuncaovital) REFERENCES funcoesvitais (idfuncaovital),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE cenariorisco (
	idcenariorisco number not null,
	idcenario number not null,
	idrisco number not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenariorisco),
	FOREIGN KEY (idcenario) REFERENCES cenario (idcenario),
	FOREIGN KEY (idrisco) REFERENCES risco (idrisco)
);

CREATE TABLE cenarioservico (
	idcenarioservico number not null,
	idcenario number not null,
	idservico number not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenarioservico),
	FOREIGN KEY (idcenario) REFERENCES cenario (idcenario),
	FOREIGN KEY (idservico) REFERENCES servico (idservico)
);

CREATE TABLE tratativa (
	idtratativa number not null,
	nometratativa varchar2(255) not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idtratativa)
);

CREATE TABLE cenarioriscoameaca (
	idcenarioriscoameaca number not null,
	idcenariorisco number not null,
	idameaca number not null,
	probabilidade number not null,
	impacto decimal(10,2) not null,
	justificativa CLOB,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenarioriscoameaca),
	FOREIGN KEY (idcenariorisco) REFERENCES cenariorisco (idcenariorisco),
	FOREIGN KEY (idameaca) REFERENCES ameaca (idameaca)
);

CREATE TABLE cenarioriscotratativa (
	idcenarioriscotratativa number not null,
	idcenariorisco number not null,
	idtratativa number not null,
	probabilidade number not null,
	impacto decimal(10,2) not null,
	medidarecuperacao CLOB,
	planomitigacao CLOB,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenarioriscotratativa),
	FOREIGN KEY (idcenariorisco) REFERENCES cenariorisco (idcenariorisco),
	FOREIGN KEY (idtratativa) REFERENCES tratativa (idtratativa)
);

CREATE TABLE cenarioriscotratativaameaca (
	idtratativaameaca number not null,
	idcenarioriscotratativa number not null,
	idcenarioriscoameaca number not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idtratativaameaca),
	FOREIGN KEY (idcenarioriscotratativa) REFERENCES cenarioriscotratativa (idcenarioriscotratativa),
	FOREIGN KEY (idcenarioriscoameaca) REFERENCES cenarioriscoameaca (idcenarioriscoameaca)
);

-- FIM [rodrigo.acorse] - 29.02.2016

-- INICIO [gilmar.junior] - 02.03.2016
CREATE TABLE impactoain
(
  idimpactoain number NOT NULL,
  impactoain character varying(255) NOT NULL,
  datahorafim timestamp DEFAULT NULL,
  PRIMARY KEY (idimpactoain)
);
  
CREATE TABLE analiseimpactonegocio
(
  idanaliseimpactonegocio number NOT NULL,
  idcontinuidade number NOT NULL,
  idfuncaovital number NOT NULL,
  impacto varchar2(254),
  severidade char(1),
  custohora double precision,
  custoimpacto double precision,
  maxtoleravelinatividade varchar2(8),
  objvtemporec varchar2(8),
  objvpontorec varchar2(8),
  estrategia1 clob,
  estrategia2 clob,
  estrategia3 clob,
  datahorafim timestamp DEFAULT NULL,
  PRIMARY KEY (idanaliseimpactonegocio),
  FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade),
  FOREIGN KEY (idfuncaovital) REFERENCES funcoesvitais (idfuncaovital)
);
-- FIM [gilmar.junior] - 02.03.2016

-- INICIO [deborah.ferreira] - 03.03.2016

CREATE TABLE planejamentoorganizacional (
	id NUMBER(10,0) NOT NULL,
	idcontinuidade NUMBER NOT NULL,
	sumarioexecutivo CLOB NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE planejamentoorganizacionalgrp (
	id NUMBER(10,0) NOT NULL,
	idplanejamentoorganizacional NUMBER(10,0) NOT NULL,
	idgrupo NUMBER(10,0) NOT NULL,
	tipogrupo CHAR(5) NOT NULL,
	responsabilidade VARCHAR2(255 CHAR) NOT NULL,
	datafim DATE,
	PRIMARY KEY (id),
	FOREIGN KEY (idplanejamentoorganizacional) REFERENCES planejamentoorganizacional (id)
);

-- FIM [deborah.ferreira] - 03.03.2016

-- INICIO [rodrigo.acorse] - 07.03.2016

CREATE TABLE calendarioevento (
	idevento number not null,
	idcontinuidade number not null,
	nomeevento varchar2(255) not null,
	detalhesevento CLOB,
	datainicioevento timestamp not null,
	datafimevento timestamp not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idevento)
);

CREATE TABLE calendarioeventogrupo (
	ideventogrupo number not null,
	idevento number not null,
	idgrupo number not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventogrupo),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idgrupo) REFERENCES grupo (idgrupo)
);

CREATE TABLE calendarioeventoempregado (
	ideventoempregado number not null,
	idevento number not null,
	idempregado number not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventoempregado),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idempregado) REFERENCES empregados (idempregado)
);

-- FIM [rodrigo.acorse] - 07.03.2016

-- INICIO [gilberto.nery] - 07.03.2016

CREATE TABLE liberacaobaseconhecimento (
	idliberacao NUMBER(10,0) NOT NULL,
	idbaseconhecimento NUMBER(10,0) NOT NULL,
	FOREIGN KEY (idliberacao) REFERENCES liberacao (idliberacao)
);

-- FIM [gilberto.nery] - 07.03.2016

-- INICIO [euler.ramos] - 08.03.2016

CREATE TABLE conhecimentomidiasoftware( 
  idconhecimentomidiasoftware NUMBER(24,0) NOT NULL, 
  idmidiasoftware NUMBER(10,0) NOT NULL, 
  idbaseconhecimento NUMBER(10,0) NOT NULL, 
  datafim date, 
  CONSTRAINT pkconhecimentomidiasoftware PRIMARY KEY (idconhecimentomidiasoftware), 
  CONSTRAINT fk_conhmsoft_midiasoftware FOREIGN KEY (idmidiasoftware) 
      REFERENCES midiasoftware (idmidiasoftware) 
);

-- FIM [euler.ramos] - 08.03.2016

-- INICIO - thyen.chang - 08.03.2016

CREATE TABLE INDICADORESCAPACIDADEIC(
	idindicadorcapacidadeic NUMBER(10,0) NOT NULL
	,idindicadorcapacidade NUMBER(10,0) NOT NULL
	,iditemconfiguracao NUMBER(10,0) NOT NULL
	,PRIMARY KEY (idindicadorcapacidadeic)
	,CONSTRAINT fk_capic_indcap FOREIGN KEY (idindicadorcapacidade) REFERENCES INDICADORCAPACIDADE (idindicadorcapacidade)
	,CONSTRAINT fk_capic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES ITEMCONFIGURACAO (iditemconfiguracao)
);

-- FIM - thyen.chang - 08.03.2016

-- INICIO [deborah.ferreira] - 08.03.2016

CREATE TABLE conscientizacao (
	idconscientizacao NUMBER(10,0) NOT NULL,
	idcontinuidade NUMBER NOT NULL,
	sumarioexecutivo CLOB NOT NULL,
	PRIMARY KEY (idconscientizacao),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE conscientizacaoregistro (
	idconscientizacaoregistro NUMBER(10,0) NOT NULL,
	idconscientizacao NUMBER(10,0) NOT NULL,
	analisecriticaacao CLOB NOT NULL,
	tipoatividade CHAR(5) NOT NULL,
	status CHAR(5) NOT NULL,
	datafim DATE NULL,
	PRIMARY KEY (idconscientizacaoregistro),
	FOREIGN KEY (idconscientizacao) REFERENCES conscientizacao (idconscientizacao)
);

-- FIM [deborah.ferreira] - 08.03.2016

-- INCIO [douglas.japiassu] - 09.03.2016

CREATE TABLE estrategiacontinuidade (
	idestrategiacontinuidade number not null,
	idcontinuidade number not null,
	sumarioexecutivo clob,
	objetivo clob,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idestrategiacontinuidade),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE estrategiafuncaovital (
	idestrategiafuncaovital number not null,
	idestrategiacontinuidade number not null,
	idfuncaovital number not null,
	PRIMARY KEY (idestrategiafuncaovital),
	FOREIGN KEY (idestrategiacontinuidade) REFERENCES estrategiacontinuidade (idestrategiacontinuidade),
	FOREIGN KEY (idfuncaovital) REFERENCES funcoesvitais (idfuncaovital)
);

CREATE TABLE medidaresposta (
	idmedidaresposta number not null,
	idestrategiacontinuidade number not null,
	idcenarioriscotratativa number not null,
	nome varchar2(255) not null,
	justificativa clob,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idmedidaresposta),
	FOREIGN KEY (idestrategiacontinuidade) REFERENCES estrategiacontinuidade (idestrategiacontinuidade),
	FOREIGN KEY (idcenarioriscotratativa) REFERENCES cenarioriscotratativa (idcenarioriscotratativa)
);

CREATE TABLE medidarespostaprojeto (
	idmedidarespostaprojeto number not null,
	idmedidaresposta number not null,
	idprojeto number(10,0) not null,
	PRIMARY KEY (idmedidarespostaprojeto),
	FOREIGN KEY (idmedidaresposta) REFERENCES medidaresposta (idmedidaresposta),
	FOREIGN KEY (idprojeto) REFERENCES projetos (idprojeto)
);

CREATE TABLE medidarecuperacao (
	idmedidarecuperacao number not null,
	idestrategiacontinuidade number not null,
	idcenarioriscotratativa number not null,
	nome varchar2(255) not null,
	tiporecuperacao varchar(2) not null,
	justificativa clob,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idmedidarecuperacao),
	FOREIGN KEY (idestrategiacontinuidade) REFERENCES estrategiacontinuidade (idestrategiacontinuidade),
	FOREIGN KEY (idcenarioriscotratativa) REFERENCES cenarioriscotratativa (idcenarioriscotratativa)
);

CREATE TABLE medidarecuperacaobaseconhec (
	idmedidarecuperacaobaseconhec number not null,
	idmedidarecuperacao number not null,
	idbaseconhecimento number(10,0) not null,
	PRIMARY KEY (idmedidarecuperacaobaseconhec),
	FOREIGN KEY (idmedidarecuperacao) REFERENCES medidarecuperacao (idmedidarecuperacao)
);

-- FIM [douglas.japiassu] - 09.03.2016

-- INICIO - thyen.chang - 09.03.2016

CREATE TABLE ATRIBUTODEMANDAIC(
	idatributodemandaic NUMBER(10,0) NOT NULL
	,idatributodemanda NUMBER(10,0) NOT NULL
	,iditemconfiguracao NUMBER(10,0) NOT NULL
	,PRIMARY KEY (idatributodemandaic)
	,CONSTRAINT fk_dmdic_atrdm FOREIGN KEY (idatributodemanda) REFERENCES ATRIBUTODEMANDA (idatributodemanda)
	,CONSTRAINT fk_dmdic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES ITEMCONFIGURACAO (iditemconfiguracao)
);

-- FIM - thyen.chang - 09.03.2016

-- INICIO [gilberto.ney] - 09.03.2016

CREATE TABLE mudancabaseconhecimento (
	idrequisicaomudanca NUMBER(10,0) NOT NULL,
	idbaseconhecimento NUMBER(10,0) NOT NULL,
	FOREIGN KEY (idrequisicaomudanca) REFERENCES requisicaomudanca (idrequisicaomudanca)
);

-- FIM [gilberto.ney] - 09.03.2016


--INICIO [gustavo.gomes] - 07.03.2016

CREATE TABLE auditoriacontinuidade(
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	idcontinuidade NUMBER(24,0) NOT NULL,
	usuario VARCHAR2(255) NOT NULL,
	datacriacao TIMESTAMP NOT NULL,
	categoriaauditoria VARCHAR2(10) NOT NULL,
	tipoauditoria VARCHAR2(10) NOT NULL,
	descricaoauditoria CLOB,
	PRIMARY KEY (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontpolitica(
	idauditoriacontpolitica NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	titulopolitica VARCHAR2(255),
	versaopolitica VARCHAR2(20),
	datavalidadepolitica DATE,
	descricaopolitica VARCHAR2(255),
	responsavelpolitica VARCHAR2(255),
	PRIMARY KEY (idauditoriacontpolitica),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontescopo(
	idauditoriacontescopo NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoAuditoria CHAR(1) NULL,
	sumarioexecutivo VARCHAR2(255),
	descricaoescopo VARCHAR2(255),
	datavalidadeescopo DATE,
	PRIMARY KEY (idauditoriacontescopo),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontprojeto(
	idauditoriacontprojeto NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idprojeto NUMBER(24,0),
	nomeprojeto VARCHAR2(255),
	PRIMARY KEY (idauditoriacontprojeto),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

--FIM [gustavo.gomes] 09.03.2016 
-- INICIO [gilberto.ney] - 10.03.2016

INSERT INTO tipodemandaservico (idtipodemandaservico,nometipodemandaservico,classificacao,deleted)
select idtipodemandaservico + 1, 'Procedimento', 'P', NULL from tipodemandaservico where ROWNUM <=1 order by idtipodemandaservico desc;

-- FIM [gilberto.ney] - 10.03.2016 
-- INICIO [pedro.francisco] - 11.03.2016

create table planocontinuidade(
	idplanodecontinuidade number(10,0) not null,
	idcontinuidade number not null,
	
	titulo varchar(255) not null,
	status number not null,
	descricao varchar(255) not null,
	validade date not null,
	autorizacao number not null,
	
	idresponsavel number,
	idresponsavelgrupo number,
	idprocedimentodecontinuidade number not null,
	
	datafim date,
	
	primary key(idplanodecontinuidade),
	constraint fk_resp_grupo_pc foreign key (idresponsavelgrupo) references grupo(idgrupo),
	constraint fk_resp_pc foreign key (idresponsavel) references empregados(idempregado),
	constraint fk_continuidade foreign key (idcontinuidade) references continuidade(idcontinuidade)
);

-- FIM [pedro.francisco] - 11.03.2016

-- INICIO [deborah.ferreira] - 11.03.2016

CREATE TABLE auditoriacontinuidadeanexos (
	idauditoriacontinuidadeanexos NUMBER(10,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idanexo NUMBER(10,0) NOT NULL,
	idregistro NUMBER(10,0) NOT NULL,
	nomeanexo VARCHAR(255) NOT NULL,
	descricaoanexo VARCHAR(255) NOT NULL,
	PRIMARY KEY (idauditoriacontinuidadeanexos),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontfuncaovital(
	idauditoriacontfuncaovital NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idfuncaovital NUMBER NOT NULL,
	nomefuncaovital VARCHAR2(255) NOT NULL,
	nomeprocessonegocio VARCHAR2(100) NOT NULL,
	prioridadefuncaovital INT NOT NULL,
	PRIMARY KEY (idauditoriacontfuncaovital),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

-- FIM [deborah.ferreira] - 11.03.2016

-- INICIO [joao.morais] - 14.03.2016

CREATE TABLE auditoriacontavalrisco(
	idauditoriacontavalrisco NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenario NUMBER NOT NULL,
	nomecenario VARCHAR2(255) NOT NULL,
	nomefuncaovital VARCHAR(255) NOT NULL,
	PRIMARY KEY (idauditoriacontavalrisco),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontavalriscoserv(
	idauditoriacontavalriscoserv NUMBER(24,0) NOT NULL,
	idauditoriacontavalrisco NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenarioservico NUMBER NOT NULL,
	idservico NUMBER NOT NULL,
	nomeservico VARCHAR(500) NOT NULL,
	PRIMARY KEY (idauditoriacontavalriscoserv),
	FOREIGN KEY (idauditoriacontavalrisco) REFERENCES auditoriacontavalrisco (idauditoriacontavalrisco)
);

CREATE TABLE auditoriacontavalriscorisco(
	idauditoriacontavalriscorisco NUMBER(24,0) NOT NULL,
	idauditoriacontavalrisco NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenariorisco NUMBER NOT NULL,
	idrisco NUMBER NOT NULL,
	nomerisco VARCHAR(150) NOT NULL,
	PRIMARY KEY (idauditoriacontavalriscorisco),
	FOREIGN KEY (idauditoriacontavalrisco) REFERENCES auditoriacontavalrisco (idauditoriacontavalrisco)
);

CREATE TABLE auditoriacontavalriscotrata(
	idauditoriacontavalriscotrata NUMBER(24,0) NOT NULL,
	idauditoriacontavalriscorisco NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenarioriscotratativa NUMBER NOT NULL,
	idtratativa NUMBER NOT NULL,
	nometratativa VARCHAR2(255) NOT NULL,
	probabilidade NUMBER NOT NULL,
	impacto DECIMAL(10,2) NOT NULL,
	propostamedidarecuperacao CLOB,
	propostaplanomitigacao CLOB,
	ameacasrelacionadas CLOB,
	PRIMARY KEY (idauditoriacontavalriscotrata),
	FOREIGN KEY (idauditoriacontavalriscorisco) REFERENCES auditoriacontavalriscorisco (idauditoriacontavalriscorisco)
);

CREATE TABLE auditoriacontavalriscoameaca(
	idauditoriacontavalriscameaca NUMBER(24,0) NOT NULL,
	idauditoriacontavalriscorisco NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenarioriscoameaca number not null,
	idameaca NUMBER(10, 0) NOT NULL,
	nomeameaca VARCHAR (255) NOT NULL,
	nomecategoriaameaca VARCHAR(255) NOT NULL,
	probabilidade NUMBER NOT NULL,
	impacto DECIMAL(10,2) NOT NULL,
	justificativa CLOB,
	PRIMARY KEY (idauditoriacontavalriscameaca),
	FOREIGN KEY (idauditoriacontavalriscorisco) REFERENCES auditoriacontavalriscorisco (idauditoriacontavalriscorisco)
);

CREATE TABLE auditoriaestcontservico(
	idauditoriaestcontservico NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idestrategiacontinuidade NUMBER NOT NULL,
	sumarioexecutivo CLOB,
	objetivo CLOB,
	PRIMARY KEY (idauditoriaestcontservico),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriaestcontservfuncvital(
	idauditoriaestcontservfuncvit NUMBER(24,0) NOT NULL,
	idauditoriaestcontservico NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idfuncaovital NUMBER NOT NULL,
	nomefuncaovital VARCHAR(255),
	PRIMARY KEY (idauditoriaestcontservfuncvit),
	FOREIGN KEY (idauditoriaestcontservico) REFERENCES auditoriaestcontservico (idauditoriaestcontservico)
);

CREATE TABLE auditoriaestcontservmedidarec(
	idauditoriaestcontservmedrec NUMBER(24,0) NOT NULL,
	idauditoriaestcontservico NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	nometratativa VARCHAR2(255) NOT NULL,
	idmedidarecuperacao NUMBER NOT NULL,
	nomemedidarecuperacao VARCHAR(255) NOT NULL,
	tiporecuperacao VARCHAR(2) NOT NULL,
	medidarecuperacao CLOB,
	justificativamedidarecuperacao CLOB,
	PRIMARY KEY (idauditoriaestcontservmedrec),
	FOREIGN KEY (idauditoriaestcontservico) REFERENCES auditoriaestcontservico (idauditoriaestcontservico)
);

CREATE TABLE auditoriaestcontservbaseconhec(
	idauditoriaestcontservbaseconh NUMBER(24,0) NOT NULL,
	idauditoriaestcontservmedrec NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idmedidarecuperacaobaseconhec NUMBER NOT NULL,
	nomebaseconhecimento varchar(256) NOT NULL,
	PRIMARY KEY (idauditoriaestcontservbaseconh),
	FOREIGN KEY (idauditoriaestcontservmedrec) REFERENCES auditoriaestcontservmedidarec (idauditoriaestcontservmedrec)
);

CREATE TABLE auditoriaestcontservmedresp(
	idauditoriaestcontservmedresp NUMBER(24,0) NOT NULL,
	idauditoriaestcontservico NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	nometratativa VARCHAR2(255) NOT NULL,
	idmedidaresposta NUMBER NOT NULL,
	nomemedidaresposta VARCHAR(255) NOT NULL,
	planomitigacao CLOB,
	justificativa CLOB,
	nomeprojeto CLOB,
	PRIMARY KEY (idauditoriaestcontservmedresp),
	FOREIGN KEY (idauditoriaestcontservico) REFERENCES auditoriaestcontservico (idauditoriaestcontservico)
);

CREATE TABLE auditoriaplanocontinuidade(
	idauditoriaplanocontinuidade NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanodecontinuidade NUMBER(10,0) NOT NULL,
	tituloplanocontinuidade varchar(255) NOT NULL,
	statusplanocontinuidade NUMBER NOT NULL,
	descricaoplanocontinuidade varchar(255) NOT NULL,
	nomeprocedimentocontinuidade varchar(254) NOT NULL,
	nomeresponsavel varchar(256) DEFAULT NULL,
	datavalidade DATE NOT NULL,
	autorizacao NUMBER NOT NULL,
	nomemudanca CLOB,
	PRIMARY KEY (idauditoriaplanocontinuidade),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriaplanocontconhecimento(
	idauditoriaplancontconheciment NUMBER(24,0) NOT NULL,
	idauditoriaplanocontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanocontinuidadeconheciment NUMBER NOT NULL,
	nomeconhecimento varchar(256) NOT NULL,
	PRIMARY KEY (idauditoriaplancontconheciment),
	FOREIGN KEY (idauditoriaplanocontinuidade) REFERENCES auditoriaplanocontinuidade (idauditoriaplanocontinuidade)
	
);

CREATE TABLE auditoriaplanocontmedidarec(
	idauditoriaplanocontmedidarec NUMBER(24,0) NOT NULL,
	idauditoriaplanocontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanocontinuidademedidarec NUMBER NOT NULL,
	medidarecuperacao VARCHAR(255) NOT NULL,
	PRIMARY KEY (idauditoriaplanocontmedidarec),
	FOREIGN KEY (idauditoriaplanocontinuidade) REFERENCES auditoriaplanocontinuidade (idauditoriaplanocontinuidade)
);

CREATE TABLE auditoriacontplanorganiza(
	idauditoriacontplanorganiza NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanejamentoorganizacional NUMBER(10,0) NOT NULL,
	sumarioexecutivo CLOB NOT NULL,
	PRIMARY KEY (idauditoriacontplanorganiza),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontplanorggrupo(
	idauditoriacontplanorggrupo NUMBER(24,0) NOT NULL,
	idauditoriacontplanorganiza NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanorganizacionalgrp NUMBER(10,0) NOT NULL,
	tipogrupo CHAR(5) NOT NULL,
	nomegrupo VARCHAR(255) NOT NULL,
	responsabilidade VARCHAR(255) NOT NULL,
	PRIMARY KEY(idauditoriacontplanorggrupo),
	FOREIGN KEY(idauditoriacontplanorganiza) REFERENCES auditoriacontplanorganiza (idauditoriacontplanorganiza)
);

CREATE TABLE auditoriacontconscientizacao(
	idauditoriacontconscientizacao NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idconscientizacao NUMBER(10,0) NOT NULL,
	sumarioexecutivo CLOB NOT NULL,
	PRIMARY KEY(idauditoriacontconscientizacao),
	FOREIGN KEY(idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontconscientregistro(
	idauditoriacontconscientregist NUMBER(24,0) NOT NULL,
	idauditoriacontconscientizacao NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idconscientizacaoregistro NUMBER(10,0) NOT NULL,
	analisecriticaacao CLOB NOT NULL,
	tipoatividade CHAR(5) NOT NULL,
	status CHAR(5) NOT NULL,
	PRIMARY KEY(idauditoriacontconscientregist),
	FOREIGN KEY(idauditoriacontconscientizacao) REFERENCES auditoriacontconscientizacao (idauditoriacontconscientizacao)
);

CREATE TABLE auditoriaestrategiatestes(
	idauditoriaestrategiatestes NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idestrategiatestes NUMBER NOT NULL,
	nomeestrategiateste VARCHAR(254) NOT NULL,
	sumarioexecutivoestteste CLOB,
	PRIMARY KEY (idauditoriaestrategiatestes),
	FOREIGN KEY(idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriaesttestmedrecup(
	idauditoriaesttestmedrecup NUMBER(24,0) NOT NULL,
	idauditoriaestrategiatestes NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idmedidarecuperacao NUMBER NOT NULL,
	nomemedidarecuperacao VARCHAR(255) NOT NULL,
	idplanoteste NUMBER NOT NULL,
	nomeplanoteste VARCHAR(255),
	descplanoteste CLOB,
	datainicio TIMESTAMP DEFAULT NULL,
	datatermino TIMESTAMP DEFAULT NULL,
	tipoteste VARCHAR(255) NULL,
	idtemplatecontinuidade NUMBER(10,0) NULL,
	nometemplatecontinuidade VARCHAR(200) NULL,
	PRIMARY KEY (idauditoriaesttestmedrecup),
	FOREIGN KEY (idauditoriaestrategiatestes) REFERENCES auditoriaestrategiatestes (idauditoriaestrategiatestes)
);

CREATE TABLE auditoriaestrtestplantestgrp(
	idauditoriaestrtestplantestgrp NUMBER(24,0) NOT NULL,
	idauditoriaesttestmedrecup NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	planotestegrupo NUMBER NOT NULL,
	idgrupo NUMBER NOT NULL,
	nomegrupo varchar(255) NOT NULL,
	tipo NUMBER NULL,
	PRIMARY KEY (idauditoriaestrtestplantestgrp),
	FOREIGN KEY (idauditoriaesttestmedrecup) REFERENCES auditoriaesttestmedrecup (idauditoriaesttestmedrecup)
);

-- FIM [joao.morais] - 14.03.2016

-- INICIO [joao.morais] - 19.03.2016

CREATE TABLE auditoriaconttestes(
	idauditoriaconttestes NUMBER(24,0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	idevento NUMBER NOT NULL,
	nomeevento varchar(255) NOT NULL,
	detalhesevento CLOB,
	datainicioevento TIMESTAMP NOT NULL,
	datafimevento TIMESTAMP NOT NULL,
	acaoauditoria CHAR(1) null,
	PRIMARY KEY (idauditoriaconttestes),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriaconttesteventgrp(
	idauditoriaconttesteventgrp NUMBER(24,0) NOT NULL,
	idauditoriaconttestes NUMBER(24,0) NOT NULL,
	idgrupo NUMBER NOT NULL,
	nomegrupo varchar(255) NOT NULL,
	acaoauditoria CHAR(1) null,
	PRIMARY KEY (idauditoriaconttesteventgrp),
	FOREIGN KEY (idauditoriaconttestes) REFERENCES auditoriaconttestes (idauditoriaconttestes)
);

CREATE TABLE auditoriaconttesteventemp(
	idauditoriaconttesteventemp NUMBER(24,0) NOT NULL,
	idauditoriaconttestes NUMBER(24,0) NOT NULL,
	idempregado NUMBER(10,0) NOT NULL,
	nomeempregado varchar(255) NOT NULL,
	acaoauditoria char(1) null,
	PRIMARY KEY (idauditoriaconttesteventemp),
	FOREIGN KEY (idauditoriaconttestes) REFERENCES auditoriaconttestes (idauditoriaconttestes)
);

CREATE TABLE auditoriaconttesteventevid(
	idauditoriaconttesteventevid NUMBER(24,0) NOT NULL,
	idauditoriaconttestes NUMBER(24,0) NOT NULL,
	nomeevidencia varchar(256) NOT NULL,
	acaoauditoria char(1) null,
	PRIMARY KEY (idauditoriaconttesteventevid),
	FOREIGN KEY (idauditoriaconttestes) REFERENCES auditoriaconttestes (idauditoriaconttestes)
);

CREATE TABLE auditoriacontinvocacao(
	idauditoriacontinvocacao NUMBER(24,0) not null,
	idauditoriacontinuidade NUMBER(24,0) not null,
	acaoauditoria CHAR(1) null,
	idsolicitacaoservicoincidente NUMBER(24,0) NOT NULL,
	idsolicitacaoservicoprocedimen NUMBER(24,0) NOT NULL,
	nomeIncidente varchar(500) NOT NULL,
	nomeprocedimento varchar(500) NOT NULL,
	nomeresponsavel varchar(255) NOT NULL,
	nomegrupoatual varchar(255) NOT NULL,
	situacao varchar(100) NOT NULL,
	PRIMARY KEY (idauditoriacontinvocacao),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

-- FIM [joao.morais] - 19.03.2016

-- INICIO - thyen.chang - 12.03.2016

ALTER TABLE BASECONHECIMENTO ADD TIPODOCUMENTO VARCHAR2(3);

UPDATE BASECONHECIMENTO SET TIPODOCUMENTO = (CASE WHEN FAQ = 'S' THEN 'F' WHEN ERROCONHECIDO = 'S' THEN 'E' ELSE 'D' END);

-- FIM - thyen.chang - 12.03.2016

-- INICIO - [gilberto.ney] - 04/12/2015

-- Cadastrar email de criacao de incidente critico 
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
select idmodeloemail + 1, 'CITSMART - Incidente Crtico criado. Nmero: ${IDSOLICITACAOSERVICO}', 'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que foi criado um incidente cr&iacute;tico. Incidente registrado em ${DATAHORASOLICITACAO}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Servi&ccedil;o:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.','A', 'IncidenteCriticoCri' from modelosemails where ROWNUM <=1 order by idmodeloemail desc;

-- Cadastrar email de aprovacao de incidente critico
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
select idmodeloemail + 1, 'CITSMART - Incidente Crtico aprovado. Nmero: ${IDSOLICITACAOSERVICO}', 'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que foi aprovado o incidente cr&iacute;tico n&uacute;mero: ${IDSOLICITACAOSERVICO}. Registrada em ${DATAHORASOLICITACAO}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Servi&ccedil;o:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.','A', 'IncidenteCriticoApr' from modelosemails where ROWNUM <=1 order by idmodeloemail desc;

-- Cadastrar email de criacao de incidente critico 
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values ((select idmodeloemail + 1 from modelosemails order by idmodeloemail desc limit 1), 'CITSMART - Critical Incident created. Number: ${IDSOLICITACAOSERVICO}',
'Mr(s) ${NOMECONTATO},<br /><br />Please be advised that the critical incident number ${IDSOLICITACAOSERVICO} was created. Registered on ${DATAHORASOLICITACAO}, as the data below:<br /><strong><br />Number:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Service:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Best regards,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'CriticalIncidentCreated');

-- Cadastrar email de aprovacao de incidente critico
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values ((select idmodeloemail + 1 from modelosemails order by idmodeloemail desc limit 1), 'CITSMART - Critical Incident approved. Number: ${IDSOLICITACAOSERVICO}', 
'Mr(s) ${NOMECONTATO},<br /><br />Please be advised that the critical incident number ${IDSOLICITACAOSERVICO} has been approved . Registered on ${DATAHORASOLICITACAO}, as the data below:<br /><strong><br />Number:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Service:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Best regards,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'CriticalIncidentApproved');

-- FIM [gilberto.ney] - 13.03.2016

-- INICIO - thyen.chang - 13.03.2016

CREATE TABLE planocontinuidadeconhecimento(
	idplanocontinuidadeconheciment NUMBER NOT NULL,
	idplanodecontinuidade number not null,
	idbaseconhecimento number not null,
	CONSTRAINT fk_pcc_pc FOREIGN KEY (idplanodecontinuidade) REFERENCES planocontinuidade (idplanodecontinuidade)
);


CREATE TABLE planocontinuidademudanca(
	idplanocontinuidademudanca NUMBER NOT NULL,
	idplanodecontinuidade number not null,
	idrequisicaomudanca number not null,
	CONSTRAINT fk_pcm_pc FOREIGN KEY (idplanodecontinuidade) REFERENCES planocontinuidade (idplanodecontinuidade),
	CONSTRAINT fk_pcm_rm FOREIGN KEY (idrequisicaomudanca) REFERENCES requisicaomudanca (idrequisicaomudanca)
);

CREATE TABLE planocontinuidademedidarec(
	idplanocontinuidademedidarec NUMBER NOT NULL,
	idplanodecontinuidade number not null,
	idmedidarecuperacao number not null,
	CONSTRAINT fk_pcmr_pc FOREIGN KEY (idplanodecontinuidade) REFERENCES planocontinuidade (idplanodecontinuidade),
	CONSTRAINT fk_pcmr_mr FOREIGN KEY (idmedidarecuperacao) REFERENCES medidarecuperacao (idmedidarecuperacao)
);
-- FIM - thyen.chang - 13.03.2016

--INCIO - [douglas.japiassu] - 13/03/2016

create table templatecontinuidade (
	idtemplatecontinuidade number(10,0) not null,
	identificacao varchar(255) not null,
	nometemplate varchar(200) not null,
	tipotemplate varchar(3) not null,
	nomeclassedto varchar(255),
	nomeclasseaction varchar(255),
	nomeclasseservico varchar(255),
	urlrecuperacao varchar(255),
	alturadiv number(10,0) not null,
	idquestionario integer,
	scriptaposrecuperacao clob,
	constraint templatecontinuidade_pk primary key (idtemplatecontinuidade) enable,
	constraint tempcont_questionario_fk foreign key (idquestionario) references questionario (idquestionario)
);

create table calendarioeventoquestionario (
	idcalendarioeventoquestionario number not null,
	idquestionario number not null,
	idevento number not null,
	dataquestionario timestamp not null,
	situacao char(1) not null,
	datahoragrav timestamp not null,
	constraint caleventquestionario_pk primary key (idcalendarioeventoquestionario),
	constraint calevt_questionario_fk foreign key (idquestionario) references questionario (idquestionario)
	constraint caleventquestionario_calevt_fk foreign key (idevento) references calendarioevento (idevento)
);

--FIM - [douglas.japiassu] - 13/03/2016

-- INICIO - gilmar.junior - 14.03.2016
CREATE TABLE estrategiatestes 
(
  idestrategiateste number not null,
  idcontinuidade number not null,
  sumarioexecutivo clob null,
  nomeiet VARCHAR2(254) not null,
  datahorafim timestamp default null,
  primary key (idestrategiateste),
  constraint fk_strtst_cont foreign key (idcontinuidade) references continuidade(idcontinuidade)
);

CREATE TABLE planoteste 
(
  idplanoteste number not null,
  idmedidarecuperacao number not null,
  idestrategiateste number not null,
  nomeplanoteste varchar(255) null,
  descplanoteste clob null,
  datainicio timestamp default null,
  datatermino timestamp default null,
  idtemplatecontinuidade number(10,0) null,
  datahorafim timestamp default null,
  primary key (idplanoteste),
  constraint fk_pltst_strtst foreign key (idestrategiateste) references estrategiatestes(idestrategiateste),
  constraint fk_pltst_medrec foreign key (idmedidarecuperacao) references medidarecuperacao(idmedidarecuperacao),
  constraint fk_pltst_tempcont foreign key (idtemplatecontinuidade) references templatecontinuidade(idtemplatecontinuidade)
);

CREATE TABLE planotestegrupo 
(
  idplanotestegrupo number not null,
  idgrupo number not null,
  idplanoteste number not null,
  tipo number null,
  datahorafim timestamp default null,
  primary key (idplanotestegrupo),
  constraint fk_pltstgrp_pltst foreign key (idplanoteste) references planoteste(idplanoteste),
  constraint fk_pltstgrp_grupo foreign key (idgrupo) references grupo(idgrupo)
);
-- FIM - gilmar.junior - 14.03.2016

-- INICIO [deborah.ferreira] - 14.03.2016

CREATE TABLE auditoriacontanalimpacnegocio (
	id NUMBER(10, 0) NOT NULL,
	idauditoriacontinuidade NUMBER(24,0) NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idanaliseimpactonegocio NUMBER NOT NULL,
	idfuncaovital NUMBER NOT NULL,
	nomefuncaovital VARCHAR(255) NOT NULL,
	impacto VARCHAR2(254),
	severidade CHAR(1),
	custohora DOUBLE PRECISION,
	custoimpacto DOUBLE PRECISION,
	maxtoleravelinatividade VARCHAR2(8),
	objtemporecuperacao VARCHAR2(8),
	objpontorecuperacao VARCHAR2(8),
	estrategia1 CLOB,
	estrategia2 CLOB,
	estrategia3 CLOB,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

-- FIM [deborah.ferreira] - 14.03.2016

-- INICIO - rodrigo.acorse - 14.03.2016

CREATE TABLE calendarioeventoteste (
	ideventoteste number not null,
	idevento number not null,
	idplanoteste number not null,
	situacao char(1),
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventoteste),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idplanoteste) REFERENCES planoteste (idplanoteste)
);

CREATE TABLE calendarioeventoconhecimento (
	ideventoconhecimento number not null,
	idevento number not null,
	idbaseconhecimento number not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventoconhecimento),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idbaseconhecimento) REFERENCES baseconhecimento (idbaseconhecimento)
);

-- FIM - rodrigo.acorse - 14.03.2016

-- INICIO - thyen.chang - 15.03.2016

ALTER TABLE HISTORICOBASECONHECIMENTO ADD TIPODOCUMENTO VARCHAR2(3);

ALTER TABLE HISTORICOBASECONHECIMENTO ADD ERROCONHECIDO VARCHAR2(1);

UPDATE HISTORICOBASECONHECIMENTO SET TIPODOCUMENTO = (CASE WHEN FAQ = 'S' THEN 'F' WHEN ERROCONHECIDO = 'S' THEN 'E' ELSE 'D' END);

ALTER TABLE CONHECIMENTOIC DROP CONSTRAINT FK_REF_CONHIC_BC;

ALTER TABLE CONHECIMENTOLIBERACAO DROP CONSTRAINT FK_REF_CONHLIB_BC;

ALTER TABLE CONHECIMENTOMUDANCA DROP CONSTRAINT FK_REF_CONHMUD_BC;

ALTER TABLE CONHECIMENTOPROBLEMA DROP CONSTRAINT FK_REF_CONHPB_BC;

ALTER TABLE CONHECIMENTOSOLICITACAOSERVICO DROP CONSTRAINT FK_REF_CONHSS_BC;

CREATE TABLE grupoiccalendario (
	idgrupoitemconfiguracao NUMBER(10, 0) NOT NULL
	,idcalendario NUMBER(10, 0) NOT NULL
	,constraint fk_grpiccld_grpic foreign key (idgrupoitemconfiguracao) references grupoitemconfiguracao (idgrupoitemconfiguracao)
	,constraint fk_grpiccld_cld foreign key (idcalendario) references calendario (idcalendario)
);

CREATE TABLE grupoiccacordonivelservico (
	idgrupoitemconfiguracao  NUMBER(10, 0) NOT NULL
	,idacordonivelservico  NUMBER(10, 0) NOT NULL
	,constraint fk_grpicans_grpic foreign key (idgrupoitemconfiguracao) references grupoitemconfiguracao (idgrupoitemconfiguracao)
	,constraint fk_grpicans_ans foreign key (idacordonivelservico) references acordonivelservico (idacordonivelservico)
);

CREATE TABLE iccalendario (
	iditemconfiguracao NUMBER(10, 0) NOT NULL
	,idcalendario NUMBER(10, 0) NOT NULL
	,constraint fk_iccld_grpic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao)
	,constraint fk_iccld_cld foreign key (idcalendario) references calendario (idcalendario)
);

CREATE TABLE iccacordonivelservico (
	iditemconfiguracao  NUMBER(10, 0) NOT NULL
	,idacordonivelservico  NUMBER(10, 0) NOT NULL
	,constraint fk_icans_grpic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao)
	,constraint fk_icans_ans foreign key (idacordonivelservico) references acordonivelservico (idacordonivelservico)
);

-- FIM - thyen.chang - 15.03.2016

-- INICIO - gustavo.gomes - 14.03.2016

CREATE TABLE ocorrenciaservicodemanda(
	idocorrenciaservicodemanda NUMBER(24,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nome VARCHAR2(255) NOT NULL,
	valor VARCHAR2(255) NOT NULL,
	PRIMARY KEY (idocorrenciaservicodemanda),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)

);

CREATE TABLE ocorrenciaservicocapacidade(
	idocorrenciaservicocapacidade NUMBER(24,0) NOT NULL,
	idocorrenciaservico NUMBER(24,0) NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nome VARCHAR2(255) NOT NULL,
	valor VARCHAR2(255) NOT NULL,
	PRIMARY KEY (idocorrenciaservicocapacidade),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)

);

-- FIM - gustavo.gomes - 14.03.2016

-- INCIO - douglas.japiassu - 21.03.2016

alter table situacaoservico add ativo integer default 2 not null;

update situacaoservico set ativo = (case when (upper(nomesituacaoservico) = upper('ativo') or upper(nomesituacaoservico) = upper('active')) then 1 else 2 end);

update menu set datafim = systimestamp where nome = '$menu.nome.ligacoesExternas';

update menu set datafim = systimestamp where nome in ('$menu.nome.pesquisaFAQ', '$menu.nome.pesquisaErroConhecido');

alter table requisicaomudanca add votacaorequisicaoaprovadaaux char(1);

-- FIM - douglas.japiassu - 21.03.2016

-- INICIO - joao.morais - 22/03/2016

alter table planocontinuidade add descricao_temp clob default '';
UPDATE planocontinuidade SET descricao_temp = descricao;
alter table planocontinuidade drop column descricao;
alter table planocontinuidade rename column descricao_temp to descricao;


-- FIM - joao.morais - 22/03/2016

-- INCIO - thyen.chang - 22.03.2016

ALTER TABLE auditoriaitemconfig ADD idtipoitemconfiguracao NUMBER;

-- FIM - thyen.chang - 22.03.2016

-- INICIO - [euler.ramos] - 22.03.2016
-- Modelos e-mail para Fluxo de Procedimento

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedure Started - Number: ${IDSOLICITACAOSERVICO}', 
'COMMUNICATION<br /><br />Please be advised that started the ${IDSOLICITACAOSERVICO} continuity procedure to solve the ${IDSOLICITACAORELACIONADA} critic icident, <br />as the data below:<br /><br />Number: <strong>${IDSOLICITACAOSERVICO}</strong><br />Procedure: <strong>${SERVICO}</strong><br />Date/Hour: <strong>${DATAHORASOLICITACAO}</strong><br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Best regards,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'startedContinuityPr');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedure executed - Number: ${IDSOLICITACAOSERVICO}', 
'COMMUNICATION<br /><br />Please be advised that the ${IDSOLICITACAOSERVICO} continuity procedure it was executed,<br />as the data below:<br /><br />Number: ${IDSOLICITACAOSERVICO}<br />Procedure: ${SERVICO}<br />Date/Hour: ${DATAHORASOLICITACAO}<br />Critic Icident: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Best regards,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'executedContinuityPr');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Continuty Procedure it was restarted - Number: ${IDSOLICITACAOSERVICO}', 
'Exception<br /><br />Please be advised that the ${IDSOLICITACAOSERVICO} continuity procedure failed and it was restarted,<br />as the data below:<br /><br />Number: ${IDSOLICITACAOSERVICO}<br />Procedure: ${SERVICO}<br />Date/Hour: ${DATAHORASOLICITACAO}<br />Critic Icident: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Best regards,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'failProcedureCont');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Continuty Procedure it was finished - Number: ${IDSOLICITACAOSERVICO}', 
'COMMUNICATION<br /><br />Please be advised that the ${IDSOLICITACAOSERVICO} continuity procedure it was finished,<br />as the data below:<br /><br />Number: ${IDSOLICITACAOSERVICO}<br />Procedure: ${SERVICO}<br />Date/Hour: ${DATAHORASOLICITACAO}<br />Critic Icident: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Best regards,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'finishContinuityProc');

alter table modelosemails modify identificador varchar(50);

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedimento iniciado - Nmero: ${IDSOLICITACAOSERVICO}', 
'AVISO<br /><br />Por favor, esteja ciente que foi iniciado o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} afim de resolver o incidente crtico ${IDSOLICITACAORELACIONADA}, <br />conforme os dados abaixo:<br /><br />Nmero: <strong>${IDSOLICITACAOSERVICO}</strong><br />Procedimento: <strong>${SERVICO}</strong><br />Data/Hora: <strong>${DATAHORASOLICITACAO}</strong><br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeIniciado');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedimento executado - Nmero: ${IDSOLICITACAOSERVICO}', 
'AVISO<br /><br />Por favor, esteja ciente que o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} foi executado,<br />conforme os dados abaixo:<br /><br />Nmero: ${IDSOLICITACAOSERVICO}<br />Procedimento: ${SERVICO}<br />Data/Hora: ${DATAHORASOLICITACAO}<br />Incidente Crtico: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Atenciosamente,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeExecutado');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedimento de Continuidade foi reiniciado - Nmero: ${IDSOLICITACAOSERVICO}', 
'Exceo<br /><br />Por favor, esteja ciente que o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} falhou e foi reiniciado,<br />conforme os dados abaixo:<br /><br />Nmero: ${IDSOLICITACAOSERVICO}<br />Procedimento: ${SERVICO}<br />Data/Hora: ${DATAHORASOLICITACAO}<br />Incidente Crtico: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Atenciosamente,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeReiniciado');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ((select max(idmodeloemail) + 1 from modelosemails), 'CITSMART - Procedimento de Continuidade foi finalizado - Nmero: ${IDSOLICITACAOSERVICO}', 
'AVISO<br /><br />Por favor, esteja ciente que o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} foi finalizado,<br />conforme os dados abaixo:<br /><br />Nmero: ${IDSOLICITACAOSERVICO}<br />Procedimento: ${SERVICO}<br />Data/Hora: ${DATAHORASOLICITACAO}<br />Incidente Crtico: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Atenciosamente,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeFinalizado');

CREATE TABLE liberacaosolicitacaoservico 
( 
  idliberacaosolicitacaoservico NUMBER(24,0) NOT NULL, 
  idliberacao NUMBER(10,0) NOT NULL, 
  idsolicitacaoservico NUMBER(24,0) NOT NULL, 
  datafim date, 
  PRIMARY KEY (idliberacaosolicitacaoservico), 
  FOREIGN KEY (idliberacao) REFERENCES liberacao (idliberacao), 
  FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico) 
);

-- FIM [euler.ramos] - 22.03.2016

-- INCIO - deborah.ferreira - 22.03.2016

CREATE TABLE invocacao(
	idinvocacao NUMBER(24,0) NOT NULL,
	idcontinuidade NUMBER(24,0) NOT NULL,
	idcliente NUMBER(10,0),
	idsolicitacaorelacionado NUMBER(24,0),
	idsolicitacao NUMBER(24,0) NOT NULL,
	nomeservico VARCHAR2(255),
	idgrupoexecutor NUMBER(10,0),
	idgrupoaprovador NUMBER(10,0),
	idresponsavel NUMBER(10,0),
	situacao VARCHAR2(20),
	PRIMARY KEY (idinvocacao),
	CONSTRAINT fk_invocacao_continuidade FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade),
	CONSTRAINT fk_invocacao_cliente FOREIGN KEY (idcliente) REFERENCES clientes (idcliente),
	CONSTRAINT fk_invocacao_solicitacao FOREIGN KEY (idsolicitacao) REFERENCES solicitacaoservico (idsolicitacaoservico),
	CONSTRAINT fk_invocacao_solicitacao_rel FOREIGN KEY (idsolicitacaorelacionado) REFERENCES solicitacaoservico (idsolicitacaoservico),
	CONSTRAINT fk_invocacao_grupo_ex FOREIGN KEY (idgrupoexecutor) REFERENCES grupo (idgrupo),
	CONSTRAINT fk_invocacao_grupo_ap FOREIGN KEY (idgrupoaprovador) REFERENCES grupo (idgrupo),
	CONSTRAINT fk_invocacao_usuario FOREIGN KEY (idresponsavel) REFERENCES usuario (idusuario)
);

ALTER TABLE auditoriacontinvocacao RENAME COLUMN nomegrupoatual TO nomegrupoexecutor;
ALTER TABLE auditoriacontinvocacao ADD nomegrupoaprovador VARCHAR(255);
ALTER TABLE auditoriacontinvocacao MODIFY nomeresponsavel VARCHAR(256) NULL;

ALTER TABLE planocontinuidade ADD versao DOUBLE PRECISION DEFAULT 1.0 NOT NULL;
ALTER TABLE auditoriaplanocontinuidade ADD versao DOUBLE PRECISION;

ALTER TABLE acordonivelservico ADD sazonalidade VARCHAR2(255);
-- FIM - deborah.ferreira - 22.03.2016

-- INCIO - [douglas.japiassu] - 28.03.2016

ALTER TABLE escalonamento ADD tipodataescalonamento integer;
UPDATE escalonamento SET tipodataescalonamento = (select re.tipodataescalonamento from regraescalonamento re where re.idregraescalonamento = escalonamento.idregraescalonamento);
ALTER TABLE regraescalonamento ADD tipodatanotificacaoemail integer;
UPDATE regraescalonamento SET tipodatanotificacaoemail = 1;
ALTER TABLE regraescalonamento ADD tipodataproblema integer;
UPDATE regraescalonamento SET tipodatanotificacaoemail = 2;

-- FIM - [douglas.japiassu] - 28.03.2016 

-- INCIO - [gilmar.junior] - 28.03.2016 
CREATE TABLE baseconhecimentosla (
    idbaseconhecimentosla number not null,
    idbaseconhecimento number not null,
    idacordonivelservico number not null,
    datainicio date not null,
    datafim date,
    PRIMARY KEY (idbaseconhecimentosla),
    FOREIGN KEY (idbaseconhecimento) REFERENCES baseconhecimento (idbaseconhecimento),
    FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico)
);

-- FIM - [gilmar.junior] - 28.03.2016 

-- INCIO - [douglas.japiassu] - 30.03.2016

CREATE TABLE permissaoacessopagina (
	idperfilacesso integer not null,
	caminho varchar(255) not null,
	pesquisa char(1),
	grava char(1),
	deleta char(1),
	tipoperfilacesso smallint,
	ordem smallint,
	PRIMARY KEY (idperfilacesso,caminho),
	CONSTRAINT fk_perfilacesso FOREIGN KEY (idperfilacesso) REFERENCES PERFILACESSO (idperfil)
);

CREATE TABLE servicocontratoans (
	idservicocontratoans integer not null,
	idservicocontrato number(19,0)  not null,
	idacordonivelservico number(10,0) not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idservicocontratoans),
	CONSTRAINT fk_servicocontrato FOREIGN KEY (idservicocontrato) REFERENCES servicocontrato (idservicocontrato),
	CONSTRAINT fk_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico)
);

-- FIM - [douglas.japiassu] - 30.03.2016 

-- INCIO - [pedro.francisco] - 29.03.2016

ALTER TABLE modelosemails ADD idprocesso integer;

-- FIM - [pedro.francisco] - 29.03.2016

-- INCIO - [rodrigo.acorse] - 01.04.2016

alter table itemconfiguracao add custohoraindisponibilidade decimal(10,2);
alter table historicoic add custohoraindisponibilidade decimal(10,2);

-- FIM - [rodrigo.acorse] - 01.04.2016

-- INCIO - [deborah.ferreira] - 02.04.2016

ALTER TABLE servicocontrato ADD custohoraindisponibilidade DECIMAL(10,2);

CREATE TABLE servicocontratocalendario (
	idservicocontratocalendario NUMBER(10,0) NOT NULL,
	idservicocontrato NUMBER(19,0) NOT NULL,
	idcalendario NUMBER(10,0) NOT NULL,
	datainicio DATE NOT NULL,
	datafim DATE,
	PRIMARY KEY (idservicocontratocalendario),
	CONSTRAINT fk_contratocal_servicocontrato FOREIGN KEY (idservicocontrato) REFERENCES servicocontrato (idservicocontrato),
	CONSTRAINT fk_contratocal_calendario FOREIGN KEY (idcalendario) REFERENCES calendario (idcalendario)
);

ALTER TABLE jornadatrabalho ADD tipohorario INTEGER DEFAULT 1 NOT NULL;

-- FIM - [deborah.ferreira] - 02.04.2016

-- INICIO - thyen.chang - 02.04.2016

CREATE TABLE grupodisponibilidade (
	idgrupodisponibilidade NUMBER NOT NULL
	, nome VARCHAR(255) NOT NULL
	, acordodisponibilidade FLOAT NOT NULL
	, valor FLOAT NOT NULL
	, idcalendario NUMBER NOT NULL
	, datafim DATE
	, PRIMARY KEY (idgrupodisponibilidade)
	, CONSTRAINT fk_grpdisp_calend FOREIGN KEY (idcalendario) REFERENCES calendario (idcalendario)
);

CREATE TABLE grupodisponibilidadeic (
	idgrupodisponibilidadeic NUMBER NOT NULL
	, idgrupodisponibilidade NUMBER NOT NULL
	, iditemconfiguracao NUMBER NOT NULL
	, PRIMARY KEY (idgrupodisponibilidadeic)
	, CONSTRAINT fk_grpdispic_grpdisp FOREIGN KEY (idgrupodisponibilidade) REFERENCES grupodisponibilidade (idgrupodisponibilidade)
	, CONSTRAINT fk_grpdispic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES itemconfiguracao (iditemconfiguracao)
);

CREATE TABLE grupoicvalorindisp (
	idgrupoicvalorindisp NUMBER NOT NULL
	, idgrupoitemconfiguracao NUMBER NOT NULL
	, valor FLOAT NOT NULL
	, PRIMARY KEY (idgrupoicvalorindisp)
);

ALTER TABLE grupoiccalendario DROP CONSTRAINT fk_grpiccld_grpic;

ALTER TABLE grupoiccacordonivelservico DROP CONSTRAINT fk_grpicans_grpic;

-- FIM - thyen.chang - 02.04.2016

-- INCIO - gilmar.junior - 06.04.2016
ALTER TABLE clientes MODIFY cpfcnpj varchar2(255) default null;

ALTER TABLE dadosbancariosintegrante modify cpf varchar2(255) default null;

ALTER TABLE empregados MODIFY cpf varchar2(255) default null;

ALTER TABLE fornecedor MODIFY cnpj varchar2(255) default null;

ALTER TABLE pessoa MODIFY cpf varchar2(255) default null;

ALTER TABLE rh_candidato MODIFY cpf varchar2(255) default null;

ALTER TABLE rh_curriculo MODIFY cpf varchar2(255) default null;

ALTER TABLE rh_funcionario MODIFY cpf varchar2(255) default null;
-- FIM - gilmar.junior - 06.04.2016

-- INICIO - gustavo.gomes - 07.04.2016
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.incidente' WHERE idmodulosistema = 1;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.requisicao' WHERE idmodulosistema = 2;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.mudanca' WHERE idmodulosistema = 3;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.evento' WHERE idmodulosistema = 4;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.continuidade' WHERE idmodulosistema = 5;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.conhecimento' WHERE idmodulosistema = 6;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.sla' WHERE idmodulosistema = 7;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.problema' WHERE idmodulosistema = 8;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.capacidade' WHERE idmodulosistema = 9;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.portfolio' WHERE idmodulosistema = 10;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.aivosconf' WHERE idmodulosistema = 11;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.gerencservicos' WHERE idmodulosistema = 12;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.liberacao' WHERE idmodulosistema = 13;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.disponibilidade' WHERE idmodulosistema = 14;
-- FIM - gustavo.gomes - 07.04.2016

-- INCIO - gilmar.junior - 07.04.2016
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.incidentesRequisicoes' WHERE identificacao LIKE 'INCREQ001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.ativosConfiguracao' WHERE identificacao LIKE 'ATVCFG001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.baseConhecimento' WHERE identificacao LIKE 'BASECG001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.niveisServico' WHERE identificacao LIKE 'NIVELS001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.problemas' WHERE identificacao LIKE 'PROBL001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.mudancas' WHERE identificacao LIKE 'MUDAN001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.liberacao' WHERE identificacao LIKE 'LIBER001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.catalogoServicos' WHERE identificacao LIKE 'CATAL001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.projetos' WHERE identificacao LIKE 'PROJET001';
-- FIM - gilmar.junior - 07.04.2016


-- INCIO - gilmar.junior - 12.04.2016
UPDATE programacaoatividade SET tipoagendamento = '1' WHERE tipoagendamento LIKE 'D';
UPDATE programacaoatividade SET tipoagendamento = '2' WHERE tipoagendamento LIKE 'S';
UPDATE programacaoatividade SET tipoagendamento = '3' WHERE tipoagendamento LIKE 'M';
UPDATE programacaoatividade SET tipoagendamento = '4' WHERE tipoagendamento LIKE 'U';
-- FIM - gilmar.junior - 12.04.2016

-- INCIO - joao.morais - 13.04.2016

ALTER TABLE controlecontrato MODIFY datainicio DATE DEFAULT NULL;

-- FIM - joao.morais - 13.04.2016

-- INCIO - gustavo.gomes - 13.04.2016
ALTER TABLE regraescalonamento MODIFY tipodataescalonamento NULL;
-- FIM - joao.morais - 30.05.2016


-- INCIO - joao.morais - 30.05.2016

alter table evm_acao_incidenterequisicao add idcategoriaservico NUMBER(10,0) null;
alter table evm_acao_incidenterequisicao add idtipocatalogoservicosoli varchar(1) null;
alter table evm_acao_incidenterequisicao add idServicoNegocioTecBusc NUMBER(24,0) null;
alter table evm_acao_incidenterequisicao add utilizaCategoriaServico varchar(1) null;

update menu set datafim = systimestamp 
where nome in(
	'$menu.nome.gerenciaBaseConhecimento',
	'$menu.nome.gerenciaConfiguracaoIncidenteRequisicoes');

-- FIM - joao.morais - 30.05.2016

-- INCIO - deborah.ferreira - 13.06.2016

ALTER TABLE permissaoacessopagina ADD tipoperfilacesso smallint;
ALTER TABLE permissaoacessopagina ADD ordem smallint;
UPDATE permissaoacessopagina SET tipoperfilacesso = 1 WHERE tipoperfilacesso IS NULL AND caminho LIKE '%gerenciamentoContinuidade%';

-- FIM - deborah.ferreira - 13.06.2016
	
-- INICIO - joao.morais - 16.06.2016

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacao.jsp', 'S', 'S', 'S', 1, 1);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacaoPolitica.jsp', 'S', 'S', 'S', 1, 2);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacaoEscopo.jsp', 'S', 'S', 'S', 1, 3);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacaoProjeto.jsp', 'S', 'S', 'S', 1, 4);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategia.jsp', 'S', 'S', 'S', 1, 5);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaFuncoesVitais.jsp', 'S', 'S', 'S', 1, 6);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaImpactoNegocio.jsp', 'S', 'S', 'S', 1, 7);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaAvaliacaoRiscos.jsp', 'S', 'S', 'S', 1, 8);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaEstrategiaContinuidade.jsp', 'S', 'S', 'S', 1, 9);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacao.jsp', 'S', 'S', 'S', 1, 10);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacaoPlanosContinuidade.jsp', 'S', 'S', 'S', 1, 11);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacaoPlanejamentoOrganizacional.jsp', 'S', 'S', 'S', 1, 12);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacaoEstrategiaTestes.jsp', 'S', 'S', 'S', 1, 13);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinua.jsp', 'S', 'S', 'S', 1, 14);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaConscientizacao.jsp', 'S', 'S', 'S', 1, 15);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaRevisaoAuditoria.jsp', 'S', 'S', 'S', 1, 16);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaTestes.jsp', 'S', 'S', 'S', 1, 17);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaInvocacao.jsp', 'S', 'S', 'S', 1, 18);

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroPortfolio/gerenciamentoPortfolioCadastroPortfolio.jsp', 'S', 'S', 'S', 2, 0);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoNegocio/gerenciamentoPortfolioServicoNegocio.jsp', 'S', 'S', 'S', 2, 1);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoServicoNegocio/gerenciamentoPortfolioInfoServicoNegocio.jsp', 'S', 'S', 'S', 2, 2);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoNegocio/gerenciamentoPortfolioCadastroServicoNegocio.jsp', 'S', 'S', 'S', 2, 3);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioRNS/gerenciamentoPortfolioRNS.jsp', 'S', 'S', 'S', 2, 4);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAtributosFinanceiros/gerenciamentoPortfolioAtributosFinanceiros.jsp', 'S', 'S', 'S', 2, 5);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCasoNegocio/gerenciamentoPortfolioCasoNegocio.jsp', 'S', 'S', 'S', 2, 6);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoNegocio/gerenciamentoPortfolioMapaDesenhoNegocio.jsp', 'S', 'S', 'S', 2, 7);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioProcessoNegocio/gerenciamentoPortfolioProcessoNegocio.jsp', 'S', 'S', 'S', 2, 8);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoio/gerenciamentoPortfolioServicoApoio.jsp', 'S', 'S', 'S', 2, 9);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioDonoNegocio/gerenciamentoPortfolioDonoNegocio.jsp', 'S', 'S', 'S', 2, 10);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioBusinessUser/gerenciamentoPortfolioBusinessUser.jsp', 'S', 'S', 'S', 2, 11);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoRequisicaoNegocio/gerenciamentoPortfolioServicoRequisicaoNegocio.jsp', 'S', 'S', 'S', 2, 12);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAplicacoes/gerenciamentoPortfolioAplicacoes.jsp', 'S', 'S', 'S', 2, 13);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioEsquemaDados/gerenciamentoPortfolioEsquemaDados.jsp', 'S', 'S', 'S', 2, 14);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoIncidenteNegocio/gerenciamentoPortfolioServicoIncidenteNegocio.jsp', 'S', 'S', 'S', 2, 15);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoProcedimento/gerenciamentoPortfolioServicoProcedimento.jsp', 'S', 'S', 'S', 2, 16);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratos/gerenciamentoPortfolioContratos.jsp', 'S', 'S', 'S', 2, 17);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioProprietarios/gerenciamentoPortfolioProprietarios.jsp', 'S', 'S', 'S', 2, 18);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioConhecimento/gerenciamentoPortfolioConhecimento.jsp', 'S', 'S', 'S', 2, 19);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioHabilidade/gerenciamentoPortfolioHabilidade.jsp', 'S', 'S', 'S', 2, 20);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioIndicadorCapacidade/gerenciamentoPortfolioIndicadorCapacidade.jsp', 'S', 'S', 'S', 2, 21);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAtributoDemanda/gerenciamentoPortfolioAtributoDemanda.jsp', 'S', 'S', 'S', 2, 22);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioOcorrenciasServico/gerenciamentoPortfolioOcorrenciasServico.jsp', 'S', 'S', 'S', 2, 23);

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoServicoApoio/gerenciamentoPortfolioInfoServicoApoio.jsp', 'S', 'S', 'S', 2, 24);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/gerenciamentoPortfolioCadastroServicoApoio.jsp', 'S', 'S', 'S', 2, 25);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoApoio/gerenciamentoPortfolioMapaDesenhoApoio.jsp', 'S', 'S', 'S', 2, 26);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoioApoio/gerenciamentoPortfolioServicoApoioApoio.jsp', 'S', 'S', 'S', 2, 27);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoRequisicaoApoio/gerenciamentoPortfolioServicoRequisicaoApoio.jsp', 'S', 'S', 'S', 2, 28);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoIncidenteApoio/gerenciamentoPortfolioServicoIncidenteApoio.jsp', 'S', 'S', 'S', 2, 29);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosApoio/gerenciamentoPortfolioContratosApoio.jsp', 'S', 'S', 'S', 2, 30);

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoContrato/gerenciamentoPortfolioInfoContrato.jsp', 'S', 'S', 'S', 2, 31);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosDetalhes/gerenciamentoPortfolioContratosDetalhes.jsp', 'S', 'S', 'S', 2, 32);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoRequisicao/gerenciamentoPortfolioContratosServicoRequisicao.jsp', 'S', 'S', 'S', 2, 33);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoIncidente/gerenciamentoPortfolioContratosServicoIncidente.jsp', 'S', 'S', 'S', 2, 34);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoProcedimento/gerenciamentoPortfolioContratosServicoProcedimento.jsp', 'S', 'S', 'S', 2, 35);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosCustoDisponibilidade/gerenciamentoPortfolioContratosCustoDisponibilidade.jsp', 'S', 'S', 'S', 2, 36);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoContratoANS/gerenciamentoPortfolioServicoContratoANS.jsp', 'S', 'S', 'S', 2, 37);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosCalendario/gerenciamentoPortfolioContratosCalendario.jsp', 'S', 'S', 'S', 2, 38);

-- FIM - joao.morais - 16.06.2016


-- INICIO - euler.ramos - 22.06.2016

alter table unidade add idcalendario NUMBER(10,0);

-- FIM - euler.ramos - 22.06.2016

-- INICIO - deborah.ferreira - 06.07.2016

DELETE FROM menu WHERE nome = '$menu.nome.cargaCatalogoServico';
DELETE FROM menu WHERE nome = '$menu.nome.tipoSolicitacaoServico';

-- FIM - deborah.ferreira - 06.07.2016

-- INCIO - rodrigo.acorse - 15.06.2016

ALTER TABLE evm_gerenciado_inventory ADD autocorrecao CHAR(1 CHAR);
ALTER TABLE evm_gerenciado_inventory ADD autocorrecaoquantidade NUMBER(11,0);

ALTER TABLE evm_gerenciado_nagios ADD autocorrecao CHAR(1 CHAR);
ALTER TABLE evm_gerenciado_nagios ADD autocorrecaoquantidade NUMBER(11,0);

ALTER TABLE evm_gerenciado_zabbix ADD autocorrecao CHAR(1 CHAR);
ALTER TABLE evm_gerenciado_zabbix ADD autocorrecaoquantidade NUMBER(11,0);

-- FIM - rodrigo.acorse - 15.06.2016

-- INCIO - rodrigo.acorse - 01.07.2016

ALTER TABLE evm_inventory_configuracao ADD ignoraricsinventariados char(1);
ALTER TABLE evm_inventory_configuracao ADD tempoignorarics integer;
ALTER TABLE evm_inventory_configuracao ADD tipoignorarics integer;

-- FIM - rodrigo.acorse - 01.07.2016

-- INICIO - deborah.ferreira - 25.07.2016

UPDATE categoriaservico SET tipocategoria = 'I' WHERE tipocategoria = 'R';

-- FIM - deborah.ferreira - 25.07.2016
-- INICIO - gilmar.junior - 02.08.2016
DROP TRIGGER trg_slareqsla_dataultmo_bf_ins;

CREATE OR REPLACE TRIGGER trg_slareqsla_dataultmo_bf_ins
BEFORE INSERT ON slarequisitosla
FOR EACH ROW
BEGIN
    SELECT sysdate INTO :new.dataultmodificacao FROM dual; 
END;
-- FIM - gilmar.junior - 02.08.2016

-- INCIO - rodrigo.acorse - 25.07.2016

CREATE TABLE aberturaautomaticaviaemail
(
	idconfigaberturaautomatica NUMBER(24,0) NOT NULL,
	nome VARCHAR(255) NOT NULL,
	idacao NUMBER(24,0) NOT NULL,
	emailservidorentrada VARCHAR(255),
	emailusuario VARCHAR(255),
	emailsenha VARCHAR(255),
	emailprovedor VARCHAR(255),
	emailporta NUMBER,
	emailpastacaixa VARCHAR(255),
	status CHAR(1),
	datainicio DATE NOT NULL,
	datafim DATE,
	PRIMARY KEY (idconfigaberturaautomatica),
	FOREIGN KEY (idacao) REFERENCES evm_acao (idacao)
);

-- FIM - rodrigo.acorse - 25.07.2016

-- INICIO - deborah.ferreira - 08.08.2016

UPDATE permissaoAcessoPagina 
SET ordem = 0 
WHERE 
	caminho = '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroPortfolio/gerenciamentoPortfolioCadastroPortfolio.jsp' 
	AND NOT EXISTS (SELECT * FROM permissaoAcessoPagina WHERE ordem = 0);

INSERT INTO permissaoAcessoPagina 
	SELECT 
		idperfilacesso,
		'/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoNegocio/gerenciamentoPortfolioServicoNegocio.jsp',
		pesquisa, 
		grava, 
		deleta, 
		tipoperfilacesso, 
		1 
	FROM permissaoAcessoPagina 
	WHERE ordem = 2 AND tipoperfilacesso = 2 AND idperfilacesso <> 1;

-- FIM - deborah.ferreira - 08.08.2016

-- INICIO - deborah.ferreira - 16.09.2016

delete from menu where nome = '$menu.nome.comando';
delete from menu where nome = '$menu.nome.comandoSistemaOperacional';
delete from menu where nome = '$menu.nome.sistemaOperacional';
delete from menu where nome = '$gerenciamento.relatorio.pentaho.menu';
delete from menu where nome = '$relatorioKpi.relatorioKpi';
delete from menu where nome = '$relatorioKpi.titulo';
delete from menu where nome = '$relatorioEficaciaDasNasEstimativasdeServico.titulo';
delete from menu where nome = '$relatorioIncidentesNaoResolvidos.titulo';
delete from menu where nome = '$relatorioDocumentacaoDeFuncionalidadesNovasOuAlteradasNoPeriodo.title';
delete from menu where nome = '$relatorioEficaciaTeste.titulo';
delete from menu where nome = '$relatorioQI03QI04ProgramacaoDefensivaEficacia';
delete from menu where nome = '$menu.nome.catalogoServicos';
delete from menu where nome = '$menu.nome.mapaDesenhoServico';
delete from menu where nome = '$menu.nome.mapaDesenhoCatalogoNegocio';
delete from menu where nome = '$menu.nome.compras';
delete from menu where nome = '$menu.nome.categoriaProduto';
delete from menu where nome = '$menu.nome.unidadeMedida';
delete from menu where nome = '$menu.nome.tipoProduto';
delete from menu where nome = '$menu.nome.produto';
delete from menu where nome = '$menu.nome.justificativaParecer';
delete from menu where nome = '$menu.nome.cotacao';
delete from menu where nome = '$menu.nome.criterioAvaliacao';
delete from menu where nome = '$menu.nome.marca';
delete from menu where nome = '$menu.nome.avaliacaoFornecedor';
delete from menu where nome = '$menu.nome.nivelAutoridade';
delete from menu where nome = '$menu.nome.projeto';
delete from menu where nome = '$menu.nome.limiteAprovacao';
delete from menu where nome = '$menu.nome.centroResultado';
delete from menu where nome = '$menu.nome.delegacaoCentroResultado';
delete from menu where nome = '$menu.nome.delegacaoCentroResultadoResp';
delete from menu where nome = '$menu.nome.simulacaoAlcada';
delete from menu where nome = '$menu.nome.qualificacaoFornecedor';
delete from menu where nome = '$menu.nome.recursosHumanos';
delete from menu where nome = '$menu.nome.cadastrosRH.idioma';
delete from menu where nome = '$menu.nome.pesquisaCurrriculo';
delete from menu where nome = '$menu.nome.viagem';
delete from menu where nome = '$menu.nome.tipoMovimFinanceiraViagem';
delete from menu where nome = '$menu.nome.formaPagamento';
delete from menu where nome = '$menu.nome.RemarcacaoViagem';
delete from menu where nome = '$menu.adiantamentosAFazer';
delete from menu where nome = '$menu.acompanhamentoPrestacaoContas';
delete from menu where nome = '$menu.solicitacaoReembolsoPrestacao';
delete from menu where nome = '$menu.nome.bi';
delete from menu where nome = '$menu.nome.bi.exportacaoManual';
delete from menu where nome = '$menu.nome.bi.painelControle';
delete from menu where nome = '$menu.nome.bi.deParaServicosBI';
delete from menu where nome = '$menu.nome.bi.servicoCorporeBI';

-- FIM - deborah.ferreira - 16.09.2016