--INCIO - [rodrigo.acorse] - 21/01/2015

alter table evm_gerente add urgenciaup char(1) null;
alter table evm_gerente add urgenciadown char(1) null;
alter table evm_gerente add impactoup char(1) null;
alter table evm_gerente add impactodown char(1) null;

alter table evm_gerenciado_inventory add urgenciainformation char(1) null;
alter table evm_gerenciado_inventory add impactoinformation char(1) null;
alter table evm_gerenciado_inventory add urgenciawarning char(1) null;
alter table evm_gerenciado_inventory add impactowarning char(1) null;
alter table evm_gerenciado_inventory add urgenciaexception char(1) null;
alter table evm_gerenciado_inventory add impactoexception char(1) null;

alter table evm_gerenciado_nagios add urgenciainformation char(1) null;
alter table evm_gerenciado_nagios add impactoinformation char(1) null;
alter table evm_gerenciado_nagios add urgenciawarning char(1) null;
alter table evm_gerenciado_nagios add impactowarning char(1) null;
alter table evm_gerenciado_nagios add urgenciaexception char(1) null;
alter table evm_gerenciado_nagios add impactoexception char(1) null;

alter table evm_gerenciado_zabbix add urgenciainformation char(1) null;
alter table evm_gerenciado_zabbix add impactoinformation char(1) null;
alter table evm_gerenciado_zabbix add urgenciawarning char(1) null;
alter table evm_gerenciado_zabbix add impactowarning char(1) null;
alter table evm_gerenciado_zabbix add urgenciaexception char(1) null;
alter table evm_gerenciado_zabbix add impactoexception char(1) null;

alter table evm_linha_g_g_nagios add urgenciaup char(1) null;
alter table evm_linha_g_g_nagios add urgenciadown char(1) null;
alter table evm_linha_g_g_nagios add impactoup char(1) null;
alter table evm_linha_g_g_nagios add impactodown char(1) null;

alter table evm_linha_g_g_nagios add urgenciainformation char(1) null;
alter table evm_linha_g_g_nagios add impactoinformation char(1) null;
alter table evm_linha_g_g_nagios add urgenciawarning char(1) null;
alter table evm_linha_g_g_nagios add impactowarning char(1) null;
alter table evm_linha_g_g_nagios add urgenciaexception char(1) null;
alter table evm_linha_g_g_nagios add impactoexception char(1) null;

alter table evm_gerente_correlacao add urgenciainformation char(1) null;
alter table evm_gerente_correlacao add impactoinformation char(1) null;
alter table evm_gerente_correlacao add urgenciawarning char(1) null;
alter table evm_gerente_correlacao add impactowarning char(1) null;
alter table evm_gerente_correlacao add urgenciaexception char(1) null;
alter table evm_gerente_correlacao add impactoexception char(1) null;

-- FIM - [rodrigo.acorse] - 21/01/2015

-- INCIO - [deborah.ferreira] - 21/01/2016

CREATE TABLE ocorrenciaservico (
	idocorrenciaservico INT8 NOT NULL,
	idservico INT8 NOT NULL,
	nomeusuario VARCHAR(255) NOT NULL,
	datacriacao TIMESTAMP NOT NULL,
	categoriaocorrencia VARCHAR(10)  NOT NULL,
	tipoocorrencia VARCHAR(10) NOT NULL,
	descricaoocorrencia TEXT,	
	PRIMARY KEY (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicodetalhes
(
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nomeservico VARCHAR(255) NOT NULL,
	nomecategoriaservico VARCHAR(255) NOT NULL,
	faseservico VARCHAR(255) NOT NULL,
	tipodeinvestimento VARCHAR(255),
	nometiposervico VARCHAR(255) NULL,
	detalheservico TEXT,
	processodeiniciacao VARCHAR(255),
	datainicio DATE NOT NULL,
	statusservico VARCHAR(255) NOT NULL,
	nomeimportancianegocio VARCHAR(255),
	nomelocalexecucaoservico VARCHAR(255),
	objetivo TEXT,
	valoresdoservico TEXT,
	nometemplateservico VARCHAR(200),
	criticidadeservico INT4,
	demandaservico INT4,
	retornofinanceiroservico INT4,
	deleted VARCHAR(1) DEFAULT 'N',
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicorequisitosnivelservico (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	datacriacao DATE NOT NULL,
	datainicioservico DATE,
	donodoservico TEXT,
	especificacao TEXT,
	contexto TEXT,
	funcionalidadesessenciais TEXT,
	seguranca TEXT,
	disponibilidade TEXT,
	capacidade TEXT,
	continuidadedonegocio TEXT,
	performancedesempenho TEXT,
	interrupcoesplanejadas TEXT,
	gestaodeincidentes TEXT,
	gestaodeproblemas TEXT,
	gestaodemudancas TEXT,
	conformidadeinterna TEXT,
	conformidadeexterna TEXT,
	datafim DATE,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicocasonegocio (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nomecasonegocio TEXT,
	descricaosumarioexecutivo TEXT,
	descricaocenarios TEXT,
	descricaoproblemaoportunidade TEXT,
	descricaopropostasolucao TEXT,
	descricaoanalisefinanceira TEXT,
	descricaoanaliserisco TEXT,
	descricaostakeholderentidade TEXT,
	descricaoviabilidadetecnica TEXT,
	descricaoconclusao TEXT,
	datafim DATE,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoatributosfinanceiros (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idatributosfinanceiros INT8 NOT NULL,
	categoriaatributosfinanceiros VARCHAR(255) NOT NULL,
	tipoatributosfinanceiros VARCHAR(1) NOT NULL,
	valoratributosfinanceiros FLOAT NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoprocessonegocio (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idprocessonegocio INT4 NOT NULL,
	nomeprocessonegocio VARCHAR(100) NOT NULL,
	nomecliente VARCHAR(255) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicodononegocio (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	iddononegocio INT4 NOT NULL,
	nomedononegocio VARCHAR(256) NOT NULL,
	tipodononegocio INT4 NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicousernegocio (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idusuarionegocio INT4 NOT NULL,
	nomeusuarionegocio VARCHAR(256) NOT NULL,
	tipousuarionegocio INT4 NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicorelacionado (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idservicorelacionado INT8 NOT NULL,
	nomeservicorelacionado VARCHAR(500) NOT NULL,
	faseservicorelacionado VARCHAR(2),
	statusservicorelacionado VARCHAR(5),
	tiposervicorelacionado VARCHAR(1),
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoaplicacao (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idaplicacao INT4 NOT NULL,
	nomeaplicacao VARCHAR(256) NOT NULL,
	nomeresponsavelaplicacao VARCHAR(256),
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicocontrato (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idcontrato INT4 NOT NULL,
    descricaocontrato TEXT NOT NULL,
    clientecontrato VARCHAR(70) NOT NULL,
	fornecedorcontrato VARCHAR(100) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoproprietarios (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idproprietario INT8 NOT NULL,
	nomeproprietario VARCHAR(256) NOT NULL,
	tipoproprietario INT4 NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoesquemadados (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idesquemadados INT8 NOT NULL,
	detalhesesquemadados TEXT NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicoanexos (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idanexo INT4 NOT NULL,
	nomeanexo VARCHAR(255) NOT NULL,
	descricaoanexo VARCHAR(255) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicomapaservico (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	iditemmapaservico INT4 NOT NULL,
	iconeitemmapaservico VARCHAR(256),
	nomeitemmapaservico VARCHAR(500) NOT NULL,
	tipoitemmapaservico CHAR(2) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);
-- FIM - [deborah.ferreira] - 21/01/2016 

-- INCIO [douglas.japiassu] 29.01.2016

create table templateservico (
	idtemplateservico int4 not null,
	identificacao varchar(255) not null,
	nometemplate varchar(200) not null,
	nomeclassedto varchar(255),
	nomeclasseaction varchar(255),
	nomeclasseservico varchar(255),
	urlrecuperacao varchar(255),
	alturadiv integer not null,
	idquestionario int4,
	scriptaposrecuperacao text,
	primary key (idtemplateservico),
	foreign key (idquestionario) references questionario (idquestionario)
);

alter table servico add valoresdoservico text;
alter table servico add idtemplateservico int4;
alter table servico add constraint servico_templateservico_fk foreign key (idtemplateservico) references templateservico (idtemplateservico);

create table servicoquestionario (
	idservicoquestionario bigint not null,
	idquestionario int4 not null,
	idservico bigint not null,
	dataquestionario timestamp not null,
	situacao char(1) not null,
	datahoragrav timestamp not null,
	primary key (idservicoquestionario),
	foreign key (idservico) references servico (idservico),
	foreign key (idquestionario) references questionario (idquestionario)
);
-- FIM [douglas.japiassu] 29.01.2016

-- INCIO [gilmar.junior] 29.01.2016
alter table servico add criticidadeservico int;
alter table servico add demandaservico int;
alter table servico add retornofinanceiroservico int;
-- FIM [gilmar.junior] 29.01.2016

-- INCIO [joao.morais] 02.02.2016
create table habilidade (
	idhabilidade int4 not null,
	nomehabilidade varchar(255) not null,
	descricao varchar(255) not null,
	datahorainicio timestamp not null,
	datahorafim timestamp,
	primary key (idhabilidade)
);

create table vinculohabilidade (
	idvinculocolaborador int4 not null,
	idempregado int4 not null,
	idhabilidade int4 not null,
	dataFim date,
	primary key (idvinculocolaborador),
	constraint fk_habilidadeVinculo foreign key (idhabilidade) references habilidade (idhabilidade),
	constraint fk_empregadoHabilidade foreign key (idempregado) references empregados (idempregado)
);
-- FIM [joao.morais] 02.02.2016

-- INICIO - thyen.chang - 02/02/2016

alter table TIPOFINANCEIROSERVICO add classificacao int;
alter table FINANCEIROSERVICO add classificacao int;

-- FIM - thyen.chang - 02/02-2016

-- INICIO [joao.morais] 10.02.2016
create table HABILIDADESERVICO(
	idhabilidade int4 not null,
	idservico int8 not null,
	idhabilidadevinculo int4 not null,
	datafim Date,
	primary key (idhabilidadevinculo),
	constraint fk_servicohabilidade foreign key (idservico) references servico (idservico)
);
-- FIM - [joao.morais] - 10/02/2016

-- INCIO - [deborah.ferreira] - 10/02/2016

CREATE TABLE auditoriaeventos (
	idauditoriaeventos INT8 NOT NULL,
	nomeusuario VARCHAR(255) NOT NULL,
	datacriacao TIMESTAMP NOT NULL,
	categoria VARCHAR(10)  NOT NULL,
	tipo VARCHAR(10) NOT NULL,
	descricao TEXT,	
	PRIMARY KEY (idauditoriaeventos)
);
-- FIM - [deborah.ferreira] - 10/02/2016

-- INCIO - [pedro.francisco] - 11/02/2016
CREATE TABLE kpiobjetivomonitoramento (
	idkpiobjetivomonitoramento int4 NOT NULL,
	idobjetivomonitoramento int4 NOT NULL,
	kpi varchar(255) NOT NULL,
	criadopor varchar(255) NOT NULL,
	CONSTRAINT kpiobjetivomonitoramento_objetivomonitoramento_FK FOREIGN KEY (idobjetivomonitoramento) REFERENCES objetivomonitoramento(idobjetivomonitoramento) ON DELETE RESTRICT ON UPDATE RESTRICT
);

ALTER TABLE objetivoplanomelhoria ADD idrespobj int4;
ALTER TABLE objetivoplanomelhoria ADD idgruporespobj int4;
ALTER TABLE acaoplanomelhoria ADD idrespacao int4;
ALTER TABLE acaoplanomelhoria ADD idgruporespacao int4;
ALTER TABLE objetivoMonitoramento ADD idrespmon int4;
ALTER TABLE objetivoMonitoramento ADD idgruporespmon int4;
-- FIM - [pedro.francisco] - 11/02/2016

-- INICIO [joao.morais] - 11/02/2016
update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.gerenciaEventos') as tbl) 
where nome = '$menu.nome.evm.acoesAutomaticas' 
or nome = '$menu.nome.evm.ferramentasmonitoracao'
or nome = '$menu.nome.evm.horario'
or nome = '$menu.nome.evm.citsmartInventory'
or nome = '$menu.nome.evm.citsmartevm'
or nome = '$menu.nome.evm.categoriaOcorrencia'
or nome = '$menu.nome.evm.gerenciamentoeventos'
or nome = '$menu.nome.evm.conexoes'
or nome = '$menu.nome.evm.gerente.nagios'
or nome = '$menu.nome.evm.gerente.zabbix'
or nome = '$menu.nome.evm.gerente.inventory'
or nome = '$menu.nome.evm.gerente.correlacao'
or nome = '$menu.nome.evm.gerente.generico.nagios'
or nome = '$menu.nome.evm.acaoAutomatica'
or nome = '$menu.nome.evm.cadAcaoAutoIncReq'
or nome = '$menu.nome.evm.acoesNotificacao'
or nome = '$menu.nome.evm.acoesMudanca'
or nome = 'menu.nome.evm.conexoes'
or nome = '$menu.nome.evm.check'
or nome = '$menu.nome.evm.statusinventory';

update menu set datafim = now() 
where nome in(
	'$menu.nome.evm.acoesAutomaticas',
	'$menu.nome.metaNivelServico',
	'$menu.nome.cadastrosRH',
	'$menu.nome.configuracaoSolicitacaoProduto',
	'$menu.nome.evm.citsmartInventory',
	'$menu.nome.evm.citsmartevm',
	'$menu.nome.evm.conexoes',
	'$menu.nome.pesquisa', 
	'$menu.nome.alcadaCentroResultado',
	'$menu.nome.monitoramento',
	'$menu.nome.monitoramentoNagios',
	'$menu.nome.eventoMonitoramento',
	'$menu.nome.recurso',
	'$menu.nome.disponibilidadeRecurso',
	'$menu.nome.grupoRecursos',
	'$menu.nome.evm.conexoes',
	'$menu.nome.cadastroContratos',
	'$menu.nome.mostraStatusCapturaInventario',
	'$menu.nome.monitoramentoativos');

update menu set ordem = 0 where nome = '$menu.nome.evm.acoesAutomaticas';
update menu set ordem = 1 where nome = '$menu.nome.evm.acaoAutomatica';
update menu set ordem = 2 where nome = '$menu.nome.evm.cadAcaoAutoIncReq';
update menu set ordem = 3 where nome = '$menu.nome.$menu.nome.evm.acoesNotificacao';
update menu set ordem = 4 where nome = '$menu.nome.evm.acoesMudanca';
update menu set ordem = 5 where nome = '$menu.nome.evm.ferramentasmonitoracao';
update menu set ordem = 6 where nome = '$menu.nome.evm.horario';
update menu set ordem = 7 where nome = '$menu.nome.evm.citsmartInventory';
update menu set ordem = 8 where nome = 'menu.nome.evm.conexoes';
update menu set ordem = 9 where nome = '$menu.nome.evm.check';
update menu set ordem = 10 where nome = '$menu.nome.evm.statusinventory';
update menu set ordem = 11 where nome = '$menu.nome.evm.acoesProblema';
update menu set ordem = 12 where nome = '$menu.nome.evm.citsmartevm';
update menu set ordem = 13 where nome = '$menu.nome.evm.conexoes';
update menu set ordem = 14 where nome = '$menu.nome.evm.gerente.nagios';
update menu set ordem = 15 where nome = '$menu.nome.evm.gerente.zabbix';
update menu set ordem = 16 where nome = '$menu.nome.evm.gerente.inventory';
update menu set ordem = 17 where nome = '$menu.nome.evm.gerente.correlacao';
update menu set ordem = 18 where nome = '$menu.nome.evm.gerente.generico.nagios';
update menu set ordem = 19 where nome = '$menu.nome.evm.categoriaOcorrencia';
update menu set ordem = 20 where nome = '$menu.nome.evm.gerenciamentoeventos';
update menu set ordem = 18 where nome = '$menu.nome.evm.trilhaAuditoria';

update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.gerenciaNivelServico') as tbl) 
where nome = '$menu.nome.avaliacaoContrato' 
or nome = '$menu.nome.avaliarSLA'
or nome = '$menu.nome.avaliacaoPorFornecedor'
or nome = '$menu.nome.planoMelhoria'
or nome = '$menu.nome.acordoNivelServico'
or nome = '$menu.nome.metaNivelServico'
or nome = '$menu.nome.tempoAtendimento';

update menu set ordem = 0 where nome = '$menu.nome.metaNivelServico';
update menu set ordem = 1 where nome = '$menu.nome.tempoAtendimento';
update menu set ordem = 2 where nome = '$menu.nome.acordoNivelServico';
update menu set ordem = 3 where nome = '$menu.nome.avaliarSLA';
update menu set ordem = 4 where nome = '$menu.nome.avaliacaoPorFornecedor';
update menu set ordem = 5 where nome = '$menu.nome.avaliacaoContrato';
update menu set ordem = 6 where nome = '$menu.nome.planoMelhoria';

update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.recursosHumanos') as tbl) 
where nome = '$menu.nome.cadastrosRH.idioma' 
or nome = '$menu.nome.pesquisaCurrriculo';

update menu set datafim = now() 
where nome in('$menu.nome.atitudeIndividual',
	'$menu.nome.certificacao',
	'$menu.nome.conhecimento',
	'$menu.nome.curriculo',
	'$menu.nome.curso',
	'$menu.nome.experienciaInformatica',
	'$menu.nome.formacaoAcademica',
	'$menu.nome.habilidade',
	'$menu.nome.horarioTrabalho',
	'$ManualFuncao.Titulo',
	'$menu.nome.justificativaRequisicaoFuncao',
	'$rh.justificativaListaNegra',
	'$menu.nome.experiencia',
	'$menu.nome.atribuicaoRequisicaoFuncao',
	'$menu.nome.comportamentoAtitude',
	'$menu.nome.comportamento',
	'$rh.historicoFuncional',
	'$menu.nome.dicionario');

update menu set ordem = 0 where nome = '$menu.nome.cadastrosRH';
update menu set ordem = 1 where nome = '$menu.nome.cadastrosRH.idioma';
update menu set ordem = 2 where nome = '$menu.nome.pesquisa';
update menu set ordem = 3 where nome = '$menu.nome.pesquisaCurrriculo';

update menu set datafim = now() where link in('/alcadaCentroResultado/alcadaCentroResultado.load');
update menu set idmenupai = (select * from (select idmenu from menu where nome = '$menu.nome.compras') as tbl) 
where nome = '$menu.nome.unidadeMedida' 
or nome = '$menu.nome.categoriaProduto'
or nome = '$menu.nome.tipoProduto'
or nome = '$menu.nome.produto'
or nome = '$menu.nome.justificativaParecer'
or nome = '$menu.nome.cotacao'
or nome = '$menu.nome.criterioAvaliacao'
or nome = '$menu.nome.marca'
or nome = '$menu.nome.avaliacaoFornecedor'
or nome = '$menu.nome.nivelAutoridade'
or nome = '$menu.nome.projeto';

update menu set ordem = 0 where nome = '$menu.nome.categoriaProduto';
update menu set ordem = 1 where nome = '$menu.nome.unidadeMedida';
update menu set ordem = 2 where nome = '$menu.nome.tipoProduto';
update menu set ordem = 3 where nome = '$menu.nome.produto';
update menu set ordem = 4 where nome = '$menu.nome.justificativaParecer';
update menu set ordem = 5 where nome = '$menu.nome.cotacao';
update menu set ordem = 6 where nome = '$menu.nome.criterioAvaliacao';
update menu set ordem = 7 where nome = '$menu.nome.marca';
update menu set ordem = 8 where nome = '$menu.nome.avaliacaoFornecedor';
update menu set ordem = 9 where nome = '$menu.nome.nivelAutoridade';
update menu set ordem = 10 where nome = '$menu.nome.projeto';
update menu set ordem = 11 where nome = '$menu.nome.limiteAprovacao';
update menu set ordem = 12 where nome = '$menu.nome.centroResultado';
update menu set ordem = 13 where nome = '$menu.nome.delegacaoCentroResultado';
update menu set ordem = 14 where nome = '$menu.nome.delegacaoCentroResultadoResp';
update menu set ordem = 15 where nome = '$menu.nome.simulacaoAlcada';
update menu set ordem = 16 where nome = '$menu.nome.qualificacaoFornecedor';

update menu set datafim = now() where link in ('%dinamicViews.load?identificacao=ReqSLA%');
-- FIM - [joao.morais] - 11/02/2016

-- INCIO - [deborah.ferreira] - 12/02/2016

CREATE TABLE auditoriaeventosgerentes (
	id INT4 NOT NULL,
	idauditoriaeventos INT8 NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idgerente INT4 NOT NULL,
	tipogerente CHAR(1) NULL,
	nomegerente VARCHAR(255) NOT NULL,
	conexao VARCHAR(50) NOT NULL,
	agendador VARCHAR(50) NOT NULL,
	ativarautocorrecao CHAR(1) NOT NULL,
	qtdexecucoesagendador INT4,
	nomeitemconfiguracaopai VARCHAR(400),
	host VARCHAR(50),
	grupocategoriaocorrencia VARCHAR(200),
	categoriaocorrencia VARCHAR(200),
	gerarocorrenciasup CHAR(1) NULL,
	acaoup VARCHAR(255) NULL,
	urgenciaup CHAR(1) NULL,
	impactoup CHAR(1) NULL,
	gerarocorrenciasdown CHAR(1) NULL,
	acaodown VARCHAR(255) NULL,
	urgenciadown CHAR(1) NULL,
	impactodown CHAR(1) NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventos) REFERENCES auditoriaeventos (idauditoriaeventos)
);

-- FIM - [deborah.ferreira] - 12/02/2016

-- INICIO - thyen.chang - 12.02.2016

CREATE TABLE ITEMCONFIGURACAOVALOR(
  IDITEMCONFIGURACAOVALOR BIGINT NOT NULL,
  IDITEMCONFIGURACAO BIGINT NOT NULL,
  DATAINICIOVALOR DATE NOT NULL,
  DATAFIMVALOR DATE,
  DATAFIM DATE,
  VALOR DECIMAL NOT NULL,
  PRIMARY KEY (IDITEMCONFIGURACAOVALOR),
  CONSTRAINT FK_ITEMCONFIGURACAOVALOR FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO (IDITEMCONFIGURACAO)
);

-- FIM - thyen.chang - 12.02.2016

--INICIO - joao.morais - 15/02/2016
create table categoriaameaca(
	idcategoriaameaca int4 not null,
	nomecategoriaameaca varchar(255) not null,
	datafim date,
	primary key (idcategoriaameaca)
);
-- FIM - joao.morais - 15/02/2016

--INICIO - [rodrigo.acorse] - 16/02/2015

create table continuidade (
	idcontinuidade bigint not null,
	nomeregistrocontinuidade varchar(500),
	idcliente int4 not null,
	datainicio date not null,
	datafim date,
	primary key (idcontinuidade),
	constraint cliente_continuidade_pkey foreign key (idcliente) references  clientes(idcliente)
);

-- FIM - [rodrigo.acorse] - 16/02/2015

-- INICIO - joao.morais - 16/02/2016
create table ameaca(
	idameaca int4 not null,
	nomeameaca varchar (255) not null,
	idcategoriaameaca int4 not null,
	datafim date,
	primary key(idameaca),
	constraint fk_categoriaameaca foreign key (idcategoriaameaca) references categoriaameaca (idcategoriaameaca)
);
-- FIM - joao.morais - 16/02/2016

-- INCIO - [pedro.francisco] - 16/02/2016
alter table planomelhoria rename column datainicio to datainicioplano;
alter table planomelhoria rename column datafim to datafimplano;

alter table acaoplanomelhoria rename column datainicio to datainicioacao;
alter table acaoplanomelhoria rename column datafim to datafimacao;

alter table planomelhoria add datafim date;
-- FIM - [pedro.francisco] - 16/02/2016

-- INICIO - [deborah.ferreira] - 16/02/2016

ALTER TABLE ocorrenciaservicoatributosfinanceiros ADD classificacaoAtributosFinan INT;

CREATE TABLE ocorrenciaservicobaseconhecim (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idbaseconhecimento INT4 NOT NULL,
	nomebaseconhecimento VARCHAR(256) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

CREATE TABLE ocorrenciaservicohabilidade (
	id INT4 NOT NULL,
	idocorrenciaservico INT8 NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	idhabilidade INT4 NOT NULL,
	nomehabilidade VARCHAR(255) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idocorrenciaservico) REFERENCES ocorrenciaservico (idocorrenciaservico)
);

-- FIM - [deborah.ferreira] - 16/02/2016

-- INICIO - rodrigo.acorse - 10/02/2016

delete from menu where nome = '$menu.nome.graficoTempoReal';
delete from menu where nome = '$menu.nome.monitoramento.incidente';

-- FIM - rodrigo.acorse - 10/02/2016

-- INICIO - gilmar.junior - 19/02/2016
ALTER TABLE processonegocio ADD idcliente bigint;
ALTER TABLE processonegocio ADD CONSTRAINT processonegocio_idcliente_fk FOREIGN KEY (idcliente) REFERENCES clientes (idcliente);
-- FIM - gilmar.junior - 19/02/2016

-- INICIO - [pedro.francisco] - 19/02/2016
create table iniciacaoescopo (
	idescopo INT4 not null,
	idcontinuidade bigint not null,
	descricao varchar(255) not null,
	sumarioexecutivo varchar(255) not null,
	validade date not null,
	primary key (idescopo),
	constraint fk_cont_escopo foreign key (idcontinuidade) references continuidade(idcontinuidade)
);
-- FIM - [pedro.francisco] - 19/02/2016

-- INICIO - joao.morais - 22/02/2016
create table iniciacaopolitica(
	idpolitica int8 not null,
	idcontinuidade int8 not null,
	idgruporesponsavel int4,
	idresponsavel int4,
	titulo varchar(255) not null,
	datacriacao date not null,
	datavalidade date not null,
	descricao varchar(255),
	responsavel varchar(255),
	gruporesponsavel varchar(255),
	versao varchar(20) not null,
	datafim date,
	primary key(idpolitica),
	constraint fk_cont_politica foreign key (idcontinuidade) references continuidade(idcontinuidade),
	constraint fk_grupo_resp_politica foreign key (idgruporesponsavel) references grupo(idgrupo),
	constraint fk_responsavel_politica foreign key (idresponsavel) references empregados(idempregado)
);

alter table iniciacaopolitica rename column titulo to tituloiniciacaopolitica;
alter table iniciacaopolitica rename column versao to versaoiniciacaopolitica;
alter table iniciacaopolitica rename column descricao to descricaoiniciacaopolitica;
alter table iniciacaopolitica rename column datavalidade to datavalidadeiniciacaopolitica;
alter table iniciacaopolitica rename column responsavel to responsaveliniciacaopolitica;
alter table iniciacaopolitica rename column idresponsavel to idresponsaveliniciacaopolitica;
alter table iniciacaopolitica rename column idgruporesponsavel to idgruporespiniciacaopolitica;
-- FIM - joao.morais - 22/02/2016

-- INCIO - [deborah.ferreira] - 22/02/2016

CREATE TABLE auditoriaeventosgerentesserv (
	id INT4 NOT NULL,
	idauditoriaeventosgerentes INT4 NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	nomeservico VARCHAR(255),
	nomeconfiguracao VARCHAR(400),
	nometipoconfiguracao VARCHAR(255),
	checkconfiguracao VARCHAR(255),
	grupocategoriaocorrencia VARCHAR(200),
	categoriaocorrencia VARCHAR(200),
	gerarocorrenciasinformation CHAR(1),
	eplinformation TEXT,
	condicaoinformation VARCHAR(50),
	valorcondicaoinformation VARCHAR(50),
	acaoinformation VARCHAR(255),
	urgenciainformation CHAR(1),
	impactoinformation CHAR(1),
	gerarocorrenciaswarning CHAR(1),
	eplwarning TEXT,
	condicaowarning VARCHAR(50),
	valorcondicaowarning VARCHAR(50),
	acaowarning VARCHAR(255),
	urgenciawarning CHAR(1),
	impactowarning CHAR(1),
	gerarocorrenciasexception CHAR(1),
	eplexception TEXT,
	condicaoexception VARCHAR(50),
	valorcondicaoexception VARCHAR(50),
	acaoexception VARCHAR(255),
	urgenciaexception CHAR(1),
	impactoexception CHAR(1),
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventosgerentes) REFERENCES auditoriaeventosgerentes (id)
);

CREATE TABLE auditoriaeventosgergennagios (
	id INT4 NOT NULL,
	idauditoriaeventos INT8 NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idgerente INT4 NOT NULL,
	nomegerente VARCHAR(255) NOT NULL,
	conexao VARCHAR(50) NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventos) REFERENCES auditoriaeventos (idauditoriaeventos)
);

CREATE TABLE auditoriaeventosgergennagserv (
	id INT4 NOT NULL,
	idauditoriaeventosgergennagios INT4 NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idlinha INT4 NOT NULL,
	hostservico VARCHAR(50),
	nomeservico VARCHAR(50),
	grupocategoriaocorrencia VARCHAR(200) NOT NULL,
	categoriaocorrencia VARCHAR(200) NOT NULL,
	agendador VARCHAR(50) NOT NULL,
	servicoativo CHAR(1) NULL,
	gerarocorrenciasup CHAR(1) NULL,
	acaoup VARCHAR(255) NULL,
	urgenciaup CHAR(1) NULL,
	impactoup CHAR(1) NULL,
	gerarocorrenciasdown CHAR(1) NULL,
	acaodown VARCHAR(255) NULL,
	urgenciadown CHAR(1) NULL,
	impactodown CHAR(1) NULL,
	gerarocorrenciasinformation CHAR(1),
	acaoinformation VARCHAR(255),
	urgenciainformation CHAR(1),
	impactoinformation CHAR(1),
	gerarocorrenciaswarning CHAR(1),
	acaowarning VARCHAR(255),
	urgenciawarning CHAR(1),
	impactowarning CHAR(1),
	gerarocorrenciasexception CHAR(1),
	acaoexception VARCHAR(255),
	urgenciaexception CHAR(1),
	impactoexception CHAR(1),
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventosgergennagios) REFERENCES auditoriaeventosgergennagios (id)
);

CREATE TABLE auditoriaeventosgerentecorrel (
	id INT4 NOT NULL,
	idauditoriaeventos INT8 NOT NULL,
	acaoauditoriaeventos CHAR(1) NULL,
	idgerente INT4 NOT NULL,
	nomegerente VARCHAR(255) NOT NULL,
	conexao VARCHAR(50) NOT NULL,
	grupocategoriaocorrencia VARCHAR(200) NOT NULL,
	categoriaocorrencia VARCHAR(200) NOT NULL,
	acaoinformation VARCHAR(255),
	urgenciainformation CHAR(1),
	impactoinformation CHAR(1),
	eplinformation TEXT,
	acaowarning VARCHAR(255),
	urgenciawarning CHAR(1),
	impactowarning CHAR(1),
	eplwarning TEXT,
	acaoexception VARCHAR(255),
	urgenciaexception CHAR(1),
	impactoexception CHAR(1),
	eplexception TEXT,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriaeventos) REFERENCES auditoriaeventos (idauditoriaeventos)
);
-- FIM - [deborah.ferreira] - 22/02/2016

-- INICIO - [pedro.francisco] - 24/02/2016
create table funcoesvitais (
	idfuncaovital bigint not null,
	idcontinuidade int8 not null,
	nome varchar(255) not null,
	idprocessonegocio int4 not null,
	prioridade int4 not null,
	datafim DATE,
	primary key (idfuncaovital),
	constraint fk_fvital foreign key (idcontinuidade) references continuidade(idcontinuidade),
	constraint fk_fvital_pn foreign key (idprocessonegocio) references processonegocio(idprocessonegocio)
);
-- FIM - [pedro.francisco] - 24/02/2016

-- INCIO [gustavo.gomes] 03.02.2016
CREATE TABLE servicobaseconhecimento
(
	idservicobaseconhecimento bigint not null,
	idservico bigint not null,
	idbaseconhecimento bigint not null,
	PRIMARY KEY (idservicobaseconhecimento) ,
	FOREIGN KEY (idservico) REFERENCES servico (idservico)
);

CREATE TABLE categoriarisco
(
	idcategoriarisco int8 NOT NULL,
	nome VARCHAR(255) NOT NULL ,
	tag VARCHAR(255),
	cor VARCHAR(255),
	icone VARCHAR(255),
	datafim DATE,
	PRIMARY KEY (idcategoriarisco)
);

ALTER TABLE risco ADD idcategoriarisco int8;
ALTER TABLE risco ADD FOREIGN KEY (idcategoriarisco) REFERENCES categoriarisco(idcategoriarisco);
ALTER TABLE ameaca ADD tipo VARCHAR(1);

CREATE TABLE ameacarisco
(
	idameacariscocont int8 NOT NULL,
	idrisco int8 NOT NULL,
	idameaca int8 NOT NULL,
	PRIMARY KEY (idameacariscocont)
);
-- FIM [gustavo.gomes] 17.02.2016
-- INICIO - [thyen.chang] - 25.02.2016

CREATE TABLE PROBLEMASERVICONEGOCIO(
  idproblemaserviconegocio INT4 NOT NULL
  ,idproblema INT4 NOT NULL
  ,idservico INT4 NOT NULL
  ,PRIMARY KEY (idproblemaserviconegocio)
  ,CONSTRAINT fk_probserv_prob FOREIGN KEY (idproblema) REFERENCES PROBLEMA (idproblema)
  ,CONSTRAINT fk_probserv_serv FOREIGN KEY (idservico) REFERENCES SERVICO (idservico)
);

-- FIM - [thyen.chang] - 25.02.2016

-- INICIO [deborah.ferreira] - 26.02.2016

CREATE TABLE iniciacaoprojeto (
	idiniciacaoprojeto INT4 NOT NULL,
	idcontinuidadeiniciacaoprojeto INT8 NOT NULL,
	idprojetoiniciacaoprojeto INT4 NOT NULL,
	PRIMARY KEY (idiniciacaoprojeto),
	FOREIGN KEY (idcontinuidadeiniciacaoprojeto) REFERENCES continuidade (idcontinuidade),
	FOREIGN KEY (idprojetoiniciacaoprojeto) REFERENCES projetos (idprojeto)
);

-- FIM [deborah.ferreira] - 26.02.2016-- FIM - rodrigo.acorse - 10/02/2016

-- INICIO - euler.ramos - 18/02/2016

CREATE TABLE configdestinatario 
( 
  idconfigdestinatario bigint NOT NULL, 
  nomeconfigdestinatario character varying(254) NOT NULL, 
  datahorafim timestamp without time zone, 
  CONSTRAINT pkconfigdestinatario PRIMARY KEY (idconfigdestinatario) 
) 
WITH ( 
  OIDS=FALSE 
);

CREATE TABLE destinatarioempregados 
( 
  idconfigdestinatario bigint NOT NULL, 
  idempregado integer NOT NULL, 
  CONSTRAINT pkdestinatarioempregados PRIMARY KEY (idconfigdestinatario, idempregado), 
  CONSTRAINT fkconfigdestempdest FOREIGN KEY (idconfigdestinatario) 
      REFERENCES configdestinatario (idconfigdestinatario) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
  CONSTRAINT fkconfigdestempemp FOREIGN KEY (idempregado) 
      REFERENCES empregados (idempregado) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT 
) 
WITH ( 
  OIDS=FALSE 
);

CREATE TABLE destinatariogrupos 
( 
  idconfigdestinatario bigint NOT NULL, 
  idgrupo integer NOT NULL, 
  CONSTRAINT pkdestinatariogrupos PRIMARY KEY (idconfigdestinatario, idgrupo), 
  CONSTRAINT fkconfigdestgrpdest FOREIGN KEY (idconfigdestinatario) 
      REFERENCES configdestinatario (idconfigdestinatario) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
 CONSTRAINT fkconfigdestgrpgrp FOREIGN KEY (idgrupo) 
      REFERENCES grupo (idgrupo) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT 
) 
WITH ( 
  OIDS=FALSE 
);

CREATE TABLE configeventonotificacao 
( 
  idconfigeventonotificacao bigint NOT NULL, 
  identificador character varying(254) NOT NULL, 
  classenegocio character varying(254) NOT NULL, 
  descricao character varying(254) NOT NULL, 
  epl text NOT NULL, 
  nivelalerta character varying(254) NOT NULL, 
  prazoconfirmacao integer, 
  prazoalerta integer, 
  prazoescalonamento integer, 
  idconfigdestinatarioinicial bigint not null, 
  idmodeloemailinicial bigint NOT NULL, 
  idconfigdestinatarioescalon bigint null, 
  idmodeloemailescalonamento bigint, 
  datahorafim timestamp without time zone, 
  exigeconfirmacao character(1) NOT NULL, 
  CONSTRAINT pkconfigeventonotificacao PRIMARY KEY (idconfigeventonotificacao), 
  CONSTRAINT fkconfigevnotmailini FOREIGN KEY (idmodeloemailinicial) 
      REFERENCES modelosemails (idmodeloemail) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
  CONSTRAINT fkconfigevnotmailesc FOREIGN KEY (idmodeloemailescalonamento) 
      REFERENCES modelosemails (idmodeloemail) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
  CONSTRAINT fkconfigevnotdestini FOREIGN KEY (idconfigdestinatarioinicial) 
      REFERENCES configdestinatario (idconfigdestinatario) MATCH SIMPLE  
      ON UPDATE RESTRICT ON DELETE RESTRICT, 
  CONSTRAINT fkconfigevnotdestesc FOREIGN KEY (idconfigdestinatarioescalon) 
      REFERENCES configdestinatario (idconfigdestinatario) MATCH SIMPLE 
      ON UPDATE RESTRICT ON DELETE RESTRICT 
) 
WITH ( 
  OIDS=FALSE 
);

CREATE TABLE modeloepl 
( 
  idmodeloepl integer NOT NULL, 
  descricao character varying(255) NOT NULL, 
  modeloepl text NOT NULL, 
  datahorafim timestamp without time zone, 
  CONSTRAINT modeloepl_pkey PRIMARY KEY (idmodeloepl) 
) 
WITH ( 
  OIDS=FALSE 
);

-- FIM - euler.ramos - 18/02/2016

-- INICIO - thyen.chang - 29.02.2016

CREATE TABLE INDICADORCAPACIDADE( 
	idindicadorcapacidade INTEGER NOT NULL, 
	nome CHARACTER VARYING(255) NOT NULL, 
	valor CHARACTER VARYING(255) NOT NULL, 
	datahorafim TIMESTAMP WITHOUT TIME ZONE, 
	CONSTRAINT PK_INDICADORCAPACIDADE PRIMARY KEY (idindicadorcapacidade) 
)WITH (OIDS=FALSE);

CREATE TABLE INDICADORESCAPACIDADESERVICO(
	idindicadorcapacidadeservico INTEGER
	,idindicadorcapacidade INTEGER
	,idservico INTEGER
	,PRIMARY KEY (idindicadorcapacidadeservico)
	,CONSTRAINT fk_capser_indcap FOREIGN KEY (idindicadorcapacidade) REFERENCES INDICADORCAPACIDADE (idindicadorcapacidade)
	,CONSTRAINT fk_capser_ser FOREIGN KEY (idservico) REFERENCES SERVICO (idservico)
)WITH (OIDS=FALSE);

-- FIM - thyen.chang - 29.02.2016

-- INICIO - douglas.japiassu - 01.03.2016
alter table servico add incidentecritico char(1) null;
-- FIM - douglas.japiassu - 01.03.2016

-- INICIO - thyen.chang - 01.03.2016

CREATE TABLE ATRIBUTODEMANDA( 
	idatributodemanda INTEGER NOT NULL, 
	nome CHARACTER VARYING(255) NOT NULL, 
	valor CHARACTER VARYING(255) NOT NULL, 
	datahorafim TIMESTAMP WITHOUT TIME ZONE, 
	CONSTRAINT PK_ATRIBUTODEMANDA PRIMARY KEY (idatributodemanda) 
)WITH (OIDS=FALSE);

CREATE TABLE ATRIBUTODEMANDASERVICO(
	idatributodemandaservico INTEGER
	,idatributodemanda INTEGER
	,idservico INTEGER
	,PRIMARY KEY (idatributodemandaservico)
	,CONSTRAINT fk_demser_atrdem FOREIGN KEY (idatributodemanda) REFERENCES ATRIBUTODEMANDA (idatributodemanda)
	,CONSTRAINT fk_demser_ser FOREIGN KEY (idservico) REFERENCES SERVICO (idservico)
)WITH (OIDS=FALSE);

-- FIM - thyen.chang - 01.03.2016

-- INICIO [rodrigo.acorse] - 29.02.2016

CREATE TABLE cenario (
	idcenario bigint not null,
	nomecenario character varying(255) not null,
	idfuncaovital bigint not null,
	idcontinuidade bigint not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenario),
	FOREIGN KEY (idfuncaovital) REFERENCES funcoesvitais (idfuncaovital),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE cenariorisco (
	idcenariorisco bigint not null,
	idcenario bigint not null,
	idrisco int not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenariorisco),
	FOREIGN KEY (idcenario) REFERENCES cenario (idcenario),
	FOREIGN KEY (idrisco) REFERENCES risco (idrisco)
);

CREATE TABLE cenarioservico (
	idcenarioservico bigint not null,
	idcenario bigint not null,
	idservico bigint not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenarioservico),
	FOREIGN KEY (idcenario) REFERENCES cenario (idcenario),
	FOREIGN KEY (idservico) REFERENCES servico (idservico)
);

CREATE TABLE tratativa (
	idtratativa bigint not null,
	nometratativa character varying(255) not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idtratativa)
);

CREATE TABLE cenarioriscoameaca (
	idcenarioriscoameaca bigint not null,
	idcenariorisco bigint not null,
	idameaca bigint not null,
	probabilidade int not null,
	impacto decimal(10,2) not null,
	justificativa text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenarioriscoameaca),
	FOREIGN KEY (idcenariorisco) REFERENCES cenariorisco (idcenariorisco),
	FOREIGN KEY (idameaca) REFERENCES ameaca (idameaca)
);

CREATE TABLE cenarioriscotratativa (
	idcenarioriscotratativa bigint not null,
	idcenariorisco bigint not null,
	idtratativa bigint not null,
	probabilidade int not null,
	impacto decimal(10,2) not null,
	medidarecuperacao text,
	planomitigacao text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idcenarioriscotratativa),
	FOREIGN KEY (idcenariorisco) REFERENCES cenariorisco (idcenariorisco),
	FOREIGN KEY (idtratativa) REFERENCES tratativa (idtratativa)
);

CREATE TABLE cenarioriscotratativaameaca (
	idtratativaameaca bigint not null,
	idcenarioriscotratativa bigint not null,
	idcenarioriscoameaca bigint not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idtratativaameaca),
	FOREIGN KEY (idcenarioriscotratativa) REFERENCES cenarioriscotratativa (idcenarioriscotratativa),
	FOREIGN KEY (idcenarioriscoameaca) REFERENCES cenarioriscoameaca (idcenarioriscoameaca)
);

-- FIM [rodrigo.acorse] - 29.02.2016

-- INICIO [gilmar.junior] - 02.03.2016
CREATE TABLE impactoain
(
  idimpactoain bigint NOT NULL,
  impactoain character varying(255) NOT NULL,
  datahorafim timestamp without time zone,
  PRIMARY KEY (idimpactoain)
)
WITH (
  OIDS=FALSE
);

CREATE TABLE analiseimpactonegocio
(
  idanaliseimpactonegocio bigint NOT NULL,
  idcontinuidade bigint NOT NULL,
  idfuncaovital bigint NOT NULL,
  impacto character varying(255),
  severidade char(1),
  custohora double precision,
  custoimpacto double precision,
  maxtoleravelinatividade varchar(8),
  objvtemporec varchar(8),
  objvpontorec varchar(8),
  estrategia1 text,
  estrategia2 text,
  estrategia3 text,
  datahorafim timestamp without time zone,
  PRIMARY KEY (idanaliseimpactonegocio),
  FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade),
  FOREIGN KEY (idfuncaovital) REFERENCES funcoesvitais (idfuncaovital)
)
WITH (
  OIDS=FALSE
);

-- FIM [gilmar.junior] - 02.03.2016

-- INICIO [deborah.ferreira] - 03.03.2016

CREATE TABLE planejamentoorganizacional (
	id INT4 NOT NULL,
	idcontinuidade INT8 NOT NULL,
	sumarioexecutivo TEXT NOT NULL,
	PRIMARY KEY (id),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE planejamentoorganizacionalgrp (
	id INT4 NOT NULL,
	idplanejamentoorganizacional INT4 NOT NULL,
	idgrupo INT4 NOT NULL,
	tipogrupo CHAR(5) NOT NULL,
	responsabilidade CHARACTER VARYING(255) NOT NULL,
	datafim DATE,
	PRIMARY KEY (id),
	FOREIGN KEY (idplanejamentoorganizacional) REFERENCES planejamentoorganizacional (id)
);

-- FIM [deborah.ferreira] - 03.03.2016

-- INICIO [rodrigo.acorse] - 07.03.2016

CREATE TABLE calendarioevento (
	idevento bigint not null,
	idcontinuidade bigint not null,
	nomeevento character varying(255) not null,
	detalhesevento text,
	datainicioevento timestamp not null,
	datafimevento timestamp not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idevento)
);

CREATE TABLE calendarioeventogrupo (
	ideventogrupo bigint not null,
	idevento bigint not null,
	idgrupo int not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventogrupo),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idgrupo) REFERENCES grupo (idgrupo)
);

CREATE TABLE calendarioeventoempregado (
	ideventoempregado bigint not null,
	idevento bigint not null,
	idempregado int not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventoempregado),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idempregado) REFERENCES empregados (idempregado)
);

-- FIM [rodrigo.acorse] - 07.03.2016

-- INICIO [gilberto.nery] - 07.03.2016

CREATE TABLE liberacaobaseconhecimento
(
   idliberacao integer NOT NULL, 
   idbaseconhecimento integer NOT NULL, 
   CONSTRAINT fk_liberacaobc_liberacao FOREIGN KEY (idliberacao) REFERENCES liberacao (idliberacao) ON UPDATE NO ACTION ON DELETE NO ACTION
) WITH (OIDS = FALSE);

-- FIM [gilberto.nery] - 07.03.2016

-- INICIO [euler.ramos] - 08.03.2016

CREATE TABLE conhecimentomidiasoftware( 
  idconhecimentomidiasoftware bigint NOT NULL, 
  idmidiasoftware integer NOT NULL, 
  idbaseconhecimento integer NOT NULL, 
  datafim date, 
  CONSTRAINT pkconhecimentomidiasoftware PRIMARY KEY (idconhecimentomidiasoftware), 
  CONSTRAINT fk_conhmsoft_midiasoftware FOREIGN KEY (idmidiasoftware) 
      REFERENCES midiasoftware (idmidiasoftware) MATCH SIMPLE 
      ON UPDATE NO ACTION ON DELETE NO ACTION 
);

-- FIM [euler.ramos] - 08.03.2016

-- INICIO - thyen.chang - 08.03.2016

CREATE TABLE INDICADORESCAPACIDADEIC(
	idindicadorcapacidadeic INTEGER
	,idindicadorcapacidade INTEGER
	,iditemconfiguracao INTEGER
	,PRIMARY KEY (idindicadorcapacidadeic)
	,CONSTRAINT fk_capic_indcap FOREIGN KEY (idindicadorcapacidade) REFERENCES INDICADORCAPACIDADE (idindicadorcapacidade)
	,CONSTRAINT fk_capic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES ITEMCONFIGURACAO (iditemconfiguracao)
)WITH (OIDS=FALSE);

-- FIM - thyen.chang - 08.03.2016

-- INICIO [deborah.ferreira] - 08.03.2016

CREATE TABLE conscientizacao (
	idconscientizacao INT4 NOT NULL,
	idcontinuidade INT8 NOT NULL,
	sumarioexecutivo TEXT NOT NULL,
	PRIMARY KEY (idconscientizacao),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE conscientizacaoregistro (
	idconscientizacaoregistro INT4 NOT NULL,
	idconscientizacao INT4 NOT NULL,
	analisecriticaacao TEXT NOT NULL,
	tipoatividade CHAR(5) NOT NULL,
	status CHAR(5) NOT NULL,
	datafim DATE NULL,
	PRIMARY KEY (idconscientizacaoregistro),
	FOREIGN KEY (idconscientizacao) REFERENCES conscientizacao (idconscientizacao)
);

-- FIM [deborah.ferreira] - 08.03.2016

-- INCIO [douglas.japiassu] - 09.03.2016

CREATE TABLE estrategiacontinuidade (
	idestrategiacontinuidade bigint not null,
	idcontinuidade bigint not null,
	sumarioexecutivo text,
	objetivo text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idestrategiacontinuidade),
	FOREIGN KEY (idcontinuidade) REFERENCES continuidade (idcontinuidade)
);

CREATE TABLE estrategiafuncaovital (
	idestrategiafuncaovital bigint not null,
	idestrategiacontinuidade bigint not null,
	idfuncaovital bigint not null,
	PRIMARY KEY (idestrategiafuncaovital),
	FOREIGN KEY (idestrategiacontinuidade) REFERENCES estrategiacontinuidade (idestrategiacontinuidade),
	FOREIGN KEY (idfuncaovital) REFERENCES funcoesvitais (idfuncaovital)
);

CREATE TABLE medidaresposta (
	idmedidaresposta bigint not null,
	idestrategiacontinuidade bigint not null,
	idcenarioriscotratativa bigint not null,
	nome varchar(255) not null,
	justificativa text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idmedidaresposta),
	FOREIGN KEY (idestrategiacontinuidade) REFERENCES estrategiacontinuidade (idestrategiacontinuidade),
	FOREIGN KEY (idcenarioriscotratativa) REFERENCES cenarioriscotratativa (idcenarioriscotratativa)
);

CREATE TABLE medidarespostaprojeto (
	idmedidarespostaprojeto bigint not null,
	idmedidaresposta bigint not null,
	idprojeto int4 not null,
	PRIMARY KEY (idmedidarespostaprojeto),
	FOREIGN KEY (idmedidaresposta) REFERENCES medidaresposta (idmedidaresposta),
	FOREIGN KEY (idprojeto) REFERENCES projetos (idprojeto)
);

CREATE TABLE medidarecuperacao (
	idmedidarecuperacao bigint not null,
	idestrategiacontinuidade bigint not null,
	idcenarioriscotratativa bigint not null,
	nome varchar(255) not null,
	tiporecuperacao varchar(2) not null,
	justificativa text,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idmedidarecuperacao),
	FOREIGN KEY (idestrategiacontinuidade) REFERENCES estrategiacontinuidade (idestrategiacontinuidade),
	FOREIGN KEY (idcenarioriscotratativa) REFERENCES cenarioriscotratativa (idcenarioriscotratativa)
);

CREATE TABLE medidarecuperacaobaseconhec (
	idmedidarecuperacaobaseconhec bigint not null,
	idmedidarecuperacao bigint not null,
	idbaseconhecimento integer not null,
	PRIMARY KEY (idmedidarecuperacaobaseconhec),
	FOREIGN KEY (idmedidarecuperacao) REFERENCES medidarecuperacao (idmedidarecuperacao)
);

-- FIM [douglas.japiassu] - 09.03.2016

-- INICIO - thyen.chang - 09.03.2016

CREATE TABLE ATRIBUTODEMANDAIC(
	idatributodemandaic INTEGER
	,idatributodemanda INTEGER
	,iditemconfiguracao INTEGER
	,PRIMARY KEY (idatributodemandaic)
	,CONSTRAINT fk_dmdic_atrdm FOREIGN KEY (idatributodemanda) REFERENCES ATRIBUTODEMANDA (idatributodemanda)
	,CONSTRAINT fk_dmdic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES ITEMCONFIGURACAO (iditemconfiguracao)
)WITH (OIDS=FALSE);

-- FIM - thyen.chang - 09.03.2016

-- INICIO [gilberto.nery] - 09.03.2016

CREATE TABLE mudancabaseconhecimento
(
   idrequisicaomudanca integer NOT NULL, 
   idbaseconhecimento integer NOT NULL, 
   CONSTRAINT fk_mudancabc_reqmudanca FOREIGN KEY (idrequisicaomudanca) REFERENCES requisicaomudanca (idrequisicaomudanca) ON UPDATE NO ACTION ON DELETE NO ACTION
) WITH (OIDS = FALSE);

-- FIM [gilberto.nery] - 09.03.2016

--INICIO [gustavo.gomes] - 07.03.2016

CREATE TABLE auditoriacontinuidade(
	idauditoriacontinuidade BIGINT NOT NULL,
	idcontinuidade BIGINT NOT NULL,
	usuario VARCHAR(255) NOT NULL,
	datacriacao TIMESTAMP NOT NULL,
	categoriaauditoria VARCHAR(10) NOT NULL,
	tipoauditoria VARCHAR(10) NOT NULL,
	descricaoauditoria TEXT,
	PRIMARY KEY (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontpolitica(
	idauditoriacontpolitica BIGINT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	titulopolitica VARCHAR(255),
	versaopolitica VARCHAR(20),
	datavalidadepolitica DATE,
	descricaopolitica VARCHAR(255),
	responsavelpolitica VARCHAR(255),
	PRIMARY KEY (idauditoriacontpolitica),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontescopo(
	idauditoriacontescopo BIGINT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoAuditoria CHAR(1) NULL,
	sumarioexecutivo VARCHAR(255),
	descricaoescopo VARCHAR(255),
	datavalidadeescopo DATE,
	PRIMARY KEY (idauditoriacontescopo),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontprojeto(
	idauditoriacontprojeto BIGINT NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idprojeto INTEGER,
	nomeprojeto VARCHAR(255),
	PRIMARY KEY (idauditoriacontprojeto),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

--FIM [gustavo.gomes] 09.03.2016 
-- INICIO [gilberto.ney] - 10.03.2016

INSERT INTO tipodemandaservico (idtipodemandaservico,nometipodemandaservico,classificacao,deleted) 
VALUES ((select idtipodemandaservico + 1 from tipodemandaservico order by idtipodemandaservico desc limit 1),'Procedimento','P',NULL);

-- FIM [gilberto.ney] - 10.03.2016

-- INICIO [deborah.ferreira] - 11.03.2016

CREATE TABLE auditoriacontinuidadeanexos (
	idauditoriacontinuidadeanexos INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idanexo INT4 NOT NULL,
	idregistro INT4 NOT NULL,
	nomeanexo VARCHAR(255) NOT NULL,
	descricaoanexo VARCHAR(255) NOT NULL,
	PRIMARY KEY (idauditoriacontinuidadeanexos),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontfuncaovital(
	idauditoriacontfuncaovital INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idfuncaovital BIGINT NOT NULL,
	nomefuncaovital VARCHAR(255) NOT NULL,
	nomeprocessonegocio VARCHAR(100) NOT NULL,
	prioridadefuncaovital INT4 NOT NULL,
	PRIMARY KEY (idauditoriacontfuncaovital),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

-- FIM [deborah.ferreira] - 11.03.2016

-- INICIO [joao.morais] - 14.03.2016

CREATE TABLE auditoriacontavalrisco(
	idauditoriacontavalrisco INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenario BIGINT NOT NULL,
	nomecenario varchar(255) NOT NULL,
	nomefuncaovital varchar(255) NOT NULL,
	PRIMARY KEY (idauditoriacontavalrisco),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontavalriscoserv(
	idauditoriacontavalriscoserv INT4 NOT NULL,
	idauditoriacontavalrisco INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenarioservico BIGINT NOT NULL,
	idservico int8 NOT NULL,
	nomeservico VARCHAR(500) NOT NULL,
	PRIMARY KEY (idauditoriacontavalriscoserv),
	FOREIGN KEY (idauditoriacontavalrisco) REFERENCES auditoriacontavalrisco (idauditoriacontavalrisco)
);

CREATE TABLE auditoriacontavalriscorisco(
	idauditoriacontavalriscorisco INT4 NOT NULL,
	idauditoriacontavalrisco INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenariorisco BIGINT not null,
	idrisco int not null,
	nomerisco VARCHAR(150) NOT NULL,
	PRIMARY KEY (idauditoriacontavalriscorisco),
	FOREIGN KEY (idauditoriacontavalrisco) REFERENCES auditoriacontavalrisco (idauditoriacontavalrisco)
);

CREATE TABLE auditoriacontavalriscotrata(
	idauditoriacontavalriscotrata INT4 NOT NULL,
	idauditoriacontavalriscorisco INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenarioriscotratativa bigint not null,
	idtratativa BIGINT NOT NULL,
	nometratativa CHARACTER VARYING(255) NOT NULL,
	probabilidade INT NOT NULL,
	impacto DECIMAL(10,2) NOT NULL,
	propostamedidarecuperacao TEXT,
	propostaplanomitigacao TEXT,
	ameacasrelacionadas TEXT,
	PRIMARY KEY (idauditoriacontavalriscotrata),
	FOREIGN KEY (idauditoriacontavalriscorisco) REFERENCES auditoriacontavalriscorisco (idauditoriacontavalriscorisco)
);

CREATE TABLE auditoriacontavalriscoameaca(
	idauditoriacontavalriscameaca INT4 NOT NULL,
	idauditoriacontavalriscorisco INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idcenarioriscoameaca bigint not null,
	idameaca INT4 NOT NULL,
	nomeameaca VARCHAR (255) NOT NULL,
	nomecategoriaameaca VARCHAR(255) NOT NULL,
	probabilidade INT NOT NULL,
	impacto DECIMAL(10,2) NOT NULL,
	justificativa TEXT,
	PRIMARY KEY (idauditoriacontavalriscameaca),
	FOREIGN KEY (idauditoriacontavalriscorisco) REFERENCES auditoriacontavalriscorisco (idauditoriacontavalriscorisco)
);

CREATE TABLE auditoriaestcontservico(
	idauditoriaestcontservico INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idestrategiacontinuidade BIGINT NOT NULL,
	sumarioexecutivo TEXT,
	objetivo TEXT,
	PRIMARY KEY (idauditoriaestcontservico),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriaestcontservfuncvital(
	idauditoriaestcontservfuncvit INT4 NOT NULL,
	idauditoriaestcontservico INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idfuncaovital BIGINT NOT NULL,
	nomefuncaovital VARCHAR(255),
	PRIMARY KEY (idauditoriaestcontservfuncvit),
	FOREIGN KEY (idauditoriaestcontservico) REFERENCES auditoriaestcontservico (idauditoriaestcontservico)
);

CREATE TABLE auditoriaestcontservmedidarec(
	idauditoriaestcontservmedrec INT4 NOT NULL,
	idauditoriaestcontservico INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	nometratativa CHARACTER VARYING(255) NOT NULL,
	idmedidarecuperacao BIGINT NOT NULL,
	nomemedidarecuperacao VARCHAR(255) NOT NULL,
	tiporecuperacao VARCHAR(2) NOT NULL,
	medidarecuperacao TEXT,
	justificativamedidarecuperacao TEXT,
	PRIMARY KEY (idauditoriaestcontservmedrec),
	FOREIGN KEY (idauditoriaestcontservico) REFERENCES auditoriaestcontservico (idauditoriaestcontservico)
);

CREATE TABLE auditoriaestcontservbaseconhec(
	idauditoriaestcontservbaseconh INT4 NOT NULL,
	idauditoriaestcontservmedrec INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idmedidarecuperacaobaseconhec BIGINT NOT NULL,
	nomebaseconhecimento varchar(256) NOT NULL,
	PRIMARY KEY (idauditoriaestcontservbaseconh),
	FOREIGN KEY (idauditoriaestcontservmedrec) REFERENCES auditoriaestcontservmedidarec (idauditoriaestcontservmedrec)
);

CREATE TABLE auditoriaestcontservmedresp(
	idauditoriaestcontservmedresp INT4 NOT NULL,
	idauditoriaestcontservico INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	nometratativa CHARACTER VARYING(255) NOT NULL,
	idmedidaresposta BIGINT NOT NULL,
	nomemedidaresposta VARCHAR(255) NOT NULL,
	planomitigacao TEXT,
	justificativa TEXT,
	nomeprojeto TEXT,
	PRIMARY KEY (idauditoriaestcontservmedresp),
	FOREIGN KEY (idauditoriaestcontservico) REFERENCES auditoriaestcontservico (idauditoriaestcontservico)
);

CREATE TABLE auditoriaplanocontinuidade(
	idauditoriaplanocontinuidade INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanodecontinuidade INT NOT NULL,
	tituloplanocontinuidade varchar(255) NOT NULL,
	statusplanocontinuidade INTEGER NOT NULL,
	descricaoplanocontinuidade varchar(255) NOT NULL,
	nomeprocedimentocontinuidade varchar(254) NOT NULL,
	nomeresponsavel varchar(256) DEFAULT NULL,
	datavalidade DATE NOT NULL,
	autorizacao INTEGER NOT NULL,
	nomemudanca TEXT,
	PRIMARY KEY (idauditoriaplanocontinuidade),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriaplanocontconhecimento(
	idauditoriaplancontconheciment INT4 NOT NULL,
	idauditoriaplanocontinuidade INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanocontinuidadeconheciment INT NOT NULL,
	nomeconhecimento varchar(256) NOT NULL,
	PRIMARY KEY (idauditoriaplancontconheciment),
	FOREIGN KEY (idauditoriaplanocontinuidade) REFERENCES auditoriaplanocontinuidade (idauditoriaplanocontinuidade)
);

CREATE TABLE auditoriaplanocontmedidarec(
	idauditoriaplanocontmedidarec INT4 NOT NULL,
	idauditoriaplanocontinuidade INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanocontinuidademedidarec INT NOT NULL,
	medidarecuperacao VARCHAR(255) NOT NULL,
	PRIMARY KEY (idauditoriaplanocontmedidarec),
	FOREIGN KEY (idauditoriaplanocontinuidade) REFERENCES auditoriaplanocontinuidade (idauditoriaplanocontinuidade)
);

CREATE TABLE auditoriacontplanorganiza(
	idauditoriacontplanorganiza INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanejamentoorganizacional INT4 NOT NULL,
	sumarioexecutivo TEXT NOT NULL,
	PRIMARY KEY (idauditoriacontplanorganiza),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontplanorggrupo(
	idauditoriacontplanorggrupo INT4 NOT NULL,
	idauditoriacontplanorganiza INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idplanorganizacionalgrp INT4 NOT NULL,
	tipogrupo CHAR(5) NOT NULL,
	nomegrupo varchar(255) NOT NULL,
	responsabilidade VARCHAR(255) NOT NULL,
	PRIMARY KEY(idauditoriacontplanorggrupo),
	FOREIGN KEY(idauditoriacontplanorganiza) REFERENCES auditoriacontplanorganiza (idauditoriacontplanorganiza)
);

CREATE TABLE auditoriacontconscientizacao(
	idauditoriacontconscientizacao INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idconscientizacao INT4 NOT NULL,
	sumarioexecutivo TEXT NOT NULL,
	PRIMARY KEY(idauditoriacontconscientizacao),
	FOREIGN KEY(idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriacontconscientregistro(
	idauditoriacontconscientregist INT4 NOT NULL,
	idauditoriacontconscientizacao INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idconscientizacaoregistro INT4 NOT NULL,
	analisecriticaacao TEXT NOT NULL,
	tipoatividade CHAR(5) NOT NULL,
	status CHAR(5) NOT NULL,
	PRIMARY KEY(idauditoriacontconscientregist),
	FOREIGN KEY(idauditoriacontconscientizacao) REFERENCES auditoriacontconscientizacao (idauditoriacontconscientizacao)
);

CREATE TABLE auditoriaestrategiatestes(
	idauditoriaestrategiatestes INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idestrategiatestes BIGINT NOT NULL,
	nomeestrategiateste VARCHAR(254) NOT NULL,
	sumarioexecutivoestteste TEXT,
	PRIMARY KEY (idauditoriaestrategiatestes),
	FOREIGN KEY(idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriaesttestmedrecup(
	idauditoriaesttestmedrecup INT4 NOT NULL,
	idauditoriaestrategiatestes INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idmedidarecuperacao BIGINT NOT NULL,
	nomemedidarecuperacao VARCHAR(255) NOT NULL,
	idplanoteste BIGINT NOT NULL,
	nomeplanoteste VARCHAR(255),
	descplanoteste TEXT,
	datainicio TIMESTAMP WITHOUT TIME ZONE NULL,
	datatermino TIMESTAMP WITHOUT TIME ZONE NULL,
	tipoteste VARCHAR(255) NULL,
	idtemplatecontinuidade INT NULL,
	nometemplatecontinuidade VARCHAR(200) NULL,
	PRIMARY KEY (idauditoriaesttestmedrecup),
	FOREIGN KEY (idauditoriaestrategiatestes) REFERENCES auditoriaestrategiatestes (idauditoriaestrategiatestes)
);

CREATE TABLE auditoriaestrtestplantestgrp(
	idauditoriaestrtestplantestgrp INT4 NOT NULL,
	idauditoriaesttestmedrecup INT4 NOT NULL,
	acaoauditoria CHAR(1) NULL,
	planotestegrupo BIGINT NOT NULL,
	idgrupo BIGINT NOT NULL,
	nomegrupo VARCHAR(255) NOT NULL,
	tipo INTEGER NULL,
	PRIMARY KEY (idauditoriaestrtestplantestgrp),
	FOREIGN KEY (idauditoriaesttestmedrecup) REFERENCES auditoriaesttestmedrecup (idauditoriaesttestmedrecup)
);

-- FIM [joao.morais] - 14.03.2016

-- INICIO [joao.morais] - 19.03.2016

CREATE TABLE auditoriaconttestes(
	idauditoriaconttestes INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	idevento BIGINT NOT NULL,
	nomeevento varchar(255) NOT NULL,
	detalhesevento TEXT,
	datainicioevento TIMESTAMP NOT NULL,
	datafimevento TIMESTAMP NOT NULL,
	acaoauditoria CHAR(1) null,
	PRIMARY KEY (idauditoriaconttestes),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

CREATE TABLE auditoriaconttesteventgrp(
	idauditoriaconttesteventgrp INT4 NOT NULL,
	idauditoriaconttestes INT4 NOT NULL,
	idgrupo BIGINT NOT NULL,
	nomegrupo varchar(255) NOT NULL,
	acaoauditoria CHAR(1) null,
	PRIMARY KEY (idauditoriaconttesteventgrp),
	FOREIGN KEY (idauditoriaconttestes) REFERENCES auditoriaconttestes (idauditoriaconttestes)
);

CREATE TABLE auditoriaconttesteventemp(
	idauditoriaconttesteventemp INT4 NOT NULL,
	idauditoriaconttestes INT4 NOT NULL,
	idempregado INT4 NOT NULL,
	nomeempregado varchar(255) NOT NULL,
	acaoauditoria char(1) null,
	PRIMARY KEY (idauditoriaconttesteventemp),
	FOREIGN KEY (idauditoriaconttestes) REFERENCES auditoriaconttestes (idauditoriaconttestes)
);

CREATE TABLE auditoriaconttesteventevid(
	idauditoriaconttesteventevid INT4 NOT NULL,
	idauditoriaconttestes INT4 NOT NULL,
	nomeevidencia varchar(256) NOT NULL,
	acaoauditoria char(1) null,
	PRIMARY KEY (idauditoriaconttesteventevid),
	FOREIGN KEY (idauditoriaconttestes) REFERENCES auditoriaconttestes (idauditoriaconttestes)
);

CREATE TABLE auditoriacontinvocacao(
	idauditoriacontinvocacao INT4 not null,
	idauditoriacontinuidade BIGINT not null,
	acaoauditoria CHAR(1) null,
	idsolicitacaoservicoincidente INT8 NOT NULL,
	idsolicitacaoservicoprocedimen INT8 NOT NULL,
	nomeIncidente varchar(500) NOT NULL,
	nomeprocedimento varchar(500) NOT NULL,
	nomeresponsavel varchar(255) NOT NULL,
	nomegrupoatual varchar(255) NOT NULL,
	situacao varchar(100) NOT NULL,
	PRIMARY KEY (idauditoriacontinvocacao),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

-- FIM [joao.morais] - 19.03.2016

-- INICIO - thyen.chang - 12.03.2016

ALTER TABLE BASECONHECIMENTO ADD TIPODOCUMENTO VARCHAR(3);

UPDATE BASECONHECIMENTO SET TIPODOCUMENTO = (CASE WHEN FAQ = 'S' THEN 'F' WHEN ERROCONHECIDO = 'S' THEN 'E' ELSE 'D' END);

-- FIM - thyen.chang - 12.03.2016

--INCIO - [douglas.japiassu] - 13/03/2016

create table templatecontinuidade (
	idtemplatecontinuidade int4 not null,
	identificacao varchar(255) not null,
	nometemplate varchar(200) not null,
	tipotemplate varchar(3) not null,
	nomeclassedto varchar(255),
	nomeclasseaction varchar(255),
	nomeclasseservico varchar(255),
	urlrecuperacao varchar(255),
	alturadiv integer not null,
	idquestionario int4,
	scriptaposrecuperacao text,
	primary key (idtemplatecontinuidade),
	foreign key (idquestionario) references questionario (idquestionario)
);

create table calendarioeventoquestionario (
	idcalendarioeventoquestionario bigint not null,
	idquestionario int4 not null,
	idevento bigint not null,
	dataquestionario timestamp not null,
	situacao char(1) not null,
	datahoragrav timestamp not null,
	primary key (idcalendarioeventoquestionario),
	foreign key (idevento) references calendarioevento (idevento),
	foreign key (idquestionario) references questionario (idquestionario)
);

--FIM - [douglas.japiassu] - 13/03/2016

-- INICIO - gilmar.junior - 13.03.2016
CREATE TABLE estrategiatestes 
(
  idestrategiateste bigint not null,
  idcontinuidade bigint not null,
  sumarioexecutivo text null,
  nomeiet character varying(254) not null,
  datahorafim timestamp without time zone,
  primary key (idestrategiateste),
  constraint fk_strtst_cont foreign key (idcontinuidade) references continuidade(idcontinuidade)
);

CREATE TABLE planoteste 
(
  idplanoteste bigint not null,
  idmedidarecuperacao bigint not null,
  idestrategiateste bigint not null,
  nomeplanoteste character varying(255) null,
  descplanoteste text null,
  tipoteste character varying(255) null,
  datainicio timestamp without time zone null,
  datatermino timestamp without time zone null,
  idtemplatecontinuidade int4 null,
  datahorafim timestamp without time zone,
  primary key (idplanoteste),
  constraint fk_pltst_strtst foreign key (idestrategiateste) references estrategiatestes(idestrategiateste),
  constraint fk_pltst_medrec foreign key (idmedidarecuperacao) references medidarecuperacao(idmedidarecuperacao),
  constraint fk_pltst_tempcont foreign key (idtemplatecontinuidade) references templatecontinuidade(idtemplatecontinuidade)
);

CREATE TABLE planotestegrupo 
(
  idplanotestegrupo bigint not null,
  idgrupo bigint not null,
  idplanoteste bigint not null,
  tipo integer null,
  datahorafim timestamp without time zone,
  primary key (idplanotestegrupo),
  constraint fk_pltstgrp_pltst foreign key (idplanoteste) references planoteste(idplanoteste),
  constraint fk_pltstgrp_grupo foreign key (idgrupo) references grupo(idgrupo)
);
-- FIM - gilmar.junior - 13.03.2016

-- INICIO - [gilberto.ney] - 04/12/2015

-- Cadastrar email de criacao de incidente critico 
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values ((select idmodeloemail + 1 from modelosemails order by idmodeloemail desc limit 1), 'CITSMART - Incidente Crtico criado. Nmero: ${IDSOLICITACAOSERVICO}',
'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que foi criado um incidente cr&iacute;tico. Incidente registrada em ${DATAHORASOLICITACAO}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Servi&ccedil;o:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'IncidenteCriticoCri');

-- Cadastrar email de aprovacao de incidente critico
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values ((select idmodeloemail + 1 from modelosemails order by idmodeloemail desc limit 1), 'CITSMART - Incidente Crtico aprovado. Nmero: ${IDSOLICITACAOSERVICO}',
'Senhor(a) ${NOMECONTATO},<br /><br />Informamos que foi aprovado o incidente cr&iacute;tico n&uacute;mero: ${IDSOLICITACAOSERVICO}. Registrada em ${DATAHORASOLICITACAO}, conforme os dados abaixo:<br /><strong><br />N&uacute;mero:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Servi&ccedil;o:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'IncidenteCriticoApr');

-- Cadastrar email de criacao de incidente critico 
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values ((select idmodeloemail + 1 from modelosemails order by idmodeloemail desc limit 1), 'CITSMART - Critical Incident created. Number: ${IDSOLICITACAOSERVICO}',
'Mr(s) ${NOMECONTATO},<br /><br />Please be advised that the critical incident number ${IDSOLICITACAOSERVICO} was created. Registered on ${DATAHORASOLICITACAO}, as the data below:<br /><strong><br />Number:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Service:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Best regards,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'CriticalIncidentCreated');

-- Cadastrar email de aprovacao de incidente critico
insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador)
values ((select idmodeloemail + 1 from modelosemails order by idmodeloemail desc limit 1), 'CITSMART - Critical Incident approved. Number: ${IDSOLICITACAOSERVICO}', 
'Mr(s) ${NOMECONTATO},<br /><br />Please be advised that the critical incident number ${IDSOLICITACAOSERVICO} has been approved . Registered on ${DATAHORASOLICITACAO}, as the data below:<br /><strong><br />Number:</strong>&nbsp;${IDSOLICITACAOSERVICO}<br /><strong>Service:</strong>&nbsp;${SERVICO}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Best regards,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.',
'A', 'CriticalIncidentApproved');

-- FIM [gilberto.ney] - 13.03.2016

-- INICIO [pedro.francisco] - 11.03.2016

create table planocontinuidade(
	idplanodecontinuidade int not null,
	idcontinuidade bigint not null,
	titulo varchar(255) not null,
	status integer not null,
	descricao varchar(255) not null,
	validade date not null,
	autorizacao integer not null,
	idresponsavel int,
	idresponsavelgrupo int,
	idprocedimentodecontinuidade bigint not null,
	datafim date,
	primary key(idplanodecontinuidade),
	constraint fk_resp_grupo_pc foreign key (idresponsavelgrupo) references grupo(idgrupo),
	constraint fk_resp_pc foreign key (idresponsavel) references empregados(idempregado),
	constraint fk_continuidade foreign key (idcontinuidade) references continuidade(idcontinuidade)
);

-- FIM [pedro.francisco] - 11.03.2016

-- INICIO - thyen.chang - 13.03.2016

CREATE TABLE planocontinuidadeconhecimento(
	idplanocontinuidadeconheciment int not null,
	idplanodecontinuidade int not null,
	idbaseconhecimento int not null,
	PRIMARY KEY (idplanocontinuidadeconheciment),
	CONSTRAINT fk_pcc_pc FOREIGN KEY (idplanodecontinuidade) REFERENCES planocontinuidade (idplanodecontinuidade)
);

CREATE TABLE planocontinuidademudanca(
	idplanocontinuidademudanca int not null,
	idplanodecontinuidade int not null,
	idrequisicaomudanca int not null,
	PRIMARY KEY (idplanocontinuidademudanca),
	CONSTRAINT fk_pcm_pc FOREIGN KEY (idplanodecontinuidade) REFERENCES planocontinuidade (idplanodecontinuidade),
	CONSTRAINT fk_pcm_rm FOREIGN KEY (idrequisicaomudanca) REFERENCES requisicaomudanca (idrequisicaomudanca)
);

CREATE TABLE planocontinuidademedidarec(
	idplanocontinuidademedidarec INT NOT NULL,
	idplanodecontinuidade int not null,
	idmedidarecuperacao bigint not null,
	PRIMARY KEY (idplanocontinuidademedidarec),
	CONSTRAINT fk_pcmr_pc FOREIGN KEY (idplanodecontinuidade) REFERENCES planocontinuidade (idplanodecontinuidade),
	CONSTRAINT fk_pcmr_mr FOREIGN KEY (idmedidarecuperacao) REFERENCES medidarecuperacao (idmedidarecuperacao)
);

-- FIM - thyen.chang - 13.03.2016

-- INICIO [deborah.ferreira] - 14.03.2016

CREATE TABLE auditoriacontanalimpacnegocio (
	id INT4 NOT NULL,
	idauditoriacontinuidade BIGINT NOT NULL,
	acaoauditoria CHAR(1) NULL,
	idanaliseimpactonegocio BIGINT NOT NULL,
	idfuncaovital BIGINT NOT NULL,
	nomefuncaovital VARCHAR(255) NOT NULL,
	impacto CHARACTER VARYING(255),
	severidade CHAR(1),
	custohora DOUBLE PRECISION,
	custoimpacto DOUBLE PRECISION,
	maxtoleravelinatividade VARCHAR(8),
	objtemporecuperacao VARCHAR(8),
	objpontorecuperacao VARCHAR(8),
	estrategia1 TEXT,
	estrategia2 TEXT,
	estrategia3 TEXT,
	PRIMARY KEY (id),
	FOREIGN KEY (idauditoriacontinuidade) REFERENCES auditoriacontinuidade (idauditoriacontinuidade)
);

-- FIM [deborah.ferreira] - 14.03.2016

-- INICIO - rodrigo.acorse - 14.03.2016

CREATE TABLE calendarioeventoteste (
	ideventoteste bigint not null,
	idevento bigint not null,
	idplanoteste bigint not null,
	situacao char(1),
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventoteste),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idplanoteste) REFERENCES planoteste (idplanoteste)
);

CREATE TABLE calendarioeventoconhecimento (
	ideventoconhecimento bigint not null,
	idevento bigint not null,
	idbaseconhecimento int not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (ideventoconhecimento),
	FOREIGN KEY (idevento) REFERENCES calendarioevento (idevento),
	FOREIGN KEY (idbaseconhecimento) REFERENCES baseconhecimento (idbaseconhecimento)
);

-- FIM - rodrigo.acorse - 14.03.2016

-- INICIO - thyen.chang - 15.03.2016

ALTER TABLE HISTORICOBASECONHECIMENTO ADD TIPODOCUMENTO VARCHAR(3);

ALTER TABLE HISTORICOBASECONHECIMENTO ADD ERROCONHECIDO VARCHAR(1);

UPDATE HISTORICOBASECONHECIMENTO SET TIPODOCUMENTO = (CASE WHEN FAQ = 'S' THEN 'F' WHEN ERROCONHECIDO = 'S' THEN 'E' ELSE 'D' END);

ALTER TABLE CONHECIMENTOIC DROP CONSTRAINT conhecimentoic_idbaseconhecimento_fkey;

ALTER TABLE conhecimentoliberacao DROP CONSTRAINT fk_ref_conhlib_bas;

ALTER TABLE conhecimentomudanca DROP CONSTRAINT conhecimentomudanca_idbaseconhecimento_fkey;

ALTER TABLE conhecimentoproblema DROP CONSTRAINT conhecimentoproblema_idbaseconhecimento_fkey;

ALTER TABLE conhecimentosolicitacaoservico DROP CONSTRAINT conhecimentosolicitacaoservico_idbaseconhecimento_fkey;

CREATE TABLE grupoiccalendario (
	idgrupoitemconfiguracao INTEGER NOT NULL
	,idcalendario INTEGER NOT NULL
	,constraint fk_grpiccld_grpic foreign key (idgrupoitemconfiguracao) references grupoitemconfiguracao (idgrupoitemconfiguracao)
	,constraint fk_grpiccld_cld foreign key (idcalendario) references calendario (idcalendario)
);

CREATE TABLE grupoiccacordonivelservico (
	idgrupoitemconfiguracao INTEGER NOT NULL
	,idacordonivelservico INT8 NOT NULL
	,constraint fk_grpicans_grpic foreign key (idgrupoitemconfiguracao) references grupoitemconfiguracao (idgrupoitemconfiguracao)
	,constraint fk_grpicans_ans foreign key (idacordonivelservico) references acordonivelservico (idacordonivelservico)
);

CREATE TABLE iccalendario (
	iditemconfiguracao INTEGER NOT NULL
	,idcalendario INTEGER NOT NULL
	,constraint fk_iccld_grpic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao)
	,constraint fk_iccld_cld foreign key (idcalendario) references calendario (idcalendario)
);

CREATE TABLE iccacordonivelservico (
	iditemconfiguracao INTEGER NOT NULL
	,idacordonivelservico INT8 NOT NULL
	,constraint fk_icans_grpic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao)
	,constraint fk_icans_ans foreign key (idacordonivelservico) references acordonivelservico (idacordonivelservico)
);

-- FIM - thyen.chang - 15.03.2016

-- INICIO - gustavo.gomes - 14.03.2016

CREATE TABLE ocorrenciaservicodemanda(
	idocorrenciaservicodemanda BIGINT NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nome VARCHAR(255) NOT NULL,
	valor VARCHAR(255) NOT NULL,
	PRIMARY KEY (idocorrenciaservicodemanda),
	constraint fk_idocorenciaservico foreign key (idocorrenciaservico) references ocorrenciaservico(idocorrenciaservico)

);

CREATE TABLE ocorrenciaservicocapacidade(
	idocorrenciaservicocapacidade BIGINT NOT NULL,
	idocorrenciaservico BIGINT NOT NULL,
	acaoocorrenciaservico CHAR(1) NULL,
	nome VARCHAR(255) NOT NULL,
	valor VARCHAR(255) NOT NULL,
	PRIMARY KEY (idocorrenciaservicocapacidade),
	constraint fk_idocorenciaservico foreign key (idocorrenciaservico) references ocorrenciaservico(idocorrenciaservico)

);

CREATE TABLE invocacao(
	idinvocacao bigint not null,
	idcontinuidade bigint not null,
	idcliente bigint not null,
	idsolicitacao bigint not null,
	nomeservico VARCHAR(255),
	idgrupoexecuto bigint,
	idresponsavel bigint,
	tipo VARCHAR(1),
	idsolicitacaorelacionado bigint,
	nomeprocedimento VARCHAR(255),
	PRIMARY KEY (idinvocacao),
	CONSTRAINT fk_continuidade FOREIGN KEY (idcontinuidade) REFERENCES CONTINUIDADE (idcontinuidade),
	CONSTRAINT fk_cliente FOREIGN KEY (idcliente) REFERENCES CLIENTES (idcliente),
	CONSTRAINT fk_solicitacao FOREIGN KEY (idsolicitacao) REFERENCES SOLICITACAOSERVICO (idsolicitacaoservico),
	CONSTRAINT fk_grupo FOREIGN KEY (idgrupoexecuto) REFERENCES GRUPO (idgrupo),
	CONSTRAINT fk_usuario FOREIGN KEY (idresponsavel) REFERENCES USUARIO (idusuario),
	CONSTRAINT fk_solicitacao_relacionado FOREIGN KEY (idsolicitacaorelacionado) REFERENCES SOLICITACAOSERVICO (idsolicitacaoservico)
);

-- FIM - gustavo.gomes - 21.03.2016

-- INCIO - douglas.japiassu - 21.03.2016

alter table situacaoservico add ativo integer not null default 2;

update situacaoservico set ativo = (case when (upper(nomesituacaoservico) = upper('ativo') or upper(nomesituacaoservico) = upper('active')) then 1 else 2 end);

update menu set datafim = now() where nome = '$menu.nome.ligacoesExternas';

update menu set datafim = now() where nome in ('$menu.nome.pesquisaFAQ', '$menu.nome.pesquisaErroConhecido');

alter table requisicaomudanca add column votacaorequisicaoaprovadaaux char(1);

-- FIM - douglas.japiassu - 21.03.2016

-- INICIO - joao.morais - 22/03/2016

ALTER TABLE planocontinuidade ALTER COLUMN descricao TYPE TEXT;
ALTER TABLE planocontinuidade ALTER COLUMN descricao DROP NOT NULL;
ALTER TABLE planocontinuidade ALTER COLUMN descricao SET DEFAULT '';

-- FIM - joao.morais - 22/03/2016

-- INCIO - thyen.chang - 22.03.2016

ALTER TABLE auditoriaitemconfig ADD idtipoitemconfiguracao INT4;

-- FIM - thyen.chang - 22.03.2016

-- INICIO - [euler.ramos] - 22.03.2016
-- Modelos e-mail para Fluxo de Procedimento

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ($id_modeloemail_01, 'CITSMART - Procedure Started - Number: ${IDSOLICITACAOSERVICO}', 
'COMMUNICATION<br /><br />Please be advised that started the ${IDSOLICITACAOSERVICO} continuity procedure to solve the ${IDSOLICITACAORELACIONADA} critic icident, <br />as the data below:<br /><br />Number: <strong>${IDSOLICITACAOSERVICO}</strong><br />Procedure: <strong>${SERVICO}</strong><br />Date/Hour: <strong>${DATAHORASOLICITACAO}</strong><br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Best regards,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'startedContinuityPr');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ($id_modeloemail_02, 'CITSMART - Procedure executed - Number: ${IDSOLICITACAOSERVICO}', 
'COMMUNICATION<br /><br />Please be advised that the ${IDSOLICITACAOSERVICO} continuity procedure it was executed,<br />as the data below:<br /><br />Number: ${IDSOLICITACAOSERVICO}<br />Procedure: ${SERVICO}<br />Date/Hour: ${DATAHORASOLICITACAO}<br />Critic Icident: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Best regards,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'executedContinuityPr');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ($id_modeloemail_03, 'CITSMART - Continuty Procedure it was restarted - Number: ${IDSOLICITACAOSERVICO}', 
'Exception<br /><br />Please be advised that the ${IDSOLICITACAOSERVICO} continuity procedure failed and it was restarted,<br />as the data below:<br /><br />Number: ${IDSOLICITACAOSERVICO}<br />Procedure: ${SERVICO}<br />Date/Hour: ${DATAHORASOLICITACAO}<br />Critic Icident: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Best regards,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'failProcedureCont');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ($id_modeloemail_04, 'CITSMART - Continuty Procedure it was finished - Number: ${IDSOLICITACAOSERVICO}', 
'COMMUNICATION<br /><br />Please be advised that the ${IDSOLICITACAOSERVICO} continuity procedure it was finished,<br />as the data below:<br /><br />Number: ${IDSOLICITACAOSERVICO}<br />Procedure: ${SERVICO}<br />Date/Hour: ${DATAHORASOLICITACAO}<br />Critic Icident: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Best regards,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'finishContinuityProc');

alter table modelosemails alter column identificador type varchar(50);

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ($id_modeloemail_05, 'CITSMART - Procedimento iniciado - Nmero: ${IDSOLICITACAOSERVICO}', 
'AVISO<br /><br />Por favor, esteja ciente que foi iniciado o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} afim de resolver o incidente crtico ${IDSOLICITACAORELACIONADA}, <br />conforme os dados abaixo:<br /><br />Nmero: <strong>${IDSOLICITACAOSERVICO}</strong><br />Procedimento: <strong>${SERVICO}</strong><br />Data/Hora: <strong>${DATAHORASOLICITACAO}</strong><br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br /><br />Atenciosamente,<br /><br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeIniciado');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ($id_modeloemail_06, 'CITSMART - Procedimento executado - Nmero: ${IDSOLICITACAOSERVICO}', 
'AVISO<br /><br />Por favor, esteja ciente que o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} foi executado,<br />conforme os dados abaixo:<br /><br />Nmero: ${IDSOLICITACAOSERVICO}<br />Procedimento: ${SERVICO}<br />Data/Hora: ${DATAHORASOLICITACAO}<br />Incidente Crtico: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Atenciosamente,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeExecutado');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ($id_modeloemail_07, 'CITSMART - Procedimento de Continuidade foi reiniciado - Nmero: ${IDSOLICITACAOSERVICO}', 
'Exceo<br /><br />Por favor, esteja ciente que o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} falhou e foi reiniciado,<br />conforme os dados abaixo:<br /><br />Nmero: ${IDSOLICITACAOSERVICO}<br />Procedimento: ${SERVICO}<br />Data/Hora: ${DATAHORASOLICITACAO}<br />Incidente Crtico: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Atenciosamente,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeReiniciado');

insert into  modelosemails (idmodeloemail, titulo, texto, situacao, identificador) 
values ($id_modeloemail_08, 'CITSMART - Procedimento de Continuidade foi finalizado - Nmero: ${IDSOLICITACAOSERVICO}', 
'AVISO<br /><br />Por favor, esteja ciente que o Procedimento de Continuidade ${IDSOLICITACAOSERVICO} foi finalizado,<br />conforme os dados abaixo:<br /><br />Nmero: ${IDSOLICITACAOSERVICO}<br />Procedimento: ${SERVICO}<br />Data/Hora: ${DATAHORASOLICITACAO}<br />Incidente Crtico: ${IDSOLICITACAORELACIONADA}<br /><br />${INFORMACOESCOMPLEMENTARESHTML}<br /><br />Atenciosamente,<br />Central IT Tecnologia da Informa&ccedil;&atilde;o Ltda.<br />', 
'A', 'procContinuidadeFinalizado');

CREATE TABLE liberacaosolicitacaoservico 
( 
  idliberacaosolicitacaoservico bigint NOT NULL, 
  idliberacao integer NOT NULL, 
  idsolicitacaoservico bigint NOT NULL, 
  datafim date, 
  PRIMARY KEY (idliberacaosolicitacaoservico), 
  FOREIGN KEY (idliberacao) REFERENCES liberacao (idliberacao) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT, 
  FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT 
);

-- FIM [euler.ramos] - 22.03.2016

-- INCIO - deborah.ferreira - 22.03.2016

ALTER TABLE invocacao ALTER COLUMN idcliente DROP NOT NULL;
ALTER TABLE invocacao DROP COLUMN tipo;
ALTER TABLE invocacao DROP COLUMN nomeprocedimento;
ALTER TABLE invocacao RENAME COLUMN idgrupoexecuto TO idgrupoexecutor;
ALTER TABLE invocacao ADD idgrupoaprovador BIGINT;
ALTER TABLE invocacao ADD situacao VARCHAR(20);
ALTER TABLE invocacao ADD CONSTRAINT fk_invocacao_grupo_ap FOREIGN KEY (idgrupoaprovador) references grupo (idgrupo);
ALTER TABLE invocacao RENAME CONSTRAINT fk_continuidade TO fk_invocacao_continuidade;
ALTER TABLE invocacao RENAME CONSTRAINT fk_cliente TO fk_invocacao_cliente;
ALTER TABLE invocacao RENAME CONSTRAINT fk_solicitacao TO fk_invocacao_solicitacao;
ALTER TABLE invocacao RENAME CONSTRAINT fk_solicitacao_relacionado TO fk_invocacao_solicitacao_rel;
ALTER TABLE invocacao RENAME CONSTRAINT fk_grupo TO fk_invocacao_grupo_ex;
ALTER TABLE invocacao RENAME CONSTRAINT fk_usuario TO fk_invocacao_usuario;

ALTER TABLE auditoriacontinvocacao RENAME COLUMN nomegrupoatual TO nomegrupoexecutor;
ALTER TABLE auditoriacontinvocacao ADD nomegrupoaprovador VARCHAR(255);
ALTER TABLE auditoriacontinvocacao ALTER COLUMN nomeresponsavel DROP NOT NULL;

ALTER TABLE planocontinuidade ADD versao DOUBLE PRECISION NOT NULL DEFAULT 1.0;
ALTER TABLE auditoriaplanocontinuidade ADD versao DOUBLE PRECISION;

ALTER TABLE acordonivelservico ADD sazonalidade VARCHAR(255);
-- FIM - deborah.ferreira - 22.03.2016

-- INCIO - [douglas.japiassu] - 28.03.2016

ALTER TABLE escalonamento ADD tipodataescalonamento integer;
UPDATE escalonamento SET tipodataescalonamento = (select re.tipodataescalonamento from regraescalonamento re where re.idregraescalonamento = escalonamento.idregraescalonamento);
ALTER TABLE regraescalonamento ADD tipodatanotificacaoemail integer;
UPDATE regraescalonamento SET tipodatanotificacaoemail = 1;
ALTER TABLE regraescalonamento ADD tipodataproblema integer;
UPDATE regraescalonamento SET tipodatanotificacaoemail = 2;
ALTER TABLE regraescalonamento ALTER COLUMN intervalonotificacao DROP NOT NULL;

-- FIM - [douglas.japiassu] - 28.03.2016 

-- INCIO - [gilmar.jnior] - 28.03.2016
CREATE TABLE baseconhecimentosla (
	idbaseconhecimentosla bigint not null,
	idbaseconhecimento int not null,
	idacordonivelservico bigint not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idbaseconhecimentosla),
	FOREIGN KEY (idbaseconhecimento) REFERENCES baseconhecimento (idbaseconhecimento),
	FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico)
);
 
-- FIM - [gilmar.jnior] - 28.03.2016 

-- INCIO - [douglas.japiassu] - 30.03.2016

CREATE TABLE permissaoacessopagina (
	idperfilacesso integer not null,
	caminho varchar(255) not null,
	pesquisa char(1),
	grava char(1),
	deleta char(1),
	tipoperfilacesso smallint,
	ordem smallint,
	PRIMARY KEY (idperfilacesso,caminho),
	CONSTRAINT fk_perfilacesso FOREIGN KEY (idperfilacesso) REFERENCES PERFILACESSO (idperfil)
);

CREATE TABLE servicocontratoans (
	idservicocontratoans integer not null,
	idservicocontrato bigint  not null,
	idacordonivelservico int8 not null,
	datainicio date not null,
	datafim date,
	PRIMARY KEY (idservicocontratoans),
	CONSTRAINT fk_servicocontrato FOREIGN KEY (idservicocontrato) REFERENCES servicocontrato (idservicocontrato),
	CONSTRAINT fk_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico)
);

-- FIM - [douglas.japiassu] - 30.03.2016 

-- INCIO - [pedro.francisco] - 29.03.2016

ALTER TABLE modelosemails ADD idprocesso integer;

-- FIM - [pedro.francisco] - 29.03.2016

-- INCIO - [rodrigo.acorse] - 01.04.2016

alter table itemconfiguracao add custohoraindisponibilidade decimal(10,2);
alter table historicoic add custohoraindisponibilidade decimal(10,2);

-- FIM - [rodrigo.acorse] - 01.04.2016

-- INCIO - [deborah.ferreira] - 02.04.2016

ALTER TABLE servicocontrato ADD custohoraindisponibilidade DECIMAL(10,2);

CREATE TABLE servicocontratocalendario (
	idservicocontratocalendario INT4 NOT NULL,
	idservicocontrato BIGINT NOT NULL,
	idcalendario INT4 NOT NULL,
	datainicio DATE NOT NULL,
	datafim DATE,
	PRIMARY KEY (idservicocontratocalendario),
	CONSTRAINT fk_contratocal_servicocontrato FOREIGN KEY (idservicocontrato) REFERENCES servicocontrato (idservicocontrato),
	CONSTRAINT fk_contratocal_calendario FOREIGN KEY (idcalendario) REFERENCES calendario (idcalendario)
);

ALTER TABLE jornadatrabalho ADD tipohorario INTEGER DEFAULT 1 NOT NULL;

-- FIM - [deborah.ferreira] - 02.04.2016

-- INICIO - thyen.chang - 02.04.2016

CREATE TABLE grupodisponibilidade (
	idgrupodisponibilidade INTEGER NOT NULL
	, nome VARCHAR(255) NOT NULL
	, acordodisponibilidade DECIMAL NOT NULL
	, valor DECIMAL NOT NULL
	, idcalendario INTEGER NOT NULL
	, datafim DATE
	, PRIMARY KEY (idgrupodisponibilidade)
	, CONSTRAINT fk_grpdisp_calend FOREIGN KEY (idcalendario) REFERENCES calendario (idcalendario)
);

CREATE TABLE grupodisponibilidadeic (
	idgrupodisponibilidadeic INTEGER NOT NULL
	, idgrupodisponibilidade INTEGER NOT NULL
	, iditemconfiguracao INTEGER NOT NULL
	, PRIMARY KEY (idgrupodisponibilidadeic)
	, CONSTRAINT fk_grpdispic_grpdisp FOREIGN KEY (idgrupodisponibilidade) REFERENCES grupodisponibilidade (idgrupodisponibilidade)
	, CONSTRAINT fk_grpdispic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES itemconfiguracao (iditemconfiguracao)
);

CREATE TABLE grupoicvalorindisp (
	idgrupoicvalorindisp INTEGER NOT NULL
	, idgrupoitemconfiguracao INTEGER NOT NULL
	, valor DECIMAL NOT NULL
	, PRIMARY KEY (idgrupoicvalorindisp)
);

ALTER TABLE grupoiccalendario DROP CONSTRAINT fk_grpiccld_grpic;

ALTER TABLE grupoiccacordonivelservico DROP CONSTRAINT fk_grpicans_grpic;
-- FIM - thyen.chang - 02.04.2016

-- INCIO - gilmar.junior - 06.04.2016
ALTER TABLE clientes ALTER COLUMN cpfcnpj DROP NOT NULL;
ALTER TABLE clientes ALTER COLUMN cpfcnpj type varchar(255);
ALTER TABLE clientes ALTER COLUMN cpfcnpj SET DEFAULT NULL;

ALTER TABLE dadosbancariosintegrante ALTER COLUMN cpf DROP NOT NULL;
ALTER TABLE dadosbancariosintegrante ALTER COLUMN cpf type varchar(255);
ALTER TABLE dadosbancariosintegrante ALTER COLUMN cpf SET DEFAULT NULL;

ALTER TABLE empregados ALTER COLUMN cpf DROP NOT NULL;
ALTER TABLE empregados ALTER COLUMN cpf type varchar(255);
ALTER TABLE empregados ALTER COLUMN cpf SET DEFAULT NULL;

ALTER TABLE fornecedor ALTER COLUMN cnpj DROP NOT NULL;
ALTER TABLE fornecedor ALTER COLUMN cnpj type varchar(255);
ALTER TABLE fornecedor ALTER COLUMN cnpj SET DEFAULT NULL;

ALTER TABLE pessoa ALTER COLUMN cpf DROP NOT NULL;
ALTER TABLE pessoa ALTER COLUMN cpf type varchar(255);
ALTER TABLE pessoa ALTER COLUMN cpf SET DEFAULT NULL;

ALTER TABLE rh_candidato ALTER COLUMN cpf DROP NOT NULL;
ALTER TABLE rh_candidato ALTER COLUMN cpf type varchar(255);
ALTER TABLE rh_candidato ALTER COLUMN cpf SET DEFAULT NULL;

ALTER TABLE rh_curriculo ALTER COLUMN cpf DROP NOT NULL;
ALTER TABLE rh_curriculo ALTER COLUMN cpf type varchar(255);
ALTER TABLE rh_curriculo ALTER COLUMN cpf SET DEFAULT NULL;

ALTER TABLE rh_funcionario ALTER COLUMN cpf DROP NOT NULL;
ALTER TABLE rh_funcionario ALTER COLUMN cpf type varchar(255);
ALTER TABLE rh_funcionario ALTER COLUMN cpf SET DEFAULT NULL;
-- FIM - gilmar.junior - 06.04.2016

-- INICIO - gustavo.gomes - 07.04.2016
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.incidente' WHERE idmodulosistema = 1;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.requisicao' WHERE idmodulosistema = 2;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.mudanca' WHERE idmodulosistema = 3;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.evento' WHERE idmodulosistema = 4;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.continuidade' WHERE idmodulosistema = 5;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.conhecimento' WHERE idmodulosistema = 6;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.sla' WHERE idmodulosistema = 7;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.problema' WHERE idmodulosistema = 8;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.capacidade' WHERE idmodulosistema = 9;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.portfolio' WHERE idmodulosistema = 10;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.aivosconf' WHERE idmodulosistema = 11;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.gerencservicos' WHERE idmodulosistema = 12;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.liberacao' WHERE idmodulosistema = 13;
UPDATE modulosistema SET nomemodulosistema = 'modulosistema.disponibilidade' WHERE idmodulosistema = 14;
-- FIM - gustavo.gomes - 07.04.2016

-- INCIO - gilmar.junior - 07-04-2016
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.incidentesRequisicoes' WHERE identificacao ILIKE 'INCREQ001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.ativosConfiguracao' WHERE identificacao ILIKE 'ATVCFG001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.baseConhecimento' WHERE identificacao ILIKE 'BASECG001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.niveisServico' WHERE identificacao ILIKE 'NIVELS001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.problemas' WHERE identificacao ILIKE 'PROBL001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.mudancas' WHERE identificacao ILIKE 'MUDAN001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.liberacao' WHERE identificacao ILIKE 'LIBER001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.catalogoServicos' WHERE identificacao ILIKE 'CATAL001';
UPDATE bi_categorias SET nomecategoria = 'consultasRelatorios.categoria.projetos' WHERE identificacao ILIKE 'PROJET001';
-- FIM - gilmar.junior - 07-04-2016
-- INCIO - gilmar.junior - 07-04-2016
UPDATE programacaoatividade SET tipoagendamento = '1' WHERE tipoagendamento ILIKE 'D';
UPDATE programacaoatividade SET tipoagendamento = '2' WHERE tipoagendamento ILIKE 'S';
UPDATE programacaoatividade SET tipoagendamento = '3' WHERE tipoagendamento ILIKE 'M';
UPDATE programacaoatividade SET tipoagendamento = '4' WHERE tipoagendamento ILIKE 'U';
-- FIM - gilmar.junior - 07-04-2016


-- INCIO - joao.morais - 13.04.2016
ALTER TABLE controlecontrato ADD COLUMN datainicio2 date;
UPDATE controlecontrato SET datainicio2 = datainicio;
ALTER TABLE controlecontrato DROP COLUMN datainicio;
ALTER TABLE controlecontrato RENAME COLUMN datainicio2 to dataincio;

ALTER TABLE controlecontrato ALTER COLUMN datainicio type date using to_date(datainicio, 'YYYY-MM-DD');

-- FIM - joao.morais - 13.04.2016

-- INCIO - gustavo.gomes - 13.04.2016
ALTER TABLE regraescalonamento ALTER COLUMN tipodataescalonamento DROP NOT NULL;
-- FIM - gustavo.gomes - 13.04.2016

-- INCIO - joao.morais - 30.05.2016

alter table evm_acao_incidenterequisicao add column idcategoriaservico int4 null;
alter table evm_acao_incidenterequisicao add column idtipocatalogoservicosoli varchar(1) null;
alter table evm_acao_incidenterequisicao add column idServicoNegocioTecBusc int8 null;
alter table evm_acao_incidenterequisicao add column utilizaCategoriaServico varchar(1) null;

update menu set datafim = now() 
where nome in(
	'$menu.nome.gerenciaBaseConhecimento',
	'$menu.nome.gerenciaConfiguracaoIncidenteRequisicoes');

-- FIM - joao.morais - 30.05.2016

-- INCIO - deborah.ferreira - 13.06.2016

ALTER TABLE permissaoacessopagina ADD tipoperfilacesso smallint;
ALTER TABLE permissaoacessopagina ADD ordem smallint;
UPDATE permissaoacessopagina SET tipoperfilacesso = 1 WHERE tipoperfilacesso IS NULL AND caminho LIKE '%gerenciamentoContinuidade%';

-- FIM - deborah.ferreira - 13.06.2016

-- INICIO - joao.morais - 16.06.2016

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacao.jsp', 'S', 'S', 'S', 1, 1);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacaoPolitica.jsp', 'S', 'S', 'S', 1, 2);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacaoEscopo.jsp', 'S', 'S', 'S', 1, 3);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/iniciacao/iniciacaoProjeto.jsp', 'S', 'S', 'S', 1, 4);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategia.jsp', 'S', 'S', 'S', 1, 5);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaFuncoesVitais.jsp', 'S', 'S', 'S', 1, 6);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaImpactoNegocio.jsp', 'S', 'S', 'S', 1, 7);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaAvaliacaoRiscos.jsp', 'S', 'S', 'S', 1, 8);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/requisitosEstrategia/requisitosEstrategiaEstrategiaContinuidade.jsp', 'S', 'S', 'S', 1, 9);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacao.jsp', 'S', 'S', 'S', 1, 10);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacaoPlanosContinuidade.jsp', 'S', 'S', 'S', 1, 11);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacaoPlanejamentoOrganizacional.jsp', 'S', 'S', 'S', 1, 12);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/implementacao/implementacaoEstrategiaTestes.jsp', 'S', 'S', 'S', 1, 13);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinua.jsp', 'S', 'S', 'S', 1, 14);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaConscientizacao.jsp', 'S', 'S', 'S', 1, 15);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaRevisaoAuditoria.jsp', 'S', 'S', 'S', 1, 16);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaTestes.jsp', 'S', 'S', 'S', 1, 17);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoContinuidade/operacaoContinua/operacaoContinuaInvocacao.jsp', 'S', 'S', 'S', 1, 18);

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroPortfolio/gerenciamentoPortfolioCadastroPortfolio.jsp', 'S', 'S', 'S', 2, 0);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoNegocio/gerenciamentoPortfolioServicoNegocio.jsp', 'S', 'S', 'S', 2, 1);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoServicoNegocio/gerenciamentoPortfolioInfoServicoNegocio.jsp', 'S', 'S', 'S', 2, 2);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoNegocio/gerenciamentoPortfolioCadastroServicoNegocio.jsp', 'S', 'S', 'S', 2, 3);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioRNS/gerenciamentoPortfolioRNS.jsp', 'S', 'S', 'S', 2, 4);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAtributosFinanceiros/gerenciamentoPortfolioAtributosFinanceiros.jsp', 'S', 'S', 'S', 2, 5);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCasoNegocio/gerenciamentoPortfolioCasoNegocio.jsp', 'S', 'S', 'S', 2, 6);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoNegocio/gerenciamentoPortfolioMapaDesenhoNegocio.jsp', 'S', 'S', 'S', 2, 7);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioProcessoNegocio/gerenciamentoPortfolioProcessoNegocio.jsp', 'S', 'S', 'S', 2, 8);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoio/gerenciamentoPortfolioServicoApoio.jsp', 'S', 'S', 'S', 2, 9);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioDonoNegocio/gerenciamentoPortfolioDonoNegocio.jsp', 'S', 'S', 'S', 2, 10);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioBusinessUser/gerenciamentoPortfolioBusinessUser.jsp', 'S', 'S', 'S', 2, 11);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoRequisicaoNegocio/gerenciamentoPortfolioServicoRequisicaoNegocio.jsp', 'S', 'S', 'S', 2, 12);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAplicacoes/gerenciamentoPortfolioAplicacoes.jsp', 'S', 'S', 'S', 2, 13);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioEsquemaDados/gerenciamentoPortfolioEsquemaDados.jsp', 'S', 'S', 'S', 2, 14);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoIncidenteNegocio/gerenciamentoPortfolioServicoIncidenteNegocio.jsp', 'S', 'S', 'S', 2, 15);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoProcedimento/gerenciamentoPortfolioServicoProcedimento.jsp', 'S', 'S', 'S', 2, 16);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratos/gerenciamentoPortfolioContratos.jsp', 'S', 'S', 'S', 2, 17);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioProprietarios/gerenciamentoPortfolioProprietarios.jsp', 'S', 'S', 'S', 2, 18);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioConhecimento/gerenciamentoPortfolioConhecimento.jsp', 'S', 'S', 'S', 2, 19);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioHabilidade/gerenciamentoPortfolioHabilidade.jsp', 'S', 'S', 'S', 2, 20);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioIndicadorCapacidade/gerenciamentoPortfolioIndicadorCapacidade.jsp', 'S', 'S', 'S', 2, 21);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioAtributoDemanda/gerenciamentoPortfolioAtributoDemanda.jsp', 'S', 'S', 'S', 2, 22);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioOcorrenciasServico/gerenciamentoPortfolioOcorrenciasServico.jsp', 'S', 'S', 'S', 2, 23);

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoServicoApoio/gerenciamentoPortfolioInfoServicoApoio.jsp', 'S', 'S', 'S', 2, 24);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroServicoApoio/gerenciamentoPortfolioCadastroServicoApoio.jsp', 'S', 'S', 'S', 2, 25);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioMapaDesenhoApoio/gerenciamentoPortfolioMapaDesenhoApoio.jsp', 'S', 'S', 'S', 2, 26);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoApoioApoio/gerenciamentoPortfolioServicoApoioApoio.jsp', 'S', 'S', 'S', 2, 27);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoRequisicaoApoio/gerenciamentoPortfolioServicoRequisicaoApoio.jsp', 'S', 'S', 'S', 2, 28);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoIncidenteApoio/gerenciamentoPortfolioServicoIncidenteApoio.jsp', 'S', 'S', 'S', 2, 29);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosApoio/gerenciamentoPortfolioContratosApoio.jsp', 'S', 'S', 'S', 2, 30);

insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioInfoContrato/gerenciamentoPortfolioInfoContrato.jsp', 'S', 'S', 'S', 2, 31);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosDetalhes/gerenciamentoPortfolioContratosDetalhes.jsp', 'S', 'S', 'S', 2, 32);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoRequisicao/gerenciamentoPortfolioContratosServicoRequisicao.jsp', 'S', 'S', 'S', 2, 33);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoIncidente/gerenciamentoPortfolioContratosServicoIncidente.jsp', 'S', 'S', 'S', 2, 34);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosServicoProcedimento/gerenciamentoPortfolioContratosServicoProcedimento.jsp', 'S', 'S', 'S', 2, 35);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosCustoDisponibilidade/gerenciamentoPortfolioContratosCustoDisponibilidade.jsp', 'S', 'S', 'S', 2, 36);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoContratoANS/gerenciamentoPortfolioServicoContratoANS.jsp', 'S', 'S', 'S', 2, 37);
insert into permissaoAcessoPagina values (1, '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioContratosCalendario/gerenciamentoPortfolioContratosCalendario.jsp', 'S', 'S', 'S', 2, 38);

-- FIM - joao.morais - 16.06.2016

-- INICIO - euler.ramos - 22.06.2016

alter table unidade add idcalendario integer;

-- FIM - euler.ramos - 22.06.2016

-- INICIO - deborah.ferreira - 06.07.2016

DELETE FROM menu WHERE nome = '$menu.nome.cargaCatalogoServico';
DELETE FROM menu WHERE nome = '$menu.nome.tipoSolicitacaoServico';

-- FIM - deborah.ferreira - 06.07.2016

-- INCIO - rodrigo.acorse - 15.06.2016
	
ALTER TABLE evm_gerenciado_inventory ADD COLUMN autocorrecao bpchar DEFAULT NULL::bpchar;
ALTER TABLE evm_gerenciado_inventory ADD COLUMN autocorrecaoquantidade int4;

ALTER TABLE evm_gerenciado_nagios ADD COLUMN autocorrecao bpchar DEFAULT NULL::bpchar;
ALTER TABLE evm_gerenciado_nagios ADD COLUMN autocorrecaoquantidade int4;

ALTER TABLE evm_gerenciado_zabbix ADD COLUMN autocorrecao bpchar DEFAULT NULL::bpchar;
ALTER TABLE evm_gerenciado_zabbix ADD COLUMN autocorrecaoquantidade int4;

-- FIM - rodrigo.acorse - 15.06.2016

-- INCIO - rodrigo.acorse - 01.07.2016

ALTER TABLE evm_inventory_configuracao ADD COLUMN ignoraricsinventariados char(1);
ALTER TABLE evm_inventory_configuracao ADD COLUMN tempoignorarics integer;
ALTER TABLE evm_inventory_configuracao ADD COLUMN tipoignorarics integer;

-- FIM - rodrigo.acorse - 01.07.2016

-- INICIO - deborah.ferreira - 25.07.2016

UPDATE categoriaservico SET tipocategoria = 'I' WHERE tipocategoria = 'R';

-- FIM - deborah.ferreira - 25.07.2016

-- INCIO - gilmar.junior - 03.08.2016
ALTER TABLE evm_cron ALTER COLUMN datahorainicio TYPE TIMESTAMP;
ALTER TABLE evm_cron ALTER COLUMN datahorafim TYPE TIMESTAMP;
ALTER TABLE evm_cron ALTER COLUMN datahoraultimaalteracao TYPE TIMESTAMP;

ALTER TABLE evm_inventory_configuracao ALTER COLUMN datahorainicio TYPE TIMESTAMP;
ALTER TABLE evm_inventory_configuracao ALTER COLUMN datahorafim TYPE TIMESTAMP;

ALTER TABLE evm_conexao ALTER COLUMN datahorainicio TYPE TIMESTAMP;
ALTER TABLE evm_conexao ALTER COLUMN datahorafim TYPE TIMESTAMP;
ALTER TABLE evm_conexao ALTER COLUMN datahoraultimaalteracao TYPE TIMESTAMP;
-- FIM - gilmar.junior - 03.08.2016

-- INCIO - rodrigo.acorse - 25.07.2016

CREATE TABLE aberturaautomaticaviaemail
(
	idconfigaberturaautomatica BIGINT NOT NULL,
	nome VARCHAR(255) NOT NULL,
	idacao BIGINT NOT NULL,
	emailservidorentrada VARCHAR(255),
	emailusuario VARCHAR(255),
	emailsenha VARCHAR(255),
	emailprovedor VARCHAR(255),
	emailporta INT,
	emailpastacaixa VARCHAR(255),
	status CHAR(1),
	datainicio DATE NOT NULL,
	datafim DATE,
	PRIMARY KEY (idconfigaberturaautomatica),
	FOREIGN KEY (idacao) REFERENCES evm_acao (idacao)
);

-- FIM - rodrigo.acorse - 25.07.2016

-- INICIO - deborah.ferreira - 08.08.2016

UPDATE permissaoAcessoPagina 
SET ordem = 0 
WHERE 
	caminho = '/pages/gerenciamentoPortfolio/gerenciamentoPortfolioCadastroPortfolio/gerenciamentoPortfolioCadastroPortfolio.jsp' 
	AND NOT EXISTS (SELECT * FROM permissaoAcessoPagina WHERE ordem = 0);

INSERT INTO permissaoAcessoPagina 
	SELECT 
		idperfilacesso,
		'/pages/gerenciamentoPortfolio/gerenciamentoPortfolioServicoNegocio/gerenciamentoPortfolioServicoNegocio.jsp',
		pesquisa, 
		grava, 
		deleta, 
		tipoperfilacesso, 
		1 
	FROM permissaoAcessoPagina 
	WHERE ordem = 2 AND tipoperfilacesso = 2 AND idperfilacesso <> 1;

-- FIM - deborah.ferreira - 08.08.2016

-- INICIO - deborah.ferreira - 16.09.2016

delete from menu where nome = '$menu.nome.comando';
delete from menu where nome = '$menu.nome.comandoSistemaOperacional';
delete from menu where nome = '$menu.nome.sistemaOperacional';
delete from menu where nome = '$gerenciamento.relatorio.pentaho.menu';
delete from menu where nome = '$relatorioKpi.relatorioKpi';
delete from menu where nome = '$relatorioKpi.titulo';
delete from menu where nome = '$relatorioEficaciaDasNasEstimativasdeServico.titulo';
delete from menu where nome = '$relatorioIncidentesNaoResolvidos.titulo';
delete from menu where nome = '$relatorioDocumentacaoDeFuncionalidadesNovasOuAlteradasNoPeriodo.title';
delete from menu where nome = '$relatorioEficaciaTeste.titulo';
delete from menu where nome = '$relatorioQI03QI04ProgramacaoDefensivaEficacia';
delete from menu where nome = '$menu.nome.catalogoServicos';
delete from menu where nome = '$menu.nome.mapaDesenhoServico';
delete from menu where nome = '$menu.nome.mapaDesenhoCatalogoNegocio';
delete from menu where nome = '$menu.nome.compras';
delete from menu where nome = '$menu.nome.categoriaProduto';
delete from menu where nome = '$menu.nome.unidadeMedida';
delete from menu where nome = '$menu.nome.tipoProduto';
delete from menu where nome = '$menu.nome.produto';
delete from menu where nome = '$menu.nome.justificativaParecer';
delete from menu where nome = '$menu.nome.cotacao';
delete from menu where nome = '$menu.nome.criterioAvaliacao';
delete from menu where nome = '$menu.nome.marca';
delete from menu where nome = '$menu.nome.avaliacaoFornecedor';
delete from menu where nome = '$menu.nome.nivelAutoridade';
delete from menu where nome = '$menu.nome.projeto';
delete from menu where nome = '$menu.nome.limiteAprovacao';
delete from menu where nome = '$menu.nome.centroResultado';
delete from menu where nome = '$menu.nome.delegacaoCentroResultado';
delete from menu where nome = '$menu.nome.delegacaoCentroResultadoResp';
delete from menu where nome = '$menu.nome.simulacaoAlcada';
delete from menu where nome = '$menu.nome.qualificacaoFornecedor';
delete from menu where nome = '$menu.nome.recursosHumanos';
delete from menu where nome = '$menu.nome.cadastrosRH.idioma';
delete from menu where nome = '$menu.nome.pesquisaCurrriculo';
delete from menu where nome = '$menu.nome.viagem';
delete from menu where nome = '$menu.nome.tipoMovimFinanceiraViagem';
delete from menu where nome = '$menu.nome.formaPagamento';
delete from menu where nome = '$menu.nome.RemarcacaoViagem';
delete from menu where nome = '$menu.adiantamentosAFazer';
delete from menu where nome = '$menu.acompanhamentoPrestacaoContas';
delete from menu where nome = '$menu.solicitacaoReembolsoPrestacao';
delete from menu where nome = '$menu.nome.bi';
delete from menu where nome = '$menu.nome.bi.exportacaoManual';
delete from menu where nome = '$menu.nome.bi.painelControle';
delete from menu where nome = '$menu.nome.bi.deParaServicosBI';
delete from menu where nome = '$menu.nome.bi.servicoCorporeBI';

-- FIM - deborah.ferreira - 16.09.2016