--INCIO - [gilberto.nery] - 28/07/2015
update menu set datafim = systimestamp where descricao like 'Cadastro de Importncia Negcio';
-- FIM - [gilberto.nery] - 28/07/2015

-- INCIO - [rodrigo.acorse] - 02/08/2016

CREATE TABLE templateincidenterequisicao
(
	idtemplateincidenterequisicao NUMBER(24,0) NOT NULL,
	nometemplate varchar(255) NOT NULL,
	idcontrato NUMBER(10,0) NOT NULL,
	idorigem NUMBER(24,0) NOT NULL,
	idsolicitante NUMBER(10,0),
	idtipodemandaservico NUMBER(10,0) NOT NULL,
	idservico NUMBER(24,0) NOT NULL,
	descricao CLOB NOT NULL,
	impacto CHAR(1 CHAR),
	urgencia CHAR(1 CHAR),
	idgrupo NUMBER(10,0),
	enviaemailcriacao CHAR(1 CHAR),
	enviaemailfinalizacao CHAR(1 CHAR),
	enviaemailacoes CHAR(1 CHAR),
	emailsolicitante VARCHAR2(254 CHAR),
	idunidade NUMBER(11,0),
	idlocalidade NUMBER(11,0),
	idcategoriaservico NUMBER(10,0),
	idtipocatalogoservicosoli VARCHAR2(1 CHAR),
	idServicoNegocioTecBusc NUMBER(24,0),
	utilizaCategoriaServico VARCHAR2(1 CHAR),
	datainicio date NOT NULL,
	datafim date,
	constraint PK_temp_ir PRIMARY KEY (idtemplateincidenterequisicao),
	constraint FK_temp_ir_contratos FOREIGN KEY (idcontrato) REFERENCES contratos (idcontrato),
	constraint FK_temp_ir_origematendimento FOREIGN KEY (idorigem) REFERENCES origematendimento (idorigem),
	constraint FK_temp_ir_empregados FOREIGN KEY (idsolicitante) REFERENCES empregados (idempregado),
	constraint FK_temp_ir_tipodemandaservico FOREIGN KEY (idtipodemandaservico) REFERENCES tipodemandaservico (idtipodemandaservico),
	constraint FK_temp_ir_servico FOREIGN KEY (idservico) REFERENCES servico (idservico),
	constraint FK_temp_ir_grupo FOREIGN KEY (idgrupo) REFERENCES grupo (idgrupo),
	constraint FK_temp_ir_unidade FOREIGN KEY (idunidade) references unidade (idunidade),
	constraint FK_temp_ir_localid FOREIGN KEY (idlocalidade) references localidade (idlocalidade)
);

-- FIM - [rodrigo.acorse] - 02/08/2016

-- INCIO - [rodrigo.acorse] - 04/08/2016

CREATE TABLE templateincidentereqic
(
	idtemplateincidentereqic NUMBER(24,0) NOT NULL,
	idtemplateincidenterequisicao NUMBER(24,0) NOT NULL,
	iditemconfiguracao NUMBER(24,0) NOT NULL,
	constraint PK_temp_ir_ic PRIMARY KEY (idtemplateincidentereqic),
	constraint FK_temp_ir_ic FOREIGN KEY (idtemplateincidenterequisicao) REFERENCES templateincidenterequisicao (idtemplateincidenterequisicao),
	constraint FK_temp_ir_ic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES itemconfiguracao (iditemconfiguracao)
);

-- FIM - [rodrigo.acorse] - 04/08/2016

--INCIO - [euler.ramos] - 02/08/2016
alter table baseconhecimento add idbaseconhecimentoorigem NUMBER(10,0);
alter table historicobaseconhecimento add idbaseconhecimentoorigem NUMBER(10,0);
-- FIM - [euler.ramos] - 02/08/2016-- FIM - [gilberto.nery] - 28/07/2015

-- INCIO - [rodrigo.acorse] - 09/08/2016

create table statusinventario
(
	idstatusinventario NUMBER(11,0) NOT NULL,
	ip VARCHAR2(50 CHAR),
	identificacao VARCHAR2(255 CHAR),
	idstatus NUMBER(11,0) NOT NULL,
	datahora TIMESTAMP NOT NULL,
	idconexao NUMBER(11,0),
	CONSTRAINT statusinventario_pkey PRIMARY KEY (idstatusinventario)
);

delete from menu where nome = '$menu.nome.evm.statusinventory';

-- FIM - [rodrigo.acorse] - 09/08/2016


--INCIO - [euler.ramos] - 26/08/2016

update historicobaseconhecimento set idusuarioalteracao = idusuarioautor where idusuarioalteracao is null;

CREATE OR REPLACE TYPE o_pasta AS OBJECT (idpasta NUMBER, idpastapai NUMBER, nivel NUMBER);

CREATE OR REPLACE TYPE t_pasta AS TABLE OF o_pasta;

CREATE OR REPLACE FUNCTION f_arvore_pastas(idRaiz NUMBER, iteracao NUMBER, nivelMaximo NUMBER) RETURN t_pasta PIPELINED IS record_obj o_pasta; 
BEGIN 
  IF (nivelMaximo > 0) THEN 
      record_obj := o_pasta(NULL,NULL,NULL); 
      IF (idRaiz>0) THEN 
          FOR consulta IN (select idpasta, case when idpastapai is null then 0 else idpastapai end idpastapai from pasta where idpasta = idRaiz and (datafim is null)) 
          LOOP 
              record_obj.idpasta := consulta.idpasta; 
			  record_obj.idpastapai := consulta.idpastapai; 
              record_obj.nivel := iteracao+1; 
              PIPE ROW (record_obj); 
              IF (iteracao < nivelMaximo - 1) THEN 
                FOR consultaFilhos IN (select idpasta, case when idpastapai is null then 0 else idpastapai end from pasta where idpastapai = consulta.idpasta and (datafim is null) order by idpasta) 
                LOOP 
                    FOR consultaRecursiva IN (select * from table(f_arvore_pastas(consultaFilhos.idpasta, iteracao + 1, nivelMaximo))) 
                    LOOP 
                        record_obj.idpasta := consultaRecursiva.idpasta; 
						record_obj.idpastapai := consultaRecursiva.idpastapai; 
                        record_obj.nivel := consultaRecursiva.nivel; 
                        PIPE ROW (record_obj); 
                    END LOOP; 
                END LOOP; 
              END IF; 
          END LOOP; 
      ELSE 
          FOR consulta IN (select idpasta from pasta where (idpastapai is null) and (datafim is null) order by idpasta) 
          LOOP 
              FOR consultaRecursiva IN (select * from table(f_arvore_pastas(consulta.idpasta, iteracao, nivelMaximo))) 
              LOOP 
                  record_obj.idpasta := consultaRecursiva.idpasta; 
				  record_obj.idpastapai := consultaRecursiva.idpastapai; 
                  record_obj.nivel := consultaRecursiva.nivel; 
                  PIPE ROW (record_obj); 
              END LOOP; 
          END LOOP; 
      END IF; 
  END IF; 
  RETURN; 
END;;

CREATE OR REPLACE TYPE o_pasta_permitida AS OBJECT (idpasta NUMBER);

CREATE OR REPLACE TYPE t_pasta_permitida AS TABLE OF o_pasta_permitida;

CREATE OR REPLACE FUNCTION f_busca_heranca_permissao(idRaiz NUMBER, iteracao NUMBER, nivelMaximo NUMBER) RETURN t_pasta_permitida PIPELINED IS record_obj o_pasta_permitida; 
BEGIN 
  IF (nivelMaximo > 0) THEN 
      record_obj := o_pasta_permitida(NULL); 
      IF (idRaiz>0) THEN 
          FOR consulta IN (select idpasta from pasta where idpasta = idRaiz and (datafim is null)) 
          LOOP 
              record_obj.idpasta := consulta.idpasta; 
              PIPE ROW (record_obj); 
              IF (iteracao < nivelMaximo - 1) THEN 
                FOR consultaFilhos IN (select idpasta from pasta where idpastapai = consulta.idpasta and ((herdapermissoes is not null) and (herdapermissoes='S')) and (datafim is null) order by idpasta) 
                LOOP 
                    FOR consultaRecursiva IN (select * from table(f_busca_heranca_permissao(consultaFilhos.idpasta, iteracao + 1, nivelMaximo))) 
                    LOOP 
                        record_obj.idpasta := consultaRecursiva.idpasta; 
                        PIPE ROW (record_obj); 
                    END LOOP; 
                END LOOP; 
              END IF; 
          END LOOP; 
      END IF; 
  END IF; 
  RETURN; 
END;;

CREATE OR REPLACE FUNCTION f_pastas_permitidas(pIdUsuario NUMBER) RETURN t_pasta_permitida PIPELINED IS record_obj o_pasta_permitida; 
BEGIN 
    record_obj := o_pasta_permitida(NULL); 
	FOR consulta IN (select distinct p.idpasta 
					 from perfilacessopasta p join ( 
						select idperfil from perfilacessousuario where idusuario = pIdUsuario and (datafim is null) 
							union 
						select pagr.idperfil from usuario u join gruposempregados ge on u.idusuario = pIdUsuario and u.idempregado = ge.idempregado 
															join perfilacessogrupo pagr on pagr.idgrupo = ge.idgrupo and (pagr.datafim is null) 
						) pfa on p.idperfil = pfa.idperfil 
					 where (p.datafim is null)) 
    LOOP 
        record_obj.idpasta := consulta.idpasta; 
        PIPE ROW (record_obj); 
        FOR consultaFilhos IN (select idpasta from pasta where idpastapai = consulta.idpasta and ((herdapermissoes is not null) and (herdapermissoes='S')) and (datafim is null) order by idpasta) 
        LOOP 
            FOR consultaRecursiva IN (select * from table(f_busca_heranca_permissao(consultaFilhos.idpasta, 0, 9000))) 
            LOOP 
                record_obj.idpasta := consultaRecursiva.idpasta; 
                PIPE ROW (record_obj); 
            END LOOP; 
        END LOOP; 
    END LOOP; 
	RETURN; 
END;;

-- FIM - [euler.ramos] - 26/08/2016