--INCIO - [gilberto.nery] - 28/07/2015
update menu set datafim = '2016-07-28' where descricao like 'Cadastro de Importncia Negcio';
-- FIM - [gilberto.nery] - 28/07/2015

--INCIO - [joao.morais] - 28/07/2015
alter table TimeSheetProjeto alter column qtdeHoras int;
-- FIM - [joao.morais] - 28/07/2015

-- INCIO - [rodrigo.acorse] - 02/08/2016

CREATE TABLE templateincidenterequisicao
(
	idtemplateincidenterequisicao bigint NOT NULL,
	nometemplate varchar(255) NOT NULL,
	idcontrato int NOT NULL,
	idorigem bigint NOT NULL,
	idsolicitante int,
	idtipodemandaservico int NOT NULL,
	idservico bigint NOT NULL,
	descricao text NOT NULL,
	impacto char(1) NULL,
	urgencia char(1) NULL,
	idgrupo int,
	enviaemailcriacao char(1) NULL,
	enviaemailfinalizacao char(1) NULL,
	enviaemailacoes char(1) NULL,
	emailsolicitante varchar(255),
	idunidade int,
	idlocalidade int,
	idcategoriaservico int,
	idtipocatalogoservicosoli varchar(1),
	idServicoNegocioTecBusc bigint,
	utilizaCategoriaServico varchar(1),
	datainicio date NOT NULL,
	datafim date,
	constraint PK_temp_ir PRIMARY KEY (idtemplateincidenterequisicao),
	constraint FK_temp_ir_contratos FOREIGN KEY (idcontrato) REFERENCES contratos (idcontrato),
	constraint FK_temp_ir_origematendimento FOREIGN KEY (idorigem) REFERENCES origematendimento (idorigem),
	constraint FK_temp_ir_empregados FOREIGN KEY (idsolicitante) REFERENCES empregados (idempregado),
	constraint FK_temp_ir_tipodemandaservico FOREIGN KEY (idtipodemandaservico) REFERENCES tipodemandaservico (idtipodemandaservico),
	constraint FK_temp_ir_servico FOREIGN KEY (idservico) REFERENCES servico (idservico),
	constraint FK_temp_ir_grupo FOREIGN KEY (idgrupo) REFERENCES grupo (idgrupo),
	constraint FK_temp_ir_unidade FOREIGN KEY (idunidade) references unidade (idunidade),
	constraint FK_temp_ir_localid FOREIGN KEY (idlocalidade) references localidade (idlocalidade)
);

-- FIM - [rodrigo.acorse] - 02/08/2016

-- INCIO - [rodrigo.acorse] - 04/08/2016

CREATE TABLE templateincidentereqic
(
	idtemplateincidentereqic bigint NOT NULL,
	idtemplateincidenterequisicao bigint NOT NULL,
	iditemconfiguracao int NOT NULL,
	constraint PK_temp_ir_ic PRIMARY KEY (idtemplateincidentereqic),
	constraint FK_temp_ir_ic FOREIGN KEY (idtemplateincidenterequisicao) REFERENCES templateincidenterequisicao (idtemplateincidenterequisicao),
	constraint FK_temp_ir_ic_ic FOREIGN KEY (iditemconfiguracao) REFERENCES itemconfiguracao (iditemconfiguracao)
);

-- FIM - [rodrigo.acorse] - 04/08/2016

--INCIO - [euler.ramos] - 02/08/2016
alter table baseconhecimento add idbaseconhecimentoorigem int;
alter table historicobaseconhecimento add idbaseconhecimentoorigem int;
-- FIM - [euler.ramos] - 02/08/2016-- FIM - [gilberto.nery] - 28/07/2015

-- INCIO - [rodrigo.acorse] - 09/08/2016

create table statusinventario
(
	idstatusinventario INTEGER NOT NULL,
	ip VARCHAR(50),
	identificacao VARCHAR(255),
	idstatus integer NOT NULL,
	datahora DATETIME NOT NULL,
	idconexao INTEGER,
	CONSTRAINT statusinventario_pkey PRIMARY KEY (idstatusinventario)
);

delete from menu where nome = '$menu.nome.evm.statusinventory';

-- FIM - [rodrigo.acorse] - 09/08/2016
-- INCIO - [gilmar.junior] - 17.08.2016
create table checkindenied (
	idcheckindenied bigint not null,
	idtarefa bigint not null references bpm_itemtrabalhofluxo(iditemtrabalho),
	idusuario int not null references usuario(idusuario),
	idjustificativa int not null references motivonegacaocheckin(idmotivo),
	latitude numeric(17, 15) not null,
	longitude numeric(18, 15) not null,
	datahora datetime2 not null default getdate(),
	constraint CheckinDenied_PK primary key (idcheckindenied)
);
-- FIM - [gilmar.junior] - 17.08.2016


--INCIO - [euler.ramos] - 26/08/2016

update historicobaseconhecimento set idusuarioalteracao = idusuarioautor where idusuarioalteracao is null;

CREATE FUNCTION f_arvore_pastas(@p_idRaiz int, @p_iteracao int, @p_nivelMaximo int) RETURNS @table_arvore_pastas TABLE (idpasta int, idpastapai int, nivel int) AS 
BEGIN 
	IF (@p_nivelMaximo <= 0) 
	BEGIN 
		return 
	END 
	DECLARE @pIdPasta int 
	DECLARE @pIdPastaPai int 
	DECLARE @pNivel int 
	IF (@p_idRaiz>0) 
		BEGIN 
			DECLARE pastas_cursor CURSOR FOR select idpasta, case when idpastapai is null then 0 else idpastapai end, cast(@p_iteracao + 1 as integer) nivel from pasta where idpasta = @p_idRaiz and (datafim is null) 
			OPEN pastas_cursor 
			FETCH NEXT FROM pastas_cursor INTO @pIdPasta, @pIdPastaPai, @pNivel 
			WHILE @@FETCH_STATUS = 0 
			BEGIN 
				INSERT INTO @table_arvore_pastas (idpasta,idpastapai,nivel) values (@pIdPasta, @pIdPastaPai, @pNivel) 
				IF (@p_iteracao < @p_nivelMaximo - 1) 
					BEGIN 
						DECLARE pastasFilhas_cursor CURSOR FOR select idpasta, case when idpastapai is null then 0 else idpastapai end, cast(@p_iteracao + 1 as integer) nivel from pasta where idpastapai = @pIdPasta and (datafim is null) order by idpasta 
						OPEN pastasFilhas_cursor 
						FETCH NEXT FROM pastasFilhas_cursor INTO @pIdPasta, @pIdPastaPai, @pNivel 
						WHILE @@FETCH_STATUS = 0 
						BEGIN 
							INSERT INTO @table_arvore_pastas (idpasta,idpastapai,nivel) 
							select idpasta,idpastapai,nivel from f_arvore_pastas(@pIdPasta, @p_iteracao + 1, @p_nivelMaximo) 
							FETCH NEXT FROM pastasFilhas_cursor INTO @pIdPasta, @pIdPastaPai, @pNivel 
						END 
						CLOSE pastasFilhas_cursor 
						DEALLOCATE pastasFilhas_cursor 
					END 
 				FETCH NEXT FROM pastas_cursor INTO @pIdPasta, @pIdPastaPai, @pNivel 
			END 
			CLOSE pastas_cursor 
			DEALLOCATE pastas_cursor 
		END 
	ELSE 
		BEGIN 
			DECLARE pastas_cursor CURSOR FOR select idpasta, case when idpastapai is null then 0 else idpastapai end, cast(@p_iteracao + 1 as integer) nivel from pasta where (idpastapai is null) and (datafim is null) order by idpasta 
			OPEN pastas_cursor 
			FETCH NEXT FROM pastas_cursor INTO @pIdPasta, @pIdPastaPai, @pNivel 
			WHILE @@FETCH_STATUS = 0 
			BEGIN 
				IF (@p_iteracao < @p_nivelMaximo - 1) 
					BEGIN 
						INSERT INTO @table_arvore_pastas (idpasta,idpastapai,nivel) 
						select idpasta,idpastapai, nivel from f_arvore_pastas(@pIdPasta, @p_iteracao, @p_nivelMaximo) 
					END 
 				FETCH NEXT FROM pastas_cursor INTO @pIdPasta, @pIdPastaPai, @pNivel 
			END 
			CLOSE pastas_cursor 
			DEALLOCATE pastas_cursor 
		END 
    RETURN 
END;

CREATE FUNCTION f_busca_heranca_permissao(@p_idRaiz int, @p_iteracao int, @p_nivelMaximo int) RETURNS @table_pastas_permitidas TABLE (idpasta int) AS 
BEGIN 
	IF (@p_nivelMaximo <= 0) 
	BEGIN 
		return 
	END 
	DECLARE @pIdPasta int 
	IF (@p_idRaiz>0) 
		BEGIN 
			DECLARE pastas_cursor CURSOR FOR select idpasta from pasta where idpasta = @p_idRaiz and (datafim is null) 
			OPEN pastas_cursor 
			FETCH NEXT FROM pastas_cursor INTO @pIdPasta 
			WHILE @@FETCH_STATUS = 0 
			BEGIN 
				INSERT INTO @table_pastas_permitidas (idpasta) values (@pIdPasta) 
				IF (@p_iteracao < @p_nivelMaximo - 1) 
					BEGIN 
						DECLARE pastasFilhas_cursor CURSOR FOR select idpasta from pasta where idpastapai = @pIdPasta and ((herdapermissoes is not null) and (herdapermissoes='S')) and (datafim is null) order by idpasta 
						OPEN pastasFilhas_cursor 
						FETCH NEXT FROM pastasFilhas_cursor INTO @pIdPasta 
						WHILE @@FETCH_STATUS = 0 
						BEGIN 
							INSERT INTO @table_pastas_permitidas (idpasta) 
							select idpasta from f_busca_heranca_permissao(@pIdPasta, @p_iteracao + 1, @p_nivelMaximo) 
							FETCH NEXT FROM pastasFilhas_cursor INTO @pIdPasta 
						END 
						CLOSE pastasFilhas_cursor 
						DEALLOCATE pastasFilhas_cursor 
					END 
 				FETCH NEXT FROM pastas_cursor INTO @pIdPasta 
			END 
			CLOSE pastas_cursor 
			DEALLOCATE pastas_cursor 
		END 
	RETURN 
END;

CREATE FUNCTION f_pastas_permitidas(@pIdUsuario int) RETURNS @table_pastas_permitidas TABLE (idpasta int) AS 
BEGIN 
	DECLARE @pIdPasta int 
	DECLARE pastas_cursor CURSOR FOR select distinct p.idpasta 
			 from perfilacessopasta p join ( 
				select idperfil from perfilacessousuario where idusuario = @pIdUsuario and (datafim is null) 
				 union 
				select pagr.idperfil from usuario u join gruposempregados ge on u.idusuario = @pIdUsuario and u.idempregado = ge.idempregado 
								    join perfilacessogrupo pagr on pagr.idgrupo = ge.idgrupo and (pagr.datafim is null) 
			 ) pfa on p.idperfil = pfa.idperfil 
			 where (p.datafim is null) 
	OPEN pastas_cursor 
	FETCH NEXT FROM pastas_cursor INTO @pIdPasta 
	WHILE @@FETCH_STATUS = 0 
	BEGIN 
		INSERT INTO @table_pastas_permitidas (idpasta) 
			select idpasta from f_busca_heranca_permissao(@pIdPasta, 0, 9000) 
		FETCH NEXT FROM pastas_cursor INTO @pIdPasta 
	END 
	CLOSE pastas_cursor 
	DEALLOCATE pastas_cursor 
	RETURN 
END;

-- FIM - [euler.ramos] - 26/08/2016