--INCIO - [douglas.japiassu] - 25.09.2016

BEGIN
	EXECUTE IMMEDIATE 'drop table controlesla'; 
EXCEPTION
	WHEN OTHERS THEN
		IF SQLCODE != -942 THEN
			RAISE; 
		END IF; 
END;

CREATE TABLE controlesla (
	idcontrolesla NUMBER (24,0) NOT NULL,
	idsolicitacaoservico NUMBER (24,0) NOT NULL,
	idstatusinicial NUMBER (24,0) NOT NULL,
	idstatusfinal NUMBER (24,0) NULL,
	datainicial TIMESTAMP NOT NULL,
	datafinal TIMESTAMP NULL,
	idusuario NUMBER (24,0) NOT NULL,
	idtarefa NUMBER (24,0) NOT NULL,
	tempototal NUMBER (24,0) NOT NULL,
	constraint PK_contsla_pk PRIMARY KEY (idcontrolesla),
	constraint FK_contsla_solserv FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico),
	constraint FK_contsla_usuario FOREIGN KEY (idusuario) REFERENCES usuario (idusuario),
	constraint FK_contsla_itemtrabalho FOREIGN KEY (idtarefa) REFERENCES bpm_itemtrabalhofluxo (iditemtrabalho)
);

-- FIM - [douglas.japiassu] - 25.09.2016

--Inicio - [euler.ramos] - 26/10/2016

CREATE OR REPLACE FUNCTION f_sla_noprazo(pIdStatus NUMBER, pSituacaoSLA CHAR,pDataHoraLimite DATE,pDataHoraSuspensaoSLA DATE,pPrazoHH NUMBER,pPrazoMM NUMBER,pTempoAtendimentoHH NUMBER,pTempoAtendimentoMM NUMBER) RETURN VARCHAR IS NOPRAZO VARCHAR(1); 
  vPrazoHH NUMBER; 
	vPrazoMM NUMBER; 
	vTempoAtendimentoHH NUMBER; 
	vTempoAtendimentoMM NUMBER; 
BEGIN 
	IF (pIdStatus=3) THEN return 'S'; END IF; 
	IF (pDataHoraLimite is null) THEN return 'S'; END IF; 
	IF (pPrazoHH is null) OR (pPrazoHH < 0) THEN vPrazoHH:=0; ELSE vPrazoHH:=pPrazoHH; END IF; 
	IF (pPrazoMM is null) OR (pPrazoMM < 0) THEN vPrazoMM:=0; ELSE vPrazoMM:=pPrazoMM; END IF; 
	IF ((pPrazoHH=0) AND (pPrazoMM=0)) THEN return 'S'; END IF; 
	IF (pTempoAtendimentoHH is null) OR (pTempoAtendimentoHH <0) THEN vTempoAtendimentoHH := 0; ELSE vTempoAtendimentoHH := pTempoAtendimentoHH; END IF; 
	IF (pTempoAtendimentoMM is null) OR (pTempoAtendimentoMM <0) THEN vTempoAtendimentoMM := 0; ELSE vTempoAtendimentoMM := pTempoAtendimentoMM; END IF; 
	IF ((pTempoAtendimentoHH>0) OR (vTempoAtendimentoMM>0)) 
		THEN 
			IF ((pPrazoHH*3600)+(pPrazoMM*60)) < ((pTempoAtendimentoHH*3600)+(pTempoAtendimentoMM*60)) 
				THEN 
					return 'N'; 
				ELSE 
					return 'S'; 
			END IF; 
		ELSE 
			IF (pIdStatus = 6) 
				THEN 
					IF ((pPrazoHH*3600)+(pPrazoMM*60)) < ((pTempoAtendimentoHH*3600)+(pTempoAtendimentoMM*60)) 
						THEN 
							return 'N'; 
						ELSE 
							return 'S';	
					END IF; 
			END IF; 
	END IF; 
	IF (((pIdStatus=2) OR (pSituacaoSLA = 'S')) AND (pDataHoraSuspensaoSLA > pDataHoraLimite)) 
		THEN 
			return 'N'; 
		ELSE 
			IF (((pIdStatus<>2) OR (pSituacaoSLA <> 'S')) AND (CURRENT_TIMESTAMP > pDataHoraLimite)) 
				THEN 
					return 'N'; 
				ELSE 
					return 'S'; 
			END IF; 
	END IF; 
END;

create or replace FUNCTION f_sla_atrasado(pIdStatus NUMBER, pSituacaoSLA CHAR,pDataHoraLimite DATE,pDataHoraSuspensaoSLA DATE,pPrazoHH NUMBER,pPrazoMM NUMBER,pTempoAtendimentoHH NUMBER,pTempoAtendimentoMM NUMBER) RETURN VARCHAR IS atrasado VARCHAR(1); 
	vNoPrazo varchar(1); 
BEGIN 
	select f_sla_noprazo(pIdStatus,pSituacaoSLA,pDataHoraLimite,pDataHoraSuspensaoSLA,pPrazoHH,pPrazoMM,pTempoAtendimentoHH,pTempoAtendimentoMM) into vNoPrazo from dual; 
	IF (vNoPrazo='N') THEN return 'S'; ELSE return 'N'; END IF; 
END;

--FIM - [euler.ramos] - 26/10/2016