--INCIO - [douglas.japiassu] - 25.09.2016

drop table if exists controlesla;

CREATE TABLE controlesla (
	idcontrolesla bigint NOT NULL,
	idsolicitacaoservico bigint NOT NULL,
	idstatusinicial integer NOT NULL,
	idstatusfinal integer NULL,
	datainicial timestamp NOT NULL,
	datafinal timestamp NULL,
	idusuario integer NOT NULL,
	idtarefa bigint NOT NULL,
	tempototal bigint NOT NULL,
	constraint PK_contsla_pk PRIMARY KEY (idcontrolesla),
	constraint FK_contsla_solserv FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico),
	constraint FK_contsla_usuario FOREIGN KEY (idusuario) REFERENCES usuario (idusuario),
	constraint FK_contsla_itemtrabalho FOREIGN KEY (idtarefa) REFERENCES bpm_itemtrabalhofluxo (iditemtrabalho)
);

-- FIM - [douglas.japiassu] - 25.09.2016

--Inicio - [euler.ramos] - 26/10/2016

CREATE OR REPLACE FUNCTION f_sla_noprazo(smallint,character(1),timestamp,timestamp,smallint,smallint,smallint,smallint) RETURNS varchar(1) AS 
$BODY$ 
DECLARE 
	vIdStatus smallint; 
	vSituacaoSLA character(1); 
	vDataHoraLimite timestamp; 
	vDataHoraSuspensaoSLA timestamp; 
	vPrazoHH smallint; 
	vPrazoMM smallint; 
	vTempoAtendimentoHH smallint; 
	vTempoAtendimentoMM smallint; 
BEGIN 
	vIdStatus := $1; 
	vSituacaoSLA := $2; 
	vDataHoraLimite := $3; 
	vDataHoraSuspensaoSLA := $4; 
	vPrazoHH := $5; 
	vPrazoMM := $6; 
	vTempoAtendimentoHH := $7; 
	vTempoAtendimentoMM := $8; 
	IF (vIdStatus=3) THEN return 'S'; END IF; 
	IF (vDataHoraLimite is null) THEN return 'S'; END IF; 
	IF (vPrazoHH is null) OR (vPrazoHH < 0) THEN vPrazoHH:=0; END IF; 
	IF (vPrazoMM is null) OR (vPrazoMM < 0) THEN vPrazoMM:=0; END IF; 
	IF ((vPrazoHH=0) AND (vPrazoMM=0)) THEN return 'S'; END IF; 
	IF (vTempoAtendimentoHH is null) OR (vTempoAtendimentoHH <0) THEN vTempoAtendimentoHH := 0; END IF; 
	IF (vTempoAtendimentoMM is null) OR (vTempoAtendimentoMM <0) THEN vTempoAtendimentoMM := 0; END IF; 
	IF ((vTempoAtendimentoHH>0) OR (vTempoAtendimentoMM>0)) 
		THEN 
			IF ((vPrazoHH*3600)+(vPrazoMM*60)) < ((vTempoAtendimentoHH*3600)+(vTempoAtendimentoMM*60)) 
				THEN 
					return 'N'; 
				ELSE 
					return 'S'; 
			END IF; 
		ELSE 
			IF (vIdStatus = 6) 
				THEN 
					IF ((vPrazoHH*3600)+(vPrazoMM*60)) < ((vTempoAtendimentoHH*3600)+(vTempoAtendimentoMM*60)) 
						THEN 
							return 'N'; 
						ELSE 
							return 'S';	
					END IF; 
			END IF; 
	END IF; 
	IF (((vIdStatus=2) OR (vSituacaoSLA = 'S')) AND (vDataHoraSuspensaoSLA > vDataHoraLimite)) 
		THEN 
			return 'N'; 
		ELSE 
			IF (((vIdStatus<>2) OR (vSituacaoSLA <> 'S')) AND (CURRENT_TIMESTAMP > vDataHoraLimite)) 
				THEN 
					return 'N'; 
				ELSE 
					return 'S'; 
			END IF; 
	END IF; 
END; 
$BODY$ 
LANGUAGE 'plpgsql' VOLATILE;


CREATE OR REPLACE FUNCTION f_sla_atrasado(smallint,character(1),timestamp,timestamp,smallint,smallint,smallint,smallint) RETURNS varchar(1) AS 
$BODY$ 
DECLARE 
	vNoPrazo varchar(1); 
BEGIN 
	select f_sla_noprazo($1,$2,$3,$4,$5,$6,$7,$8) into vNoPrazo; 
	IF (vNoPrazo='N') THEN return 'S'; ELSE return 'N'; END IF; 
END; 
$BODY$ 
LANGUAGE 'plpgsql' VOLATILE;

--FIM - [euler.ramos] - 26/10/2016
