--INCIO - [douglas.japiassu] - 25.09.2016

if object_id('controlesla') is not null drop table controlesla;

CREATE TABLE controlesla (
	idcontrolesla bigint NOT NULL,
	idsolicitacaoservico bigint NOT NULL,
	idstatusinicial int NOT NULL,
	idstatusfinal int NULL,
	datainicial datetime NOT NULL,
	datafinal datetime NULL,
	idusuario int NOT NULL,
	idtarefa bigint NOT NULL,
	tempototal bigint NOT NULL,
	constraint PK_contsla_pk PRIMARY KEY (idcontrolesla),
	constraint FK_contsla_solserv FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico),
	constraint FK_contsla_usuario FOREIGN KEY (idusuario) REFERENCES usuario (idusuario),
	constraint FK_contsla_itemtrabalho FOREIGN KEY (idtarefa) REFERENCES bpm_itemtrabalhofluxo (iditemtrabalho)
);

-- FIM - [douglas.japiassu] - 25.09.2016

--Inicio - [euler.ramos] - 26/10/2016

CREATE FUNCTION f_sla_noprazo(@pIdStatus smallint,@pSituacaoSLA char(1),@pDataHoraLimite datetime,@pDataHoraSuspensaoSLA datetime,@pPrazoHH smallint,@pPrazoMM smallint,@pTempoAtendimentoHH smallint,@pTempoAtendimentoMM smallint) RETURNS varchar(1) AS 
BEGIN 
	IF (@pPrazoHH is null) OR (@pPrazoHH < 0) 
		SET @pPrazoHH = 0 
	IF (@pPrazoMM is null) OR (@pPrazoMM < 0) 
		SET @pPrazoMM = 0 
	IF ((@pPrazoHH=0) AND (@pPrazoMM=0)) 
	BEGIN 
		return 'S' 
	END 
	IF (@pTempoAtendimentoHH is null) OR (@pTempoAtendimentoHH <0) 
		SET @pTempoAtendimentoHH = 0 
	IF (@pTempoAtendimentoMM is null) OR (@pTempoAtendimentoMM <0) 
		SET @pTempoAtendimentoMM = 0 
	IF ((@pTempoAtendimentoHH>0) OR (@pTempoAtendimentoMM>0)) 
	BEGIN 
		IF ((@pPrazoHH*3600)+(@pPrazoMM*60)) < ((@pTempoAtendimentoHH*3600)+(@pTempoAtendimentoMM*60)) 
				return 'N' 
			ELSE 
				return 'S' 
	END 
		ELSE 
			BEGIN 
				IF (@pIdStatus=6) 
				BEGIN 
					IF (((@pPrazoHH*3600)+(@pPrazoMM*60)) < ((@pTempoAtendimentoHH*3600)+(@pTempoAtendimentoMM*60))) 
						return 'N' 
					ELSE 
						return 'S' 
				END 
			END 
	IF (((@pIdStatus=2) OR (@pSituacaoSLA = 'S')) AND (@pDataHoraSuspensaoSLA > @pDataHoraLimite)) 
	BEGIN 
			return 'N' 
	END 
		ELSE 
			BEGIN 
				IF (((@pIdStatus<>2) OR (@pSituacaoSLA <> 'S')) AND (CURRENT_TIMESTAMP > @pDataHoraLimite)) 
					return 'N' 
				ELSE 
					return 'S' 
			END 
	return 'S' 
END;


CREATE FUNCTION f_sla_atrasado(@pIdStatus smallint,@pSituacaoSLA char(1),@pDataHoraLimite datetime,@pDataHoraSuspensaoSLA datetime,@pPrazoHH smallint,@pPrazoMM smallint,@pTempoAtendimentoHH smallint,@pTempoAtendimentoMM smallint) RETURNS varchar(1) AS 
BEGIN 
	DECLARE @noPrazo varchar(1) 
	select @noPrazo = dbo.f_sla_noprazo(@pIdStatus,@pSituacaoSLA,@pDataHoraLimite,@pDataHoraSuspensaoSLA,@pPrazoHH,@pPrazoMM,@pTempoAtendimentoHH,@pTempoAtendimentoMM) 
	IF (@noPrazo='N') 
		return 'S' 
	return 'N' 
END;

--FIM - [euler.ramos] - 26/10/2016