-- INCIO [douglas.japiassu] 04.01.2017

CREATE OR REPLACE FUNCTION f_permissao_fluxo(bigint, bigint) RETURNS SETOF permissoesfluxo AS 
$BODY$ 
DECLARE 
	rec permissoesfluxo%ROWTYPE; 
	permissoes permissoesfluxo%ROWTYPE; 
 	
	p_idusuario ALIAS for $1; 
	p_idfluxo ALIAS for  $2; 
BEGIN 
	rec.criar := 'N'; 
	rec.executar := 'N'; 
	rec.delegar := 'N'; 
	rec.suspender := 'N'; 
	rec.reativar := 'N'; 
	rec.alterarsla := 'N'; 
	rec.reabrir := 'N'; 
	rec.cancelar := 'N'; 

	for permissoes in (select pf.* from bpm_fluxo f inner join permissoesfluxo pf on pf.idtipofluxo = f.idtipofluxo inner join gruposempregados ge on ge.idgrupo = pf.idgrupo inner join usuario u on u.idempregado = ge.idempregado where u.idusuario = p_idusuario and f.idfluxo = p_idfluxo and f.datafim is null) loop 
		rec.idtipofluxo := permissoes.idtipofluxo; 
		if upper(permissoes.criar) = upper('S') then rec.criar := 'S'; end if; 
		if upper(permissoes.executar) = upper('S') then rec.executar := 'S'; end if; 
		if upper(permissoes.delegar) = upper('S') then rec.delegar := 'S'; end if; 
		if upper(permissoes.suspender) = upper('S') then rec.suspender := 'S'; end if; 
		if upper(permissoes.reativar) = upper('S') then rec.reativar := 'S'; end if; 
		if upper(permissoes.alterarsla) = upper('S') then rec.alterarsla := 'S'; end if; 
		if upper(permissoes.reabrir) = upper('S') then rec.reabrir := 'S'; end if; 
		if upper(permissoes.cancelar) = upper('S') then rec.cancelar := 'S'; end if; 		
	end loop; 

	return next rec; 
 
END; 
$BODY$ 
LANGUAGE  'plpgsql' VOLATILE;

update portfolioservico set  imagemportal = regexp_replace(imagemportal, '.+?(?=\/imagens/portal)', '', 'gi');
update servico set  imagemportal = regexp_replace(imagemportal, '.+?(?=\/imagens/portal)', '', 'gi');

-- FIM [douglas.japiassu] 04.01.2017