-- SCRIPTS PROGRAMA 0005 PROJETO 0006 e PROJETO 0097 - GERENCIAMENTO DE EVENTOS

set sql_safe_updates = 0;

-- INCIO - Valdolo Damasceno (02/01/2015)
create table evm_check
(
	idcheck int(11) not null,
	nome varchar(255) not null,
	idtipoitemconfiguracao int(11) not null,
	idcaracteristicaprincipal int(11) not null,
	tipocheck varchar(50) not null,
	idcaracteristicacomplementar int(11) default null,
	simbolodaexpressaowarning varchar(50) not null,
	valordaexpressaowarning varchar(50) not null,
	simbolodaexpressaoexception varchar(50) not null,
	valordaexpressaoexception varchar(50) not null,
	idusuariocriador int(11) not null,
	idusuariomodificador int(11) default null,
	datahorainicio date not null,
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	tipovalorwarning varchar(50),
	tipovalorexception varchar(50),
	primary key (idcheck),
	key (idcaracteristicaprincipal, idcaracteristicacomplementar),
	key (idtipoitemconfiguracao),
	key (idusuariocriador, idusuariomodificador)
) ENGINE=InnoDB;


create table evm_conexao
(
	idconexao int(11) not null,
	nome varchar(50) not null,
	ferramenta varchar(50) not null,
	protocolo varchar(50),
	endereco varchar(50) not null,
	porta int(11),
	usuario varchar(50),
	senha varchar(50),
	idusuariocriador int(11) not null,
	idusuariomodificador int(11),
	datahorainicio date not null,
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	status VARCHAR(7) NOT NULL,
	idevmconexaoeventmonitor INT(11),
	primary key (idconexao),
	key (idusuariocriador, idusuariomodificador)
) ENGINE=InnoDB;


create table evm_cron
(
	idcron int(11) not null,
	nome varchar(50) not null,
	expressao varchar(50) not null,
	idusuariocriador int(11) not null,
	idusuariomodificador int(11),
	datahorainicio date not null,
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	primary key (idcron),
	key (idusuariocriador, idusuariomodificador)
) ENGINE=InnoDB;

create table evm_gerenciado_inventory
(
	idgerenciado int(11) not null,
	idgerente int(11) not null,
	iditemconfiguracaofilho int(11),
	idtipoitemconfiguracao int(11),
	idcheck int(11) not null,
	idfluxoacaowarning int(11),
	idfluxoacaoexception int(11),
	simbolodaexpressaowarning varchar(50),
	simbolodaexpressaoexception varchar(50),
	valordaexpressaowarning varchar(50),
	valordaexpressaoexception varchar(50),
	idusuariocriador int(11) not null,
	idusuariomodificador int(11),
	datahorainicio date not null,
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	eplException TEXT,
	eplWarning TEXT,
	idevmtipoevento int(11) not null,
	iditemconfiguracaopai int(11),
	identificacaoicfilho varchar(400),
	identificacaoicpai varchar(400),
	primary key (idgerenciado),
	key (idcheck),
	key (idgerente),
	key (iditemconfiguracaofilho),
	key (idtipoitemconfiguracao),
	key (idEvmTipoEvento),
	key (idusuariocriador, idusuariomodificador)
) ENGINE=InnoDB;




create table evm_gerenciado_nagios
(
	idgerenciado int(11) not null,
	idgerente int(11) not null,
	servico varchar(50),
	iditemconfiguracaofilho int(11) not null,
	idfluxoacaowarning int(11),
	idfluxoacaoexception int(11),
	simbolodaexpressaowarning varchar(50),
	simbolodaexpressaoexception varchar(50),
	valordaexpressaowarning varchar(50),
	valordaexpressaoexception varchar(50),
	idusuariocriador int(11) not null,
	idusuariomodificador int(11),
	datahorainicio date not null,
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	eplException TEXT,
	eplWarning TEXT,
	idevmtipoevento int(11) not null,
	iditemconfiguracaopai int(11),
	identificacaoicfilho varchar(400),
	identificacaoicpai varchar(400),
	primary key (idgerenciado),
	key (idgerente),
	key (iditemconfiguracaofilho),
	key (idEvmTipoEvento),
	key (idusuariocriador, idusuariomodificador)
) ENGINE=InnoDB;

create table evm_gerenciado_zabbix
(
	idgerenciado int(11) not null,
	idgerente int(11) not null,
	nometrigger varchar(50),
	idtrigger int(11) not null,
	iditemconfiguracaofilho int(11) not null,
	idfluxoacaowarning int(11),
	idfluxoacaoexception int(11),
	simbolodaexpressaowarning varchar(50),
	simbolodaexpressaoexception varchar(50),
	valordaexpressaowarning varchar(50),
	valordaexpressaoexception varchar(50),
	idusuariocriador int(11) not null,
	idusuariomodificador int(11),
	datahorainicio date not null,
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	eplException TEXT,
	eplWarning TEXT,
	idevmtipoevento int(11) not null,
	iditemconfiguracaopai int(11),
	identificacaoicfilho varchar(400),
	identificacaoicpai varchar(400),
	primary key (idgerenciado),
	key (idgerente),
	key (iditemconfiguracaofilho),
	key (idEvmTipoEvento),
	key (idusuariocriador, idusuariomodificador)
) ENGINE=InnoDB;


create table evm_gerente
(
	idgerente int(11) not null,
	nome varchar(255) not null,
	idconexao int(11) not null,
	idcron int(11) not null,
	iditemconfiguracaopai int(11),
	host varchar(50),
	idfluxodown int(11),
	idusuariocriador int(11) not null,
	idusuariomodificador int(11),
	datahorainicio date not null,
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	primary key (idgerente),
	key (idconexao),
	key (idcron),
	key (iditemconfiguracaopai),
	key (idusuariocriador, idusuariomodificador)
) ENGINE=InnoDB;

create table evm_gerente_correlacao
(
	idgerentecorrelacao int(11) not null,
	nome varchar(255) not null,
	eplWarning TEXT,
	idfluxoacaowarning int(11),
	eplException TEXT,
	idfluxoacaoexception int(11),
	idusuariocriador int(11) not null,
	idusuariomodificador int(11),
	datahorainicio date not null default '0000-00-00',
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	idevmtipoevento int(11) not null,
	idevmconexaoeventmonitor int(11) not null,
	primary key (idgerentecorrelacao),
	key (idEvmTipoEvento),
	key (idusuariocriador, idusuariomodificador)
) ENGINE=InnoDB;

create table evm_inventory_configuracao
(
	idconfiguracao INTEGER NOT NULL,
	idinventory VARCHAR(255) NOT NULL,
	faixaip VARCHAR(4000) NOT NULL,
	contexto VARCHAR(50) NOT NULL,
	ipservidor VARCHAR(50),
	portanet INTEGER,
	timeout INTEGER,
	numerotentativas INTEGER,
	portasnmp INTEGER,
	nomesnmpcommunity VARCHAR(255),
	idformula INTEGER,
	datahorainicio DATE NOT NULL,
	datahorafim DATE NULL DEFAULT '0000-00-00',
	idconexao INTEGER NOT NULL,
	idcron INTEGER NOT NULL,
	conteudoformula TEXT,
	expressaoCron varchar(50) NOT NULL,
	destinoInventario TEXT,
	idevmconexaoeventmonitor INT(11),
	primary key (idconfiguracao),
	KEY (idconexao),
	KEY (idformula)
) ENGINE=InnoDB;

-- INICIO - MURILO GABRIEL RODRIGUES - 25/03/2015
create table evm_tipoevento 
  ( 
     idevmtipoevento      INT(11) NOT NULL, 
     idgrupoevmtipoevento INT(11), 
     nome                 VARCHAR(200) NOT NULL, 
     datahorafim          DATE NULL DEFAULT '0000-00-00', 
     primary key (idevmtipoevento), 
     KEY (idgrupoevmtipoevento) 
  ) ENGINE=InnoDB;

create table evm_grupotipoevento 
  ( 
     idgrupoevmtipoevento INT(11) NOT NULL, 
     nome                 VARCHAR(200) NOT NULL, 
     datahorafim          DATE NULL DEFAULT '0000-00-00', 
     primary key (idgrupoevmtipoevento) 
  ) ENGINE=InnoDB;
-- FIM - MURILO GABRIEL RODRIGUES - 25/03/2015

-- INICIO - MURILO GABRIEL RODRIGUES - 09/04/2015
create table evm_conexao_event_monitor 
  ( 
     idevmconexaoeventmonitor INT(11) NOT NULL, 
     identificador            VARCHAR(100) NOT NULL, 
     nome                     VARCHAR(200) NOT NULL, 
     protocolo                VARCHAR(100) NOT NULL, 
     ip                       VARCHAR(100) NOT NULL, 
     porta                    VARCHAR(100) NOT NULL, 
     contexto                 VARCHAR(100) NOT NULL, 
     usuario                  VARCHAR(100) NOT NULL, 
     senha                    VARCHAR(100) NOT NULL, 
     datahorafim              DATE NULL DEFAULT '0000-00-00', 
     primary key (idevmconexaoeventmonitor) 
  ) ENGINE=InnoDB;
-- FIM - MURILO GABRIEL RODRIGUES - 09/04/2015

alter table evm_check add constraint fk_evm_check_carac_prin foreign key (idcaracteristicaprincipal) references caracteristica (idcaracteristica);

alter table evm_check add constraint fk_evm_check_carac_comp foreign key (idcaracteristicacomplementar) references caracteristica (idcaracteristica);

alter table evm_check add constraint fk_evm_check_tipoitemconfiguracao foreign key (idtipoitemconfiguracao) references tipoitemconfiguracao (idtipoitemconfiguracao);

alter table evm_check add constraint fk_evm_check_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_check add constraint fk_evm_check_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_conexao add constraint fk_evm_conexao_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_conexao add constraint fk_evm_conexao_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_cron add constraint fk_evm_cron_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_cron add constraint fk_evm_cron_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_inventory add constraint fk_evm_gerenciado_inventory_check foreign key (idcheck) references evm_check (idcheck);

alter table evm_gerenciado_inventory add constraint fk_evm_gerenciado_inventory_evm_gerente foreign key (idgerente) references evm_gerente (idgerente);

alter table evm_gerenciado_nagios add constraint fk_evm_gerenciado_nagios_evm_gerente foreign key (idgerente) references evm_gerente (idgerente);

alter table evm_gerenciado_zabbix add constraint fk_evm_gerenciado_zabbix_evm_gerente foreign key (idgerente) references evm_gerente (idgerente);

alter table evm_gerenciado_inventory add constraint fk_evm_gerenciado_inventory_itemconfiguracao foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerenciado_nagios add constraint fk_evm_gerenciado_nagios_itemconfiguracao foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerenciado_zabbix add constraint fk_evm_gerenciado_zabbix_itemconfiguracao foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inventory_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inventory_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nagios_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nagios_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zabbix_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zabbix_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerente_correlacao add constraint fk_evm_gerente_correlacao_evm foreign key (idevmconexaoeventmonitor) references evm_conexao_event_monitor (idevmconexaoeventmonitor);

alter table evm_gerente_correlacao add constraint fk_evm_ger_correlacao_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerente_correlacao add constraint fk_evm_ger_correlacao_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_inventory add constraint fk_evm_gerenciado_inventory_tipoitemconfiguracao foreign key (idtipoitemconfiguracao) references tipoitemconfiguracao (idtipoitemconfiguracao);

alter table evm_gerente add constraint fk_evm_gerente_evm_conexao foreign key (idconexao) references evm_conexao (idconexao);

alter table evm_gerente add constraint fk_evm_gerente_evm_cron foreign key (idcron) references evm_cron (idcron);

alter table evm_gerente add constraint fk_evm_gerente_itemconfiguracao foreign key (iditemconfiguracaopai) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerente add constraint fk_evm_gerente_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerente add constraint fk_evm_gerente_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_inventory_configuracao add constraint FK_evm_inventory_configuracao_evm_conexao FOREIGN KEY (idconexao) REFERENCES evm_conexao (idconexao);

alter table evm_inventory_configuracao add constraint FK_evm_inventory_configuracao_formula FOREIGN KEY (idformula) REFERENCES formula (idformula);
-- fim - Valdolo Damasceno (02/01/2015)

-- inicio - Euler Ramos (13/04/2015)

alter table contratos ENGINE=InnoDB;

alter table origematendimento ENGINE=InnoDB;

alter table tipodemandaservico ENGINE=InnoDB;

alter table servicocontrato ENGINE=InnoDB;

create table evm_acao
(
  idacao bigint(20)     NOT NULL,
  nomeacao varchar(254) NOT NULL,
  tipoacao varchar(254) NOT NULL,
  datahorafim date      NULL,
  primary key (idacao)
) ENGINE=InnoDB;

create table evm_acao_incidenterequisicao 
(
	idacaoincidenterequisicao bigint(20) NOT NULL,
	idacao bigint(20) NOT NULL,
	idcontrato int(11) NOT NULL,
	idorigem bigint(20) NOT NULL,
	idsolicitante int(11) NOT NULL,
	idtipodemandaservico int(11) NOT NULL,
	idservico bigint(20) NOT NULL,
	descricao text NOT NULL,
	impacto char(1),
	urgencia char(1),
	idgrupo integer NOT NULL,
	enviaemailcriacao char(1),
	enviaemailfinalizacao char(1),
	enviaemailacoes character(1),
  constraint pkevm_acao_incidenterequisicao primary key (idacaoincidenterequisicao),
  constraint FK_evm_acao_incidenterequisicao_acao FOREIGN KEY (idacao) REFERENCES evm_acao (idacao),
  constraint FK_evm_acao_incidenterequisicao_contratos FOREIGN KEY (idcontrato) REFERENCES contratos (idcontrato),
  constraint FK_evm_acao_incidenterequisicao_origematendimento FOREIGN KEY (idorigem) REFERENCES origematendimento (idorigem),
  constraint FK_evm_acao_incidenterequisicao_empregados FOREIGN KEY (idsolicitante) REFERENCES empregados (idempregado),
  constraint FK_evm_acao_incidenterequisicao_tipodemandaservico FOREIGN KEY (idtipodemandaservico) REFERENCES tipodemandaservico (idtipodemandaservico),
  constraint FK_evm_acao_incidenterequisicao_servico FOREIGN KEY (idservico) REFERENCES servico (idservico),
  constraint FK_evm_acao_incidenterequisicao_grupo FOREIGN KEY (idgrupo) REFERENCES grupo (idgrupo)
) ENGINE=InnoDB;
-- fim - Euler Ramos (13/04/2015)

-- INICIO - rodrigo.acorse (13/04/2015)

ALTER TABLE usuario ENGINE=InnoDB;

ALTER TABLE grupo ENGINE=InnoDB;

ALTER TABLE gruposemails ENGINE=InnoDB;

create table evm_acao_notificacao
(
  idacaonotificacao bigint(20) NOT NULL,
  idacao bigint(20) NOT NULL,
  assunto varchar(254) NOT NULL,
  conteudo text NOT NULL,
  constraint evm_acao_notificacao_pkey primary key (idacaonotificacao) 
);

alter table evm_acao_notificacao add constraint fk_evm_acao_notificacao_evm_acao foreign key (idacao) references evm_acao (idacao);
	
create table evm_acao_notificacao_usuario
(
  idacaonotificacaousuario bigint(20) NOT NULL,
  idacaonotificacao bigint(20) NOT NULL,
  idusuario int(11) NOT NULL,
  constraint evm_acao_notificacao_usuario_pkey primary key (idacaonotificacaousuario) 
);

alter table evm_acao_notificacao_usuario add constraint fk_evm_acao_notificacao_usuario_evm_acao_notificacao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);

alter table evm_acao_notificacao_usuario add constraint fk_evm_acao_notificacao_usuario_usuario foreign key (idusuario) references usuario (idusuario);

create table evm_acao_notificacao_grupo
(
  idacaonotificacaogrupo bigint(20) NOT NULL,
  idacaonotificacao bigint(20) NOT NULL,
  idgrupo int(11) NOT NULL,
  constraint evm_acao_notificacao_grupo_pkey primary key (idacaonotificacaogrupo) 
);

alter table evm_acao_notificacao_grupo add constraint fk_evm_acao_notificacao_grupo_evm_acao_notificacao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);

alter table evm_acao_notificacao_grupo add constraint fk_evm_acao_notificacao_grupo_grupo foreign key (idgrupo) references grupo (idgrupo);

create table evm_acao_notificacao_email
(
  idacaonotificacaoemail bigint(20) NOT NULL,
  idacaonotificacao bigint(20) NOT NULL,
  email varchar(254) NOT NULL,
  constraint evm_acao_notificacao_email_pkey primary key (idacaonotificacaoemail) 
);

alter table evm_acao_notificacao_email add constraint fk_evm_acao_notificacao_email_evm_acao_notificacao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);

create table evm_acao_automatica
(
  idacaoautomatica bigint(20) NOT NULL,
  nome varchar(254) NOT NULL,
  datahorafim date  NULL,
  constraint evm_acao_automatica_pkey primary key (idacaoautomatica) 
);

create table evm_acao_automatica_vinculo
(
  idacaoautomatica bigint(20) NOT NULL,
  idacao bigint(20) NOT NULL,
  constraint evm_acao_vinculada_pkey primary key (idacaoautomatica, idacao) 
);

alter table evm_acao_automatica_vinculo add constraint fk_evm_acao_automatica_vinculo_evm_acao_automatica foreign key (idacaoautomatica) references evm_acao_automatica (idacaoautomatica);
	
alter table evm_acao_automatica_vinculo add constraint fk_evm_acao_automatica_vinculo_evm_acao foreign key (idacao) references evm_acao (idacao);

-- FIM - rodrigo.acorse (13/04/2015)

-- INICIO - rodrigo.acorse - 30/04/2015
create table evm_acao_instancia
(
  idacaoinstancia bigint(20) NOT NULL,
  idocorrencia varchar(254) NOT NULL,
  idacao bigint(20) NOT NULL,
  ferramenta varchar(254) NOT NULL,
  status varchar(254) NOT NULL,
  datahora date NOT NULL,
  constraint evm_acao_instancia_pkey primary key (idacaoinstancia) 
);

alter table evm_acao_instancia add constraint fk_idacao foreign key (idacao) references evm_acao (idacao);

create table evm_acao_instancia_solicitacao
(
  idacaoinstanciasolicitacao bigint(20) NOT NULL,
  idacaoinstancia bigint(20) NOT NULL,
  idsolicitacaoservico bigint(20) NOT NULL,
  constraint evm_acao_ins_solicitacao_pkey primary key (idacaoinstanciasolicitacao) 
);

alter table evm_acao_instancia_solicitacao add constraint fk_idacaoinstancia foreign key (idacaoinstancia) references evm_acao_instancia (idacaoinstancia);
alter table evm_acao_instancia_solicitacao add constraint fk_idsolicitacaoservico foreign key (idsolicitacaoservico) references solicitacaoservico (idsolicitacaoservico);
-- FIM - rodrigo.acorse - 30/04/2015

-- INICIO - valdoilo.damasceno - 08/05/2015
delete from menu where nome = '$menu.nome.monitoramentoNagios';
delete from menu where nome = '$menu.nome.recurso';
delete from menu where nome = '$menu.nome.disponibilidadeRecurso';
delete from menu where nome = '$menu.nome.grupoRecursos';
delete from menu where nome = '$menu.nome.monitoramento';
delete from menu where nome = '$menu.nome.eventoMonitoramento';
delete from menu where nome = '$menu.nome.monitoramentoativos';
delete from menu where nome = '$menu.nome.mostraStatusCapturaInventario';
-- FIM - valdoilo.damasceno - 08/05/2015

set sql_safe_updates = 1;

-- FROM SCRIPTS PROGRAMA 0005 PROJETO 0006 e PROJETO 0097 - GERENCIAMENTO DE EVENTOS