-- SCRIPTS PROGRAMA 0005 PROJETO 0006 e PROJETO 0097 - GERENCIAMENTO DE EVENTOS

-- INCIO - Rodrigo Ricardo P. Dorighello Guilherme (20/04/2015)
create table evm_check
(
	idcheck NUMBER(11,0) not null,
	nome VARCHAR2(255 CHAR) not null,
	idtipoitemconfiguracao NUMBER(11,0) not null,
	idcaracteristicaprincipal NUMBER(11,0) not null,
	tipocheck VARCHAR2(50 CHAR) not null,
	idcaracteristicacomplementar NUMBER(11,0) default null,
	simbolodaexpressaowarning VARCHAR2(50 CHAR) not null,
	valordaexpressaowarning VARCHAR2(50 CHAR) not null,
	simbolodaexpressaoexception VARCHAR2(50 CHAR) not null,
	valordaexpressaoexception VARCHAR2(50 CHAR) not null,
	idusuariocriador NUMBER(11,0) not null,
	idusuariomodificador NUMBER(11,0) default null,
	datahorainicio date not null,
	datahorafim date,
	datahoraultimaalteracao date,
	tipovalorwarning VARCHAR2(50 CHAR),
	tipovalorexception VARCHAR2(50 CHAR),
	
	CONSTRAINT evm_check_pkey PRIMARY KEY (idcheck)
);


create table evm_conexao
(
	idconexao NUMBER(11,0) not null,
	nome VARCHAR2(50 CHAR) not null,
	ferramenta VARCHAR2(50 CHAR) not null,
	protocolo VARCHAR2(50 CHAR),
	endereco VARCHAR2(50 CHAR) not null,
	porta NUMBER(11,0),
	usuario VARCHAR2(50 CHAR),
	senha VARCHAR2(50 CHAR),
	idusuariocriador NUMBER(11,0) not null,
	idusuariomodificador NUMBER(11,0),
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	status VARCHAR2(7 CHAR) NOT NULL,
	idevmconexaoeventmonitor NUMBER(11,0),
	CONSTRAINT evm_conexao_pkey PRIMARY KEY (idconexao)
);


create table evm_cron
(
	idcron NUMBER(11,0) not null,
	nome VARCHAR2(50 CHAR) not null,
	expressao VARCHAR2(50 CHAR) not null,
	idusuariocriador NUMBER(11,0) not null,
	idusuariomodificador NUMBER(11,0),
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	CONSTRAINT evm_cron_pkey PRIMARY KEY (idcron)
);

create table evm_gerenciado_inventory
(
	idgerenciado NUMBER(11,0) not null,
	idgerente NUMBER(11,0) not null,
	iditemconfiguracaofilho NUMBER(11,0),
	idtipoitemconfiguracao NUMBER(11,0),
	idcheck NUMBER(11,0) not null,
	idfluxoacaowarning NUMBER(11,0),
	idfluxoacaoexception NUMBER(11,0),
	simbolodaexpressaowarning VARCHAR2(50 CHAR),
	simbolodaexpressaoexception VARCHAR2(50 CHAR),
	valordaexpressaowarning VARCHAR2(50 CHAR),
	valordaexpressaoexception VARCHAR2(50 CHAR),
	idusuariocriador NUMBER(11,0) not null,
	idusuariomodificador NUMBER(11,0),
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	eplException CLOB,
	eplWarning CLOB,
	idEvmTipoEvento NUMBER(11,0) not null,
	iditemconfiguracaopai NUMBER(11,0),
	identificacaoicfilho VARCHAR2(400 CHAR),
	identificacaoicpai VARCHAR2(400 CHAR),
	CONSTRAINT evm_gerenciado_inventory_pkey PRIMARY KEY (idgerenciado)
);


create table evm_gerenciado_nagios
(
	idgerenciado NUMBER(11,0) not null,
	idgerente NUMBER(11,0) not null,
	servico VARCHAR2(50 CHAR),
	iditemconfiguracaofilho NUMBER(11,0) not null,
	idfluxoacaowarning NUMBER(11,0),
	idfluxoacaoexception NUMBER(11,0),
	simbolodaexpressaowarning VARCHAR2(50 CHAR),
	simbolodaexpressaoexception VARCHAR2(50 CHAR),
	valordaexpressaowarning VARCHAR2(50 CHAR),
	valordaexpressaoexception VARCHAR2(50 CHAR),
	idusuariocriador NUMBER(11,0) not null,
	idusuariomodificador NUMBER(11,0),
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	eplException CLOB,
	eplWarning CLOB,
	idEvmTipoEvento NUMBER(11,0) not null,
	iditemconfiguracaopai NUMBER(11,0),
	identificacaoicfilho VARCHAR2(400 CHAR),
	identificacaoicpai VARCHAR2(400 CHAR),
	CONSTRAINT evm_gerenciado_nagios_pkey PRIMARY KEY (idgerenciado)
);

create table evm_gerenciado_zabbix
(
	idgerenciado NUMBER(11,0) not null,
	idgerente NUMBER(11,0) not null,
	servico VARCHAR2(50 CHAR),
	iditemconfiguracaofilho NUMBER(11,0) not null,
	idfluxoacaowarning NUMBER(11,0),
	idfluxoacaoexception NUMBER(11,0),
	simbolodaexpressaowarning VARCHAR2(50 CHAR),
	simbolodaexpressaoexception VARCHAR2(50 CHAR),
	valordaexpressaowarning VARCHAR2(50 CHAR),
	valordaexpressaoexception VARCHAR2(50 CHAR),
	idusuariocriador NUMBER(11,0) not null,
	idusuariomodificador NUMBER(11,0),
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	eplException CLOB,
	eplWarning CLOB,
	idEvmTipoEvento NUMBER(11,0) not null,
	iditemconfiguracaopai NUMBER(11,0),
	identificacaoicfilho VARCHAR2(400 CHAR),
	identificacaoicpai VARCHAR2(400 CHAR),
	CONSTRAINT evm_gerenciado_zabbix_pkey PRIMARY KEY (idgerenciado)
);


create table evm_gerente
(
	idgerente NUMBER(11,0) not null,
	nome VARCHAR2(255 CHAR) not null,
	idconexao NUMBER(11,0) not null,
	idcron NUMBER(11,0) not null,
	iditemconfiguracaopai NUMBER(11,0),
	host VARCHAR2(50 CHAR),
	idfluxodown NUMBER(11,0),
	idusuariocriador NUMBER(11,0) not null,
	idusuariomodificador NUMBER(11,0),
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	CONSTRAINT evm_gerente_pkey PRIMARY KEY (idgerente)
);

create table evm_gerente_correlacao
(
	idgerentecorrelacao  NUMBER(11,0) not null,
	nome VARCHAR2(255 CHAR) not null,
	eplWarning CLOB,
	idfluxoacaowarning  NUMBER(11,0),
	eplException CLOB,
	idfluxoacaoexception  NUMBER(11,0),
	idusuariocriador  NUMBER(11,0) not null,
	idusuariomodificador  NUMBER(11,0),
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	idevmtipoevento  NUMBER(11,0) not null,
	idevmconexaoeventmonitor NUMBER(11,0) not null,
	CONSTRAINT evm_gerente_correl_pkey PRIMARY KEY (idgerentecorrelacao)
);

create table evm_inventory_configuracao
(
	idconfiguracao NUMBER(10,0) NOT NULL,
	idinventory VARCHAR2(255 CHAR) NOT NULL,
	faixaip VARCHAR2(4000 CHAR) NOT NULL,
	contexto VARCHAR2(50 CHAR) NOT NULL,
	ipservidor VARCHAR2(50 CHAR),
	portanet NUMBER(10,0),
	timeout NUMBER(10,0),
	numerotentativas NUMBER(10,0),
	portasnmp NUMBER(10,0),
	nomesnmpcommunity VARCHAR2(255 CHAR),
	idformula NUMBER(10,0),
	datahorainicio DATE NOT NULL,
	datahorafim DATE NULL,
	idconexao NUMBER(10,0) NOT NULL,
	idcron NUMBER(10,0) NOT NULL,
	conteudoformula CLOB,
	expressaoCron VARCHAR2(50 CHAR) NOT NULL,
	destinoInventario CLOB,
	idevmconexaoeventmonitor NUMBER(11,0),
	CONSTRAINT evm_inventory_config_pkey PRIMARY KEY (idconfiguracao)
);

create table evm_tipoevento 
  ( 
     idevmtipoevento      NUMBER(11,0) NOT NULL, 
     idgrupoevmtipoevento NUMBER(11,0), 
     nome                 VARCHAR2(200 CHAR) NOT NULL,
     datahorafim          DATE NULL, 
	 CONSTRAINT evm_tipoevento_pkey PRIMARY KEY (idevmtipoevento)
  );

create table evm_grupotipoevento
  ( 
     idgrupoevmtipoevento NUMBER(11,0) NOT NULL, 
     nome                 VARCHAR2(200 CHAR) NOT NULL,
     datahorafim          DATE NULL, 
	 CONSTRAINT evm_grupotipoevento_pkey PRIMARY KEY (idgrupoevmtipoevento)
  );
  
create table evm_conexao_event_monitor
  ( 
     idevmconexaoeventmonitor NUMBER(11,0) NOT NULL, 
     identificador            VARCHAR2(100 CHAR) NOT NULL, 
     nome                     VARCHAR2(200 CHAR) NOT NULL, 
     protocolo                VARCHAR2(100 CHAR) NOT NULL, 
     ip                       VARCHAR2(100 CHAR) NOT NULL, 
     porta                    VARCHAR2(100 CHAR) NOT NULL, 
     contexto                 VARCHAR2(100 CHAR) NOT NULL, 
     usuario                  VARCHAR2(100 CHAR) NOT NULL, 
     senha                    VARCHAR2(100 CHAR) NOT NULL,
     datahorafim              DATE NULL, 
	 CONSTRAINT evm_conexao_event_monitor_pkey PRIMARY KEY (idevmconexaoeventmonitor)
  );

alter table evm_check add constraint fk_evm_check_caract_princ foreign key (idcaracteristicaprincipal)  references caracteristica (idcaracteristica);

alter table evm_check add constraint fk_evm_check_caract_comp foreign key (idcaracteristicacomplementar) references caracteristica (idcaracteristica);

alter table evm_check add constraint fk_evm_check_tipoitconfig foreign key (idtipoitemconfiguracao) references tipoitemconfiguracao (idtipoitemconfiguracao);

alter table evm_check add constraint fk_evm_check_usuario_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_check add constraint fk_evm_check_usuario_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_conexao add constraint fk_evm_conexao_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_conexao add constraint fk_evm_conexao_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_cron add constraint fk_evm_cron_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_cron add constraint fk_evm_cron_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_check foreign key (idcheck) references evm_check (idcheck);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_evm_ger foreign key (idgerente) references evm_gerente (idgerente);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nag_evm_ger foreign key (idgerente) references evm_gerente (idgerente);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_evm_ger foreign key (idgerente) references evm_gerente (idgerente);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_itconf foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nag_itconf foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_itconf foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nag_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nag_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_tipoitconf foreign key (idtipoitemconfiguracao) references tipoitemconfiguracao (idtipoitemconfiguracao);

alter table evm_gerente_correlacao add constraint fk_evm_ger_cor_evm foreign key (idevmconexaoeventmonitor) references evm_conexao_event_monitor (idevmconexaoeventmonitor);

alter table evm_gerente_correlacao add constraint fk_evm_ger_cor_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerente_correlacao add constraint fk_evm_ger_cor_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerente add constraint fk_evm_ger_evm_conexao foreign key (idconexao) references evm_conexao (idconexao);

alter table evm_gerente add constraint fk_evm_ger_evm_cron foreign key (idcron) references evm_cron (idcron);

alter table evm_gerente add constraint fk_evm_ger_itconf foreign key (iditemconfiguracaopai) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerente add constraint fk_evm_ger_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerente add constraint fk_evm_ger_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_inventory_configuracao add constraint FK_evm_inv_conf_evm_conexao FOREIGN KEY (idconexao) REFERENCES evm_conexao (idconexao);

alter table evm_inventory_configuracao add constraint FK_evm_inv_conf_formula FOREIGN KEY (idformula) REFERENCES formula (idformula);
-- FIM - Rodrigo Ricardo P. Dorighello Guilherme (20/04/2015)

-- inicio - Euler Ramos (13/04/2015)
CREATE TABLE evm_acao
(
  idacao NUMBER(24,0) NOT NULL,
  nomeacao VARCHAR2(254 CHAR) NOT NULL,
  tipoacao VARCHAR2(254 CHAR) NOT NULL,
  datahorafim date,
  CONSTRAINT evm_acao_pkey PRIMARY KEY (idacao)
);

CREATE TABLE evm_acao_incidenterequisicao
(
	idacaoincidenterequisicao NUMBER(24,0) NOT NULL ENABLE,
	idacao NUMBER(24,0) NOT NULL ENABLE,
	idcontrato NUMBER(10,0) NOT NULL ENABLE,
	idorigem NUMBER(24,0) NOT NULL ENABLE,
	idsolicitante NUMBER(10,0) NOT NULL ENABLE,
	idtipodemandaservico NUMBER(10,0) NOT NULL ENABLE,
	idservico NUMBER(24,0) NOT NULL ENABLE,
	descricao CLOB NOT NULL ENABLE,
	impacto CHAR(1 CHAR),
	urgencia CHAR(1 CHAR),
	idgrupo NUMBER(10,0) NOT NULL ENABLE,
	enviaemailcriacao CHAR(1 CHAR),
	enviaemailfinalizacao CHAR(1 CHAR),
	enviaemailacoes CHAR(1 CHAR),
  CONSTRAINT pkevm_acao_incidenterequisicao PRIMARY KEY (idacaoincidenterequisicao),
  CONSTRAINT FK_evm_acaoincreq_acao FOREIGN KEY (idacao) REFERENCES evm_acao(idacao),
  CONSTRAINT FK_evm_acaoincreq_contratos FOREIGN KEY (idcontrato) REFERENCES contratos(idcontrato),
  CONSTRAINT FK_evm_acaoincreq_origematend FOREIGN KEY (idorigem) REFERENCES origematendimento(idorigem),
  CONSTRAINT FK_evm_acaoincreq_empregados FOREIGN KEY (idsolicitante) REFERENCES empregados(idempregado),
  CONSTRAINT FK_evm_acaoincreq_tipodemanda FOREIGN KEY (idtipodemandaservico) REFERENCES tipodemandaservico(idtipodemandaservico),
  CONSTRAINT FK_evm_acaoincreq_servico FOREIGN KEY (idservico) REFERENCES servico(idservico),
  CONSTRAINT FK_evm_acaoincreq_grupo FOREIGN KEY (idgrupo) REFERENCES grupo(idgrupo)
);
-- fim - Euler Ramos (13/04/2015)

-- INICIO - rodrigo.acorse (13/04/2015)
CREATE TABLE evm_acao_notificacao
(
  idacaonotificacao NUMBER(24,0) NOT NULL,
  idacao NUMBER(24,0) NOT NULL,
  assunto VARCHAR2(254 CHAR) NOT NULL,
  conteudo CLOB NOT NULL,
  CONSTRAINT evm_acao_notif_pkey PRIMARY KEY (idacaonotificacao) 
);

alter table evm_acao_notificacao add constraint fk_evm_acao_notificacao foreign key (idacao) references evm_acao (idacao);
	
CREATE TABLE evm_acao_notificacao_usuario
(
  idacaonotificacaousuario NUMBER(24,0) NOT NULL,
  idacaonotificacao NUMBER(24,0) NOT NULL,
  idusuario NUMBER(11,0) NOT NULL,
  CONSTRAINT evm_acao_notif_usr_pkey PRIMARY KEY (idacaonotificacaousuario) 
);

alter table evm_acao_notificacao_usuario add constraint fk_evm_acao_notif_usr_acao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);
alter table evm_acao_notificacao_usuario add constraint fk_evm_acao_notif_usr_usr foreign key (idusuario) references usuario (idusuario);

CREATE TABLE evm_acao_notificacao_grupo
(
  idacaonotificacaogrupo NUMBER(24,0) NOT NULL,
  idacaonotificacao NUMBER(24,0) NOT NULL,
  idgrupo NUMBER(11,0) NOT NULL,
  CONSTRAINT evm_acao_notif_grupo_pkey PRIMARY KEY (idacaonotificacaogrupo) 
);

alter table evm_acao_notificacao_grupo add constraint fk_evm_acao_notif_grupo_acao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);
alter table evm_acao_notificacao_grupo add constraint fk_evm_acao_notif_grupo_grupo foreign key (idgrupo) references grupo (idgrupo);

CREATE TABLE evm_acao_notificacao_email
(
  idacaonotificacaoemail NUMBER(24,0) NOT NULL,
  idacaonotificacao NUMBER(24,0) NOT NULL,
  email varchar(254) NOT NULL,
  CONSTRAINT evm_acao_notif_email_pkey PRIMARY KEY (idacaonotificacaoemail) 
);

alter table evm_acao_notificacao_email add constraint fk_evm_acao_notif_email_acao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);

CREATE TABLE evm_acao_automatica
(
  idacaoautomatica NUMBER(24,0) NOT NULL,
  nome VARCHAR2(254 CHAR) NOT NULL,
  datahorafim date,
  CONSTRAINT evm_acao_automatica_pkey PRIMARY KEY (idacaoautomatica) 
);

CREATE TABLE evm_acao_automatica_vinculo
(
  idacaoautomatica NUMBER(24,0) NOT NULL,
  idacao NUMBER(24,0) NOT NULL,
  CONSTRAINT evm_acao_vinculada_pkey PRIMARY KEY (idacaoautomatica, idacao) 
);

alter table evm_acao_automatica_vinculo add constraint fk_evm_acao_auto_vin_auto foreign key (idacaoautomatica) references evm_acao_automatica (idacaoautomatica);
	
alter table evm_acao_automatica_vinculo add constraint fk_evm_acao_auto_vin_acao foreign key (idacao) references evm_acao (idacao);

-- FIM - rodrigo.acorse (13/04/2015)

-- FIM SCRIPTS PROGRAMA 0005 PROJETO 0006 - GERENCIAMENTO DE EVENTOS

-- SCRIPTS PROGRAMA 005 PROJETO 097 - GERENCIAMENTO DE EVENTOS - SEGUNDA ENTREGA

-- INICIO - rodrigo.acorse - 30/04/2015
CREATE TABLE evm_acao_instancia
(
  idacaoinstancia NUMBER(24,0) NOT NULL,
  idocorrencia VARCHAR2(254 CHAR) NOT NULL,
  idacao NUMBER(24,0) NOT NULL,
  ferramenta VARCHAR2(254 CHAR) NOT NULL,
  status VARCHAR2(254 CHAR) NOT NULL,
  datahora DATE NOT NULL,
  CONSTRAINT evm_acao_instancia_pkey PRIMARY KEY (idacaoinstancia) 
);

ALTER TABLE evm_acao_instancia ADD CONSTRAINT fk_idacao FOREIGN KEY (idacao) REFERENCES evm_acao (idacao);

CREATE TABLE evm_acao_instancia_solicitacao
(
  idacaoinstanciasolicitacao NUMBER(24,0) NOT NULL,
  idacaoinstancia NUMBER(24,0) NOT NULL,
  idsolicitacaoservico NUMBER(24,0) NOT NULL,
  CONSTRAINT evm_acao_ins_solicitacao_pkey PRIMARY KEY (idacaoinstanciasolicitacao) 
);

ALTER TABLE evm_acao_instancia_solicitacao ADD CONSTRAINT fk_idacaoinstancia FOREIGN KEY (idacaoinstancia) REFERENCES evm_acao_instancia (idacaoinstancia);
ALTER TABLE evm_acao_instancia_solicitacao ADD CONSTRAINT fk_idsolicitacaoservico FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico);
-- FIM - rodrigo.acorse - 30/04/2015

-- INICIO - valdoilo.damasceno - 08/05/2015
delete from menu where nome = '$menu.nome.monitoramentoNagios';
delete from menu where nome = '$menu.nome.recurso';
delete from menu where nome = '$menu.nome.disponibilidadeRecurso';
delete from menu where nome = '$menu.nome.grupoRecursos';
delete from menu where nome = '$menu.nome.monitoramento';
delete from menu where nome = '$menu.nome.eventoMonitoramento';
delete from menu where nome = '$menu.nome.monitoramentoativos';
delete from menu where nome = '$menu.nome.mostraStatusCapturaInventario';
-- FIM - valdoilo.damasceno - 08/05/2015

-- FROM SCRIPTS PROGRAMA 0005 PROJETO 0006 e PROJETO 0097 - GERENCIAMENTO DE EVENTOS