-- SCRIPTS PROGRAMA 0005 PROJETO 0006 e PROJETO 0097 - GERENCIAMENTO DE EVENTOS

-- INCIO - Valdolo Damasceno (02/01/2015)
CREATE TABLE evm_check ( 
	idcheck integer NOT NULL,
	nome varchar(255) NOT NULL,
	idtipoitemconfiguracao integer NOT NULL,
	idcaracteristicaprincipal integer NOT NULL,
	tipocheck varchar(50) NOT NULL,
	idcaracteristicacomplementar integer DEFAULT NULL,
	simbolodaexpressaowarning varchar(50) NOT NULL,
	valordaexpressaowarning varchar(50) NOT NULL,
	simbolodaexpressaoexception varchar(50) NOT NULL,
	valordaexpressaoexception varchar(50) NOT NULL,
	idusuariocriador integer NOT NULL,
	idusuariomodificador integer DEFAULT NULL,
	datahorainicio DATE NOT NULL,
	datahorafim DATE,
	datahoraultimaalteracao DATE,
	tipovalorwarning varchar(50),
	tipovalorexception varchar(50)
);

CREATE TABLE evm_conexao ( 
	idconexao integer NOT NULL,
	nome varchar(50) NOT NULL,
	ferramenta varchar(50) NOT NULL,
	protocolo varchar(50),
	endereco varchar(50) NOT NULL,
	porta integer,
	usuario varchar(50),
	senha varchar(50),
	idusuariocriador integer NOT NULL,
	idusuariomodificador integer,
	datahorainicio DATE NOT NULL,
	datahorafim DATE,
	datahoraultimaalteracao DATE,
	status VARCHAR(7) NOT NULL,
	idevmconexaoeventmonitor integer
);

CREATE TABLE evm_cron ( 
	idcron integer NOT NULL,
	nome varchar(50) NOT NULL,
	expressao varchar(50) NOT NULL,
	idusuariocriador integer NOT NULL,
	idusuariomodificador integer,
	datahorainicio DATE NOT NULL,
	datahorafim DATE,
	datahoraultimaalteracao DATE
);

CREATE TABLE evm_gerenciado_inventory ( 
     idgerenciado                INTEGER NOT NULL, 
     idgerente                   INTEGER NOT NULL, 
     iditemconfiguracaofilho     INTEGER, 
     idtipoitemconfiguracao      INTEGER, 
     idcheck                     INTEGER NOT NULL, 
     idfluxoacaowarning          INTEGER, 
     idfluxoacaoexception        INTEGER, 
     simbolodaexpressaowarning   VARCHAR(50), 
     simbolodaexpressaoexception VARCHAR(50), 
     valordaexpressaowarning     VARCHAR(50), 
     valordaexpressaoexception   VARCHAR(50), 
     idusuariocriador            INTEGER NOT NULL, 
     idusuariomodificador        INTEGER, 
     datahorainicio              DATE NOT NULL, 
     datahorafim                 DATE, 
     datahoraultimaalteracao     DATE, 
     eplexception                TEXT, 
     eplwarning                  TEXT, 
     idevmtipoevento             INTEGER NOT NULL, 
     iditemconfiguracaopai       INTEGER, 
     identificacaoicfilho        VARCHAR(400), 
     identificacaoicpai          VARCHAR(400), 
	 CONSTRAINT evm_gerenciado_inventory_pkey PRIMARY KEY (idgerenciado)
);

CREATE TABLE evm_gerenciado_nagios ( 
     idgerenciado                INTEGER NOT NULL, 
     idgerente                   INTEGER NOT NULL, 
     servico                     VARCHAR(50), 
     iditemconfiguracaofilho     INTEGER NOT NULL, 
     idfluxoacaowarning          INTEGER, 
     idfluxoacaoexception        INTEGER, 
     simbolodaexpressaowarning   VARCHAR(50), 
     simbolodaexpressaoexception VARCHAR(50), 
     valordaexpressaowarning     VARCHAR(50), 
     valordaexpressaoexception   VARCHAR(50), 
     idusuariocriador            INTEGER NOT NULL, 
     idusuariomodificador        INTEGER, 
     datahorainicio              DATE NOT NULL, 
     datahorafim                 DATE, 
     datahoraultimaalteracao     DATE, 
     eplexception                TEXT, 
     eplwarning                  TEXT, 
     idevmtipoevento             INTEGER NOT NULL, 
     iditemconfiguracaopai       INTEGER, 
     identificacaoicfilho        VARCHAR(400), 
     identificacaoicpai          VARCHAR(400), 
     CONSTRAINT evm_gerenciado_nagios_pkey PRIMARY KEY (idgerenciado)
);

CREATE TABLE evm_gerenciado_zabbix ( 
     idgerenciado                INTEGER NOT NULL, 
     idgerente                   INTEGER NOT NULL, 
     nometrigger                 VARCHAR(50), 
     idtrigger                   VARCHAR(11) NOT NULL, 
     iditemconfiguracaofilho     INTEGER NOT NULL, 
     idfluxoacaowarning          INTEGER, 
     idfluxoacaoexception        INTEGER, 
     simbolodaexpressaowarning   VARCHAR(50), 
     simbolodaexpressaoexception VARCHAR(50), 
     valordaexpressaowarning     VARCHAR(50), 
     valordaexpressaoexception   VARCHAR(50), 
     idusuariocriador            INTEGER NOT NULL, 
     idusuariomodificador        INTEGER, 
     datahorainicio              DATE NOT NULL, 
     datahorafim                 DATE, 
     datahoraultimaalteracao     DATE, 
     eplexception                TEXT, 
     eplwarning                  TEXT, 
     idevmtipoevento             INTEGER NOT NULL, 
     iditemconfiguracaopai       INTEGER, 
     identificacaoicfilho        VARCHAR(400), 
     identificacaoicpai          VARCHAR(400), 
     CONSTRAINT evm_gerenciado_zabbix_pkey PRIMARY KEY (idgerenciado)
);

CREATE TABLE evm_gerente ( 
	idgerente integer NOT NULL,
	nome varchar(255) NOT NULL,
	idconexao integer NOT NULL,
	idcron integer NOT NULL,
	iditemconfiguracaopai integer,
	host varchar(50),
	idfluxodown integer,
	idusuariocriador integer NOT NULL,
	idusuariomodificador integer,
	datahorainicio DATE NOT NULL,
	datahorafim DATE,
	datahoraultimaalteracao DATE
);

create table evm_gerente_correlacao
(
	idgerentecorrelacao integer not null,
	nome varchar(255) NOT NULL,
	eplWarning TEXT,
	idfluxoacaowarning integer,
	eplException TEXT,
	idfluxoacaoexception integer,
	idusuariocriador integer not null,
	idusuariomodificador integer,
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	idevmtipoevento integer not null,
	idevmconexaoeventmonitor integer not null
);

CREATE TABLE evm_inventory_configuracao (
	idconfiguracao INTEGER NOT NULL,
	idinventory VARCHAR(255) NOT NULL,
	faixaip VARCHAR(4000) NOT NULL,
	contexto VARCHAR(50) NOT NULL,
	ipservidor VARCHAR(50),
	portanet INTEGER,
	timeout INTEGER,
	numerotentativas INTEGER,
	portasnmp INTEGER,
	nomesnmpcommunity VARCHAR(255),
	idformula INTEGER,
	datahorainicio DATE NOT NULL,
	datahorafim DATE,
	idconexao INTEGER NOT NULL,
	idcron INTEGER NOT NULL,
	conteudoformula TEXT,
	expressaoCron VARCHAR(50) NOT NULL,
	destinoInventario TEXT,
	idevmconexaoeventmonitor INTEGER
);

-- INICIO - MURILO GABRIEL RODRIGUES - 25/03/2015
CREATE TABLE evm_tipoevento 
  ( 
     idevmtipoevento      integer NOT NULL, 
     idgrupoevmtipoevento integer, 
     nome                 VARCHAR(200) NOT NULL, 
     datahorafim          DATE NULL, 
     CONSTRAINT idevmtipoevento_pkey PRIMARY KEY (idevmtipoevento) 
  );

CREATE TABLE evm_grupotipoevento 
  ( 
     idgrupoevmtipoevento integer NOT NULL, 
     nome                 VARCHAR(200) NOT NULL, 
     datahorafim          DATE NULL, 
     CONSTRAINT idgrupoevmtipoeventor_pkey PRIMARY KEY (idgrupoevmtipoevento) 
  );
-- FIM - MURILO GABRIEL RODRIGUES - 25/03/2015

-- INICIO - MURILO GABRIEL RODRIGUES - 09/04/2015
CREATE TABLE evm_conexao_event_monitor 
  ( 
     idevmconexaoeventmonitor integer NOT NULL, 
     identificador            VARCHAR(100) NOT NULL, 
     nome                     VARCHAR(200) NOT NULL, 
     protocolo                VARCHAR(100) NOT NULL, 
     ip                       VARCHAR(100) NOT NULL, 
     porta                    VARCHAR(100) NOT NULL, 
     contexto                 VARCHAR(100) NOT NULL, 
     usuario                  VARCHAR(100) NOT NULL, 
     senha                    VARCHAR(100) NOT NULL, 
     datahorafim              DATE NULL, 
     CONSTRAINT idevmconexaoeventmonitor_pkey PRIMARY KEY (idevmconexaoeventmonitor) 
  );
-- FIM - MURILO GABRIEL RODRIGUES - 09/04/2015

-- INCIO - PRIMARY KEY -
ALTER TABLE evm_check ADD CONSTRAINT PK_evm_check PRIMARY KEY (idcheck);

ALTER TABLE evm_conexao ADD CONSTRAINT PK_evm_conexao PRIMARY KEY (idconexao);

ALTER TABLE evm_cron ADD CONSTRAINT PK_evm_cron PRIMARY KEY (idcron);

ALTER TABLE evm_gerente ADD CONSTRAINT PK_evm_gerente PRIMARY KEY (idgerente);

ALTER TABLE evm_gerente_correlacao ADD CONSTRAINT PK_evm_gerente_correl PRIMARY KEY (idgerentecorrelacao);

ALTER TABLE evm_inventory_configuracao ADD CONSTRAINT PK_evm_inventory_configuracao_idconfiguracao PRIMARY KEY (idconfiguracao);
-- FIM - PRIMARY KEY -

-- INICIO - FOREIGN KEY -
ALTER TABLE evm_check ADD CONSTRAINT FK_evm_check_caracteristica_prin FOREIGN KEY (idcaracteristicaprincipal) REFERENCES caracteristica (idcaracteristica);
ALTER TABLE evm_check ADD CONSTRAINT FK_evm_check_caracteristica_comp FOREIGN KEY (idcaracteristicacomplementar) REFERENCES caracteristica (idcaracteristica);
ALTER TABLE evm_check ADD CONSTRAINT FK_evm_check_tipoitemconfiguracao FOREIGN KEY (idtipoitemconfiguracao) REFERENCES tipoitemconfiguracao (idtipoitemconfiguracao);
ALTER TABLE evm_check ADD CONSTRAINT FK_evm_check_usuario_cria FOREIGN KEY (idusuariocriador) REFERENCES usuario (idusuario);
ALTER TABLE evm_check ADD CONSTRAINT FK_evm_check_usuario_modif FOREIGN KEY (idusuariomodificador) REFERENCES usuario (idusuario);

ALTER TABLE evm_conexao ADD CONSTRAINT FK_evm_conexao_usuario_cria FOREIGN KEY (idusuariocriador) REFERENCES usuario (idusuario);
ALTER TABLE evm_conexao ADD CONSTRAINT FK_evm_conexao_usuario_modif FOREIGN KEY (idusuariomodificador) REFERENCES usuario (idusuario);

ALTER TABLE evm_cron ADD CONSTRAINT FK_evm_cron_usuario_cria FOREIGN KEY (idusuariocriador) REFERENCES usuario (idusuario);
ALTER TABLE evm_cron ADD CONSTRAINT FK_evm_cron_usuario_modif FOREIGN KEY (idusuariomodificador) REFERENCES usuario (idusuario);

ALTER TABLE evm_gerenciado_inventory ADD CONSTRAINT FK_evm_gerenciado_inventory_evm_check FOREIGN KEY (idcheck) REFERENCES evm_check (idcheck);
ALTER TABLE evm_gerenciado_inventory ADD CONSTRAINT FK_evm_gerenciado_inventory_evm_gerente FOREIGN KEY (idgerente) REFERENCES evm_gerente (idgerente);
ALTER TABLE evm_gerenciado_inventory ADD CONSTRAINT FK_evm_gerenciado_inventory_ic FOREIGN KEY (iditemconfiguracaofilho) REFERENCES itemconfiguracao (iditemconfiguracao);
ALTER TABLE evm_gerenciado_inventory ADD CONSTRAINT FK_evm_gerenciado_inventory_usu_cria FOREIGN KEY (idusuariocriador) REFERENCES usuario (idusuario);
ALTER TABLE evm_gerenciado_inventory ADD CONSTRAINT FK_evm_gerenciado_inventory_usu_modi FOREIGN KEY (idusuariomodificador) REFERENCES usuario (idusuario);

ALTER TABLE evm_gerenciado_nagios ADD CONSTRAINT FK_evm_gerenciado_evm_gerente FOREIGN KEY (idgerente) REFERENCES evm_gerente (idgerente);
ALTER TABLE evm_gerenciado_nagios ADD CONSTRAINT FK_evm_gerenciado_ic FOREIGN KEY (iditemconfiguracaofilho) REFERENCES itemconfiguracao (iditemconfiguracao);
ALTER TABLE evm_gerenciado_nagios ADD CONSTRAINT FK_evm_gerenciado_usu_cria FOREIGN KEY (idusuariocriador) REFERENCES usuario (idusuario);
ALTER TABLE evm_gerenciado_nagios ADD CONSTRAINT FK_evm_gerenciado_usu_modi FOREIGN KEY (idusuariomodificador) REFERENCES usuario (idusuario);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_evm_ger foreign key (idgerente) references evm_gerente (idgerente);
alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_itconf foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);
alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_usr_cri foreign key (idusuariocriador) references usuario (idusuario);
alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

ALTER TABLE evm_gerente ADD CONSTRAINT FK_evm_gerente_evm_conexao FOREIGN KEY (idconexao) REFERENCES evm_conexao (idconexao);
ALTER TABLE evm_gerente ADD CONSTRAINT FK_evm_gerente_evm_cron FOREIGN KEY (idcron) REFERENCES evm_cron (idcron);
ALTER TABLE evm_gerente ADD CONSTRAINT FK_evm_gerente_itemconfiguracao FOREIGN KEY (iditemconfiguracaopai) REFERENCES itemconfiguracao (iditemconfiguracao);
ALTER TABLE evm_gerente ADD CONSTRAINT FK_evm_gerente_usuario_cria FOREIGN KEY (idusuariocriador) REFERENCES usuario (idusuario);
ALTER TABLE evm_gerente ADD CONSTRAINT FK_evm_gerente_usuario_modif FOREIGN KEY (idusuariomodificador) REFERENCES usuario (idusuario);

alter table evm_gerente_correlacao add constraint fk_evm_ger_cor_evm foreign key (idevmconexaoeventmonitor) references evm_conexao_event_monitor (idevmconexaoeventmonitor);
alter table evm_gerente_correlacao add constraint fk_evm_ger_cor_usr_cri foreign key (idusuariocriador) references usuario (idusuario);
alter table evm_gerente_correlacao add constraint fk_evm_ger_cor_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

ALTER TABLE evm_inventory_configuracao ADD CONSTRAINT FK_evm_inventory_configuracao_evm_conexao FOREIGN KEY (idconexao) REFERENCES evm_conexao (idconexao);
ALTER TABLE evm_inventory_configuracao ADD CONSTRAINT FK_evm_inventory_configuracao_formula FOREIGN KEY (idformula) REFERENCES formula (idformula);
-- FIM - FOREIGN KEY -

-- fim - Valdolo Damasceno (02/01/2015)

-- inicio - Euler Ramos (13/04/2015)
CREATE TABLE evm_acao
(
  idacao bigint NOT NULL,
  nomeacao character varying(254) NOT NULL,
  tipoacao character varying(254) NOT NULL,
  datahorafim DATE,
  CONSTRAINT evm_acao_pkey PRIMARY KEY (idacao) 
);

CREATE TABLE evm_acao_incidenterequisicao 
(
	idacaoincidenterequisicao bigint NOT NULL,
	idacao bigint NOT NULL,
	idcontrato integer NOT NULL,
	idorigem bigint NOT NULL,
	idsolicitante integer NOT NULL,
	idtipodemandaservico integer NOT NULL,
	idservico bigint NOT NULL,
	descricao text NOT NULL,
	impacto character(1) DEFAULT NULL::bpchar,
	urgencia character(1) DEFAULT NULL::bpchar,
	idgrupo integer NOT NULL,
	enviaemailcriacao character(1) DEFAULT NULL::bpchar,
	enviaemailfinalizacao character(1) DEFAULT NULL::bpchar,
	enviaemailacoes character(1) DEFAULT NULL::bpchar,
  CONSTRAINT pkevm_acao_incidenterequisicao PRIMARY KEY (idacaoincidenterequisicao),
  CONSTRAINT FK_evm_acaoincreq_acao FOREIGN KEY (idacao) REFERENCES evm_acao(idacao),
  CONSTRAINT FK_evm_acaoincreq_contratos FOREIGN KEY (idcontrato) REFERENCES contratos(idcontrato),
  CONSTRAINT FK_evm_acaoincreq_origematend FOREIGN KEY (idorigem) REFERENCES origematendimento(idorigem),
  CONSTRAINT FK_evm_acaoincreq_empregados FOREIGN KEY (idsolicitante) REFERENCES empregados(idempregado),
  CONSTRAINT FK_evm_acaoincreq_tipodemanda FOREIGN KEY (idtipodemandaservico) REFERENCES tipodemandaservico(idtipodemandaservico),
  CONSTRAINT FK_evm_acaoincreq_servico FOREIGN KEY (idservico) REFERENCES servico(idservico),
  CONSTRAINT FK_evm_acaoincreq_grupo FOREIGN KEY (idgrupo) REFERENCES grupo(idgrupo)
);

-- fim - Euler Ramos (13/04/2015)

-- INICIO - rodrigo.acorse (13/04/2015)
CREATE TABLE evm_acao_notificacao
(
  idacaonotificacao bigint NOT NULL,
  idacao bigint NOT NULL,
  assunto character varying(254) NOT NULL,
  conteudo text NOT NULL,
  CONSTRAINT evm_acao_notificacao_pkey PRIMARY KEY (idacaonotificacao) 
);

alter table evm_acao_notificacao add constraint fk_evm_acao_notificacao_evm_acao 
	foreign key (idacao) references evm_acao (idacao);
	
CREATE TABLE evm_acao_notificacao_usuario
(
  idacaonotificacaousuario bigint NOT NULL,
  idacaonotificacao bigint NOT NULL,
  idusuario integer NOT NULL,
  CONSTRAINT evm_acao_notificacao_usuario_pkey PRIMARY KEY (idacaonotificacaousuario) 
);

alter table evm_acao_notificacao_usuario add constraint fk_evm_acao_notificacao_usuario_evm_acao_notificacao
	foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);
alter table evm_acao_notificacao_usuario add constraint fk_evm_acao_notificacao_usuario_usuario
	foreign key (idusuario) references usuario (idusuario);

CREATE TABLE evm_acao_notificacao_grupo
(
  idacaonotificacaogrupo bigint NOT NULL,
  idacaonotificacao bigint NOT NULL,
  idgrupo integer NOT NULL,
  CONSTRAINT evm_acao_notificacao_grupo_pkey PRIMARY KEY (idacaonotificacaogrupo) 
);

alter table evm_acao_notificacao_grupo add constraint fk_evm_acao_notificacao_grupo_evm_acao_notificacao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);
alter table evm_acao_notificacao_grupo add constraint fk_evm_acao_notificacao_grupo_grupo foreign key (idgrupo) references grupo (idgrupo);

CREATE TABLE evm_acao_notificacao_email
(
  idacaonotificacaoemail bigint NOT NULL,
  idacaonotificacao bigint NOT NULL,
  email character varying(254) NOT NULL,
  CONSTRAINT evm_acao_notificacao_email_pkey PRIMARY KEY (idacaonotificacaoemail) 
);

alter table evm_acao_notificacao_email add constraint fk_evm_acao_notificacao_email_evm_acao_notificacao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);

CREATE TABLE evm_acao_automatica
(
  idacaoautomatica bigint NOT NULL,
  nome character varying(254) NOT NULL,
  datahorafim DATE,
  CONSTRAINT evm_acao_automatica_pkey PRIMARY KEY (idacaoautomatica) 
);

CREATE TABLE evm_acao_automatica_vinculo
(
  idacaoautomatica bigint NOT NULL,
  idacao bigint NOT NULL,
  CONSTRAINT evm_acao_vinculada_pkey PRIMARY KEY (idacaoautomatica, idacao) 
);

alter table evm_acao_automatica_vinculo add constraint fk_evm_acao_automatica_vinculo_evm_acao_automatica foreign key (idacaoautomatica) references evm_acao_automatica (idacaoautomatica);
	
alter table evm_acao_automatica_vinculo add constraint fk_evm_acao_automatica_vinculo_evm_acao foreign key (idacao) references evm_acao (idacao);

-- FIM - rodrigo.acorse (13/04/2015)

-- FIM SCRIPTS PROGRAMA 0005 PROJETO 0006 - GERENCIAMENTO DE EVENTOS

-- SCRIPTS PROGRAMA 005 PROJETO 097 - GERENCIAMENTO DE EVENTOS - SEGUNDA ENTREGA

-- INICIO - rodrigo.acorse - 30/04/2015
CREATE TABLE evm_acao_instancia
(
  idacaoinstancia bigint NOT NULL,
  idocorrencia character varying(254) NOT NULL,
  idacao bigint NOT NULL,
  ferramenta character varying(254) NOT NULL,
  status character varying(254) NOT NULL,
  datahora date NOT NULL,
  CONSTRAINT evm_acao_instancia_pkey PRIMARY KEY (idacaoinstancia) 
);

ALTER TABLE evm_acao_instancia ADD CONSTRAINT fk_idacao FOREIGN KEY (idacao)  REFERENCES evm_acao (idacao);

CREATE TABLE evm_acao_instancia_solicitacao 
(
  idacaoinstanciasolicitacao bigint NOT NULL,
  idacaoinstancia bigint NOT NULL,
  idsolicitacaoservico bigint NOT NULL,
  CONSTRAINT evm_acao_ins_solicitacao_pkey PRIMARY KEY (idacaoinstanciasolicitacao) 
);

ALTER TABLE evm_acao_instancia_solicitacao ADD CONSTRAINT fk_idacaoinstancia FOREIGN KEY (idacaoinstancia) REFERENCES evm_acao_instancia  (idacaoinstancia);
ALTER TABLE evm_acao_instancia_solicitacao ADD CONSTRAINT fk_idsolicitacaoservico FOREIGN KEY (idsolicitacaoservico) REFERENCES solicitacaoservico (idsolicitacaoservico);
-- FIM - rodrigo.acorse - 30/04/2015

-- INICIO - valdoilo.damasceno - 08/05/2015
delete from menu where nome = '$menu.nome.monitoramentoNagios';
delete from menu where nome = '$menu.nome.recurso';
delete from menu where nome = '$menu.nome.disponibilidadeRecurso';
delete from menu where nome = '$menu.nome.grupoRecursos';
delete from menu where nome = '$menu.nome.monitoramento';
delete from menu where nome = '$menu.nome.eventoMonitoramento';
delete from menu where nome = '$menu.nome.monitoramentoativos';
delete from menu where nome = '$menu.nome.mostraStatusCapturaInventario';
-- FIM - valdoilo.damasceno - 08/05/2015

-- FROM SCRIPTS PROGRAMA 0005 PROJETO 0006 e PROJETO 0097 - GERENCIAMENTO DE EVENTOS