-- SCRIPTS PROGRAMA 0005 PROJETO 0006 e PROJETO 0097 - GERENCIAMENTO DE EVENTOS

-- INCIO - Rodrigo Ricardo P. Dorighello Guilherme (20/04/2015)
create table evm_check
(
	idcheck integer not null,
	nome varchar(255) not null,
	idtipoitemconfiguracao integer not null,
	idcaracteristicaprincipal integer not null,
	tipocheck varchar(50) not null,
	idcaracteristicacomplementar integer default null,
	simbolodaexpressaowarning varchar(50) not null,
	valordaexpressaowarning varchar(50) not null,
	simbolodaexpressaoexception varchar(50) not null,
	valordaexpressaoexception varchar(50) not null,
	idusuariocriador integer not null,
	idusuariomodificador integer default null,
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	tipovalorwarning varchar(50),
	tipovalorexception varchar(50),
	CONSTRAINT evm_check_pkey PRIMARY KEY (idcheck)
);


create table evm_conexao
(
	idconexao integer not null,
	nome varchar(50) not null,
	ferramenta varchar(50) not null,
	protocolo varchar(50),
	endereco varchar(50) not null,
	porta integer,
	usuario varchar(50),
	senha varchar(50),
	idusuariocriador integer not null,
	idusuariomodificador integer,
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	status VARCHAR(7) NOT NULL,
	idevmconexaoeventmonitor integer,
	CONSTRAINT evm_conexao_pkey PRIMARY KEY (idconexao)
);


create table evm_cron
(
	idcron integer not null,
	nome varchar(50) not null,
	expressao varchar(50) not null,
	idusuariocriador integer not null,
	idusuariomodificador integer,
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	CONSTRAINT evm_cron_pkey PRIMARY KEY (idcron)
);


create table evm_gerenciado_inventory
(
	idgerenciado integer not null,
	idgerente integer not null,
	iditemconfiguracaofilho integer,
	idtipoitemconfiguracao integer,
	idcheck integer not null,
	idfluxoacaowarning integer,
	idfluxoacaoexception integer,
	simbolodaexpressaowarning varchar(50),
	simbolodaexpressaoexception varchar(50),
	valordaexpressaowarning varchar(50),
	valordaexpressaoexception varchar(50),
	idusuariocriador integer not null,
	idusuariomodificador integer,
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	eplException TEXT,
	eplWarning TEXT,
	idevmtipoevento integer not null,
	iditemconfiguracaopai bigint,
	identificacaoicfilho varchar(400),
	identificacaoicpai varchar(400),
	CONSTRAINT evm_gerenciado_inventory_pkey PRIMARY KEY (idgerenciado)
);


create table evm_gerenciado_nagios
(
	idgerenciado integer not null,
	idgerente integer not null,
	servico varchar(50),
	iditemconfiguracaofilho integer not null,
	idfluxoacaowarning integer,
	idfluxoacaoexception integer,
	simbolodaexpressaowarning varchar(50),
	simbolodaexpressaoexception varchar(50),
	valordaexpressaowarning varchar(50),
	valordaexpressaoexception varchar(50),
	idusuariocriador integer not null,
	idusuariomodificador integer,
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	eplException TEXT,
	eplWarning TEXT,
	idevmtipoevento integer not null,
	iditemconfiguracaopai bigint,
	identificacaoicfilho varchar(400),
	identificacaoicpai varchar(400),
	CONSTRAINT evm_gerenciado_nagios_pkey PRIMARY KEY (idgerenciado)
);

create table evm_gerenciado_zabbix
(
	idgerenciado integer not null,
	idgerente integer not null,
	servico varchar(50),
	iditemconfiguracaofilho integer not null,
	idfluxoacaowarning integer,
	idfluxoacaoexception integer,
	simbolodaexpressaowarning varchar(50),
	simbolodaexpressaoexception varchar(50),
	valordaexpressaowarning varchar(50),
	valordaexpressaoexception varchar(50),
	idusuariocriador integer not null,
	idusuariomodificador integer,
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	eplException TEXT,
	eplWarning TEXT,
	idevmtipoevento integer not null,
	iditemconfiguracaopai bigint,
	identificacaoicfilho VARCHAR(400),
	identificacaoicpai VARCHAR(400),
	CONSTRAINT evm_gerenciado_zabbix_pkey PRIMARY KEY (idgerenciado)
);

create table evm_gerente
(
	idgerente integer not null,
	nome varchar(255) not null,
	idconexao integer not null,
	idcron integer not null,
	iditemconfiguracaopai integer,
	host varchar(50),
	idfluxodown integer,
	idusuariocriador integer not null,
	idusuariomodificador integer,
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	CONSTRAINT evm_gerente_pkey PRIMARY KEY (idgerente)
);


create table evm_gerente_correlacao
(
	idgerentecorrelacao integer not null,
	nome varchar(50) not null,
	eplWarning TEXT,
	idfluxoacaowarning integer,
	eplException TEXT,
	idfluxoacaoexception integer,
	idusuariocriador integer not null,
	idusuariomodificador integer,
	datahorainicio date not null,
	datahorafim date null,
	datahoraultimaalteracao date null,
	idevmtipoevento integer not null,
	idevmconexaoeventmonitor integer,
	CONSTRAINT evm_gerente_correl_pkey PRIMARY KEY (idgerentecorrelacao)
);

create table evm_inventory_configuracao
(
	idconfiguracao INTEGER NOT NULL,
	idinventory VARCHAR(255) NOT NULL,
	faixaip VARCHAR(4000) NOT NULL,
	contexto VARCHAR(50) NOT NULL,
	ipservidor VARCHAR(50),
	portanet INTEGER,
	timeout INTEGER,
	numerotentativas INTEGER,
	portasnmp INTEGER,
	nomesnmpcommunity VARCHAR(255),
	idformula INTEGER,
	datahorainicio DATE NOT NULL,
	datahorafim DATE NULL,
	idconexao INTEGER NOT NULL,
	idcron INTEGER NOT NULL,
	conteudoformula TEXT,
	expressaoCron varchar(50) NOT NULL,
	destinoInventario TEXT,
	idevmconexaoeventmonitor bigint,
	CONSTRAINT evm_inventory_config_pkey PRIMARY KEY (idconfiguracao)
);

create table evm_tipoevento 
  ( 
     idevmtipoevento      integer NOT NULL, 
     idgrupoevmtipoevento integer, 
     nome                 VARCHAR(200) NOT NULL, 
     datahorafim          DATE NULL, 
	 CONSTRAINT evm_tipoevento_pkey PRIMARY KEY (idevmtipoevento)
  );

create table evm_grupotipoevento 
  ( 
     idgrupoevmtipoevento integer NOT NULL, 
     nome                 VARCHAR(200) NOT NULL, 
     datahorafim          DATE NULL, 
	 CONSTRAINT evm_grupotipoevento_pkey PRIMARY KEY (idgrupoevmtipoevento)
  );

create table evm_conexao_event_monitor 
  ( 
     idevmconexaoeventmonitor integer NOT NULL, 
     identificador            VARCHAR(100) NOT NULL, 
     nome                     VARCHAR(200) NOT NULL, 
     protocolo                VARCHAR(100) NOT NULL, 
     ip                       VARCHAR(100) NOT NULL, 
     porta                    VARCHAR(100) NOT NULL, 
     contexto                 VARCHAR(100) NOT NULL, 
     usuario                  VARCHAR(100) NOT NULL, 
     senha                    VARCHAR(100) NOT NULL, 
     datahorafim              DATE NULL, 
	 CONSTRAINT evm_conexao_event_monitor_pkey PRIMARY KEY (idevmconexaoeventmonitor)
  );
  
alter table evm_check add constraint fk_evm_check_caract_princ foreign key (idcaracteristicaprincipal) references caracteristica (idcaracteristica);

alter table evm_check add constraint fk_evm_check_caract_comp foreign key (idcaracteristicacomplementar) references caracteristica (idcaracteristica);

alter table evm_check add constraint fk_evm_check_tipoitconfig foreign key (idtipoitemconfiguracao) references tipoitemconfiguracao (idtipoitemconfiguracao);

alter table evm_check add constraint fk_evm_check_usuario_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_check add constraint fk_evm_check_usuario_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_conexao add constraint fk_evm_conexao_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_conexao add constraint fk_evm_conexao_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_cron add constraint fk_evm_cron_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_cron add constraint fk_evm_cron_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_check foreign key (idcheck) references evm_check (idcheck);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_evm_ger foreign key (idgerente) references evm_gerente (idgerente);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nag_evm_ger foreign key (idgerente) references evm_gerente (idgerente);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_evm_ger foreign key (idgerente) references evm_gerente (idgerente);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_itconf foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nag_itconf foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_itconf foreign key (iditemconfiguracaofilho) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nag_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerenciado_nagios add constraint fk_evm_ger_nag_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerenciado_zabbix add constraint fk_evm_ger_zab_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerente_correlacao add constraint fk_evm_ger_cor_evm foreign key (idevmconexaoeventmonitor) references evm_conexao_event_monitor (idevmconexaoeventmonitor);

alter table evm_gerente_correlacao add constraint fk_evm_ger_cor_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerente_correlacao add constraint fk_evm_ger_cor_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_gerenciado_inventory add constraint fk_evm_ger_inv_tipoitconf foreign key (idtipoitemconfiguracao) references tipoitemconfiguracao (idtipoitemconfiguracao);

alter table evm_gerente add constraint fk_evm_ger_evm_conexao foreign key (idconexao) references evm_conexao (idconexao);

alter table evm_gerente add constraint fk_evm_ger_evm_cron foreign key (idcron) references evm_cron (idcron);

alter table evm_gerente add constraint fk_evm_ger_itconf foreign key (iditemconfiguracaopai) references itemconfiguracao (iditemconfiguracao);

alter table evm_gerente add constraint fk_evm_ger_usr_cri foreign key (idusuariocriador) references usuario (idusuario);

alter table evm_gerente add constraint fk_evm_ger_usr_mod foreign key (idusuariomodificador) references usuario (idusuario);

alter table evm_inventory_configuracao add constraint FK_evm_inv_conf_evm_conexao FOREIGN KEY (idconexao) REFERENCES evm_conexao (idconexao);

alter table evm_inventory_configuracao add constraint FK_evm_inv_conf_formula FOREIGN KEY (idformula) REFERENCES formula (idformula);
-- FIM - Rodrigo Ricardo P. Dorighello Guilherme (20/04/2015)

-- inicio - Euler Ramos (13/04/2015)
CREATE TABLE [dbo].[evm_acao] 
(
  [idacao] [bigint] NOT NULL,
  [nomeacao] [varchar](254) NOT NULL,
  [tipoacao] [varchar](254) NOT NULL,
  [datahorafim]  [date] NULL,
  CONSTRAINT evm_acao_pkey PRIMARY KEY ([idacao])
);

CREATE TABLE [dbo].[evm_acao_incidenterequisicao] 
(
	[idacaoincidenterequisicao] [bigint] NOT NULL,
	[idacao] [bigint] NOT NULL,
	[idcontrato] [int] NOT NULL,
	[idorigem] [bigint] NOT NULL,
	[idsolicitante] [int] NOT NULL,
	[idtipodemandaservico] [int] NOT NULL,
	[idservico] bigint NOT NULL,
	[descricao] [text] NOT NULL,
	[impacto] [char](1) NULL,
	[urgencia] [char](1) NULL,
	[idgrupo] [int] NOT NULL,
	[enviaemailcriacao] [char](1) NULL,
	[enviaemailfinalizacao] [char](1) NULL,
	[enviaemailacoes] [char](1) NULL,
  CONSTRAINT pkevm_acao_incidenterequisicao PRIMARY KEY ([idacaoincidenterequisicao]),
  CONSTRAINT FK_evm_acaoincreq_acao FOREIGN KEY ([idacao]) REFERENCES [evm_acao]([idacao]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT FK_evm_acao_incidenterequisicao_contratos FOREIGN KEY ([idcontrato]) REFERENCES [contratos] ([idcontrato]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT FK_evm_acao_incidenterequisicao_origematendimento FOREIGN KEY ([idorigem]) REFERENCES [origematendimento] ([idorigem]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT FK_evm_acao_incidenterequisicao_empregados FOREIGN KEY ([idsolicitante]) REFERENCES [empregados] ([idempregado]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT FK_evm_acao_incidenterequisicao_tipodemandaservico FOREIGN KEY ([idtipodemandaservico]) REFERENCES [tipodemandaservico] ([idtipodemandaservico]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT FK_evm_acao_incidenterequisicao_servico FOREIGN KEY ([idservico]) REFERENCES [servico] ([idservico]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT FK_evm_acao_incidenterequisicao_grupo FOREIGN KEY ([idgrupo]) REFERENCES [grupo] ([idgrupo]) ON DELETE CASCADE ON UPDATE CASCADE
);

-- fim - Euler Ramos (13/04/2015)

-- INICIO - rodrigo.acorse (13/04/2015)
CREATE TABLE evm_acao_notificacao
(
  idacaonotificacao bigint NOT NULL,
  idacao bigint NOT NULL,
  assunto varchar(254) NOT NULL,
  conteudo text NOT NULL,
  CONSTRAINT evm_acao_notificacao_pkey PRIMARY KEY (idacaonotificacao) 
);

alter table evm_acao_notificacao add constraint fk_evm_acao_notificacao_evm_acao foreign key (idacao) references evm_acao (idacao);
	
CREATE TABLE evm_acao_notificacao_usuario
(
  idacaonotificacaousuario bigint NOT NULL,
  idacaonotificacao bigint NOT NULL,
  idusuario integer NOT NULL,
  CONSTRAINT evm_acao_notificacao_usuario_pkey PRIMARY KEY (idacaonotificacaousuario) 
);

alter table evm_acao_notificacao_usuario add constraint fk_evm_acao_notificacao_usuario_evm_acao_notificacao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);
alter table evm_acao_notificacao_usuario add constraint fk_evm_acao_notificacao_usuario_usuario foreign key (idusuario) references usuario (idusuario);

CREATE TABLE evm_acao_notificacao_grupo
(
  idacaonotificacaogrupo bigint NOT NULL,
  idacaonotificacao bigint NOT NULL,
  idgrupo integer NOT NULL,
  CONSTRAINT evm_acao_notificacao_grupo_pkey PRIMARY KEY (idacaonotificacaogrupo) 
);

alter table evm_acao_notificacao_grupo add constraint fk_evm_acao_notificacao_grupo_evm_acao_notificacao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);
alter table evm_acao_notificacao_grupo add constraint fk_evm_acao_notificacao_grupo_grupo foreign key (idgrupo) references grupo (idgrupo);

CREATE TABLE evm_acao_notificacao_email
(
  idacaonotificacaoemail bigint NOT NULL,
  idacaonotificacao bigint NOT NULL,
  email varchar(254) NOT NULL,
  CONSTRAINT evm_acao_notificacao_email_pkey PRIMARY KEY (idacaonotificacaoemail) 
);

alter table evm_acao_notificacao_email add constraint fk_evm_acao_notificacao_email_evm_acao_notificacao foreign key (idacaonotificacao) references evm_acao_notificacao (idacaonotificacao);

CREATE TABLE evm_acao_automatica
(
  idacaoautomatica bigint NOT NULL,
  nome varchar(254) NOT NULL,
  datahorafim date NULL,
  CONSTRAINT evm_acao_automatica_pkey PRIMARY KEY (idacaoautomatica) 
);

CREATE TABLE evm_acao_automatica_vinculo
(
  idacaoautomatica bigint NOT NULL,
  idacao bigint NOT NULL,
  CONSTRAINT evm_acao_vinculada_pkey PRIMARY KEY (idacaoautomatica, idacao) 
);

alter table evm_acao_automatica_vinculo add constraint fk_evm_acao_automatica_vinculo_evm_acao_automatica foreign key (idacaoautomatica) references evm_acao_automatica (idacaoautomatica);
	
alter table evm_acao_automatica_vinculo add constraint fk_evm_acao_automatica_vinculo_evm_acao foreign key (idacao) references evm_acao (idacao);
-- FIM - rodrigo.acorse (13/04/2015)

-- FIM SCRIPTS PROGRAMA 0005 PROJETO 0006 - GERENCIAMENTO DE EVENTOS

-- SCRIPTS PROGRAMA 005 PROJETO 097 - GERENCIAMENTO DE EVENTOS - SEGUNDA ENTREGA

-- INICIO - rodrigo.acorse - 30/04/2015
create table evm_acao_instancia
(
  idacaoinstancia bigint NOT NULL,
  idocorrencia varchar(254) NOT NULL,
  idacao bigint NOT NULL,
  ferramenta varchar(254) NOT NULL,
  status varchar(254) NOT NULL,
  datahora date NOT NULL,
  constraint evm_acao_instancia_pkey primary key (idacaoinstancia) 
);

alter table evm_acao_instancia add constraint fk_idacao foreign key (idacao) references evm_acao (idacao);

create table evm_acao_instancia_solicitacao
(
  idacaoinstanciasolicitacao bigint NOT NULL,
  idacaoinstancia bigint NOT NULL,
  idsolicitacaoservico bigint NOT NULL,
  constraint evm_acao_ins_solicitacao_pkey primary key (idacaoinstanciasolicitacao) 
);

alter table evm_acao_instancia_solicitacao add constraint fk_idacaoinstancia foreign key (idacaoinstancia) references evm_acao_instancia (idacaoinstancia);
alter table evm_acao_instancia_solicitacao add constraint fk_idsolicitacaoservico foreign key (idsolicitacaoservico) references solicitacaoservico (idsolicitacaoservico);
-- FIM - rodrigo.acorse - 30/04/2015

-- INICIO - valdoilo.damasceno - 08/05/2015
delete from menu where nome = '$menu.nome.monitoramentoNagios';
delete from menu where nome = '$menu.nome.recurso';
delete from menu where nome = '$menu.nome.disponibilidadeRecurso';
delete from menu where nome = '$menu.nome.grupoRecursos';
delete from menu where nome = '$menu.nome.monitoramento';
delete from menu where nome = '$menu.nome.eventoMonitoramento';
delete from menu where nome = '$menu.nome.monitoramentoativos';
delete from menu where nome = '$menu.nome.mostraStatusCapturaInventario';
-- FIM - valdoilo.damasceno - 08/05/2015

-- FROM SCRIPTS PROGRAMA 0005 PROJETO 0006 e PROJETO 0097 - GERENCIAMENTO DE EVENTOS