-- SCRIPTS PROGRAMA 0005 PROJETO 168 - GERENCIAMENTO DE EVENTOS

set sql_safe_updates = 0;

-- INCIO - Rodrigo Pecci Acorse (14/07/2015)

ALTER TABLE evm_gerente ADD COLUMN idfluxoup int(11) AFTER host;

ALTER TABLE evm_check ADD COLUMN simbolodaexpressaoinformation varchar(50) not null AFTER idcaracteristicacomplementar;
ALTER TABLE evm_check ADD COLUMN valordaexpressaoinformation varchar(50) not null AFTER simbolodaexpressaoinformation;
ALTER TABLE evm_check ADD COLUMN tipovalorinformation varchar(50) AFTER datahoraultimaalteracao;

ALTER TABLE evm_gerenciado_inventory ADD COLUMN idfluxoacaoinformation int(11) AFTER idcheck;
ALTER TABLE evm_gerenciado_inventory ADD COLUMN simbolodaexpressaoinformation varchar(50) AFTER idfluxoacaoexception;
ALTER TABLE evm_gerenciado_inventory ADD COLUMN valordaexpressaoinformation varchar(50) AFTER simbolodaexpressaoexception;
ALTER TABLE evm_gerenciado_inventory ADD COLUMN eplInformation TEXT AFTER datahoraultimaalteracao;

ALTER TABLE evm_gerenciado_nagios ADD COLUMN idfluxoacaoinformation int(11) AFTER iditemconfiguracaofilho;
ALTER TABLE evm_gerenciado_nagios ADD COLUMN simbolodaexpressaoinformation varchar(50) AFTER idfluxoacaoexception;
ALTER TABLE evm_gerenciado_nagios ADD COLUMN valordaexpressaoinformation varchar(50) AFTER simbolodaexpressaoexception;
ALTER TABLE evm_gerenciado_nagios ADD COLUMN eplInformation TEXT AFTER datahoraultimaalteracao;

ALTER TABLE evm_gerenciado_zabbix ADD COLUMN idfluxoacaoinformation int(11) AFTER iditemconfiguracaofilho;
ALTER TABLE evm_gerenciado_zabbix ADD COLUMN simbolodaexpressaoinformation varchar(50) AFTER idfluxoacaoexception;
ALTER TABLE evm_gerenciado_zabbix ADD COLUMN valordaexpressaoinformation varchar(50) AFTER simbolodaexpressaoexception;
ALTER TABLE evm_gerenciado_zabbix ADD COLUMN eplInformation TEXT AFTER datahoraultimaalteracao;

ALTER TABLE evm_gerente_correlacao ADD COLUMN eplInformation TEXT AFTER nome;
ALTER TABLE evm_gerente_correlacao ADD COLUMN idfluxoacaoinformation int(11) AFTER eplInformation;

RENAME TABLE evm_tipoevento TO evm_categoriaocorrencia;
RENAME TABLE evm_grupotipoevento TO evm_grupocategoriaocorrencia;

ALTER TABLE evm_categoriaocorrencia CHANGE idevmtipoevento idevmcategoriaocorrencia INT(11) NOT NULL;
ALTER TABLE evm_categoriaocorrencia CHANGE idgrupoevmtipoevento idgrupoevmcategoriaocorrencia INT(11);

ALTER TABLE evm_grupocategoriaocorrencia CHANGE idgrupoevmtipoevento idgrupoevmcategoriaocorrencia INT(11) NOT NULL;

ALTER TABLE evm_gerenciado_inventory CHANGE idEvmTipoEvento idevmcategoriaocorrencia INT(11) NOT NULL;
ALTER TABLE evm_gerenciado_nagios CHANGE idEvmTipoEvento idevmcategoriaocorrencia INT(11) NOT NULL;
ALTER TABLE evm_gerenciado_zabbix CHANGE idevmtipoevento idevmcategoriaocorrencia INT(11) NOT NULL;
ALTER TABLE evm_gerente_correlacao CHANGE idevmtipoevento idevmcategoriaocorrencia INT(11) NOT NULL;

delete from menu where nome = '$menu.nome.evm.tipoevento';

-- FIM - Rodrigo Pecci Acorse (14/07/2015)

-- INCIO - Rodrigo Ricardo Dorighello (20/07/2015)

ALTER TABLE imagemitemconfiguracao ADD COLUMN idgerenteevm int(11);

CREATE TABLE catalogonegociomapaimg
(
	idcatalogonegociomapaimg int(11) NOT NULL,
	idcatalogonegocio int(11) DEFAULT NULL,
	idservico bigint(20) DEFAULT NULL,
	posx int(11) DEFAULT NULL,
	posy int(11) DEFAULT NULL,
	descricao varchar(256) DEFAULT NULL,
	caminhoimagem varchar(256) DEFAULT NULL,
	PRIMARY KEY (idcatalogonegociomapaimg),
	KEY (idcatalogonegocio),
	KEY (idservico)
) ENGINE=InnoDB;

CREATE TABLE catalogonegociomapaimgrelacao
(
	idcatnegmapaimgrel int(11) NOT NULL,
	idcatnegmapaimgfilho int(11) NOT NULL,
	idcatnegmapaimgpai int(11) NOT NULL,
	PRIMARY KEY (idcatnegmapaimgrel),
	KEY (idcatnegmapaimgfilho),
	KEY (idcatnegmapaimgpai)
) ENGINE=InnoDB;

alter table catalogonegociomapaimg add constraint fk_cat_neg_mapa_img_catneg foreign key (idcatalogonegocio) references catalogoservico (idcatalogoservico);

alter table catalogonegociomapaimg add constraint fk_cat_neg_mapa_img_servico foreign key (idservico) references servico (idservico);

alter table catalogonegociomapaimgrelacao add constraint fk_cat_neg_mapa_img_rel_fil foreign key (idcatnegmapaimgfilho) references catalogonegociomapaimg (idcatalogonegociomapaimg);

alter table catalogonegociomapaimgrelacao add constraint fk_cat_neg_mapa_img_rel_pai foreign key (idcatnegmapaimgpai) references catalogonegociomapaimg (idcatalogonegociomapaimg);

CREATE TABLE evm_relacao_gercorrelacao_serv
(
	idrelacao int(11) NOT NULL,
	idservico bigint(20) NOT NULL,
	idgerentecorrelacao int(11) NOT NULL,
	PRIMARY KEY (idrelacao),
	KEY (idservico),
	KEY (idgerentecorrelacao)
) ENGINE=InnoDB;

alter table evm_relacao_gercorrelacao_serv add constraint fk_rel_gercor_serv_servico foreign key (idservico) references servico (idservico);

alter table evm_relacao_gercorrelacao_serv add constraint fk_rel_gercor_serv_gerente foreign key (idgerentecorrelacao) references evm_gerente_correlacao (idgerentecorrelacao);

ALTER TABLE evm_gerente ADD COLUMN autocorrecao char(1) DEFAULT NULL AFTER idFluxoDown;

ALTER TABLE evm_gerente ADD COLUMN autocorrecaoquantidade int(11)  DEFAULT NULL AFTER autocorrecao;

create table evm_acao_mudanca
(
	idacaomudanca bigint(20) NOT NULL,
	idacao bigint(20) NOT NULL,
	idcontrato int(11) NOT NULL,
	idsolicitante int(11) NOT NULL,
	idtipomudanca int(11) NOT NULL,
	nomecontato varchar(255) NOT NULL,
	emailcontato varchar(255) NOT NULL,
	idunidade int(11) NOT NULL,
	idlocalidade int(11) DEFAULT NULL,
	titulo varchar(255) NOT NULL,
	descricao text NOT NULL,
	impacto char(1),
	urgencia char(1),
	prioridade int(11) NOT NULL,
	idgrupo int(11) NOT NULL,
	enviaemailcriacao char(1),
	enviaemailfinalizacao char(1),
	enviaemailgrupocomite char(1),
	enviaemailacoes char(1),
	CONSTRAINT pkevm_acao_mudanca PRIMARY KEY (idacaomudanca),
	KEY (idacao),
	KEY (idcontrato),
	KEY (idsolicitante),
	KEY (idtipomudanca),
	KEY (idunidade),
	KEY (idlocalidade),
	KEY (idgrupo)
) ENGINE=InnoDB;

alter table evm_acao_mudanca add constraint FK_evm_acao_mudanca_acao foreign key (idacao) references evm_acao (idacao);

alter table evm_acao_mudanca add constraint FK_evm_acao_mudanca_contra foreign key (idcontrato) references contratos (idcontrato);

alter table evm_acao_mudanca add constraint FK_evm_acao_mudanca_empreg foreign key (idsolicitante) references empregados (idempregado);

alter table evm_acao_mudanca add constraint FK_evm_acao_mudanca_tipomud foreign key (idtipomudanca) references tipomudanca (idtipomudanca);

alter table evm_acao_mudanca add constraint FK_evm_acao_mudanca_unidade foreign key (idunidade) references unidade (idunidade);

alter table evm_acao_mudanca add constraint FK_evm_acao_mudanca_localid foreign key (idlocalidade) references localidade (idlocalidade);

alter table evm_acao_mudanca add constraint FK_evm_acao_mudanca_grupo foreign key (idgrupo) references grupo (idgrupo);

create table evm_acao_instancia_mudanca
(
  idacaoinstanciamudanca bigint(20) NOT NULL,
  idacaoinstancia bigint(20) NOT NULL,
  idrequisicaomudanca int(11) NOT NULL,
  constraint evm_acao_ins_reqmudanca_pkey primary key (idacaoinstanciamudanca) 
);

alter table evm_acao_instancia_mudanca add constraint fk_idacaoinstancia_mud foreign key (idacaoinstancia) references evm_acao_instancia (idacaoinstancia);

alter table evm_acao_instancia_mudanca add constraint fk_idrequisicao_mud foreign key (idrequisicaomudanca) references requisicaomudanca (idrequisicaomudanca);

ALTER TABLE evm_acao_incidenterequisicao ADD COLUMN emailsolicitante varchar(255) NOT NULL AFTER idservico;

ALTER TABLE evm_acao_incidenterequisicao ADD COLUMN idunidade int(11) NOT NULL AFTER emailsolicitante;

alter table evm_acao_incidenterequisicao add constraint FK_evm_acao_increq_unidade foreign key (idunidade) references unidade (idunidade);

ALTER TABLE evm_acao_incidenterequisicao ADD COLUMN idlocalidade int(11) DEFAULT NULL AFTER idunidade;

alter table evm_acao_incidenterequisicao add constraint FK_evm_acao_increq_localid foreign key (idlocalidade) references localidade (idlocalidade);


-- FIM - Rodrigo Ricardo Dorighello (10/08/2015)

-- INCIO - Douglas Tavares de Azevedo Japiassu (22/07/2015)

ALTER TABLE evm_acao_instancia ADD COLUMN idevmconexaoeventmonitor int(11) AFTER datahora;

-- FIM - Douglas Tavares de Azevedo Japiassu (22/07/2015)


-- INCIO - Cristian Guedes (23/07/2015)

/*
 * Desenvolvedor: ibimon.morais - Data: 06/08/2015 - Horrio: 15:27 - ID Citsmart: 175383 - 
 * Motivo/Comentrio: Refatorao na tabela: trocando o idocorrencia por idcategoriaocorrencia
 */
CREATE TABLE evm_baseconhecimento
(
	idevmbaseconhecimento int(11) NOT NULL,
	idbaseconhecimento int(11) NOT NULL,
	idevmcategoriaocorrencia int(11) NOT NULL,
    datainicio date not null,
    datafim date,
	PRIMARY KEY (idevmbaseconhecimento)
) ENGINE=InnoDB;

CREATE TABLE evm_acaomanualsolserv
(
	idevmacaomanualsolserv int(11) NOT NULL,
	idsolicitacaoservico int(11) NOT NULL,
	idocorrencia varchar(25) NOT NULL,
    datainicio date not null,
    datafim date,
	PRIMARY KEY (idevmacaomanualsolserv)
) ENGINE=InnoDB;


CREATE TABLE evm_acaomanualmudanca
(
	idevmacaomanualmudanca int(11) NOT NULL,
	idRequisicaoMudanca int(11) NOT NULL,
	idocorrencia varchar(25) NOT NULL,
    datainicio date not null,
    datafim date,
	PRIMARY KEY (idevmacaomanualmudanca)
) ENGINE=InnoDB;


ALTER TABLE evm_gerente add column idevmcategoriaocorrencia INT(11);
ALTER TABLE evm_gerente ADD COLUMN eplup TEXT;
ALTER TABLE evm_gerente ADD COLUMN epldown TEXT;

-- FIM - Cristian Guedes (23/07/2015)

set sql_safe_updates = 1;

-- FROM SCRIPTS PROGRAMA 0005 PROJETO 168 - GERENCIAMENTO DE EVENTOS