set sql_safe_updates = 0;
-- INICIO - [douglas.japiassu] - 04/09/2015

alter table servico engine=InnoDB;

create table portfolioservico (
	idportfolioservico bigint not null, 
	descportfolioservico varchar(500), 
	datainicio date not null, 
	datafim date,
	primary key (idportfolioservico)
) ENGINE=InnoDB;

alter table servico add idportfolioservico bigint null;
alter table servico add tiposervico varchar(1) null;
alter table servico add faseservico varchar(2) null;
alter table servico add statusservico varchar(5) null;
alter table servico add constraint servico_portfolioservico_fk foreign key (idportfolioservico) references portfolioservico (idportfolioservico);

alter table servicocontrato add idservicocontratorelacionado bigint null;
alter table servicocontrato add constraint servicocontrato_autorel foreign key (idservicocontratorelacionado) references servicocontrato (idservicocontrato);

alter table categoriaservico add tipocategoria varchar(1) not null default 'R';

create table servicoautorelacionamento (
	idservicoautorelacionamento bigint not null, 
	idservico bigint not null,
	idservicorelacionado bigint not null,
	faseservico varchar(2),
	statusservico varchar(5),
	datainicio date not null, 
	datafim date,
	primary key (idservicoautorelacionamento)
) ENGINE=InnoDB;

alter table servicoautorelacionamento add constraint serv_autorel_servico foreign key (idservico) references servico (idservico);
alter table servicoautorelacionamento add constraint serv_autorel_servrelacionado foreign key (idservicorelacionado) references servico (idservico);
-- FIM - [douglas.japiassu] - 23/09/2015

--INCIO - [rodrigo.guilherme] - 22/09/2015

CREATE TABLE mapanegocioitem
(
	idmapanegocioitem int(11) NOT NULL,
	idserviconegocio bigint(20) DEFAULT NULL,
	idservicoapoio bigint(20) DEFAULT NULL,
	iditemconfiguracao int(11) DEFAULT NULL,
	posx int(11) DEFAULT NULL,
	posy int(11) DEFAULT NULL,
	descricao varchar(256) DEFAULT NULL,
	icone varchar(256) DEFAULT NULL,
	PRIMARY KEY (idmapanegocioitem),
	KEY (idserviconegocio),
	KEY (idservicoapoio)
) ENGINE=InnoDB;

CREATE TABLE mapanegociorelacao
(
	idmapanegociorelacao int(11) NOT NULL,
	idmapanegocioitemfilho int(11) NOT NULL,
	idmapanegocioitempai int(11) NOT NULL,
	PRIMARY KEY (idmapanegociorelacao),
	KEY (idmapanegocioitemfilho),
	KEY (idmapanegocioitempai)
) ENGINE=InnoDB;

alter table mapanegocioitem add constraint fk_map_neg_item_serneg foreign key (idserviconegocio) references servico (idservico);

alter table mapanegocioitem add constraint fk_map_neg_item_serapo foreign key (idservicoapoio) references servico (idservico);

alter table mapanegocioitem add constraint fk_map_neg_item_ic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao);

alter table mapanegociorelacao add constraint fk_map_neg_item_rel_fil foreign key (idmapanegocioitemfilho) references mapanegocioitem (idmapanegocioitem);

alter table mapanegociorelacao add constraint fk_map_neg_item_rel_pai foreign key (idmapanegocioitempai) references mapanegocioitem (idmapanegocioitem);

CREATE TABLE tempoatendimentounidade (
	idtempoatendimentounidade bigint(20) NOT NULL,
 	idacordonivelservico bigint(20) NOT NULL,
	idunidade int(11) NOT NULL,
  	PRIMARY KEY (idtempoatendimentounidade),
	CONSTRAINT fk_ta_unidade_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico),
	CONSTRAINT fk_ta_unidade_uni FOREIGN KEY (idunidade) REFERENCES unidade (idunidade)
) ENGINE=InnoDB;

CREATE TABLE tempoatendimentoempregado (
	idtempoatendimentoempregado bigint(20) NOT NULL,
 	idacordonivelservico bigint(20) NOT NULL,
	idempregado int(11) NOT NULL,
 	PRIMARY KEY (idtempoatendimentoempregado),
	CONSTRAINT fk_ta_empregado_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico),
	CONSTRAINT fk_ta_empregado_emp FOREIGN KEY (idempregado) REFERENCES empregados (idempregado)
) ENGINE=InnoDB;

ALTER TABLE acordonivelservico ADD COLUMN idcontrato int(11) NULL, ADD CONSTRAINT fk_acordonivelservico_contratos FOREIGN KEY (idcontrato) REFERENCES contratos (idcontrato);

delete from menu where nome = '$menu.nome.ReqNivelServico';
delete from menu where nome = '$menu.nome.acordoNivelServicoMultinivel';

-- FIM - [rodrigo.guilherme] - 19/11/2015


--INCIO - [joao.morais] - 26/11/2015

delete from visaorelacionada where idvisaorelacionada = '3622' 
	OR idvisaorelacionada = '3623' 
	OR idvisaorelacionada = '3624' 
	OR idvisaorelacionada = '3625'
	OR idvisaorelacionada = '3626'
	OR idvisaorelacionada = '3627'
	OR idvisaorelacionada = '3628'
	OR idvisaorelacionada = '3629';
delete from visao where descricao = '$visao.ListagemContratos';
delete from visao where descricao = '$visao.contratos';
delete from menu where nome = '$menu.nome.cadastroContratos';

-- FIM - [joao.morais] - 26/11/2015

-- INCIO - [murilo.rodrigues] - 01/10/2015

CREATE TABLE aplicacao
(
	idaplicacao int(11) NOT NULL,
	nome varchar(256) DEFAULT NULL,
	datafim date DEFAULT NULL,
	ultimaversaodisponivel VARCHAR(100) DEFAULT NULL,
	idresponsavel INT(11) DEFAULT NULL,
	PRIMARY KEY (idaplicacao)
) ENGINE=InnoDB;

CREATE TABLE aplicacaorequisito
(
	idrequisitoaplicacao int(11) NOT NULL,
	idaplicacao int(11) DEFAULT NULL,
	nomerequisito varchar(256) DEFAULT NULL,
	detalhesrequisito text DEFAULT NULL,
	statusrequisito varchar(256) DEFAULT NULL,
	deleted char(1) DEFAULT 'N',
	PRIMARY KEY (idrequisitoaplicacao)
) ENGINE=InnoDB;

alter table aplicacaorequisito add constraint fk_idaplicacao_requisito foreign key (idaplicacao) references aplicacao (idaplicacao);

CREATE TABLE aplicacaocliente
(
	idaplicacaocliente int(11) NOT NULL,
	idcliente int(11) NOT NULL,
	idaplicacao int(11) NOT NULL,
	PRIMARY KEY (idaplicacaocliente)
) ENGINE=InnoDB;
		
alter table aplicacaocliente add constraint fk_aplicacaocliente_idcliente foreign key (idcliente) references clientes (idcliente);
alter table aplicacaocliente add constraint fk_aplicacaocliente_idaplicacao foreign key (idaplicacao) references aplicacao (idaplicacao);

-- FIM - [murilo.rodrigues] - 01/10/2015

-- INICIO - [ibimon.morais] - 01/10/2015
CREATE TABLE casonegocio
(
	idcasonegocio int(11) NOT NULL,
	idservicocasonegocio   bigint(20) DEFAULT NULL,
	nomecasonegocio varchar(100) DEFAULT NULL,
	descricaosumarioexecutivo text,
	descricaocenarios text,
	descricaoproblemaoportunidade text,
	descricaopropostasolucao text,
	descricaoanalisefinanceira text,
	descricaoanaliserisco text,
	descricaostakeholderentidade text,
	descricaoviabilidadetecnica text,
	descricaoconclusao text,
	datafim DATETIME NULL,
	PRIMARY KEY (idcasonegocio)
)ENGINE=InnoDB;

alter table casonegocio add constraint fk_id_servico_caso_negocio foreign key (idservicocasonegocio) references servico (idservico);
-- FIM - [ibimon.morais] - 01/10/2015

-- INICIO [douglas.japiassu] 20.10.2015

create table requisitosnivelservico (
	idrequisitosnivelservico bigint not null,
	idserviconegocio bigint not null,
	datacriacao date not null,
	idempregado int(11) null,
	datainicioservico date,
	donodoservico text,
	especificacao text,
	contexto text,
	funcionalidadesessenciais text,
	seguranca text,
	disponibilidade text,
	capacidade text,
	continuidadedonegocio text,
	performancedesempenho text,
	interrupcoesplanejadas text,
	gestaodeincidentes text,
	gestaodeproblemas text,
	gestaodemudancas text,
	conformidadeinterna text,
	conformidadeexterna text,
	datafim date,
	primary key (idrequisitosnivelservico)
) ENGINE=InnoDB;

alter table requisitosnivelservico add constraint servico_requisitos_fk foreign key (idserviconegocio) references servico (idservico);
-- INCIO [ibimon.morais] 28.10.2015
alter table requisitosnivelservico add constraint id_empregados_fk foreign key (idempregado) references empregados (idempregado);
-- FIM [ibimon.morais] 28.10.2015

create table esquemadados (
	idesquemadados bigint not null,
	idserviconegocio bigint not null,
	datacriacao date not null,
	detalhes text,
	datafim date,
	primary key (idesquemadados)
) ENGINE=InnoDB;

alter table esquemadados add constraint servico_esquemadados_fk foreign key (idserviconegocio) references servico (idservico);

-- FIM [douglas.japiassu] 20.10.2015

-- INCIO [douglas.japiassu] 26.10.2015

alter table servico add processodeiniciacao varchar(5) null;
alter table servico add tipodeinvestimento varchar(5) null;

-- FIM [douglas.japiassu] 26.10.2015

-- INCIO [ibimon.morais] 26.10.2015
alter table fornecedor add tipofornecedor varchar(1) null;
-- FIM [ibimon.morais] 26.10.2015

-- INCIO [ibimon.morais] 27.10.2015
alter table clientes add tipocliente varchar(1) null;
-- FIM [ibimon.morais] 27.10.2015

-- INCIO [douglas.japiassu] 27.10.2015

alter table servico_hist add faseservico varchar(2) null;
alter table servico_hist add statusservico varchar(5) null;

-- FIM [douglas.japiassu] 27.10.2015

-- INCIO [ibimon.morais] 04.11.2015
alter table solicitacaoservico add justificativavencimentosla text null;
-- FIM [douglas.japiassu] 04.11.2015

--INICIO - thyen.chang - 05.11.2015	
ALTER TABLE historicoic
	ADD COLUMN datafim DATE NULL,
	ADD COLUMN datahoradesinstalacao DATE NULL,
	ADD COLUMN datainicio DATE NULL,
	ADD COLUMN idbaseconhecimento INT NULL,
	ADD COLUMN idgruporesponsavel INT NULL,
	ADD COLUMN informacoesadicionais VARCHAR(4000) NULL,
	ADD COLUMN nome TEXT NULL;
-- FIM - thyen.chang - 05.11.2015
	
-- INICIO ERICK.SATO
CREATE TABLE `problemabaseconhecimentorelacionado` (
  `idproblemabaseconhecimentorelacionado` int(11) NOT NULL,
  `idproblema` int(11) NOT NULL,
  `idBaseConhecimento` int(11) NOT NULL,
  PRIMARY KEY (`idproblemabaseconhecimentorelacionado`),
  KEY `fk_problema_baseconhecimntorelacionado` (`idproblema`),
  KEY `fk_baseconhecimento_problemarelacionado` (`idBaseConhecimento`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- INICIO - CRISTIAN GUEDES - 05/11/2015

create table evm_g_g_nagios
(
	idgerente int(11) not null,
	nome varchar(255) not null,
	idconexao int(11) not null,
	idusuariocriador int(11) not null,
	idusuariomodificador int(11),
	datahorainicio date not null,
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	epl TEXT,
	autocorrecao char(1) DEFAULT NULL,
	primary key (idgerente),
	key (idconexao),
	key (idusuariocriador, idusuariomodificador)
) ENGINE=InnoDB;

create table evm_linha_g_g_nagios
(
     idlinha int(11) not null,
	idgerente int(11) not null,
	host varchar(50) not null,
	service varchar(50) not null,
	idcron int(11) not null,
	idfluxoacaoinformation int(11),
	idFluxoAcaoWarning int(11),
	idFluxoAcaoException int(11),
	idFluxoAcaoDown int(11),
	idFluxoAcaoUp int(11),
	autocorrecao char(1) DEFAULT NULL,
	autocorrecaoquantidade int(11)  DEFAULT NULL,
	idusuariocriador int(11) not null,
	idusuariomodificador int(11),
	datahorainicio date not null,
	datahorafim date null default '0000-00-00',
	datahoraultimaalteracao date null default '0000-00-00',
	idevmcategoriaocorrencia int(11) NOT NULL,
	epl TEXT,
	linhaativa char(1) default 'S',
	primary key (idlinha),
	key (idgerente),
	key (idcron),
	key (idusuariocriador, idusuariomodificador),
	foreign key (idgerente) references evm_g_g_nagios(idgerente) on delete cascade
	
) ENGINE=InnoDB;

-- FIM - CRISTIAN GUEDES - 05/11/2015

-- INICIO - GILBERTO NERY - 06/11/2015

update parametrocorpore set datafim = CURDATE() where idparametrocorpore = 1;
update parametrocorpore set datafim = CURDATE() where idparametrocorpore = 2;
update parametrocorpore set datafim = CURDATE() where idparametrocorpore = 6;
update parametrocorpore set datafim = CURDATE() where idparametrocorpore = 8;

-- FIM - GILBERTO NERY - 06/11/2015

--INCIO - [gustavo.gomes] - 24/11/2015

----24/11/2015
delete from menu where nome = '$menu.nome.catalogoNegocio';

CREATE TABLE aplicacaoservico (
  idaplicacaoservico int(11) not null,
  idservico bigint(20) not null,
  idaplicacao int(11) not null,
  primary key (idaplicacaoservico),
  foreign key (idaplicacao) references aplicacao (idaplicacao),
  foreign key (idservico) references servico (idservico)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

----19/01/2016
CREATE TABLE vinculoservicoproprietarios(
	idvinculoservicoproprietarios bigint(20) not null,
	idservico bigint(20) not null,
	idempregado int(11),
	idgrupo int(11),
	tipo int(11),
	primary key (idvinculoservicoproprietarios)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- FIM - [gustavo.gomes] - 19/01/2016

-- INCIO [douglas.japiassu] 25.11.2015

alter table bi_consulta engine=InnoDB;
update bi_consulta set naoatualizbase = 'N' where naoatualizbase is null or naoatualizbase = '';
alter table bi_consulta modify naoatualizbase char(1) not null;
alter table bi_consulta add tipoexibicao varchar(1) not null default 'N';
alter table bi_consulta add moduloexibicao varchar(50) null;

-- FIM [douglas.japiassu] 25.11.2015

--INCIO - [rodrigo.acorse] - 01/12/2015

delete from menu where nome = '$menu.nome.evm.pesquisaocorrenciaeventos';
delete from menu where nome = '$menu.nome.itemConfiguracao';

-- FIM - [rodrigo.acorse] - 01/12/2015

--INCIO - [rodrigo.acorse] - 22/12/2015

alter table evm_gerente add gerarup char(1) null default 'S';
alter table evm_gerente add gerardown char(1) null default 'S';

alter table evm_gerenciado_inventory add gerarinformation char(1) null default 'S';
alter table evm_gerenciado_inventory add gerarwarning char(1) null default 'S';
alter table evm_gerenciado_inventory add gerarexception char(1) null default 'S';

alter table evm_gerenciado_nagios add gerarinformation char(1) null default 'S';
alter table evm_gerenciado_nagios add gerarwarning char(1) null default 'S';
alter table evm_gerenciado_nagios add gerarexception char(1) null default 'S';

alter table evm_gerenciado_zabbix add gerarinformation char(1) null default 'S';
alter table evm_gerenciado_zabbix add gerarwarning char(1) null default 'S';
alter table evm_gerenciado_zabbix add gerarexception char(1) null default 'S';

alter table evm_linha_g_g_nagios add gerarup char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerardown char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerarinformation char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerarwarning char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerarexception char(1) null default 'S';

-- FIM - [rodrigo.acorse] - 22/12/2015

-- INCIO - [deborah.ferreira] - 13/01/2016

ALTER TABLE processonegocio ENGINE=InnoDB;

CREATE TABLE processonegociounidades (
	idprocessonegociounidades int(11) NOT NULL,
	idprocessonegocio int(11) NOT NULL,
	idunidade int(11) NOT NULL,
	PRIMARY KEY (idprocessonegociounidades),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio),
	FOREIGN KEY (idunidade) REFERENCES unidade (idunidade)
) ENGINE=InnoDB;

CREATE TABLE processonegociotiposfluxo (
	idprocessonegociotiposfluxo int(11) NOT NULL,
	idprocessonegocio int(11) NOT NULL,
	idtipofluxo int(11) NOT NULL,
	PRIMARY KEY (idprocessonegociotiposfluxo),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio),
	FOREIGN KEY (idtipofluxo) REFERENCES bpm_tipofluxo (idtipofluxo)
) ENGINE=InnoDB;

ALTER TABLE processonegocio MODIFY percdispensanovaaprovacao decimal(5,2);
ALTER TABLE processonegocio MODIFY permiteaprovacaonivelinferior char(1);
ALTER TABLE processonegocio MODIFY permissaosolicitacao char(1);

ALTER TABLE processonegocio ADD deleted char(1) DEFAULT 'N';
-- FIM - [deborah.ferreira] - 13/01/2016

-- INCIO - [douglas.japiassu] - 14/01/2016

UPDATE
	servico 
SET
	tiposervico = (SELECT classificacao FROM tipodemandaservico WHERE tipodemandaservico.idtipodemandaservico = servico.idtipodemandaservico) 
WHERE
	tiposervico IS NULL;

-- FIM - [douglas.japiassu] - 14/01/2016

--INCIO - [joao.morais] - 14/01/2016
create table tipofinanceiroservico (
	idtipo bigint not null, 
	perfil varchar(1) not null,
	nometipo varchar(255) not null,
	datafim date,
	primary key (idtipo)
) ENGINE=InnoDB;
	
create table financeiroservico (
	idfinanceiroservico bigint not null, 
	idservico bigint(20) not null,
	idtipo bigint not null,
	valor int(20) not null,
	datafim date,
	primary key (idfinanceiroservico)
) ENGINE=InnoDB;

alter table financeiroservico add CONSTRAINT fk_finan_serv_servico FOREIGN KEY (idservico) REFERENCES servico (idservico);
alter table financeiroservico add CONSTRAINT fk_finan_serv_tipofin FOREIGN KEY (idtipo) REFERENCES tipofinanceiroservico (idtipo);
-- FIM - [joao.morais] - 14/01/2016

--INCIO - [pedro.francisco] - 15/01/2016
create table portfoliobusinessuser (
	idbusinessuser int not null auto_increment,
	idservico bigint not null,
	idgrupo int ,
	idusuario int,
	tipo int not null,
	constraint portfoliobusinessuser_pk primary key (idbusinessuser),
	constraint portfoliobusinessuser_grupo_fk foreign key (idgrupo) references grupo(idgrupo),
	constraint portfoliobusinessuser_servico_fk foreign key (idservico) references servico(idservico),
	constraint portfoliobusinessuser_usuario_fk foreign key (idusuario) references usuario(idusuario)
) ENGINE=InnoDB;
--FIM - [pedro.francisco] - 15/01/2016

--INCIO - [joao.morais] - 18/01/2016
alter table contratos add horasuporte int;
alter table contratos add escopo varchar(255);
alter table contratos add datarevisaorenovacao date;
-- FIM - [joao.morais] - 18/01/2016

-- INCIO - [deborah.ferreira] - 14/01/2016

CREATE TABLE servicoprocessonegocio (
	idservicoprocessonegocio int(11) NOT NULL,
	idservico bigint NOT NULL,
	idprocessonegocio int(11) NOT NULL,
	PRIMARY KEY (idservicoprocessonegocio),
	FOREIGN KEY (idservico) REFERENCES servico (idservico),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio)
) ENGINE=InnoDB;

-- FIM - [deborah.ferreira] - 14/01/2016 

--INCIO - [gilmar.junior] - 19/01/2016
create table servicodononegocio (
	idservicodononegocio int not null auto_increment,
	idservico bigint not null,
	idgrupo int ,
	idempregado int,
	tipodononegocio int not null,
	constraint servicodononegocio_PK primary key (idservicodononegocio),
	constraint servicodononegocio_servico_FK foreign key (idgrupo) references grupo(idgrupo),
	constraint servicodononegocio_grupo_FK foreign key (idservico) references servico(idservico),
	constraint servicodononegocio_emp_FK foreign key (idempregado) references empregados(idempregado)
) ENGINE=InnoDB;

-- FIM - [gilmar.junior] - 19/01/2016

-- INICIO - [gilberto.nery] - 20/01/2016

CREATE TABLE evm_acao_problema (
  idacaoproblema INT(11) NOT NULL,
  idacao bigint(20) NOT NULL,
  idcontrato INT(11) NULL,
  idsolicitante INT(11) NULL,
  idorigem BIGINT(20) NULL,
  idgrupo INT(11) NULL,
  nomecontato VARCHAR(100) NULL,
  emailcontato VARCHAR(200) NULL,
  telefonecontato VARCHAR(100) NULL,
  ramalcontato VARCHAR(5) NULL,
  observacao TEXT NULL,
  idunidade INT(11) NULL,
  idlocalidade INT(11) NULL,
  tituloproblema VARCHAR(255) NULL,
  descricaoproblema TEXT NULL,
  severidadeproblema VARCHAR(15) NULL,
  impactoproblema VARCHAR(10) NULL,
  urgenciaproblema VARCHAR(10) NULL,
  datahoralimitesolucionar DATE NULL,
  prioridade INT(1) NULL,
  proativoreativo VARCHAR(15) NULL,
  enviaemailcriacao CHAR(1) NULL,
  enviaemailfinalizacao CHAR(1) NULL,
  enviaemailacoes CHAR(1) NULL,
  idcategoriaproblema INT(11) NULL,
  idcausa INT(11) NULL,
  idcategoriasolucao INT(11) NULL,
  fechamento LONGTEXT NULL,
  PRIMARY KEY (idacaoproblema),
  INDEX FK_ACAO_idx (idacao ASC),
  INDEX FK_CONTRATO_idx (idcontrato ASC),
  INDEX FK_SOLICITANTE_idx (idsolicitante ASC),
  INDEX FK_ORIGEM_idx (idorigem ASC),
  INDEX FK_GRUPO_idx (idgrupo ASC),
  INDEX FK_UNIDADE_idx (idunidade ASC),
  INDEX FK_LOCALIDADE_idx (idlocalidade ASC),
  INDEX FK_CATEGORIA_PROBLEMA_idx (idcategoriaproblema ASC),
  INDEX FK_CATEG_SOLUCAO_idx (idcategoriasolucao ASC),
  INDEX FK_CAUSA_idx (idcausa ASC),
  CONSTRAINT FK_evm_acao_problema_acao FOREIGN KEY (idacao) REFERENCES evm_acao (idacao),
  CONSTRAINT FK_CONTRATO    FOREIGN KEY (idcontrato)    REFERENCES contratos (idcontrato)    ON DELETE NO ACTION    ON UPDATE NO ACTION,
  CONSTRAINT FK_SOLICITANTE    FOREIGN KEY (idsolicitante)    REFERENCES empregados (idempregado)    ON DELETE NO ACTION    ON UPDATE NO ACTION,
  CONSTRAINT FK_ORIGEM    FOREIGN KEY (idorigem)    REFERENCES origematendimento (idorigem)    ON DELETE NO ACTION    ON UPDATE NO ACTION,
  CONSTRAINT FK_GRUPO    FOREIGN KEY (idgrupo)    REFERENCES grupo (idgrupo)    ON DELETE NO ACTION    ON UPDATE NO ACTION,
  CONSTRAINT FK_UNIDADE    FOREIGN KEY (idunidade)    REFERENCES unidade (idunidade)    ON DELETE NO ACTION    ON UPDATE NO ACTION,
  CONSTRAINT FK_LOCALIDADE    FOREIGN KEY (idlocalidade)    REFERENCES localidade (idlocalidade)    ON DELETE NO ACTION    ON UPDATE NO ACTION,
  CONSTRAINT FK_CATEGORIA_PROBLEMA    FOREIGN KEY (idcategoriaproblema)    REFERENCES categoriaproblema (idcategoriaproblema)    ON DELETE NO ACTION    ON UPDATE NO ACTION,
  CONSTRAINT FK_CATEG_SOLUCAO    FOREIGN KEY (idcategoriasolucao)    REFERENCES categoriasolucao (idcategoriasolucao)    ON DELETE NO ACTION    ON UPDATE NO ACTION,
  CONSTRAINT FK_CAUSA    FOREIGN KEY (idcausa)    REFERENCES causaincidente (idcausaincidente)    ON DELETE NO ACTION    ON UPDATE NO ACTION
)
ENGINE = InnoDB;

CREATE TABLE evm_acao_instancia_problema (
  idacaoinstanciaproblema bigint(20) NOT NULL,
  idacaoinstancia bigint(20) NOT NULL,
  idrequisicaoproblema INT(11) NULL,
  PRIMARY KEY (idacaoinstanciaproblema),
  CONSTRAINT FK_evm_inst_instancia FOREIGN KEY (idacaoinstancia) REFERENCES evm_acao_instancia (idacaoinstancia),
  CONSTRAINT FK_evm_inst_problema    FOREIGN KEY (idrequisicaoproblema)    REFERENCES problema (idproblema)    ON DELETE NO ACTION    ON UPDATE NO ACTION
)
ENGINE = InnoDB;

CREATE TABLE evm_acaomanualproblema (
  idevmacaomanualproblema bigint(20) NOT NULL,
  idocorrencia VARCHAR(254) not null,
  idrequisicaoproblema INT(11) NOT NULL,
  datainicio date not null,
  datafim date,
  PRIMARY KEY (idevmacaomanualproblema),
  CONSTRAINT FK_evm_man_prob FOREIGN KEY (idrequisicaoproblema) REFERENCES problema(idproblema) ON DELETE NO ACTION    ON UPDATE NO ACTION
)
ENGINE = InnoDB;

-- FIM - [gilberto.nery] (20/01/2016)

-- INICIO - thyen.chang - 26/01/2016

ALTER TABLE evm_gerenciado_zabbix CHANGE nometrigger nometrigger varchar(255);

-- FIM - thyen.chang - 26/01/2016

-- INICIO - rodrigo.acorse - 27/01/2016

ALTER TABLE evm_gerenciado_nagios CHANGE servico servico varchar(255);

-- FIM - rodrigo.acorse - 27/01/2016

-- INCIO [douglas.japiassu] Scripts CARLOS - MOBILE - 11.02.2016
alter table ocorrenciasolicitacao add codigoexterno varchar(100);
alter table rest_execution add platform varchar(255);
alter table rest_execution add uuid varchar(255);
ALTER TABLE ocorrenciasolicitacao CHANGE COLUMN descricao VARCHAR(2000);
alter table tabfederacaodados drop primary key;
ALTER TABLE tabfederacaodados ADD PRIMARY KEY (nometabela, chavefinal, chaveoriginal, origem);
-- FIM [douglas.japiasssu] Scripts CARLOS - MOBILE - 11.02.2016

-- INICIO - thyen.chang - 06.03.2016

ALTER TABLE empregados MODIFY COLUMN cpf VARCHAR(16);

-- FIM - thyen.chang - 06.03.2016

-- INICIO - thyen.chang - 06.03.2016

alter table planomelhoria add column datainicio date;

alter table planomelhoria drop column datainicioplano;

alter table acaoplanomelhoria add column datainicio date;

alter table acaoplanomelhoria add column datafim date;

-- FIM - thyen.chang - 06.03.2016

set sql_safe_updates = 1;