-- INICIO - [douglas.japiassu] - 03/09/2015

create table portfolioservico (
	idportfolioservico number not null, 
	descportfolioservico varchar2(500), 
	datainicio date not null, 
	datafim date,
	constraint portfolioservico_pk primary key (idportfolioservico) enable
);

alter table servico add idportfolioservico number(10,0) null;
alter table servico add tiposervico char(1) null;
alter table servico add faseservico varchar(2) null;
alter table servico add statusservico varchar(5) null;
alter table servico add constraint servico_portfolioservico_fk foreign key (idportfolioservico) references portfolioservico (idportfolioservico) enable;

alter table servicocontrato add idservicocontratorelacionado number null;
alter table servicocontrato add constraint servicocontrato_autorel foreign key (idservicocontratorelacionado) references servicocontrato (idservicocontrato) enable;

alter table categoriaservico add tipocategoria varchar(1) default 'R' not null ;

create table servicoautorelacionamento (
	idservicoautorelacionamento number(24,0) not null, 
	idservico number(24,0) not null,
	idservicorelacionado number not null,
	faseservico varchar(2),
	statusservico varchar(5),
	datainicio date not null, 
	datafim date,
	primary key (idservicoautorelacionamento)
);

alter table servicoautorelacionamento add constraint serv_autorel_servico foreign key (idservico) references servico (idservico) enable;
alter table servicoautorelacionamento add constraint serv_autorel_servrelacionado foreign key (idservicorelacionado) references servico (idservico) enable;
-- FIM - [douglas.japiassu] - 23/09/2015
--INCIO - [rodrigo.guilherme] - 22/09/2015

CREATE TABLE mapanegocioitem
(
	idmapanegocioitem NUMBER(10,0) NOT NULL,
	idserviconegocio NUMBER(24,0) DEFAULT NULL,
	idservicoapoio NUMBER(24,0) DEFAULT NULL,
	iditemconfiguracao NUMBER(10,0) DEFAULT NULL,
	posx NUMBER(10,0) DEFAULT NULL,
	posy NUMBER(10,0) DEFAULT NULL,
	descricao VARCHAR2(255 CHAR) DEFAULT NULL,
	icone VARCHAR2(255 CHAR) DEFAULT NULL,
	CONSTRAINT mapanegitem_pkey PRIMARY KEY (idmapanegocioitem)
);

CREATE TABLE mapanegociorelacao
(
	idmapanegociorelacao NUMBER(10,0) NOT NULL,
	idmapanegocioitemfilho NUMBER(10,0) NOT NULL,
	idmapanegocioitempai NUMBER(10,0) NOT NULL,
	CONSTRAINT mapanegrel_pkey PRIMARY KEY (idmapanegociorelacao)
);

alter table mapanegocioitem add constraint fk_map_neg_item_serneg foreign key (idserviconegocio) references servico (idservico);

alter table mapanegocioitem add constraint fk_map_neg_item_serapo foreign key (idservicoapoio) references servico (idservico);

alter table mapanegocioitem add constraint fk_map_neg_item_ic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao);

alter table mapanegociorelacao add constraint fk_map_neg_item_rel_fil foreign key (idmapanegocioitemfilho) references mapanegocioitem (idmapanegocioitem);

alter table mapanegociorelacao add constraint fk_map_neg_item_rel_pai foreign key (idmapanegocioitempai) references mapanegocioitem (idmapanegocioitem);

CREATE TABLE tempoatendimentounidade
(
	idtempoatendimentounidade NUMBER(24,0) NOT NULL,
	idacordonivelservico NUMBER(24,0) NOT NULL,
	idunidade NUMBER(10,0) NOT NULL,
	PRIMARY KEY (idtempoatendimentounidade)
);

ALTER TABLE tempoatendimentounidade ADD CONSTRAINT fk_ta_unidade_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico);
ALTER TABLE tempoatendimentounidade ADD CONSTRAINT fk_ta_unidade_uni FOREIGN KEY (idunidade) REFERENCES unidade (idunidade);

CREATE TABLE tempoatendimentoempregado
(
	idtempoatendimentoempregado NUMBER(24,0) NOT NULL,
 	idacordonivelservico NUMBER(24,0) NOT NULL,
	idempregado NUMBER(10,0) NOT NULL,
 	PRIMARY KEY (idtempoatendimentoempregado)
);

ALTER TABLE tempoatendimentoempregado ADD CONSTRAINT fk_ta_empregado_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico);
ALTER TABLE tempoatendimentoempregado ADD CONSTRAINT fk_ta_empregado_emp FOREIGN KEY (idempregado) REFERENCES empregados (idempregado);

ALTER TABLE acordonivelservico ADD  idcontrato NUMBER(10,0) NULL;
ALTER TABLE acordonivelservico ADD CONSTRAINT fk_ans_contrato FOREIGN KEY (idcontrato) REFERENCES contratos (idcontrato);

delete from menu where nome = '$menu.nome.ReqNivelServico';
delete from menu where nome = '$menu.nome.acordoNivelServicoMultinivel';

-- FIM - [rodrigo.guilherme] - 22/09/2015

--INCIO - [joao.morais] - 26/11/2015

delete from visaorelacionada where idvisaorelacionada = '3622' 
	OR idvisaorelacionada = '3623' 
	OR idvisaorelacionada = '3624' 
	OR idvisaorelacionada = '3625'
	OR idvisaorelacionada = '3626'
	OR idvisaorelacionada = '3627'
	OR idvisaorelacionada = '3628'
	OR idvisaorelacionada = '3629';
delete from visao where descricao = '$visao.ListagemContratos';
delete from visao where descricao = '$visao.contratos';
delete from menu where nome = '$menu.nome.cadastroContratos';

-- FIM - [joao.morais] - 26/11/2015

-- INCIO - [murilo.rodrigues] - 01/10/2015

CREATE TABLE aplicacao
(
	idaplicacao NUMBER(10,0) NOT NULL,
	nome VARCHAR2(255 CHAR) DEFAULT NULL,
	datafim date DEFAULT NULL,
	ultimaversaodisponivel VARCHAR2(100) DEFAULT NULL,
	idresponsavel NUMBER(10,0) DEFAULT NULL,
	CONSTRAINT aplicacao_pkey PRIMARY KEY (idaplicacao)
);

CREATE TABLE aplicacaorequisito
(
	idrequisitoaplicacao NUMBER(10,0) NOT NULL,
	idaplicacao NUMBER(10,0) DEFAULT NULL,
	nomerequisito VARCHAR2(255 CHAR) DEFAULT NULL,
	detalhesrequisito clob DEFAULT NULL,
	statusrequisito VARCHAR2(255 CHAR) DEFAULT NULL,
	deleted CHAR(1) DEFAULT 'N',
	CONSTRAINT aplicacaorequisito_pkey PRIMARY KEY (idrequisitoaplicacao)
);

alter table aplicacaorequisito add constraint fk_idaplicacao_requisito foreign key (idaplicacao) references aplicacao (idaplicacao);

CREATE TABLE aplicacaocliente
(
	idaplicacaocliente NUMBER(10,0) NOT NULL,
	idcliente NUMBER(10,0) NOT NULL,
	idaplicacao NUMBER(10,0) NOT NULL,
	CONSTRAINT aplicacaocliente_pkey PRIMARY KEY (idaplicacaocliente)
);
		
alter table aplicacaocliente add constraint fk_aplicacaocliente_idcliente foreign key (idcliente) references clientes (idcliente);
alter table aplicacaocliente add constraint fk_aplicacaocliente_idaplic foreign key (idaplicacao) references aplicacao (idaplicacao);

-- FIM - [murilo.rodrigues] - 01/10/2015

CREATE TABLE casonegocio
(
	idcasonegocio NUMBER(10,0) NOT NULL,
	idservicocasonegocio NUMBER(24,0) NOT NULL,
	nomecasonegocio VARCHAR2(100) DEFAULT NULL,
	descricaosumarioexecutivo clob,
	descricaocenarios clob,
	descricaoproblemaoportunidade clob,
	descricaopropostasolucao clob,
	descricaoanalisefinanceira clob,
	descricaoanaliserisco clob,
	descricaostakeholderentidade clob,
	descricaoviabilidadetecnica clob,
	descricaoconclusao clob,
	datafim DATE DEFAULT NULL,
	CONSTRAINT casonegocio_pkey PRIMARY KEY (idcasonegocio)
);

alter table casonegocio add constraint fk_id_servico_caso_negocio foreign key (idservicocasonegocio) references servico (idservico);
-- FIM - [ibimon.morais] - 01/10/2015

-- INCIO [douglas.japiassu] 20.10.2015

create table requisitosnivelservico (
	idrequisitosnivelservico number not null,
	idserviconegocio number not null,
	idempregado number null,
	datacriacao date not null,
	datainicioservico date,
	donodoservico clob,
	especificacao clob,
	contexto clob,
	funcionalidadesessenciais clob,
	seguranca clob,
	disponibilidade clob,
	capacidade clob,
	continuidadedonegocio clob,
	performancedesempenho clob,
	interrupcoesplanejadas clob,
	gestaodeincidentes clob,
	gestaodeproblemas clob,
	gestaodemudancas clob,
	conformidadeinterna clob,
	conformidadeexterna clob,
	datafim date,
	primary key (idrequisitosnivelservico)
);

alter table requisitosnivelservico add constraint servico_requisitos_fk foreign key (idserviconegocio) references servico (idservico);
-- INCIO [ibimon.morais] 28.10.2015
alter table requisitosnivelservico add constraint id_empregados_fk foreign key (idempregado) references empregados (idempregado);
-- FIM [ibimon.morais] 28.10.2015

create table esquemadados (
	idesquemadados number not null,
	idserviconegocio number not null,
	datacriacao date not null,
	detalhes clob,
	datafim date,
	primary key (idesquemadados)
);

alter table esquemadados add constraint servico_esquemadados_fk foreign key (idserviconegocio) references servico (idservico);

-- FIM [douglas.japiassu] 20.10.2015

-- INCIO [douglas.japiassu] 26.10.2015

alter table servico add processodeiniciacao varchar(5) null;
alter table servico add tipodeinvestimento varchar(5) null;

-- FIM [douglas.japiassu] 26.10.2015

-- INCIO [ibimon.morais] 26.10.2015
alter table fornecedor add tipofornecedor varchar(1) null;
-- FIM [ibimon.morais] 26.10.2015

-- INCIO [ibimon.morais] 27.10.2015
alter table clientes add tipocliente varchar(1) null;
-- FIM [ibimon.morais] 27.10.2015

-- INCIO [douglas.japiassu] 27.10.2015

alter table servico_hist add faseservico varchar(2) null;
alter table servico_hist add statusservico varchar(5) null;

-- FIM [douglas.japiassu] 27.10.2015

-- INCIO [ibimon.morais] 04.11.2015
alter table solicitacaoservico add justificativavencimentosla clob null;
-- FIM [douglas.japiassu] 04.11.2015

--INICIO - thyen.chang - 05.11.2015
ALTER TABLE historicoic ADD datafim DATE NULL;
ALTER TABLE historicoic ADD datahoradesinstalacao DATE NULL;
ALTER TABLE historicoic ADD datainicio DATE NULL;
ALTER TABLE historicoic ADD idbaseconhecimento INT NULL;
ALTER TABLE historicoic ADD idgruporesponsavel INT NULL;
ALTER TABLE historicoic ADD informacoesadicionais VARCHAR(4000) NULL;
ALTER TABLE historicoic ADD nome clob NULL;
-- FIM - thyen.chang - 05.11.2015

-- INICIO ERICK.SATO
create table probbaseconhecrel (
	idprobbaseconhecrel number(24, 0) not null,
	idproblema number(24, 0) not null,
	idBaseConhecimento number(10, 0) not null
);

-- INICIO - CRISTIAN GUEDES - 05/11/2015
 
-- FIM - CRISTIAN GUEDES - 05/11/2015

create table evm_g_g_nagios
(
	idgerente NUMBER(10,0) not null,
	nome varchar(255) not null,
	idconexao NUMBER(10,0) not null,
	idusuariocriador NUMBER(10,0) not null,
	idusuariomodificador NUMBER(10,0),
	datahorainicio date not null,
	datahorafim date default null,
	datahoraultimaalteracao date default null,
	epl clob,
	autocorrecao char(1 CHAR) DEFAULT NULL,
	primary key (idgerente)
);

create table evm_linha_g_g_nagios
(
    idlinha NUMBER(10,0) not null,
	idgerente NUMBER(10,0) not null,
	host varchar(50) not null,
	service varchar(50) not null,
	idcron NUMBER(10,0) not null,
	idfluxoacaoinformation NUMBER(10,0),
	idFluxoAcaoWarning NUMBER(10,0),
	idFluxoAcaoException NUMBER(10,0),
	idFluxoAcaoDown NUMBER(10,0),
	idFluxoAcaoUp NUMBER(10,0),
	autocorrecao char(1 char) DEFAULT NULL,
	autocorrecaoquantidade NUMBER(11,0)  DEFAULT NULL,
	idusuariocriador NUMBER(10,0) not null,
	idusuariomodificador NUMBER(10,0),
	datahorainicio date not null,
	datahorafim date default null,
	datahoraultimaalteracao date default null,
	idevmcategoriaocorrencia NUMBER(10,0) NOT NULL,
	epl varchar(4000),
	linhaativa char(1 char) default 'S',
	primary key (idlinha),
	foreign key (idgerente) references evm_g_g_nagios(idgerente) on delete cascade
);

-- INICIO - GILBERTO NERY - 06/11/2015

update parametrocorpore set datafim = current_date where idparametrocorpore in (1,2,6,8);

-- FIM - GILBERTO NERY - 06/11/2015

--INCIO - [gustavo.gomes] - 24/11/2015

----24/11/2015
delete from menu where nome = '$menu.nome.catalogoNegocio';

CREATE TABLE aplicacaoservico (
  idaplicacaoservico NUMBER(10,0) not null,
  idservico NUMBER(10,0) not null,
  idaplicacao NUMBER(10,0) not null,
  primary key (idaplicacaoservico),
  foreign key (idaplicacao) references aplicacao (idaplicacao),
  foreign key (idservico) references servico (idservico)
);

----19/01/2016
CREATE TABLE VINCULOSERVICOPROPRIETARIOS (
  IDVINCULOSERVICOPROPRIETARIOS NUMBER(22,0) NOT NULL,
  IDSERVICO NUMBER(22,0) NOT NULL,
  IDEMPREGADO NUMBER(22,0),
  IDGRUPO NUMBER(22,0),
  TIPO NUMBER(22,0),
  PRIMARY KEY (IDVINCULOSERVICOPROPRIETARIOS)
);

-- FIM - [gustavo.gomes] - 19/01/2016

-- INCIO [douglas.japiassu] 25.11.2015

update bi_consulta set naoatualizbase = 'N' where naoatualizbase is null or naoatualizbase = '';
alter table bi_consulta modify naoatualizbase char(1) not null;
alter table bi_consulta add tipoexibicao varchar(1) default 'N' not null;
alter table bi_consulta add moduloexibicao varchar(50) null;

-- FIM [douglas.japiassu] 25.11.2015

--INCIO - [rodrigo.acorse] - 01/12/2015

delete from menu where nome = '$menu.nome.evm.pesquisaocorrenciaeventos';
delete from menu where nome = '$menu.nome.itemConfiguracao';

-- FIM - [rodrigo.acorse] - 01/12/2015

--INCIO - [rodrigo.acorse] - 22/12/2015

alter table evm_gerente add gerarup char(1) default 'S';
alter table evm_gerente add gerardown char(1) default 'S';

alter table evm_gerenciado_inventory add gerarinformation char(1) default 'S';
alter table evm_gerenciado_inventory add gerarwarning char(1) default 'S';
alter table evm_gerenciado_inventory add gerarexception char(1) default 'S';

alter table evm_gerenciado_nagios add gerarinformation char(1) default 'S';
alter table evm_gerenciado_nagios add gerarwarning char(1) default 'S';
alter table evm_gerenciado_nagios add gerarexception char(1) default 'S';

alter table evm_gerenciado_zabbix add gerarinformation char(1) default 'S';
alter table evm_gerenciado_zabbix add gerarwarning char(1) default 'S';
alter table evm_gerenciado_zabbix add gerarexception char(1) default 'S';

alter table evm_linha_g_g_nagios add gerarup char(1) default 'S';
alter table evm_linha_g_g_nagios add gerardown char(1) default 'S';
alter table evm_linha_g_g_nagios add gerarinformation char(1) default 'S';
alter table evm_linha_g_g_nagios add gerarwarning char(1) default 'S';
alter table evm_linha_g_g_nagios add gerarexception char(1) default 'S';

-- FIM - [rodrigo.acorse] - 22/12/2015

-- INCIO - [deborah.ferreira] - 13/01/2016

RENAME "processonegocio" TO processonegocio;
   
ALTER TABLE processonegocio RENAME COLUMN "idprocessonegocio" TO idprocessonegocio;
ALTER TABLE processonegocio RENAME COLUMN "idgrupoexecutor" TO idgrupoexecutor;
ALTER TABLE processonegocio RENAME COLUMN "idgrupoadministrador" TO idgrupoadministrador;
ALTER TABLE processonegocio RENAME COLUMN "nomeprocessonegocio" TO nomeprocessonegocio;
ALTER TABLE processonegocio RENAME COLUMN "permissaosolicitacao" TO permissaosolicitacao;
ALTER TABLE processonegocio RENAME COLUMN "percdispensanovaaprovacao" TO percdispensanovaaprovacao;
ALTER TABLE processonegocio RENAME COLUMN "permiteaprovacaonivelinferior" TO permiteaprovacaonivelinferior;

CREATE TABLE processonegociounidades
(
	idprocessonegociounidades NUMBER(10,0) NOT NULL,
	idprocessonegocio NUMBER(10,0) NOT NULL,
	idunidade NUMBER(10,0) NOT NULL,
	PRIMARY KEY (idprocessonegociounidades),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio),
	FOREIGN KEY (idunidade) REFERENCES unidade (idunidade)
);

CREATE TABLE processonegociotiposfluxo
(
	idprocessonegociotiposfluxo NUMBER(10,0) NOT NULL,
	idprocessonegocio NUMBER(10,0) NOT NULL,
	idtipofluxo NUMBER(10,0) NOT NULL,
	PRIMARY KEY (idprocessonegociotiposfluxo),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio),
	FOREIGN KEY (idtipofluxo) REFERENCES bpm_tipofluxo (idtipofluxo)
);

ALTER TABLE processonegocio MODIFY percdispensanovaaprovacao NUMBER(5,2) NULL;
ALTER TABLE processonegocio MODIFY permiteaprovacaonivelinferior CHAR(1) NULL;
ALTER TABLE processonegocio MODIFY permissaosolicitacao CHAR(1) NULL;

ALTER TABLE processonegocio ADD deleted CHAR(1) DEFAULT 'N';
-- FIM - [deborah.ferreira] - 13/01/2016 

-- INCIO - [douglas.japiassu] - 14/01/2016

UPDATE
	servico
SET
	tiposervico = (SELECT classificacao FROM tipodemandaservico WHERE tipodemandaservico.idtipodemandaservico = servico.idtipodemandaservico)
WHERE
	tiposervico IS NULL;

-- FIM - [douglas.japiassu] - 14/01/2016

--INCIO - [joao.morais] - 14/01/2016
create table financeiroservico (
	idfinanceiroservico number(38) not null, 
	idservico number(20) not null,
	idtipo number(38) not null,
	valor number(20, 2) not null,
	datafim date,
	primary key (idfinanceiroservico)
);

create table tipofinanceiroservico (
	idtipo number not null, 
	perfil varchar(1) not null,
	nometipo varchar(255) not null,
	datafim date,
	primary key (idtipo)
);

alter table financeiroservico add CONSTRAINT fk_finan_serv_tipofin FOREIGN KEY (idtipo) REFERENCES tipofinanceiroservico (idtipo);
alter table financeiroservico add CONSTRAINT fk_finan_serv_servico FOREIGN KEY (idservico) REFERENCES servico (idservico);
-- FIM - [joao.morais] - 14/01/2016

--INCIO - [pedro.francisco] - 18/01/2016
CREATE TABLE PORTFOLIOBUSINESSUSER (
	IDBUSINESSUSER NUMBER NOT NULL,
	IDSERVICO NUMBER NOT NULL,
	IDGRUPO NUMBER,
	IDUSUARIO NUMBER,
	TIPO NUMBER NOT NULL,
	CONSTRAINT PBUSINESSUSER_PK PRIMARY KEY (IDBUSINESSUSER),
	CONSTRAINT PBUSINESSUSER_GRUPO_FK FOREIGN KEY (IDGRUPO) REFERENCES GRUPO(IDGRUPO),
	CONSTRAINT PBUSINESSUSER_USUARIO_FK FOREIGN KEY (IDUSUARIO) REFERENCES USUARIO(IDUSUARIO),
	CONSTRAINT PBUSINESSUSER_SERVICO_FK FOREIGN KEY (IDSERVICO) REFERENCES SERVICO(IDSERVICO)
);
--FIM - [pedro.francisco] - 18/01/2016

-- FIM - [joao.morais] - 14/01/2016

--INCIO - [joao.morais] - 18/01/2016
alter table contratos add horasuporte int;
alter table contratos add escopo varchar(255);
alter table contratos add datarevisaorenovacao date;
-- FIM - [joao.morais] - 18/01/2016

-- INCIO - [deborah.ferreira] - 14/01/2016

CREATE TABLE servicoprocessonegocio
(
	idservicoprocessonegocio NUMBER(10,0) NOT NULL,
	idservico NUMBER(24,0) NOT NULL,
	idprocessonegocio NUMBER(10,0) NOT NULL,
	PRIMARY KEY (idservicoprocessonegocio),
	FOREIGN KEY (idservico) REFERENCES servico (idservico),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio)
);

-- FIM - [deborah.ferreira] - 14/01/2016

--INCIO - [gilmar.junior] - 19/01/2016
CREATE TABLE servicodononegocio (
	idservicodononegocio number not null,
	idservico number not null,
	idgrupo number,
	idempregado number,
	tipodononegocio number not null,
	primary key(idservicodononegocio)
);
alter table servicodononegocio add CONSTRAINT fk_servico_dononegocio_grupo FOREIGN KEY (idgrupo) REFERENCES grupo (idgrupo);
alter table servicodononegocio add CONSTRAINT fk_servico_dononegocio_servico FOREIGN KEY (idservico) REFERENCES servico (idservico);
alter table servicodononegocio add CONSTRAINT fk_servico_dononegocio_empr FOREIGN KEY (idempregado) REFERENCES empregados (idempregado);
--FIM - [gilmar.junior] - 19/01/2016

-- INICIO - [gilberto.nery] - 20/01/2016

CREATE TABLE evm_acao_problema
(
	  idacaoproblema NUMBER(24,0) NOT NULL ENABLE,
	  idacao NUMBER(24,0) NOT NULL,
	  idcontrato NUMBER(10,0) NULL,
	  idsolicitante NUMBER(10,0) NULL,
	  idorigem NUMBER(24,0) NULL,
	  idgrupo NUMBER(10,0) NULL,
	  nomecontato VARCHAR(100) NULL,
	  emailcontato VARCHAR(200) NULL,
	  telefonecontato VARCHAR(100) NULL,
	  ramalcontato VARCHAR(5) NULL,
	  observacao CLOB NULL,
	  idunidade NUMBER(10,0) NULL,
	  idlocalidade NUMBER(10,0) NULL,
	  tituloproblema VARCHAR(255) NULL,
	  descricaoproblema CLOB NULL,
	  severidadeproblema CHAR(1 CHAR) NULL,
	  impactoproblema CHAR(1 CHAR) NULL,
	  urgenciaproblema CHAR(1 CHAR) NULL,
	  datahoralimitesolucionar DATE NULL,
	  prioridade NUMBER(10,0) NULL,
	  proativoreativo VARCHAR(15) NULL,
	  enviaemailcriacao CHAR(1 CHAR) NULL,
	  enviaemailfinalizacao CHAR(1 CHAR) NULL,
	  enviaemailacoes CHAR(1 CHAR) NULL,
	  idcategoriaproblema NUMBER(10,0) NULL,
	  idcausa NUMBER(10,0) NULL,
	  idcategoriasolucao NUMBER(10,0) NULL,
	  fechamento CLOB NULL,
  CONSTRAINT pkevm_acao_problema PRIMARY KEY (idacaoproblema),
  CONSTRAINT FK_evmprob_acao FOREIGN KEY (idacao) REFERENCES evm_acao(idacao),
  CONSTRAINT FK_evmprob_contratos FOREIGN KEY (idcontrato) REFERENCES contratos(idcontrato),
  CONSTRAINT FK_evmprob_origem FOREIGN KEY (idorigem) REFERENCES origematendimento(idorigem),
  CONSTRAINT FK_evmprob_empregados FOREIGN KEY (idsolicitante) REFERENCES empregados(idempregado),
  CONSTRAINT FK_evmprob_grupo FOREIGN KEY (idgrupo) REFERENCES grupo(idgrupo),
  CONSTRAINT FK_evmprob_UNIDADE FOREIGN KEY (idunidade)    REFERENCES unidade (idunidade),
  CONSTRAINT FK_evmprob_LOCALIDADE FOREIGN KEY (idlocalidade)    REFERENCES localidade (idlocalidade),
  CONSTRAINT FK_evmprob_CATEGORIA FOREIGN KEY (idcategoriaproblema)    REFERENCES categoriaproblema (idcategoriaproblema),
  CONSTRAINT FK_evmprob_SOLUCAO FOREIGN KEY (idcategoriasolucao)    REFERENCES categoriasolucao (idcategoriasolucao),
  CONSTRAINT FK_evmprob_CAUSA  FOREIGN KEY (idcausa)    REFERENCES causaincidente (idcausaincidente)    
);

CREATE TABLE evm_acao_instancia_problema
(
	  idacaoinstanciaproblema NUMBER(24,0) NOT NULL ENABLE,
	  idacaoinstancia NUMBER(24,0) NOT NULL,
	  idrequisicaoproblema NUMBER(10,0) NULL,
	  CONSTRAINT pk_evm_inst_problema PRIMARY KEY (idacaoinstanciaproblema),
	  CONSTRAINT FK_evm_inst_instancia FOREIGN KEY (idacaoinstancia) REFERENCES evm_acao_instancia(idacaoinstancia),
	  CONSTRAINT FK_evm_inst_problema FOREIGN KEY (idrequisicaoproblema) REFERENCES problema(idproblema)
);

CREATE TABLE evm_acaomanualproblema (
  idevmacaomanualproblema NUMBER(24,0) NOT NULL ENABLE,
  idocorrencia VARCHAR(254) not null,
  idrequisicaoproblema NUMBER(10,0) NOT NULL,
  datainicio date not null,
  datafim date,
  CONSTRAINT pk_evm_man_prob PRIMARY KEY (idevmacaomanualproblema),
  CONSTRAINT FK_evm_man_prob FOREIGN KEY (idrequisicaoproblema) REFERENCES problema(idproblema)
);

-- FIM - [gilberto.nery] - 20/01/2016

-- INICIO - thyen.chang - 26/01/2016

ALTER TABLE evm_gerenciado_zabbix DROP COLUMN servico;

ALTER TABLE evm_gerenciado_zabbix ADD nometrigger varchar(255);

ALTER TABLE evm_gerenciado_zabbix ADD idtrigger integer;

-- FIM - thyen.chang - 26/01/2016

-- INICIO - rodrigo.acorse - 27/01/2016

ALTER TABLE evm_gerenciado_nagios MODIFY servico VARCHAR(255);

-- FIM - rodrigo.acorse - 27/01/2016-- FIM - [joao.morais] - 14/01/2016

-- INCIO [douglas.japiassu] Scripts CARLOS - MOBILE - 11.02.2016
alter table ocorrenciasolicitacao add codigoexterno varchar(100);
alter table rest_execution add platform varchar(255);
alter table rest_execution add uuid varchar(255);
ALTER TABLE ocorrenciasolicitacao modify descricao VARCHAR(2000);
alter table tabfederacaodados drop primary key;
ALTER TABLE tabfederacaodados ADD PRIMARY KEY (nometabela, chavefinal, chaveoriginal, origem);
-- FIM [douglas.japiasssu] Scripts CARLOS - MOBILE - 11.02.2016

-- INICIO - thyen.chang - 06.03.2016

ALTER TABLE empregados MODIFY cpf VARCHAR2(16);

-- FIM - thyen.chang - 06.03.2016

-- INICIO - thyen.chang - 06.03.2016

alter table planomelhoria add datainicio date;

alter table planomelhoria drop column datainicioplano;

alter table acaoplanomelhoria add datainicio date;

alter table acaoplanomelhoria add datafim date;

-- FIM - thyen.chang - 06.03.2016