-- INICIO - [douglas.japiassu] - 03/09/2015

create table portfolioservico (
	idportfolioservico bigint not null, 
	descportfolioservico varchar(500), 
	datainicio date not null, 
	datafim date,
	primary key (idportfolioservico)
);

alter table servico add idportfolioservico bigint null;
alter table servico add tiposervico varchar(1) null;
alter table servico add faseservico varchar(2) null;
alter table servico add statusservico varchar(5) null;
alter table servico add constraint servico_portfolioservico_fk foreign key (idportfolioservico) references portfolioservico (idportfolioservico);

alter table servicocontrato add idservicocontratorelacionado bigint null;
alter table servicocontrato add constraint servicocontrato_autorel foreign key (idservicocontratorelacionado) references servicocontrato (idservicocontrato);

alter table categoriaservico add tipocategoria varchar(1) not null default 'R';

create table servicoautorelacionamento (
	idservicoautorelacionamento bigint not null, 
	idservico bigint not null,
	idservicorelacionado bigint not null,
	faseservico varchar(2),
	statusservico varchar(5),
	datainicio date not null, 
	datafim date,
	primary key (idservicoautorelacionamento)
);

alter table servicoautorelacionamento add constraint serv_autorel_servico foreign key (idservico) references servico (idservico);
alter table servicoautorelacionamento add constraint serv_autorel_servrelacionado foreign key (idservicorelacionado) references servico (idservico);
-- FIM - [douglas.japiassu] - 23/09/2015

--INCIO - [rodrigo.guilherme] - 22/09/2015

CREATE TABLE mapanegocioitem
(
	idmapanegocioitem int4 NOT NULL,
	idserviconegocio int8 DEFAULT NULL,
	idservicoapoio int8 DEFAULT NULL,
	iditemconfiguracao int4 DEFAULT NULL,
	posx int4 DEFAULT NULL,
	posy int4 DEFAULT NULL,
	descricao varchar(256) DEFAULT NULL,
	icone varchar(256) DEFAULT NULL,
	CONSTRAINT mapanegitem_pkey PRIMARY KEY (idmapanegocioitem)
);

CREATE TABLE mapanegociorelacao
(
	idmapanegociorelacao int4 NOT NULL,
	idmapanegocioitemfilho int4 NOT NULL,
	idmapanegocioitempai int4 NOT NULL,
	CONSTRAINT mapanegrel_pkey PRIMARY KEY (idmapanegociorelacao)
);

alter table mapanegocioitem add constraint fk_map_neg_item_serneg foreign key (idserviconegocio) references servico (idservico);

alter table mapanegocioitem add constraint fk_map_neg_item_serapo foreign key (idservicoapoio) references servico (idservico);

alter table mapanegocioitem add constraint fk_map_neg_item_ic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao);

alter table mapanegociorelacao add constraint fk_map_neg_item_rel_fil foreign key (idmapanegocioitemfilho) references mapanegocioitem (idmapanegocioitem);

alter table mapanegociorelacao add constraint fk_map_neg_item_rel_pai foreign key (idmapanegocioitempai) references mapanegocioitem (idmapanegocioitem);

CREATE TABLE tempoatendimentounidade (
	idtempoatendimentounidade int8 NOT NULL,
	idacordonivelservico int8 NOT NULL,
	idunidade int4 NOT NULL,
	PRIMARY KEY (idtempoatendimentounidade)
);

ALTER TABLE tempoatendimentounidade ADD CONSTRAINT fk_ta_unidade_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico);
ALTER TABLE tempoatendimentounidade ADD CONSTRAINT fk_ta_unidade_uni FOREIGN KEY (idunidade) REFERENCES unidade (idunidade);

CREATE TABLE tempoatendimentoempregado (
	idtempoatendimentoempregado int8 NOT NULL,
 	idacordonivelservico int8 NOT NULL,
	idempregado int4 NOT NULL,
 	PRIMARY KEY (idtempoatendimentoempregado)
);

ALTER TABLE tempoatendimentoempregado ADD CONSTRAINT fk_ta_empregado_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico);
ALTER TABLE tempoatendimentoempregado ADD CONSTRAINT fk_ta_empregado_emp FOREIGN KEY (idempregado) REFERENCES empregados (idempregado);

ALTER TABLE acordonivelservico ADD  idcontrato int4 NULL;
ALTER TABLE acordonivelservico ADD CONSTRAINT fk_ans_contrato FOREIGN KEY (idcontrato) REFERENCES contratos (idcontrato);

delete from menu where nome = '$menu.nome.ReqNivelServico';
delete from menu where nome = '$menu.nome.acordoNivelServicoMultinivel';

-- FIM - [rodrigo.guilherme] - 22/09/2015

--INCIO - [joao.morais] - 26/11/2015

delete from visaorelacionada where idvisaorelacionada = '3622' 
	OR idvisaorelacionada = '3623' 
	OR idvisaorelacionada = '3624' 
	OR idvisaorelacionada = '3625'
	OR idvisaorelacionada = '3626'
	OR idvisaorelacionada = '3627'
	OR idvisaorelacionada = '3628'
	OR idvisaorelacionada = '3629';
delete from visao where descricao = '$visao.ListagemContratos';
delete from visao where descricao = '$visao.contratos';
delete from menu where nome = '$menu.nome.cadastroContratos';

-- FIM - [joao.morais] - 26/11/2015

-- INCIO - [murilo.rodrigues] - 01/10/2015

CREATE TABLE aplicacao
(
	idaplicacao int4 NOT NULL,
	nome varchar(256) DEFAULT NULL,
	datafim date DEFAULT NULL,
	ultimaversaodisponivel varchar(100) DEFAULT NULL,
	idresponsavel int4 DEFAULT NULL,
	CONSTRAINT aplicacao_pkey PRIMARY KEY (idaplicacao)
);

CREATE TABLE aplicacaorequisito
(
	idrequisitoaplicacao int4 NOT NULL,
	idaplicacao int4 DEFAULT NULL,
	nomerequisito varchar(256) DEFAULT NULL,
	detalhesrequisito text DEFAULT NULL,
	statusrequisito varchar(256) DEFAULT NULL,
	deleted varchar(1) DEFAULT 'N',
	CONSTRAINT aplicacaorequisito_pkey PRIMARY KEY (idrequisitoaplicacao)
);

alter table aplicacaorequisito add constraint fk_idaplicacao_requisito foreign key (idaplicacao) references aplicacao (idaplicacao);

CREATE TABLE aplicacaocliente
(
	idaplicacaocliente int4 NOT NULL,
	idcliente int4 NOT NULL,
	idaplicacao int4 NOT NULL,
	CONSTRAINT aplicacaocliente_pkey PRIMARY KEY (idaplicacaocliente)
);
		
alter table aplicacaocliente add constraint fk_aplicacaocliente_idcliente foreign key (idcliente) references clientes (idcliente);
alter table aplicacaocliente add constraint fk_aplicacaocliente_idaplicacao foreign key (idaplicacao) references aplicacao (idaplicacao);

-- FIM - [murilo.rodrigues] - 01/10/2015

-- INICIO - [ibimon.morais] - 01/10/2015
CREATE TABLE casonegocio
(
	idcasonegocio int4 NOT NULL,
	idservicocasonegocio  bigint NOT NULL,
	nomecasonegocio text,
	descricaosumarioexecutivo text,
	descricaocenarios text,
	descricaoproblemaoportunidade text,
	descricaopropostasolucao text,
	descricaoanalisefinanceira text,
	descricaoanaliserisco text,
	descricaostakeholderentidade text,
	descricaoviabilidadetecnica text,
	descricaoconclusao text,
	datafim date,	
	CONSTRAINT casonegocio_pkey PRIMARY KEY (idcasonegocio)
);

alter table casonegocio add constraint fk_id_servico_caso_negocio foreign key (idservicocasonegocio) references servico (idservico);
-- FIM - [ibimon.morais] - 01/10/2015

-- INCIO [douglas.japiassu] 20.10.2015

create table requisitosnivelservico (
	idrequisitosnivelservico bigint not null,
	idserviconegocio bigint not null,
	datacriacao date not null,
	idempregado integer null,
	datainicioservico date,
	donodoservico text,
	especificacao text,
	contexto text,
	funcionalidadesessenciais text,
	seguranca text,
	disponibilidade text,
	capacidade text,
	continuidadedonegocio text,
	performancedesempenho text,
	interrupcoesplanejadas text,
	gestaodeincidentes text,
	gestaodeproblemas text,
	gestaodemudancas text,
	conformidadeinterna text,
	conformidadeexterna text,
	datafim date,
	primary key (idrequisitosnivelservico)
);

alter table requisitosnivelservico add constraint servico_requisitos_fk foreign key (idserviconegocio) references servico (idservico);
-- INCIO [ibimon.morais] 28.10.2015
alter table requisitosnivelservico add constraint id_empregados_fk foreign key (idempregado) references empregados (idempregado);
-- FIM [ibimon.morais] 28.10.2015

create table esquemadados (
	idesquemadados bigint not null,
	idserviconegocio bigint not null,
	datacriacao date not null,
	detalhes text,
	datafim date,
	primary key (idesquemadados)
);

alter table esquemadados add constraint servico_esquemadados_fk foreign key (idserviconegocio) references servico (idservico);

-- FIM [douglas.japiassu] 20.10.2015

-- INCIO [douglas.japiassu] 26.10.2015

alter table servico add processodeiniciacao varchar(5) null;
alter table servico add tipodeinvestimento varchar(5) null;

-- FIM [douglas.japiassu] 26.10.2015

-- INCIO [ibimon.morais] 26.10.2015
alter table fornecedor add tipofornecedor varchar(1) null;
-- FIM [ibimon.morais] 26.10.2015

-- INCIO [ibimon.morais] 27.10.2015
alter table clientes add tipocliente character(1) null;
-- FIM [ibimon.morais] 27.10.2015

-- INCIO [douglas.japiassu] 27.10.2015

alter table servico_hist add faseservico varchar(2) null;
alter table servico_hist add statusservico varchar(5) null;

-- FIM [douglas.japiassu] 27.10.2015

-- INCIO [ibimon.morais] 04.11.2015
alter table solicitacaoservico add justificativavencimentosla text null;
-- FIM [douglas.japiassu] 04.11.2015

--INICIO - thyen.chang - 05.11.2015
ALTER TABLE historicoic ADD datafim DATE NULL;
ALTER TABLE historicoic ADD datahoradesinstalacao DATE NULL;
ALTER TABLE historicoic ADD datainicio DATE NULL;
ALTER TABLE historicoic ADD idbaseconhecimento INT NULL;
ALTER TABLE historicoic ADD idgruporesponsavel INT NULL;
ALTER TABLE historicoic ADD informacoesadicionais VARCHAR(4000) NULL;
ALTER TABLE historicoic ADD nome TEXT NULL;
-- FIM - thyen.chang - 05.11.2015

-- INCIO ERICK.SATO
create table problemabaseconhecimentorelacionado (
  idproblemabaseconhecimentorelacionado int not null,
  idproblema int not null,
  idBaseConhecimento int not null,
  primary key (idproblemabaseconhecimentorelacionado),
  constraint fk_problema_baseconhecimntorelacionado
    foreign key (idproblema )
    references problema (idproblema),
  constraint fk_baseconhecimento_problemarelacionado
    foreign key (idBaseConhecimento )
    references baseconhecimento (idBaseConhecimento )
);

-- INICIO - CRISTIAN GUEDES - 05/11/2015

create table evm_g_g_nagios
(
	idgerente int not null,
	nome varchar(255) not null,
	idconexao int not null,
	idusuariocriador int not null,
	idusuariomodificador int,
	datahorainicio date not null,
	datahorafim date default null,
	datahoraultimaalteracao date default null,
	epl text,
	autocorrecao char(1) DEFAULT NULL,
	primary key (idgerente)
);

create table evm_linha_g_g_nagios
(
    idlinha int not null,
	idgerente int not null,
	host varchar(50) not null,
	service varchar(50) not null,
	idcron int not null,
	idfluxoacaoinformation int,
	idFluxoAcaoWarning int,
	idFluxoAcaoException int,
	idFluxoAcaoDown int,
	idFluxoAcaoUp int,
	autocorrecao char(1) DEFAULT NULL,
	autocorrecaoquantidade int  DEFAULT NULL,
	idusuariocriador int not null,
	idusuariomodificador int,
	datahorainicio date not null,
	datahorafim date default null,
	datahoraultimaalteracao date default null,
	idevmcategoriaocorrencia int NOT NULL,
	epl text,
	linhaativa char(1) default 'S',
	primary key (idlinha),
	foreign key (idgerente) references evm_g_g_nagios(idgerente) on delete cascade
);

-- FIM - CRISTIAN GUEDES - 05/11/2015

-- INICIO - GILBERTO NERY - 06/11/2015

update parametrocorpore set datafim = current_date where idparametrocorpore in (1,2,6,8);

-- FIM - GILBERTO NERY - 06/11/2015

--INCIO - [gustavo.gomes] - 24/11/2015

----24/11/2015
delete from menu where nome = '$menu.nome.catalogoNegocio';

CREATE TABLE aplicacaoservico (
  idaplicacaoservico int not null,
  idservico int not null,
  idaplicacao int not null,
  primary key (idaplicacaoservico),
  foreign key (idaplicacao) references aplicacao (idaplicacao),
  foreign key (idservico) references servico (idservico)
);

----19/01/2016
CREATE TABLE VINCULOSERVICOPROPRIETARIOS(
  IDVINCULOSERVICOPROPRIETARIOS int8 not null,
  IDSERVICO int8 not null,
  IDEMPREGADO int4,
  IDGRUPO int4,
  TIPO int4,
  primary key (IDVINCULOSERVICOPROPRIETARIOS)
);

-- FIM - [gustavo.gomes] - 19/01/2016

-- INCIO [douglas.japiassu] 25.11.2015

update bi_consulta set naoatualizbase = 'N' where naoatualizbase is null or naoatualizbase = '';
alter table bi_consulta alter column naoatualizbase set not null;
alter table bi_consulta add tipoexibicao varchar(1) not null default 'N';
alter table bi_consulta add moduloexibicao varchar(50) null;

-- FIM [douglas.japiassu] 25.11.2015

--INCIO - [rodrigo.acorse] - 01/12/2015

delete from menu where nome = '$menu.nome.evm.pesquisaocorrenciaeventos';
delete from menu where nome = '$menu.nome.itemConfiguracao';

-- FIM - [rodrigo.acorse] - 01/12/2015

--INCIO - [rodrigo.acorse] - 22/12/2015

alter table evm_gerente add gerarup char(1) null default 'S';
alter table evm_gerente add gerardown char(1) null default 'S';

alter table evm_gerenciado_inventory add gerarinformation char(1) null default 'S';
alter table evm_gerenciado_inventory add gerarwarning char(1) null default 'S';
alter table evm_gerenciado_inventory add gerarexception char(1) null default 'S';

alter table evm_gerenciado_nagios add gerarinformation char(1) null default 'S';
alter table evm_gerenciado_nagios add gerarwarning char(1) null default 'S';
alter table evm_gerenciado_nagios add gerarexception char(1) null default 'S';

alter table evm_gerenciado_zabbix add gerarinformation char(1) null default 'S';
alter table evm_gerenciado_zabbix add gerarwarning char(1) null default 'S';
alter table evm_gerenciado_zabbix add gerarexception char(1) null default 'S';

alter table evm_linha_g_g_nagios add gerarup char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerardown char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerarinformation char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerarwarning char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerarexception char(1) null default 'S';

-- FIM - [rodrigo.acorse] - 22/12/2015

-- INCIO - [deborah.ferreira] - 13/01/2016

CREATE TABLE processonegociounidades (
	idprocessonegociounidades int4 NOT NULL,
	idprocessonegocio int4 NOT NULL,
	idunidade int4 NOT NULL,
	PRIMARY KEY (idprocessonegociounidades),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio),
	FOREIGN KEY (idunidade) REFERENCES unidade (idunidade)
);

CREATE TABLE processonegociotiposfluxo (
	idprocessonegociotiposfluxo int4 NOT NULL,
	idprocessonegocio int4 NOT NULL,
	idtipofluxo int4 NOT NULL,
	PRIMARY KEY (idprocessonegociotiposfluxo),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio),
	FOREIGN KEY (idtipofluxo) REFERENCES bpm_tipofluxo (idtipofluxo)
);

ALTER TABLE processonegocio ALTER COLUMN percdispensanovaaprovacao DROP NOT NULL;
ALTER TABLE processonegocio ALTER COLUMN permiteaprovacaonivelinferior DROP NOT NULL;
ALTER TABLE processonegocio ALTER COLUMN permissaosolicitacao DROP NOT NULL;

ALTER TABLE processonegocio ADD deleted varchar(1) DEFAULT 'N';
-- FIM - [deborah.ferreira] - 13/01/2016 

-- INCIO - [douglas.japiassu] - 14/01/2016

UPDATE 
	servico 
SET 
	tiposervico = tipodemandaservico.classificacao
FROM 
	(SELECT idtipodemandaservico, classificacao FROM tipodemandaservico) tipodemandaservico 
WHERE
	tipodemandaservico.idtipodemandaservico = servico.idtipodemandaservico 
	and servico.tiposervico is null;

-- FIM - [douglas.japiassu] - 14/01/2016

--INCIO - [joao.morais] - 14/01/2016
create table tipofinanceiroservico (
	idtipo bigint not null, 
	perfil varchar(1) not null,
	nometipo varchar(255) not null,
	datafim date,
	primary key (idtipo)
);

create table financeiroservico (
	idfinanceiroservico bigint not null, 
	idservico bigint not null,
	idtipo bigint not null,
	valor float not null,
	datafim date,
	primary key (idfinanceiroservico)
);

alter table financeiroservico add CONSTRAINT fk_finan_serv_tipofin FOREIGN KEY (idtipo) REFERENCES tipofinanceiroservico (idtipo);
alter table financeiroservico add CONSTRAINT fk_finan_serv_servico FOREIGN KEY (idservico) REFERENCES servico (idservico);
-- FIM - [joao.morais] - 14/01/2016

--INCIO - [pedro.francisco] - 18/01/2016
CREATE TABLE portfoliobusinessuser (
	idbusinessuser int8 NOT NULL,
	idservico int8 NOT NULL,
	idgrupo int4,
	idusuario int4,
	tipo INTEGER NOT NULL,
	CONSTRAINT portfoliobusinessuser_pk PRIMARY KEY (idbusinessuser),
	CONSTRAINT portfoliobusinessuser_grupo_fk FOREIGN KEY (idgrupo) REFERENCES public.grupo(idgrupo),
	CONSTRAINT portfoliobusinessuser_usuario_fk FOREIGN KEY (idusuario) REFERENCES public.usuario(idusuario),
	CONSTRAINT portfoliobusinessuser_servico_fk FOREIGN KEY (idservico) REFERENCES public.servico(idservico)
);
--FIM - [pedro.francisco] - 18/01/2016
-- FIM - [joao.morais] - 14/01/2016

--INCIO - [joao.morais] - 18/01/2016
alter table contratos add horasuporte int;
alter table contratos add escopo varchar(255);
alter table contratos add datarevisaorenovacao date;
-- FIM - [joao.morais] - 18/01/2016

-- INCIO - [deborah.ferreira] - 14/01/2016

CREATE TABLE servicoprocessonegocio (
	idservicoprocessonegocio int4 NOT NULL,
	idservico bigint NOT NULL,
	idprocessonegocio int4 NOT NULL,
	PRIMARY KEY (idservicoprocessonegocio),
	FOREIGN KEY (idservico) REFERENCES servico (idservico),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio)
);
-- FIM - [deborah.ferreira] - 14/01/2016 

--INCIO - [gilmar.junior] - 18/01/2016
create table servicodononegocio(
	idservicodononegocio int8 not null,
	idservico int8 not null,
	idgrupo int4,
	idempregado int4,
	tipodononegocio INTEGER not null,
	primary key (idservicodononegocio)
);

alter table servicodononegocio add CONSTRAINT fk_dono_serv_servico FOREIGN KEY (idservico) REFERENCES servico (idservico);
alter table servicodononegocio add CONSTRAINT fk_dono_serv_grupo FOREIGN KEY (idgrupo) REFERENCES grupo (idgrupo);
alter table servicodononegocio add CONSTRAINT fk_dono_serv_emp FOREIGN KEY (idempregado) REFERENCES empregados (idempregado);
-- FIM - [gilmar.junior] - 18/01/2016

-- INICIO - [gilberto.nery] - 20/01/2016

CREATE TABLE evm_acao_problema (
  idacaoproblema bigint NOT NULL,
  idacao bigint NOT NULL,
  idcontrato int NULL,
  idsolicitante int NULL,
  idorigem bigint NULL,
  idgrupo int NULL,
  nomecontato VARCHAR(100) NULL,
  emailcontato VARCHAR(200) NULL,
  telefonecontato VARCHAR(100) NULL,
  ramalcontato VARCHAR(5) NULL,
  observacao TEXT NULL,
  idunidade int NULL,
  idlocalidade int NULL,
  tituloproblema VARCHAR(255) NULL,
  descricaoproblema TEXT NULL,
  severidadeproblema VARCHAR(15) NULL,
  impactoproblema VARCHAR(10) NULL,
  urgenciaproblema VARCHAR(10) NULL,
  datahoralimitesolucionar DATE NULL,
  prioridade bigint NULL,
  proativoreativo VARCHAR(15) NULL,
  enviaemailcriacao CHAR(1) NULL,
  enviaemailfinalizacao CHAR(1) NULL,
  enviaemailacoes CHAR(1) NULL,
  idcategoriaproblema int NULL,
  idcausa int NULL,
  idcategoriasolucao int NULL,
  fechamento TEXT NULL,
  PRIMARY KEY (idacaoproblema),
  foreign key (idacao) references evm_acao(idacao),
  foreign key (idcontrato) references contratos(idcontrato),
  foreign key (idsolicitante) references empregados(idempregado),
  foreign key (idorigem) references origematendimento(idorigem),
  foreign key (idgrupo) references grupo (idgrupo),
  foreign key (idunidade) references unidade (idunidade),
  foreign key (idlocalidade) references localidade (idlocalidade),
  foreign key (idcategoriaproblema) references categoriaproblema (idcategoriaproblema),
  foreign key (idcategoriasolucao) references categoriasolucao (idcategoriasolucao),
  foreign key (idcausa) references causaincidente (idcausaincidente)
);

CREATE TABLE evm_acao_instancia_problema (
  idacaoinstanciaproblema bigint NOT NULL,
  idacaoinstancia bigint NOT NULL,
  idrequisicaoproblema int NULL,
  PRIMARY KEY (idacaoinstanciaproblema),
  foreign key (idacaoinstancia) references evm_acao_instancia(idacaoinstancia),
  foreign key (idrequisicaoproblema) references problema(idproblema)
);

CREATE TABLE evm_acaomanualproblema (
  idevmacaomanualproblema bigint NOT NULL,
  idocorrencia character varying(254) not null,
  idrequisicaoproblema bigint NOT NULL,
  datainicio date not null,
  datafim date,
  PRIMARY KEY (idevmacaomanualproblema),
  foreign key (idrequisicaoproblema) references problema(idproblema)
);

-- FIM - [gilberto.nery] - 20/01/2016

-- INICIO - thyen.chang - 26/01/2016

ALTER TABLE evm_gerenciado_zabbix ALTER COLUMN nometrigger TYPE varchar(255);

-- FIM - thyen.chang - 26/01/2016

-- INICIO - rodrigo.acorse - 27/01/2016

ALTER TABLE evm_gerenciado_nagios ALTER COLUMN servico TYPE varchar(255);

-- FIM - rodrigo.acorse - 27/01/2016-- FIM - [joao.morais] - 14/01/2016

-- INCIO [douglas.japiassu] Scripts CARLOS - MOBILE - 11.02.2016
alter table ocorrenciasolicitacao add codigoexterno character varying(100);
alter table rest_execution add platform character varying(255);
alter table rest_execution add uuid character varying(255);
ALTER TABLE ocorrenciasolicitacao ALTER COLUMN descricao TYPE character varying(2000);
alter table tabfederacaodados DROP CONSTRAINT tabfederacaodados_pkey;
ALTER TABLE tabfederacaodados ADD CONSTRAINT tabfederacaodados_pkey PRIMARY KEY (nometabela, chavefinal, chaveoriginal, origem);
-- FIM [douglas.japiasssu] Scripts CARLOS - MOBILE - 11.02.2016

-- INICIO - thyen.chang - 06.03.2016

ALTER TABLE empregados ALTER COLUMN cpf TYPE CHARACTER VARYING(16);

-- FIM - thyen.chang - 06.03.2016

-- INICIO - thyen.chang - 06.03.2016

alter table planomelhoria add column datainicio date;

alter table planomelhoria drop column datainicioplano;

alter table acaoplanomelhoria add column datainicio date;

alter table acaoplanomelhoria add column datafim date;

-- FIM - thyen.chang - 06.03.2016