-- INICIO - [douglas.japiassu] - 04/09/2015	
	
create table portfolioservico (
	idportfolioservico bigint not null, 
	descportfolioservico varchar(500), 
	datainicio date not null, 
	datafim date,
	primary key (idportfolioservico)
);

alter table servico add idportfolioservico bigint null;
alter table servico add tiposervico varchar(1) null;
alter table servico add faseservico varchar(2) null;
alter table servico add statusservico varchar(5) null;
alter table servico add constraint servico_portfolioservico_fk foreign key (idportfolioservico) references portfolioservico (idportfolioservico);

alter table servicocontrato add idservicocontratorelacionado bigint null;
alter table servicocontrato add constraint servicocontrato_autorel foreign key (idservicocontratorelacionado) references servicocontrato (idservicocontrato);

alter table categoriaservico add tipocategoria varchar(1) not null default 'R';

create table servicoautorelacionamento (
	idservicoautorelacionamento bigint not null, 
	idservico bigint not null,
	idservicorelacionado bigint not null,
	faseservico varchar(2),
	statusservico varchar(5),
	datainicio date not null, 
	datafim date,
	primary key (idservicoautorelacionamento)
);

alter table servicoautorelacionamento add constraint serv_autorel_servico foreign key (idservico) references servico (idservico);
alter table servicoautorelacionamento add constraint serv_autorel_servrelacionado foreign key (idservicorelacionado) references servico (idservico);
-- FIM - [douglas.japiassu] - 23/09/2015

--INCIO - [rodrigo.guilherme] - 22/09/2015

CREATE TABLE mapanegocioitem
(
	idmapanegocioitem int NOT NULL,
	idserviconegocio bigint DEFAULT NULL,
	idservicoapoio bigint DEFAULT NULL,
	iditemconfiguracao int DEFAULT NULL,
	posx int DEFAULT NULL,
	posy int DEFAULT NULL,
	descricao varchar(256) DEFAULT NULL,
	icone varchar(256) DEFAULT NULL,
	CONSTRAINT mapanegitem_pkey PRIMARY KEY (idmapanegocioitem)
);

CREATE TABLE mapanegociorelacao
(
	idmapanegociorelacao int NOT NULL,
	idmapanegocioitemfilho int NOT NULL,
	idmapanegocioitempai int NOT NULL,
	CONSTRAINT mapanegrel_pkey PRIMARY KEY (idmapanegociorelacao)
);

alter table mapanegocioitem add constraint fk_map_neg_item_serneg foreign key (idserviconegocio) references servico (idservico);
alter table mapanegocioitem add constraint fk_map_neg_item_serapo foreign key (idservicoapoio) references servico (idservico);
alter table mapanegocioitem add constraint fk_map_neg_item_ic foreign key (iditemconfiguracao) references itemconfiguracao (iditemconfiguracao);
alter table mapanegociorelacao add constraint fk_map_neg_item_rel_fil foreign key (idmapanegocioitemfilho) references mapanegocioitem (idmapanegocioitem);
alter table mapanegociorelacao add constraint fk_map_neg_item_rel_pai foreign key (idmapanegocioitempai) references mapanegocioitem (idmapanegocioitem);

CREATE TABLE tempoatendimentounidade (
	idtempoatendimentounidade bigint NOT NULL,
	idacordonivelservico bigint NOT NULL,
	idunidade int NOT NULL,
	PRIMARY KEY (idtempoatendimentounidade)
);

ALTER TABLE tempoatendimentounidade ADD CONSTRAINT fk_ta_unidade_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico);
ALTER TABLE tempoatendimentounidade ADD CONSTRAINT fk_ta_unidade_uni FOREIGN KEY (idunidade) REFERENCES unidade (idunidade);

CREATE TABLE tempoatendimentoempregado (
	idtempoatendimentoempregado bigint NOT NULL,
 	idacordonivelservico bigint NOT NULL,
	idempregado int NOT NULL,
 	PRIMARY KEY (idtempoatendimentoempregado)
);

ALTER TABLE tempoatendimentoempregado ADD CONSTRAINT fk_ta_empregado_ans FOREIGN KEY (idacordonivelservico) REFERENCES acordonivelservico (idacordonivelservico);
ALTER TABLE tempoatendimentoempregado ADD CONSTRAINT fk_ta_empregado_emp FOREIGN KEY (idempregado) REFERENCES empregados (idempregado);

ALTER TABLE acordonivelservico ADD  idcontrato int NULL;
ALTER TABLE acordonivelservico ADD CONSTRAINT fk_ans_contrato FOREIGN KEY (idcontrato) REFERENCES contratos (idcontrato);

delete from menu where nome = '$menu.nome.ReqNivelServico';
delete from menu where nome = '$menu.nome.acordoNivelServicoMultinivel';

-- FIM - [rodrigo.guilherme] - 22/09/2015

--INCIO - [joao.morais] - 26/11/2015

delete from visaorelacionada where idvisaorelacionada = '3622' 
	OR idvisaorelacionada = '3623' 
	OR idvisaorelacionada = '3624' 
	OR idvisaorelacionada = '3625'
	OR idvisaorelacionada = '3626'
	OR idvisaorelacionada = '3627'
	OR idvisaorelacionada = '3628'
	OR idvisaorelacionada = '3629';
delete from visao where descricao = '$visao.ListagemContratos';
delete from visao where descricao = '$visao.contratos';
delete from menu where nome = '$menu.nome.cadastroContratos';

-- FIM - [joao.morais] - 26/11/2015

-- INCIO - [murilo.rodrigues] - 01/10/2015

CREATE TABLE aplicacao
(
	idaplicacao int NOT NULL,
	nome varchar(256) DEFAULT NULL,
	datafim date DEFAULT NULL,
	ultimaversaodisponivel VARCHAR(100) DEFAULT NULL,
	idresponsavel INT DEFAULT NULL,
	CONSTRAINT aplicacao_pkey PRIMARY KEY (idaplicacao)
);

CREATE TABLE aplicacaorequisito
(
	idrequisitoaplicacao int NOT NULL,
	idaplicacao int DEFAULT NULL,
	nomerequisito varchar(256) DEFAULT NULL,
	detalhesrequisito text DEFAULT NULL,
	statusrequisito varchar(256) DEFAULT NULL,
	deleted varchar(1) DEFAULT 'N',
	CONSTRAINT aplicacaorequisito_pkey PRIMARY KEY (idrequisitoaplicacao)
);

alter table aplicacaorequisito add constraint fk_idaplicacao_requisito foreign key (idaplicacao) references aplicacao (idaplicacao);

CREATE TABLE aplicacaocliente
(
	idaplicacaocliente int NOT NULL,
	idcliente int NOT NULL,
	idaplicacao int NOT NULL,
	CONSTRAINT aplicacaocliente_pkey PRIMARY KEY (idaplicacaocliente)
);
		
alter table aplicacaocliente add constraint fk_aplicacaocliente_idcliente foreign key (idcliente) references clientes (idcliente);
alter table aplicacaocliente add constraint fk_aplicacaocliente_idaplicacao foreign key (idaplicacao) references aplicacao (idaplicacao);

-- FIM - [murilo.rodrigues] - 01/10/2015

-- INICIO - [ibimon.morais] - 01/10/2015
CREATE TABLE casonegocio
(
	idcasonegocio  int NOT NULL,
	idservicocasonegocio  bigint NOT NULL,
	nomecasonegocio varchar(100) DEFAULT NULL,
	descricaosumarioexecutivo text,
	descricaocenarios text,
	descricaoproblemaoportunidade text,
	descricaopropostasolucao text,
	descricaoanalisefinanceira text,
	descricaoanaliserisco text,
	descricaostakeholderentidade text,
	descricaoviabilidadetecnica text,
	descricaoconclusao text,
	datafim date default NULL,
	CONSTRAINT casonegocio_pkey PRIMARY KEY (idcasonegocio)
);
alter table casonegocio add constraint fk_id_servico_caso_negocio foreign key (idservicocasonegocio) references servico (idservico);
-- FIM - [ibimon.morais] - 01/10/2015

-- INCIO [douglas.japiassu] 20.10.2015

create table requisitosnivelservico (
	idrequisitosnivelservico bigint not null,
	idserviconegocio bigint not null,
	datacriacao date not null,
	idempregado int null,
	datainicioservico date,
	donodoservico text,
	especificacao text,
	contexto text,
	funcionalidadesessenciais text,
	seguranca text,
	disponibilidade text,
	capacidade text,
	continuidadedonegocio text,
	performancedesempenho text,
	interrupcoesplanejadas text,
	gestaodeincidentes text,
	gestaodeproblemas text,
	gestaodemudancas text,
	conformidadeinterna text,
	conformidadeexterna text,
	datafim date,
	primary key (idrequisitosnivelservico)
);

alter table requisitosnivelservico add constraint servico_requisitos_fk foreign key (idserviconegocio) references servico (idservico);
-- INCIO [ibimon.morais] 28.10.2015
alter table requisitosnivelservico add constraint id_empregados_fk foreign key (idempregado) references empregados (idempregado);
-- FIM [ibimon.morais] 28.10.2015

create table esquemadados (
	idesquemadados bigint not null,
	idserviconegocio bigint not null,
	datacriacao date not null,
	detalhes text,
	datafim date,
	primary key (idesquemadados)
);

alter table esquemadados add constraint servico_esquemadados_fk foreign key (idserviconegocio) references servico (idservico);

-- FIM [douglas.japiassu] 20.10.2015

-- INCIO [douglas.japiassu] 26.10.2015

alter table servico add processodeiniciacao varchar(5) null;
alter table servico add tipodeinvestimento varchar(5) null;

-- FIM [douglas.japiassu] 26.10.2015

-- INCIO [ibimon.morais] 26.10.2015
alter table fornecedor add tipofornecedor varchar(1) null;
-- FIM [ibimon.morais] 26.10.2015

-- INCIO [ibimon.morais] 27.10.2015
alter table clientes add tipocliente varchar(1) null;
-- FIM [ibimon.morais] 27.10.2015

-- INCIO [douglas.japiassu] 27.10.2015
alter table servico_hist add faseservico varchar(2) null;
alter table servico_hist add statusservico varchar(5) null;
-- FIM [douglas.japiassu] 27.10.2015

-- INCIO [ibimon.morais] 04.11.2015
alter table solicitacaoservico add justificativavencimentosla text null;
-- FIM [ibimon.morais] 04.11.2015

--INICIO - thyen.chang - 05.11.2015
ALTER TABLE historicoic ADD datafim DATE NULL;
ALTER TABLE historicoic ADD datahoradesinstalacao DATE NULL;
ALTER TABLE historicoic ADD datainicio DATE NULL;
ALTER TABLE historicoic ADD idbaseconhecimento INT NULL;
ALTER TABLE historicoic ADD idgruporesponsavel INT NULL;
ALTER TABLE historicoic ADD informacoesadicionais VARCHAR(4000) NULL;
ALTER TABLE historicoic ADD nome TEXT NULL;
-- FIM - thyen.chang - 05.11.2015

--INCIO ERICK.SATO
create table problemabaseconhecimentorelacionado (
	idproblemabaseconhecimentorelacionado bigint not null,
	idproblema int not null references problema(idproblema),
	idBaseConhecimento int not null references baseconhecimento(idBaseConhecimento),
	constraint problemabaseconhecimentorelacionado_PK primary key (idproblemabaseconhecimentorelacionado)
);		

-- INICIO - CRISTIAN GUEDES - 05/11/2015

create table evm_g_g_nagios
(
	idgerente bigint not null,
	nome varchar(255) not null,
	idconexao bigint not null,
	idusuariocriador bigint not null,
	idusuariomodificador bigint,
	datahorainicio date not null,
	datahorafim date default null,
	datahoraultimaalteracao date default null,
	epl text,
	autocorrecao char(1) DEFAULT NULL,
	primary key (idgerente)
);

create table evm_linha_g_g_nagios
(
    idlinha bigint not null,
	idgerente bigint not null,
	host varchar(50) not null,
	service varchar(50) not null,
	idcron bigint not null,
	idfluxoacaoinformation bigint,
	idFluxoAcaoWarning bigint,
	idFluxoAcaoException bigint,
	idFluxoAcaoDown bigint,
	idFluxoAcaoUp bigint,
	autocorrecao char(1) DEFAULT NULL,
	autocorrecaoquantidade int  DEFAULT NULL,
	idusuariocriador bigint not null,
	idusuariomodificador bigint,
	datahorainicio date not null,
	datahorafim date default null,
	datahoraultimaalteracao date default null,
	idevmcategoriaocorrencia bigint NOT NULL,
	epl text,
	linhaativa char(1) default 'S',
	primary key (idlinha),
	foreign key (idgerente) references evm_g_g_nagios(idgerente) on delete cascade
);

-- FIM - CRISTIAN GUEDES - 05/11/2015

-- INICIO - GILBERTO NERY - 06/11/2015
update parametrocorpore set datafim = getdate() where idparametrocorpore in (1,2,6,8);
-- FIM - GILBERTO NERY - 06/11/2015

--INCIO - [gustavo.gomes] - 24/11/2015

----24/11/2015
delete from menu where nome = '$menu.nome.catalogoNegocio';

CREATE TABLE aplicacaoservico (
  idaplicacaoservico bigint not null,
  idservico bigint not null,
  idaplicacao int not null,
  primary key (idaplicacaoservico),
  foreign key (idaplicacao) references aplicacao (idaplicacao),
  foreign key (idservico) references servico (idservico)
);

----19/01/2016
CREATE TABLE VINCULOSERVICOPROPRIETARIOS (
  IDVINCULOSERVICOPROPRIETARIOS bigint not null,
  IDSERVICO bigint not null,
  IDEMPREGADO int,
  IDGRUPO int,
  TIPO int,
  primary key (IDVINCULOSERVICOPROPRIETARIOS)
);

-- FIM - [gustavo.gomes] - 19/01/2016

-- INCIO [douglas.japiassu] 25.11.2015

update bi_consulta set naoatualizbase = 'N' where naoatualizbase is null or naoatualizbase = '';
alter table bi_consulta alter column naoatualizbase char(1) not null;
alter table bi_consulta add tipoexibicao varchar(1) not null default 'N';
alter table bi_consulta add moduloexibicao varchar(50) null;

-- FIM [douglas.japiassu] 25.11.2015

--INCIO - [rodrigo.acorse] - 01/12/2015

delete from menu where nome = '$menu.nome.evm.pesquisaocorrenciaeventos';
delete from menu where nome = '$menu.nome.itemConfiguracao';

-- FIM - [rodrigo.acorse] - 01/12/2015

--INCIO - [rodrigo.acorse] - 22/12/2015

alter table evm_gerente add gerarup char(1) null default 'S';
alter table evm_gerente add gerardown char(1) null default 'S';

alter table evm_gerenciado_inventory add gerarinformation char(1) null default 'S';
alter table evm_gerenciado_inventory add gerarwarning char(1) null default 'S';
alter table evm_gerenciado_inventory add gerarexception char(1) null default 'S';

alter table evm_gerenciado_nagios add gerarinformation char(1) null default 'S';
alter table evm_gerenciado_nagios add gerarwarning char(1) null default 'S';
alter table evm_gerenciado_nagios add gerarexception char(1) null default 'S';

alter table evm_gerenciado_zabbix add gerarinformation char(1) null default 'S';
alter table evm_gerenciado_zabbix add gerarwarning char(1) null default 'S';
alter table evm_gerenciado_zabbix add gerarexception char(1) null default 'S';

alter table evm_linha_g_g_nagios add gerarup char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerardown char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerarinformation char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerarwarning char(1) null default 'S';
alter table evm_linha_g_g_nagios add gerarexception char(1) null default 'S';

-- FIM - [rodrigo.acorse] - 22/12/2015

-- INCIO - [deborah.ferreira] - 13/01/2016

CREATE TABLE processonegociounidades
(
	idprocessonegociounidades int NOT NULL,
	idprocessonegocio int NOT NULL,
	idunidade int NOT NULL,
	PRIMARY KEY (idprocessonegociounidades),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio),
	FOREIGN KEY (idunidade) REFERENCES unidade (idunidade)
);

CREATE TABLE processonegociotiposfluxo
(
	idprocessonegociotiposfluxo int NOT NULL,
	idprocessonegocio int NOT NULL,
	idtipofluxo int NOT NULL,
	PRIMARY KEY (idprocessonegociotiposfluxo),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio),
	FOREIGN KEY (idtipofluxo) REFERENCES bpm_tipofluxo (idtipofluxo)
);

ALTER TABLE processonegocio ALTER COLUMN percdispensanovaaprovacao decimal(5,2);
ALTER TABLE processonegocio ALTER COLUMN permiteaprovacaonivelinferior char(1);
ALTER TABLE processonegocio ALTER COLUMN permissaosolicitacao char(1);

ALTER TABLE processonegocio ADD deleted varchar(1) DEFAULT 'N';
-- FIM - [deborah.ferreira] - 13/01/2016 

-- INCIO - [douglas.japiassu] - 14/01/2016

UPDATE 
	servico 
SET 
	tiposervico = tipodemandaservico.classificacao 
FROM 
	(SELECT idtipodemandaservico, classificacao FROM tipodemandaservico) tipodemandaservico 
WHERE 
	tipodemandaservico.idtipodemandaservico = servico.idtipodemandaservico 
	and servico.tiposervico is null;

-- FIM - [douglas.japiassu] - 14/01/2016

--INCIO - [joao.morais] - 14/01/2016
create table tipofinanceiroservico (
	idtipo bigint not null, 
	perfil varchar(1) not null,
	nometipo varchar(255) not null,
	datafim date,
	primary key (idtipo)
);
	
create table financeiroservico (
	idfinanceiroservico bigint not null, 
	idservico bigint not null,
	idtipo bigint not null,
	valor float not null,
	datafim date,
	primary key (idfinanceiroservico)
);

alter table financeiroservico add CONSTRAINT fk_finan_serv_servico FOREIGN KEY (idservico) REFERENCES servico (idservico);
alter table financeiroservico add CONSTRAINT fk_finan_serv_tipofin FOREIGN KEY (idtipo) REFERENCES tipofinanceiroservico (idtipo);
-- FIM - [joao.morais] - 14/01/2016

--INCIO - [pedro.francisco] - 18/01/2016
create table portfoliobusinessuser (
	idbusinessuser int not null,
	idservico bigint not null,
	idgrupo int,
	idusuario int,
	tipo int not null,
	constraint portfoliobusinessuser_pk primary key (idbusinessuser),
	constraint portfoliobusinessuser_grupo_fk foreign key (idgrupo) references grupo(idgrupo),
	constraint portfoliobusinessuser_usuario_fk foreign key (idusuario) references usuario(idusuario),
	constraint portfoliobusinessuser_servico_fk foreign key (idservico) references servico(idservico)
);
--FIM - [pedro.francisco] - 18/01/2016

-- FIM - [joao.morais] - 14/01/2016

--INCIO - [joao.morais] - 18/01/2016
alter table contratos add horasuporte int;
alter table contratos add escopo varchar(255);
alter table contratos add datarevisaorenovacao date;
-- FIM - [joao.morais] - 18/01/2016

-- INCIO - [deborah.ferreira] - 14/01/2016

CREATE TABLE servicoprocessonegocio
(
	idservicoprocessonegocio int NOT NULL,
	idservico bigint NOT NULL,
	idprocessonegocio int NOT NULL,
	PRIMARY KEY (idservicoprocessonegocio),
	FOREIGN KEY (idservico) REFERENCES servico (idservico),
	FOREIGN KEY (idprocessonegocio) REFERENCES processonegocio (idprocessonegocio)
);
-- FIM - [deborah.ferreira] - 14/01/2016

--INCIO - [gilmar.junior] - 19/01/2016
CREATE TABLE servicodononegocio (
	idservicodononegocio bigint not null,
	idservico bigint not null,
	idgrupo int,
	idempregado int,
	tipodononegocio bigint not null,
	primary key(idservicodononegocio)
);
alter table servicodononegocio add CONSTRAINT fk_servico_dononegocio_grupo FOREIGN KEY (idgrupo) REFERENCES grupo (idgrupo);
alter table servicodononegocio add CONSTRAINT fk_servico_dononegocio_servico FOREIGN KEY (idservico) REFERENCES servico (idservico);
alter table servicodononegocio add CONSTRAINT fk_servico_dononegocio_empr FOREIGN KEY (idempregado) REFERENCES empregados (idempregado);
-- FIM - [gilmar.junior] - 19/01/2016

-- INICIO - [gilberto.nery] - 20/01/2016

CREATE TABLE evm_acao_problema (
  idacaoproblema bigint NOT NULL,
  idacao bigint NOT NULL,
  idcontrato int NULL,
  idsolicitante int NULL,
  idorigem bigint NULL,
  idgrupo int NULL,
  nomecontato VARCHAR(100) NULL,
  emailcontato VARCHAR(200) NULL,
  telefonecontato VARCHAR(100) NULL,
  ramalcontato VARCHAR(5) NULL,
  observacao TEXT NULL,
  idunidade int NULL,
  idlocalidade int NULL,
  tituloproblema VARCHAR(255) NULL,
  descricaoproblema TEXT NULL,
  severidadeproblema VARCHAR(15) NULL,
  impactoproblema VARCHAR(10) NULL,
  urgenciaproblema VARCHAR(10) NULL,
  datahoralimitesolucionar DATE NULL,
  prioridade bigint NULL,
  proativoreativo VARCHAR(15) NULL,
  enviaemailcriacao CHAR(1) NULL,
  enviaemailfinalizacao CHAR(1) NULL,
  enviaemailacoes CHAR(1) NULL,
  idcategoriaproblema int NULL,
  idcausa int NULL,
  idcategoriasolucao int NULL,
  fechamento TEXT NULL,
  PRIMARY KEY (idacaoproblema),
  foreign key (idacao) references evm_acao(idacao) on delete cascade,
  foreign key (idcontrato) references contratos(idcontrato) on delete cascade,
  foreign key (idsolicitante) references empregados(idempregado) on delete cascade,
  foreign key (idorigem) references origematendimento(idorigem) on delete cascade,
  foreign key (idgrupo) references grupo (idgrupo) on delete cascade,
  foreign key (idunidade) references unidade (idunidade) on delete cascade,
  foreign key (idlocalidade) references localidade (idlocalidade) on delete cascade,
  foreign key (idcategoriaproblema) references categoriaproblema (idcategoriaproblema) on delete cascade,
  foreign key (idcategoriasolucao) references categoriasolucao (idcategoriasolucao) on delete cascade,
  foreign key (idcausa) references causaincidente (idcausaincidente) on delete cascade
);

CREATE TABLE evm_acao_instancia_problema (
  idacaoinstanciaproblema bigint NOT NULL,
  idacaoinstancia bigint NOT NULL,
  idrequisicaoproblema int NULL,
  PRIMARY KEY (idacaoinstanciaproblema),
  foreign key (idacaoinstancia) references evm_acao_instancia(idacaoinstancia) on delete cascade,
  foreign key (idrequisicaoproblema) references problema(idproblema) on delete cascade
);

CREATE TABLE evm_acaomanualproblema (
  idevmacaomanualproblema bigint NOT NULL,
  idocorrencia VARCHAR(254) not null,
  idrequisicaoproblema int NOT NULL,
  datainicio date not null,
  datafim date,
  PRIMARY KEY (idevmacaomanualproblema),
  foreign key (idrequisicaoproblema) references problema(idproblema) on delete cascade
);

-- FIM - [gilberto.nery] - 20/01/2016

-- INICIO - thyen.chang - 26/01/2016

ALTER TABLE evm_gerenciado_zabbix DROP COLUMN servico;

ALTER TABLE evm_gerenciado_zabbix ADD nometrigger varchar(255);

ALTER TABLE evm_gerenciado_zabbix ADD idtrigger integer;

-- FIM - thyen.chang - 26/01/2016

-- INICIO - rodrigo.acorse - 27/01/2016

ALTER TABLE evm_gerenciado_nagios ALTER COLUMN servico VARCHAR(255);

-- FIM - rodrigo.acorse - 27/01/2016
-- FIM - [joao.morais] - 14/01/2016

-- INCIO [douglas.japiassu] Scripts CARLOS - MOBILE - 11.02.2016
alter table ocorrenciasolicitacao add codigoexterno varchar(100);
alter table rest_execution add platform varchar(255);
alter table rest_execution add uuid varchar(255);
ALTER TABLE ocorrenciasolicitacao ALTER COLUMN descricao VARCHAR(2000);
alter table tabfederacaodados DROP CONSTRAINT tabfederacaodados_pkey;
ALTER TABLE tabfederacaodados ADD CONSTRAINT tabfederacaodados_pkey PRIMARY KEY (nometabela, chavefinal, chaveoriginal, origem);
-- FIM [douglas.japiasssu] Scripts CARLOS - MOBILE - 11.02.2016

-- INICIO - thyen.chang - 06.03.2016

ALTER TABLE empregados ALTER COLUMN cpf VARCHAR(16);

-- FIM - thyen.chang - 06.03.2016

-- INICIO - thyen.chang - 08.03.2016

alter table planomelhoria add datainicio date;

alter table planomelhoria drop column datainicioplano;

alter table acaoplanomelhoria add datainicio date;

alter table acaoplanomelhoria add datafim date;

-- FIM - thyen.chang - 08.03.2016