SET DEFINE OFF;

/*

CREATE USER citsmart_homologacao IDENTIFIED BY citsmart_homologacao DEFAULT TABLESPACE users TEMPORARY TABLESPACE temp;

GRANT CONNECT, RESOURCE, CREATE VIEW, CREATE PUBLIC SYNONYM TO citsmart_homologacao WITH ADMIN OPTION;

GRANT ALTER ANY ROLE, ALTER ANY SEQUENCE, ALTER ANY TABLE, ALTER TABLESPACE,ALTER ANY TRIGGER, COMMENT ANY TABLE, CREATE ANY SEQUENCE, CREATE ANY TABLE,CREATE ANY TRIGGER, CREATE ROLE, CREATE TABLESPACE, CREATE USER, DROP ANY SEQUENCE, DROP ANY TABLE, DROP ANY TRIGGER, DROP TABLESPACE, DROP USER, DROP ANY ROLE, GRANT ANY ROLE, INSERT ANY TABLE, SELECT ANY TABLE, UPDATE ANY TABLE TO citsmart_homologacao;

*/


-- CRIACAO DE TABELAS 
-- SCRIPT DE ORIGEM: 01 - tables_citsmart.sql

CREATE TABLE ACORDONIVELSERVICO (
    IDACORDONIVELSERVICO NUMBER(19, 0) NOT NULL, 
    IDSERVICOCONTRATO NUMBER(19, 0), 
    IDPRIORIDADEPADRAO NUMBER(19, 0), 
    SITUACAO CHAR(1) NOT NULL, 
    TITULOSLA VARCHAR2(500) NOT NULL, 
    DISPONIBILIDADE NUMBER(15, 3), 
    DESCRICAOSLA CLOB, 
    ESCOPOSLA CLOB, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    AVALIAREM DATE, 
    TIPO CHAR(1), 
    DELETED CHAR(1), 
    VALORLIMITE NUMBER(15, 3), 
    DETALHEGLOSA CLOB, 
    DETALHELIMITEGLOSA CLOB, 
    UNIDADEVALORLIMITE VARCHAR2(150), 
    IMPACTO CHAR(1), 
    URGENCIA CHAR(1), 
    PERMITEMUDARIMPURG CHAR(1), 
    IDFORMULA NUMBER(10, 0)
);

CREATE TABLE ACORDONIVELSERVICOCONTRATO (
    IDACORDONIVELSERVICOCONTRATO NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0) NOT NULL, 
    DESCRICAOACORDO VARCHAR2(200) NOT NULL, 
    DETALHAMENTOACORDO CLOB, 
    VALORLIMITE NUMBER(15, 3) NOT NULL, 
    UNIDADEVALORLIMITE VARCHAR2(200), 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    DESCRICAOGLOSA CLOB, 
    DELETED CHAR(1), 
    IDFORMULA NUMBER(10, 0)
);


CREATE TABLE ANEXO (
    IDANEXO NUMBER(10, 0) NOT NULL, 
    IDEXECUCAOATIVIDADE NUMBER(10, 0), 
    NOME VARCHAR2(256) NOT NULL, 
    DESCRICAO CLOB, 
    EXTENSAO VARCHAR2(256) NOT NULL, 
    LINK VARCHAR2(256) NOT NULL, 
    PATH VARCHAR2(256) NOT NULL
);

CREATE TABLE ANEXOBASECONHECIMENTO (
    IDANEXOBASECONHECIMENTO NUMBER(10, 0) NOT NULL, 
    IDBASECONHECIMENTO NUMBER(10, 0), 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    NOME VARCHAR2(256) NOT NULL, 
    LINK VARCHAR2(256) NOT NULL, 
    EXTENSAO VARCHAR2(10) NOT NULL, 
    DESCRICAO VARCHAR2(256) NOT NULL
);

CREATE TABLE ANEXOINCIDENTE (
    IDANEXOINCIDENTE NUMBER(10, 0) NOT NULL, 
    IDINCIDENTE NUMBER(10, 0) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    NOME VARCHAR2(256) NOT NULL, 
    LINK VARCHAR2(256) NOT NULL, 
    EXTENSAO VARCHAR2(10), 
    DESCRICAO VARCHAR2(256) NOT NULL
);

CREATE TABLE ATIVIDADEPERIODICA (
    IDATIVIDADEPERIODICA NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0), 
    IDPROCEDIMENTOTECNICO NUMBER(10, 0), 
    IDGRUPOATVPERIODICA NUMBER(10, 0), 
    TITULOATIVIDADE VARCHAR2(256), 
    DESCRICAO CLOB, 
    DATAINICIO DATE, 
    ORIENTACAOTECNICA CLOB, 
    DATAFIM DATE, 
    CRIADOPOR VARCHAR2(30), 
    DATACRIACAO DATE, 
    ALTERADOPOR VARCHAR2(30), 
    DATAULTALTERACAO DATE, 
    IDSOLICITACAOSERVICO NUMBER(10, 0)
);

CREATE TABLE ATIVIDADES (
    IDATIVIDADE NUMBER(10, 0) NOT NULL, 
    IDETAPA NUMBER(10, 0) NOT NULL, 
    IDTIPOATIVIDADE NUMBER(10, 0) NOT NULL, 
    IDATIVIDADEPROXIMA NUMBER(10, 0), 
    NOMEATIVIDADE VARCHAR2(100) NOT NULL, 
    ORDEM SMALLINT NOT NULL, 
    GRUPOEXECUTOR VARCHAR2(20) 
);


CREATE TABLE ATIVIDADESFLUXOS (
    IDATIVIDADE NUMBER(10, 0) NOT NULL, 
    IDFLUXO NUMBER(10, 0) NOT NULL
);

CREATE TABLE ATIVIDADESOS (
    IDATIVIDADESOS NUMBER(19, 0) NOT NULL, 
    IDOS NUMBER(10, 0) NOT NULL, 
    SEQUENCIA SMALLINT, 
    IDATIVIDADESERVICOCONTRATO NUMBER(19, 0), 
    DESCRICAOATIVIDADE CLOB NOT NULL, 
    OBSATIVIDADE CLOB, 
    CUSTOATIVIDADE NUMBER(18, 3), 
    GLOSAATIVIDADE NUMBER(18, 3), 
    COMPLEXIDADE CHAR(5), 
    DELETED CHAR(1), 
    QTDEEXECUTADA NUMBER(15, 3) 
);

CREATE TABLE ATIVIDADESSERVICOCONTRATO (
    IDATIVIDADESERVICOCONTRATO NUMBER(19, 0) NOT NULL, 
    IDSERVICOCONTRATO NUMBER(19, 0) NOT NULL, 
    DESCRICAOATIVIDADE CLOB NOT NULL, 
    OBSATIVIDADE CLOB, 
    CUSTOATIVIDADE NUMBER(18, 3), 
    COMPLEXIDADE CHAR(5), 
    DELETED CHAR(1)
);


CREATE TABLE AUDITORIA (
    IDAUDITORIA NUMBER(10, 0) NOT NULL, 
    IDITEMCONFIGURACAO NUMBER(10, 0), 
    IDUSUARIO NUMBER(10, 0), 
    DATA DATE NOT NULL, 
    HORA CHAR(4), 
    OCORR CLOB
);

CREATE TABLE AUDITORIAITEMCONFIGURACAO (
    IDAUDITORIA NUMBER(10, 0) NOT NULL, 
    IDITEMCONFIGURACAO NUMBER(10, 0), 
    IDEMPREGADO NUMBER(10, 0), 
    DATA DATE NOT NULL, 
    HORA CHAR(4), 
    OCORR CLOB
);

CREATE TABLE BASECONHECIMENTO (
    IDBASECONHECIMENTO NUMBER(10, 0) NOT NULL, 
    IDPASTA NUMBER(10, 0), 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    TITULO VARCHAR2(256) NOT NULL, 
    CONTEUDO CLOB, 
    STATUS CHAR(1) NOT NULL, 
    IDBASECONHECIMENTOPAI NUMBER(10, 0), 
    DATAEXPIRACAO DATE, 
    VERSAO VARCHAR2(45) NOT NULL
);


CREATE TABLE BASEITEMCONFIGURACAO (
    IDBASEITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    IDTIPOITEMCONFIGURACAO NUMBER(10, 0), 
    NOMEBASEITEMCONFIGURACAO VARCHAR2(256) NOT NULL, 
    EXECUTAVEL VARCHAR2(256) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    TIPOEXECUCAO CHAR(1), 
    COMANDO VARCHAR2(256) 
);

CREATE TABLE BIBLIOTECASEXTERNAS (
    IDBIBLIOTECASEXTERNA NUMBER(19, 0) NOT NULL, 
    NOME VARCHAR2(500) NOT NULL, 
    CAMINHO VARCHAR2(500) NOT NULL
);

CREATE TABLE BOTAOACAOVISAO (
    IDBOTAOACAOVISAO NUMBER(19, 0) NOT NULL, 
    IDVISAO NUMBER(19, 0) NOT NULL, 
    TEXTO VARCHAR2(120) NOT NULL, 
    ACAO CHAR(1) NOT NULL, 
    SCRIPT CLOB, 
    HINT VARCHAR2(120), 
    ICONE VARCHAR2(120), 
    ORDEM SMALLINT
);

CREATE TABLE BPM_ATRIBUICAOFLUXO (
    IDATRIBUICAO NUMBER(19, 0) NOT NULL, 
    IDITEMTRABALHO NUMBER(19, 0) NOT NULL, 
    TIPO VARCHAR2(20), 
    DATAHORA DATE DEFAULT SYSDATE NOT NULL, 
    IDUSUARIO NUMBER(10, 0), 
    IDGRUPO NUMBER(10, 0)
);

CREATE TABLE BPM_ELEMENTOFLUXO (
    IDELEMENTO NUMBER(19, 0) NOT NULL, 
    IDFLUXO NUMBER(19, 0) NOT NULL, 
    TIPOELEMENTO VARCHAR2(20) NOT NULL, 
    SUBTIPO VARCHAR2(20), 
    NOME VARCHAR2(50), 
    DOCUMENTACAO CLOB, 
    TIPOINTERACAO CHAR(1), 
    URL VARCHAR2(150), 
    VISAO VARCHAR2(150), 
    GRUPOS CLOB, 
    USUARIOS CLOB, 
    ACAOENTRADA CLOB, 
    ACAOSAIDA CLOB, 
    SCRIPT CLOB, 
    TEXTOEMAIL CLOB, 
    NOMEFLUXOENCADEADO VARCHAR2(100), 
    POSX DOUBLE PRECISION, 
    POSY DOUBLE PRECISION, 
    ALTURA DOUBLE PRECISION, 
    LARGURA DOUBLE PRECISION, 
    MODELOEMAIL VARCHAR2(20) 
);

CREATE TABLE BPM_FLUXO (
    IDFLUXO NUMBER(19, 0) NOT NULL, 
    VERSAO VARCHAR2(10) NOT NULL, 
    IDTIPOFLUXO NUMBER(10, 0), 
    VARIAVEIS CLOB, 
    CONTEUDOXML CLOB, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE BPM_HISTORICOITEMTRABALHO (
    IDHISTORICOITEMTRABALHO NUMBER(19, 0) NOT NULL, 
    IDITEMTRABALHO NUMBER(19, 0) NOT NULL, 
    IDRESPONSAVEL NUMBER(10, 0), 
    IDUSUARIO NUMBER(10, 0), 
    IDGRUPO NUMBER(10, 0), 
    DATAHORA DATE DEFAULT SYSDATE NOT NULL, 
    ACAO VARCHAR2(10) NOT NULL
);

CREATE TABLE BPM_INSTANCIAFLUXO (
    IDINSTANCIA NUMBER(19, 0) NOT NULL, 
    IDFLUXO NUMBER(19, 0) NOT NULL, 
    DATAHORACRIACAO DATE DEFAULT SYSDATE NOT NULL, 
    SITUACAO VARCHAR2(20), 
    DATAHORAFINALIZACAO DATE
);

CREATE TABLE BPM_ITEMTRABALHOFLUXO (
    IDITEMTRABALHO NUMBER(19, 0) NOT NULL, 
    IDINSTANCIA NUMBER(19, 0) NOT NULL, 
    IDELEMENTO NUMBER(19, 0) NOT NULL, 
    IDRESPONSAVELATUAL NUMBER(10, 0), 
    DATAHORACRIACAO DATE DEFAULT SYSDATE NOT NULL, 
    DATAHORAINICIO DATE, 
    SITUACAO CHAR(20) NOT NULL, 
    DATAHORAFINALIZACAO DATE
);

CREATE TABLE BPM_OBJETOINSTANCIAFLUXO (
    IDOBJETOINSTANCIA NUMBER(19, 0) NOT NULL, 
    IDITEMTRABALHO NUMBER(19, 0), 
    IDINSTANCIA NUMBER(19, 0) NOT NULL, 
    IDOBJETONEGOCIO NUMBER(19, 0), 
    NOMEOBJETO VARCHAR2(100), 
    NOMECLASSE VARCHAR2(100), 
    TIPOASSOCIACAO CHAR(1) NOT NULL, 
    CAMPOCHAVE CHAR(1) NOT NULL, 
    OBJETOPRINCIPAL CHAR(1) NOT NULL, 
    NOMETABELABD VARCHAR2(120), 
    NOMECAMPOBD VARCHAR2(100), 
    TIPOCAMPOBD VARCHAR2(20), 
    VALOR CLOB
);

CREATE TABLE BPM_SEQUENCIAFLUXO (
    IDELEMENTOORIGEM NUMBER(19, 0) NOT NULL, 
    IDELEMENTODESTINO NUMBER(19, 0) NOT NULL, 
    IDFLUXO NUMBER(19, 0) NOT NULL, 
    NOMECLASSEORIGEM VARCHAR2(100), 
    NOMECLASSEDESTINO VARCHAR2(100), 
    CONDICAO CLOB, 
    IDCONEXAOORIGEM SMALLINT, 
    IDCONEXAODESTINO SMALLINT, 
    BORDAX DOUBLE PRECISION, 
    BORDAY DOUBLE PRECISION, 
    POSICAOALTERADA CHAR(1), 
    NOME VARCHAR2(100) 
);

CREATE TABLE BPM_TIPOFLUXO (
    IDTIPOFLUXO NUMBER(10, 0) NOT NULL, 
    NOMEFLUXO VARCHAR2(70) NOT NULL, 
    DESCRICAO CLOB
);

CREATE TABLE CALENDARIO (
    IDCALENDARIO NUMBER(10, 0) NOT NULL, 
    DESCRICAO VARCHAR2(70), 
    CONSIDERAFERIADOS CHAR(1), 
    IDJORNADASEG NUMBER(10, 0), 
    IDJORNADATER NUMBER(10, 0), 
    IDJORNADAQUA NUMBER(10, 0), 
    IDJORNADAQUI NUMBER(10, 0), 
    IDJORNADASEX NUMBER(10, 0), 
    IDJORNADASAB NUMBER(10, 0), 
    IDJORNADADOM NUMBER(10, 0)
);

CREATE TABLE CAMPOOBJRELACIONADO (
    IDCAMPOOBJRELACIONADO NUMBER(19, 0) NOT NULL, 
    IDRELACOBJETONEGOCIO NUMBER(19, 0) NOT NULL, 
    IDCAMPOSOBJETONEGOCIOPAI NUMBER(19, 0) NOT NULL, 
    IDCAMPOSOBJETONEGOCIOFILHO NUMBER(19, 0) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL
);

CREATE TABLE CAMPOSOBJETONEGOCIO (
    IDCAMPOSOBJETONEGOCIO NUMBER(19, 0) NOT NULL, 
    IDOBJETONEGOCIO NUMBER(19, 0) NOT NULL, 
    NOME VARCHAR2(100) NOT NULL, 
    NOMEDB VARCHAR2(100) NOT NULL, 
    PK CHAR(1) NOT NULL, 
    SEQUENCE CHAR(1) NOT NULL, 
    UNICO CHAR(1) NOT NULL, 
    TIPODB CHAR(20) NOT NULL, 
    OBRIGATORIO CHAR(1) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL
);

CREATE TABLE CARACTERISTICA (
    IDCARACTERISTICA NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOMECARACTERISTICA VARCHAR2(255) NOT NULL, 
    TAGCARACTERISTICA VARCHAR2(255), 
    DESCRICAO VARCHAR2(4000), 
    TIPO CHAR(2) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    SISTEMA NUMBER(10, 0) NOT NULL
);

CREATE TABLE CARGOS (
    IDCARGO NUMBER(10, 0) NOT NULL, 
    NOMECARGO VARCHAR2(256) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE CATEGORIAGALERIAIMAGEM (
    IDCATEGORIAGALERIAIMAGEM NUMBER(10, 0) NOT NULL, 
    NOMECATEGORIA VARCHAR2(70) NOT NULL
);

CREATE TABLE CATEGORIAPROBLEMA (
    IDCATEGORIAPROBLEMA NUMBER(10, 0) NOT NULL, 
    CAT_IDCATEGORIAPROBLEMA NUMBER(10, 0), 
    IDCATEGORIAPROBLEMAPAI NUMBER(10, 0) NOT NULL, 
    NOMECATEGORIA NUMBER(10, 0) NOT NULL
);

CREATE TABLE CATEGORIAQUESTIONARIO (
    IDCATEGORIAQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    NOMECATEGORIAQUESTIONARIO VARCHAR2(50) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    COMPARTILHADA CHAR(1) DEFAULT 'N'
);

CREATE TABLE CATEGORIASERVICO (
    IDCATEGORIASERVICO NUMBER(10, 0) NOT NULL, 
    IDCATEGORIASERVICOPAI NUMBER(10, 0), 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOMECATEGORIASERVICO VARCHAR2(100) NOT NULL, 
    DATAINICIO DATE DEFAULT TO_DATE('2012-04-02',  'YYYY-MM-DD'), 
    DATAFIM DATE, 
    NMCATEGSERVICOCONCAT VARCHAR2(1024) 
);

CREATE TABLE CATEGORIASOLUCAO (
    IDCATEGORIASOLUCAO NUMBER(10, 0) NOT NULL, 
    IDCATEGORIASOLUCAOPAI NUMBER(10, 0), 
    DESCRICAOCATEGORIASOLUCAO VARCHAR2(100) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    DELETED CHAR(1)
);

CREATE TABLE CAUSAINCIDENTE (
    IDCAUSAINCIDENTE NUMBER(10, 0) NOT NULL, 
    IDCAUSAINCIDENTEPAI NUMBER(10, 0), 
    DESCRICAOCAUSA VARCHAR2(100) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    DELETED CHAR(1)
);

CREATE TABLE CIDADES (
    IDCIDADE NUMBER(10, 0) NOT NULL, 
    NOMECIDADE VARCHAR2(45) NOT NULL, 
    IDUF NUMBER(10, 0) NOT NULL
);

CREATE TABLE CLIENTES (
    IDCLIENTE NUMBER(10, 0) NOT NULL, 
    NOMERAZAOSOCIAL VARCHAR2(70) NOT NULL, 
    NOMEFANTASIA VARCHAR2(70), 
    CPFCNPJ VARCHAR2(14), 
    OBSERVACOES CLOB, 
    SITUACAO CHAR(1) NOT NULL, 
    DELETED CHAR(1)
);

CREATE TABLE COLECAO (
    IDCOLECAO NUMBER(10, 0) NOT NULL, 
    NOME VARCHAR2(256), 
    IDTESTE NUMBER(10, 0)
);

CREATE TABLE COMANDO (
    ID NUMBER(10, 0) NOT NULL, 
    DESCRICAO VARCHAR2(400) NOT NULL
);

CREATE TABLE COMANDOSISTEMAOPERACIONAL (
    ID NUMBER(10, 0) NOT NULL, 
    IDCOMANDO NUMBER(10, 0) NOT NULL, 
    IDSISTEMAOPERACIONAL NUMBER(10, 0) NOT NULL, 
    COMANDO VARCHAR2(255) NOT NULL, 
    SISTEMAOPERACIONAL VARCHAR2(255), 
    COMANDOSISTEMAOPERACIONAL VARCHAR2(255) 
);

CREATE TABLE COMENTARIOS (
    IDCOMENTARIO NUMBER(10, 0) NOT NULL, 
    IDBASECONHECIMENTO NUMBER(10, 0) NOT NULL, 
    COMENTARIO CLOB NOT NULL, 
    NOME VARCHAR2(255) NOT NULL, 
    NOTA VARCHAR2(45) NOT NULL, 
    EMAIL VARCHAR2(70) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE CONDICAOOPERACAO (
    IDCONDICAOOPERACAO NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOMECONDICAOOPERACAO VARCHAR2(150) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE CONTATOCLIENTE (
    IDCONTATOCLIENTE NUMBER(10, 0) NOT NULL, 
    IDCLIENTE NUMBER(10, 0) NOT NULL, 
    NOME VARCHAR2(80) NOT NULL, 
    TELEFONES VARCHAR2(100), 
    EMAIL VARCHAR2(255), 
    DEPARTAMENTO VARCHAR2(100), 
    OBSERVACOES CLOB, 
    DATAINICIO DATE, 
    DATAFIM DATE
);

CREATE TABLE CONTATOSOLICITACAOSERVICO (
    IDCONTATOSOLICITACAOSERVICO NUMBER(10, 0) NOT NULL, 
    NOMECONTATO VARCHAR2(70) NOT NULL, 
    TELEFONECONTATO VARCHAR2(70) NOT NULL, 
    EMAILCONTATO VARCHAR2(120) NOT NULL, 
    LOCALIZACAOFISICA CLOB NOT NULL
);

CREATE TABLE CONTRATOQUESTIONARIOS (
    IDCONTRATOQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    IDQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0) NOT NULL, 
    DATAQUESTIONARIO DATE NOT NULL, 
    IDPROFISSIONAL NUMBER(10, 0), 
    IDEMPRESA NUMBER(10, 0), 
    ABA VARCHAR2(30), 
    SITUACAO CHAR(1), 
    SITUACAOCOMPLEMENTO CHAR(1), 
    DATAHORAGRAV DATE, 
    MIGRADO CHAR(1), 
    CONTEUDOIMPRESSO CLOB, 
    IDMIGRACAO NUMBER(10, 0)
);

CREATE TABLE CONTRATOS (
    IDCONTRATO NUMBER(10, 0) NOT NULL, 
    IDCLIENTE NUMBER(10, 0) NOT NULL, 
    IDMOEDA NUMBER(10, 0), 
    IDFORNECEDOR NUMBER(19, 0) NOT NULL, 
    NUMERO VARCHAR2(30) NOT NULL, 
    OBJETO CLOB NOT NULL, 
    DATACONTRATO DATE NOT NULL, 
    VALORESTIMADO NUMBER(18, 3), 
    TIPOTEMPOESTIMADO CHAR(1), 
    TEMPOESTIMADO NUMBER(10, 0), 
    TIPO CHAR(1) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    COTACAOMOEDA NUMBER(18, 3), 
    CADASTROMANUALUSUARIO CHAR(1), 
    DELETED CHAR(1)
);

CREATE TABLE CONTRATOSCOLABORADORES (
    IDEMPREGADO NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0) NOT NULL
);

CREATE TABLE CONTRATOSGRUPOS (
    IDGRUPO NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0) NOT NULL
);

CREATE TABLE CONTROLEGED (
    IDCONTROLEGED NUMBER(10, 0) NOT NULL, 
    IDTABELA SMALLINT NOT NULL, 
    ID NUMBER(10, 0) NOT NULL, 
    NOMEARQUIVO VARCHAR2(255) NOT NULL, 
    DESCRICAOARQUIVO VARCHAR2(255), 
    EXTENSAOARQUIVO VARCHAR2(5), 
    DATAHORA DATE DEFAULT SYSDATE NOT NULL, 
    PASTA VARCHAR2(255), 
    CONTEUDOARQUIVO CLOB
);

CREATE TABLE CONTROLEQUESTIONARIOS (
    IDCONTROLEQUESTIONARIO NUMBER(10, 0) NOT NULL
);

CREATE TABLE DEMANDAS (
    IDDEMANDA NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0), 
    IDSITUACAODEMANDA NUMBER(10, 0) NOT NULL, 
    IDTIPODEMANDA NUMBER(10, 0) NOT NULL, 
    IDPROJETO NUMBER(10, 0), 
    IDDEMANDAPAI NUMBER(10, 0), 
    IDFLUXO NUMBER(10, 0) NOT NULL, 
    PREVISAOINICIO DATE, 
    DATAINICIO DATE, 
    PREVISAOFIM DATE, 
    DATAFIM DATE, 
    DETALHAMENTO CLOB, 
    PRIORIDADE CHAR(1) NOT NULL, 
    EXPECTATIVAFIM DATE, 
    DATACADASTRO DATE, 
    COMPLEXIDADE NUMBER(10, 0), 
    CUSTOTOTAL NUMBER(18, 3), 
    OBSERVACAO CLOB, 
    IDOS NUMBER(10, 0), 
    GLOSA NUMBER(15, 3) 
);

CREATE TABLE EMAILSOLICITACAOSERVICO (
    MESSAGEID VARCHAR2(500) NOT NULL, 
    SITUACAO VARCHAR2(25) NOT NULL, 
    IDEMAILSOLICITACAOSERVICO NUMBER(10, 0) NOT NULL
);

CREATE TABLE EMPREGADOITEMCONFIGURACAO (
    IDUSUARIO NUMBER(10, 0) NOT NULL, 
    IDITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    IDEMPREGADO NUMBER(10, 0), 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE EMPREGADOS (
    IDEMPREGADO NUMBER(10, 0) NOT NULL, 
    NOME VARCHAR2(80) NOT NULL, 
    NOMEPROCURA VARCHAR2(80), 
    DATANASCIMENTO DATE, 
    SEXO CHAR(1), 
    CPF VARCHAR2(14), 
    RG VARCHAR2(15), 
    DATAEMISSAORG DATE, 
    IDTIPOSANGUE NUMBER(10, 0) DEFAULT 0, 
    ORGEXPEDIDOR VARCHAR2(15), 
    IDUFORGEXPEDIDOR NUMBER(10, 0), 
    PAI VARCHAR2(50), 
    MAE VARCHAR2(50), 
    CONJUGE VARCHAR2(50), 
    OBSERVACOES CLOB, 
    ESTADOCIVIL SMALLINT, 
    EMAIL VARCHAR2(200), 
    DATACADASTRO DATE, 
    FUMANTE CHAR(1) DEFAULT 'N', 
    CTPSNUMERO VARCHAR2(15), 
    CTPSSERIE VARCHAR2(10), 
    CTPSIDUF NUMBER(10, 0), 
    CTPSDATAEMISSAO DATE, 
    NIT VARCHAR2(20), 
    DATAADMISSAO DATE, 
    DATADEMISSAO DATE, 
    TIPO CHAR(1), 
    IDSITUACAOFUNCIONAL NUMBER(10, 0) NOT NULL, 
    CUSTOPORHORA DOUBLE PRECISION, 
    CUSTOTOTALMES DOUBLE PRECISION, 
    VALORSALARIO DOUBLE PRECISION, 
    VALORPRODUTIVIDADEMEDIA DOUBLE PRECISION, 
    VALORPLANOSAUDEMEDIA DOUBLE PRECISION, 
    VALORVTRAMEDIA DOUBLE PRECISION, 
    VALORVREFMEDIA DOUBLE PRECISION, 
    AGENCIA VARCHAR2(10), 
    CONTASALARIO VARCHAR2(20), 
    IDUNIDADE NUMBER(10, 0), 
    DATAFIM DATE, 
    TELEFONE VARCHAR2(45), 
    IDCARGO NUMBER(10, 0), 
    VINCULAACONTRATOS CHAR(1)
);

CREATE TABLE EMPRESA (
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOMEEMPRESA VARCHAR2(150) NOT NULL, 
    DETALHAMENTO CLOB, 
    DATAINICIO DATE DEFAULT TO_DATE('2012-04-02',  'YYYY-MM-DD'), 
    DATAFIM DATE
);

CREATE TABLE ETAPAS (
    IDETAPA NUMBER(10, 0) NOT NULL, 
    IDFLUXO NUMBER(10, 0) NOT NULL, 
    IDETAPAPAI NUMBER(10, 0), 
    NOMEETAPA VARCHAR2(70) NOT NULL, 
    ORDEM SMALLINT NOT NULL
);

CREATE TABLE EVENTO (
    IDEVENTO NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    DESCRICAO VARCHAR2(255) NOT NULL, 
    LIGARCASODESL CHAR(1) NOT NULL, 
    DATAINICIO DATE, 
    DATAFIM DATE, 
    USUARIO VARCHAR2(256), 
    SENHA VARCHAR2(256) 
);


CREATE TABLE EVENTOEMPREGADO (
    IDEVENTO NUMBER(10, 0) NOT NULL, 
    IDEMPREGADO NUMBER(10, 0) NOT NULL, 
    IDGRUPO NUMBER(10, 0), 
    IDUNIDADE NUMBER(10, 0), 
    IDITEMCONFIGURACAOPAI NUMBER(10, 0)
);

CREATE TABLE EVENTOGRUPO (
    IDEVENTO NUMBER(10, 0), 
    IDGRUPO NUMBER(10, 0)
);

CREATE TABLE EVENTOUNIDADE (
    IDUNIDADE NUMBER(10, 0), 
    IDEVENTO NUMBER(10, 0)
);

CREATE TABLE EXCECAOCALENDARIO (
    IDEXCECAOCALENDARIO NUMBER(10, 0) NOT NULL, 
    IDCALENDARIO NUMBER(10, 0) NOT NULL, 
    IDJORNADA NUMBER(10, 0), 
    TIPO CHAR(1) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATATERMINO DATE NOT NULL
);

CREATE TABLE EXCECAOEMPREGADO (
    IDEVENTO NUMBER(10, 0) NOT NULL, 
    IDEMPREGADO NUMBER(10, 0) NOT NULL, 
    IDGRUPO NUMBER(10, 0), 
    IDUNIDADE NUMBER(10, 0)
);

CREATE TABLE EXECUCAOATIVIDADEPERIODICA (
    IDEXECUCAOATIVIDADEPERIODICA NUMBER(10, 0) NOT NULL, 
    IDATIVIDADEPERIODICA NUMBER(10, 0) NOT NULL, 
    DATAPROGRAMADA DATE NOT NULL, 
    HORAPROGRAMADA CHAR(5), 
    SITUACAO CHAR(1) NOT NULL, 
    DETALHAMENTO CLOB, 
    USUARIO CHAR(1), 
    IDEMPREGADO NUMBER(10, 0), 
    DATAEXECUCAO DATE, 
    HORAEXECUCAO CHAR(5), 
    DATAREGISTRO DATE, 
    HORAREGISTRO CHAR(5), 
    IDPROGRAMACAOATIVIDADE NUMBER(10, 0), 
    IDMOTIVOSUSPENSAO NUMBER(10, 0), 
    COMPLEMENTOMOTIVOSUSPENSAO CLOB
);

CREATE TABLE EXECUCAOBATCH (
    IDEXECUCAOBATCH NUMBER(10, 0) NOT NULL, 
    IDPROCESSAMENTOBATCH NUMBER(10, 0) NOT NULL, 
    CONTEUDO CLOB NOT NULL, 
    DATAHORA DATE DEFAULT SYSDATE NOT NULL
);

CREATE TABLE EXECUCAODEMANDA (
    IDEXECUCAO NUMBER(10, 0) NOT NULL, 
    IDDEMANDA NUMBER(10, 0) NOT NULL, 
    IDATIVIDADE NUMBER(10, 0) NOT NULL, 
    IDEMPREGADOEXECUTOR NUMBER(10, 0), 
    IDEMPREGADORECEPTOR NUMBER(10, 0), 
    RELATO CLOB, 
    QTDEHORAS NUMBER(18, 3), 
    SITUACAO CHAR(1) NOT NULL, 
    GRUPOEXECUTOR VARCHAR2(20), 
    TERMINOPREVISTO DATE, 
    TERMINOREAL DATE
);

CREATE TABLE EXECUCAOSOLICITACAO (
    IDEXECUCAO NUMBER(19, 0) NOT NULL, 
    IDSOLICITACAOSERVICO NUMBER(19, 0), 
    IDFASE NUMBER(19, 0), 
    IDINSTANCIAFLUXO NUMBER(19, 0), 
    IDFLUXO NUMBER(19, 0), 
    PRAZOHH SMALLINT, 
    PRAZOMM SMALLINT, 
    SEQREABERTURA NUMBER(10, 0)
);

CREATE TABLE FASESERVICO (
    IDFASE NUMBER(19, 0) NOT NULL, 
    NOMEFASE VARCHAR2(70) NOT NULL, 
    FASECAPTURA CHAR(1) NOT NULL
);

CREATE TABLE FATURA (
    IDFATURA NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0) NOT NULL, 
    DATAINICIAL DATE NOT NULL, 
    DATAFINAL DATE NOT NULL, 
    DESCRICAOFATURA VARCHAR2(150), 
    VALORCOTACAOMOEDA NUMBER(15, 3) NOT NULL, 
    DATACRIACAO DATE NOT NULL, 
    DATAULTMODIFICACAO DATE NOT NULL, 
    VALORPREVISTOSOMAOS NUMBER(15, 3), 
    VALORSOMAGLOSASOS NUMBER(15, 3), 
    VALOREXECUTADOSOMAOS NUMBER(15, 3), 
    OBSERVACAO CLOB, 
    APROVACAOGESTOR CLOB, 
    APROVACAOFISCAL CLOB, 
    SALDOPREVISTO NUMBER(15, 3), 
    SITUACAOFATURA CHAR(1) NOT NULL
);

CREATE TABLE FATURAAPURACAOANS (
    IDFATURAAPURACAOANS NUMBER(10, 0) NOT NULL, 
    IDFATURA NUMBER(10, 0) NOT NULL, 
    IDACORDONIVELSERVICOCONTRATO NUMBER(10, 0) NOT NULL, 
    VALORAPURADO NUMBER(15, 3), 
    DETALHAMENTO CLOB, 
    PERCENTUALGLOSA NUMBER(15, 3), 
    VALORGLOSA NUMBER(15, 3), 
    DATAAPURACAO DATE
);

CREATE TABLE FATURAOS (
    IDFATURA NUMBER(10, 0) NOT NULL, 
    IDOS NUMBER(10, 0) NOT NULL
);

CREATE TABLE FERIADO (
    IDFERIADO NUMBER(10, 0) NOT NULL, 
    DATA DATE NOT NULL, 
    DESCRICAO VARCHAR2(100), 
    ABRANGENCIA CHAR(1), 
    IDUF NUMBER(10, 0), 
    IDCIDADE NUMBER(10, 0), 
    RECORRENTE CHAR(1)
);

CREATE TABLE FLUXO (
    IDFLUXO NUMBER(10, 0) NOT NULL, 
    NOMEFLUXO VARCHAR2(70) NOT NULL, 
    DESCRICAO CLOB
);

CREATE TABLE FLUXOS (
    IDFLUXO NUMBER(10, 0) NOT NULL, 
    NOMEFLUXO VARCHAR2(70) NOT NULL
);

CREATE TABLE FLUXOSERVICO (
    IDSERVICOCONTRATO NUMBER(19, 0) NOT NULL, 
    IDTIPOFLUXO NUMBER(10, 0) NOT NULL, 
    IDFASE NUMBER(19, 0) NOT NULL, 
    PRINCIPAL CHAR(1) DEFAULT 'N' NOT NULL, 
    DELETED CHAR(1)
);

CREATE TABLE FORMULA (
    IDFORMULA NUMBER(10, 0) NOT NULL, 
    IDENTIFICADOR VARCHAR2(120) NOT NULL, 
    NOME VARCHAR2(120) NOT NULL, 
    CONTEUDO CLOB, 
    DATACRIACAO DATE
);

CREATE TABLE FORNECEDOR (
    IDFORNECEDOR NUMBER(19, 0) NOT NULL, 
    RAZAOSOCIAL VARCHAR2(100) NOT NULL, 
    NOMEFANTASIA VARCHAR2(70), 
    CNPJ VARCHAR2(14), 
    EMAIL VARCHAR2(255), 
    OBSERVACAO CLOB, 
    DELETED CHAR(1)
);

CREATE TABLE GALERIAIMAGENS (
    IDIMAGEM NUMBER(10, 0) NOT NULL, 
    IDCATEGORIAGALERIAIMAGEM NUMBER(10, 0) NOT NULL, 
    NOMEIMAGEM VARCHAR2(255) NOT NULL, 
    DESCRICAOIMAGEM VARCHAR2(70), 
    DETALHAMENTO CLOB, 
    EXTENSAO VARCHAR2(15) 
);

CREATE TABLE GLOSAOS (
    IDGLOSAOS NUMBER(10, 0) NOT NULL, 
    IDOS NUMBER(10, 0) NOT NULL, 
    DATACRIACAO DATE NOT NULL, 
    DATAULTMODIFICACAO DATE NOT NULL, 
    DESCRICAOGLOSA CLOB NOT NULL, 
    OCORRENCIAS CLOB, 
    PERCAPLICADO NUMBER(15, 3) NOT NULL, 
    CUSTOGLOSA NUMBER(15, 3) NOT NULL, 
    NUMEROOCORRENCIAS NUMBER(15, 3), 
    IDACORDONIVELSERVICO NUMBER(10, 0)
);

CREATE TABLE GRUPO (
    IDGRUPO NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOME VARCHAR2(255) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    DESCRICAO CLOB, 
    SERVICEDESK CHAR(1), 
    SIGLA VARCHAR2(20) 
);

CREATE TABLE GRUPOATVPERIODICA (
    IDGRUPOATVPERIODICA NUMBER(10, 0) NOT NULL, 
    NOMEGRUPOATVPERIODICA VARCHAR2(256) NOT NULL, 
    DESCGRUPOATVPERIODICA CLOB, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    DELETED CHAR(1)
);

CREATE TABLE GRUPOQUESTIONARIO (
    IDGRUPOQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    IDQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    NOMEGRUPOQUESTIONARIO VARCHAR2(80) NOT NULL, 
    ORDEM SMALLINT
);

CREATE TABLE GRUPOSEMPREGADOS (
    IDGRUPO NUMBER(10, 0) NOT NULL, 
    IDEMPREGADO NUMBER(10, 0) NOT NULL
);

CREATE TABLE GRUPOVISAO (
    IDGRUPOVISAO NUMBER(19, 0) NOT NULL, 
    IDVISAO NUMBER(19, 0) NOT NULL, 
    DESCRICAOGRUPOVISAO VARCHAR2(500) NOT NULL, 
    FORMA CHAR(1) NOT NULL, 
    ORDEM NUMBER(10, 0) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL
);

CREATE TABLE GRUPOVISAOCAMPOSNEGOCIO (
    IDGRUPOVISAO NUMBER(19, 0) NOT NULL, 
    IDCAMPOSOBJETONEGOCIO NUMBER(19, 0) NOT NULL, 
    DESCRICAONEGOCIO VARCHAR2(500) NOT NULL, 
    TIPONEGOCIO VARCHAR2(20) NOT NULL, 
    ORDEM NUMBER(10, 0) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    OBRIGATORIO CHAR(1) NOT NULL, 
    TAMANHO SMALLINT NOT NULL, 
    DECIMAIS SMALLINT NOT NULL, 
    TIPOLIGACAO CHAR(1), 
    TEXTOSQL CLOB, 
    TAMANHOPARAPESQ SMALLINT, 
    FORMULA CLOB, 
    VISIVEL CHAR(1) NOT NULL, 
    HTMLCODE CLOB
);

CREATE TABLE GRUPOVISAOCAMPOSNEGOCIOINFOSQL (
    IDGRPVISCAMPOSNEGINFOSQL NUMBER(19, 0) NOT NULL, 
    IDGRUPOVISAO NUMBER(19, 0) NOT NULL, 
    IDCAMPOSOBJETONEGOCIO NUMBER(19, 0) NOT NULL, 
    CAMPO VARCHAR2(150) NOT NULL, 
    TIPOLIGACAO CHAR(1) NOT NULL, 
    FILTRO CLOB, 
    DESCRICAO VARCHAR2(400) 
);

CREATE TABLE GRUPOVISAOCAMPOSNEGOCIOLIGACAO (
    IDGRPVISCAMPOSNEGLIGACA  NUMBER(19, 0) NOT NULL, 
    IDGRUPOVISAO NUMBER(19, 0) NOT NULL, 
    IDCAMPOSOBJETONEGOCIO NUMBER(19, 0) NOT NULL, 
    IDCAMPOSOBJETONEGOCIOLIGACAO NUMBER(19, 0), 
    TIPOLIGACAO CHAR(1) NOT NULL, 
    FILTRO CLOB, 
    DESCRICAO VARCHAR2(400) 
);

CREATE TABLE HILOSEQUENCES (
    SEQUENCENAME VARCHAR2(50) NOT NULL, 
    HIGHVALUES NUMBER(10, 0) NOT NULL
);

CREATE TABLE HISTORICOEXECUCAO (
    IDHISTORICO NUMBER(10, 0) NOT NULL, 
    IDEXECUCAO NUMBER(10, 0) NOT NULL, 
    DATA DATE NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    IDEMPREGADOEXECUTOR NUMBER(10, 0) NOT NULL, 
    DETALHAMENTO CLOB, 
    HORA NUMBER(10, 0)
);

CREATE TABLE HISTORICOTENTATIVA (
    IDHISTORICOTENTATIVA NUMBER(10, 0) NOT NULL, 
    IDITEMCONFIGURACAO NUMBER(10, 0), 
    IDBASEITEMCONFIGURACAO NUMBER(10, 0), 
    IDEVENTO NUMBER(10, 0), 
    IDEMPREGADO NUMBER(10, 0), 
    DESCRICAO VARCHAR2(255), 
    DATA DATE, 
    HORA CHAR(4)
);

CREATE TABLE HTMLCODEVISAO (
    IDHTMLCODEVISAO NUMBER(19, 0) NOT NULL, 
    IDVISAO NUMBER(19, 0) NOT NULL, 
    HTMLCODETYPE CHAR(30) NOT NULL, 
    HTMLCODE CLOB NOT NULL
);

CREATE TABLE IMAGEMHISTORICO (
    IDIMAGEM NUMBER(10, 0) NOT NULL, 
    DATA DATE NOT NULL, 
    NOMEARQUIVO VARCHAR2(255) NOT NULL, 
    OBSERVACAO CLOB, 
    IDCONTRATO NUMBER(10, 0) NOT NULL, 
    IDPROFISSIONAL NUMBER(10, 0), 
    IDEMPRESA NUMBER(10, 0), 
    ABA VARCHAR2(30) 
);

CREATE TABLE IMAGEMITEMCONFIGURACAO (
    IDIMAGEMITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    IDSERVICO NUMBER(10, 0), 
    IDITEMCONFIGURACAO NUMBER(10, 0), 
    POSX NUMBER(10, 0), 
    POSY NUMBER(10, 0), 
    DESCRICAO VARCHAR2(256), 
    CAMINHOIMAGEM VARCHAR2(256), 
    IDIMAGEMITEMCONFIGURACAOPAI NUMBER(10, 0)
);

CREATE TABLE IMPORTANCIANEGOCIO (
    IDIMPORTANCIANEGOCIO NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOMEIMPORTANCIANEGOCIO VARCHAR2(100) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL
);

CREATE TABLE INFORMACAOSERVICO (
    IDINFORMACAOSERVICO NUMBER(19, 0) NOT NULL, 
    IDSERVICO NUMBER(19, 0) NOT NULL, 
    USUARIO VARCHAR2(255), 
    TITULO VARCHAR2(255), 
    TEXTO VARCHAR2(255), 
    SITUACAO VARCHAR2(255), 
    DELETED VARCHAR2(255) 
);

CREATE TABLE INFORMACOESCONTRATOCONFIG (
    IDINFORMACOESCONTRATOCONFIG NUMBER(10, 0) NOT NULL, 
    IDINFORMACOESCONTRATOCONFIGPAI NUMBER(10, 0), 
    NOME VARCHAR2(50) NOT NULL, 
    DESCRICAO VARCHAR2(70) NOT NULL, 
    FUNCIONALIDADEPATH VARCHAR2(255), 
    FUNCITEM CHAR(1) NOT NULL, 
    IDQUESTIONARIO NUMBER(10, 0), 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    ORDEM SMALLINT, 
    INFOADICIONAL CLOB, 
    FUNCADICIONALAPOSGRAVACAO VARCHAR2(255), 
    CHAMARFUNCADDAPOSGRAVAR CHAR(1), 
    CHAMARFUNCADDHISTORICO CHAR(1), 
    ICONEFUNCHISTORICO VARCHAR2(255), 
    ICONEFUNCHISTORICOFINAL VARCHAR2(255), 
    VALIDACOES CLOB, 
    SEGURANCAUNIDADE CHAR(1), 
    SEGURANCAUNIDADEPCMSO CHAR(1), 
    SEGURANCAUNIDADEENFERM CHAR(1)
);

CREATE TABLE INFORMACOESCONTRATOPERFSEG (
    IDINFORMACOESCONTRATOCONFIG NUMBER(10, 0) NOT NULL, 
    IDPERFILSEGURANCA NUMBER(10, 0) NOT NULL
);

CREATE TABLE INVENTARIOXML (
    IDINVENTARIOXML NUMBER(10, 0) NOT NULL, 
    CONTEUDO CLOB, 
    IDNETMAP NUMBER(10, 0), 
    DATAINICIAL DATE, 
    DATAFINAL DATE, 
    NOME VARCHAR2(256) 
);

CREATE TABLE ITEMCONFIGURACAO (
    IDITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    IDENTIFICACAO VARCHAR2(400) NOT NULL, 
    IDUNIDADE NUMBER(10, 0), 
    IDITEMCONFIGURACAOPAI NUMBER(10, 0), 
    IDTIPOITEMCONFIGURACAO NUMBER(10, 0), 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    SISTEMA NUMBER(10, 0), 
    IDUSUARIO NUMBER(10, 0)
);

CREATE TABLE ITEMCONFIGURACAOEVENTO (
    IDITEMCONFIGURACAOEVENTO NUMBER(10, 0) NOT NULL, 
    IDBASEITEMCONFIGURACAO NUMBER(10, 0), 
    IDITEMCONFIGURACAO NUMBER(10, 0), 
    IDEVENTO NUMBER(10, 0) NOT NULL, 
    TIPOEXECUCAO CHAR(1), 
    GERARQUANDO CHAR(1) NOT NULL, 
    DATA DATE NOT NULL, 
    HORA CHAR(4), 
    LINHACOMANDO VARCHAR2(255) 
);

CREATE TABLE JMS_ROLES (
    ROLEID VARCHAR2(32) NOT NULL, 
    USERID VARCHAR2(32) NOT NULL
);

CREATE TABLE JMS_SUBSCRIPTIONS (
    CLIENTID VARCHAR2(128) NOT NULL, 
    SUBNAME VARCHAR2(128) NOT NULL, 
    TOPIC VARCHAR2(255) NOT NULL, 
    SELECTOR VARCHAR2(255) 
);

CREATE TABLE JMS_USERS (
    USERID VARCHAR2(32) NOT NULL, 
    PASSWD VARCHAR2(32) NOT NULL, 
    CLIENTID VARCHAR2(128) 
);

CREATE TABLE JORNADATRABALHO (
    IDJORNADA NUMBER(10, 0) NOT NULL, 
    DESCRICAO VARCHAR2(70) NOT NULL, 
    INICIO1 CHAR(5), 
    TERMINO1 CHAR(5), 
    INICIO2 CHAR(5), 
    TERMINO2 CHAR(5), 
    INICIO3 CHAR(5), 
    TERMINO3 CHAR(5), 
    INICIO4 CHAR(5), 
    TERMINO4 CHAR(5), 
    INICIO5 CHAR(5), 
    TERMINO5 CHAR(5), 
    CARGAHORARIA CHAR(5), 
    DATAFIM DATE, 
    DATAINICIO DATE
);

CREATE TABLE JUSTIFICACAOFALHA (
    IDJUSTIFICACAOFALHA NUMBER(10, 0) NOT NULL, 
    IDITEMCONFIGURACAO NUMBER(10, 0), 
    IDBASEITEMCONFIGURACAO NUMBER(10, 0), 
    IDEVENTO NUMBER(10, 0), 
    IDEMPREGADO NUMBER(10, 0), 
    IDHISTORICOTENTATIVA NUMBER(10, 0), 
    DESCRICAO CLOB, 
    DATA DATE, 
    HORA CHAR(4)
);

CREATE TABLE JUSTIFICATIVASOLICITACAO (
    IDJUSTIFICATIVA NUMBER(10, 0) NOT NULL, 
    DESCRICAOJUSTIFICATIVA VARCHAR2(100) NOT NULL, 
    SUSPENSAO CHAR(1) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    DELETED CHAR(1)
);

CREATE TABLE LOCALEXECUCAOSERVICO (
    IDLOCALEXECUCAOSERVICO NUMBER(10, 0) NOT NULL, 
    NOMELOCALEXECUCAOSERVICO VARCHAR2(70) NOT NULL, 
    DELETED CHAR(1)
);

CREATE TABLE LOGDADOS (
    IDLOG NUMBER(10, 0) NOT NULL, 
    DTATUALIZACAO DATE, 
    OPERACAO VARCHAR2(100), 
    DADOS CLOB, 
    IDUSUARIO NUMBER(10, 0), 
    LOCALORIGEM VARCHAR2(255), 
    NOMETABELA VARCHAR2(255) 
);

CREATE TABLE MENU (
    IDMENU NUMBER(10, 0) NOT NULL, 
    IDMENUPAI NUMBER(10, 0), 
    NOME VARCHAR2(256) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    DESCRICAO VARCHAR2(256), 
    ORDEM NUMBER(10, 0), 
    LINK VARCHAR2(256) NOT NULL, 
    IMAGEM VARCHAR2(256), 
    HORIZONTAL VARCHAR2(10) 
);

CREATE TABLE MEUCATALOGO (
    IDUSUARIO NUMBER(10, 0) NOT NULL, 
    IDSERVICO NUMBER(10, 0) NOT NULL
);

CREATE TABLE MODELOSEMAILS (
    IDMODELOEMAIL NUMBER(10, 0) NOT NULL, 
    TITULO VARCHAR2(100) NOT NULL, 
    TEXTO CLOB NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    IDENTIFICADOR VARCHAR2(20) 
);

CREATE TABLE MOEDAS (
    IDMOEDA NUMBER(10, 0) NOT NULL, 
    NOMEMOEDA VARCHAR2(50) NOT NULL
);

CREATE TABLE MOTIVOSUSPENSAOATIVID (
    IDMOTIVO NUMBER(10, 0) NOT NULL, 
    DESCRICAO VARCHAR2(100) NOT NULL
);

CREATE TABLE NETMAP (
    IDNETMAP NUMBER(10, 0) NOT NULL, 
    IP VARCHAR2(50), 
    MASK VARCHAR2(50), 
    MAC VARCHAR2(50), 
    DATA DATE, 
    NOME VARCHAR2(150) 
);

CREATE TABLE OBJETONEGOCIO (
    IDOBJETONEGOCIO NUMBER(19, 0) NOT NULL, 
    NOMEOBJETONEGOCIO VARCHAR2(500) NOT NULL, 
    NOMETABELADB VARCHAR2(120) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL
);

CREATE TABLE OCORRENCIAS (
    IDOCORRENCIA NUMBER(10, 0) NOT NULL, 
    IDDEMANDA NUMBER(10, 0) NOT NULL, 
    OCORRENCIA CLOB, 
    TIPOOCORRENCIA CHAR(1) NOT NULL, 
    RESPOSTAOCORRENCIA CLOB, 
    DATA DATE NOT NULL, 
    IDEMPREGADO NUMBER(10, 0)
);

CREATE TABLE OCORRENCIASOLICITACAO (
    IDOCORRENCIA NUMBER(10, 0) NOT NULL, 
    IDJUSTIFICATIVA NUMBER(10, 0), 
    IDSOLICITACAOSERVICO NUMBER(19, 0), 
    IDITEMTRABALHO NUMBER(19, 0), 
    DATAREGISTRO DATE, 
    HORAREGISTRO VARCHAR2(5), 
    REGISTRADOPOR VARCHAR2(100), 
    DESCRICAO VARCHAR2(200), 
    DATAINICIO DATE, 
    DATAFIM DATE, 
    COMPLEMENTOJUSTIFICATIVA CLOB, 
    DADOSSOLICITACAO CLOB, 
    INFORMACOESCONTATO CLOB, 
    CATEGORIA VARCHAR2(20), 
    ORIGEM CHAR(1), 
    TEMPOGASTO SMALLINT, 
    OCORRENCIA CLOB
);

CREATE TABLE OPCAORESPOSTAQUESTIONARIO (
    IDOPCAORESPOSTAQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    IDQUESTAOQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    TITULO VARCHAR2(255) NOT NULL, 
    PESO NUMBER(10, 0), 
    VALOR VARCHAR2(50), 
    GERAALERTA CHAR(1), 
    EXIBECOMPLEMENTO CHAR(1), 
    IDQUESTAOCOMPLEMENTO NUMBER(10, 0)
);

CREATE TABLE OPINIAO (
    IDOPINIAO NUMBER(10, 0) NOT NULL, 
    IDUSUARIO NUMBER(10, 0), 
    IDSOLICITACAO NUMBER(10, 0), 
    TIPO VARCHAR2(50), 
    OBSERVACOES VARCHAR2(250), 
    DATA DATE, 
    HORA DATE
);

CREATE TABLE ORIGEMATENDIMENTO (
    IDORIGEM NUMBER(19, 0) NOT NULL, 
    DESCRICAO VARCHAR2(100) NOT NULL
);

CREATE TABLE OS (
    IDOS NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0) NOT NULL, 
    IDCLASSIFICACAOOS NUMBER(10, 0), 
    IDSERVICOCONTRATO NUMBER(19, 0), 
    NUMERO VARCHAR2(20), 
    ANO NUMBER(10, 0), 
    DATAINICIO DATE, 
    DATAFIM DATE, 
    DEMANDA CLOB NOT NULL, 
    OBJETIVO CLOB, 
    SITUACAOOS NUMBER(10, 0), 
    NOMEAREAREQUISITANTE VARCHAR2(150), 
    OBSFINALIZACAO CLOB, 
    QUANTIDADEGLOSASANTERIOR NUMBER(10, 0)
);

CREATE TABLE OSATIVIDADEPERIODICA (
    IDATIVIDADEPERIODICA NUMBER(10, 0), 
    IDOS NUMBER(10, 0)
);

CREATE TABLE PALAVRAGEMEA (
    IDPALAVRAGEMEA NUMBER(10, 0) NOT NULL, 
    PALAVRA VARCHAR2(256) NOT NULL, 
    PALAVRACORRESPONDENTE VARCHAR2(256) NOT NULL
);

CREATE TABLE PARAMETROCORPORE (
    IDPARAMETROCORPORE NUMBER(10, 0) NOT NULL, 
    NOMEPARAMETROCORPORE VARCHAR2(200) NOT NULL, 
    VALOR VARCHAR2(200) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE PARAMETROS (
    NOMEPARAMETRO VARCHAR2(70) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    MODULO VARCHAR2(200), 
    VALOR VARCHAR2(200), 
    DETALHAMENTO VARCHAR2(200) 
);

CREATE TABLE PARAMETROSCONTRATO (
    IDCONTRATO NUMBER(10, 0) NOT NULL, 
    NOMEPARAMETRO VARCHAR2(100) NOT NULL, 
    VALORPARAMETRO CLOB
);

CREATE TABLE PASTA (
    IDPASTA NUMBER(10, 0) NOT NULL, 
    NOME VARCHAR2(256), 
    DATAINICIO DATE, 
    DATAFIM DATE, 
    IDPASTAPAI NUMBER(10, 0)
);

CREATE TABLE PERFILACESSO (
    IDPERFIL NUMBER(10, 0) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    NOME VARCHAR2(256) NOT NULL
);

CREATE TABLE PERFILACESSOGRUPO (
    IDPERFIL NUMBER(10, 0) NOT NULL, 
    IDGRUPO NUMBER(10, 0) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE PERFILACESSOMENU (
    IDPERFILACESSO NUMBER(10, 0), 
    IDMENU NUMBER(10, 0), 
    PESQUISA CHAR(1) NOT NULL, 
    GRAVA CHAR(1) NOT NULL, 
    DELETA CHAR(1) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE PERFILACESSOPASTA (
    IDPERFIL NUMBER(10, 0) NOT NULL, 
    IDPASTA NUMBER(10, 0) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    APROVABASECONHECIMENTO CHAR(1)
);

CREATE TABLE PERFILACESSOSITUACAOFATURA (
    IDPERFIL NUMBER(10, 0) NOT NULL, 
    SITUACAOFATURA CHAR(1) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE PERFILACESSOSITUACAOOS (
    IDPERFIL NUMBER(10, 0) NOT NULL, 
    SITUACAOOS NUMBER(10, 0) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE PERFILACESSOUSUARIO (
    DATAINICIO DATE NOT NULL, 
    IDUSUARIO NUMBER(10, 0) NOT NULL, 
    IDPERFIL NUMBER(10, 0) NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE PERFILSEGURANCA (
    IDPERFILSEGURANCA NUMBER(10, 0) NOT NULL, 
    NOMEPERFILSEGURANCA VARCHAR2(15) NOT NULL, 
    DESCPERFILSEGURANCA VARCHAR2(70) 
);

CREATE TABLE PERMISSOESFLUXO (
    IDGRUPO NUMBER(10, 0) NOT NULL, 
    IDTIPOFLUXO NUMBER(10, 0) NOT NULL, 
    CRIAR CHAR(1) NOT NULL, 
    EXECUTAR CHAR(1) NOT NULL, 
    DELEGAR CHAR(1) NOT NULL, 
    SUSPENDER CHAR(1) NOT NULL, 
    REATIVAR CHAR(1), 
    ALTERARSLA CHAR(1), 
    REABRIR CHAR(1)
);

CREATE TABLE PESQUISASATISFACAO (
    IDPESQUISASATISFACAO NUMBER(10, 0) NOT NULL, 
    IDSOLICITACAOSERVICO NUMBER(19, 0) NOT NULL, 
    NOTA NUMBER(10, 0) NOT NULL, 
    COMENTARIO CLOB
);

CREATE TABLE PORTAL (
    IDPORTAL NUMBER(10, 0) NOT NULL, 
    IDITEM NUMBER(10, 0), 
    POSICAOX DOUBLE PRECISION, 
    POSICAOY DOUBLE PRECISION, 
    IDUSUARIO NUMBER(10, 0) NOT NULL, 
    LARGURA DOUBLE PRECISION, 
    ALTURA DOUBLE PRECISION, 
    DATA DATE, 
    HORA DATE, 
    COLUNA NUMBER(10, 0)
);

CREATE TABLE PRIORIDADE (
    IDPRIORIDADE NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0), 
    NOMEPRIORIDADE VARCHAR2(100) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    GRUPOPRIORIDADE CHAR(3) NOT NULL
);

CREATE TABLE PRIORIDADEACORDONIVELSERVICO (
    IDUNIDADE NUMBER(10, 0) NOT NULL, 
    IDACORDONIVELSERVICO NUMBER(19, 0) NOT NULL, 
    IDPRIORIDADE NUMBER(19, 0), 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE PRIORIDADESERVICOUNIDADE (
    IDUNIDADE NUMBER(10, 0) NOT NULL, 
    IDSERVICOCONTRATO NUMBER(19, 0) NOT NULL, 
    IDPRIORIDADE NUMBER(19, 0), 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE PROBLEMA (
    IDPROBLEMA NUMBER(10, 0) NOT NULL, 
    STATUS VARCHAR2(40), 
    PRIORIDADE NUMBER(10, 0), 
    IDCRIADOR NUMBER(10, 0), 
    IDPROPRIETARIO NUMBER(10, 0), 
    TITULO VARCHAR2(255), 
    DESCRICAO VARCHAR2(1000), 
    IDCATEGORIAPROBLEMA NUMBER(10, 0), 
    IMPACTO VARCHAR2(10), 
    URGENCIA VARCHAR2(10), 
    PROATIVOREATIVO VARCHAR2(15), 
    DATAHORALIMITESOLUCIONAR DATE, 
    MSGERROASSOCIADA VARCHAR2(1000), 
    IDPROBLEMAITEMCONFIGURACAO NUMBER(10, 0), 
    IDPROBLEMAMUDANCA NUMBER(10, 0), 
    IDPROBLEMAINCIDENTE NUMBER(10, 0), 
    DATAHORAINICIO DATE, 
    DATAHORAFIM DATE, 
    SOLUCAODEFINITIVA VARCHAR2(4000), 
    ADICIONARBDCE VARCHAR2(1), 
    STATUSBASECONHECIMENTO VARCHAR2(1), 
    IDPASTABASECONHECIMENTO NUMBER(10, 0), 
    CAUSARAIZ VARCHAR2(4000), 
    SOLUCAOCONTORNO VARCHAR2(4000), 
    IDBASECONHECIMENTO NUMBER(10, 0), 
    SEVERIDADE VARCHAR2(15) 
);

CREATE TABLE PROBLEMAITEMCONFIGURACAO (
    IDPROBLEMAITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    IDPROBLEMA NUMBER(10, 0) NOT NULL, 
    IDITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    DESCRICAOPROBLEMA VARCHAR2(255) 
);

CREATE TABLE PROBLEMAMUDANCA (
    IDPROBLEMAMUDANCA NUMBER(10, 0) NOT NULL, 
    IDPROBLEMA NUMBER(10, 0) NOT NULL, 
    IDREQUISICAOMUDANCA NUMBER(10, 0) NOT NULL
);

CREATE TABLE PROCEDIMENTOTECNICO (
    IDPROCEDIMENTOTECNICO NUMBER(10, 0) NOT NULL, 
    NOMEPROCEDIMENTOTECNICO VARCHAR2(255) NOT NULL, 
    TEXTOPROCEDIMENTOTECNICO CLOB, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE PROCESSAMENTOBATCH (
    IDPROCESSAMENTOBATCH NUMBER(10, 0) NOT NULL, 
    DESCRICAO VARCHAR2(70) NOT NULL, 
    EXPRESSAOCRON VARCHAR2(40) NOT NULL, 
    CONTEUDO CLOB, 
    TIPO CHAR(1) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL
);

CREATE TABLE PROGRAMACAOATIVIDADE (
    IDPROGRAMACAOATIVIDADE NUMBER(10, 0) NOT NULL, 
    IDATIVIDADEPERIODICA NUMBER(10, 0) NOT NULL, 
    TIPOAGENDAMENTO CHAR(1) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    DURACAOESTIMADA NUMBER(10, 0), 
    PERIODICIDADEDIARIA NUMBER(10, 0), 
    PERIODICIDADESEMANAL NUMBER(10, 0), 
    PERIODICIDADEMENSAL NUMBER(10, 0), 
    DIA NUMBER(10, 0), 
    DIAUTIL NUMBER(10, 0), 
    DIASEMANA NUMBER(10, 0), 
    SEQDIASEMANA NUMBER(10, 0), 
    SEG CHAR(1), 
    TER CHAR(1), 
    QUA CHAR(1), 
    QUI CHAR(1), 
    SEX CHAR(1), 
    SAB CHAR(1), 
    DOM CHAR(1), 
    JAN CHAR(1), 
    FEV CHAR(1), 
    MAR CHAR(1), 
    ABR CHAR(1), 
    MAI CHAR(1), 
    JUN CHAR(1), 
    JUL CHAR(1), 
    AGO CHAR(1), 
    SETEM CHAR(1), 
    OUTUB CHAR(1), 
    NOV CHAR(1), 
    DEZ CHAR(1), 
    REPETICAO CHAR(1), 
    REPETICAOINTERVALO NUMBER(10, 0), 
    REPETICAOTIPOINTERVALO CHAR(1), 
    HORAINICIO CHAR(4), 
    HORAFIM CHAR(4), 
    IDATIVIDADESOS NUMBER(10, 0)
);

CREATE TABLE PROJETOS (
    IDPROJETO NUMBER(10, 0) NOT NULL, 
    IDCLIENTE NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0), 
    NOMEPROJETO VARCHAR2(70) NOT NULL, 
    DETALHAMENTO CLOB, 
    SITUACAO CHAR(1) NOT NULL, 
    VALORESTIMADO NUMBER(18, 3) NOT NULL
);

CREATE TABLE QUESTAOQUESTIONARIO (
    IDQUESTAOQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    IDGRUPOQUESTIONARIO NUMBER(10, 0), 
    IDQUESTAOAGRUPADORA NUMBER(10, 0), 
    IDQUESTAOCOMPARTILHADA NUMBER(10, 0), 
    IDQUESTAOORIGEM NUMBER(10, 0), 
    TIPO CHAR(1) NOT NULL, 
    TITULOQUESTAOQUESTIONARIO CLOB, 
    TIPOQUESTAO CHAR(1) NOT NULL, 
    SEXOQUESTAO CHAR(1) NOT NULL, 
    SEQUENCIAQUESTAO NUMBER(10, 0) NOT NULL, 
    VALORDEFAULT CLOB, 
    TEXTOINICIAL CLOB, 
    TAMANHO NUMBER(10, 0), 
    DECIMAIS NUMBER(10, 0), 
    INFORESPOSTA CHAR(1), 
    VALORESREFERENCIA CLOB, 
    UNIDADE CLOB, 
    OBRIGATORIA CHAR(1) NOT NULL, 
    PONDERADA CHAR(1), 
    QTDELINHAS NUMBER(10, 0), 
    QTDECOLUNAS NUMBER(10, 0), 
    CABECALHOLINHAS CHAR(1), 
    CABECALHOCOLUNAS CHAR(1), 
    NOMELISTAGEM VARCHAR2(30), 
    ULTIMOVALOR CHAR(1), 
    IDSUBQUESTIONARIO NUMBER(10, 0), 
    ABARESULTSUBFORM VARCHAR2(200), 
    SIGLA VARCHAR2(100), 
    IMPRIME CHAR(1), 
    CALCULADA CHAR(1), 
    EDITAVEL CHAR(1), 
    VALORPERMITIDO1 NUMBER(15, 5), 
    VALORPERMITIDO2 NUMBER(15, 5), 
    APLICAVELCRIANCA CHAR(1), 
    APLICAVELIDOSO CHAR(1), 
    APLICAVELADULTO CHAR(1), 
    APLICAVELADOLESCENTE CHAR(1), 
    IDIMAGEM NUMBER(10, 0)
);

CREATE TABLE QUESTIONARIO (
    IDQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    IDQUESTIONARIOORIGEM NUMBER(10, 0), 
    IDCATEGORIAQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    NOMEQUESTIONARIO VARCHAR2(50) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    ATIVO CHAR(1) DEFAULT 'S'
);

CREATE TABLE REABERTURASOLICITACAO (
    IDSOLICITACAOSERVICO NUMBER(19, 0) NOT NULL, 
    SEQREABERTURA NUMBER(10, 0) NOT NULL, 
    IDRESPONSAVEL NUMBER(10, 0), 
    DATAHORA DATE DEFAULT SYSDATE NOT NULL, 
    OBSERVACOES CLOB
);

CREATE TABLE REGIOES (
    IDREGIOES NUMBER(10, 0) NOT NULL, 
    NOME VARCHAR2(45) NOT NULL
);

CREATE TABLE RELACOBJETONEGOCIO (
    IDRELACOBJETONEGOCIO NUMBER(19, 0) NOT NULL, 
    IDOBJETONEGOCIOPAI NUMBER(19, 0) NOT NULL, 
    IDOBJETONEGOCIOFILHO NUMBER(19, 0) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL
);

CREATE TABLE RESPONSABILIDADE (
    IDRESPONSABILIDADE NUMBER(10, 0) NOT NULL, 
    IDEMPREGADO NUMBER(10, 0), 
    IDCONTRATO NUMBER(10, 0) NOT NULL, 
    IDCONTATOCLIENTE NUMBER(10, 0), 
    IDSERVICOCONTRATO NUMBER(10, 0), 
    PRODUTOATV VARCHAR2(400) NOT NULL, 
    DETALHAMENTO CLOB, 
    PARTICIPACAO VARCHAR2(400) 
);

CREATE TABLE RESPOSTAITEMQUESTIONARIO (
    IDRESPOSTAITEMQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    IDIDENTIFICADORRESPOSTA NUMBER(10, 0) NOT NULL, 
    IDQUESTAOQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    SEQUENCIALRESPOSTA NUMBER(10, 0), 
    RESPOSTATEXTUAL CLOB, 
    RESPOSTAPERCENTUAL NUMBER(15, 5), 
    RESPOSTAVALOR NUMBER(15, 5), 
    RESPOSTAVALOR2 NUMBER(15, 5), 
    RESPOSTANUMERO NUMBER(13, 0), 
    RESPOSTANUMERO2 NUMBER(13, 0), 
    RESPOSTADATA DATE, 
    RESPOSTAHORA VARCHAR2(4), 
    RESPOSTAPRESSAOSISTOLICA SMALLINT, 
    RESPOSTAPRESSAODIASTOLICA SMALLINT, 
    RESPOSTAMES SMALLINT, 
    RESPOSTAANO SMALLINT, 
    RESPOSTAPESO NUMBER(15, 5), 
    RESPOSTAALTURA NUMBER(15, 5), 
    RESPOSTAIMC NUMBER(15, 5), 
    RESPOSTADUM DATE, 
    RESPOSTACICLOMENSTRUAL SMALLINT, 
    RESPOSTAMEDIAFASELUTEA SMALLINT, 
    RESPOSTADPP DATE, 
    RESPOSTAIDLISTAGEM VARCHAR2(10), 
    IDATESTADO NUMBER(10, 0), 
    RESPOSTADPPPELADUM DATE, 
    RESPOSTADIA SMALLINT
);

CREATE TABLE RESPOSTAITEMQUESTIONARIOANEXOS (
    IDRESPOSTAITMQUESTIONARIOANEXO NUMBER(10, 0) NOT NULL, 
    IDRESPOSTAITEMQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    CAMINHOANEXO VARCHAR2(255) NOT NULL, 
    OBSERVACAO CLOB
);

CREATE TABLE RESPOSTAITEMQUESTIONARIOCIDS (
    IDRESPOSTAITEMQUESTIONARIOCID NUMBER(10, 0) NOT NULL, 
    IDRESPOSTAITEMQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    IDCID NUMBER(10, 0) NOT NULL
);

CREATE TABLE RESPOSTAITEMQUESTIONARIOOPCOES (
    IDRESPOSTAITEMQUESTIONARIO NUMBER(10, 0) NOT NULL, 
    IDOPCAORESPOSTAQUESTIONARIO NUMBER(10, 0) NOT NULL
);

CREATE TABLE SCRIPTSVISAO (
    IDSCRIPTSVISAO NUMBER(19, 0) NOT NULL, 
    IDVISAO NUMBER(19, 0) NOT NULL, 
    TYPEEXECUTE CHAR(1) NOT NULL, 
    SCRYPTTYPE CHAR(30) NOT NULL, 
    SCRIPT CLOB, 
    SCRIPTLANGUAGE VARCHAR2(30) 
);

CREATE TABLE SERVICO (
    IDSERVICO NUMBER(19, 0) NOT NULL, 
    IDCATEGORIASERVICO NUMBER(10, 0) NOT NULL, 
    IDSITUACAOSERVICO NUMBER(10, 0) NOT NULL, 
    IDTIPOSERVICO NUMBER(10, 0), 
    IDIMPORTANCIANEGOCIO NUMBER(10, 0), 
    IDEMPRESA NUMBER(19, 0) NOT NULL, 
    IDTIPOEVENTOSERVICO NUMBER(10, 0), 
    IDTIPODEMANDASERVICO NUMBER(10, 0), 
    IDLOCALEXECUCAOSERVICO NUMBER(10, 0), 
    NOMESERVICO VARCHAR2(500) NOT NULL, 
    DETALHESERVICO CLOB, 
    OBJETIVO CLOB, 
    PASSOSSERVICO CLOB, 
    DATAINICIO DATE, 
    LINKPROCESSO VARCHAR2(500), 
    DESCRICAOPROCESSO CLOB, 
    TIPODESCPROCESS CHAR(1), 
    DISPPORTAL CHAR(1), 
    QUADROORIENTPORTAL CLOB, 
    DELETED CHAR(1), 
    DETALHESSERVICO VARCHAR2(255), 
    SIGLAABREV VARCHAR2(150), 
    IDBASECONHECIMENTO NUMBER(10, 0)
);

CREATE TABLE SERVICOCONTRATO (
    IDSERVICOCONTRATO NUMBER(19, 0) NOT NULL, 
    IDSERVICO NUMBER(19, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0) NOT NULL, 
    IDCONDICAOOPERACAO NUMBER(10, 0), 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    OBSERVACAO CLOB, 
    CUSTO NUMBER(18, 3), 
    RESTRICOESPRESSUP CLOB, 
    OBJETIVO CLOB, 
    PERMITESLANOCADINC CHAR(1), 
    LINKPROCESSO VARCHAR2(500), 
    DESCRICAOPROCESSO CLOB, 
    TIPODESCPROCESS CHAR(1), 
    DELETED CHAR(1), 
    AREAREQUISITANTE VARCHAR2(150), 
    IDGRUPONIVEL1 NUMBER(10, 0), 
    IDMODELOEMAILCRIACAO NUMBER(10, 0), 
    IDMODELOEMAILFINALIZACAO NUMBER(10, 0), 
    IDMODELOEMAILACOES NUMBER(10, 0), 
    IDGRUPOEXECUTOR NUMBER(10, 0), 
    IDCALENDARIO NUMBER(10, 0), 
    PERMSLATEMPOACOMBINAR CHAR(1), 
    PERMMUDANCASLA CHAR(1), 
    PERMMUDANCACALENDARIO CHAR(1)
);

CREATE TABLE SISTEMAOPERACIONAL (
    ID NUMBER(10, 0) NOT NULL, 
    NOME VARCHAR2(255) 
);

CREATE TABLE SITUACAODEMANDA (
    IDSITUACAODEMANDA NUMBER(10, 0) NOT NULL, 
    NOMESITUACAO VARCHAR2(40) NOT NULL
);

CREATE TABLE SITUACAOSERVICO (
    IDSITUACAOSERVICO NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOMESITUACAOSERVICO VARCHAR2(100) NOT NULL, 
    DATAINICIO DATE, 
    DATAFIM DATE
);

CREATE TABLE SOLICITACAOSERVICO (
    IDSOLICITACAOSERVICO NUMBER(19, 0) NOT NULL, 
    IDFASEATUAL NUMBER(19, 0), 
    IDTIPOPROBLEMA NUMBER(19, 0), 
    IDGRUPOATUAL NUMBER(10, 0), 
    IDPRIORIDADE NUMBER(19, 0), 
    IDORIGEM NUMBER(19, 0), 
    IDRESPONSAVEL NUMBER(10, 0), 
    IDSOLICITANTE NUMBER(10, 0), 
    ATENDIMENTOPRESENCIAL CHAR(1), 
    DATAHORASOLICITACAO DATE DEFAULT SYSDATE NOT NULL, 
    DATAHORALIMITE DATE DEFAULT TO_DATE('2000-01-01 00:00:00',  'YYYY-MM-DD HH24:MI:SS') NOT NULL, 
    PRAZOHH SMALLINT, 
    PRAZOMM SMALLINT, 
    DESCRICAO CLOB NOT NULL, 
    RESPOSTA CLOB, 
    DATAHORAINICIO DATE DEFAULT TO_DATE('2000-01-01 00:00:00',  'YYYY-MM-DD HH24:MI:SS') NOT NULL, 
    DATAHORAFIM DATE DEFAULT TO_DATE('2000-01-01 00:00:00',  'YYYY-MM-DD HH24:MI:SS') NOT NULL, 
    SITUACAO VARCHAR2(20) NOT NULL, 
    DELETED CHAR(1), 
    IDCONTATOSOLICITACAOSERVICO NUMBER(10, 0), 
    IDSERVICOCONTRATO NUMBER(19, 0), 
    IDUNIDADE NUMBER(10, 0), 
    IDCAUSAINCIDENTE NUMBER(10, 0), 
    IDCATEGORIASOLUCAO NUMBER(10, 0), 
    IDTIPODEMANDASERVICO NUMBER(10, 0), 
    IDITEMCONFIGURACAO NUMBER(10, 0), 
    IDITEMCONFIGURACAOFILHO NUMBER(10, 0), 
    IDSOLICITACAOPAI NUMBER(10, 0), 
    DETALHAMENTOCAUSA____ CLOB, 
    SEQREABERTURA NUMBER(10, 0), 
    DETALHAMENTOCAUSA CLOB, 
    ENVIAEMAILCRIACAO CHAR(1), 
    ENVIAEMAILFINALIZACAO CHAR(1), 
    ENVIAEMAILACOES CHAR(1), 
    IDGRUPONIVEL1 NUMBER(10, 0), 
    SOLUCAOTEMPORARIA CHAR(1), 
    IDSOLICITACAOSERVICOORIGEM NUMBER(19, 0), 
    IDCALENDARIO NUMBER(10, 0), 
    HOUVEMUDANCA CHAR(1), 
    SLAACOMBINAR CHAR(1), 
    PRAZOHHANTERIOR SMALLINT, 
    PRAZOMMANTERIOR SMALLINT, 
    TEMPODECORRIDOHH SMALLINT, 
    TEMPODECORRIDOMM SMALLINT, 
    DATAHORASUSPENSAO DATE, 
    DATAHORAREATIVACAO DATE, 
    IMPACTO CHAR(1), 
    URGENCIA CHAR(1), 
    TEMPOCAPTURAHH SMALLINT, 
    TEMPOCAPTURAMM SMALLINT, 
    TEMPOATRASOHH SMALLINT, 
    TEMPOATRASOMM SMALLINT, 
    TEMPOATENDIMENTOHH SMALLINT, 
    TEMPOATENDIMENTOMM SMALLINT, 
    DATAHORACAPTURA DATE, 
    IDBASECONHECIMENTO NUMBER(10, 0)
);

CREATE TABLE TEMPOACORDONIVELSERVICO (
    IDACORDONIVELSERVICO NUMBER(19, 0) NOT NULL, 
    IDPRIORIDADE NUMBER(19, 0) NOT NULL, 
    IDFASE NUMBER(19, 0) NOT NULL, 
    TEMPOHH NUMBER(10, 0) NOT NULL, 
    TEMPOMM NUMBER(10, 0) NOT NULL
);

CREATE TABLE TESTE (
    IDTESTE NUMBER(10, 0) NOT NULL, 
    NOME VARCHAR2(256) 
);

CREATE TABLE TIMERS (
    TIMERID VARCHAR2(80) NOT NULL, 
    TARGETID VARCHAR2(250) NOT NULL, 
    INITIALDATE DATE DEFAULT SYSDATE NOT NULL, 
    TIMERINTERVAL NUMBER(19, 0), 
    INSTANCEPK CLOB, 
    INFO CLOB
);

CREATE TABLE TIMESHEET (
    IDTIMESHEET NUMBER(10, 0) NOT NULL, 
    IDDEMANDA NUMBER(10, 0), 
    IDEMPREGADO NUMBER(10, 0) NOT NULL, 
    IDPROJETO NUMBER(10, 0), 
    QTDEHORAS NUMBER(18, 3) NOT NULL, 
    DATA DATE NOT NULL, 
    CUSTOPORHORA NUMBER(18, 3) NOT NULL, 
    DETALHAMENTO CLOB
);

CREATE TABLE TIPODEMANDA (
    IDTIPODEMANDA NUMBER(10, 0) NOT NULL, 
    NOMETIPODEMANDA VARCHAR2(40) NOT NULL
);

CREATE TABLE TIPODEMANDASERVICO (
    IDTIPODEMANDASERVICO NUMBER(10, 0) NOT NULL, 
    NOMETIPODEMANDASERVICO VARCHAR2(70) NOT NULL, 
    CLASSIFICACAO CHAR(1), 
    DELETED CHAR(1)
);

CREATE TABLE TIPOEVENTOSERVICO (
    IDTIPOEVENTOSERVICO NUMBER(10, 0) NOT NULL, 
    NOMETIPOEVENTOSERVICO VARCHAR2(70) NOT NULL, 
    DELETED CHAR(1)
);

CREATE TABLE TIPOITEMCFGCARACTERISTICA (
    ID NUMBER(10, 0) NOT NULL, 
    IDTIPOITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    IDCARACTERISTICA NUMBER(10, 0) NOT NULL, 
    DATAINICIO DATE, 
    DATAFIM DATE, 
    NAMEINFOAGENTE VARCHAR2(255) 
);

CREATE TABLE TIPOITEMCONFIGURACAO (
    IDTIPOITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOMETIPOITEMCONFIGURACAO VARCHAR2(255) NOT NULL, 
    TAGTIPOITEMCONFIGURACAO VARCHAR2(50), 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    SISTEMA NUMBER(10, 0)
);

CREATE TABLE TIPOOS (
    IDCLASSIFICACAOOS NUMBER(10, 0) NOT NULL, 
    IDCONTRATO NUMBER(10, 0), 
    DESCRICAO VARCHAR2(150) NOT NULL, 
    DETALHAMENTO CLOB
);

CREATE TABLE TIPOPROBLEMAATENDIMENTO (
    IDTIPOPROBLEMA NUMBER(19, 0) NOT NULL, 
    IDTIPOPROBLEMAPAI NUMBER(19, 0), 
    DESCRICAOPROBLEMA CLOB NOT NULL, 
    SITUACAO CHAR(1) NOT NULL
);

CREATE TABLE TIPOSATIVIDADES (
    IDTIPOATIVIDADE NUMBER(10, 0) NOT NULL, 
    DESCRICAOTIPOATIVIDADE VARCHAR2(50) NOT NULL
);

CREATE TABLE TIPOSERVICO (
    IDTIPOSERVICO NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOMETIPOSERVICO VARCHAR2(300) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL
);

CREATE TABLE TIPOUNIDADE (
    IDTIPOUNIDADE NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOMETIPOUNIDADE VARCHAR2(80) NOT NULL, 
    DATAINICIO DATE, 
    DATAFIM DATE
);

CREATE TABLE UFS (
    IDUF NUMBER(10, 0) NOT NULL, 
    NOMEUF VARCHAR2(50) NOT NULL, 
    SIGLAUF VARCHAR2(2) NOT NULL, 
    IDREGIOES NUMBER(10, 0)
);

CREATE TABLE UNIDADE (
    IDUNIDADE NUMBER(10, 0) NOT NULL, 
    IDUNIDADEPAI NUMBER(10, 0), 
    IDTIPOUNIDADE NUMBER(10, 0), 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    NOME VARCHAR2(255) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE, 
    DESCRICAO CLOB, 
    EMAIL VARCHAR2(40) 
);

CREATE TABLE UNIDADEBASEITEMCONFIGURACAO (
    IDBASEITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    IDUNIDADE NUMBER(10, 0)
);

CREATE TABLE UNIDADESACCSERVICOS (
    IDUNIDADE NUMBER(10, 0) NOT NULL, 
    IDSERVICO NUMBER(19, 0) NOT NULL
);

CREATE TABLE USUARIO (
    IDUSUARIO NUMBER(10, 0) NOT NULL, 
    IDUNIDADE NUMBER(10, 0), 
    IDEMPREGADO NUMBER(10, 0) NOT NULL, 
    IDEMPRESA NUMBER(10, 0) NOT NULL, 
    LOGIN VARCHAR2(256), 
    NOME VARCHAR2(256), 
    SENHA VARCHAR2(300) NOT NULL, 
    STATUS CHAR(1), 
    LDAP CHAR(1)
);

CREATE TABLE USUARIOITEMCONFIGURACAO (
    IDUSUARIO NUMBER(10, 0) NOT NULL, 
    IDITEMCONFIGURACAO NUMBER(10, 0) NOT NULL, 
    DATAINICIO DATE NOT NULL, 
    DATAFIM DATE
);

CREATE TABLE VALOR (
    IDVALOR NUMBER(10, 0) NOT NULL, 
    IDITEMCONFIGURACAO NUMBER(10, 0), 
    IDCARACTERISTICA NUMBER(10, 0), 
    VALORSTR VARCHAR2(4000), 
    VALORLONGO CLOB, 
    VALORDECIMAL NUMBER(18, 4), 
    VALORDATE DATE, 
    IDBASEITEMCONFIGURACAO NUMBER(10, 0)
);

CREATE TABLE VALORVISAOCAMPOSNEGOCIO (
    IDVALORVISAOCAMPOSNEGOCIO NUMBER(19, 0) NOT NULL, 
    IDGRUPOVISAO NUMBER(19, 0) NOT NULL, 
    IDCAMPOSOBJETONEGOCIO NUMBER(19, 0) NOT NULL, 
    VALOR VARCHAR2(500) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    DESCRICAO VARCHAR2(500) NOT NULL
);

CREATE TABLE VINCULOVISAO (
    IDVISAORELACIONADA NUMBER(19, 0) NOT NULL, 
    SEQ NUMBER(10, 0) NOT NULL, 
    TIPOVINCULO CHAR(1) NOT NULL, 
    IDGRUPOVISAOPAI NUMBER(19, 0), 
    IDCAMPOSOBJETONEGOCIOPAI NUMBER(19, 0), 
    IDGRUPOVISAOFILHO NUMBER(19, 0), 
    IDCAMPOSOBJETONEGOCIOFILHO NUMBER(19, 0), 
    IDCAMPOSOBJETONEGOCIOPAINN NUMBER(19, 0), 
    IDCAMPOSOBJETONEGOCIOFILHONN NUMBER(19, 0)
);

CREATE TABLE VISAO (
    IDVISAO NUMBER(19, 0) NOT NULL, 
    DESCRICAO VARCHAR2(120) NOT NULL, 
    TIPOVISAO CHAR(2) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    CLASSENAME VARCHAR2(500), 
    IDENTIFICADOR VARCHAR2(100) 
);

CREATE TABLE VISAORELACIONADA (
    IDVISAORELACIONADA NUMBER(19, 0) NOT NULL, 
    IDVISAOPAI NUMBER(19, 0) NOT NULL, 
    IDVISAOFILHA NUMBER(19, 0) NOT NULL, 
    IDOBJETONEGOCIONN NUMBER(19, 0), 
    ORDEM NUMBER(10, 0) NOT NULL, 
    TITULO VARCHAR2(500) NOT NULL, 
    SITUACAO CHAR(1) NOT NULL, 
    TIPOVINCULACAO CHAR(1) NOT NULL, 
    ACAOEMSELECAOPESQUISA CHAR(2)
);


-- CRIACAO DE CHAVES PRIMARIAS
-- SCRIPT DE ORIGEM: 02 - pks_citsmart.sql

-- CONSTRAINT GRUPOVISAOCAMPOSNEGOCIOINFOSQL_PK DA TABELA GRUPOVISAOCAMPOSNEGOCIOINFOSQL ALTERADA PARA GRPVISCAMPOSNEGINFOSQL_PK 
-- CONSTRAINT GRUPOVISAOCAMPOSNEGOCIOLIGACAO_PK DA TABELA GRUPOVISAOCAMPOSNEGOCIOLIGACAO ALTERADA PARA GRPVISCAMPOSNEGLIGACAO_PK 
-- CONSTRAINT PRIORIDADEACORDONIVELSERVICO_PK DA TABELA PRIORIDADEACORDONIVELSERVICO ALTERADA PARA PRIORIACORDNIVELSERV_PK 
-- CONSTRAINT RESPOSTAITEMQUESTIONARIOANEXOS_PK DA TABELA RESPOSTAITEMQUESTIONARIOANEXOS ALTERADA PARA RESPITEMQUESTOANEXOS_PK 
-- CONSTRAINT RESPOSTAITEMQUESTIONARIOCIDS_PK DA TABELA RESPOSTAITEMQUESTIONARIOCIDS ALTERADA PARA RESPITEMQUESTCIDS_PK 
-- CONSTRAINT RESPOSTAITEMQUESTIONARIOOPCOES_PK DA TABELA RESPOSTAITEMQUESTIONARIOOPCOES ALTERADA PARA RESPITEMQUESTOPCOES_PK 

ALTER TABLE ACORDONIVELSERVICO
    ADD CONSTRAINT ACORDONIVELSERVICO_PK PRIMARY KEY (IDACORDONIVELSERVICO);

ALTER TABLE ACORDONIVELSERVICOCONTRATO
    ADD CONSTRAINT ACORDONIVELSERVICOCONTRATO_PK PRIMARY KEY (IDACORDONIVELSERVICOCONTRATO);

ALTER TABLE ANEXO
    ADD CONSTRAINT ANEXO_PK PRIMARY KEY (IDANEXO);

ALTER TABLE ANEXOBASECONHECIMENTO
    ADD CONSTRAINT ANEXOBASECONHECIMENTO_PK PRIMARY KEY (IDANEXOBASECONHECIMENTO);

ALTER TABLE ANEXOINCIDENTE
    ADD CONSTRAINT ANEXOINCIDENTE_PK PRIMARY KEY (IDANEXOINCIDENTE);

ALTER TABLE ATIVIDADEPERIODICA
    ADD CONSTRAINT ATIVIDADEPERIODICA_PK PRIMARY KEY (IDATIVIDADEPERIODICA);

ALTER TABLE ATIVIDADES
    ADD CONSTRAINT ATIVIDADES_PK PRIMARY KEY (IDATIVIDADE);

ALTER TABLE ATIVIDADESFLUXOS
    ADD CONSTRAINT ATIVIDADESFLUXOS_PK PRIMARY KEY (IDATIVIDADE,  IDFLUXO);

ALTER TABLE ATIVIDADESOS
    ADD CONSTRAINT ATIVIDADESOS_PK PRIMARY KEY (IDATIVIDADESOS);

ALTER TABLE ATIVIDADESSERVICOCONTRATO
    ADD CONSTRAINT ATIVIDADESSERVICOCONTRATO_PK PRIMARY KEY (IDATIVIDADESERVICOCONTRATO);

ALTER TABLE AUDITORIA
    ADD CONSTRAINT AUDITORIA_PK PRIMARY KEY (IDAUDITORIA);

ALTER TABLE AUDITORIAITEMCONFIGURACAO
    ADD CONSTRAINT AUDITORIAITEMCONFIGURACAO_PK PRIMARY KEY (IDAUDITORIA);

ALTER TABLE BASECONHECIMENTO
    ADD CONSTRAINT BASECONHECIMENTO_PK PRIMARY KEY (IDBASECONHECIMENTO);

ALTER TABLE BASEITEMCONFIGURACAO
    ADD CONSTRAINT BASEITEMCONFIGURACAO_PK PRIMARY KEY (IDBASEITEMCONFIGURACAO);

ALTER TABLE BIBLIOTECASEXTERNAS
    ADD CONSTRAINT BIBLIOTECASEXTERNAS_PK PRIMARY KEY (IDBIBLIOTECASEXTERNA);

ALTER TABLE BOTAOACAOVISAO
    ADD CONSTRAINT BOTAOACAOVISAO_PK PRIMARY KEY (IDBOTAOACAOVISAO);

ALTER TABLE BPM_ATRIBUICAOFLUXO
    ADD CONSTRAINT BPM_ATRIBUICAOFLUXO_PK PRIMARY KEY (IDATRIBUICAO);

ALTER TABLE BPM_ELEMENTOFLUXO
    ADD CONSTRAINT BPM_ELEMENTOFLUXO_PK PRIMARY KEY (IDELEMENTO);

ALTER TABLE BPM_FLUXO
    ADD CONSTRAINT BPM_FLUXO_PK PRIMARY KEY (IDFLUXO);

ALTER TABLE BPM_HISTORICOITEMTRABALHO
    ADD CONSTRAINT BPM_HISTORICOITEMTRABALHO_PK PRIMARY KEY (IDHISTORICOITEMTRABALHO);

ALTER TABLE BPM_INSTANCIAFLUXO
    ADD CONSTRAINT BPM_INSTANCIAFLUXO_PK PRIMARY KEY (IDINSTANCIA);

ALTER TABLE BPM_ITEMTRABALHOFLUXO
    ADD CONSTRAINT BPM_ITEMTRABALHOFLUXO_PK PRIMARY KEY (IDITEMTRABALHO);

ALTER TABLE BPM_OBJETOINSTANCIAFLUXO
    ADD CONSTRAINT BPM_OBJETOINSTANCIAFLUXO_PK PRIMARY KEY (IDOBJETOINSTANCIA);

ALTER TABLE BPM_SEQUENCIAFLUXO
    ADD CONSTRAINT BPM_SEQUENCIAFLUXO_PK PRIMARY KEY (IDELEMENTOORIGEM,  IDELEMENTODESTINO);

ALTER TABLE BPM_TIPOFLUXO
    ADD CONSTRAINT BPM_TIPOFLUXO_PK PRIMARY KEY (IDTIPOFLUXO);

ALTER TABLE CALENDARIO
    ADD CONSTRAINT CALENDARIO_PK PRIMARY KEY (IDCALENDARIO);

ALTER TABLE CAMPOOBJRELACIONADO
    ADD CONSTRAINT CAMPOOBJRELACIONADO_PK PRIMARY KEY (IDCAMPOOBJRELACIONADO);

ALTER TABLE CAMPOSOBJETONEGOCIO
    ADD CONSTRAINT CAMPOSOBJETONEGOCIO_PK PRIMARY KEY (IDCAMPOSOBJETONEGOCIO);

ALTER TABLE CARACTERISTICA
    ADD CONSTRAINT CARACTERISTICA_PK PRIMARY KEY (IDCARACTERISTICA);

ALTER TABLE CARGOS
    ADD CONSTRAINT CARGOS_PK PRIMARY KEY (IDCARGO);

ALTER TABLE CATEGORIAGALERIAIMAGEM
    ADD CONSTRAINT CATEGORIAGALERIAIMAGEM_PK PRIMARY KEY (IDCATEGORIAGALERIAIMAGEM);

ALTER TABLE CATEGORIAPROBLEMA
    ADD CONSTRAINT CATEGORIAPROBLEMA_PK PRIMARY KEY (IDCATEGORIAPROBLEMA);

ALTER TABLE CATEGORIAQUESTIONARIO
    ADD CONSTRAINT CATEGORIAQUESTIONARIO_PK PRIMARY KEY (IDCATEGORIAQUESTIONARIO);

ALTER TABLE CATEGORIASERVICO
    ADD CONSTRAINT CATEGORIASERVICO_PK PRIMARY KEY (IDCATEGORIASERVICO);

ALTER TABLE CATEGORIASOLUCAO
    ADD CONSTRAINT CATEGORIASOLUCAO_PK PRIMARY KEY (IDCATEGORIASOLUCAO);

ALTER TABLE CAUSAINCIDENTE
    ADD CONSTRAINT CAUSAINCIDENTE_PK PRIMARY KEY (IDCAUSAINCIDENTE);

ALTER TABLE CIDADES
    ADD CONSTRAINT CIDADES_PK PRIMARY KEY (IDCIDADE);

ALTER TABLE CLIENTES
    ADD CONSTRAINT CLIENTES_PK PRIMARY KEY (IDCLIENTE);

ALTER TABLE COLECAO
    ADD CONSTRAINT COLECAO_PK PRIMARY KEY (IDCOLECAO);

ALTER TABLE COMANDO
    ADD CONSTRAINT COMANDO_PK PRIMARY KEY (ID);

ALTER TABLE COMANDOSISTEMAOPERACIONAL
    ADD CONSTRAINT COMANDOSISTEMAOPERACIONAL_PK PRIMARY KEY (ID);

ALTER TABLE COMENTARIOS
    ADD CONSTRAINT COMENTARIOS_PK PRIMARY KEY (IDCOMENTARIO);

ALTER TABLE CONDICAOOPERACAO
    ADD CONSTRAINT CONDICAOOPERACAO_PK PRIMARY KEY (IDCONDICAOOPERACAO);

ALTER TABLE CONTATOCLIENTE
    ADD CONSTRAINT CONTATOCLIENTE_PK PRIMARY KEY (IDCONTATOCLIENTE);

ALTER TABLE CONTATOSOLICITACAOSERVICO
    ADD CONSTRAINT CONTATOSOLICITACAOSERVICO_PK PRIMARY KEY (IDCONTATOSOLICITACAOSERVICO);

ALTER TABLE CONTRATOQUESTIONARIOS
    ADD CONSTRAINT CONTRATOQUESTIONARIOS_PK PRIMARY KEY (IDCONTRATOQUESTIONARIO);

ALTER TABLE CONTRATOS
    ADD CONSTRAINT CONTRATOS_PK PRIMARY KEY (IDCONTRATO);

ALTER TABLE CONTRATOSCOLABORADORES
    ADD CONSTRAINT CONTRATOSCOLABORADORES_PK PRIMARY KEY (IDEMPREGADO,  IDCONTRATO);

ALTER TABLE CONTRATOSGRUPOS
    ADD CONSTRAINT CONTRATOSGRUPOS_PK PRIMARY KEY (IDGRUPO,  IDCONTRATO);

ALTER TABLE CONTROLEGED
    ADD CONSTRAINT CONTROLEGED_PK PRIMARY KEY (IDCONTROLEGED);

ALTER TABLE CONTROLEQUESTIONARIOS
    ADD CONSTRAINT CONTROLEQUESTIONARIOS_PK PRIMARY KEY (IDCONTROLEQUESTIONARIO);

ALTER TABLE DEMANDAS
    ADD CONSTRAINT DEMANDAS_PK PRIMARY KEY (IDDEMANDA);

ALTER TABLE EMAILSOLICITACAOSERVICO
    ADD CONSTRAINT EMAILSOLICITACAOSERVICO_PK PRIMARY KEY (IDEMAILSOLICITACAOSERVICO);

ALTER TABLE EMPREGADOITEMCONFIGURACAO
    ADD CONSTRAINT EMPREGADOITEMCONFIGURACAO_PK PRIMARY KEY (IDUSUARIO,  IDITEMCONFIGURACAO);

ALTER TABLE EMPREGADOS
    ADD CONSTRAINT EMPREGADOS_PK PRIMARY KEY (IDEMPREGADO);

ALTER TABLE EMPRESA
    ADD CONSTRAINT EMPRESA_PK PRIMARY KEY (IDEMPRESA);

ALTER TABLE ETAPAS
    ADD CONSTRAINT ETAPAS_PK PRIMARY KEY (IDETAPA);

ALTER TABLE EVENTO
    ADD CONSTRAINT EVENTO_PK PRIMARY KEY (IDEVENTO);

ALTER TABLE EVENTOEMPREGADO
    ADD CONSTRAINT EVENTOEMPREGADO_PK PRIMARY KEY (IDEVENTO,  IDEMPREGADO);

ALTER TABLE EXCECAOCALENDARIO
    ADD CONSTRAINT EXCECAOCALENDARIO_PK PRIMARY KEY (IDEXCECAOCALENDARIO);

ALTER TABLE EXCECAOEMPREGADO
    ADD CONSTRAINT EXCECAOEMPREGADO_PK PRIMARY KEY (IDEVENTO,  IDEMPREGADO);

ALTER TABLE EXECUCAOATIVIDADEPERIODICA
    ADD CONSTRAINT EXECUCAOATIVIDADEPERIODICA_PK PRIMARY KEY (IDEXECUCAOATIVIDADEPERIODICA);

ALTER TABLE EXECUCAOBATCH
    ADD CONSTRAINT EXECUCAOBATCH_PK PRIMARY KEY (IDEXECUCAOBATCH);

ALTER TABLE EXECUCAODEMANDA
    ADD CONSTRAINT EXECUCAODEMANDA_PK PRIMARY KEY (IDEXECUCAO);

ALTER TABLE EXECUCAOSOLICITACAO
    ADD CONSTRAINT EXECUCAOSOLICITACAO_PK PRIMARY KEY (IDEXECUCAO);

ALTER TABLE FASESERVICO
    ADD CONSTRAINT FASESERVICO_PK PRIMARY KEY (IDFASE);

ALTER TABLE FATURA
    ADD CONSTRAINT FATURA_PK PRIMARY KEY (IDFATURA);

ALTER TABLE FATURAAPURACAOANS
    ADD CONSTRAINT FATURAAPURACAOANS_PK PRIMARY KEY (IDFATURAAPURACAOANS);

ALTER TABLE FATURAOS
    ADD CONSTRAINT FATURAOS_PK PRIMARY KEY (IDFATURA,  IDOS);

ALTER TABLE FERIADO
    ADD CONSTRAINT FERIADO_PK PRIMARY KEY (IDFERIADO);

ALTER TABLE FLUXO
    ADD CONSTRAINT FLUXO_PK PRIMARY KEY (IDFLUXO);

ALTER TABLE FLUXOS
    ADD CONSTRAINT FLUXOS_PK PRIMARY KEY (IDFLUXO);

ALTER TABLE FLUXOSERVICO
    ADD CONSTRAINT FLUXOSERVICO_PK PRIMARY KEY (IDSERVICOCONTRATO,  IDTIPOFLUXO,  IDFASE);

ALTER TABLE FORMULA
    ADD CONSTRAINT FORMULA_IDENTIFICADOR_KEY UNIQUE (IDENTIFICADOR);

ALTER TABLE FORMULA
    ADD CONSTRAINT FORMULA_PK PRIMARY KEY (IDFORMULA);

ALTER TABLE GALERIAIMAGENS
    ADD CONSTRAINT GALERIAIMAGENS_PK PRIMARY KEY (IDIMAGEM);

ALTER TABLE GLOSAOS
    ADD CONSTRAINT GLOSAOS_PK PRIMARY KEY (IDGLOSAOS);

ALTER TABLE GRUPO
    ADD CONSTRAINT GRUPO_PK PRIMARY KEY (IDGRUPO);

ALTER TABLE GRUPOATVPERIODICA
    ADD CONSTRAINT GRUPOATVPERIODICA_PK PRIMARY KEY (IDGRUPOATVPERIODICA);

ALTER TABLE GRUPOQUESTIONARIO
    ADD CONSTRAINT GRUPOQUESTIONARIO_PK PRIMARY KEY (IDGRUPOQUESTIONARIO);

ALTER TABLE GRUPOSEMPREGADOS
    ADD CONSTRAINT GRUPOSEMPREGADOS_PK PRIMARY KEY (IDGRUPO,  IDEMPREGADO);

ALTER TABLE GRUPOVISAO
    ADD CONSTRAINT GRUPOVISAO_PK PRIMARY KEY (IDGRUPOVISAO);

ALTER TABLE GRUPOVISAOCAMPOSNEGOCIO
    ADD CONSTRAINT GRUPOVISAOCAMPOSNEGOCIO_PK PRIMARY KEY (IDGRUPOVISAO,  IDCAMPOSOBJETONEGOCIO);

ALTER TABLE GRUPOVISAOCAMPOSNEGOCIOINFOSQL
    ADD CONSTRAINT GRPVISCAMPOSNEGINFOSQL_PK  PRIMARY KEY (IDGRPVISCAMPOSNEGINFOSQL);

ALTER TABLE GRUPOVISAOCAMPOSNEGOCIOLIGACAO
    ADD CONSTRAINT GRPVISCAMPOSNEGLIGACAO_PK  PRIMARY KEY (IDGRPVISCAMPOSNEGLIGACA);

ALTER TABLE HILOSEQUENCES
    ADD CONSTRAINT HILOSEQUENCES_PK PRIMARY KEY (SEQUENCENAME);

ALTER TABLE HISTORICOEXECUCAO
    ADD CONSTRAINT HISTORICOEXECUCAO_PK PRIMARY KEY (IDHISTORICO);

ALTER TABLE HISTORICOTENTATIVA
    ADD CONSTRAINT HISTORICOTENTATIVA_PK PRIMARY KEY (IDHISTORICOTENTATIVA);

ALTER TABLE HTMLCODEVISAO
    ADD CONSTRAINT HTMLCODEVISAO_PK PRIMARY KEY (IDHTMLCODEVISAO);

ALTER TABLE IMAGEMHISTORICO
    ADD CONSTRAINT IMAGEMHISTORICO_PK PRIMARY KEY (IDIMAGEM);

ALTER TABLE IMAGEMITEMCONFIGURACAO
    ADD CONSTRAINT IMAGEMITEMCONFIGURACAO_PK PRIMARY KEY (IDIMAGEMITEMCONFIGURACAO);

ALTER TABLE IMPORTANCIANEGOCIO
    ADD CONSTRAINT IMPORTANCIANEGOCIO_PK PRIMARY KEY (IDIMPORTANCIANEGOCIO);

ALTER TABLE INFORMACAOSERVICO
    ADD CONSTRAINT INFORMACAOSERVICO_PK PRIMARY KEY (IDINFORMACAOSERVICO);

ALTER TABLE INFORMACOESCONTRATOCONFIG
    ADD CONSTRAINT INFORMACOESCONTRATOCONFIG_PK PRIMARY KEY (IDINFORMACOESCONTRATOCONFIG);

ALTER TABLE INFORMACOESCONTRATOPERFSEG
    ADD CONSTRAINT INFORMACOESCONTRATOPERFSEG_PK PRIMARY KEY (IDINFORMACOESCONTRATOCONFIG,  IDPERFILSEGURANCA);

ALTER TABLE INVENTARIOXML
    ADD CONSTRAINT INVENTARIOXML_PK PRIMARY KEY (IDINVENTARIOXML);

ALTER TABLE ITEMCONFIGURACAO
    ADD CONSTRAINT ITEMCONFIGURACAO_PK PRIMARY KEY (IDITEMCONFIGURACAO);

ALTER TABLE JMS_ROLES
    ADD CONSTRAINT JMS_ROLES_PK PRIMARY KEY (USERID,  ROLEID);

ALTER TABLE JMS_SUBSCRIPTIONS
    ADD CONSTRAINT JMS_SUBSCRIPTIONS_PK PRIMARY KEY (CLIENTID,  SUBNAME);

ALTER TABLE JMS_USERS
    ADD CONSTRAINT JMS_USERS_PK PRIMARY KEY (USERID);

ALTER TABLE JORNADATRABALHO
    ADD CONSTRAINT JORNADATRABALHO_PK PRIMARY KEY (IDJORNADA);

ALTER TABLE JUSTIFICACAOFALHA
    ADD CONSTRAINT JUSTIFICACAOFALHA_PK PRIMARY KEY (IDJUSTIFICACAOFALHA);

ALTER TABLE JUSTIFICATIVASOLICITACAO
    ADD CONSTRAINT JUSTIFICATIVASOLICITACAO_PK PRIMARY KEY (IDJUSTIFICATIVA);

ALTER TABLE LOCALEXECUCAOSERVICO
    ADD CONSTRAINT LOCALEXECUCAOSERVICO_PK PRIMARY KEY (IDLOCALEXECUCAOSERVICO);

ALTER TABLE LOGDADOS
    ADD CONSTRAINT LOGDADOS_PK PRIMARY KEY (IDLOG);

ALTER TABLE MENU
    ADD CONSTRAINT MENU_PK PRIMARY KEY (IDMENU);

ALTER TABLE MEUCATALOGO
    ADD CONSTRAINT MEUCATALOGO_PK PRIMARY KEY (IDUSUARIO,  IDSERVICO);

ALTER TABLE MODELOSEMAILS
    ADD CONSTRAINT MODELOSEMAILS_PK PRIMARY KEY (IDMODELOEMAIL);

ALTER TABLE MOEDAS
    ADD CONSTRAINT MOEDAS_PK PRIMARY KEY (IDMOEDA);

ALTER TABLE MOTIVOSUSPENSAOATIVID
    ADD CONSTRAINT MOTIVOSUSPENSAOATIVID_PK PRIMARY KEY (IDMOTIVO);

ALTER TABLE NETMAP
    ADD CONSTRAINT NETMAP_PK PRIMARY KEY (IDNETMAP);

ALTER TABLE OBJETONEGOCIO
    ADD CONSTRAINT OBJETONEGOCIO_PK PRIMARY KEY (IDOBJETONEGOCIO);

ALTER TABLE OCORRENCIAS
    ADD CONSTRAINT OCORRENCIAS_PK PRIMARY KEY (IDOCORRENCIA);

ALTER TABLE OCORRENCIASOLICITACAO
    ADD CONSTRAINT OCORRENCIASOLICITACAO_PK PRIMARY KEY (IDOCORRENCIA);

ALTER TABLE OPCAORESPOSTAQUESTIONARIO
    ADD CONSTRAINT OPCAORESPOSTAQUESTIONARIO_PK PRIMARY KEY (IDOPCAORESPOSTAQUESTIONARIO);

ALTER TABLE OPINIAO
    ADD CONSTRAINT OPINIAO_PK PRIMARY KEY (IDOPINIAO);

ALTER TABLE ORIGEMATENDIMENTO
    ADD CONSTRAINT ORIGEMATENDIMENTO_PK PRIMARY KEY (IDORIGEM);

ALTER TABLE OS
    ADD CONSTRAINT OS_PK PRIMARY KEY (IDOS);

ALTER TABLE PALAVRAGEMEA
    ADD CONSTRAINT PALAVRAGEMEA_PK PRIMARY KEY (IDPALAVRAGEMEA);

ALTER TABLE PARAMETROCORPORE
    ADD CONSTRAINT PARAMETROCORPORE_PK PRIMARY KEY (IDPARAMETROCORPORE);

ALTER TABLE PARAMETROSCONTRATO
    ADD CONSTRAINT PARAMETROSCONTRATO_PK PRIMARY KEY (IDCONTRATO,  NOMEPARAMETRO);

ALTER TABLE PASTA
    ADD CONSTRAINT PASTA_PK PRIMARY KEY (IDPASTA);

ALTER TABLE PERFILACESSO
    ADD CONSTRAINT PERFILACESSO_PK PRIMARY KEY (IDPERFIL);

ALTER TABLE PERFILACESSOGRUPO
    ADD CONSTRAINT PERFILACESSOGRUPO_PK PRIMARY KEY (IDPERFIL,  IDGRUPO);

ALTER TABLE PERFILACESSOPASTA
    ADD CONSTRAINT PERFILACESSOPASTA_PK PRIMARY KEY (IDPERFIL,  IDPASTA);

ALTER TABLE PERFILACESSOSITUACAOFATURA
    ADD CONSTRAINT PERFILACESSOSITUACAOFATURA_PK PRIMARY KEY (IDPERFIL,  SITUACAOFATURA);

ALTER TABLE PERFILACESSOSITUACAOOS
    ADD CONSTRAINT PERFILACESSOSITUACAOOS_PK PRIMARY KEY (IDPERFIL,  SITUACAOOS);

ALTER TABLE PERFILACESSOUSUARIO
    ADD CONSTRAINT PERFILACESSOUSUARIO_PK PRIMARY KEY (IDUSUARIO,  IDPERFIL);

ALTER TABLE PERFILSEGURANCA
    ADD CONSTRAINT PERFILSEGURANCA_PK PRIMARY KEY (IDPERFILSEGURANCA);

ALTER TABLE PERMISSOESFLUXO
    ADD CONSTRAINT PERMISSOESFLUXO_PK PRIMARY KEY (IDGRUPO,  IDTIPOFLUXO);

ALTER TABLE PESQUISASATISFACAO
    ADD CONSTRAINT PESQUISASATISFACAO_PK PRIMARY KEY (IDPESQUISASATISFACAO);

ALTER TABLE PORTAL
    ADD CONSTRAINT PORTAL_PK PRIMARY KEY (IDPORTAL);

ALTER TABLE PRIORIDADE
    ADD CONSTRAINT PRIORIDADE_PK PRIMARY KEY (IDPRIORIDADE);

ALTER TABLE PRIORIDADEACORDONIVELSERVICO
    ADD CONSTRAINT PRIORIACORDNIVELSERV_PK  PRIMARY KEY (IDUNIDADE,  IDACORDONIVELSERVICO);

ALTER TABLE PRIORIDADESERVICOUNIDADE
    ADD CONSTRAINT PRIORIDADESERVICOUNIDADE_PK PRIMARY KEY (IDUNIDADE,  IDSERVICOCONTRATO);

ALTER TABLE PROBLEMA
    ADD CONSTRAINT PROBLEMA_PK PRIMARY KEY (IDPROBLEMA);

ALTER TABLE PROBLEMAITEMCONFIGURACAO
    ADD CONSTRAINT PROBLEMAITEMCONFIGURACAO_PK PRIMARY KEY (IDPROBLEMAITEMCONFIGURACAO);

ALTER TABLE PROBLEMAMUDANCA
    ADD CONSTRAINT PROBLEMAMUDANCA_PK PRIMARY KEY (IDPROBLEMAMUDANCA);

ALTER TABLE PROCEDIMENTOTECNICO
    ADD CONSTRAINT PROCEDIMENTOTECNICO_PK PRIMARY KEY (IDPROCEDIMENTOTECNICO);

ALTER TABLE PROCESSAMENTOBATCH
    ADD CONSTRAINT PROCESSAMENTOBATCH_PK PRIMARY KEY (IDPROCESSAMENTOBATCH);

ALTER TABLE PROGRAMACAOATIVIDADE
    ADD CONSTRAINT PROGRAMACAOATIVIDADE_PK PRIMARY KEY (IDPROGRAMACAOATIVIDADE);

ALTER TABLE PROJETOS
    ADD CONSTRAINT PROJETOS_PK PRIMARY KEY (IDPROJETO);

ALTER TABLE QUESTAOQUESTIONARIO
    ADD CONSTRAINT QUESTAOQUESTIONARIO_PK PRIMARY KEY (IDQUESTAOQUESTIONARIO);

ALTER TABLE QUESTIONARIO
    ADD CONSTRAINT QUESTIONARIO_PK PRIMARY KEY (IDQUESTIONARIO);

ALTER TABLE REABERTURASOLICITACAO
    ADD CONSTRAINT REABERTURASOLICITACAO_PK PRIMARY KEY (IDSOLICITACAOSERVICO,  SEQREABERTURA);

ALTER TABLE REGIOES
    ADD CONSTRAINT REGIOES_NOME_KEY UNIQUE (NOME);

ALTER TABLE REGIOES
    ADD CONSTRAINT REGIOES_PK PRIMARY KEY (IDREGIOES);

ALTER TABLE RELACOBJETONEGOCIO
    ADD CONSTRAINT RELACOBJETONEGOCIO_PK PRIMARY KEY (IDRELACOBJETONEGOCIO);

ALTER TABLE RESPONSABILIDADE
    ADD CONSTRAINT RESPONSABILIDADE_PK PRIMARY KEY (IDRESPONSABILIDADE);

ALTER TABLE RESPOSTAITEMQUESTIONARIO
    ADD CONSTRAINT RESPOSTAITEMQUESTIONARIO_PK PRIMARY KEY (IDRESPOSTAITEMQUESTIONARIO);

ALTER TABLE RESPOSTAITEMQUESTIONARIOANEXOS
    ADD CONSTRAINT RESPITEMQUESTOANEXOS_PK  PRIMARY KEY (IDRESPOSTAITMQUESTIONARIOANEXO);

ALTER TABLE RESPOSTAITEMQUESTIONARIOCIDS
    ADD CONSTRAINT RESPITEMQUESTCIDS_PK  PRIMARY KEY (IDRESPOSTAITEMQUESTIONARIOCID);

ALTER TABLE RESPOSTAITEMQUESTIONARIOOPCOES
    ADD CONSTRAINT RESPITEMQUESTOPCOES_PK  PRIMARY KEY (IDRESPOSTAITEMQUESTIONARIO,  IDOPCAORESPOSTAQUESTIONARIO);

ALTER TABLE SCRIPTSVISAO
    ADD CONSTRAINT SCRIPTSVISAO_PK PRIMARY KEY (IDSCRIPTSVISAO);

ALTER TABLE SERVICO
    ADD CONSTRAINT SERVICO_PK PRIMARY KEY (IDSERVICO);

ALTER TABLE SERVICOCONTRATO
    ADD CONSTRAINT SERVICOCONTRATO_PK PRIMARY KEY (IDSERVICOCONTRATO);

ALTER TABLE SISTEMAOPERACIONAL
    ADD CONSTRAINT SISTEMAOPERACIONAL_PK PRIMARY KEY (ID);

ALTER TABLE SITUACAODEMANDA
    ADD CONSTRAINT SITUACAODEMANDA_PK PRIMARY KEY (IDSITUACAODEMANDA);

ALTER TABLE SITUACAOSERVICO
    ADD CONSTRAINT SITUACAOSERVICO_PK PRIMARY KEY (IDSITUACAOSERVICO);

ALTER TABLE SOLICITACAOSERVICO
    ADD CONSTRAINT SOLICITACAOSERVICO_PK PRIMARY KEY (IDSOLICITACAOSERVICO);

ALTER TABLE TEMPOACORDONIVELSERVICO
    ADD CONSTRAINT TEMPOACORDONIVELSERVICO_PK PRIMARY KEY (IDACORDONIVELSERVICO,  IDPRIORIDADE,  IDFASE);

ALTER TABLE TESTE
    ADD CONSTRAINT TESTE_PK PRIMARY KEY (IDTESTE);

ALTER TABLE TIMERS
    ADD CONSTRAINT TIMERS_PK PRIMARY KEY (TIMERID,  TARGETID);

ALTER TABLE TIMESHEET
    ADD CONSTRAINT TIMESHEET_PK PRIMARY KEY (IDTIMESHEET);

ALTER TABLE TIPODEMANDA
    ADD CONSTRAINT TIPODEMANDA_PK PRIMARY KEY (IDTIPODEMANDA);

ALTER TABLE TIPODEMANDASERVICO
    ADD CONSTRAINT TIPODEMANDASERVICO_PK PRIMARY KEY (IDTIPODEMANDASERVICO);

ALTER TABLE TIPOEVENTOSERVICO
    ADD CONSTRAINT TIPOEVENTOSERVICO_PK PRIMARY KEY (IDTIPOEVENTOSERVICO);

ALTER TABLE TIPOITEMCFGCARACTERISTICA
    ADD CONSTRAINT TIPOITEMCFGCARACTERISTICA_PK PRIMARY KEY (ID);

ALTER TABLE TIPOITEMCONFIGURACAO
    ADD CONSTRAINT TIPOITEMCONFIGURACAO_PK PRIMARY KEY (IDTIPOITEMCONFIGURACAO);

ALTER TABLE TIPOOS
    ADD CONSTRAINT TIPOOS_PK PRIMARY KEY (IDCLASSIFICACAOOS);

ALTER TABLE TIPOPROBLEMAATENDIMENTO
    ADD CONSTRAINT TIPOPROBLEMAATENDIMENTO_PK PRIMARY KEY (IDTIPOPROBLEMA);

ALTER TABLE TIPOSATIVIDADES
    ADD CONSTRAINT TIPOSATIVIDADES_PK PRIMARY KEY (IDTIPOATIVIDADE);

ALTER TABLE TIPOSERVICO
    ADD CONSTRAINT TIPOSERVICO_PK PRIMARY KEY (IDTIPOSERVICO);

ALTER TABLE TIPOUNIDADE
    ADD CONSTRAINT TIPOUNIDADE_PK PRIMARY KEY (IDTIPOUNIDADE);

ALTER TABLE UFS
    ADD CONSTRAINT UFS_PK PRIMARY KEY (IDUF);

ALTER TABLE UNIDADE
    ADD CONSTRAINT UNIDADE_PK PRIMARY KEY (IDUNIDADE);

ALTER TABLE UNIDADEBASEITEMCONFIGURACAO
    ADD CONSTRAINT UNIDADEBASEITEMCONFIGURACAO_PK PRIMARY KEY (IDBASEITEMCONFIGURACAO);

ALTER TABLE UNIDADESACCSERVICOS
    ADD CONSTRAINT UNIDADESACCSERVICOS_PK PRIMARY KEY (IDUNIDADE,  IDSERVICO);

ALTER TABLE USUARIO
    ADD CONSTRAINT USUARIO_PK PRIMARY KEY (IDUSUARIO);

ALTER TABLE USUARIOITEMCONFIGURACAO
    ADD CONSTRAINT USUARIOITEMCONFIGURACAO_PK PRIMARY KEY (IDUSUARIO,  IDITEMCONFIGURACAO);

ALTER TABLE VALOR
    ADD CONSTRAINT VALOR_PK PRIMARY KEY (IDVALOR);

ALTER TABLE VALORVISAOCAMPOSNEGOCIO
    ADD CONSTRAINT VALORVISAOCAMPOSNEGOCIO_PK PRIMARY KEY (IDVALORVISAOCAMPOSNEGOCIO);

ALTER TABLE VINCULOVISAO
    ADD CONSTRAINT VINCULOVISAO_PK PRIMARY KEY (IDVISAORELACIONADA,  SEQ);

ALTER TABLE VISAO
    ADD CONSTRAINT VISAO_PK PRIMARY KEY (IDVISAO);

ALTER TABLE VISAORELACIONADA
    ADD CONSTRAINT VISAORELACIONADA_PK PRIMARY KEY (IDVISAORELACIONADA);


-- CRIACAO DE CHAVES ESTRANGEIRAS
-- SCRIPT DE ORIGEM: 03 - fks_citsmart.sql

-- CONSTRAINT FK_REFERENCE_33 DA TABELA PERMISSOESFLUXO ALTERADA PARA FK_PERMISSOESFLUXO_33 
-- CONSTRAINT FK_REFERENCE_102 DA TABELA HISTORICOTENTATIVA ALTERADA PARA FK_HISTORICOTENTATIVA_102
-- CONSTRAINT FK_REFERENCE_78 DA TABELA VISAORELACIONADA ALTERADA PARA FK_VISAORELACIONADA_78
-- CONSTRAINT FK_SOLICITACAOSERVICO_TIPODEMANDA DA TABELA SOLICITACAOSERVICO ALTERADA PARA FK_SOLICITSERV_TPDEMANDA 
-- CONSTRAINT FK_REFERENCE_90 DA TABELA VISAORELACIONADA ALTERADA PARA FK_VISAORELACIONADA_90
-- CONSTRAINT FK_REFERENCE_44 DA TABELA IMAGEMITEMCONFIGURACAO NAO FOI CRIADA POR JÁ EXISTIR TAL RESTRICAO
-- CONSTRAINT FK_REFERENCE_45 DA TABELA SERVICOCONTRATO  NAO FOI CRIADA POR JÁ EXISTIR TAL RESTRICAO
-- CONSTRAINT FK_REFERENCE_46 DA TABELA INFORMACAOSERVICO  NAO FOI CRIADA POR JÁ EXISTIR TAL RESTRICAO
-- CONSTRAINT FK_REFERENCE_530 DA TABELA SOLICITACAOSERVICO  NAO FOI CRIADA POR JÁ EXISTIR TAL RESTRICAO
-- CONSTRAINT FK_REFERENCE_546 DA TABELA USUARIO  NAO FOI CRIADA POR JÁ EXISTIR TAL RESTRICAO

ALTER TABLE  UNIDADE
    ADD CONSTRAINT DEP_DEP FOREIGN KEY (IDUNIDADEPAI) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  ITEMCONFIGURACAO
    ADD CONSTRAINT FK_ASSOCIATION12 FOREIGN KEY (IDITEMCONFIGURACAOPAI) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  COMENTARIOS
    ADD CONSTRAINT FK_COMENTARIO_BASECONHECIMENTO FOREIGN KEY (IDBASECONHECIMENTO) REFERENCES BASECONHECIMENTO(IDBASECONHECIMENTO);

ALTER TABLE  JUSTIFICACAOFALHA
    ADD CONSTRAINT FK_REFERENCE_1 FOREIGN KEY (IDHISTORICOTENTATIVA) REFERENCES HISTORICOTENTATIVA(IDHISTORICOTENTATIVA);

ALTER TABLE  BASEITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_100 FOREIGN KEY (IDTIPOITEMCONFIGURACAO) REFERENCES TIPOITEMCONFIGURACAO(IDTIPOITEMCONFIGURACAO);

ALTER TABLE  ITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_101 FOREIGN KEY (IDTIPOITEMCONFIGURACAO) REFERENCES TIPOITEMCONFIGURACAO(IDTIPOITEMCONFIGURACAO);

ALTER TABLE  ACORDONIVELSERVICO
    ADD CONSTRAINT FK_REFERENCE_102 FOREIGN KEY (IDPRIORIDADEPADRAO) REFERENCES PRIORIDADE(IDPRIORIDADE);

ALTER TABLE  HISTORICOTENTATIVA
    ADD CONSTRAINT FK_HISTORICOTENTATIVA_102 FOREIGN KEY (IDEVENTO) REFERENCES EVENTO(IDEVENTO);

ALTER TABLE  EVENTOUNIDADE
    ADD CONSTRAINT FK_REFERENCE_103 FOREIGN KEY (IDEVENTO) REFERENCES EVENTO(IDEVENTO);

ALTER TABLE  ITEMCONFIGURACAOEVENTO
    ADD CONSTRAINT FK_REFERENCE_104 FOREIGN KEY (IDEVENTO) REFERENCES EVENTO(IDEVENTO);

ALTER TABLE  EXCECAOEMPREGADO
    ADD CONSTRAINT FK_REFERENCE_105 FOREIGN KEY (IDEVENTO) REFERENCES EVENTO(IDEVENTO);

ALTER TABLE  EVENTOGRUPO
    ADD CONSTRAINT FK_REFERENCE_106 FOREIGN KEY (IDEVENTO) REFERENCES EVENTO(IDEVENTO);

ALTER TABLE  JUSTIFICACAOFALHA
    ADD CONSTRAINT FK_REFERENCE_107 FOREIGN KEY (IDEVENTO) REFERENCES EVENTO(IDEVENTO);

ALTER TABLE  EVENTOEMPREGADO
    ADD CONSTRAINT FK_REFERENCE_108 FOREIGN KEY (IDEVENTO) REFERENCES EVENTO(IDEVENTO);

ALTER TABLE  PERFILACESSOMENU
    ADD CONSTRAINT FK_REFERENCE_109 FOREIGN KEY (IDMENU) REFERENCES MENU(IDMENU);

ALTER TABLE  IMAGEMITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_110 FOREIGN KEY (IDSERVICO) REFERENCES SERVICO(IDSERVICO);

ALTER TABLE  SERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_111 FOREIGN KEY (IDSERVICO) REFERENCES SERVICO(IDSERVICO);

ALTER TABLE  INFORMACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_112 FOREIGN KEY (IDSERVICO) REFERENCES SERVICO(IDSERVICO);

ALTER TABLE  UFS
    ADD CONSTRAINT FK_REFERENCE_113 FOREIGN KEY (IDREGIOES) REFERENCES REGIOES(IDREGIOES);

ALTER TABLE  RESPOSTAITEMQUESTIONARIOOPCOES
    ADD CONSTRAINT FK_REFERENCE_115 FOREIGN KEY (IDOPCAORESPOSTAQUESTIONARIO) REFERENCES OPCAORESPOSTAQUESTIONARIO(IDOPCAORESPOSTAQUESTIONARIO);

ALTER TABLE  BPM_ITEMTRABALHOFLUXO
    ADD CONSTRAINT FK_REFERENCE_116 FOREIGN KEY (IDINSTANCIA) REFERENCES BPM_INSTANCIAFLUXO(IDINSTANCIA);

ALTER TABLE  BPM_OBJETOINSTANCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_117 FOREIGN KEY (IDINSTANCIA) REFERENCES BPM_INSTANCIAFLUXO(IDINSTANCIA);

ALTER TABLE  UNIDADE
    ADD CONSTRAINT FK_REFERENCE_118 FOREIGN KEY (IDTIPOUNIDADE) REFERENCES TIPOUNIDADE(IDTIPOUNIDADE);

ALTER TABLE  BPM_ITEMTRABALHOFLUXO
    ADD CONSTRAINT FK_REFERENCE_119 FOREIGN KEY (IDELEMENTO) REFERENCES BPM_ELEMENTOFLUXO(IDELEMENTO);

ALTER TABLE  ANEXOBASECONHECIMENTO
    ADD CONSTRAINT FK_REFERENCE_131 FOREIGN KEY (IDBASECONHECIMENTO) REFERENCES BASECONHECIMENTO(IDBASECONHECIMENTO);

ALTER TABLE  FERIADO
    ADD CONSTRAINT FK_REFERENCE_132 FOREIGN KEY (IDUF) REFERENCES UFS(IDUF);

ALTER TABLE  CIDADES
    ADD CONSTRAINT FK_REFERENCE_134 FOREIGN KEY (IDUF) REFERENCES UFS(IDUF);

ALTER TABLE  EXECUCAOSOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_135 FOREIGN KEY (IDFASE) REFERENCES FASESERVICO(IDFASE);

ALTER TABLE  TEMPOACORDONIVELSERVICO
    ADD CONSTRAINT FK_REFERENCE_136 FOREIGN KEY (IDFASE) REFERENCES FASESERVICO(IDFASE);

ALTER TABLE  FLUXOSERVICO
    ADD CONSTRAINT FK_REFERENCE_137 FOREIGN KEY (IDFASE) REFERENCES FASESERVICO(IDFASE);

ALTER TABLE  VALORVISAOCAMPOSNEGOCIO
    ADD CONSTRAINT FK_REFERENCE_154 FOREIGN KEY (IDGRUPOVISAO,  IDCAMPOSOBJETONEGOCIO) 
	REFERENCES GRUPOVISAOCAMPOSNEGOCIO(IDGRUPOVISAO,  IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  GRUPOVISAOCAMPOSNEGOCIOINFOSQL
    ADD CONSTRAINT FK_REFERENCE_155 FOREIGN KEY (IDGRUPOVISAO,  IDCAMPOSOBJETONEGOCIO) 
	REFERENCES GRUPOVISAOCAMPOSNEGOCIO(IDGRUPOVISAO,  IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  GRUPOVISAOCAMPOSNEGOCIOLIGACAO
    ADD CONSTRAINT FK_REFERENCE_156 FOREIGN KEY (IDGRUPOVISAO,  IDCAMPOSOBJETONEGOCIO) 
	REFERENCES GRUPOVISAOCAMPOSNEGOCIO(IDGRUPOVISAO,  IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  PERFILACESSOUSUARIO
    ADD CONSTRAINT FK_REFERENCE_157 FOREIGN KEY (IDPERFIL) REFERENCES PERFILACESSO(IDPERFIL);

ALTER TABLE  PERFILACESSOPASTA
    ADD CONSTRAINT FK_REFERENCE_158 FOREIGN KEY (IDPERFIL) REFERENCES PERFILACESSO(IDPERFIL);

ALTER TABLE  PERFILACESSOGRUPO
    ADD CONSTRAINT FK_REFERENCE_159 FOREIGN KEY (IDPERFIL) REFERENCES PERFILACESSO(IDPERFIL);

ALTER TABLE  SERVICO
    ADD CONSTRAINT FK_REFERENCE_16 FOREIGN KEY (IDTIPOEVENTOSERVICO) REFERENCES TIPOEVENTOSERVICO(IDTIPOEVENTOSERVICO);

ALTER TABLE  HISTORICOTENTATIVA
    ADD CONSTRAINT FK_REFERENCE_160 FOREIGN KEY (IDBASEITEMCONFIGURACAO) REFERENCES BASEITEMCONFIGURACAO(IDBASEITEMCONFIGURACAO);

ALTER TABLE  VALOR
    ADD CONSTRAINT FK_REFERENCE_161 FOREIGN KEY (IDBASEITEMCONFIGURACAO) REFERENCES BASEITEMCONFIGURACAO(IDBASEITEMCONFIGURACAO);

ALTER TABLE  ITEMCONFIGURACAOEVENTO
    ADD CONSTRAINT FK_REFERENCE_162 FOREIGN KEY (IDBASEITEMCONFIGURACAO) REFERENCES BASEITEMCONFIGURACAO(IDBASEITEMCONFIGURACAO);

ALTER TABLE  JUSTIFICACAOFALHA
    ADD CONSTRAINT FK_REFERENCE_163 FOREIGN KEY (IDBASEITEMCONFIGURACAO) REFERENCES BASEITEMCONFIGURACAO(IDBASEITEMCONFIGURACAO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_164 FOREIGN KEY (IDUNIDADE,  IDSERVICOCONTRATO) REFERENCES PRIORIDADESERVICOUNIDADE(IDUNIDADE,  IDSERVICOCONTRATO);

ALTER TABLE  PERFILACESSOUSUARIO
    ADD CONSTRAINT FK_REFERENCE_165 FOREIGN KEY (IDUSUARIO) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  AUDITORIA
    ADD CONSTRAINT FK_REFERENCE_166 FOREIGN KEY (IDUSUARIO) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  BPM_ATRIBUICAOFLUXO
    ADD CONSTRAINT FK_REFERENCE_167 FOREIGN KEY (IDUSUARIO) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  USUARIOITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_168 FOREIGN KEY (IDUSUARIO) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  EMPREGADOITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_169 FOREIGN KEY (IDUSUARIO) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  ITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_170 FOREIGN KEY (IDUSUARIO) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  INFORMACOESCONTRATOPERFSEG
    ADD CONSTRAINT FK_REFERENCE_171 FOREIGN KEY (IDPERFILSEGURANCA) REFERENCES PERFILSEGURANCA(IDPERFILSEGURANCA);

ALTER TABLE  CONTROLEGED
    ADD CONSTRAINT FK_REFERENCE_172 FOREIGN KEY (ID) REFERENCES COMANDO(ID);

ALTER TABLE  INFORMACOESCONTRATOPERFSEG
    ADD CONSTRAINT FK_REFERENCE_173 FOREIGN KEY (IDINFORMACOESCONTRATOCONFIG) REFERENCES INFORMACOESCONTRATOCONFIG(IDINFORMACOESCONTRATOCONFIG);

ALTER TABLE  HISTORICOTENTATIVA
    ADD CONSTRAINT FK_REFERENCE_174 FOREIGN KEY (IDEVENTO,  IDEMPREGADO) REFERENCES EXCECAOEMPREGADO(IDEVENTO,  IDEMPREGADO);

ALTER TABLE  JUSTIFICACAOFALHA
    ADD CONSTRAINT FK_REFERENCE_175 FOREIGN KEY (IDEVENTO,  IDEMPREGADO) REFERENCES EXCECAOEMPREGADO(IDEVENTO,  IDEMPREGADO);

ALTER TABLE  OPCAORESPOSTAQUESTIONARIO
    ADD CONSTRAINT FK_REFERENCE_176 FOREIGN KEY (IDQUESTAOQUESTIONARIO) REFERENCES QUESTAOQUESTIONARIO(IDQUESTAOQUESTIONARIO);

ALTER TABLE  RESPOSTAITEMQUESTIONARIO
    ADD CONSTRAINT FK_REFERENCE_177 FOREIGN KEY (IDQUESTAOQUESTIONARIO) REFERENCES QUESTAOQUESTIONARIO(IDQUESTAOQUESTIONARIO);

ALTER TABLE  TEMPOACORDONIVELSERVICO
    ADD CONSTRAINT FK_REFERENCE_178 FOREIGN KEY (IDACORDONIVELSERVICO) REFERENCES ACORDONIVELSERVICO(IDACORDONIVELSERVICO);

ALTER TABLE  SERVICO
    ADD CONSTRAINT FK_REFERENCE_179 FOREIGN KEY (IDTIPODEMANDASERVICO) REFERENCES TIPODEMANDASERVICO(IDTIPODEMANDASERVICO);

ALTER TABLE  VALORVISAOCAMPOSNEGOCIO
    ADD CONSTRAINT FK_REFERENCE_180 FOREIGN KEY (IDCAMPOSOBJETONEGOCIO) REFERENCES CAMPOSOBJETONEGOCIO(IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  GRUPOVISAOCAMPOSNEGOCIO
    ADD CONSTRAINT FK_REFERENCE_181 FOREIGN KEY (IDCAMPOSOBJETONEGOCIO) REFERENCES CAMPOSOBJETONEGOCIO(IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  GRUPOVISAOCAMPOSNEGOCIOINFOSQL
    ADD CONSTRAINT FK_REFERENCE_182 FOREIGN KEY (IDCAMPOSOBJETONEGOCIO) REFERENCES CAMPOSOBJETONEGOCIO(IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  GRUPOVISAOCAMPOSNEGOCIOLIGACAO
    ADD CONSTRAINT FK_REFERENCE_183 FOREIGN KEY (IDCAMPOSOBJETONEGOCIO) REFERENCES CAMPOSOBJETONEGOCIO(IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  BASECONHECIMENTO
    ADD CONSTRAINT FK_REFERENCE_198 FOREIGN KEY (IDPASTA) REFERENCES PASTA(IDPASTA);

ALTER TABLE  PERFILACESSOPASTA
    ADD CONSTRAINT FK_REFERENCE_199 FOREIGN KEY (IDPASTA) REFERENCES PASTA(IDPASTA);

ALTER TABLE  OS
    ADD CONSTRAINT FK_REFERENCE_2 FOREIGN KEY (IDCLASSIFICACAOOS) REFERENCES TIPOOS(IDCLASSIFICACAOOS);

ALTER TABLE  CONTROLEGED
    ADD CONSTRAINT FK_REFERENCE_200 FOREIGN KEY (ID) REFERENCES COMANDOSISTEMAOPERACIONAL(ID);

ALTER TABLE  DEMANDAS
    ADD CONSTRAINT FK_REFERENCE_208 FOREIGN KEY (IDPROJETO) REFERENCES PROJETOS(IDPROJETO);

ALTER TABLE  TIMESHEET
    ADD CONSTRAINT FK_REFERENCE_209 FOREIGN KEY (IDPROJETO) REFERENCES PROJETOS(IDPROJETO);

ALTER TABLE  CONTRATOS
    ADD CONSTRAINT FK_REFERENCE_217 FOREIGN KEY (IDMOEDA) REFERENCES MOEDAS(IDMOEDA);

ALTER TABLE  DEMANDAS
    ADD CONSTRAINT FK_REFERENCE_232 FOREIGN KEY (IDSITUACAODEMANDA) REFERENCES SITUACAODEMANDA(IDSITUACAODEMANDA);

ALTER TABLE  SERVICO
    ADD CONSTRAINT FK_REFERENCE_256 FOREIGN KEY (IDSITUACAOSERVICO) REFERENCES SITUACAOSERVICO(IDSITUACAOSERVICO);

ALTER TABLE  QUESTAOQUESTIONARIO
    ADD CONSTRAINT FK_REFERENCE_257 FOREIGN KEY (IDIMAGEM) REFERENCES IMAGEMHISTORICO(IDIMAGEM);

ALTER TABLE  CONTRATOQUESTIONARIOS
    ADD CONSTRAINT FK_REFERENCE_258 FOREIGN KEY (IDQUESTIONARIO) REFERENCES QUESTIONARIO(IDQUESTIONARIO);

ALTER TABLE  INFORMACOESCONTRATOCONFIG
    ADD CONSTRAINT FK_REFERENCE_259 FOREIGN KEY (IDQUESTIONARIO) REFERENCES QUESTIONARIO(IDQUESTIONARIO);

ALTER TABLE  GRUPOQUESTIONARIO
    ADD CONSTRAINT FK_REFERENCE_260 FOREIGN KEY (IDQUESTIONARIO) REFERENCES QUESTIONARIO(IDQUESTIONARIO);

ALTER TABLE  GRUPOSEMPREGADOS
    ADD CONSTRAINT FK_REFERENCE_261 FOREIGN KEY (IDGRUPO) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  EXCECAOEMPREGADO
    ADD CONSTRAINT FK_REFERENCE_263 FOREIGN KEY (IDGRUPO) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  PERFILACESSOGRUPO
    ADD CONSTRAINT FK_REFERENCE_265 FOREIGN KEY (IDGRUPO) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  PERMISSOESFLUXO
    ADD CONSTRAINT FK_REFERENCE_266 FOREIGN KEY (IDGRUPO) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  EVENTOGRUPO
    ADD CONSTRAINT FK_REFERENCE_268 FOREIGN KEY (IDGRUPO) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  EVENTOEMPREGADO
    ADD CONSTRAINT FK_REFERENCE_270 FOREIGN KEY (IDGRUPO) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  JMS_ROLES
    ADD CONSTRAINT FK_REFERENCE_271 FOREIGN KEY (USERID) REFERENCES JMS_USERS(USERID);

ALTER TABLE  EXECUCAOSOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_280 FOREIGN KEY (IDSOLICITACAOSERVICO) REFERENCES SOLICITACAOSERVICO(IDSOLICITACAOSERVICO);

ALTER TABLE  SERVICO
    ADD CONSTRAINT FK_REFERENCE_295 FOREIGN KEY (IDCATEGORIASERVICO) REFERENCES CATEGORIASERVICO(IDCATEGORIASERVICO);

ALTER TABLE  VALORVISAOCAMPOSNEGOCIO
    ADD CONSTRAINT FK_REFERENCE_296 FOREIGN KEY (IDGRUPOVISAO) REFERENCES GRUPOVISAO(IDGRUPOVISAO);

ALTER TABLE  GRUPOVISAOCAMPOSNEGOCIO
    ADD CONSTRAINT FK_REFERENCE_297 FOREIGN KEY (IDGRUPOVISAO) REFERENCES GRUPOVISAO(IDGRUPOVISAO);

ALTER TABLE  GRUPOVISAOCAMPOSNEGOCIOINFOSQL
    ADD CONSTRAINT FK_REFERENCE_298 FOREIGN KEY (IDGRUPOVISAO) REFERENCES GRUPOVISAO(IDGRUPOVISAO);

ALTER TABLE  GRUPOVISAOCAMPOSNEGOCIOLIGACAO
    ADD CONSTRAINT FK_REFERENCE_299 FOREIGN KEY (IDGRUPOVISAO) REFERENCES GRUPOVISAO(IDGRUPOVISAO);

ALTER TABLE  ATIVIDADES
    ADD CONSTRAINT FK_REFERENCE_3 FOREIGN KEY (IDETAPA) REFERENCES ETAPAS(IDETAPA);

ALTER TABLE  VINCULOVISAO
    ADD CONSTRAINT FK_REFERENCE_300 FOREIGN KEY (IDVISAORELACIONADA) REFERENCES VISAORELACIONADA(IDVISAORELACIONADA);

ALTER TABLE  TIPOITEMCFGCARACTERISTICA
    ADD CONSTRAINT FK_REFERENCE_308 FOREIGN KEY (IDCARACTERISTICA) REFERENCES CARACTERISTICA(IDCARACTERISTICA);

ALTER TABLE  VALOR
    ADD CONSTRAINT FK_REFERENCE_309 FOREIGN KEY (IDCARACTERISTICA) REFERENCES CARACTERISTICA(IDCARACTERISTICA);

ALTER TABLE  BPM_FLUXO
    ADD CONSTRAINT FK_REFERENCE_31 FOREIGN KEY (IDTIPOFLUXO) REFERENCES BPM_TIPOFLUXO(IDTIPOFLUXO);

ALTER TABLE  ETAPAS
    ADD CONSTRAINT FK_REFERENCE_310 FOREIGN KEY (IDFLUXO) REFERENCES FLUXO(IDFLUXO);

ALTER TABLE  DEMANDAS
    ADD CONSTRAINT FK_REFERENCE_311 FOREIGN KEY (IDFLUXO) REFERENCES FLUXO(IDFLUXO);

ALTER TABLE  EXECUCAOSOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_312 FOREIGN KEY (IDFLUXO) REFERENCES FLUXO(IDFLUXO);

ALTER TABLE  BPM_INSTANCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_313 FOREIGN KEY (IDFLUXO) REFERENCES FLUXO(IDFLUXO);

ALTER TABLE  BPM_ELEMENTOFLUXO
    ADD CONSTRAINT FK_REFERENCE_314 FOREIGN KEY (IDFLUXO) REFERENCES FLUXO(IDFLUXO);

ALTER TABLE  BPM_SEQUENCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_315 FOREIGN KEY (IDFLUXO) REFERENCES FLUXO(IDFLUXO);

ALTER TABLE  ATIVIDADESFLUXOS
    ADD CONSTRAINT FK_REFERENCE_316 FOREIGN KEY (IDFLUXO) REFERENCES FLUXO(IDFLUXO);

ALTER TABLE  QUESTAOQUESTIONARIO
    ADD CONSTRAINT FK_REFERENCE_317 FOREIGN KEY (IDGRUPOQUESTIONARIO) REFERENCES GRUPOQUESTIONARIO(IDGRUPOQUESTIONARIO);

ALTER TABLE  DEMANDAS
    ADD CONSTRAINT FK_REFERENCE_318 FOREIGN KEY (IDTIPODEMANDA) REFERENCES TIPODEMANDA(IDTIPODEMANDA);

ALTER TABLE  TIPOOS
    ADD CONSTRAINT FK_REFERENCE_319 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  FLUXOSERVICO
    ADD CONSTRAINT FK_REFERENCE_32 FOREIGN KEY (IDTIPOFLUXO) REFERENCES BPM_TIPOFLUXO(IDTIPOFLUXO);

ALTER TABLE  CONTRATOQUESTIONARIOS
    ADD CONSTRAINT FK_REFERENCE_320 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  DEMANDAS
    ADD CONSTRAINT FK_REFERENCE_321 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  RESPONSABILIDADE
    ADD CONSTRAINT FK_REFERENCE_322 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  SERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_323 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  OS
    ADD CONSTRAINT FK_REFERENCE_324 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  PROJETOS
    ADD CONSTRAINT FK_REFERENCE_325 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  IMAGEMHISTORICO
    ADD CONSTRAINT FK_REFERENCE_326 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  ATIVIDADEPERIODICA
    ADD CONSTRAINT FK_REFERENCE_327 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  CATEGORIASERVICO
    ADD CONSTRAINT FK_REFERENCE_33 FOREIGN KEY (IDCATEGORIASERVICOPAI) REFERENCES CATEGORIASERVICO(IDCATEGORIASERVICO);

ALTER TABLE  PERMISSOESFLUXO
    ADD CONSTRAINT FK_PERMISSOESFLUXO_33 FOREIGN KEY (IDTIPOFLUXO) REFERENCES BPM_TIPOFLUXO(IDTIPOFLUXO);

ALTER TABLE  CONTRATOQUESTIONARIOS
    ADD CONSTRAINT FK_REFERENCE_330 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  TIPOSERVICO
    ADD CONSTRAINT FK_REFERENCE_331 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  TIPOITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_332 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  EVENTO
    ADD CONSTRAINT FK_REFERENCE_333 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  SERVICO
    ADD CONSTRAINT FK_REFERENCE_334 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  TIPOUNIDADE
    ADD CONSTRAINT FK_REFERENCE_335 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  USUARIO
    ADD CONSTRAINT FK_REFERENCE_336 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  INFORMACOESCONTRATOCONFIG
    ADD CONSTRAINT FK_REFERENCE_337 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  PARAMETROCORPORE
    ADD CONSTRAINT FK_REFERENCE_338 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  SITUACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_339 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  ETAPAS
    ADD CONSTRAINT FK_REFERENCE_34 FOREIGN KEY (IDFLUXO) REFERENCES BPM_FLUXO(IDFLUXO);

ALTER TABLE  IMAGEMHISTORICO
    ADD CONSTRAINT FK_REFERENCE_340 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  QUESTIONARIO
    ADD CONSTRAINT FK_REFERENCE_341 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  GRUPO
    ADD CONSTRAINT FK_REFERENCE_342 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  CATEGORIASERVICO
    ADD CONSTRAINT FK_REFERENCE_343 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  CARACTERISTICA
    ADD CONSTRAINT FK_REFERENCE_344 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  PRIORIDADE
    ADD CONSTRAINT FK_REFERENCE_345 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  PARAMETROS
    ADD CONSTRAINT FK_REFERENCE_346 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  IMPORTANCIANEGOCIO
    ADD CONSTRAINT FK_REFERENCE_347 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  UNIDADE
    ADD CONSTRAINT FK_REFERENCE_348 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  CATEGORIAQUESTIONARIO
    ADD CONSTRAINT FK_REFERENCE_349 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  DEMANDAS
    ADD CONSTRAINT FK_REFERENCE_35 FOREIGN KEY (IDFLUXO) REFERENCES BPM_FLUXO(IDFLUXO);

ALTER TABLE  ITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_350 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  CONDICAOOPERACAO
    ADD CONSTRAINT FK_REFERENCE_351 FOREIGN KEY (IDEMPRESA) REFERENCES EMPRESA(IDEMPRESA);

ALTER TABLE  RESPOSTAITEMQUESTIONARIOOPCOES
    ADD CONSTRAINT FK_REFERENCE_352 FOREIGN KEY (IDRESPOSTAITEMQUESTIONARIO) REFERENCES RESPOSTAITEMQUESTIONARIO(IDRESPOSTAITEMQUESTIONARIO);

ALTER TABLE  RESPOSTAITEMQUESTIONARIOCIDS
    ADD CONSTRAINT FK_REFERENCE_353 FOREIGN KEY (IDRESPOSTAITEMQUESTIONARIO) REFERENCES RESPOSTAITEMQUESTIONARIO(IDRESPOSTAITEMQUESTIONARIO);

ALTER TABLE  RESPOSTAITEMQUESTIONARIOANEXOS
    ADD CONSTRAINT FK_REFERENCE_354 FOREIGN KEY (IDRESPOSTAITEMQUESTIONARIO) REFERENCES RESPOSTAITEMQUESTIONARIO(IDRESPOSTAITEMQUESTIONARIO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_355 FOREIGN KEY (IDORIGEM) REFERENCES ORIGEMATENDIMENTO(IDORIGEM);

ALTER TABLE  HISTORICOTENTATIVA
    ADD CONSTRAINT FK_REFERENCE_364 FOREIGN KEY (IDBASEITEMCONFIGURACAO) REFERENCES UNIDADEBASEITEMCONFIGURACAO(IDBASEITEMCONFIGURACAO);

ALTER TABLE  VALOR
    ADD CONSTRAINT FK_REFERENCE_365 FOREIGN KEY (IDBASEITEMCONFIGURACAO) REFERENCES UNIDADEBASEITEMCONFIGURACAO(IDBASEITEMCONFIGURACAO);

ALTER TABLE  ITEMCONFIGURACAOEVENTO
    ADD CONSTRAINT FK_REFERENCE_366 FOREIGN KEY (IDBASEITEMCONFIGURACAO) REFERENCES UNIDADEBASEITEMCONFIGURACAO(IDBASEITEMCONFIGURACAO);

ALTER TABLE  JUSTIFICACAOFALHA
    ADD CONSTRAINT FK_REFERENCE_367 FOREIGN KEY (IDBASEITEMCONFIGURACAO) REFERENCES UNIDADEBASEITEMCONFIGURACAO(IDBASEITEMCONFIGURACAO);

ALTER TABLE  TEMPOACORDONIVELSERVICO
    ADD CONSTRAINT FK_REFERENCE_375 FOREIGN KEY (IDPRIORIDADE) REFERENCES PRIORIDADE(IDPRIORIDADE);

ALTER TABLE  PRIORIDADESERVICOUNIDADE
    ADD CONSTRAINT FK_REFERENCE_376 FOREIGN KEY (IDPRIORIDADE) REFERENCES PRIORIDADE(IDPRIORIDADE);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_377 FOREIGN KEY (IDPRIORIDADE) REFERENCES PRIORIDADE(IDPRIORIDADE);

ALTER TABLE  CONTROLEGED
    ADD CONSTRAINT FK_REFERENCE_378 FOREIGN KEY (ID) REFERENCES SISTEMAOPERACIONAL(ID);

ALTER TABLE  SERVICO
    ADD CONSTRAINT FK_REFERENCE_379 FOREIGN KEY (IDIMPORTANCIANEGOCIO) REFERENCES IMPORTANCIANEGOCIO(IDIMPORTANCIANEGOCIO);

ALTER TABLE  COLECAO
    ADD CONSTRAINT FK_REFERENCE_380 FOREIGN KEY (IDTESTE) REFERENCES TESTE(IDTESTE);

ALTER TABLE  ATIVIDADES
    ADD CONSTRAINT FK_REFERENCE_381 FOREIGN KEY (IDTIPOATIVIDADE) REFERENCES TIPOSATIVIDADES(IDTIPOATIVIDADE);

ALTER TABLE  AUDITORIA
    ADD CONSTRAINT FK_REFERENCE_382 FOREIGN KEY (IDUSUARIO,  IDITEMCONFIGURACAO) REFERENCES USUARIOITEMCONFIGURACAO(IDUSUARIO,  IDITEMCONFIGURACAO);

ALTER TABLE  PROGRAMACAOATIVIDADE
    ADD CONSTRAINT FK_REFERENCE_397 FOREIGN KEY (IDATIVIDADEPERIODICA) REFERENCES ATIVIDADEPERIODICA(IDATIVIDADEPERIODICA);

ALTER TABLE  EXECUCAOATIVIDADEPERIODICA
    ADD CONSTRAINT FK_REFERENCE_398 FOREIGN KEY (IDATIVIDADEPERIODICA) REFERENCES ATIVIDADEPERIODICA(IDATIVIDADEPERIODICA);

ALTER TABLE  HISTORICOTENTATIVA
    ADD CONSTRAINT FK_REFERENCE_399 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  CONTROLEGED
    ADD CONSTRAINT FK_REFERENCE_4 FOREIGN KEY (ID) REFERENCES TIPOITEMCFGCARACTERISTICA(ID);

ALTER TABLE  ATIVIDADESFLUXOS
    ADD CONSTRAINT FK_REFERENCE_40 FOREIGN KEY (IDFLUXO) REFERENCES BPM_FLUXO(IDFLUXO);

ALTER TABLE  OCORRENCIAS
    ADD CONSTRAINT FK_REFERENCE_400 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  RESPONSABILIDADE
    ADD CONSTRAINT FK_REFERENCE_401 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  GRUPOSEMPREGADOS
    ADD CONSTRAINT FK_REFERENCE_402 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  EXECUCAOATIVIDADEPERIODICA
    ADD CONSTRAINT FK_REFERENCE_403 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  USUARIO
    ADD CONSTRAINT FK_REFERENCE_404 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  EXCECAOEMPREGADO
    ADD CONSTRAINT FK_REFERENCE_405 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  EMPREGADOITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_406 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  AUDITORIAITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_407 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  JUSTIFICACAOFALHA
    ADD CONSTRAINT FK_REFERENCE_408 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  TIMESHEET
    ADD CONSTRAINT FK_REFERENCE_409 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  ATIVIDADEPERIODICA
    ADD CONSTRAINT FK_REFERENCE_41 FOREIGN KEY (IDGRUPOATVPERIODICA) REFERENCES GRUPOATVPERIODICA(IDGRUPOATVPERIODICA);

ALTER TABLE  EVENTOEMPREGADO
    ADD CONSTRAINT FK_REFERENCE_410 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  AUDITORIA
    ADD CONSTRAINT FK_REFERENCE_418 FOREIGN KEY (IDUSUARIO,  IDITEMCONFIGURACAO) REFERENCES EMPREGADOITEMCONFIGURACAO(IDUSUARIO,  IDITEMCONFIGURACAO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_42 FOREIGN KEY (IDTIPOPROBLEMA) REFERENCES TIPOPROBLEMAATENDIMENTO(IDTIPOPROBLEMA);

ALTER TABLE  EVENTOUNIDADE
    ADD CONSTRAINT FK_REFERENCE_422 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  PRIORIDADESERVICOUNIDADE
    ADD CONSTRAINT FK_REFERENCE_423 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  USUARIO
    ADD CONSTRAINT FK_REFERENCE_424 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  EXCECAOEMPREGADO
    ADD CONSTRAINT FK_REFERENCE_425 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_426 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  UNIDADEBASEITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_427 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  EMPREGADOS
    ADD CONSTRAINT FK_REFERENCE_428 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  SERVICO
    ADD CONSTRAINT FK_REFERENCE_43 FOREIGN KEY (IDLOCALEXECUCAOSERVICO) REFERENCES LOCALEXECUCAOSERVICO(IDLOCALEXECUCAOSERVICO);

ALTER TABLE  ITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_430 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  EVENTOEMPREGADO
    ADD CONSTRAINT FK_REFERENCE_431 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  QUESTIONARIO
    ADD CONSTRAINT FK_REFERENCE_432 FOREIGN KEY (IDCATEGORIAQUESTIONARIO) REFERENCES CATEGORIAQUESTIONARIO(IDCATEGORIAQUESTIONARIO);

ALTER TABLE  HISTORICOTENTATIVA
    ADD CONSTRAINT FK_REFERENCE_433 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  IMAGEMITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_434 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  VALOR
    ADD CONSTRAINT FK_REFERENCE_435 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  ITEMCONFIGURACAOEVENTO
    ADD CONSTRAINT FK_REFERENCE_436 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  AUDITORIA
    ADD CONSTRAINT FK_REFERENCE_437 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  USUARIOITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_439 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  EMPREGADOITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_441 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  AUDITORIAITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_442 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  JUSTIFICACAOFALHA
    ADD CONSTRAINT FK_REFERENCE_443 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  HISTORICOEXECUCAO
    ADD CONSTRAINT FK_REFERENCE_444 FOREIGN KEY (IDEXECUCAO) REFERENCES EXECUCAODEMANDA(IDEXECUCAO);

ALTER TABLE  SERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_452 FOREIGN KEY (IDCONDICAOOPERACAO) REFERENCES CONDICAOOPERACAO(IDCONDICAOOPERACAO);

ALTER TABLE  BPM_ATRIBUICAOFLUXO
    ADD CONSTRAINT FK_REFERENCE_47 FOREIGN KEY (IDITEMTRABALHO) REFERENCES BPM_ITEMTRABALHOFLUXO(IDITEMTRABALHO);

ALTER TABLE  BPM_OBJETOINSTANCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_48 FOREIGN KEY (IDITEMTRABALHO) REFERENCES BPM_ITEMTRABALHOFLUXO(IDITEMTRABALHO);

ALTER TABLE  HTMLCODEVISAO
    ADD CONSTRAINT FK_REFERENCE_481 FOREIGN KEY (IDVISAO) REFERENCES VISAO(IDVISAO);

ALTER TABLE  BOTAOACAOVISAO
    ADD CONSTRAINT FK_REFERENCE_482 FOREIGN KEY (IDVISAO) REFERENCES VISAO(IDVISAO);

ALTER TABLE  GRUPOVISAO
    ADD CONSTRAINT FK_REFERENCE_483 FOREIGN KEY (IDVISAO) REFERENCES VISAO(IDVISAO);

ALTER TABLE  SCRIPTSVISAO
    ADD CONSTRAINT FK_REFERENCE_484 FOREIGN KEY (IDVISAO) REFERENCES VISAO(IDVISAO);

ALTER TABLE  FERIADO
    ADD CONSTRAINT FK_REFERENCE_485 FOREIGN KEY (IDCIDADE) REFERENCES CIDADES(IDCIDADE);

ALTER TABLE  CAMPOSOBJETONEGOCIO
    ADD CONSTRAINT FK_REFERENCE_486 FOREIGN KEY (IDOBJETONEGOCIO) REFERENCES OBJETONEGOCIO(IDOBJETONEGOCIO);

ALTER TABLE  BPM_OBJETOINSTANCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_487 FOREIGN KEY (IDOBJETONEGOCIO) REFERENCES OBJETONEGOCIO(IDOBJETONEGOCIO);

ALTER TABLE  RESPONSABILIDADE
    ADD CONSTRAINT FK_REFERENCE_488 FOREIGN KEY (IDCONTATOCLIENTE) REFERENCES CONTATOCLIENTE(IDCONTATOCLIENTE);

ALTER TABLE  HISTORICOTENTATIVA
    ADD CONSTRAINT FK_REFERENCE_489 FOREIGN KEY (IDEVENTO,  IDEMPREGADO) REFERENCES EVENTOEMPREGADO(IDEVENTO,  IDEMPREGADO);

ALTER TABLE  INVENTARIOXML
    ADD CONSTRAINT FK_REFERENCE_49 FOREIGN KEY (IDNETMAP) REFERENCES NETMAP(IDNETMAP);

ALTER TABLE  JUSTIFICACAOFALHA
    ADD CONSTRAINT FK_REFERENCE_490 FOREIGN KEY (IDEVENTO,  IDEMPREGADO) REFERENCES EVENTOEMPREGADO(IDEVENTO,  IDEMPREGADO);

ALTER TABLE  ATIVIDADESFLUXOS
    ADD CONSTRAINT FK_REFERENCE_491 FOREIGN KEY (IDATIVIDADE) REFERENCES ATIVIDADES(IDATIVIDADE);

ALTER TABLE  EXECUCAODEMANDA
    ADD CONSTRAINT FK_REFERENCE_492 FOREIGN KEY (IDATIVIDADE) REFERENCES ATIVIDADES(IDATIVIDADE);

ALTER TABLE  PROJETOS
    ADD CONSTRAINT FK_REFERENCE_5 FOREIGN KEY (IDCLIENTE) REFERENCES CLIENTES(IDCLIENTE);

ALTER TABLE  EXECUCAOATIVIDADEPERIODICA
    ADD CONSTRAINT FK_REFERENCE_50 FOREIGN KEY (IDPROGRAMACAOATIVIDADE) REFERENCES PROGRAMACAOATIVIDADE(IDPROGRAMACAOATIVIDADE);

ALTER TABLE  GLOSAOS
    ADD CONSTRAINT FK_REFERENCE_504 FOREIGN KEY (IDOS) REFERENCES OS(IDOS);

ALTER TABLE  FATURA
    ADD CONSTRAINT FK_REFERENCE_505 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  ATIVIDADESOS
    ADD CONSTRAINT FK_REFERENCE_506 FOREIGN KEY (IDOS) REFERENCES OS(IDOS);

ALTER TABLE  FATURAOS
    ADD CONSTRAINT FK_REFERENCE_507 FOREIGN KEY (IDFATURA) REFERENCES FATURA(IDFATURA);

ALTER TABLE  FATURAOS
    ADD CONSTRAINT FK_REFERENCE_508 FOREIGN KEY (IDOS) REFERENCES OS(IDOS);

ALTER TABLE  ACORDONIVELSERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_509 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  CAMPOOBJRELACIONADO
    ADD CONSTRAINT FK_REFERENCE_51 FOREIGN KEY (IDRELACOBJETONEGOCIO) REFERENCES RELACOBJETONEGOCIO(IDRELACOBJETONEGOCIO);

ALTER TABLE  FATURAAPURACAOANS
    ADD CONSTRAINT FK_REFERENCE_510 FOREIGN KEY (IDFATURA) REFERENCES FATURA(IDFATURA);

ALTER TABLE  FATURAAPURACAOANS
    ADD CONSTRAINT FK_REFERENCE_511 FOREIGN KEY (IDACORDONIVELSERVICOCONTRATO) REFERENCES ACORDONIVELSERVICOCONTRATO(IDACORDONIVELSERVICOCONTRATO);

ALTER TABLE  PARAMETROSCONTRATO
    ADD CONSTRAINT FK_REFERENCE_512 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  PERFILACESSOSITUACAOOS
    ADD CONSTRAINT FK_REFERENCE_515 FOREIGN KEY (IDPERFIL) REFERENCES PERFILACESSO(IDPERFIL);

ALTER TABLE  PERFILACESSOSITUACAOFATURA
    ADD CONSTRAINT FK_REFERENCE_516 FOREIGN KEY (IDPERFIL) REFERENCES PERFILACESSO(IDPERFIL);

ALTER TABLE  EXECUCAOSOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_517 FOREIGN KEY (IDINSTANCIAFLUXO) REFERENCES BPM_INSTANCIAFLUXO(IDINSTANCIA);

ALTER TABLE  BPM_SEQUENCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_518 FOREIGN KEY (IDELEMENTOORIGEM) REFERENCES BPM_ELEMENTOFLUXO(IDELEMENTO);

ALTER TABLE  BPM_SEQUENCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_519 FOREIGN KEY (IDELEMENTODESTINO) REFERENCES BPM_ELEMENTOFLUXO(IDELEMENTO);

ALTER TABLE  BPM_SEQUENCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_520 FOREIGN KEY (IDFLUXO) REFERENCES BPM_FLUXO(IDFLUXO);

ALTER TABLE  EXECUCAOSOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_521 FOREIGN KEY (IDFLUXO) REFERENCES BPM_FLUXO(IDFLUXO);

ALTER TABLE  BPM_ELEMENTOFLUXO
    ADD CONSTRAINT FK_REFERENCE_522 FOREIGN KEY (IDFLUXO) REFERENCES BPM_FLUXO(IDFLUXO);

ALTER TABLE  BPM_INSTANCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_524 FOREIGN KEY (IDFLUXO) REFERENCES BPM_FLUXO(IDFLUXO);

ALTER TABLE  BPM_HISTORICOITEMTRABALHO
    ADD CONSTRAINT FK_REFERENCE_525 FOREIGN KEY (IDITEMTRABALHO) REFERENCES BPM_ITEMTRABALHOFLUXO(IDITEMTRABALHO);

ALTER TABLE  BPM_HISTORICOITEMTRABALHO
    ADD CONSTRAINT FK_REFERENCE_526 FOREIGN KEY (IDUSUARIO) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  BPM_HISTORICOITEMTRABALHO
    ADD CONSTRAINT FK_REFERENCE_527 FOREIGN KEY (IDRESPONSAVEL) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_529 FOREIGN KEY (IDSERVICOCONTRATO) REFERENCES SERVICOCONTRATO(IDSERVICOCONTRATO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_531 FOREIGN KEY (IDCAUSAINCIDENTE) REFERENCES CAUSAINCIDENTE(IDCAUSAINCIDENTE);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_532 FOREIGN KEY (IDCATEGORIASOLUCAO) REFERENCES CATEGORIASOLUCAO(IDCATEGORIASOLUCAO);

ALTER TABLE  CALENDARIO
    ADD CONSTRAINT FK_REFERENCE_533 FOREIGN KEY (IDJORNADASEG) REFERENCES JORNADATRABALHO(IDJORNADA);

ALTER TABLE  CALENDARIO
    ADD CONSTRAINT FK_REFERENCE_534 FOREIGN KEY (IDJORNADATER) REFERENCES JORNADATRABALHO(IDJORNADA);

ALTER TABLE  CALENDARIO
    ADD CONSTRAINT FK_REFERENCE_535 FOREIGN KEY (IDJORNADAQUA) REFERENCES JORNADATRABALHO(IDJORNADA);

ALTER TABLE  CALENDARIO
    ADD CONSTRAINT FK_REFERENCE_536 FOREIGN KEY (IDJORNADAQUI) REFERENCES JORNADATRABALHO(IDJORNADA);

ALTER TABLE  CALENDARIO
    ADD CONSTRAINT FK_REFERENCE_537 FOREIGN KEY (IDJORNADASEX) REFERENCES JORNADATRABALHO(IDJORNADA);

ALTER TABLE  CALENDARIO
    ADD CONSTRAINT FK_REFERENCE_538 FOREIGN KEY (IDJORNADASAB) REFERENCES JORNADATRABALHO(IDJORNADA);

ALTER TABLE  CALENDARIO
    ADD CONSTRAINT FK_REFERENCE_539 FOREIGN KEY (IDJORNADADOM) REFERENCES JORNADATRABALHO(IDJORNADA);

ALTER TABLE  EXCECAOCALENDARIO
    ADD CONSTRAINT FK_REFERENCE_540 FOREIGN KEY (IDCALENDARIO) REFERENCES CALENDARIO(IDCALENDARIO);

ALTER TABLE  EXCECAOCALENDARIO
    ADD CONSTRAINT FK_REFERENCE_541 FOREIGN KEY (IDJORNADA) REFERENCES JORNADATRABALHO(IDJORNADA);

ALTER TABLE  REABERTURASOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_542 FOREIGN KEY (IDRESPONSAVEL) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  REABERTURASOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_543 FOREIGN KEY (IDSOLICITACAOSERVICO) REFERENCES SOLICITACAOSERVICO(IDSOLICITACAOSERVICO);

ALTER TABLE  EXECUCAOSOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_544 FOREIGN KEY (IDSOLICITACAOSERVICO,  SEQREABERTURA) 
	REFERENCES REABERTURASOLICITACAO(IDSOLICITACAOSERVICO,  SEQREABERTURA);

ALTER TABLE  SERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_547 FOREIGN KEY (IDMODELOEMAILCRIACAO) REFERENCES MODELOSEMAILS(IDMODELOEMAIL);

ALTER TABLE  SERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_548 FOREIGN KEY (IDMODELOEMAILFINALIZACAO) REFERENCES MODELOSEMAILS(IDMODELOEMAIL);

ALTER TABLE  SERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_549 FOREIGN KEY (IDMODELOEMAILACOES) REFERENCES MODELOSEMAILS(IDMODELOEMAIL);

ALTER TABLE  BPM_ATRIBUICAOFLUXO
    ADD CONSTRAINT FK_REFERENCE_550 FOREIGN KEY (IDGRUPO) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  PESQUISASATISFACAO
    ADD CONSTRAINT FK_REFERENCE_551 FOREIGN KEY (IDSOLICITACAOSERVICO) REFERENCES SOLICITACAOSERVICO(IDSOLICITACAOSERVICO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_552 FOREIGN KEY (IDSOLICITANTE) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_553 FOREIGN KEY (IDGRUPOATUAL) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_554 FOREIGN KEY (IDRESPONSAVEL) REFERENCES USUARIO(IDUSUARIO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_555 FOREIGN KEY (IDFASEATUAL) REFERENCES FASESERVICO(IDFASE);

ALTER TABLE  BPM_HISTORICOITEMTRABALHO
    ADD CONSTRAINT FK_REFERENCE_556 FOREIGN KEY (IDGRUPO) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  EMPREGADOS
    ADD CONSTRAINT FK_REFERENCE_557 FOREIGN KEY (IDCARGO) REFERENCES CARGOS(IDCARGO);

ALTER TABLE  SERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_558 FOREIGN KEY (IDGRUPONIVEL1) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  SERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_559 FOREIGN KEY (IDGRUPOEXECUTOR) REFERENCES GRUPO(IDGRUPO);

ALTER TABLE  SERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_560 FOREIGN KEY (IDCALENDARIO) REFERENCES CALENDARIO(IDCALENDARIO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_561 FOREIGN KEY (IDCALENDARIO) REFERENCES CALENDARIO(IDCALENDARIO);

ALTER TABLE  OCORRENCIASOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_562 FOREIGN KEY (IDJUSTIFICATIVA) REFERENCES JUSTIFICATIVASOLICITACAO(IDJUSTIFICATIVA);

ALTER TABLE  ATIVIDADEPERIODICA
    ADD CONSTRAINT FK_REFERENCE_563 FOREIGN KEY (IDSOLICITACAOSERVICO) REFERENCES SOLICITACAOSERVICO(IDSOLICITACAOSERVICO);

ALTER TABLE  OCORRENCIASOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_564 FOREIGN KEY (IDSOLICITACAOSERVICO) REFERENCES SOLICITACAOSERVICO(IDSOLICITACAOSERVICO);

ALTER TABLE  OCORRENCIASOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_565 FOREIGN KEY (IDITEMTRABALHO) REFERENCES BPM_ITEMTRABALHOFLUXO(IDITEMTRABALHO);

ALTER TABLE  SERVICO
    ADD CONSTRAINT FK_REFERENCE_567 FOREIGN KEY (IDBASECONHECIMENTO) REFERENCES BASECONHECIMENTO(IDBASECONHECIMENTO);

ALTER TABLE  CONTRATOSCOLABORADORES
    ADD CONSTRAINT FK_REFERENCE_568 FOREIGN KEY (IDEMPREGADO) REFERENCES EMPREGADOS(IDEMPREGADO);

ALTER TABLE  CONTRATOSCOLABORADORES
    ADD CONSTRAINT FK_REFERENCE_569 FOREIGN KEY (IDCONTRATO) REFERENCES CONTRATOS(IDCONTRATO);

ALTER TABLE  UNIDADESACCSERVICOS
    ADD CONSTRAINT FK_REFERENCE_570 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  UNIDADESACCSERVICOS
    ADD CONSTRAINT FK_REFERENCE_571 FOREIGN KEY (IDSERVICO) REFERENCES SERVICO(IDSERVICO);

ALTER TABLE  ACORDONIVELSERVICO
    ADD CONSTRAINT FK_REFERENCE_572 FOREIGN KEY (IDFORMULA) REFERENCES FORMULA(IDFORMULA);

ALTER TABLE  ACORDONIVELSERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_573 FOREIGN KEY (IDFORMULA) REFERENCES FORMULA(IDFORMULA);

ALTER TABLE  PRIORIDADEACORDONIVELSERVICO
    ADD CONSTRAINT FK_REFERENCE_579 FOREIGN KEY (IDACORDONIVELSERVICO) REFERENCES ACORDONIVELSERVICO(IDACORDONIVELSERVICO);

ALTER TABLE  PRIORIDADEACORDONIVELSERVICO
    ADD CONSTRAINT FK_REFERENCE_580 FOREIGN KEY (IDPRIORIDADE) REFERENCES PRIORIDADE(IDPRIORIDADE);

ALTER TABLE  PRIORIDADEACORDONIVELSERVICO
    ADD CONSTRAINT FK_REFERENCE_581 FOREIGN KEY (IDUNIDADE) REFERENCES UNIDADE(IDUNIDADE);

ALTER TABLE  ETAPAS
    ADD CONSTRAINT FK_REFERENCE_59 FOREIGN KEY (IDFLUXO) REFERENCES FLUXOS(IDFLUXO);

ALTER TABLE  CONTRATOS
    ADD CONSTRAINT FK_REFERENCE_6 FOREIGN KEY (IDCLIENTE) REFERENCES CLIENTES(IDCLIENTE);

ALTER TABLE  DEMANDAS
    ADD CONSTRAINT FK_REFERENCE_60 FOREIGN KEY (IDFLUXO) REFERENCES FLUXOS(IDFLUXO);

ALTER TABLE  OSATIVIDADEPERIODICA
    ADD CONSTRAINT FK_REFERENCE_600 FOREIGN KEY (IDOS) REFERENCES OS(IDOS);

ALTER TABLE  OSATIVIDADEPERIODICA
    ADD CONSTRAINT FK_REFERENCE_601 FOREIGN KEY (IDATIVIDADEPERIODICA) REFERENCES ATIVIDADEPERIODICA(IDATIVIDADEPERIODICA);

ALTER TABLE  PROGRAMACAOATIVIDADE
    ADD CONSTRAINT FK_REFERENCE_602 FOREIGN KEY (IDATIVIDADESOS) REFERENCES ATIVIDADESOS(IDATIVIDADESOS);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_REFERENCE_607 FOREIGN KEY (IDBASECONHECIMENTO) REFERENCES BASECONHECIMENTO(IDBASECONHECIMENTO);

ALTER TABLE  EXECUCAOSOLICITACAO
    ADD CONSTRAINT FK_REFERENCE_61 FOREIGN KEY (IDFLUXO) REFERENCES FLUXOS(IDFLUXO);

ALTER TABLE  PROBLEMAITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_610 FOREIGN KEY (IDITEMCONFIGURACAO) REFERENCES ITEMCONFIGURACAO(IDITEMCONFIGURACAO);

ALTER TABLE  PROBLEMA
    ADD CONSTRAINT FK_REFERENCE_612 FOREIGN KEY (IDPROBLEMAITEMCONFIGURACAO) REFERENCES PROBLEMAITEMCONFIGURACAO(IDPROBLEMAITEMCONFIGURACAO);

ALTER TABLE  PROBLEMAITEMCONFIGURACAO
    ADD CONSTRAINT FK_REFERENCE_613 FOREIGN KEY (IDPROBLEMA) REFERENCES PROBLEMA(IDPROBLEMA);

ALTER TABLE  PROBLEMA
    ADD CONSTRAINT FK_REFERENCE_614 FOREIGN KEY (IDPROBLEMAMUDANCA) REFERENCES PROBLEMAMUDANCA(IDPROBLEMAMUDANCA);

ALTER TABLE  PROBLEMAMUDANCA
    ADD CONSTRAINT FK_REFERENCE_615 FOREIGN KEY (IDPROBLEMA) REFERENCES PROBLEMA(IDPROBLEMA);

ALTER TABLE  PROBLEMA
    ADD CONSTRAINT FK_REFERENCE_616 FOREIGN KEY (IDCATEGORIAPROBLEMA) REFERENCES CATEGORIAPROBLEMA(IDCATEGORIAPROBLEMA);

ALTER TABLE  CATEGORIAPROBLEMA
    ADD CONSTRAINT FK_REFERENCE_617 FOREIGN KEY (CAT_IDCATEGORIAPROBLEMA) REFERENCES CATEGORIAPROBLEMA(IDCATEGORIAPROBLEMA);

ALTER TABLE  GLOSAOS
    ADD CONSTRAINT FK_REFERENCE_618 FOREIGN KEY (IDACORDONIVELSERVICO) REFERENCES ACORDONIVELSERVICO(IDACORDONIVELSERVICO);

ALTER TABLE  BPM_INSTANCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_62 FOREIGN KEY (IDFLUXO) REFERENCES FLUXOS(IDFLUXO);

ALTER TABLE  BPM_ELEMENTOFLUXO
    ADD CONSTRAINT FK_REFERENCE_63 FOREIGN KEY (IDFLUXO) REFERENCES FLUXOS(IDFLUXO);

ALTER TABLE  BPM_SEQUENCIAFLUXO
    ADD CONSTRAINT FK_REFERENCE_64 FOREIGN KEY (IDFLUXO) REFERENCES FLUXOS(IDFLUXO);

ALTER TABLE  ATIVIDADESFLUXOS
    ADD CONSTRAINT FK_REFERENCE_65 FOREIGN KEY (IDFLUXO) REFERENCES FLUXOS(IDFLUXO);

ALTER TABLE  ATIVIDADEPERIODICA
    ADD CONSTRAINT FK_REFERENCE_68 FOREIGN KEY (IDPROCEDIMENTOTECNICO) REFERENCES PROCEDIMENTOTECNICO(IDPROCEDIMENTOTECNICO);

ALTER TABLE  CONTATOCLIENTE
    ADD CONSTRAINT FK_REFERENCE_7 FOREIGN KEY (IDCLIENTE) REFERENCES CLIENTES(IDCLIENTE);

ALTER TABLE  RELACOBJETONEGOCIO
    ADD CONSTRAINT FK_REFERENCE_73 FOREIGN KEY (IDOBJETONEGOCIOPAI) REFERENCES OBJETONEGOCIO(IDOBJETONEGOCIO);

ALTER TABLE  RELACOBJETONEGOCIO
    ADD CONSTRAINT FK_REFERENCE_74 FOREIGN KEY (IDOBJETONEGOCIOFILHO) REFERENCES OBJETONEGOCIO(IDOBJETONEGOCIO);

ALTER TABLE  OCORRENCIAS
    ADD CONSTRAINT FK_REFERENCE_77 FOREIGN KEY (IDDEMANDA) REFERENCES DEMANDAS(IDDEMANDA);

ALTER TABLE  EXECUCAODEMANDA
    ADD CONSTRAINT FK_REFERENCE_78 FOREIGN KEY (IDDEMANDA) REFERENCES DEMANDAS(IDDEMANDA);

ALTER TABLE  VISAORELACIONADA
    ADD CONSTRAINT FK_VISAORELACIONADA_78 FOREIGN KEY (IDVISAOPAI) REFERENCES VISAO(IDVISAO);

ALTER TABLE  TIMESHEET
    ADD CONSTRAINT FK_REFERENCE_79 FOREIGN KEY (IDDEMANDA) REFERENCES DEMANDAS(IDDEMANDA);

ALTER TABLE  ATIVIDADESOS
    ADD CONSTRAINT FK_REFERENCE_8 FOREIGN KEY (IDATIVIDADESERVICOCONTRATO) REFERENCES ATIVIDADESSERVICOCONTRATO(IDATIVIDADESERVICOCONTRATO);

ALTER TABLE  CAMPOOBJRELACIONADO
    ADD CONSTRAINT FK_REFERENCE_81 FOREIGN KEY (IDCAMPOSOBJETONEGOCIOPAI) REFERENCES CAMPOSOBJETONEGOCIO(IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  CAMPOOBJRELACIONADO
    ADD CONSTRAINT FK_REFERENCE_82 FOREIGN KEY (IDCAMPOSOBJETONEGOCIOFILHO) REFERENCES CAMPOSOBJETONEGOCIO(IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  ATIVIDADESSERVICOCONTRATO
    ADD CONSTRAINT FK_REFERENCE_87 FOREIGN KEY (IDSERVICOCONTRATO) REFERENCES SERVICOCONTRATO(IDSERVICOCONTRATO);

ALTER TABLE  RESPONSABILIDADE
    ADD CONSTRAINT FK_REFERENCE_88 FOREIGN KEY (IDSERVICOCONTRATO) REFERENCES SERVICOCONTRATO(IDSERVICOCONTRATO);

ALTER TABLE  OS
    ADD CONSTRAINT FK_REFERENCE_89 FOREIGN KEY (IDSERVICOCONTRATO) REFERENCES SERVICOCONTRATO(IDSERVICOCONTRATO);

ALTER TABLE  PRIORIDADESERVICOUNIDADE
    ADD CONSTRAINT FK_REFERENCE_90 FOREIGN KEY (IDSERVICOCONTRATO) REFERENCES SERVICOCONTRATO(IDSERVICOCONTRATO);

ALTER TABLE  VISAORELACIONADA
    ADD CONSTRAINT FK_VISAORELACIONADA_90 FOREIGN KEY (IDOBJETONEGOCIONN) REFERENCES OBJETONEGOCIO(IDOBJETONEGOCIO);

ALTER TABLE  ACORDONIVELSERVICO
    ADD CONSTRAINT FK_REFERENCE_91 FOREIGN KEY (IDSERVICOCONTRATO) REFERENCES SERVICOCONTRATO(IDSERVICOCONTRATO);

ALTER TABLE  FLUXOSERVICO
    ADD CONSTRAINT FK_REFERENCE_93 FOREIGN KEY (IDSERVICOCONTRATO) REFERENCES SERVICOCONTRATO(IDSERVICOCONTRATO);

ALTER TABLE  SERVICO
    ADD CONSTRAINT FK_REFERENCE_97 FOREIGN KEY (IDTIPOSERVICO) REFERENCES TIPOSERVICO(IDTIPOSERVICO);

ALTER TABLE  TIPOITEMCFGCARACTERISTICA
    ADD CONSTRAINT FK_REFERENCE_99 FOREIGN KEY (IDTIPOITEMCONFIGURACAO) REFERENCES TIPOITEMCONFIGURACAO(IDTIPOITEMCONFIGURACAO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_SOLICITACAOSERV_CONTATO FOREIGN KEY (IDCONTATOSOLICITACAOSERVICO) 
	REFERENCES CONTATOSOLICITACAOSERVICO(IDCONTATOSOLICITACAOSERVICO);

ALTER TABLE  SOLICITACAOSERVICO
    ADD CONSTRAINT FK_SOLICITSERV_TPDEMANDA FOREIGN KEY (IDTIPODEMANDASERVICO) REFERENCES TIPODEMANDASERVICO(IDTIPODEMANDASERVICO);

ALTER TABLE  VINCULOVISAO
    ADD CONSTRAINT FK_VINCULOV_REF1_CAMPOSOB FOREIGN KEY (IDCAMPOSOBJETONEGOCIOPAINN) REFERENCES CAMPOSOBJETONEGOCIO(IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  VINCULOVISAO
    ADD CONSTRAINT FK_VINCULOV_REF1_GRUPOVIS FOREIGN KEY (IDGRUPOVISAOFILHO,  IDCAMPOSOBJETONEGOCIOFILHO) 
	REFERENCES GRUPOVISAOCAMPOSNEGOCIO(IDGRUPOVISAO,  IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  VINCULOVISAO
    ADD CONSTRAINT FK_VINCULOV_REF2_CAMPOSOB FOREIGN KEY (IDCAMPOSOBJETONEGOCIOFILHONN) REFERENCES CAMPOSOBJETONEGOCIO(IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  VINCULOVISAO
    ADD CONSTRAINT FK_VINCULOV_REF2_GRUPOVIS FOREIGN KEY (IDGRUPOVISAOPAI,  IDCAMPOSOBJETONEGOCIOPAI) 
	REFERENCES GRUPOVISAOCAMPOSNEGOCIO(IDGRUPOVISAO,  IDCAMPOSOBJETONEGOCIO);

ALTER TABLE  VISAORELACIONADA
    ADD CONSTRAINT FK_VISAOREL_REF2_VISAO FOREIGN KEY (IDVISAOFILHA) REFERENCES VISAO(IDVISAO);


-- AJUSTES
-- SCRIPT DE ORIGEM: 04- Ajustes_DDL_ORACLE.sql

ALTER TABLE CONTRATOS ADD IDGRUPOSOLICITANTE INTEGER;

ALTER TABLE GRUPO ADD ABERTURA VARCHAR(45);
ALTER TABLE GRUPO ADD ANDAMENTO VARCHAR(45);
ALTER TABLE GRUPO ADD ENCERRAMENTO VARCHAR(45);

CREATE TABLE GRUPOSEMAILS (
	IDGRUPO INTEGER NOT NULL, 
	IDEMPREGADO INTEGER, 
	NOME VARCHAR(80), 
	EMAIL VARCHAR(200) NOT NULL, 
	PRIMARY KEY (IDGRUPO,  EMAIL)
);

ALTER TABLE GRUPOSEMPREGADOS ADD ENVIAEMAIL CHAR(1);

ALTER TABLE OS ADD QUANTIDADE INTEGER;
ALTER TABLE OS ADD IDOSPAI INTEGER;
ALTER TABLE OS ADD CONSTRAINT FK_REFERENCE_619 FOREIGN KEY (IDOSPAI) REFERENCES OS (IDOS);

ALTER TABLE CONTRATOS ADD DATAFIMCONTRATO DATE;

ALTER TABLE BPM_ELEMENTOFLUXO DROP CONSTRAINT FK_REFERENCE_63;
ALTER TABLE BPM_ELEMENTOFLUXO DROP CONSTRAINT FK_REFERENCE_314;

ALTER TABLE BPM_SEQUENCIAFLUXO DROP CONSTRAINT FK_REFERENCE_315;
ALTER TABLE BPM_SEQUENCIAFLUXO DROP CONSTRAINT FK_REFERENCE_64;

ALTER TABLE SOLICITACAOSERVICO MODIFY DATAHORAFIM NULL;

ALTER TABLE BPM_INSTANCIAFLUXO DROP CONSTRAINT FK_REFERENCE_62;
ALTER TABLE BPM_INSTANCIAFLUXO DROP CONSTRAINT FK_REFERENCE_313;

ALTER TABLE EXECUCAOSOLICITACAO DROP CONSTRAINT FK_REFERENCE_61;
ALTER TABLE EXECUCAOSOLICITACAO DROP CONSTRAINT FK_REFERENCE_312;

ALTER TABLE SOLICITACAOSERVICO DROP CONSTRAINT FK_REFERENCE_164;

CREATE TABLE CONTROLEGED (
	IDCONTROLEGED DECIMAL(10) PRIMARY KEY NOT NULL, 
	IDTABELA DECIMAL(22) NOT NULL, 
	ID DECIMAL(10) NOT NULL, 
	NOMEARQUIVO VARCHAR2(255) NOT NULL, 
	DESCRICAOARQUIVO VARCHAR2(255), 
	EXTENSAOARQUIVO VARCHAR2(5), 
	DATAHORA TIMESTAMP DEFAULT SYSDATE  NOT NULL, 
	PASTA VARCHAR2(255), 
	CONTEUDOARQUIVO BLOB
);

ALTER TABLE BPM_ITEMTRABALHOFLUXO MODIFY SITUACAO VARCHAR(20);

ALTER TABLE EXCECAOCALENDARIO DROP CONSTRAINT FK_REFERENCE_541;


-- INSERINDO DADOS NAS TABELAS
-- SCRIPT DE ORIGEM: 05- iniciaOperacao_ORACLE.sql
-- NÃO APLICADO POIS A CARGA SERÁ EFETUADA COM SCRIPTS DE INSERT GERADOS A PARTIR
-- DE CITSMART_HOMOLOGACAO.


-- ORIGEM: Documentação Entrega Deploy CITSMart - V.1.0.23.doc
-- Nenhum SQL ORACLE a ser aplicado.

-- ORIGEM: Documentação Entrega Deploy CITSMart - V.1.0.24.doc


ALTER TABLE CARACTERISTICA MODIFY SISTEMA CHAR(1);
ALTER TABLE TIPOITEMCONFIGURACAO MODIFY SISTEMA CHAR(1);
ALTER TABLE CARACTERISTICA MODIFY SISTEMA CHAR(1);
ALTER TABLE TIPOITEMCONFIGURACAO MODIFY SISTEMA CHAR(1);
ALTER TABLE ATIVIDADESSERVICOCONTRATO MODIFY HORA FLOAT;
ALTER TABLE ATIVIDADESSERVICOCONTRATO MODIFY HORA DEFAULT NULL;

-- ORIGEM: Documentação Entrega Deploy CITSMart - V.1.1.26.doc

/*ORACLE DEPLOY 1.1.26*/

ALTER TABLE LOCALIDADE  ADD CONSTRAINT PK_LOCALIDADE PRIMARY KEY (IDLOCALIDADE);

ALTER TABLE CONTATOSOLICITACAOSERVICO ADD CONSTRAINT FK_REFERENCE_622 FOREIGN KEY (IDLOCALIDADE) REFERENCES LOCALIDADE (IDLOCALIDADE);

ALTER TABLE POST ADD CONSTRAINT POST_PK PRIMARY KEY (IDPOST);

ALTER TABLE CATEGORIAPOST ADD CONSTRAINT CATEGORIAPOST_PK PRIMARY KEY (IDCATEGORIAPOST);

ALTER TABLE POST ADD CONSTRAINT FK_POST_1 FOREIGN KEY (IDCATEGORIAPOST) REFERENCES CATEGORIAPOST(IDCATEGORIAPOST);

ALTER TABLE PORTAL MODIFY HORA TIMESTAMP;

ALTER TABLE OPINIAO MODIFY HORA TIMESTAMP;

ALTER TABLE LOCALIDADEUNIDADE  ADD CONSTRAINT PK_LOCALIDADEUNIDADE PRIMARY KEY (IDLOCALIDADEUNIDADE);

ALTER TABLE LOCALIDADEUNIDADE  ADD CONSTRAINT FK_LOCALIDA_REFERENCE_UNIDADE FOREIGN KEY (IDUNIDADE)     REFERENCES UNIDADE (IDUNIDADE);

ALTER TABLE LOCALIDADEUNIDADE ADD CONSTRAINT FK_LOCALIDA_REFERENCE_LOCALIDA FOREIGN KEY (IDLOCALIDADE) REFERENCES LOCALIDADE (IDLOCALIDADE);

ALTER TABLE CARACTERISTICA MODIFY SISTEMA CHAR(1);

ALTER TABLE ITEMCONFIGURACAO DROP COLUMN SISTEMA; 

ALTER TABLE ITEMCONFIGURACAO DROP COLUMN IDUSUARIO; 

ALTER TABLE ITEMCONFIGURACAO DROP COLUMN IDEMPRESA;

ALTER TABLE ITEMCONFIGURACAO ADD (IDGRUPOITEMCONFIGURACAO NUMBER);

ALTER TABLE TIPOITEMCONFIGURACAO MODIFY SISTEMA CHAR(1);

ALTER TABLE ITEMCONFIGURACAOEVENTO ADD (LINHACOMANDOLINUX VARCHAR2(255) );


-- ORIGEM: Documentação Entrega Deploy CITSMart - V.1.1.26C.doc

/* Oracle */

CREATE TABLE CONTADORACESSO(
   IDCONTADORACESSO     INT NOT NULL,
   IDUSUARIO            INT,
   IDBASECONHECIMENTO   INT,
   DATAHORAACESSO       TIMESTAMP ,
   CONTADORACESSO       INT,
   PRIMARY KEY (IDCONTADORACESSO) 
);


-- ORIGEM: Documentação Entrega Deploy CITSMart - V.1.1.27.doc


-- ORIGEM: Documentação Entrega Deploy CITSMart - V.1.1.29.doc

-- ALTERACOES ADICIONAIS PARTE 1 - CITSMART 2.0
-- SCRIPT ORIGEM: citsmart1_2.0_oracle_corrigido.sql

CREATE TABLE GRUPOITEMCONFIGURACAO (
	IDGRUPOITEMCONFIGURACAO 	  NUMBER(38) NOT NULL,
	NOMEGRUPOITEMCONFIGURACAO 	  VARCHAR2(100) NOT NULL, 
	DATAINICIO 			  DATE NOT NULL, 
	DATAFIM 			  DATE, 
	PRIMARY KEY (IDGRUPOITEMCONFIGURACAO)
);

CREATE TABLE ACORDOSERVICOCONTRATO (
	IDACORDOSERVICOCONTRATO 	  NUMBER(38) NOT NULL,
	IDACORDONIVELSERVICO 		  NUMBER(38) NOT NULL,
	IDSERVICOCONTRATO   		  NUMBER(38) NOT NULL,
	DATACRIACAO          		  DATE NOT NULL,
	DATAINICIO           		  DATE,
	DATAFIM              		  DATE,
	DATAULTATUALIZ       		  DATE,
	DELETED              		  CHAR(1)
);

CREATE TABLE VALORAJUSTEGLOSA (
	IDSERVICOCONTRATO    	NUMBER(38) NOT NULL,
	IDACORDONIVELSERVICO 	NUMBER(38) NOT NULL,
	QUANTIDADEFALHAS     	NUMBER(38),
	VALORAJUSTE          	NUMBER(10,2),
	DELETED              	CHAR(1)
);

CREATE TABLE GLOSASERVICOCONTRATO (
	IDGLOSASERVICOCONTRATO 			  NUMBER(38) NOT NULL,
	IDSERVICOCONTRATO    			  NUMBER(38) NOT NULL,
	QUANTIDADEGLOSA      			  NUMBER(38),
	DATAFIM              			  DATE,
	PRIMARY KEY(IDGLOSASERVICOCONTRATO)
);

CREATE TABLE SOLICITACAOSERVICOMUDANCA (
	IDREQUISICAOMUDANCA 	NUMBER(38),
	IDSOLICITACAOSERVICO 	NUMBER(38)
);

CREATE TABLE CATEGORIAMUDANCA (
	IDCATEGORIAMUDANCA 		    NUMBER(38) NOT NULL,
	IDTIPOFLUXO       		    NUMBER(19),
	IDMODELOEMAILCRIACAO 		    NUMBER(19),
	IDMODELOEMAILFINALIZACAO 	    NUMBER(19),
	IDMODELOEMAILACOES 		    NUMBER(19),
	IDGRUPONIVEL1      		    NUMBER(19),
	IDGRUPOEXECUTOR   		    NUMBER(19),
	IDCALENDARIO      		    NUMBER(19),
	IDCATEGORIAMUDANCAPAI 		    NUMBER(19),
	NOMECATEGORIA      		    VARCHAR2(255),
	DATAINICIO         		    DATE,
	DATAFIM            		    DATE
);

/* ESSA TABELA JA EXISTE, POREM A COLUNA 
 * NIVELURGENCIA VARCHAR2(255)
 * NAO EXISTE 
 */
CREATE TABLE REQUISICAOMUDANCA (
	IDREQUISICAOMUDANCA 		    NUMBER(38) NOT NULL,
	IDPROPRIETARIO     		    NUMBER(38) NOT NULL,
	IDSOLICITANTE      		    NUMBER(38) NOT NULL,
	TIPO            		     VARCHAR2(25),
	IDCATEGORIAMUDANCA 		    NUMBER(19),
	IDGRUPONIVEL1      		    NUMBER(19),
	IDGRUPOATUAL       		    NUMBER(19),
	IDCALENDARIO       		    NUMBER(19),
	MOTIVO             		    VARCHAR2(255),
	NIVELIMPORTANCIANEGOCIO 	    VARCHAR2(255),
	CLASSIFICACAO      		    VARCHAR2(255),
	NIVELIMPACTO       		    VARCHAR2(255),
	ANALISEIMPACTO     		    VARCHAR2(3000),
	DATAHORACONCLUSAO  		    TIMESTAMP(6),
	DATAACEITACAO     		    DATE,
	DATAVOTACAO        		    DATE,
	DATAHORAINICIO     		    TIMESTAMP(6),
	DATAHORATERMINO    		    TIMESTAMP(6),
	TITULO           		    VARCHAR2(255),
	DESCRICAO          		    VARCHAR2(255),
	RISCO              		    VARCHAR2(255),
	ESTIMATIVACUSTO   		    NUMBER(19),
	PLANOREVERSAO     		    VARCHAR2(3000),
	STATUS            		    VARCHAR2(45),
	PRIORIDADE        		    NUMBER(38),
	ENVIAEMAILCRIACAO  		    CHAR(1),
	ENVIAEMAILFINALIZACAO 		    CHAR(1),
	ENVIAEMAILACOES    		    CHAR(1),
	EXIBIRQUADROMUDANCAS 		    CHAR(1),
	SEQREABERTURA      		    NUMBER(38),
	DATAHORACAPTURA    		    TIMESTAMP(6),
	DATAHORAREATIVACAO 		    TIMESTAMP(6),
	DATAHORASUSPENSAO  	  	    TIMESTAMP(6),
	TEMPODECORRIDOHH   		    NUMBER(38),
	TEMPODECORRIDOMM   		    NUMBER(38),
	PRAZOHH            		    NUMBER(38),
	PRAZOMM           		    NUMBER(38),
	TEMPOATENDIMENTOHH 		    NUMBER(38),
	TEMPOATENDIMENTOMM 		    NUMBER(38),
	TEMPOATRASOHH      		    NUMBER(38),
	TEMPOATRASOMM      		    NUMBER(38),
	TEMPOCAPTURAHH     		    NUMBER(38),
	TEMPOCAPTURAMM     		    NUMBER(38),
	FASE            		      VARCHAR2(20)
);

CREATE TABLE EXECUCAOMUDANCA (
	IDEXECUCAO         	  NUMBER(38)  NOT NULL,
	IDINSTANCIAFLUXO   	  NUMBER(19)  NOT NULL,
	IDREQUISICAOMUDANCA 	NUMBER(38)  NOT NULL,
	IDFLUXO           	  NUMBER(19)  NOT NULL,
	SEQREABERTURA     	  NUMBER(38)
); 

CREATE TABLE OCORRENCIAMUDANCA (
	IDOCORRENCIA      		      NUMBER(38) NOT NULL,
	IDITEMTRABALHO      		    NUMBER(19),
	IDJUSTIFICATIVA     		    NUMBER(19),
	IDREQUISICAOMUDANCA  		    NUMBER(19),
	DATAREGISTRO        		    DATE,
	HORAREGISTRO       		      VARCHAR2(5),
	REGISTRADOPOR      	 	      VARCHAR2(100),
	DESCRICAO          	 	      VARCHAR2(200),
	DATAINICIO         	 	      DATE,
	DATAFIM            	 	      DATE,
	COMPLEMENTOJUSTIFICATIVA   	CLOB,
	DADOSMUDANCA         		    CLOB,
	INFORMACOESCONTATO   		    CLOB,
	CATEGORIA          	 	      VARCHAR2(20),
	ORIGEM              		    CHAR(1),
	TEMPOGASTO         		      NUMBER(38),
	OCORRENCIA           		    CLOB
);

/* ESSA TABELA NAO EXISTE
   OBS: O IDENTIFICADOR E MUITO LONGO PARA O PADRAO DO ORACLE
   IDENTIFICADOR ALTERADO PARA: REQUISICAOMUDANCAITEMCONFIGURA
*/
CREATE TABLE REQUISICAOMUDANCAITEMCONFIGURA (
	IDREQUISICAOMUDANCAITEMCONFIGU  	    NUMBER(38) NOT NULL,
	IDREQUISICAOMUDANCA  			            NUMBER(38),
	IDITEMCONFIGURACAO  			            NUMBER(38),
	DESCRICAO           			            VARCHAR2(100)
);

CREATE TABLE REQUISICAOMUDANCASERVICO (
	IDREQUISICAOMUDANCASERVICO  	NUMBER(38) NOT NULL,
	IDREQUISICAOMUDANCA  		      NUMBER(38) NOT NULL,
	IDSERVICO           		      NUMBER(19) NOT NULL
);

ALTER TABLE CATEGORIAMUDANCA
	ADD PRIMARY KEY (IDCATEGORIAMUDANCA);

ALTER TABLE REQUISICAOMUDANCA 
	ADD PRIMARY KEY (IDREQUISICAOMUDANCA);

ALTER TABLE EXECUCAOMUDANCA 
	ADD PRIMARY KEY (IDEXECUCAO);

ALTER TABLE OCORRENCIAMUDANCA 
	ADD PRIMARY KEY (IDOCORRENCIA);

ALTER TABLE REQUISICAOMUDANCAITEMCONFIGURA 
	ADD PRIMARY KEY (IDREQUISICAOMUDANCAITEMCONFIGU);

ALTER TABLE REQUISICAOMUDANCASERVICO 
	ADD PRIMARY KEY (IDREQUISICAOMUDANCASERVICO);

ALTER TABLE SOLICITACAOSERVICOMUDANCA 
	ADD FOREIGN KEY (IDREQUISICAOMUDANCA) 
		REFERENCES REQUISICAOMUDANCA (IDREQUISICAOMUDANCA);

ALTER TABLE SOLICITACAOSERVICOMUDANCA 
	MODIFY IDSOLICITACAOSERVICO NUMBER(38) DEFAULT NULL;

ALTER TABLE SOLICITACAOSERVICOMUDANCA 
	ADD FOREIGN KEY (IDSOLICITACAOSERVICO) 
		REFERENCES SOLICITACAOSERVICO (IDSOLICITACAOSERVICO);

ALTER TABLE ACORDOSERVICOCONTRATO 
	ADD PRIMARY KEY (IDACORDOSERVICOCONTRATO);

ALTER TABLE MATRIZVISAO 
	ADD PRIMARY KEY (IDMATRIZ);
	
ALTER TABLE ITEMCONFIGURACAO 
	ADD FOREIGN KEY (IDGRUPOITEMCONFIGURACAO) 
		REFERENCES GRUPOITEMCONFIGURACAO (IDGRUPOITEMCONFIGURACAO);

ALTER TABLE MATRIZVISAO 
	ADD FOREIGN KEY (IDVISAO) 
		REFERENCES VISAO (IDVISAO);

ALTER TABLE MATRIZVISAO 
	ADD FOREIGN KEY (IDOBJETONEGOCIO) 
		REFERENCES OBJETONEGOCIO (IDOBJETONEGOCIO);

ALTER TABLE MATRIZVISAO 
	ADD FOREIGN KEY (IDCAMPOSOBJETONEGOCIO1) 
		REFERENCES CAMPOSOBJETONEGOCIO (IDCAMPOSOBJETONEGOCIO);

ALTER TABLE MATRIZVISAO 
	ADD FOREIGN KEY (IDCAMPOSOBJETONEGOCIO2) 
		REFERENCES CAMPOSOBJETONEGOCIO (IDCAMPOSOBJETONEGOCIO);

ALTER TABLE MATRIZVISAO 
	ADD FOREIGN KEY (IDCAMPOSOBJETONEGOCIO3) 
		REFERENCES CAMPOSOBJETONEGOCIO (IDCAMPOSOBJETONEGOCIO);

ALTER TABLE ACORDOSERVICOCONTRATO 
	ADD FOREIGN KEY (IDACORDONIVELSERVICO) 
		REFERENCES ACORDONIVELSERVICO (IDACORDONIVELSERVICO);

ALTER TABLE ACORDOSERVICOCONTRATO 
	ADD FOREIGN KEY (IDSERVICOCONTRATO) 
		REFERENCES SERVICOCONTRATO (IDSERVICOCONTRATO);

ALTER TABLE TIPOCOMPLEXIDADE
	ADD PRIMARY KEY (COMPLEXIDADE);

-- SQL ADICIONAL

ALTER TABLE COMPLEXIDADE 
	ADD PRIMARY KEY (IDCONTRATO, COMPLEXIDADE);

ALTER TABLE CATEGORIAMUDANCA 
	ADD FOREIGN KEY (IDTIPOFLUXO) 
		REFERENCES BPM_TIPOFLUXO (IDTIPOFLUXO);

ALTER TABLE CATEGORIAMUDANCA 
	ADD FOREIGN KEY (IDMODELOEMAILCRIACAO) 
		REFERENCES MODELOSEMAILS (IDMODELOEMAIL);

ALTER TABLE CATEGORIAMUDANCA 
	ADD FOREIGN KEY (IDMODELOEMAILFINALIZACAO) 
		REFERENCES MODELOSEMAILS (IDMODELOEMAIL);

ALTER TABLE CATEGORIAMUDANCA 
	ADD FOREIGN KEY (IDMODELOEMAILACOES) 
		REFERENCES MODELOSEMAILS (IDMODELOEMAIL);

ALTER TABLE CATEGORIAMUDANCA 
	ADD FOREIGN KEY (IDGRUPONIVEL1) 
		REFERENCES GRUPO (IDGRUPO);

ALTER TABLE CATEGORIAMUDANCA 
	ADD FOREIGN KEY (IDGRUPOEXECUTOR) 
		REFERENCES GRUPO (IDGRUPO);

ALTER TABLE CATEGORIAMUDANCA 
	ADD FOREIGN KEY (IDCALENDARIO) 
		REFERENCES CALENDARIO (IDCALENDARIO);	 

ALTER TABLE REQUISICAOMUDANCA 
	ADD FOREIGN KEY (IDCATEGORIAMUDANCA) 
		REFERENCES CATEGORIAMUDANCA (IDCATEGORIAMUDANCA);

ALTER TABLE REQUISICAOMUDANCA 
	ADD FOREIGN KEY (IDGRUPONIVEL1)
		 REFERENCES GRUPO (IDGRUPO);

ALTER TABLE REQUISICAOMUDANCA 
	ADD FOREIGN KEY (IDGRUPOATUAL) 
		REFERENCES GRUPO (IDGRUPO);

ALTER TABLE REQUISICAOMUDANCA 
	ADD FOREIGN KEY (IDCALENDARIO) 
		REFERENCES CALENDARIO (IDCALENDARIO);

ALTER TABLE REQUISICAOMUDANCA 
	ADD NIVELURGENCIA VARCHAR2(255);

ALTER TABLE EXECUCAOMUDANCA 
	ADD FOREIGN KEY (IDINSTANCIAFLUXO) 
		REFERENCES BPM_INSTANCIAFLUXO (IDINSTANCIA);

ALTER TABLE EXECUCAOMUDANCA 
	ADD FOREIGN KEY (IDREQUISICAOMUDANCA) 
		REFERENCES REQUISICAOMUDANCA (IDREQUISICAOMUDANCA);

ALTER TABLE EXECUCAOMUDANCA 
	ADD FOREIGN KEY (IDFLUXO) 
		REFERENCES BPM_FLUXO (IDFLUXO);

ALTER TABLE OCORRENCIAMUDANCA 
	ADD FOREIGN KEY (IDITEMTRABALHO) 
		REFERENCES BPM_ITEMTRABALHOFLUXO (IDITEMTRABALHO);

ALTER TABLE OCORRENCIAMUDANCA 
	ADD FOREIGN KEY (IDJUSTIFICATIVA) 
		REFERENCES JUSTIFICATIVASOLICITACAO (IDJUSTIFICATIVA);   

ALTER TABLE OCORRENCIAMUDANCA 
	ADD FOREIGN KEY (IDREQUISICAOMUDANCA)  
		REFERENCES  REQUISICAOMUDANCA (IDREQUISICAOMUDANCA); 

ALTER TABLE REQUISICAOMUDANCAITEMCONFIGURA 
	ADD FOREIGN KEY (IDREQUISICAOMUDANCA) 
		REFERENCES  REQUISICAOMUDANCA (IDREQUISICAOMUDANCA);

ALTER TABLE REQUISICAOMUDANCAITEMCONFIGURA 
	ADD FOREIGN KEY (IDITEMCONFIGURACAO) 
		REFERENCES ITEMCONFIGURACAO (IDITEMCONFIGURACAO);

ALTER TABLE REQUISICAOMUDANCASERVICO 
	ADD FOREIGN KEY (IDREQUISICAOMUDANCA) 
		REFERENCES REQUISICAOMUDANCA (IDREQUISICAOMUDANCA);

ALTER TABLE REQUISICAOMUDANCASERVICO  
	ADD FOREIGN KEY (IDSERVICO) 
		REFERENCES SERVICO (IDSERVICO);	 

ALTER TABLE ITEMCONFIGURACAO 
	ADD IDPROPRIETARIO NUMBER(38);

ALTER TABLE ITEMCONFIGURACAO 
	ADD DATAEXPIRACAO DATE;

ALTER TABLE ITEMCONFIGURACAO 
	ADD FOREIGN KEY (IDPROPRIETARIO) 
		REFERENCES EMPREGADOS (IDEMPREGADO);

ALTER TABLE GRUPOITEMCONFIGURACAO 
	ADD EMAIL VARCHAR2(50);

ALTER TABLE ITEMCONFIGURACAO 
	ADD VERSAO VARCHAR2(50);

-- DESSE PONTO EM DIANTE FOI VERIFICADO QUE AS ESTRUTURAS NÃO CONSTAM NO BANCO DE DADOS ORACLE.

CREATE TABLE REQUISITOSLA (
	IDREQUISITOSLA       NUMBER(38) NOT NULL,
	IDEMPREGADO          NUMBER(38),
	REQUISITADOEM        DATE,
	ASSUNTO              VARCHAR2(200) NOT NULL,
	DETALHAMENTO         CLOB,
	SITUACAO             CHAR(1) NOT NULL,
	CRIADOPOR            VARCHAR2(30),
	CRIADOEM             TIMESTAMP,
	MODIFICADOPOR        VARCHAR2(30),
	MODIFICADOEM         TIMESTAMP,
	DELETED              CHAR(1)
);

ALTER TABLE REQUISITOSLA
	ADD PRIMARY KEY (IDREQUISITOSLA);

ALTER TABLE REQUISITOSLA 
	ADD FOREIGN KEY (IDEMPREGADO)
		REFERENCES EMPREGADOS (IDEMPREGADO); 

CREATE TABLE SLAREQUISITOSLA (
	IDREQUISITOSLA       	NUMBER(38) NOT NULL,
	IDACORDONIVELSERVICO 	NUMBER(38) NOT NULL,
	DATAVINCULACAO       	TIMESTAMP,
	DATAULTMODIFICACAO   	TIMESTAMP,
	DELETED              	CHAR(1)
);

ALTER TABLE SLAREQUISITOSLA
	ADD PRIMARY KEY (IDREQUISITOSLA, IDACORDONIVELSERVICO);

ALTER TABLE SLAREQUISITOSLA 
	ADD FOREIGN KEY (IDREQUISITOSLA)
		REFERENCES REQUISITOSLA (IDREQUISITOSLA);

ALTER TABLE SLAREQUISITOSLA 
	ADD FOREIGN KEY (IDACORDONIVELSERVICO)
		REFERENCES ACORDONIVELSERVICO (IDACORDONIVELSERVICO);

ALTER TABLE ACORDONIVELSERVICO 
	ADD CRIADOEM TIMESTAMP;

ALTER TABLE ACORDONIVELSERVICO 
	ADD CRIADOPOR VARCHAR2(30);

ALTER TABLE ACORDONIVELSERVICO 
	ADD MODIFICADOEM TIMESTAMP;

ALTER TABLE ACORDONIVELSERVICO 
	ADD MODIFICADOPOR VARCHAR2(30);

CREATE TABLE ACORDONIVELSERVICO_HIST (
	IDACORDONIVELSERVICO_HIST 	    NUMBER(19) NOT NULL,
	IDACORDONIVELSERVICO 		        NUMBER(19) NOT NULL,
	IDSERVICOCONTRATO    		        NUMBER(19),
	IDPRIORIDADEPADRAO		          NUMBER(11),
	SITUACAO             		        CHAR(1) NOT NULL,
	TITULOSLA            		        VARCHAR2(500) NOT NULL,
	DISPONIBILIDADE      		        NUMBER(10,3),
	DESCRICAOSLA         		        CLOB,
	ESCOPOSLA            		        CLOB,
	DATAINICIO           		        DATE NOT NULL,
	DATAFIM              		        DATE,
	AVALIAREM            		        DATE,
	TIPO                 		        CHAR(1),
	VALORLIMITE          		        NUMBER(15,3),
	DETALHEGLOSA         		        CLOB,
	DETALHELIMITEGLOSA   		        CLOB,
	UNIDADEVALORLIMITE   		        VARCHAR2(150),
	IMPACTO              		        CHAR(1),
	URGENCIA             		        CHAR(1),
	PERMITEMUDARIMPURG  		        CHAR(1),
	DELETED              		        CHAR(1),
	CRIADOEM             		        TIMESTAMP(6),
	CRIADOPOR            		        VARCHAR2(30),
	MODIFICADOEM         		        TIMESTAMP(6),
	MODIFICADOPOR       		        VARCHAR2(30),
	CONTEUDODADOS        		        CLOB,
	IDFORMULA           		        NUMBER(10)
);

ALTER TABLE ACORDONIVELSERVICO_HIST
	ADD PRIMARY KEY (IDACORDONIVELSERVICO_HIST);

ALTER TABLE ACORDONIVELSERVICO_HIST 
	MODIFY IDPRIORIDADEPADRAO NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO_HIST 
	ADD FOREIGN KEY (IDPRIORIDADEPADRAO)
		REFERENCES PRIORIDADE (IDPRIORIDADE);

ALTER TABLE ACORDONIVELSERVICO_HIST 
	ADD FOREIGN KEY (IDSERVICOCONTRATO) 
		REFERENCES SERVICOCONTRATO (IDSERVICOCONTRATO);

CREATE TABLE CONTRATOS_HIST (
	IDCONTRATO_HIST 		      NUMBER(11) NOT NULL,
	IDCONTRATO 			          NUMBER(11) NOT NULL,
	IDCLIENTE 			          NUMBER(11) NOT NULL,
	IDMOEDA 			            NUMBER(11) DEFAULT NULL,
	IDFORNECEDOR 			        NUMBER(20) NOT NULL,
	NUMERO 				            VARCHAR2(30) NOT NULL,
	OBJETO 				            CLOB NOT NULL,
	DATACONTRATO 			        DATE NOT NULL,
	VALORESTIMADO 		        NUMBER(18,3) DEFAULT NULL,
	TIPOTEMPOESTIMADO	        CHAR(1) DEFAULT NULL,
	TEMPOESTIMADO 		        NUMBER(11) DEFAULT NULL,
	TIPO 				              CHAR(1) NOT NULL,
	SITUACAO 			            CHAR(1) NOT NULL,
	COTACAOMOEDA 			        NUMBER(18,3) DEFAULT NULL,
	CADASTROMANUALUSUARIO 		CHAR(1) DEFAULT NULL,
	DELETED 			            CHAR(1) DEFAULT NULL,
	IDGRUPOSOLICITANTE 		    NUMBER(11) DEFAULT NULL,
	DATAFIMCONTRATO 		      DATE DEFAULT NULL,
	CRIADOEM             		  TIMESTAMP(6),
  CRIADOPOR            		  VARCHAR2(30),
	MODIFICADOEM        		  TIMESTAMP(6),
	MODIFICADOPOR        		  VARCHAR2(30),  
	CONTEUDODADOS        		  CLOB,
	PRIMARY KEY (IDCONTRATO_HIST)	
);

CREATE INDEX IDX_CON_HIS_IDMOEDA 
	ON CONTRATOS_HIST (IDMOEDA);

CREATE INDEX IDX_CON_HIS_IDCLIENTE 
	ON CONTRATOS_HIST (IDCLIENTE);

CREATE INDEX IDX_CON_HIS_IDFORNECEDOR 
	ON CONTRATOS_HIST (IDFORNECEDOR);

ALTER TABLE CONTATOSOLICITACAOSERVICO 
	MODIFY TELEFONECONTATO VARCHAR2(70);

INSERT INTO PROCESSAMENTOBATCH (IDPROCESSAMENTOBATCH, DESCRICAO, EXPRESSAOCRON, CONTEUDO, TIPO, SITUACAO)
VALUES (4, 'VERIFICA E AVISA A DATA DE EXPIRAÇÃO DE UM ITEM DE CONFIGURAÇÃO', '0 45 23 * * ? *', 'BR.COM.CENTRALIT.CITCORPORE.QUARTZ.JOB.VERIFICAVALIDADELICENCA', 'C', 'A');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR)
VALUES (6,'VALIDADE DO ITEM CONFIGURAÇÃO - ${IDENTIFICACAO}', 'INFORMAMOS QUE O ITEM DE CONFIGURA&CCEDIL;&ATILDE;O IDENTIFICADO COMO ${IDENTIFICACAO} EXPIRAR&AACUTE; NO DIA&NBSP;${DATAEXPIRACAO}.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.<BR />', 'A', '');

CREATE TABLE CATEGORIAOCORRENCIA (
	IDCATEGORIAOCORRENCIA 	NUMBER(11) NOT NULL,
	NOME 			              VARCHAR2(20) NOT NULL,
	DATAINICIO 		          DATE NOT NULL,
	DATAFIM 		            DATE
);

ALTER TABLE CATEGORIAOCORRENCIA 
	ADD PRIMARY KEY(IDCATEGORIAOCORRENCIA);

CREATE TABLE ORIGEMOCORRENCIA (
	IDORIGEMOCORRENCIA 	    NUMBER(11) NOT NULL,
	NOME 			              VARCHAR2(20) NOT NULL,
	DATAINICIO 		          DATE NOT NULL,
	DATAFIM 		            DATE
);

ALTER TABLE ORIGEMOCORRENCIA 
	ADD PRIMARY KEY(IDORIGEMOCORRENCIA);

ALTER TABLE OCORRENCIASOLICITACAO 
	ADD IDCATEGORIAOCORRENCIA NUMBER(11);

ALTER TABLE OCORRENCIASOLICITACAO 
	ADD IDORIGEMOCORRENCIA NUMBER(11);

ALTER TABLE OCORRENCIASOLICITACAO 
	ADD FOREIGN KEY(IDCATEGORIAOCORRENCIA) 
		REFERENCES CATEGORIAOCORRENCIA(IDCATEGORIAOCORRENCIA);

ALTER TABLE OCORRENCIASOLICITACAO 
	ADD FOREIGN KEY(IDORIGEMOCORRENCIA) 
		REFERENCES ORIGEMOCORRENCIA(IDORIGEMOCORRENCIA);

CREATE TABLE LINGUA (
	IDLINGUA 	    NUMBER(38) NOT NULL,
	NOME 		      VARCHAR2(245) NULL,
	SIGLA 		    VARCHAR2(245) NULL,
	DATAINICIO	  DATE NULL,
	DATAFIM 	    DATE NULL,
	PRIMARY KEY (IDLINGUA)
);

CREATE TABLE DICIONARIO (
	IDDICIONARIO 	  NUMBER(38) NOT NULL,
	NOME 		        VARCHAR2(245) NULL,
	VALOR 		      VARCHAR2(245) NULL,
	IDLINGUA 	      NUMBER(38) NULL
);

ALTER TABLE DICIONARIO
	ADD PRIMARY KEY (IDDICIONARIO);

ALTER TABLE DICIONARIO
	ADD FOREIGN KEY (IDLINGUA) REFERENCES LINGUA (IDLINGUA);
  
CREATE INDEX IDX_DIC_LIN 
	ON DICIONARIO (IDLINGUA);

ALTER TABLE GRUPOITEMCONFIGURACAO 
	ADD EMAILGRUPOITEMCONFIGURACAO VARCHAR2(256);

CREATE TABLE NOTIFICACAO (
	IDNOTIFICACAO 	  NUMBER(38) NOT NULL,
	TITULO 		        VARCHAR2(255),
	TIPONOTIFICACAO   CHAR(1),
	DATAINICIO 	      DATE,
	DATAFIM 	        DATE,
	PRIMARY KEY (IDNOTIFICACAO) 
);

ALTER TABLE TIPOITEMCONFIGURACAO 
	ADD CATEGORIA NUMBER(38);

CREATE TABLE MIDIA (
	IDMIDIA 	    NUMBER(38) NOT NULL,
	NOME 		      VARCHAR2(200) DEFAULT NULL,
	MIDIACOL	    VARCHAR2(45) DEFAULT NULL,
	PRIMARY KEY (IDMIDIA)
);

CREATE TABLE MIDIASOFTWARE (
	IDMIDIASOFTWARE 	NUMBER(38) NOT NULL,
	NOME 			        VARCHAR2(200) NOT NULL,
	ENDFISICO 		    VARCHAR2(500) DEFAULT NULL,
	VERSAO 			      VARCHAR2(20) DEFAULT NULL,
	ENDLOGICO 		    VARCHAR2(200) DEFAULT NULL,
	LICENCAS 		      NUMBER(38) DEFAULT NULL,
	IDMIDIA 		      NUMBER(38) DEFAULT NULL,
	IDTIPOSOFTWARE 		NUMBER(38) DEFAULT NULL,
	DATAINICIO 		    DATE DEFAULT NULL,
	DATAFIM 		      DATE DEFAULT NULL,
	PRIMARY KEY (IDMIDIASOFTWARE)
);

CREATE INDEX IDX_MDS_MID 
	ON MIDIASOFTWARE (IDMIDIA);

CREATE INDEX IDX_MDS_TPS
	ON MIDIASOFTWARE (IDTIPOSOFTWARE);

CREATE TABLE TIPOSOFTWARE (
	IDTIPOSOFTWARE    NUMBER(38) NOT NULL,
	NOME              VARCHAR2(200) DEFAULT NULL,
	PRIMARY KEY (IDTIPOSOFTWARE)
);

CREATE TABLE NOTIFICACAOGRUPO (
	IDNOTIFICACAO 	NUMBER(38),
	IDGRUPO 	      NUMBER(38)
);

ALTER TABLE NOTIFICACAOGRUPO
	ADD FOREIGN KEY (IDNOTIFICACAO)
		REFERENCES NOTIFICACAO (IDNOTIFICACAO);

ALTER TABLE NOTIFICACAOGRUPO
	ADD FOREIGN KEY (IDGRUPO)
		REFERENCES GRUPO (IDGRUPO);

CREATE TABLE NOTIFICACAOUSUARIO (
	IDNOTIFICACAO 	NUMBER(38),
	IDUSUARIO 	    NUMBER(38)
);

ALTER TABLE NOTIFICACAOUSUARIO
	ADD FOREIGN KEY (IDNOTIFICACAO)
		REFERENCES NOTIFICACAO (IDNOTIFICACAO);

ALTER TABLE NOTIFICACAOUSUARIO
	ADD FOREIGN KEY (IDUSUARIO)
		REFERENCES USUARIO (IDUSUARIO);

ALTER TABLE BASECONHECIMENTO 
	ADD IDNOTIFICACAO NUMBER(38);

ALTER TABLE BASECONHECIMENTO
	ADD FOREIGN KEY (IDNOTIFICACAO) 
		REFERENCES NOTIFICACAO (IDNOTIFICACAO);

ALTER TABLE PASTA 
	ADD IDNOTIFICACAO NUMBER(38);

CREATE TABLE IMPORTANCIACONHECIMENTOUSUARIO (
	IDBASECONHECIMENTO 	    NUMBER(38) NOT NULL,
	IDUSUARIO 		          NUMBER(38) NOT NULL,
	GRAUIMPORTANCIAUSUARIO 	VARCHAR2(45) NOT NULL,
	PRIMARY KEY (IDBASECONHECIMENTO, IDUSUARIO) 
);

CREATE TABLE IMPORTANCIACONHECIMENTOGRUPO (
	IDBASECONHECIMENTO 	    NUMBER(38) NOT NULL,
	IDGRUPO 		            NUMBER(38) NOT NULL,
	GRAUIMPORTANCIAGRUPO 	  VARCHAR2(45) NOT NULL,
	PRIMARY KEY (IDBASECONHECIMENTO, IDGRUPO)
);

CREATE TABLE BASECONHECIMENTORELACIONADO (
	IDBASECONHECIMENTO 		          NUMBER(38) NOT NULL,
	IDBASECONHECIMENTORELACIONADO 	NUMBER(38) NOT NULL,
	PRIMARY KEY (IDBASECONHECIMENTO, IDBASECONHECIMENTORELACIONADO)
);

ALTER TABLE BASECONHECIMENTO 
	ADD JUSTIFICATIVAOBSERVACAO VARCHAR2(500);

ALTER TABLE BASECONHECIMENTO 
	ADD DATAPUBLICACAO DATE;

ALTER TABLE BASECONHECIMENTO 
	ADD FONTEREFERENCIA VARCHAR2(255);

ALTER TABLE BASECONHECIMENTO 
	ADD FAQ VARCHAR2(45);

ALTER TABLE BASECONHECIMENTO 
	ADD ARQUIVADO VARCHAR2(45);

ALTER TABLE BASECONHECIMENTO
  ADD IDUSUARIOAUTOR NUMBER(38);

ALTER TABLE BASECONHECIMENTO
  ADD IDUSUARIOAPROVADOR NUMBER(38);

ALTER TABLE PERFILACESSOPASTA 
  ADD PERMITELEITURA CHAR(1);

ALTER TABLE PERFILACESSOPASTA 
  ADD PERMITELEITURAGRAVACAO CHAR(1);

ALTER TABLE PASTA 
	ADD HERDAPERMISSOES CHAR(1);

-- ATRIBUI PERMISSÃO DE LEITURA/GRAVAÇÃO PARA O PERFIL ADMINISTRADOR
UPDATE PERFILACESSOPASTA SET PERMITELEITURA = 'N', PERMITELEITURAGRAVACAO = 'S' WHERE IDPERFIL = 1;

-- ATRIBUI PERMISSÃO DE LEITURA PARA OS DEMAIS PERFIS
UPDATE PERFILACESSOPASTA SET PERMITELEITURA = 'S', PERMITELEITURAGRAVACAO = 'N' WHERE IDPERFIL <> 1;

CREATE TABLE HISTORICOBASECONHECIMENTO (
	IDHISTORICOBASECONHECIMENTO 	  NUMBER(38) NOT NULL,
	IDBASECONHECIMENTO 		          NUMBER(38) NOT NULL,
	IDPASTA  			                  NUMBER(38) DEFAULT NULL,
	DATAINICIO 			                DATE DEFAULT NULL,
	DATAFIM 			                  DATE DEFAULT NULL,
	TITULO 				                  VARCHAR2(256) DEFAULT NULL,
	CONTEUDO 			                  CLOB,
	STATUS 				                  CHAR(1) DEFAULT NULL,
	IDBASECONHECIMENTOPAI  		      NUMBER(38) DEFAULT NULL,
	DATAEXPIRACAO 			            DATE DEFAULT NULL,
	VERSAO 				                  VARCHAR2(45) DEFAULT NULL,
	IDUSUARIOAUTOR 			            NUMBER(38) DEFAULT NULL,
	IDUSUARIOAPROVADOR 		          NUMBER(38) DEFAULT NULL,
	FONTEREFERENCIA 		            VARCHAR2(255) DEFAULT NULL,
	IDNOTIFICACAO 			            NUMBER(38) DEFAULT NULL,
	DATAPUBLICACAO 			            DATE DEFAULT NULL,
	JUSTIFICATIVAOBSERVACAO 	      VARCHAR2(500) DEFAULT NULL,
	FAQ 				                    VARCHAR2(45) DEFAULT NULL,
	ORIGEM 				                  CHAR(1) DEFAULT NULL,
	ARQUIVADO 			                VARCHAR2(45) DEFAULT NULL,
	IDUSUARIOALTERACAO 		          NUMBER(38) DEFAULT NULL,
	DATAHORAALTERACAO 		          TIMESTAMP DEFAULT NULL,
	PRIMARY KEY (IDHISTORICOBASECONHECIMENTO)
);

ALTER TABLE BASECONHECIMENTO
	ADD IDHISTORICOBASECONHECIMENTO NUMBER(38);
  
ALTER TABLE BASECONHECIMENTO
	ADD FOREIGN KEY (IDHISTORICOBASECONHECIMENTO) 
		REFERENCES HISTORICOBASECONHECIMENTO (IDHISTORICOBASECONHECIMENTO);

INSERT INTO PROCESSAMENTOBATCH (IDPROCESSAMENTOBATCH, DESCRICAO, EXPRESSAOCRON, CONTEUDO, TIPO, SITUACAO) 
VALUES (6, 'VERIFICA E AVISA A DATA DE EXPIRAÇÃO DE UM ITEM DE CONFIGURAÇÃO', '0 03 09 * * ? *',
'BR.COM.CENTRALIT.CITCORPORE.QUARTZ.JOB.VERIFICAVALIDADELICENCA', 'C', 'A');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (7, 'VALIDADE DO DOCUMENTO - ${TITULO}', 'INFORMAMOS QUE O DOCUMENTO TITULADO COMO ${TITULO} EXPIRAR&AACUTE; NO DIA&NBSP;${DATAEXPIRACAO}.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.<BR />', 'A', 'BC');

/* OPERACAO NAO PERMITIDA.
ALTER TABLE BASECONHECIMENTO 
	ADD ORIGEM CHAR(1) NOT NULL;
*/

ALTER TABLE BASECONHECIMENTO 
	ADD ORIGEM CHAR(1);

ALTER TABLE REQUISICAOMUDANCA
	ADD IDBASECONHECIMENTO NUMBER(38);

ALTER TABLE REQUISICAOMUDANCA 
	ADD FOREIGN KEY (IDBASECONHECIMENTO) 
		REFERENCES BASECONHECIMENTO (IDBASECONHECIMENTO);

ALTER TABLE SOLICITACAOSERVICO 
	ADD IDSOLICITACAORELACIONADA NUMBER(38);

CREATE TABLE REVISARSLA (
	IDREVISARSLA 		        NUMBER(38) NOT NULL,
	IDACORDONIVELSERVICO 	  NUMBER(38) NOT NULL,
	DATAREVISAO 		        DATE NOT NULL,
	DETALHEREVISAO 		      CLOB DEFAULT NULL,
	OBSERVACAO 		          VARCHAR2(200) DEFAULT NULL,
	DELETED 		            CHAR(1) DEFAULT NULL,
	PRIMARY KEY (IDREVISARSLA)
);

CREATE TABLE IMPACTO (
	IDIMPACTO NUMBER(10,0),
	NIVELIMPACTO VARCHAR2(100 CHAR),
	SIGLAIMPACTO CHAR(2 CHAR),
	PRIMARY KEY (IDIMPACTO)
);

CREATE TABLE URGENCIA (
	IDURGENCIA NUMBER(10,0),
	NIVELURGENCIA VARCHAR2(100 CHAR),
	SIGLAURGENCIA CHAR(2 CHAR),
	PRIMARY KEY (IDURGENCIA)
);

CREATE TABLE MATRIZPRIORIDADE (
	IDMATRIZPRIORIDADE 	      NUMBER(38) NOT NULL,
	IDIMPACTO 		            NUMBER(38) NOT NULL,
	IDURGENCIA 		            NUMBER(38) NOT NULL,
	VALORPRIORIDADE 	        NUMBER(38) NOT NULL,
	IDCONTRATO 		            NUMBER(38) DEFAULT NULL,
	DELETED 		              CHAR(1) DEFAULT NULL,
	PRIMARY KEY (IDMATRIZPRIORIDADE)
);

ALTER TABLE MATRIZPRIORIDADE 
	ADD FOREIGN KEY (IDIMPACTO) REFERENCES IMPACTO (IDIMPACTO);

ALTER TABLE MATRIZPRIORIDADE 
	ADD FOREIGN KEY (IDURGENCIA) 
		REFERENCES URGENCIA (IDURGENCIA);

CREATE INDEX FK_IMPACTO_IDX 
	ON MATRIZPRIORIDADE (IDIMPACTO);

CREATE INDEX FK_URGENCIA_IDX 
	ON MATRIZPRIORIDADE (IDURGENCIA);

ALTER TABLE BASECONHECIMENTO 
	ADD PRIVACIDADE VARCHAR2(45);
  
ALTER TABLE BASECONHECIMENTO 
	ADD SITUACAO VARCHAR2(45);

CREATE TABLE EVENTOMONITORAMENTO (
	IDEVENTOMONITORAMENTO 	    NUMBER(38) NOT NULL,
	NOMEEVENTO 		              VARCHAR2(255) NOT NULL,
	DETALHAMENTO 		            CLOB DEFAULT NULL,
	CRIADOPOR 		              VARCHAR2(255) DEFAULT NULL,
	MODIFICADOPOR 		          VARCHAR2(255) DEFAULT NULL,
	DATACRIACAO 		            DATE NULL,
	ULTMODIFICACAO 		          DATE NULL,
	PRIMARY KEY (IDEVENTOMONITORAMENTO)
);

CREATE TABLE EVENTOMONITCONHECIMENTO (
	IDEVENTOMONITORAMENTO 	    NUMBER(38) NOT NULL,
	IDBASECONHECIMENTO 	        NUMBER(38) NOT NULL,
	PRIMARY KEY (IDEVENTOMONITORAMENTO, IDBASECONHECIMENTO)
);

CREATE TABLE NAGIOSCONEXAO (
	IDNAGIOSCONEXAO      NUMBER(38) NOT NULL,
	NOME                 VARCHAR2(255) NOT NULL,
	NOMEJNDI             VARCHAR2(255),
	CRIADOPOR            VARCHAR2(40),
	MODIFICADOPOR        VARCHAR2(40),
	DATACRIACAO          DATE,
	ULTMODIFICACAO       DATE,
	PRIMARY KEY (IDNAGIOSCONEXAO)
);

CREATE TABLE RECURSO (
	IDRECURSO            NUMBER(38) NOT NULL,
	IDGRUPORECURSO       NUMBER(38) NOT NULL,
	IDRECURSOPAI         NUMBER(38),
	NOMERECURSO          VARCHAR2(150) NOT NULL,
	DATAINICIO           DATE NOT NULL,
	DATAFIM              DATE,
	TIPOATUALIZACAO      CHAR(1) NOT NULL,
	DELETED              CHAR(1)
);

ALTER TABLE RECURSO
	ADD PRIMARY KEY (IDRECURSO);

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDRECURSOPAI)
		REFERENCES RECURSO (IDRECURSO);

ALTER TABLE RECURSO 
	ADD IDNAGIOSCONEXAO NUMBER(38);

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDNAGIOSCONEXAO)
		REFERENCES NAGIOSCONEXAO (IDNAGIOSCONEXAO);
	  
ALTER TABLE RECURSO 
	ADD HOSTNAME VARCHAR2(255);

ALTER TABLE RECURSO 
	ADD SERVICENAME VARCHAR2(255);

ALTER TABLE RECURSO 
	ADD HORAINICIOFUNC VARCHAR2(5);

ALTER TABLE RECURSO 
	ADD HORAFIMFUNC VARCHAR2(5);

ALTER TABLE RECURSO 
	ADD IDCALENDARIO NUMBER(38);

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDCALENDARIO)
		REFERENCES CALENDARIO (IDCALENDARIO);

ALTER TABLE RECURSO 
	ADD STATUSABERTURAINC VARCHAR2(255);

ALTER TABLE RECURSO 
	ADD IDSOLICITANTE NUMBER(38);

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDSOLICITANTE) 
		REFERENCES EMPREGADOS (IDEMPREGADO);

ALTER TABLE RECURSO 
	ADD EMAILABERTURAINC VARCHAR2(255);

ALTER TABLE RECURSO 
	ADD DESCRICAOABERTINC CLOB;

ALTER TABLE RECURSO 
	ADD IMPACTO CHAR(1);

ALTER TABLE RECURSO 
	ADD URGENCIA CHAR(1);

ALTER TABLE RECURSO 
	ADD IDGRUPO NUMBER(38);

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDGRUPO) 
		REFERENCES GRUPO (IDGRUPO);

ALTER TABLE RECURSO 
	ADD IDORIGEM NUMBER(38);

ALTER TABLE RECURSO 
	MODIFY IDORIGEM NUMBER(38) DEFAULT NULL;

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDORIGEM)
		REFERENCES ORIGEMATENDIMENTO (IDORIGEM);

ALTER TABLE RECURSO 
	ADD IDSERVICOCONTRATO NUMBER(38);

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDSERVICOCONTRATO)
		REFERENCES SERVICOCONTRATO (IDSERVICOCONTRATO);

ALTER TABLE RECURSO 
	ADD IDEVENTOMONITORAMENTO NUMBER(38);

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDEVENTOMONITORAMENTO)
		REFERENCES EVENTOMONITORAMENTO (IDEVENTOMONITORAMENTO);

ALTER TABLE RECURSO 
	ADD IDITEMCONFIGURACAO NUMBER(38);

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDITEMCONFIGURACAO) 
		REFERENCES ITEMCONFIGURACAO (IDITEMCONFIGURACAO);

ALTER TABLE RECURSO 
	ADD STATUSALERTA VARCHAR2(255);

ALTER TABLE RECURSO 
	ADD EMAILSALERTA CLOB;

ALTER TABLE RECURSO 
	ADD DESCRICAOALERTA CLOB;

CREATE TABLE SOLICITACAOSERVICOEVTMON (
	IDSOLICITACAOSERVICO 		    NUMBER(38) NOT NULL,
	IDEVENTOMONITORAMENTO 		  NUMBER(38) NOT NULL,
	IDRECURSO            		    NUMBER(38),
	NOMEHOST             		    VARCHAR2(255),
	NOMESERVICE          		    VARCHAR2(255),
	INFOADD              		    CLOB,
	PRIMARY KEY (IDSOLICITACAOSERVICO, IDEVENTOMONITORAMENTO)
);

ALTER TABLE SOLICITACAOSERVICOEVTMON 
	ADD FOREIGN KEY (IDSOLICITACAOSERVICO)
		REFERENCES SOLICITACAOSERVICO (IDSOLICITACAOSERVICO);

ALTER TABLE SOLICITACAOSERVICOEVTMON 
	ADD FOREIGN KEY (IDEVENTOMONITORAMENTO)
		REFERENCES EVENTOMONITORAMENTO (IDEVENTOMONITORAMENTO);

ALTER TABLE SOLICITACAOSERVICOEVTMON 
	ADD FOREIGN KEY (IDRECURSO)
		REFERENCES RECURSO (IDRECURSO);
	  
CREATE TABLE GRUPORECURSOS (
	IDGRUPORECURSO       NUMBER(38) NOT NULL,
	NOMEGRUPORECURSO     VARCHAR2(70) NOT NULL,
	SITUACAO             CHAR(1) NOT NULL,
	DELETED              CHAR(1)
);

ALTER TABLE GRUPORECURSOS
	ADD PRIMARY KEY (IDGRUPORECURSO);

ALTER TABLE RECURSO 
	ADD FOREIGN KEY (IDGRUPORECURSO)
		REFERENCES GRUPORECURSOS (IDGRUPORECURSO);
      
ALTER TABLE NAGIOSCONEXAO 
	ADD DELETED CHAR(1);

ALTER TABLE ACORDOSERVICOCONTRATO 
	ADD IDRECURSO NUMBER(10,0);

ALTER TABLE ACORDOSERVICOCONTRATO 
	ADD FOREIGN KEY (IDRECURSO)
		REFERENCES RECURSO (IDRECURSO);

CREATE TABLE EXTERNALCONNECTION (
	IDEXTERNALCONNECTION  NUMBER(38) NOT NULL,
	NOME                  VARCHAR2(80) NOT NULL,
	TIPO                  CHAR(1) NOT NULL,
	URLJDBC               VARCHAR2(255),
	JDBCDBNAME            VARCHAR2(255),
	JDBCDRIVER            VARCHAR2(255),
	JDBCUSER              VARCHAR2(255),
	JDBCPASSWORD          VARCHAR2(255),
	FILENAME              VARCHAR2(500),
	PRIMARY KEY (IDEXTERNALCONNECTION)
);

CREATE TABLE IMPORTCONFIG (
	IDIMPORTCONFIG       	NUMBER(38) NOT NULL,
	TIPO                 	CHAR(1) NOT NULL,
	IDEXTERNALCONNECTION 	NUMBER(38),
	TABELAORIGEM         	VARCHAR2(255),
	TABELADESTINO        	VARCHAR2(255),
	FILTROORIGEM         	CLOB,
	PRIMARY KEY (IDIMPORTCONFIG)
);

ALTER TABLE IMPORTCONFIG 
	ADD FOREIGN KEY (IDEXTERNALCONNECTION)
		REFERENCES EXTERNALCONNECTION (IDEXTERNALCONNECTION);

CREATE TABLE IMPORTCONFIGCAMPOS (
	IDIMPORTCONFIGCAMPO  	NUMBER(38) NOT NULL,
	IDIMPORTCONFIG       	NUMBER(38) NOT NULL,
	ORIGEM               	VARCHAR2(255),
	DESTINO              	VARCHAR2(255),
	SCRIPT               	CLOB,
	PRIMARY KEY (IDIMPORTCONFIGCAMPO)
);

ALTER TABLE IMPORTCONFIGCAMPOS 
	ADD FOREIGN KEY (IDIMPORTCONFIG)
		REFERENCES IMPORTCONFIG (IDIMPORTCONFIG);
      
ALTER TABLE IMPORTCONFIG 
	ADD NOME VARCHAR2(100);

ALTER TABLE EXTERNALCONNECTION 
	ADD SCHEMADB VARCHAR2(255);

ALTER TABLE ITEMCONFIGURACAO
	ADD FAMILIA VARCHAR2(250) DEFAULT NULL;
  
ALTER TABLE ITEMCONFIGURACAO
	ADD CLASSE VARCHAR2(250) DEFAULT NULL;
  
ALTER TABLE ITEMCONFIGURACAO
	ADD LOCALIDADE	VARCHAR2(250) DEFAULT NULL;
  
ALTER TABLE ITEMCONFIGURACAO  
	ADD STATUS	NUMBER(38) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO
	ADD CRITICIDADE NUMBER(38) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO
	ADD NUMEROSERIE VARCHAR2(45) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO
	ADD IDMUDANCA NUMBER(38) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO
	ADD IDPROBLEMA NUMBER(38) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO
	ADD IDINCIDENTE NUMBER(38) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO
	ADD IDMIDIASOFTWARE NUMBER(38) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO
	ADD IMPACTO VARCHAR2(255) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO
	ADD URGENCIA VARCHAR2(255) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO
	ADD IDBASECONHECIMENTO	NUMBER(38) DEFAULT NULL;

ALTER TABLE ITEMCONFIGURACAO 
	ADD FOREIGN KEY (IDBASECONHECIMENTO)
		REFERENCES BASECONHECIMENTO (IDBASECONHECIMENTO);

CREATE TABLE HISTORICOIC (
	IDHISTORICOIC 			        NUMBER(38) NOT NULL,
	IDITEMCONFIGURACAO 		      NUMBER(38) NOT NULL,
	IDENTIFICACAO 			        VARCHAR2(400) NOT NULL,
	IDITEMCONFIGURACAOPAI 		  NUMBER(38) DEFAULT NULL,
	IDTIPOITEMCONFIGURACAO 		  NUMBER(38) DEFAULT NULL,
	IDGRUPOITEMCONFIGURACAO 	  NUMBER(38) DEFAULT NULL,
	IDPROPRIETARIO 			        NUMBER(38) DEFAULT NULL,
	VERSAO 				              VARCHAR2(250) DEFAULT NULL,
	FAMILIA 			              VARCHAR2(250) DEFAULT NULL,
	IDFAMILIAITEMCONFIGURACAO 	NUMBER(38) DEFAULT NULL,
	CLASSE 				              VARCHAR2(250) DEFAULT NULL,
	IDCLASSEITEMCONFIGURACAO 	  NUMBER(38) DEFAULT NULL,
	LOCALIDADE 			            VARCHAR2(250) DEFAULT NULL,
	STATUS 				              NUMBER(38) DEFAULT NULL,
	CRITICIDADE 			          NUMBER(38) DEFAULT NULL,
	NUMEROSERIE 			          VARCHAR2(45) DEFAULT NULL,
	DATAEXPIRACAO 			        DATE DEFAULT NULL,
	IDMUDANCA 			            NUMBER(38) DEFAULT NULL,
	IDPROBLEMA 			            NUMBER(38) DEFAULT NULL,
	IDINCIDENTE 			          NUMBER(38) DEFAULT NULL,
	IDAUTORALTERACAO 		        NUMBER(38) NOT NULL,
	DATAHORAALTERACAO 		      TIMESTAMP DEFAULT SYSDATE,
	BASELINE 			              VARCHAR2(30) DEFAULT NULL,
	RESTAURACAO 			          NUMBER(38) DEFAULT NULL,
	IDMIDIASOFTWARE 		        NUMBER(38) DEFAULT NULL,
	IMPACTO 			              VARCHAR2(255) DEFAULT NULL,
	URGENCIA 			              VARCHAR2(255) DEFAULT NULL,
	HISTORICOVERSAO 		        FLOAT DEFAULT NULL,
	PRIMARY KEY (IDHISTORICOIC)
);

CREATE INDEX FK_ITEMCONFIGURACAO 
	ON HISTORICOIC (IDITEMCONFIGURACAO);

CREATE INDEX FK_AUTORALTERACAO 
	ON HISTORICOIC (IDAUTORALTERACAO);

CREATE INDEX FK_FAMILIAITEMCONFIGURACAO 
	ON HISTORICOIC (IDFAMILIAITEMCONFIGURACAO);

CREATE INDEX FK_CLASSEITEMCONFIGURACAO 
	ON HISTORICOIC (IDCLASSEITEMCONFIGURACAO);

CREATE TABLE HISTORICOVALOR (
	IDHISTORICOVALOR 	      NUMBER(38) NOT NULL,
	IDVALOR 		            NUMBER(38) NOT NULL,
	IDITEMCONFIGURACAO 	    NUMBER(38) DEFAULT NULL,
	IDCARACTERISTICA 	      NUMBER(38) DEFAULT NULL,
	VALORSTR 		            VARCHAR2(4000) DEFAULT NULL,
	VALORLONGO 		          CLOB,
	VALORNUMBER 		        NUMBER(18,4) DEFAULT NULL,
	VALORDATE 		          DATE DEFAULT NULL,
	IDBASEITEMCONFIGURACAO 	NUMBER(38) DEFAULT NULL,
	DATAHORAALTERACAO 	    TIMESTAMP DEFAULT SYSDATE,
	IDAUTORALTERACAO 	      NUMBER(38) NOT NULL,
	BASELINE 		            VARCHAR2(30) DEFAULT NULL,
	IDHISTORICOIC 		      NUMBER(38) DEFAULT NULL,
	PRIMARY KEY (IDHISTORICOVALOR)
);

CREATE INDEX FK_VALOR 
	ON HISTORICOVALOR (IDVALOR);

CREATE TABLE ITEMCFGSOLICITACAOSERV (
	IDITEMCONFIGURACAO 	  NUMBER(38),
	IDSOLICITACAOSERVICO 	NUMBER(38),
	DATAINICIO        	  DATE,
	DATAFIM           	  DATE
);

ALTER TABLE ITEMCFGSOLICITACAOSERV
	ADD FOREIGN KEY (IDITEMCONFIGURACAO)
		REFERENCES ITEMCONFIGURACAO (IDITEMCONFIGURACAO);

ALTER TABLE ITEMCFGSOLICITACAOSERV
	MODIFY IDSOLICITACAOSERVICO NUMBER(38);

ALTER TABLE ITEMCFGSOLICITACAOSERV
	ADD FOREIGN KEY (IDSOLICITACAOSERVICO)
		REFERENCES SOLICITACAOSERVICO (IDSOLICITACAOSERVICO);

ALTER TABLE GRUPOITEMCONFIGURACAO 
	ADD IDGRUPOITEMCONFIGURACAOPAI NUMBER(38);


CREATE TABLE VALORSERVICOCONTRATO (
	IDSERVICOCONTRATO    	    NUMBER(38),
	IDSERVICO            	    NUMBER(38),
	VALORSERVICO         	    NUMBER(10,2),
	DATAINICIO          	    DATE,
	DATAFIM              	    DATE,
	IDVALORSERVICOCONTRATO 	  NUMBER(38) NOT NULL
);

ALTER TABLE VALORSERVICOCONTRATO
	ADD PRIMARY KEY (IDVALORSERVICOCONTRATO);

ALTER TABLE VALORSERVICOCONTRATO 
	MODIFY IDSERVICOCONTRATO NUMBER(38);

ALTER TABLE VALORSERVICOCONTRATO 
	ADD FOREIGN KEY (IDSERVICOCONTRATO) 
		REFERENCES SERVICOCONTRATO (IDSERVICOCONTRATO);

CREATE TABLE IMAGEMSERVICORELACIONADO (
	IDIMAGEMSERVICORELACIONADO 	    NUMBER(38) NOT NULL,
	IDSERVICO 			                NUMBER(38) DEFAULT NULL,
	IDSERVICORELACIONADO 		        NUMBER(38) DEFAULT NULL,
	POSX 				                    NUMBER(38) DEFAULT NULL,
	POSY 				                    NUMBER(38) DEFAULT NULL,
	DESCRICAO 			                VARCHAR2(256) DEFAULT NULL,
	CAMINHOIMAGEM 			            VARCHAR2(256) DEFAULT NULL,
	IDIMAGEMSERVICORELACIONADOPAI 	NUMBER(38) DEFAULT NULL,
	PRIMARY KEY (IDIMAGEMSERVICORELACIONADO)
);

CREATE INDEX IDX_IMAGEMITEMSERVICO 
	ON IMAGEMSERVICORELACIONADO (IDSERVICO);

CREATE INDEX IDX_IMAGEMSERVICORELACIONADO 
	ON IMAGEMSERVICORELACIONADO (IDSERVICORELACIONADO);

/* NOME DO INDICE ALTERADO PARA IDX_IMAGEMSERVICORELACIONADOPA
 * PARA SER COMPATIVEL A PADRAO ORACLE DE 30 CARACTERES.
 */
CREATE INDEX IDX_IMAGEMSERVICORELACIONADOPA 
	ON IMAGEMSERVICORELACIONADO (IDIMAGEMSERVICORELACIONADOPAI);

CREATE  TABLE NOTIFICACAOSERVICO (
	IDNOTIFICACAO 	NUMBER(38),
	IDSERVICO 	    NUMBER(38)
);

ALTER TABLE NOTIFICACAO 
	ADD ORIGEMNOTIFICACAO CHAR NOT NULL;
  
ALTER TABLE NOTIFICACAO 
	ADD IDCONTRATO NUMBER(38);

UPDATE BASECONHECIMENTO SET FAQ='N' WHERE IDBASECONHECIMENTO IS NOT NULL;
 
UPDATE BASECONHECIMENTO SET IDUSUARIOAUTOR = 20 WHERE IDBASECONHECIMENTO IS NOT NULL;
 
UPDATE BASECONHECIMENTO SET ARQUIVADO = 'N' WHERE IDBASECONHECIMENTO IS NOT NULL;

CREATE TABLE SOLICITACAOSERVICOPROBLEMA (
	IDPROBLEMA 		        NUMBER(38) DEFAULT NULL,
	IDSOLICITACAOSERVICO 	NUMBER(38) DEFAULT NULL
);

CREATE INDEX FK_SOLICITA_REFERENCE_SOLICITA ON SOLICITACAOSERVICOPROBLEMA (IDSOLICITACAOSERVICO);

-- ALTERACOES ADICIONAIS PARTE 2 - CITSMART 2.0
-- SCRIPT ORIGEM: citsmart2_2.0_oracle_corrigido.sql

CREATE TABLE ALCADA (
	IDALCADA	NUMBER(38) NOT NULL,
	NOMEALCADA	VARCHAR2(70) NOT NULL,
	SITUACAO	CHAR(1) NOT NULL,
	TIPOALCADA	VARCHAR2(40)
);

COMMENT ON COLUMN ALCADA.TIPOALCADA IS 'C- Autorização de compras';

ALTER TABLE ALCADA
	ADD PRIMARY KEY (IDALCADA);

CREATE TABLE ALCADACENTRORESULTADO (
	IDALCADACENTRORESULTADO 	NUMBER(38) NOT NULL,
	IDCENTRORESULTADO 		NUMBER(38) NOT NULL,
	IDEMPREGADO 			NUMBER(38) NOT NULL,
	IDALCADA 			NUMBER(38) NOT NULL,
	DATAINICIO 			DATE NOT NULL,
	DATAFIM 			DATE
);

ALTER TABLE ALCADACENTRORESULTADO
	ADD PRIMARY KEY (IDALCADACENTRORESULTADO);

CREATE TABLE AVALIACAOCOLETAPRECO (
	IDCRITERIO           NUMBER(38) NOT NULL,
	IDCOLETAPRECO        NUMBER(38) NOT NULL,
	AVALIACAO            NUMBER(38) NOT NULL
);

CREATE TABLE CATEGORIAPRODUTO (
	IDCATEGORIA          		NUMBER(38) NOT NULL,
	IDCATEGORIAPAI       		NUMBER(38),
	NOMECATEGORIA        		VARCHAR2(100) NOT NULL,
	SITUACAO             		CHAR(1) NOT NULL,
	PESOCOTACAOPRECO     		NUMBER(38),
	PESOCOTACAOPRAZOENTREGA 	NUMBER(38),
	PESOCOTACAOPRAZOPAGTO 		NUMBER(38),
	PESOCOTACAOTAXAJUROS 		NUMBER(38),
	PESOCOTACAOPRAZOGARANTIA 	NUMBER(38)
);

ALTER TABLE CATEGORIAPRODUTO
	ADD PRIMARY KEY (IDCATEGORIA);

CREATE TABLE CENTRORESULTADO (
	IDCENTRORESULTADO    		NUMBER(38) NOT NULL,
	CODIGOCENTRORESULTADO 		VARCHAR2(25) NOT NULL,
	NOMECENTRORESULTADO  		VARCHAR2(200) NOT NULL,
	IDCENTRORESULTADOPAI 		NUMBER(38),
	PERMITEREQUISICAOPRODUTO	CHAR(1),
	SITUACAO             		CHAR(1) NOT NULL
);

ALTER TABLE CENTRORESULTADO
	ADD PRIMARY KEY (IDCENTRORESULTADO);

CREATE TABLE COLETAPRECO (
	IDCOLETAPRECO        	NUMBER(38) NOT NULL,
	IDFORNECEDOR         	NUMBER(38) NOT NULL,
	IDITEMCOTACAO        	NUMBER(38) NOT NULL,
	IDRESPONSAVEL        	NUMBER(38) NOT NULL,
	IDRESPRESULTADO      	NUMBER(38),
	IDJUSTIFRESULTADO    	NUMBER(38),
	DATACOLETA           	DATE NOT NULL,
	DATAVALIDADE         	DATE,
	ESPECIFICACOES       	CLOB,
	PRECO                	NUMBER(8,2) NOT NULL,
	VALORACRESCIMO       	NUMBER(8,2) NOT NULL,
	VALORDESCONTO        	NUMBER(8,2) NOT NULL,
	VALORFRETE           	NUMBER(8,2) NOT NULL,
	PRAZOENTREGA         	NUMBER(38) NOT NULL,
	PRAZOMEDIOPAGTO      	NUMBER(4,2) NOT NULL,
	TAXAJUROS            	NUMBER(4,2) NOT NULL,
	PRAZOGARANTIA        	NUMBER(38) NOT NULL,
	QUANTIDADECOTADA     	NUMBER(8,2) NOT NULL,
	PONTUACAO            	NUMBER(8,4),
	RESULTADOCALCULO     	CHAR(1),
	QUANTIDADECALCULO    	NUMBER(8,2),
	RESULTADOFINAL       	CHAR(1),
	QUANTIDADECOMPRA     	NUMBER(8,2),
	COMPLEMJUSTIFRESULTADO 	CLOB,
	QUANTIDADEAPROVADA   	NUMBER(8,2),
	QUANTIDADEPEDIDO     	NUMBER(8,2)
);

COMMENT ON COLUMN COLETAPRECO.RESULTADOCALCULO IS 'M - MELHOR COTAÇÃO, E - EMPATE, N - NÃO VENCEDORA';

COMMENT ON COLUMN COLETAPRECO.RESULTADOFINAL IS 'M - MELHOR COTAÇÃO, N - NÃO VENCEDORA';

ALTER TABLE COLETAPRECO
	ADD PRIMARY KEY (IDCOLETAPRECO);

CREATE TABLE COTACAO (
	IDCOTACAO            NUMBER(38) NOT NULL,
	IDENTIFICACAO        VARCHAR2(100),
	IDEMPRESA            NUMBER(38) NOT NULL,
	IDRESPONSAVEL        NUMBER(38) NOT NULL,
	SITUACAO             VARCHAR2(25) NOT NULL,
	DATAHORACADASTRO     TIMESTAMP NOT NULL,
	OBSERVACOES          CLOB,
	DATAFINALPREVISTA    DATE
);

ALTER TABLE COTACAO
	ADD PRIMARY KEY (IDCOTACAO);

CREATE TABLE COTACAOITEMREQUISICAO (
	IDCOLETAPRECO        		NUMBER(38) NOT NULL,
	IDITEMREQUISICAOPRODUTO 	NUMBER(38) NOT NULL,
	IDPARECER            		NUMBER(38),
	IDITEMTRABALHOAPROVACAO 	NUMBER(38),
	IDSOLICITACAOSERVICO 		NUMBER(38),
	IDITEMTRABALHOINSPECAO 		NUMBER(38),
	IDCOTACAO            		NUMBER(38),
	QUANTIDADE           		NUMBER(8,2) NOT NULL,
	SITUACAO             		CHAR(25),
	QUANTIDADEENTREGUE   		NUMBER(8,2)
);

COMMENT ON COLUMN COTACAOITEMREQUISICAO.SITUACAO IS 'AGUARDANDO - AGUARDANDO APROVAÇÃO, PREAPROVADO - PRÉ APROVADO, APROVADO - APROVADO, NAOAPROVADO - NÃO APROVADO';

ALTER TABLE COTACAOITEMREQUISICAO
	ADD PRIMARY KEY (IDCOLETAPRECO, IDITEMREQUISICAOPRODUTO);

CREATE TABLE CRITERIOAVALIACAO (
	IDCRITERIO           		NUMBER(38) NOT NULL,
	DESCRICAO            		VARCHAR2(100) NOT NULL,
	APLICAVELCOTACAO     		CHAR(1) NOT NULL,
	APLICAVELAVALIACAOSOLICITANTE 	CHAR(1) NOT NULL,
	APLICAVELAVALIACAOCOMPRADOR 	CHAR(1) NOT NULL,
	APLICAVELQUALIFICACAOFORNECEDO CHAR(1) NOT NULL,
	TIPOAVALIACAO        		CHAR(1) NOT NULL
);

COMMENT ON COLUMN CRITERIOAVALIACAO.TIPOAVALIACAO IS 'S - SIM/NAO, A - ACEITO/NAO ACEITO, C - CONFORME/NAO CONFORME, N - NUMERO - 0 A 10';

ALTER TABLE CRITERIOAVALIACAO
	ADD PRIMARY KEY (IDCRITERIO);

CREATE TABLE CRITERIOITEMCOTACAO (
	IDITEMCOTACAO        NUMBER(38) NOT NULL,
	IDCRITERIO           NUMBER(38) NOT NULL,
	PESO                 NUMBER(38) NOT NULL
);

ALTER TABLE CRITERIOITEMCOTACAO
	ADD PRIMARY KEY (IDCRITERIO, IDITEMCOTACAO);

CREATE TABLE ENDERECO (
	IDENDERECO           NUMBER(38) NOT NULL,
	LOGRADOURO           VARCHAR2(200) NOT NULL,
	NUMERO               VARCHAR2(20),
	COMPLEMENTO          VARCHAR2(200),
	BAIRRO               VARCHAR2(200),
	IDCIDADE             NUMBER(38),
	IDPAIS               NUMBER(38),
	CEP                  VARCHAR2(8),
	IDUF                 NUMBER(38)
);

ALTER TABLE ENDERECO
	ADD PRIMARY KEY (IDENDERECO);

CREATE TABLE ENTREGAITEMREQUISICAO (
	IDENTREGA            		NUMBER(38) NOT NULL,
	IDPEDIDO             		NUMBER(38) NOT NULL,
	IDCOLETAPRECO        		NUMBER(38) NOT NULL,
	IDITEMREQUISICAOPRODUTO 	NUMBER(38) NOT NULL,
	IDSOLICITACAOSERVICO 		NUMBER(38) NOT NULL,
	QUANTIDADEENTREGUE   		NUMBER(8,2) NOT NULL,
	IDITEMTRABALHO       		NUMBER(38),
	IDPARECER            		NUMBER(38),
	SITUACAO             		VARCHAR2(25) NOT NULL,
	OBSERVACOES          		CLOB
);

ALTER TABLE ENTREGAITEMREQUISICAO
	ADD PRIMARY KEY (IDENTREGA);


CREATE TABLE FORNECEDORCOTACAO (
	IDCOTACAO            NUMBER(38) NOT NULL,
	IDFORNECEDOR         NUMBER(38) NOT NULL
);

ALTER TABLE FORNECEDORCOTACAO
	ADD PRIMARY KEY (IDCOTACAO, IDFORNECEDOR);

CREATE TABLE FORNECEDORPRODUTO (
	IDFORNECEDORPRODUTO  NUMBER(38) NOT NULL,
	IDFORNECEDOR         NUMBER(38) NOT NULL,
	IDTIPOPRODUTO        NUMBER(38) NOT NULL,
	IDMARCA              NUMBER(38),
	DATAINICIO           DATE NOT NULL,
	DATAFIM              DATE
);

ALTER TABLE FORNECEDORPRODUTO
	ADD PRIMARY KEY (IDFORNECEDORPRODUTO);

CREATE TABLE INSPECAOENTREGAITEM (
	IDENTREGA            NUMBER(38) NOT NULL,
	IDCRITERIO           NUMBER(38) NOT NULL,
	IDRESPONSAVEL        NUMBER(38),
	DATAHORAINSPECAO     TIMESTAMP,
	AVALIACAO            NUMBER(38),
	OBSERVACOES          CLOB
);

ALTER TABLE INSPECAOENTREGAITEM
	ADD PRIMARY KEY (IDENTREGA, IDCRITERIO);

CREATE TABLE INSPECAOPEDIDOCOMPRA (
	IDPEDIDO             NUMBER(38) NOT NULL,
	IDCRITERIO           NUMBER(38) NOT NULL,
	IDRESPONSAVEL        NUMBER(38) NOT NULL,
	DATAHORAINSPECAO     TIMESTAMP NOT NULL,
	AVALIACAO            NUMBER(38) NOT NULL,
	OBSERVACOES          CLOB
);

ALTER TABLE INSPECAOPEDIDOCOMPRA
	ADD PRIMARY KEY (IDPEDIDO, IDCRITERIO);

CREATE TABLE ITEMCOTACAO (
	IDITEMCOTACAO        		NUMBER(38) NOT NULL,
	IDCOTACAO            		NUMBER(38),
	IDPRODUTO            		NUMBER(38),
	TIPOIDENTIFICACAO    		CHAR(1) NOT NULL,
	QUANTIDADE          		NUMBER(8,2),
	SITUACAO             		VARCHAR2(20),
	DATAHORALIMITE       		TIMESTAMP,
	IDCATEGORIAPRODUTO   		NUMBER(38),
	IDUNIDADEMEDIDA      		NUMBER(38),
	DESCRICAOITEM        		VARCHAR2(200) NOT NULL,
	ESPECIFICACOES       		CLOB,
	MARCAPREFERENCIAL    		VARCHAR2(100),
	PRECOAPROXIMADO      		NUMBER(8,2),
	SOLICITACOESATENDIDAS 		CLOB,
	RESULTADOVALIDACAO   		CHAR(1),
	MENSAGENSVALIDACAO   		CLOB,
	PESOPRECO            		NUMBER(38),
	PESOPRAZOENTREGA     		NUMBER(38),
	PESOPRAZOPAGTO       		NUMBER(38),
	PESOTAXAJUROS        		NUMBER(38),
	PESOPRAZOGARANTIA    		NUMBER(38),
	EXIGEFORNECEDORQUALIFICADO 	CHAR(1)
);

ALTER TABLE ITEMCOTACAO
	ADD PRIMARY KEY (IDITEMCOTACAO);

CREATE TABLE ITEMPEDIDOCOMPRA (
	IDITEMPEDIDO         NUMBER(38) NOT NULL,
	IDPEDIDO             NUMBER(38) NOT NULL,
	IDPRODUTO            NUMBER(38) NOT NULL,
	IDCOLETAPRECO        NUMBER(38),
	QUANTIDADE           NUMBER(8,2) NOT NULL,
	VALORTOTAL           NUMBER(8,2) NOT NULL,
	VALORDESCONTO        NUMBER(8,2),
	VALORACRESCIMO       NUMBER(8,2),
	BASECALCULOICMS      NUMBER(8,2),
	ALIQUOTAICMS         NUMBER(8,2),
	ALIQUOTAIPI          NUMBER(8,2)
);

ALTER TABLE ITEMPEDIDOCOMPRA
	ADD PRIMARY KEY (IDITEMPEDIDO);

CREATE TABLE ITEMREQUISICAOPRODUTO (
	IDITEMREQUISICAOPRODUTO 	NUMBER(38) NOT NULL,
	IDSOLICITACAOSERVICO 		NUMBER(38) NOT NULL,
	IDPARECERVALIDACAO   		NUMBER(38),
	IDPARECERAUTORIZACAO 		NUMBER(38),
	IDCATEGORIAPRODUTO   		NUMBER(38),
	IDUNIDADEMEDIDA      		NUMBER(38),
	IDPRODUTO            		NUMBER(38),
	IDITEMCOTACAO        		NUMBER(38),
	DESCRICAOITEM        		VARCHAR2(200) NOT NULL,
	ESPECIFICACOES       		CLOB,
	QUANTIDADE           		NUMBER(8,2) NOT NULL,
	MARCAPREFERENCIAL    		VARCHAR2(100),
	PRECOAPROXIMADO      		NUMBER(8,2),
	SITUACAO             		VARCHAR2(20),
	PERCVARIACAOPRECO    		NUMBER(8,2),
	QTDEAPROVADA         		NUMBER(8,2),
	TIPOATENDIMENTO      		CHAR(1) NOT NULL,
	TIPOIDENTIFICACAO    		CHAR(1) NOT NULL,
	APROVACOTACAO        		CHAR(1),
	QTDECOTADA           		NUMBER(8,2)
);

COMMENT ON COLUMN ITEMREQUISICAOPRODUTO.TIPOATENDIMENTO IS 'C - COTAÇÃO, E - ESTOQUE';

ALTER TABLE ITEMREQUISICAOPRODUTO
	ADD PRIMARY KEY (IDITEMREQUISICAOPRODUTO);

CREATE TABLE JUSTIFICATIVAPARECER (
	IDJUSTIFICATIVA      		NUMBER(38) NOT NULL,
	DESCRICAOJUSTIFICATIVA 	VARCHAR2(100) NOT NULL,
	SITUACAO             		CHAR(1),
	APLICAVELREQUISICAO  		CHAR(1),
	APLICAVELCOTACAO     		CHAR(1),
	APLICAVELINSPECAO    		CHAR(1)
);

ALTER TABLE JUSTIFICATIVAPARECER
	ADD PRIMARY KEY (IDJUSTIFICATIVA);

CREATE TABLE LIMITEALCADA (
	IDLIMITEALCADA       		NUMBER(38) NOT NULL,
	IDALCADA             		NUMBER(38) NOT NULL,
	IDGRUPO              		NUMBER(38) NOT NULL,
	TIPOLIMITE           		CHAR(1),
	ABRANGENCIACENTROCUSTO 		VARCHAR2(20) NOT NULL,
	LIMITEVALORITEM      		NUMBER(8,2),
	LIMITEVALORMENSAL    		NUMBER(8,2),
	SITUACAO             		CHAR NOT NULL
);

COMMENT ON COLUMN LIMITEALCADA.TIPOLIMITE IS 'F - POR FAIXA DE VALORES, Q - QUALQUER VALOR';

COMMENT ON COLUMN LIMITEALCADA.ABRANGENCIACENTROCUSTO IS 'T - TODOS, R - SOMENTE O RESPONSÁVEL';

ALTER TABLE LIMITEALCADA
	ADD PRIMARY KEY (IDLIMITEALCADA);

CREATE TABLE MARCA (
	IDMARCA              NUMBER(38) NOT NULL,
	IDFABRICANTE         NUMBER(38),
	NOMEMARCA            VARCHAR2(100) NOT NULL,
	SITUACAO             CHAR(1) NOT NULL
);

ALTER TABLE MARCA
	ADD PRIMARY KEY (IDMARCA);

CREATE TABLE PAIS (
	IDPAIS               NUMBER(38) NOT NULL,
	NOME             VARCHAR2(200) NOT NULL
);

ALTER TABLE PAIS 
	ADD PRIMARY KEY (IDPAIS);

CREATE TABLE PARECER (
	IDPARECER            		NUMBER(38) NOT NULL,
	IDJUSTIFICATIVA      		NUMBER(38),
	IDALCADA             		NUMBER(38),
	IDRESPONSAVEL        		NUMBER(38) NOT NULL,
	DATAHORAPARECER      		TIMESTAMP NOT NULL,
	COMPLEMENTOJUSTIFICATIVA 	CLOB,
	APROVADO            		CHAR(1) NOT NULL,
	OBSERVACOES          		CLOB
);

ALTER TABLE PARECER
	ADD PRIMARY KEY (IDPARECER);

CREATE TABLE PEDIDOCOMPRA (
	IDPEDIDO             NUMBER(38) NOT NULL,
	IDEMPRESA            NUMBER(38) NOT NULL,
	IDFORNECEDOR         NUMBER(38) NOT NULL,
	DATAPEDIDO           DATE NOT NULL,
	DATAPREVISTAENTREGA  DATE,
	NUMEROPEDIDO         VARCHAR2(25) NOT NULL,
	IDENTIFICACAOENTREGA VARCHAR2(25),
	VALORFRETE           NUMBER(8,2),
	VALORSEGURO          NUMBER(8,2),
	NUMERONF             VARCHAR2(25),
	OUTRASDESPESAS       NUMBER(8,2),
	SITUACAO             VARCHAR2(20) NOT NULL,
	IDCOTACAO            NUMBER(38),
	IDENDERECOENTREGA    NUMBER(38),
	DATAENTREGA          DATE,
	OBSERVACOES          CLOB
);

ALTER TABLE PEDIDOCOMPRA
	ADD PRIMARY KEY (IDPEDIDO);

CREATE TABLE PRODUTO (
	IDPRODUTO            NUMBER(38) NOT NULL,
	IDTIPOPRODUTO        NUMBER(38) NOT NULL,
	IDMARCA              NUMBER(38),
	MODELO               VARCHAR2(25),
	PRECOMERCADO         NUMBER(8,2),
	DETALHES             CLOB,
	CODIGOPRODUTO        VARCHAR2(25),
	SITUACAO             CHAR(1) NOT NULL,
	COMPLEMENTO          VARCHAR2(100)
);

ALTER TABLE PRODUTO
	ADD PRIMARY KEY (IDPRODUTO);

CREATE TABLE RELACIONAMENTOPRODUTO (
	IDTIPOPRODUTO        		NUMBER(38) NOT NULL,
	IDTIPOPRODUTORELACIONADO 	NUMBER(38) NOT NULL,
	TIPORELACIONAMENTO  		CHAR(1)
);

COMMENT ON COLUMN RELACIONAMENTOPRODUTO.TIPORELACIONAMENTO IS 'A - ACESSÓRIO, S - PRODUTO SEMELHANTE';

ALTER TABLE RELACIONAMENTOPRODUTO
	ADD PRIMARY KEY (IDTIPOPRODUTO, IDTIPOPRODUTORELACIONADO);

CREATE TABLE REQUISICAOPRODUTO (
	IDSOLICITACAOSERVICO NUMBER(38) NOT NULL,
	IDPROJETO            NUMBER(38),
	IDCENTROCUSTO        NUMBER(38),
	IDENDERECOENTREGA    NUMBER(38),
	FINALIDADE           CHAR(1) NOT NULL,
	REJEITADA            CHAR(1) NOT NULL
);

COMMENT ON COLUMN REQUISICAOPRODUTO.FINALIDADE IS 'C - ATENDIMENTO AO CLIENTE, I - USO INTERNO';

ALTER TABLE REQUISICAOPRODUTO
	ADD PRIMARY KEY (IDSOLICITACAOSERVICO);

CREATE TABLE TIPOPRODUTO (
	IDTIPOPRODUTO        NUMBER(38) NOT NULL,
	IDCATEGORIA          NUMBER(38),
	IDUNIDADEMEDIDA      NUMBER(38),
	NOMEPRODUTO          VARCHAR2(100) NOT NULL,
	SITUACAO             CHAR(1) NOT NULL,
	ACEITAREQUISICAO     CHAR(1) NOT NULL
);

ALTER TABLE TIPOPRODUTO
	ADD PRIMARY KEY (IDTIPOPRODUTO);

CREATE TABLE UNIDADEMEDIDA (
	IDUNIDADEMEDIDA      NUMBER(38) NOT NULL,
	NOMEUNIDADEMEDIDA    VARCHAR2(100) NOT NULL,
	SIGLAUNIDADEMEDIDA   VARCHAR2(10) NOT NULL,
	SITUACAO             CHAR(1) NOT NULL
);

DELETE FROM FORNECEDOR WHERE IDFORNECEDOR = 1;

ALTER TABLE FORNECEDOR 
	ADD PRIMARY KEY (IDFORNECEDOR);
  
INSERT INTO FORNECEDOR (IDFORNECEDOR,RAZAOSOCIAL,NOMEFANTASIA,CNPJ,EMAIL,DELETED) values ('1','CENTRAL IT TECNOLOGIA DA INFORMAÇÃO LTDA','CENTRAL IT','07171299000196','contato@centralit.com.br',null);


/* ESSA TABELA JA EXISTIA MAS NAO POSSUIA O
 * CAMPO CONTATO VARCHAR2(245).
 */
CREATE TABLE AVALIACAOFORNECEDOR (
	IDAVALIACAOFORNECEDOR 		NUMBER(38),
	IDFORNECEDOR 			NUMBER(38),
	IDRESPONSAVEL 			NUMBER(38),
	DATAAVALIACAO 			DATE,
	DECISAOQUALIFICACAO 		CHAR(1),
	OBSERVACOES 			CLOB,
	PRIMARY KEY (IDAVALIACAOFORNECEDOR)
);

ALTER TABLE AVALIACAOFORNECEDOR
	ADD FOREIGN KEY (IDFORNECEDOR) 
		REFERENCES FORNECEDOR (IDFORNECEDOR);

ALTER TABLE AVALIACAOFORNECEDOR
	ADD FOREIGN KEY (IDRESPONSAVEL) 
		REFERENCES EMPREGADOS (IDEMPREGADO);

CREATE TABLE AVALIACAOREFERENCIAFORNECEDOR (
	IDAVALIACAOFORNECEDOR 	NUMBER(38),
	IDEMPREGADO 		NUMBER(38),
	DECISAO 		CHAR(1),
	OBSERVACOES 		CLOB,
	PRIMARY KEY (IDAVALIACAOFORNECEDOR, IDEMPREGADO)
);

ALTER TABLE AVALIACAOREFERENCIAFORNECEDOR
	ADD FOREIGN KEY (IDAVALIACAOFORNECEDOR) 
		REFERENCES AVALIACAOFORNECEDOR (IDAVALIACAOFORNECEDOR);

ALTER TABLE AVALIACAOREFERENCIAFORNECEDOR
	ADD FOREIGN KEY (IDAVALIACAOFORNECEDOR) 
		REFERENCES EMPREGADOS (IDEMPREGADO);

CREATE TABLE CRITERIOAVALIACAOFORNECEDOR (
	IDAVALIACAOFORNECEDOR 	NUMBER(38),
	IDCRITERIO 		NUMBER(38),
	VALOR 			NUMBER(38),
	OBSERVACOES 		CLOB,
	PRIMARY KEY (IDAVALIACAOFORNECEDOR, IDCRITERIO)
);

ALTER TABLE CRITERIOAVALIACAOFORNECEDOR
	ADD FOREIGN KEY (IDAVALIACAOFORNECEDOR) 
		REFERENCES AVALIACAOFORNECEDOR (IDAVALIACAOFORNECEDOR);

ALTER TABLE CRITERIOAVALIACAOFORNECEDOR
	ADD FOREIGN KEY (IDCRITERIO) 
		REFERENCES CRITERIOAVALIACAO (IDCRITERIO);

ALTER TABLE AVALIACAOFORNECEDOR 
	ADD CONTATO VARCHAR2(245);

ALTER TABLE UNIDADEMEDIDA
	ADD PRIMARY KEY (IDUNIDADEMEDIDA);

ALTER TABLE ALCADACENTRORESULTADO 
	ADD FOREIGN KEY (IDCENTRORESULTADO)
      		REFERENCES CENTRORESULTADO (IDCENTRORESULTADO);

ALTER TABLE ALCADACENTRORESULTADO 
	ADD FOREIGN KEY (IDEMPREGADO)
      		REFERENCES EMPREGADOS (IDEMPREGADO);

ALTER TABLE ALCADACENTRORESULTADO 
	ADD FOREIGN KEY (IDALCADA)
      		REFERENCES ALCADA (IDALCADA);

ALTER TABLE AVALIACAOCOLETAPRECO 
	ADD FOREIGN KEY (IDCRITERIO)
      		REFERENCES CRITERIOAVALIACAO (IDCRITERIO);

ALTER TABLE AVALIACAOCOLETAPRECO 
	ADD FOREIGN KEY (IDCOLETAPRECO)
      		REFERENCES COLETAPRECO (IDCOLETAPRECO);

ALTER TABLE CATEGORIAPRODUTO 
	ADD FOREIGN KEY (IDCATEGORIAPAI)
		REFERENCES CATEGORIAPRODUTO (IDCATEGORIA);

ALTER TABLE COLETAPRECO 
	ADD FOREIGN KEY (IDITEMCOTACAO)
		REFERENCES ITEMCOTACAO (IDITEMCOTACAO);

ALTER TABLE COLETAPRECO 
	ADD FOREIGN KEY (IDRESPONSAVEL)
		REFERENCES EMPREGADOS (IDEMPREGADO);

ALTER TABLE COLETAPRECO 
	ADD FOREIGN KEY (IDFORNECEDOR)
      		REFERENCES FORNECEDOR (IDFORNECEDOR);

ALTER TABLE COLETAPRECO 
	ADD FOREIGN KEY (IDRESPRESULTADO)
      		REFERENCES EMPREGADOS (IDEMPREGADO);

ALTER TABLE COLETAPRECO 
	ADD FOREIGN KEY (IDJUSTIFRESULTADO)
		REFERENCES JUSTIFICATIVAPARECER (IDJUSTIFICATIVA);

ALTER TABLE COTACAO 
	ADD FOREIGN KEY (IDEMPRESA)
		REFERENCES EMPRESA (IDEMPRESA);

ALTER TABLE COTACAOITEMREQUISICAO 
	ADD FOREIGN KEY (IDCOLETAPRECO)
		REFERENCES COLETAPRECO (IDCOLETAPRECO);

ALTER TABLE COTACAOITEMREQUISICAO 
	ADD FOREIGN KEY (IDCOTACAO)
		REFERENCES COTACAO (IDCOTACAO);

ALTER TABLE COTACAOITEMREQUISICAO 
	ADD FOREIGN KEY (IDITEMREQUISICAOPRODUTO)
      		REFERENCES ITEMREQUISICAOPRODUTO (IDITEMREQUISICAOPRODUTO);

ALTER TABLE COTACAOITEMREQUISICAO 
	ADD FOREIGN KEY (IDPARECER)
		REFERENCES PARECER (IDPARECER);

ALTER TABLE COTACAOITEMREQUISICAO
	MODIFY IDITEMTRABALHOAPROVACAO NUMBER(38);

ALTER TABLE COTACAOITEMREQUISICAO 
	ADD FOREIGN KEY (IDITEMTRABALHOAPROVACAO)
		REFERENCES BPM_ITEMTRABALHOFLUXO (IDITEMTRABALHO);

ALTER TABLE 
	COTACAOITEMREQUISICAO MODIFY IDSOLICITACAOSERVICO NUMBER(38);

ALTER TABLE COTACAOITEMREQUISICAO 
	ADD FOREIGN KEY (IDSOLICITACAOSERVICO)
		REFERENCES SOLICITACAOSERVICO (IDSOLICITACAOSERVICO);

ALTER TABLE COTACAOITEMREQUISICAO 
	MODIFY IDITEMTRABALHOINSPECAO NUMBER(38);

ALTER TABLE COTACAOITEMREQUISICAO 
	ADD FOREIGN KEY (IDITEMTRABALHOINSPECAO)
		REFERENCES BPM_ITEMTRABALHOFLUXO (IDITEMTRABALHO);

ALTER TABLE CRITERIOITEMCOTACAO
	ADD FOREIGN KEY (IDCRITERIO)
		REFERENCES CRITERIOAVALIACAO (IDCRITERIO);

ALTER TABLE CRITERIOITEMCOTACAO 
	ADD FOREIGN KEY (IDITEMCOTACAO)
		REFERENCES ITEMCOTACAO (IDITEMCOTACAO);

ALTER TABLE ENTREGAITEMREQUISICAO 
	ADD FOREIGN KEY (IDPEDIDO)
		REFERENCES PEDIDOCOMPRA (IDPEDIDO);

ALTER TABLE ENTREGAITEMREQUISICAO 
	ADD FOREIGN KEY (IDCOLETAPRECO, IDITEMREQUISICAOPRODUTO)
		REFERENCES COTACAOITEMREQUISICAO (IDCOLETAPRECO, IDITEMREQUISICAOPRODUTO);

ALTER TABLE ENTREGAITEMREQUISICAO 
	MODIFY IDSOLICITACAOSERVICO NUMBER(38);

ALTER TABLE ENTREGAITEMREQUISICAO 
	ADD FOREIGN KEY (IDSOLICITACAOSERVICO)
		REFERENCES SOLICITACAOSERVICO (IDSOLICITACAOSERVICO);

ALTER TABLE ENTREGAITEMREQUISICAO 
	MODIFY IDITEMTRABALHO NUMBER(38);

ALTER TABLE ENTREGAITEMREQUISICAO 
	ADD FOREIGN KEY (IDITEMTRABALHO)
		REFERENCES BPM_ITEMTRABALHOFLUXO (IDITEMTRABALHO);

ALTER TABLE ENTREGAITEMREQUISICAO 
	ADD FOREIGN KEY (IDPARECER)
		REFERENCES PARECER (IDPARECER);

ALTER TABLE FORNECEDORCOTACAO 
	ADD FOREIGN KEY (IDCOTACAO)
		REFERENCES COTACAO (IDCOTACAO);

ALTER TABLE FORNECEDORCOTACAO 
	MODIFY IDFORNECEDOR NUMBER(38);

ALTER TABLE FORNECEDORCOTACAO 
	ADD FOREIGN KEY (IDFORNECEDOR)
		REFERENCES FORNECEDOR (IDFORNECEDOR);

ALTER TABLE FORNECEDORPRODUTO 
	MODIFY IDFORNECEDOR NUMBER(38);

ALTER TABLE FORNECEDORPRODUTO 
	ADD FOREIGN KEY (IDFORNECEDOR)
		REFERENCES FORNECEDOR (IDFORNECEDOR);

ALTER TABLE FORNECEDORPRODUTO 
	ADD FOREIGN KEY (IDTIPOPRODUTO)
		REFERENCES TIPOPRODUTO (IDTIPOPRODUTO);

ALTER TABLE FORNECEDORPRODUTO 
	ADD FOREIGN KEY (IDMARCA)
		REFERENCES MARCA (IDMARCA);

ALTER TABLE INSPECAOENTREGAITEM 
	ADD FOREIGN KEY (IDRESPONSAVEL)
		REFERENCES EMPREGADOS (IDEMPREGADO);

ALTER TABLE INSPECAOENTREGAITEM 
	ADD FOREIGN KEY (IDCRITERIO)
		REFERENCES CRITERIOAVALIACAO (IDCRITERIO);

ALTER TABLE INSPECAOENTREGAITEM 
	ADD FOREIGN KEY (IDENTREGA)
		REFERENCES ENTREGAITEMREQUISICAO (IDENTREGA);

ALTER TABLE INSPECAOPEDIDOCOMPRA 
	ADD FOREIGN KEY (IDPEDIDO)
		REFERENCES PEDIDOCOMPRA (IDPEDIDO);

ALTER TABLE INSPECAOPEDIDOCOMPRA 
	ADD FOREIGN KEY (IDCRITERIO)
		REFERENCES CRITERIOAVALIACAO (IDCRITERIO);

ALTER TABLE INSPECAOPEDIDOCOMPRA 
	ADD FOREIGN KEY (IDRESPONSAVEL)
		REFERENCES EMPREGADOS (IDEMPREGADO);

ALTER TABLE ITEMCOTACAO 
	ADD FOREIGN KEY (IDCOTACAO)
		REFERENCES COTACAO (IDCOTACAO);

ALTER TABLE ITEMCOTACAO 
	ADD FOREIGN KEY (IDPRODUTO)
		REFERENCES PRODUTO (IDPRODUTO);

ALTER TABLE ITEMCOTACAO 
	ADD FOREIGN KEY (IDUNIDADEMEDIDA)
		REFERENCES UNIDADEMEDIDA (IDUNIDADEMEDIDA);

ALTER TABLE ITEMCOTACAO 
	ADD FOREIGN KEY (IDCATEGORIAPRODUTO)
		REFERENCES CATEGORIAPRODUTO (IDCATEGORIA);

ALTER TABLE ITEMPEDIDOCOMPRA 
	ADD FOREIGN KEY (IDCOLETAPRECO)
		REFERENCES COLETAPRECO (IDCOLETAPRECO);

ALTER TABLE ITEMPEDIDOCOMPRA 
	ADD FOREIGN KEY (IDPEDIDO)
		REFERENCES PEDIDOCOMPRA (IDPEDIDO);

ALTER TABLE ITEMPEDIDOCOMPRA 
	ADD FOREIGN KEY (IDPRODUTO)
		REFERENCES PRODUTO (IDPRODUTO);

ALTER TABLE ITEMREQUISICAOPRODUTO 
	ADD FOREIGN KEY (IDSOLICITACAOSERVICO)
		REFERENCES REQUISICAOPRODUTO (IDSOLICITACAOSERVICO);

ALTER TABLE ITEMREQUISICAOPRODUTO 
	ADD FOREIGN KEY (IDPARECERVALIDACAO)
		REFERENCES PARECER (IDPARECER);

ALTER TABLE ITEMREQUISICAOPRODUTO 
	ADD FOREIGN KEY (IDPARECERAUTORIZACAO)
		REFERENCES PARECER (IDPARECER);

ALTER TABLE ITEMREQUISICAOPRODUTO 
	ADD FOREIGN KEY (IDPRODUTO)
		REFERENCES PRODUTO (IDPRODUTO);

ALTER TABLE ITEMREQUISICAOPRODUTO
	ADD FOREIGN KEY (IDUNIDADEMEDIDA)
		REFERENCES UNIDADEMEDIDA (IDUNIDADEMEDIDA);

ALTER TABLE ITEMREQUISICAOPRODUTO 
	ADD FOREIGN KEY (IDCATEGORIAPRODUTO)
		REFERENCES CATEGORIAPRODUTO (IDCATEGORIA);

ALTER TABLE ITEMREQUISICAOPRODUTO
	ADD FOREIGN KEY (IDITEMCOTACAO)
		REFERENCES ITEMCOTACAO (IDITEMCOTACAO);

ALTER TABLE LIMITEALCADA 
	ADD FOREIGN KEY (IDALCADA)
		REFERENCES ALCADA (IDALCADA);

ALTER TABLE LIMITEALCADA 
	ADD FOREIGN KEY (IDGRUPO)
		REFERENCES GRUPO (IDGRUPO);

ALTER TABLE MARCA 
	MODIFY IDFABRICANTE NUMBER(38);

ALTER TABLE MARCA 
	ADD FOREIGN KEY (IDFABRICANTE)
		REFERENCES FORNECEDOR (IDFORNECEDOR);

ALTER TABLE PARECER 
	ADD FOREIGN KEY (IDJUSTIFICATIVA)
		REFERENCES JUSTIFICATIVAPARECER (IDJUSTIFICATIVA);

ALTER TABLE PARECER 
	ADD FOREIGN KEY (IDALCADA)
		REFERENCES ALCADA (IDALCADA);

ALTER TABLE PEDIDOCOMPRA 
	ADD FOREIGN KEY (IDFORNECEDOR)
		REFERENCES FORNECEDOR (IDFORNECEDOR);

ALTER TABLE PEDIDOCOMPRA 
	ADD FOREIGN KEY (IDCOTACAO)
		REFERENCES COTACAO (IDCOTACAO);

ALTER TABLE PEDIDOCOMPRA
	 ADD FOREIGN KEY (IDENDERECOENTREGA)
		REFERENCES ENDERECO (IDENDERECO);

ALTER TABLE PRODUTO
	 ADD FOREIGN KEY (IDTIPOPRODUTO)
		REFERENCES TIPOPRODUTO (IDTIPOPRODUTO);

ALTER TABLE PRODUTO 
	ADD FOREIGN KEY (IDMARCA)
		REFERENCES MARCA (IDMARCA);

ALTER TABLE RELACIONAMENTOPRODUTO
	 ADD FOREIGN KEY (IDTIPOPRODUTO)
		REFERENCES TIPOPRODUTO (IDTIPOPRODUTO);

ALTER TABLE RELACIONAMENTOPRODUTO 
	ADD FOREIGN KEY (IDTIPOPRODUTORELACIONADO)
		REFERENCES TIPOPRODUTO (IDTIPOPRODUTO);

ALTER TABLE REQUISICAOPRODUTO 
	ADD FOREIGN KEY (IDPROJETO)
		REFERENCES PROJETOS (IDPROJETO);

ALTER TABLE REQUISICAOPRODUTO 
	ADD FOREIGN KEY (IDCENTROCUSTO)
		REFERENCES CENTRORESULTADO (IDCENTRORESULTADO);

ALTER TABLE REQUISICAOPRODUTO
	ADD FOREIGN KEY (IDENDERECOENTREGA)
		REFERENCES ENDERECO (IDENDERECO);

ALTER TABLE TIPOPRODUTO 
	ADD FOREIGN KEY (IDCATEGORIA)
		REFERENCES CATEGORIAPRODUTO (IDCATEGORIA);

ALTER TABLE TIPOPRODUTO
	ADD FOREIGN KEY (IDUNIDADEMEDIDA)
		REFERENCES UNIDADEMEDIDA (IDUNIDADEMEDIDA);

ALTER TABLE BPM_TIPOFLUXO 
	ADD NOMECLASSEFLUXO VARCHAR2(255);

ALTER TABLE BPM_ELEMENTOFLUXO 
	ADD TEMPLATE VARCHAR2(40);

ALTER TABLE BPM_ELEMENTOFLUXO 
	ADD INTERVALO NUMBER(38);

ALTER TABLE BPM_ELEMENTOFLUXO 
	ADD CONDICAODISPARO CLOB;

ALTER TABLE BPM_ELEMENTOFLUXO 
	ADD MULTIPLASINSTANCIAS CHAR(1);

ALTER TABLE BPM_ITEMTRABALHOFLUXO 
	ADD DATAHORAEXECUCAO TIMESTAMP;

CREATE TABLE TEMPLATESOLICITACAOSERVICO (
	IDTEMPLATE           NUMBER(38) NOT NULL,
	IDENTIFICACAO        VARCHAR2(40) NOT NULL,
	NOMETEMPLATE         VARCHAR2(200) NOT NULL,
	NOMECLASSEDTO        VARCHAR2(255) NOT NULL,
	NOMECLASSEACTION     VARCHAR2(255) NOT NULL,
	NOMECLASSESERVICO    VARCHAR2(255) NOT NULL,
	URLRECUPERACAO       VARCHAR2(255) NOT NULL,
	SCRIPTAPOSRECUPERACAO CLOB,
	HABILITADIRECIONAMENTO CHAR(1),
	HABILITASITUACAO     CHAR(1),
	HABILITASOLUCAO      CHAR(1),
	ALTURADIV            NUMBER(38),
	HABILITAURGENCIAIMPACTO CHAR(1),
	HABILITANOTIFICACAOEMAIL CHAR(1),
	HABILITAPROBLEMA     CHAR(1),
	HABILITAMUDANCA      CHAR(1)
);

ALTER TABLE TEMPLATESOLICITACAOSERVICO
	ADD PRIMARY KEY (IDTEMPLATE);

ALTER TABLE SERVICO 
	ADD IDTEMPLATESOLICITACAO NUMBER(38);

ALTER TABLE SERVICO 
	ADD IDTEMPLATEACOMPANHAMENTO NUMBER(38);

ALTER TABLE SERVICO 
	ADD FOREIGN KEY (IDTEMPLATESOLICITACAO)
		REFERENCES TEMPLATESOLICITACAOSERVICO (IDTEMPLATE);

ALTER TABLE SERVICO 
	ADD FOREIGN KEY (IDTEMPLATEACOMPANHAMENTO)
		REFERENCES TEMPLATESOLICITACAOSERVICO (IDTEMPLATE);

ALTER TABLE FORNECEDOR 
	ADD TELEFONE VARCHAR2(20);

ALTER TABLE FORNECEDOR 
	ADD FAX VARCHAR2(20);

ALTER TABLE FORNECEDOR 
	ADD NOMECONTATO VARCHAR2(100);

ALTER TABLE FORNECEDOR 
	ADD INSCRICAOESTADUAL VARCHAR2(25);

ALTER TABLE FORNECEDOR 
	ADD INSCRICAOMUNICIPAL VARCHAR2(25);

ALTER TABLE FORNECEDOR 
	ADD IDENDERECO NUMBER(38);

ALTER TABLE FORNECEDOR 
	ADD TIPOPESSOA CHAR(1);

ALTER TABLE FORNECEDOR 
	ADD FOREIGN KEY (IDENDERECO)
		REFERENCES ENDERECO (IDENDERECO);

ALTER TABLE UNIDADE 
	ADD IDENDERECO NUMBER(38);

ALTER TABLE UNIDADE 
	ADD ACEITAENTREGAPRODUTO CHAR(1);

ALTER TABLE UNIDADE 
	ADD FOREIGN KEY (IDENDERECO)
		REFERENCES ENDERECO (IDENDERECO);

ALTER TABLE UFS 
	ADD IDPAIS NUMBER(38);

ALTER TABLE UFS 
	ADD FOREIGN KEY (IDPAIS)
		REFERENCES PAIS (IDPAIS);

INSERT INTO PAIS (IDPAIS, NOME) VALUES (1, 'BRASIL');

UPDATE UFS SET IDPAIS = 1;

UPDATE FORNECEDOR SET TIPOPESSOA = 'J';

CREATE TABLE LIBERACAO (
	IDLIBERACAO          NUMBER(38) NOT NULL,
	IDSOLICITANTE        NUMBER(38) NOT NULL,
	IDRESPONSAVEL        NUMBER(38),
	TITULO               VARCHAR2(100) NOT NULL,
	DESCRICAO            CLOB NOT NULL,
	DATAINICIAL          DATE NOT NULL,
	DATAFINAL            DATE NOT NULL,
	DATALIBERACAO        DATE,
	SITUACAO             CHAR(1) NOT NULL,
	RISCO                CHAR(1) NOT NULL,
	VERSAO               VARCHAR2(25)
);

COMMENT ON COLUMN LIBERACAO.SITUACAO IS 'A - ACEITA, E - EM EXECUÇÃO, F - FINALIZADA, X - CANCELADA';

COMMENT ON COLUMN LIBERACAO.RISCO IS 'B - BAIXO, M - MÉDIO, A - ALTO';

ALTER TABLE LIBERACAO
	ADD PRIMARY KEY (IDLIBERACAO);

CREATE TABLE LIBERACAOMUDANCA (
	IDLIBERACAO          NUMBER(38) NOT NULL,
	IDREQUISICAOMUDANCA  NUMBER(38) NOT NULL
);

ALTER TABLE LIBERACAOMUDANCA
	ADD PRIMARY KEY (IDLIBERACAO, IDREQUISICAOMUDANCA);

ALTER TABLE LIBERACAO 
	ADD FOREIGN KEY (IDSOLICITANTE)
		REFERENCES EMPREGADOS (IDEMPREGADO);

ALTER TABLE LIBERACAO 
	ADD FOREIGN KEY (IDRESPONSAVEL)
		REFERENCES EMPREGADOS (IDEMPREGADO);

ALTER TABLE LIBERACAOMUDANCA 
	ADD FOREIGN KEY (IDLIBERACAO)
		REFERENCES LIBERACAO (IDLIBERACAO);

ALTER TABLE LIBERACAOMUDANCA 
	ADD FOREIGN KEY (IDREQUISICAOMUDANCA)
		REFERENCES REQUISICAOMUDANCA (IDREQUISICAOMUDANCA);

INSERT INTO MIDIA (IDMIDIA, NOME) VALUES (1, 'BLU-RAY');
INSERT INTO MIDIA (IDMIDIA, NOME) VALUES (2, 'CARTÃO DE MEMÓRIA');
INSERT INTO MIDIA (IDMIDIA, NOME) VALUES (3, 'CD');
INSERT INTO MIDIA (IDMIDIA, NOME) VALUES (4, 'DISQUETE');
INSERT INTO MIDIA (IDMIDIA, NOME) VALUES (5, 'DVD');
INSERT INTO MIDIA (IDMIDIA, NOME) VALUES (6, 'FITA MAGNÉTICA');
INSERT INTO MIDIA (IDMIDIA, NOME) VALUES (7, 'HD');
INSERT INTO MIDIA (IDMIDIA, NOME) VALUES (8, 'PEN DRIVE');
INSERT INTO MIDIA (IDMIDIA, NOME) VALUES (9, 'OUTROS');

INSERT INTO TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) VALUES (1, 'ANTI-VIRUS');
INSERT INTO TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) VALUES (2, 'AUXILIAR DE ESCRITÓRIO');
INSERT INTO TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) VALUES (3, 'COMUNICADOR INSTANTÂNEO');
INSERT INTO TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) VALUES (4, 'EDITOR DE IMAGEM');
INSERT INTO TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) VALUES (5, 'EDITOR DE TEXTO');
INSERT INTO TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) VALUES (6, 'NAVEGADOR');
INSERT INTO TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) VALUES (7, 'SISTEMA OPERACIONAL');
INSERT INTO TIPOSOFTWARE (IDTIPOSOFTWARE, NOME) VALUES (8, 'OUTROS');

-- ALTERACOES ADICIONAIS PARTE 3 - CITSMART 2.0
-- SCRIPT ORIGEM: citsmart3_2.0_oracle_corrigido.sql

ALTER TABLE ATIVIDADEPERIODICA 
	ADD IDREQUISICAOMUDANCA NUMBER(38);

ALTER TABLE ATIVIDADEPERIODICA 
	ADD FOREIGN KEY (IDREQUISICAOMUDANCA)
		REFERENCES REQUISICAOMUDANCA (IDREQUISICAOMUDANCA);

ALTER TABLE ATIVIDADEPERIODICA 
	ADD BLACKOUT CHAR(1);

ALTER TABLE PROBLEMA 
	ADD IDGRUPO NUMBER(38);

ALTER TABLE PROBLEMA 
	ADD IDSERVICO NUMBER(38);

ALTER TABLE PROBLEMA 
	ADD IDCONTRATO NUMBER(38);

ALTER TABLE PROBLEMA 
	ADD IDSERVICOCONTRATO NUMBER(38);

ALTER TABLE PROBLEMA 
	ADD IDPRIORIDADE NUMBER(38);

ALTER TABLE PROBLEMA 
	ADD DATAHORALIMITE TIMESTAMP;

ALTER TABLE PROBLEMA 
	ADD DATAHORASOLICITACAO TIMESTAMP;

ALTER TABLE PROBLEMA 
	ADD PRAZOHH NUMBER(38);

ALTER TABLE PROBLEMA 
	ADD PRAZOMM NUMBER(38);

ALTER TABLE PROBLEMA 
	ADD SLAACOMBINAR CHAR(1);

/* ESSA TABELA NAO EXISTIA */
CREATE TABLE SERVICO_HIST (
	IDHISTORICOSERVICO 			NUMBER(38) NOT NULL,
	IDSERVICO 				NUMBER(38) NOT NULL,
	IDCATEGORIASERVICO 			NUMBER(38) NOT NULL,
	IDSITUACAOSERVICO 			NUMBER(38) NOT NULL,
	IDTIPOSERVICO 				NUMBER(38) DEFAULT NULL,
	IDIMPORTANCIANEGOCIO 			NUMBER(38) DEFAULT NULL,
	IDEMPRESA 				NUMBER(38) NOT NULL,
	IDTIPOEVENTOSERVICO 			NUMBER(38) DEFAULT NULL,
	IDTIPODEMANDASERVICO 			NUMBER(38) DEFAULT NULL,
	IDLOCALEXECUCAOSERVICO 			NUMBER(38) DEFAULT NULL,
	NOMESERVICO 				VARCHAR2(500) NOT NULL,
	DETALHESERVICO 				CLOB,
	OBJETIVO 				CLOB,
	PASSOSSERVICO 				CLOB,
	DATAINICIO 				DATE DEFAULT NULL,
	LINKPROCESSO 				VARCHAR2(500) DEFAULT NULL,
	DESCRICAOPROCESSO 			CLOB,
	TIPODESCPROCESS 			CHAR(1) DEFAULT NULL,
	DISPPORTAL 				CHAR(1) DEFAULT NULL,
	QUADROORIENTPORTAL 			CLOB,
	DELETED 				CHAR(1) DEFAULT NULL,
	DETALHESSERVICO 			VARCHAR2(255) DEFAULT NULL,
	SIGLAABREV 				VARCHAR2(150) DEFAULT NULL,
	IDBASECONHECIMENTO 			NUMBER(38) DEFAULT NULL,
	IDTEMPLATESOLICITACAO 			NUMBER(38) DEFAULT NULL,
	IDTEMPLATEACOMPANHAMENTO 		NUMBER(38) DEFAULT NULL,
	PRIMARY KEY (IDHISTORICOSERVICO)
);

ALTER TABLE SERVICO_HIST ADD CRIADOEM TIMESTAMP;

ALTER TABLE SERVICO_HIST ADD CRIADOPOR VARCHAR2(25);

ALTER TABLE SERVICO_HIST ADD MODIFICADOEM TIMESTAMP;

ALTER TABLE SERVICO_HIST ADD MODIFICADOPOR VARCHAR2(25);

ALTER TABLE SERVICO_HIST ADD CONTEUDODADOS CLOB;

ALTER TABLE ACORDONIVELSERVICO ADD TEMPOAUTO NUMBER(15,3);

ALTER TABLE ACORDONIVELSERVICO ADD IDPRIORIDADEAUTO1 NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO ADD IDPRIORIDADEAUTO2 NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO ADD IDPRIORIDADEAUTO3 NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO ADD IDPRIORIDADEAUTO4 NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO ADD IDPRIORIDADEAUTO5 NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO ADD IDGRUPO1 NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO ADD IDGRUPO2 NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO ADD IDGRUPO3 NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO ADD IDGRUPO4 NUMBER(38);

ALTER TABLE ACORDONIVELSERVICO ADD IDGRUPO5 NUMBER(38);

/* ESSA TABELA NAO EXISTIA */
CREATE TABLE PLANOMELHORIA (
	IDPLANOMELHORIA      	NUMBER(38) NOT NULL,
	IDFORNECEDOR         	NUMBER(38),
	IDCONTRATO           	NUMBER(38),
	TITULO              	VARCHAR2(100) NOT NULL,
	DATAINICIO           	DATE NOT NULL,
	DATAFIM              	DATE,
	OBJETIVO             	CLOB,
	VISAOGERAL           	CLOB,
	ESCOPO               	CLOB,
	VISAO                	CLOB,
	MISSAO               	CLOB,
	DATACRIACAO          	DATE,
	NOTAS                	CLOB,
	CRIADOPOR            	VARCHAR2(40),
	MODIFICADOPOR        	VARCHAR2(40),
	ULTMODIFICACAO       	DATE,
	SITUACAO             	CHAR(1),
	PRIMARY KEY (IDPLANOMELHORIA)
);

CREATE INDEX IX_PM_FORN 
	ON PLANOMELHORIA (IDFORNECEDOR);

CREATE INDEX IX_PM_CONTRATO 
	ON PLANOMELHORIA (IDCONTRATO, IDFORNECEDOR);

/* ESSA TABELA NAO EXISTIA */
CREATE TABLE OBJETIVOPLANOMELHORIA (
	IDOBJETIVOPLANOMELHORIA 	NUMBER(38) NOT NULL,
	IDPLANOMELHORIA      		NUMBER(38) NOT NULL,
	TITULOOBJETIVO       		VARCHAR2(255) NOT NULL,
	DETALHAMENTO         		CLOB,
	RESULTADOESPERADO    		CLOB,
	MEDICAO              		VARCHAR2(255),
	RESPONSAVEL          		VARCHAR2(255),
	CRIADOPOR            		VARCHAR2(40),
	MODIFICADOPOR        		VARCHAR2(40),
	DATACRIACAO          		DATE,
	ULTMODIFICACAO       		DATE,
	PRIMARY KEY (IDOBJETIVOPLANOMELHORIA)
);

CREATE INDEX IX_OBJ_PM_ID 
	ON OBJETIVOPLANOMELHORIA (IDPLANOMELHORIA);

ALTER TABLE OBJETIVOPLANOMELHORIA 
	ADD FOREIGN KEY (IDPLANOMELHORIA)
		REFERENCES PLANOMELHORIA (IDPLANOMELHORIA);

/* ESSA TABELA NAO EXISTIA */	  
CREATE TABLE ACAOPLANOMELHORIA (
	IDACAOPLANOMELHORIA  		NUMBER(38) NOT NULL,
	IDPLANOMELHORIA      		NUMBER(38) NOT NULL,
	IDOBJETIVOPLANOMELHORIA 	NUMBER(38) NOT NULL,
	TITULOACAO           		VARCHAR2(255) NOT NULL,
	DETALHAMENTOACAO     		CLOB,
	DATAINICIO           		DATE,
	DATAFIM              		DATE,
	RESPONSAVEL          		VARCHAR2(255),
	DATACONCLUSAO        		DATE,
	CRIADOPOR            		VARCHAR2(40),
	MODIFICADOPOR        		VARCHAR2(40),
	DATACRIACAO          		DATE,
	ULTMODIFICACAO       		DATE,
	PRIMARY KEY (IDACAOPLANOMELHORIA)
);

CREATE INDEX IX_ACT_PM_ID 
	ON ACAOPLANOMELHORIA (IDOBJETIVOPLANOMELHORIA);

ALTER TABLE ACAOPLANOMELHORIA 
	ADD FOREIGN KEY (IDPLANOMELHORIA)
		REFERENCES PLANOMELHORIA (IDPLANOMELHORIA);

ALTER TABLE ACAOPLANOMELHORIA 
	ADD FOREIGN KEY (IDOBJETIVOPLANOMELHORIA)
		REFERENCES OBJETIVOPLANOMELHORIA (IDOBJETIVOPLANOMELHORIA);

/* ESSA TABELA NAO EXISTIA */
CREATE TABLE OBJETIVOMONITORAMENTO (
	IDOBJETIVOMONITORAMENTO 		NUMBER(38) NOT NULL,
	IDOBJETIVOPLANOMELHORIA 		NUMBER(38) NOT NULL,
	TITULOMONITORAMENTO  			VARCHAR2(255) NOT NULL,
	FATORCRITICOSUCESSO  			VARCHAR2(255),
	KPI                  			VARCHAR2(255),
	METRICA              			CLOB,
	MEDICAO              			CLOB,
	RELATORIOS           			CLOB,
	RESPONSAVEL          			VARCHAR2(255),
	CRIADOPOR            			VARCHAR2(40),
	MODIFICADOPOR        			VARCHAR2(40),
	DATACRIACAO          			DATE,
	ULTMODIFICACAO       			DATE,
	PRIMARY KEY (IDOBJETIVOMONITORAMENTO)
);

ALTER TABLE OBJETIVOMONITORAMENTO 
	ADD FOREIGN KEY (IDOBJETIVOPLANOMELHORIA)
		REFERENCES OBJETIVOPLANOMELHORIA (IDOBJETIVOPLANOMELHORIA);

	  
ALTER TABLE BASECONHECIMENTO 
	ADD GERENCIAMENTODISPONIBILIDADE CHAR(1);

ALTER TABLE BASECONHECIMENTO 
	ADD DIREITOAUTORAL CHAR(1);

ALTER TABLE BASECONHECIMENTO 
	ADD LEGISLACAO CHAR(1);
  
/* ESSA TABELA JA EXISTIA */
CREATE TABLE CATALOGOSERVICO (
	IDCATALOGOSERVICO 		NUMBER(38) DEFAULT '0' NOT NULL,
	IDCONTRATO 			NUMBER(38) DEFAULT NULL,
	DATAINICIO 			DATE DEFAULT NULL,
	DATAFIM 			DATE DEFAULT NULL,
	OBS 				CLOB,
	NOMESERVICO 			CHAR(150) DEFAULT NULL,
	TITULOCATALOGOSERVICO 		VARCHAR2(256) DEFAULT NULL,
	PRIMARY KEY (IDCATALOGOSERVICO)
);

ALTER TABLE CATALOGOSERVICO
	ADD FOREIGN KEY (IDCONTRATO)
		REFERENCES CONTRATOS (IDCONTRATO);

CREATE TABLE INFOCATALOGOSERVICO (
	IDINFOCATALOGOSERVICO 		NUMBER(38) NOT NULL,
	IDCATALOGOSERVICO 		    NUMBER(38),
	DESCINFOCATALOGOSERVICO 	CLOB
);

ALTER TABLE INFOCATALOGOSERVICO
	ADD PRIMARY KEY (IDINFOCATALOGOSERVICO);

ALTER TABLE INFOCATALOGOSERVICO
	ADD FOREIGN KEY (IDCATALOGOSERVICO)
		REFERENCES CATALOGOSERVICO (IDCATALOGOSERVICO);    

/* ESSA TABELA JA EXISTIA */
CREATE TABLE SERVCONTRATOCATALOGOSERV (
	IDSERVICOCONTRATO 	NUMBER(38) DEFAULT NULL,
	IDCATALOGOSERVICO 	NUMBER(38) DEFAULT NULL
);

ALTER TABLE SERVCONTRATOCATALOGOSERV 
	MODIFY IDSERVICOCONTRATO 	NUMBER(38);

ALTER TABLE SERVCONTRATOCATALOGOSERV
	ADD FOREIGN KEY (IDSERVICOCONTRATO)  
		REFERENCES SERVICO (IDSERVICO);

ALTER TABLE SERVCONTRATOCATALOGOSERV 
	ADD FOREIGN KEY (IDCATALOGOSERVICO)  
		REFERENCES  CATALOGOSERVICO (IDCATALOGOSERVICO);

/* ESSA TABELA NAO EXISTIA */
CREATE TABLE CONHECIMENTOIC (
	IDITEMCONFIGURACAO 	NUMBER(38) NOT NULL,
	IDBASECONHECIMENTO 	NUMBER(38) NOT NULL,
	PRIMARY KEY (IDITEMCONFIGURACAO, IDBASECONHECIMENTO) 
);
      
ALTER TABLE CONHECIMENTOIC
	ADD FOREIGN KEY (IDITEMCONFIGURACAO)
		REFERENCES ITEMCONFIGURACAO (IDITEMCONFIGURACAO);

ALTER TABLE CONHECIMENTOIC
	ADD FOREIGN KEY (IDBASECONHECIMENTO)
		REFERENCES BASECONHECIMENTO (IDBASECONHECIMENTO);

/* ESSA TABELA NAO EXISTIA */
CREATE TABLE CONHECIMENTOPROBLEMA (
	IDPROBLEMA 		      NUMBER(38) NOT NULL,
	IDBASECONHECIMENTO 	NUMBER(38) NOT NULL,
	PRIMARY KEY (IDPROBLEMA, IDBASECONHECIMENTO)
);

ALTER TABLE CONHECIMENTOPROBLEMA
	ADD FOREIGN KEY (IDPROBLEMA)
		REFERENCES PROBLEMA (IDPROBLEMA);

ALTER TABLE CONHECIMENTOPROBLEMA
	ADD FOREIGN KEY (IDBASECONHECIMENTO)
		REFERENCES BASECONHECIMENTO (IDBASECONHECIMENTO);

/* ESSA TABELA NAO EXISTIA */  
CREATE  TABLE CONHECIMENTOMUDANCA (
	IDREQUISICAOMUDANCA 	NUMBER(38) NOT NULL,
	IDBASECONHECIMENTO 	NUMBER(38) NOT NULL,
	PRIMARY KEY (IDREQUISICAOMUDANCA, IDBASECONHECIMENTO) 
);

ALTER TABLE CONHECIMENTOMUDANCA
	ADD FOREIGN KEY (IDREQUISICAOMUDANCA)
		REFERENCES REQUISICAOMUDANCA (IDREQUISICAOMUDANCA);

ALTER TABLE CONHECIMENTOMUDANCA
	ADD FOREIGN KEY (IDBASECONHECIMENTO)
		REFERENCES BASECONHECIMENTO (IDBASECONHECIMENTO);  

/* ESSA TABELA NAO EXISTIA */
CREATE  TABLE CONHECIMENTOSOLICITACAOSERVICO (
	IDSOLICITACAOSERVICO 	NUMBER(38) NOT NULL,
	IDBASECONHECIMENTO 	NUMBER(38) NOT NULL,
	PRIMARY KEY (IDSOLICITACAOSERVICO, IDBASECONHECIMENTO) 
);

ALTER TABLE CONHECIMENTOSOLICITACAOSERVICO
	ADD FOREIGN KEY (IDSOLICITACAOSERVICO)
		REFERENCES SOLICITACAOSERVICO (IDSOLICITACAOSERVICO);

ALTER TABLE CONHECIMENTOSOLICITACAOSERVICO
	ADD FOREIGN KEY (IDBASECONHECIMENTO)
		REFERENCES BASECONHECIMENTO (IDBASECONHECIMENTO);

ALTER TABLE ITEMREQUISICAOPRODUTO 
	ADD VALORAPROVADO NUMBER(8,2);

ALTER TABLE COTACAOITEMREQUISICAO 
	ADD IDITEMTRABALHO NUMBER(38);

ALTER TABLE INSPECAOENTREGAITEM 
	MODIFY AVALIACAO VARCHAR2(25) DEFAULT NULL;

ALTER TABLE INSPECAOPEDIDOCOMPRA 
	MODIFY AVALIACAO VARCHAR2(25) DEFAULT NULL;

/* ESSA TABELA NAO EXISTIA */
CREATE TABLE CRITERIOCOTACAOCATEGORIA (
	   IDCATEGORIA          NUMBER(38) NOT NULL,
	   IDCRITERIO           NUMBER(38) NOT NULL,
	   PESOCOTACAO          NUMBER(38) NOT NULL
);

ALTER TABLE CRITERIOCOTACAOCATEGORIA
	ADD PRIMARY KEY (IDCATEGORIA, IDCRITERIO);

ALTER TABLE CRITERIOCOTACAOCATEGORIA 
	ADD FOREIGN KEY (IDCATEGORIA)
		REFERENCES CATEGORIAPRODUTO (IDCATEGORIA);

ALTER TABLE CRITERIOCOTACAOCATEGORIA 
	ADD FOREIGN KEY (IDCRITERIO)
		REFERENCES CRITERIOAVALIACAO (IDCRITERIO);

/*
ESSA LINHA NAO FUNCIONA NO ORACLE
DROP TABLE IF EXISTS HISTORICOSITUACAOCOTACAO;
*/

/* ESSA TABELA NAO EXISTIA */
CREATE TABLE HISTORICOSITUACAOCOTACAO (
	IDHISTORICO          NUMBER(38) NOT NULL,
	IDCOTACAO            NUMBER(38) NOT NULL,
	IDRESPONSAVEL        NUMBER(38) NOT NULL,
	DATAHORA             TIMESTAMP NOT NULL,
	SITUACAO             VARCHAR2(25) NOT NULL
);

ALTER TABLE HISTORICOSITUACAOCOTACAO
	ADD PRIMARY KEY (IDHISTORICO);

ALTER TABLE HISTORICOSITUACAOCOTACAO 
	ADD FOREIGN KEY (IDCOTACAO)
		REFERENCES COTACAO (IDCOTACAO);

ALTER TABLE HISTORICOSITUACAOCOTACAO 
	ADD FOREIGN KEY (IDRESPONSAVEL)
		REFERENCES EMPREGADOS (IDEMPREGADO);

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (8, 'CRIAÇÃO DA PASTA - ${NOME}', 'INFORMAMOS QUE FOI CRIADO A PASTA ${NOME}.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.<BR />', 'A', 'CP');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (9, 'ALTERAÇÃO DA PASTA - ${NOME}', 'INFORMAMOS QUE A PASTA ${NOME} FOI ALTERADA.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.<BR />', 'A', 'AP');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (10, 'EXCLUSÃO DA PASTA - ${NOME}', 'INFORMAMOS QUE A PASTA ${NOME} FOI EXCLU&IACUTE;DA.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.', 'A', 'EP');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (11, 'CRIAÇÃO DO DOCUMENTO - ${TITULO}','INFORMAMOS QUE FOI CRIADO O DOCUMENTO ${TITULO}.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.<BR />', 'A', 'CC');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (12, 'ALTERAÇÃO DO DOCUMENTO - ${TITULO}', 'INFORMAMOS QUE O DOCUMENTO ${TITULO} FOI ALTERADO.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.<BR />', 'A', 'AC');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (13, 'EXCLUSÃO DO DOCUMENTO - ${TITULO}', 'INFORMAMOS QUE O DOCUMENTO ${TITULO} FOI EXCLU&IACUTE;DO.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.<BR />', 'A', 'EC');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (14, 'ALTERAÇÃO DO ITEM CONFIGURAÇÃO - ${IDENTIFICACAO}', 'INFORMAMOS QUE O ITEM DE CONFIGURA&CCEDIL;&ATILDE;O IDENTIFICADO COMO ${IDENTIFICACAO} SOFREU ALTERA&CCEDIL;&ATILDE;O.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.', 'A', 'ALTERACAOIC');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (15, 'ALTERAÇÃO DO ITEM CONFIGURAÇÃO PARA GRUPO- ${IDENTIFICACAO}', 'INFORMAMOS QUE O ITEM DE CONFIGURA&CCEDIL;&ATILDE;O IDENTIFICADO COMO ${IDENTIFICACAO} FOI ALTERADO PARA O GRUPO ${NOMEGRUPOITEMCONFIGURACAO}<BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.', 'A', 'ALTERACAOICGRUPO');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (16, 'CRIAÇÃO DO ITEM CONFIGURAÇÃO - ${IDENTIFICACAO}', 'INFORMAMOS A CRIA&CCEDIL;&ATILDE;O DO ITEM DE CONFIGURA&CCEDIL;&ATILDE;O IDENTIFICADO COMO ${IDENTIFICACAO} .<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.', 'A', 'CRIACAOIC');

INSERT INTO MODELOSEMAILS (IDMODELOEMAIL, TITULO, TEXTO, SITUACAO, IDENTIFICADOR) 
VALUES (17, 'ALTERAÇÃO SERVIÇO - ${NOMESERVICO}', 'INFORMAMOS QUE O SERVI&CCEDIL;O IDENTIFICADO COMO ${NOMESERVICO} SOFREU ALTERA&CCEDIL;&ATILDE;O.<BR /><BR /><BR />ATENCIOSAMENTE,<BR /><BR />CENTRAL IT TECNOLOGIA DA INFORMA&CCEDIL;&ATILDE;O LTDA.', 'A', 'ALTERACAOSERVICO');

ALTER TABLE CAMPOSOBJETONEGOCIO
  ADD PRECISIONDB NUMBER(38) DEFAULT 0 NOT NULL;
  

/* 
CONSTRAINT NAO EXISTIA NO BANCO

ALTER TABLE ITEMCONFIGURACAO 
	DROP CONSTRAINT ITEMCONFIGURACAO_IBFK_1;

*/

-- ALTERACOES ADICIONAIS PARTE 4 - CITSMART 2.0
-- SCRIPT ORIGEM: citsmart4_2.0_oracle_corrigido.sql

-- SCRIPT ADICIONAL PARA QUE O SCRIPT citsmart4_2.0_oracle_corrigido.sql FUNCIONE.
DELETE FROM UFS;
DELETE FROM CIDADES;

INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (0,' -- INDEFINIDA -- ','--',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (1,'DISTRITO FEDERAL','DF',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (2,'SÃO PAULO','SP',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (3,'RIO DE JANEIRO','RJ',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (4,'GOIÁS','GO',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (5,'TOCANTINS','TO',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (6,'MINAS GERAIS','MG',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (7,'PARANÁ','PR',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (8,'ESPIRITO SANTO','ES',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (9,'ACRE','AC',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (10,'ALAGOAS','AL',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (11,'AMAPÁ','AP',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (12,'AMAZONAS','AM',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (13,'BAHIA','BA',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (14,'CEARÁ','CE',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (15,'MARANHÃO','MA',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (16,'MATO GROSSO','MT',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (17,'MATO GROSSO DO SUL','MS',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (18,'PARAÍBA','PB',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (19,'PARÁ','PA',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (20,'PERNAMBUCO','PE',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (21,'PIAUÍ','PI',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (22,'RIO GRANDE DO NORTE','RN',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (23,'RIO GRANDE DO SUL','RS',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (24,'RONDÔNIA','RO',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (25,'RORAIMA','RR',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (26,'SANTA CATARINA','SC',NULL,1);
INSERT INTO UFS (IDUF,NOMEUF,SIGLAUF,IDREGIOES,IDPAIS) VALUES (27,'SERGIPE','SE',NULL,1);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0001, 'ACRELÂNDIA', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0002, 'ASSIS BRASIL', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0003, 'BRASILÉIA' , 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0004, 'BUJARI', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0005, 'CAPIXABA', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0006, 'CRUZEIRO DO SUL', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0007, 'EPITACIOLÂNDIA' , 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0008, 'FEIJÓ', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0009, 'JORDÃO', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0010, 'MÂNCIO LIMA' , 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0011, 'MANOEL URBANO', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0012, 'MARECHAL THAUMATURGO' , 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0013, 'PLÁCIDO DE CASTRO', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0014, 'PORTO ACRE', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0015, 'PORTO WALTER', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0016, 'RIO BRANCO', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0017, 'RODRIGUES ALVES', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0018, 'SANTA ROSA DO PURUS', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0019, 'SENA MADUREIRA' , 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0020, 'SENADOR GUIOMARD' , 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0021, 'TARAUACÁ', 09);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0022, 'XAPURI', 09);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0023, 'ÁGUA BRANCA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0024, 'ANADIA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0025, 'ARAPIRACA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0026, 'ATALAIA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0027, 'BARRA DE SANTO ANTÔNIO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0028, 'BARRA DE SÃO MIGUEL', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0029, 'BATALHA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0030, 'BELÉM', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0031, 'BELO MONTE', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0032, 'BOCA DA MATA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0033, 'BRANQUINHA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0034, 'CACIMBINHAS' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0035, 'CAJUEIRO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0036, 'CAMPESTRE' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0037, 'CAMPO ALEGRE', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0038, 'CAMPO GRANDE', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0039, 'CANAPI', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0040, 'CAPELA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0041, 'CARNEIROS' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0042, 'CHÃ PRETA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0043, 'COITÉ DO NÓIA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0044, 'COLÔNIA LEOPOLDINA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0045, 'COQUEIRO SECO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0046, 'CORURIPE', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0047, 'CRAÍBAS' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0048, 'DELMIRO GOUVEIA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0049, 'DOIS RIACHOS', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0050, 'ESTRELA DE ALAGOAS', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0051, 'FEIRA GRANDE', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0052, 'FELIZ DESERTO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0053, 'FLEXEIRAS' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0054, 'GIRAU DO PONCIANO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0055, 'IBATEGUARA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0056, 'IGACI', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0057, 'IGREJA NOVA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0058, 'INHAPI', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0059, 'JACARÉ DOS HOMENS', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0060, 'JACUÍPE' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0061, 'JAPARATINGA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0062, 'JARAMATAIA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0063, 'JOAQUIM GOMES', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0064, 'JUNDIÁ', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0065, 'JUNQUEIRO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0066, 'LAGOA DA CANOA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0067, 'LIMOEIRO DE ANADIA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0068, 'MACEIÓ', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0069, 'MAJOR ISIDORO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0070, 'MAR VERMELHO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0071, 'MARAGOGI', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0072, 'MARAVILHA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0073, 'MARECHAL DEODORO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0074, 'MARIBONDO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0075, 'MATA GRANDE' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0076, 'MATRIZ DE CAMARAGIBE' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0077, 'MESSIAS' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0078, 'MINADOR DO NEGRÃO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0079, 'MONTEIRÓPOLIS', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0080, 'MURICI', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0081, 'NOVO LINO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0082, 'OLHO D`ÁGUA DAS FLORES' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0083, 'OLHO D`ÁGUA DO CASADO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0084, 'OLHO D`ÁGUA GRANDE', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0085, 'OLIVENÇA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0086, 'OURO BRANCO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0087, 'PALESTINA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0088, 'PALMEIRA DOS ÍNDIOS', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0089, 'PÃO DE AÇÚCAR', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0090, 'PARICONHA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0091, 'PARIPUEIRA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0092, 'PASSO DE CAMARAGIBE', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0093, 'PAULO JACINTO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0094, 'PENEDO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0095, 'PIAÇABUÇU' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0096, 'PILAR', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0097, 'PINDOBA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0098, 'PIRANHAS', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0099, 'POÇO DAS TRINCHEIRAS' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0100, 'PORTO CALVO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0101, 'PORTO DE PEDRAS', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0102, 'PORTO REAL DO COLÉGIO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0103, 'QUEBRANGULO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0104, 'RIO LARGO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0105, 'ROTEIRO' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0106, 'SANTA LUZIA DO NORTE' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0107, 'SANTANA DO IPANEMA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0108, 'SANTANA DO MUNDAÚ', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0109, 'SÃO BRÁS', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0110, 'SÃO JOSÉ DA LAJE' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0111, 'SÃO JOSÉ DA TAPERA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0112, 'SÃO LUÍS DO QUITUNDE' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0113, 'SÃO MIGUEL DOS CAMPOS', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0114, 'SÃO MIGUEL DOS MILAGRES', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0115, 'SÃO SEBASTIÃO', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0116, 'SATUBA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0117, 'SENADOR RUI PALMEIRA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0118, 'TANQUE D`ARCA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0119, 'TAQUARANA' , 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0120, 'TEOTÔNIO VILELA', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0121, 'TRAIPU', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0122, 'UNIÃO DOS PALMARES', 10);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0123, 'VIÇOSA', 10);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0124, 'AMAPÁ', 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0125, 'CALÇOENE', 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0126, 'CUTIAS', 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0127, 'FERREIRA GOMES' , 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0128, 'ITAUBAL' , 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0129, 'LARANJAL DO JARI' , 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0130, 'MACAPÁ', 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0131, 'MAZAGÃO' , 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0132, 'OIAPOQUE', 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0133, 'PEDRA BRANCA DO AMAPARÍ', 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0134, 'PORTO GRANDE', 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0135, 'PRACUÚBA', 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0136, 'SANTANA' , 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0137, 'SERRA DO NAVIO' , 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0138, 'TARTARUGALZINHO', 11);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0139, 'VITÓRIA DO JARI', 11);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0140, 'ALVARÃES', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0141, 'AMATURÁ' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0142, 'NAMÃ' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0143, 'ANORI', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0144, 'APUÍ' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0145, 'ATALAIA DO NORTE' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0146, 'AUTAZES' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0147, 'BARCELOS', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0148, 'BARREIRINHA' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0149, 'BENJAMIN CONSTANT', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0150, 'BERURI', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0151, 'BOA VISTA DO RAMOS', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0152, 'BOCA DO ACRE', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0153, 'BORBA', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0154, 'CAAPIRANGA', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0155, 'CANUTAMA', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0156, 'CARAUARI', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0157, 'CAREIRO' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0158, 'CAREIRO DA VÁRZEA', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0159, 'COARI', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0160, 'CODAJÁS' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0161, 'EIRUNEPÉ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0162, 'ENVIRA', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0163, 'FONTE BOA' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0164, 'GUAJARÁ' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0165, 'HUMAITÁ' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0166, 'IPIXUNA' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0167, 'IRANDUBA', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0168, 'ITACOATIARA' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0169, 'ITAMARATI' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0170, 'ITAPIRANGA', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0171, 'JAPURÁ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0172, 'JURUÁ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0173, 'JUTAÍ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0174, 'LÁBREA', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0175, 'MANACAPURU', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0176, 'MANAQUIRI' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0177, 'MANAUS', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0178, 'MANICORÉ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0179, 'MARAÃ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0180, 'MAUÉS', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0181, 'NHAMUNDÁ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0182, 'NOVA OLINDA DO NORTE' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0183, 'NOVO AIRÃO', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0184, 'NOVO ARIPUANÃ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0185, 'PARINTINS' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0186, 'PAUINI', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0187, 'PRESIDENTE FIGUEIREDO', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0188, 'RIO PRETO DA EVA' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0189, 'SANTA ISABEL DO RIO NEGRO', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0190, 'SANTO ANTÔNIO DO IÇÁ' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0191, 'SÃO GABRIEL DA CACHOEIRA' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0192, 'SÃO PAULO DE OLIVENÇA', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0193, 'SÃO SEBASTIÃO DO UATUMÃ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0194, 'SILVES', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0195, 'TABATINGA' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0196, 'TAPAUÁ', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0197, 'TEFÉ' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0198, 'TONANTINS' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0199, 'UARINI', 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0200, 'URUCARÁ' , 12);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0201, 'URUCURITUBA' , 12);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0202, 'ABAÍRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0203, 'ABARÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0204, 'ACAJUTIBA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0205, 'ADUSTINA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0206, 'ÁGUA FRIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0207, 'AIQUARA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0208, 'ALAGOINHAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0209, 'ALCOBAÇA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0210, 'ALMADINA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0211, 'AMARGOSA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0212, 'AMÉLIA RODRIGUES' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0213, 'AMÉRICA DOURADA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0214, 'ANAGÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0215, 'ANDARAÍ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0216, 'ANDORINHA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0217, 'ANGICAL' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0218, 'ANGUERA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0219, 'ANTAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0220, 'ANTÔNIO CARDOSO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0221, 'ANTÔNIO GONÇALVES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0222, 'APORÁ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0223, 'APUAREMA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0224, 'ARAÇAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0225, 'ARACATU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0226, 'ARACI', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0227, 'ARAMARI' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0228, 'ARATACA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0229, 'ARATUÍPE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0230, 'AURELINO LEAL', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0231, 'BAIANÓPOLIS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0232, 'BAIXA GRANDE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0233, 'BANZAÊ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0234, 'BARRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0235, 'BARRA DA ESTIVA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0236, 'BARRA DO CHOÇA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0237, 'BARRA DO MENDES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0238, 'BARRA DO ROCHA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0239, 'BARREIRAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0240, 'BARRO ALTO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0241, 'BELMONTE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0242, 'BELO CAMPO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0243, 'BIRITINGA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0244, 'BOA NOVA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0245, 'BOA VISTA DO TUPIM', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0246, 'BOM JESUS DA LAPA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0247, 'BOM JESUS DA SERRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0248, 'BONINAL' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0249, 'BONITO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0250, 'BOQUIRA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0251, 'BOTUPORÃ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0252, 'BREJÕES' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0253, 'BREJOLÂNDIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0254, 'BROTAS DE MACAÚBAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0255, 'BRUMADO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0256, 'BUERAREMA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0257, 'BURITIRAMA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0258, 'CAATIBA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0259, 'CABACEIRAS DO PARAGUAÇU', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0260, 'CACHOEIRA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0261, 'CACULÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0262, 'CAÉM' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0263, 'CAETANOS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0264, 'CAETITÉ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0265, 'CAFARNAUM' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0266, 'CAIRU', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0267, 'CALDEIRÃO GRANDE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0268, 'CAMACAN' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0269, 'CAMAÇARI', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0270, 'CAMAMU', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0271, 'CAMPO ALEGRE DE LOURDES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0272, 'CAMPO FORMOSO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0273, 'CANÁPOLIS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0274, 'CANARANA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0275, 'CANAVIEIRAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0276, 'CANDEAL' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0277, 'CANDEIAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0278, 'CANDIBA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0279, 'CÂNDIDO SALES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0280, 'CANSANÇÃO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0281, 'CANUDOS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0282, 'CAPELA DO ALTO ALEGRE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0283, 'CAPIM GROSSO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0284, 'CARAÍBAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0285, 'CARAVELAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0286, 'CARDEAL DA SILVA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0287, 'CARINHANHA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0288, 'CASA NOVA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0289, 'CASTRO ALVES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0290, 'CATOLÂNDIA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0291, 'CATU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0292, 'CATURAMA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0293, 'CENTRAL' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0294, 'CHORROCHÓ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0295, 'CÍCERO DANTAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0296, 'CIPÓ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0297, 'COARACI' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0298, 'COCOS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0299, 'CONCEIÇÃO DA FEIRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0300, 'CONCEIÇÃO DO ALMEIDA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0301, 'CONCEIÇÃO DO COITÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0302, 'CONCEIÇÃO DO JACUÍPE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0303, 'CONDE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0304, 'CONDEÚBA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0305, 'CONTENDAS DO SINCORÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0306, 'CORAÇÃO DE MARIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0307, 'CORDEIROS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0308, 'CORIBE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0309, 'CORONEL JOÃO SÁ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0310, 'CORRENTINA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0311, 'COTEGIPE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0312, 'CRAVOLÂNDIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0313, 'CRISÓPOLIS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0314, 'CRISTÓPOLIS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0315, 'CRUZ DAS ALMAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0316, 'CURAÇÁ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0317, 'DÁRIO MEIRA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0318, 'DIAS D`ÁVILA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0319, 'DOM BASÍLIO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0320, 'DOM MACEDO COSTA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0321, 'ELÍSIO MEDRADO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0322, 'ENCRUZILHADA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0323, 'ENTRE RIOS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0324, 'ÉRICO CARDOSO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0325, 'ESPLANADA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0326, 'EUCLIDES DA CUNHA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0327, 'EUNÁPOLIS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0328, 'FÁTIMA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0329, 'FEIRA DA MATA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0330, 'FEIRA DE SANTANA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0331, 'FILADÉLFIA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0332, 'FIRMINO ALVES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0333, 'FLORESTA AZUL', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0334, 'FORMOSA DO RIO PRETO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0335, 'GANDU', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0336, 'GAVIÃO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0337, 'GENTIO DO OURO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0338, 'GLÓRIA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0339, 'GONGOGI' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0340, 'GOVERNADOR LOMANTO JÚNIOR', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0341, 'GOVERNADOR MANGABEIRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0342, 'GUAJERU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0343, 'GUANAMBI', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0344, 'GUARATINGA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0345, 'HELIÓPOLIS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0346, 'IAÇU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0347, 'IBIASSUCÊ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0348, 'IBICARAÍ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0349, 'IBICOARA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0350, 'IBICUÍ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0351, 'IBIPEBA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0352, 'IBIPITANGA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0353, 'IBIQUERA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0354, 'IBIRAPITANGA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0355, 'IBIRAPUÃ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0356, 'IBIRATAIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0357, 'IBITIARA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0358, 'IBITITÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0359, 'IBOTIRAMA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0360, 'ICHU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0361, 'IGAPORÃ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0362, 'IGRAPIÚNA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0363, 'IGUAÍ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0364, 'ILHÉUS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0365, 'INHAMBUPE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0366, 'IPECAETÁ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0367, 'IPIAÚ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0368, 'IPIRÁ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0369, 'IPUPIARA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0370, 'IRAJUBA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0371, 'IRAMAIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0372, 'IRAQUARA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0373, 'IRARÁ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0374, 'IRECÊ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0375, 'ITABELA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0376, 'ITABERABA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0377, 'ITABUNA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0378, 'ITACARÉ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0379, 'ITAETÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0380, 'ITAGI', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0381, 'ITAGIBÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0382, 'ITAGIMIRIM', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0383, 'ITAGUAÇU DA BAHIA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0384, 'ITAJU DO COLÔNIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0385, 'ITAJUÍPE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0386, 'ITAMARAJU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0387, 'ITAMARI' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0388, 'ITAMBÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0389, 'ITANAGRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0390, 'ITANHÉM' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0391, 'ITAPARICA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0392, 'ITAPÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0393, 'ITAPEBI' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0394, 'ITAPETINGA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0395, 'ITAPICURU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0396, 'ITAPITANGA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0397, 'ITAQUARA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0398, 'ITARANTIM' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0399, 'ITATIM', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0400, 'ITIRUÇU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0401, 'ITIÚBA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0402, 'ITORORÓ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0403, 'ITUAÇU', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0404, 'ITUBERÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0405, 'IUIÚ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0406, 'JABORANDI' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0407, 'JACARACI', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0408, 'JACOBINA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0409, 'JAGUAQUARA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0410, 'JAGUARARI' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0411, 'JAGUARIPE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0412, 'JANDAÍRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0413, 'JEQUIÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0414, 'JEREMOABO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0415, 'JIQUIRIÇÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0416, 'JITAÚNA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0417, 'JOÃO DOURADO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0418, 'JUAZEIRO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0419, 'JUCURUÇU', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0420, 'JUSSARA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0421, 'JUSSARI' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0422, 'JUSSIAPE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0423, 'LAFAIETE COUTINHO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0424, 'LAGOA REAL', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0425, 'LAJE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0426, 'LAJEDÃO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0427, 'LAJEDINHO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0428, 'LAJEDO DO TABOCAL', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0429, 'LAMARÃO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0430, 'LAPÃO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0431, 'LAURO DE FREITAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0432, 'LENÇÓIS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0433, 'LICÍNIO DE ALMEIDA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0434, 'LIVRAMENTO DE NOSSA SENHORA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0435, 'MACAJUBA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0436, 'MACARANI', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0437, 'MACAÚBAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0438, 'MACURURÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0439, 'MADRE DE DEUS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0440, 'MAETINGA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0441, 'MAIQUINIQUE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0442, 'MAIRI', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0443, 'MALHADA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0444, 'MALHADA DE PEDRAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0445, 'MANOEL VITORINO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0446, 'MANSIDÃO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0447, 'MARACÁS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0448, 'MARAGOGIPE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0449, 'MARAÚ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0450, 'MARCIONÍLIO SOUZA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0451, 'MASCOTE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0452, 'MATA DE SÃO JOÃO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0453, 'MATINA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0454, 'MEDEIROS NETO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0455, 'MIGUEL CALMON', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0456, 'MILAGRES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0457, 'MIRANGABA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0458, 'MIRANTE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0459, 'MONTE SANTO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0460, 'MORPARÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0461, 'MORRO DO CHAPÉU', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0462, 'MORTUGABA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0463, 'MUCUGÊ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0464, 'MUCURI', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0465, 'MULUNGU DO MORRO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0466, 'MUNDO NOVO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0467, 'MUNIZ FERREIRA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0468, 'MUQUÉM DE SÃO FRANCISCO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0469, 'MURITIBA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0470, 'MUTUÍPE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0471, 'NAZARÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0472, 'NILO PEÇANHA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0473, 'NORDESTINA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0474, 'NOVA CANAÃ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0475, 'NOVA FÁTIMA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0476, 'NOVA IBIÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0477, 'NOVA ITARANA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0478, 'NOVA REDENÇÃO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0479, 'NOVA SOURE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0480, 'NOVA VIÇOSA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0481, 'NOVO HORIZONTE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0482, 'NOVO TRIUNFO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0483, 'OLINDINA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0484, 'OLIVEIRA DOS BREJINHOS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0485, 'OURIÇANGAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0486, 'OUROLÂNDIA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0487, 'PALMAS DE MONTE ALTO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0488, 'PALMEIRAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0489, 'PARAMIRIM' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0490, 'PARATINGA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0491, 'PARIPIRANGA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0492, 'PAU BRASIL', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0493, 'PAULO AFONSO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0494, 'PÉ DE SERRA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0495, 'PEDRÃO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0496, 'PEDRO ALEXANDRE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0497, 'PIATÃ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0498, 'PILÃO ARCADO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0499, 'PINDAÍ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0500, 'PINDOBAÇU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0501, 'PINTADAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0502, 'PIRAÍ DO NORTE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0503, 'PIRIPÁ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0504, 'PIRITIBA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0505, 'PLANALTINO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0506, 'PLANALTO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0507, 'POÇÕES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0508, 'POJUCA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0509, 'PONTO NOVO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0510, 'PORTO SEGURO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0511, 'POTIRAGUÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0512, 'PRADO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0513, 'PRESIDENTE DUTRA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0514, 'PRESIDENTE JÂNIO QUADROS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0515, 'PRESIDENTE TANCREDO NEVES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0516, 'QUEIMADAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0517, 'QUIJINGUE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0518, 'QUIXABEIRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0519, 'RAFAEL JAMBEIRO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0520, 'REMANSO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0521, 'RETIROLÂNDIA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0522, 'RIACHÃO DAS NEVES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0523, 'RIACHÃO DO JACUÍPE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0524, 'RIACHO DE SANTANA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0525, 'RIBEIRA DO AMPARO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0526, 'RIBEIRA DO POMBAL', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0527, 'RIBEIRÃO DO LARGO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0528, 'RIO DE CONTAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0529, 'RIO DO ANTÔNIO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0530, 'RIO DO PIRES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0531, 'RIO REAL', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0532, 'RODELAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0533, 'RUY BARBOSA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0534, 'SALINAS DA MARGARIDA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0535, 'SALVADOR', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0536, 'SANTA BÁRBARA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0537, 'SANTA BRÍGIDA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0538, 'SANTA CRUZ CABRÁLIA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0539, 'SANTA CRUZ DA VITÓRIA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0540, 'SANTA INÊS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0541, 'SANTA LUZIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0542, 'SANTA MARIA DA VITÓRIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0543, 'SANTA RITA DE CÁSSIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0544, 'SANTA TERESINHA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0545, 'SANTALUZ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0546, 'SANTANA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0547, 'SANTANÓPOLIS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0548, 'SANTO AMARO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0549, 'SANTO ANTÔNIO DE JESUS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0550, 'SANTO ESTÊVÃO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0551, 'SÃO DESIDÉRIO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0552, 'SÃO DOMINGOS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0553, 'SÃO FELIPE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0554, 'SÃO FÉLIX' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0555, 'SÃO FÉLIX DO CORIBE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0556, 'SÃO FRANCISCO DO CONDE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0557, 'SÃO GABRIEL' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0558, 'SÃO GONÇALO DOS CAMPOS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0559, 'SÃO JOSÉ DA VITÓRIA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0560, 'SÃO JOSÉ DO JACUÍPE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0561, 'SÃO MIGUEL DAS MATAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0562, 'SÃO SEBASTIÃO DO PASSÉ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0563, 'SAPEAÇU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0564, 'SÁTIRO DIAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0565, 'SAUBARA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0566, 'SAÚDE', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0567, 'SEABRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0568, 'SEBASTIÃO LARANJEIRAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0569, 'SENHOR DO BONFIM' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0570, 'SENTO SÉ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0571, 'SERRA DO RAMALHO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0572, 'SERRA DOURADA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0573, 'SERRA PRETA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0574, 'SERRINHA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0575, 'SERROLÂNDIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0576, 'SIMÕES FILHO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0577, 'SÍTIO DO MATO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0578, 'SÍTIO DO QUINTO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0579, 'SOBRADINHO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0580, 'SOUTO SOARES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0581, 'TABOCAS DO BREJO VELHO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0582, 'TANHAÇU' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0583, 'TANQUE NOVO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0584, 'TANQUINHO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0585, 'TAPEROÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0586, 'TAPIRAMUTÁ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0587, 'TEIXEIRA DE FREITAS', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0588, 'TEODORO SAMPAIO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0589, 'TEOFILÂNDIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0590, 'TEOLÂNDIA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0591, 'TERRA NOVA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0592, 'TREMEDAL', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0593, 'TUCANO', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0594, 'UAUÁ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0595, 'UBAÍRA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0596, 'UBAITABA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0597, 'UBATÃ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0598, 'UIBAÍ', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0599, 'UMBURANAS' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0600, 'UNA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0601, 'URANDI', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0602, 'URUÇUCA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0603, 'UTINGA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0604, 'VALENÇA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0605, 'VALENTE' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0606, 'VÁRZEA DA ROÇA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0607, 'VÁRZEA DO POÇO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0608, 'VÁRZEA NOVA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0609, 'VARZEDO' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0610, 'VERA CRUZ' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0611, 'VEREDA', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0612, 'VITÓRIA DA CONQUISTA' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0613, 'WAGNER', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0614, 'WANDERLEY' , 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0615, 'WENCESLAU GUIMARÃES', 13);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0616, 'XIQUE-XIQUE' , 13);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0617, 'ABAIARA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0618, 'ACARAPÉ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0619, 'ACARAÚ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0620, 'ACOPIARA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0621, 'AIUABA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0622, 'ALCÂNTARAS', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0623, 'ALTANEIRA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0624, 'ALTO SANTO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0625, 'AMONTADA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0626, 'ANTONINA DO NORTE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0627, 'APUIARÉS', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0628, 'AQUIRAZ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0629, 'ARACATI' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0630, 'ARACOIABA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0631, 'ARARENDÁ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0632, 'ARARIPE' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0633, 'ARATUBA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0634, 'ARNEIROZ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0635, 'ASSARÉ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0636, 'AURORA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0637, 'BAIXIO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0638, 'BANABUIÚ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0639, 'BARBALHA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0640, 'BARREIRA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0641, 'BARRO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0642, 'BARROQUINHA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0643, 'BATURITÉ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0644, 'BEBERIBE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0645, 'BELA CRUZ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0646, 'BOA VIAGEM', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0647, 'BREJO SANTO' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0648, 'CAMOCIM' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0649, 'CAMPOS SALES', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0650, 'CANINDÉ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0651, 'CAPISTRANO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0652, 'CARIDADE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0653, 'CARIRÉ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0654, 'CARIRIAÇU' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0655, 'CARIÚS', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0656, 'CARNAUBAL' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0657, 'CASCAVEL', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0658, 'CATARINA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0659, 'CATUNDA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0660, 'CAUCAIA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0661, 'CEDRO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0662, 'CHAVAL', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0663, 'CHORÓ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0664, 'CHOROZINHO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0665, 'COREAÚ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0666, 'CRATEÚS' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0667, 'CRATO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0668, 'CROATÁ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0669, 'CRUZ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0670, 'DEPUTADO IRAPUAN PINHEIRO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0671, 'ERERÊ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0672, 'EUSÉBIO' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0673, 'FARIAS BRITO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0674, 'FORQUILHA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0675, 'FORTALEZA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0676, 'FORTIM', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0677, 'FRECHEIRINHA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0678, 'GENERAL SAMPAIO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0679, 'GRAÇA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0680, 'GRANJA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0681, 'GRANJEIRO' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0682, 'GROAÍRAS', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0683, 'GUAIÚBA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0684, 'GUARACIABA DO NORTE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0685, 'GUARAMIRANGA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0686, 'HIDROLÂNDIA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0687, 'HORIZONTE' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0688, 'IBARETAMA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0689, 'IBIAPINA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0690, 'IBICUITINGA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0691, 'ICAPUÍ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0692, 'ICÓ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0693, 'IGUATU', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0694, 'INDEPENDÊNCIA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0695, 'IPAPORANGA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0696, 'IPAUMIRIM' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0697, 'IPU', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0698, 'IPUEIRAS', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0699, 'IRACEMA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0700, 'IRAUÇUBA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0701, 'ITAIÇABA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0702, 'ITAITINGA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0703, 'ITAPAGÉ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0704, 'ITAPIPOCA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0705, 'ITAPIÚNA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0706, 'ITAREMA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0707, 'ITATIRA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0708, 'JAGUARETAMA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0709, 'JAGUARIBARA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0710, 'JAGUARIBE' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0711, 'JAGUARUANA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0712, 'JARDIM', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0713, 'JATI' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0714, 'JIJOCA DE JERICOACOARA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0715, 'JUAZEIRO DO NORTE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0716, 'JUCÁS', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0717, 'LAVRAS DA MANGABEIRA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0718, 'LIMOEIRO DO NORTE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0719, 'MADALENA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0720, 'MARACANAÚ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0721, 'MARANGUAPE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0722, 'MARCO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0723, 'MARTINÓPOLE' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0724, 'MASSAPÊ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0725, 'MAURITI' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0726, 'MERUOCA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0727, 'MILAGRES', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0728, 'MILHÃ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0729, 'MIRAÍMA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0730, 'MISSÃO VELHA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0731, 'MOMBAÇA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0732, 'MONSENHOR TABOSA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0733, 'MORADA NOVA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0734, 'MORAÚJO' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0735, 'MORRINHOS' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0736, 'MUCAMBO' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0737, 'MULUNGU' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0738, 'NOVA OLINDA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0739, 'NOVA RUSSAS' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0740, 'NOVO ORIENTE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0741, 'OCARA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0742, 'ORÓS' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0743, 'PACAJUS' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0744, 'PACATUBA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0745, 'PACOTI', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0746, 'PACUJÁ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0747, 'PALHANO' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0748, 'PALMÁCIA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0749, 'PARACURU', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0750, 'PARAIPABA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0751, 'PARAMBU' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0752, 'PARAMOTI', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0753, 'PEDRA BRANCA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0754, 'PENAFORTE' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0755, 'PENTECOSTE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0756, 'PEREIRO' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0757, 'PINDORETAMA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0758, 'PIQUET CARNEIRO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0759, 'PIRES FERREIRA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0760, 'PORANGA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0761, 'PORTEIRAS' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0762, 'POTENGI' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0763, 'POTIRETAMA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0764, 'QUITERIANÓPOLIS', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0765, 'QUIXADÁ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0766, 'QUIXELÔ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0767, 'QUIXERAMOBIM', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0768, 'QUIXERÉ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0769, 'REDENÇÃO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0770, 'RERIUTABA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0771, 'RUSSAS', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0772, 'SABOEIRO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0773, 'SALITRE' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0774, 'SANTA QUITÉRIA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0775, 'SANTANA DO ACARAÚ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0776, 'SANTANA DO CARIRI', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0777, 'SÃO BENEDITO', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0778, 'SÃO GONÇALO DO AMARANTE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0779, 'SÃO JOÃO DO JAGUARIBE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0780, 'SÃO LUÍS DO CURU' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0781, 'SENADOR POMPEU' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0782, 'SENADOR SÁ', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0783, 'SOBRAL', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0784, 'SOLONÓPOLE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0785, 'TABULEIRO DO NORTE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0786, 'TAMBORIL', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0787, 'TARRAFAS', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0788, 'TAUÁ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0789, 'TEJUÇUOCA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0790, 'TIANGUÁ' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0791, 'TRAIRI', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0792, 'TURURU', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0793, 'UBAJARA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0794, 'UMARI', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0795, 'UMIRIM', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0796, 'URUBURETAMA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0797, 'URUOCA', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0798, 'VARJOTA' , 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0799, 'VÁRZEA ALEGRE', 14);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0800, 'VIÇOSA DO CEARÁ', 14);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0801, 'BRASÍLIA', 01);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0802, 'AFONSO CLÁUDIO' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0803, 'ÁGUA DOCE DO NORTE', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0804, 'ÁGUIA BRANCA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0805, 'ALEGRE', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0806, 'ALFREDO CHAVES' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0807, 'ALTO RIO NOVO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0808, 'ANCHIETA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0809, 'APIACÁ', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0810, 'ARACRUZ' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0811, 'ATILIO VIVACQUA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0812, 'BAIXO GUANDU', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0813, 'BARRA DE SÃO FRANCISCO' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0814, 'BOA ESPERANÇA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0815, 'BOM JESUS DO NORTE', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0816, 'BREJETUBA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0817, 'CACHOEIRO DE ITAPEMIRIM', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0818, 'CARIACICA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0819, 'CASTELO' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0820, 'COLATINA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0821, 'CONCEIÇÃO DA BARRA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0822, 'CONCEIÇÃO DO CASTELO' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0823, 'DIVINO DE SÃO LOURENÇO' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0824, 'DOMINGOS MARTINS' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0825, 'DORES DO RIO PRETO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0826, 'ECOPORANGA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0827, 'FUNDÃO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0828, 'GUAÇUÍ', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0829, 'GUARAPARI' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0830, 'IBATIBA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0831, 'IBIRAÇU' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0832, 'IBITIRAMA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0833, 'ICONHA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0834, 'IRUPI', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0835, 'ITAGUAÇU', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0836, 'ITAPEMIRIM', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0837, 'ITARANA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0838, 'IÚNA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0839, 'JAGUARÉ' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0840, 'JERÔNIMO MONTEIRO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0841, 'JOÃO NEIVA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0842, 'LARANJA DA TERRA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0843, 'LINHARES', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0844, 'MANTENÓPOLIS', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0845, 'MARATAÍZES', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0846, 'MARECHAL FLORIANO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0847, 'MARILÂNDIA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0848, 'MIMOSO DO SUL', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0849, 'MONTANHA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0850, 'MUCURICI', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0851, 'MUNIZ FREIRE', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0852, 'MUQUI', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0853, 'NOVA VENÉCIA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0854, 'PANCAS', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0855, 'PEDRO CANÁRIO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0856, 'PINHEIROS' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0857, 'PIÚMA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0858, 'PONTO BELO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0859, 'PRESIDENTE KENNEDY', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0860, 'RIO BANANAL' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0861, 'RIO NOVO DO SUL', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0862, 'SANTA LEOPOLDINA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0863, 'SANTA MARIA DE JETIBÁ', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0864, 'SANTA TERESA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0865, 'SÃO DOMINGOS DO NORTE', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0866, 'SÃO GABRIEL DA PALHA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0867, 'SÃO JOSÉ DO CALÇADO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0868, 'SÃO MATEUS', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0869, 'SÃO ROQUE DO CANAÃ', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0870, 'SERRA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0871, 'SOORETAMA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0872, 'VARGEM ALTA' , 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0873, 'VENDA NOVA DO IMIGRANTE', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0874, 'VIANA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0875, 'VILA PAVÃO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0876, 'VILA VALÉRIO', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0877, 'VILA VELHA', 08);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0878, 'VITÓRIA' , 08);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0879, 'ABADIA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0880, 'ABADIÂNIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0881, 'ACREÚNA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0882, 'ADELÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0883, 'ÁGUA FRIA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0884, 'ÁGUA LIMPA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0885, 'ÁGUAS LINDAS DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0886, 'ALEXÂNIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0887, 'ALOÂNDIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0888, 'ALTO HORIZONTE' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0889, 'ALTO PARAÍSO DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0890, 'ALVORADA DO NORTE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0891, 'AMARALINA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0892, 'AMERICANO DO BRASIL', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0893, 'AMORINÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0894, 'ANÁPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0895, 'ANHANGUERA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0896, 'ANICUNS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0897, 'APARECIDA DE GOIÂNIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0898, 'APARECIDA DO RIO DOCE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0899, 'APORÉ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0900, 'ARAÇU', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0901, 'ARAGARÇAS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0902, 'ARAGOIÂNIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0903, 'ARAGUAPAZ' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0904, 'ARENÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0905, 'ARUANÃ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0906, 'AURILÂNDIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0907, 'AVELINÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0908, 'BALIZA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0909, 'BARRO ALTO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0910, 'BELA VISTA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0911, 'BOM JARDIM DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0912, 'BOM JESUS DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0913, 'BONFINÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0914, 'BONÓPOLIS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0915, 'BRAZABRANTES', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0916, 'BRITÂNIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0917, 'BURITI ALEGRE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0918, 'BURITI DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0919, 'BURITINÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0920, 'CABECEIRAS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0921, 'CACHOEIRA ALTA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0922, 'CACHOEIRA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0923, 'CACHOEIRA DOURADA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0924, 'CAÇU' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0925, 'CAIAPÔNIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0926, 'CALDAS NOVAS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0927, 'CALDAZINHA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0928, 'CAMPESTRE DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0929, 'CAMPINAÇU' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0930, 'CAMPINORTE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0931, 'CAMPO ALEGRE DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0932, 'CAMPOS BELOS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0933, 'CAMPOS VERDES', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0934, 'CARMO DO RIO VERDE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0935, 'CASTELÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0936, 'CATALÃO' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0937, 'CATURAÍ' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0938, 'CAVALCANTE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0939, 'CERES', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0940, 'CEZARINA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0941, 'CHAPADÃO DO CÉU', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0942, 'CIDADES OCIDENTAL', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0943, 'COCALZINHO DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0944, 'COLINAS DO SUL' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0945, 'CÓRREGO DO OURO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0946, 'CORUMBÁ DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0947, 'CORUMBAÍBA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0948, 'CRISTALINA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0949, 'CRISTIANÓPOLIS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0950, 'CRIXÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0951, 'CROMÍNIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0952, 'CUMARI', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0953, 'DAMIANÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0954, 'DAMOLÂNDIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0955, 'DAVINÓPOLIS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0956, 'DIORAMA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0957, 'DIVINÓPOLIS DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0958, 'DOVERLÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0959, 'EDEALINA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0960, 'EDÉIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0961, 'ESTRELA DO NORTE' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0962, 'FAINA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0963, 'FAZENDA NOVA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0964, 'FIRMINÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0965, 'FLORES DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0966, 'FORMOSA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0967, 'FORMOSO' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0968, 'GOIANÁPOLIS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0969, 'GOIANDIRA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0970, 'GOIANÉSIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0971, 'GOIÂNIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0972, 'GOIANIRA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0973, 'GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0974, 'GOIATUBA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0975, 'GOUVELÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0976, 'GUAPÓ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0977, 'GUARAÍTA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0978, 'GUARANI DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0979, 'GUARINOS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0980, 'HEITORAÍ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0981, 'HIDROLÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0982, 'HIDROLINA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0983, 'IACIARA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0984, 'INACIOLÂNDIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0985, 'INDIARA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0986, 'INHUMAS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0987, 'IPAMERI' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0988, 'IPORÁ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0989, 'ISRAELÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0990, 'ITABERAÍ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0991, 'ITAGUARI', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0992, 'ITAGUARU', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0993, 'ITAJÁ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0994, 'ITAPACI' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0995, 'ITAPIRAPUÃ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0996, 'ITAPURANGA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0997, 'ITARUMÃ' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0998, 'ITAUÇU', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (0999, 'ITUMBIARA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1000, 'IVOLÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1001, 'JANDAIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1002, 'JARAGUÁ' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1003, 'JATAÍ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1004, 'JAUPACI' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1005, 'JESÚPOLIS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1006, 'JOVIÂNIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1007, 'JUSSARA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1008, 'LEOPOLDO DE BULHÕES', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1009, 'LUZIÂNIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1010, 'MAIRIPOTABA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1011, 'MAMBAÍ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1012, 'MARA ROSA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1013, 'MARZAGÃO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1014, 'MATRINCHÃ' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1015, 'MAURILÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1016, 'MIMOSO DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1017, 'MINAÇU', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1018, 'MINEIROS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1019, 'MOIPORÁ' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1020, 'MONTE ALEGRE DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1021, 'MONTES CLAROS DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1022, 'MONTIVIDIU', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1023, 'MONTIVIDIU DO NORTE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1024, 'MORRINHOS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1025, 'MORRO AGUDO DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1026, 'MOSSÂMEDES', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1027, 'MOZARLÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1028, 'MUNDO NOVO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1029, 'MUTUNÓPOLIS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1030, 'NAZÁRIO' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1031, 'NERÓPOLIS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1032, 'NIQUELÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1033, 'NOVA AMÉRICA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1034, 'NOVA AURORA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1035, 'NOVA CRIXÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1036, 'NOVA GLÓRIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1037, 'NOVA IGUAÇU DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1038, 'NOVA ROMA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1039, 'NOVA VENEZA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1040, 'NOVO BRASIL' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1041, 'NOVO GAMA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1042, 'NOVO PLANALTO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1043, 'ORIZONA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1044, 'OURO VERDE DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1045, 'OUVIDOR' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1046, 'PADRE BERNARDO' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1047, 'PALESTINA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1048, 'PALMEIRAS DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1049, 'PALMELO' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1050, 'PALMINÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1051, 'PANAMÁ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1052, 'PARANAIGUARA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1053, 'PARAÚNA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1054, 'PEROLÂNDIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1055, 'PETROLINA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1056, 'PILAR DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1057, 'PIRACANJUBA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1058, 'PIRANHAS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1059, 'PIRENÓPOLIS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1060, 'PIRES DO RIO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1061, 'PLANALTINA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1062, 'PONTALINA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1063, 'PORANGATU' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1064, 'PORTEIRÃO' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1065, 'PORTELÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1066, 'POSSE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1067, 'PROFESSOR JAMIL', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1068, 'QUIRINÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1069, 'RIALMA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1070, 'RIANÁPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1071, 'RIO QUENTE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1072, 'RIO VERDE' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1073, 'RUBIATABA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1074, 'SANCLERLÂNDIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1075, 'SANTA BÁRBARA DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1076, 'SANTA CRUZ DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1077, 'SANTA FÉ DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1078, 'SANTA HELENA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1079, 'SANTA ISABEL', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1080, 'SANTA RITA DO ARAGUAIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1081, 'SANTA RITA DO NOVO DESTINO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1082, 'SANTA ROSA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1083, 'SANTA TEREZA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1084, 'SANTA TEREZINHA DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1085, 'SANTO ANTÔNIO DA BARRA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1086, 'SANTO ANTÔNIO DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1087, 'SANTO ANTÔNIO DO DESCOBERTO' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1088, 'SÃO DOMINGOS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1089, 'SÃO FRANCISCO DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1090, 'SÃO JOÃO D`ALIANÇA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1091, 'SÃO JOÃO DA PARAÚNA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1092, 'SÃO LUÍS DE MONTES BELOS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1093, 'SÃO LUÍZ DO NORTE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1094, 'SÃO MIGUEL DO ARAGUAIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1095, 'SÃO MIGUEL DO PASSA QUATRO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1096, 'SÃO PATRÍCIO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1097, 'SÃO SIMÃO' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1098, 'SENADOR CANEDO' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1099, 'SERRANÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1100, 'SILVÂNIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1101, 'SIMOLÂNDIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1102, 'SÍTIO D`ABADIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1103, 'TAQUARAL DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1104, 'TERESINA DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1105, 'TEREZÓPOLIS DE GOIÁS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1106, 'TRÊS RANCHOS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1107, 'TRINDADE', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1108, 'TROMBAS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1109, 'TURVÂNIA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1110, 'TURVELÂNDIA' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1111, 'UIRAPURU', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1112, 'URUAÇU', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1113, 'URUANA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1114, 'URUTAÍ', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1115, 'VALPARAÍSO DE GOIÁS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1116, 'VARJÃO', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1117, 'VIANÓPOLIS', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1118, 'VICENTINÓPOLIS' , 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1119, 'VILA BOA', 04);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1120, 'VILA PROPÍCIO', 04);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1121, 'AÇAILÂNDIA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1122, 'AFONSO CUNHA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1123, 'ÁGUA DOCE DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1124, 'ALCÂNTARA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1125, 'ALDEIAS ALTAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1126, 'ALTAMIRA DO MARANHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1127, 'ALTO ALEGRE DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1128, 'ALTO ALEGRE DO PINDARÉ' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1129, 'ALTO PARNAÍBA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1130, 'AMAPÁ DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1131, 'AMARANTE DO MARANHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1132, 'ANAJATUBA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1133, 'ANAPURUS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1134, 'APICUM-AÇU', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1135, 'ARAGUANÃ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1136, 'ARAIOSES', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1137, 'ARAME', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1138, 'ARARI', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1139, 'AXIXÁ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1140, 'BACABAL' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1141, 'BACABEIRA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1142, 'BACURI', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1143, 'BACURITUBA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1144, 'BALSAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1145, 'BARÃO DE GRAJAÚ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1146, 'BARRA DO CORDA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1147, 'BARREIRINHAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1148, 'BELA VISTA DO MARANHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1149, 'BELÁGUA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1150, 'BENEDITO LEITE' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1151, 'BEQUIMÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1152, 'BERNARDO DO MEARIM', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1153, 'BOA VISTA DO GURUPI', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1154, 'BOM JARDIM', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1155, 'BOM JESUS DAS SELVAS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1156, 'BOM LUGAR' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1157, 'BREJO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1158, 'BREJO DE AREIA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1159, 'BURITI', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1160, 'BURITI BRAVO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1161, 'BURITICUPU', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1162, 'BURITIRANA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1163, 'CACHOEIRA GRANDE' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1164, 'CAJAPIÓ' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1165, 'CAJARI', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1166, 'CAMPESTRE DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1167, 'CÂNDIDO MENDES' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1168, 'CANTANHEDE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1169, 'CAPINZAL DO NORTE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1170, 'CAROLINA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1171, 'CARUTAPERA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1172, 'CAXIAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1173, 'CEDRAL', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1174, 'CENTRAL DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1175, 'CENTRO DO GUILHERME', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1176, 'CENTRO NOVO DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1177, 'CHAPADINHA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1178, 'CIDELÂNDIA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1179, 'CODÓ' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1180, 'COELHO NETO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1181, 'COLINAS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1182, 'CONCEIÇÃO DO LAGO-AÇU', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1183, 'COROATÁ' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1184, 'CURURUPU', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1185, 'DAVINÓPOLIS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1186, 'DOM PEDRO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1187, 'DUQUE BACELAR', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1188, 'ESPERANTINÓPOLIS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1189, 'ESTREITO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1190, 'FEIRA NOVA DO MARANHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1191, 'FERNANDO FALCÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1192, 'FORMOSA DA SERRA NEGRA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1193, 'FORTALEZA DOS NOGUEIRAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1194, 'FORTUNA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1195, 'GODOFREDO VIANA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1196, 'GONÇALVES DIAS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1197, 'GOVERNADOR ARCHER', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1198, 'GOVERNADOR EDISON LOBÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1199, 'GOVERNADOR EUGÊNIO BARROS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1200, 'GOVERNADOR LUIZ ROCHA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1201, 'GOVERNADOR NEWTON BELLO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1202, 'GOVERNADOR NUNES FREIRE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1203, 'GRAÇA ARANHA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1204, 'GRAJAÚ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1205, 'GUIMARÃES' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1206, 'HUMBERTO DE CAMPOS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1207, 'ICATU', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1208, 'IGARAPÉ DO MEIO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1209, 'IGARAPÉ GRANDE' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1210, 'IMPERATRIZ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1211, 'ITAIPAVA DO GRAJAÚ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1212, 'ITAPECURU MIRIM', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1213, 'ITINGA DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1214, 'JATOBÁ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1215, 'JENIPAPO DOS VIEIRAS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1216, 'JOÃO LISBOA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1217, 'JOSELÂNDIA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1218, 'JUNCO DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1219, 'LAGO DA PEDRA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1220, 'LAGO DO JUNCO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1221, 'LAGO DOS RODRIGUES', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1222, 'LAGO VERDE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1223, 'LAGOA DO MATO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1224, 'LAGOA GRANDE DO MARANHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1225, 'LAJEADO NOVO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1226, 'LIMA CAMPOS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1227, 'LORETO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1228, 'LUÍS DOMINGUES' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1229, 'MAGALHÃES DE ALMEIDA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1230, 'MARACAÇUMÉ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1231, 'MARAJÁ DO SENA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1232, 'MARANHÃOZINHO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1233, 'MATA ROMA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1234, 'MATINHA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1235, 'MATÕES', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1236, 'MATÕES DO NORTE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1237, 'MILAGRES DO MARANHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1238, 'MIRADOR' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1239, 'MIRANDA DO NORTE' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1240, 'MIRINZAL', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1241, 'MONÇÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1242, 'MONTES ALTOS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1243, 'MORROS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1244, 'NINA RODRIGUES' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1245, 'NOVA COLINAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1246, 'NOVA IORQUE' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1247, 'NOVA OLINDA DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1248, 'OLHO D`ÁGUA DAS CUNHÃS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1249, 'OLINDA NOVA DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1250, 'PAÇO DO LUMIAR' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1251, 'PALMEIRÂNDIA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1252, 'PARAIBANO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1253, 'PARNARAMA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1254, 'PASSAGEM FRANCA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1255, 'PASTOS BONS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1256, 'PAULINO NEVES', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1257, 'PAULO RAMOS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1258, 'PEDREIRAS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1259, 'PEDRO DO ROSÁRIO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1260, 'PENALVA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1261, 'PERI MIRIM', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1262, 'PERITORÓ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1263, 'PINDARÉ-MIRIM', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1264, 'PINHEIRO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1265, 'PIO XII' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1266, 'PIRAPEMAS' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1267, 'POÇÃO DE PEDRAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1268, 'PORTO FRANCO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1269, 'PORTO RICO DO MARANHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1270, 'PRESIDENTE DUTRA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1271, 'PRESIDENTE JUSCELINO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1272, 'PRESIDENTE MÉDICI', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1273, 'PRESIDENTE SARNEY', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1274, 'PRESIDENTE VARGAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1275, 'PRIMEIRA CRUZ', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1276, 'RAPOSA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1277, 'RIACHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1278, 'RIBAMAR FIQUENE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1279, 'ROSÁRIO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1280, 'SAMBAÍBA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1281, 'SANTA FILOMENA DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1282, 'SANTA HELENA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1283, 'SANTA INÊS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1284, 'SANTA LUZIA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1285, 'SANTA LUZIA DO PARUÁ' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1286, 'SANTA QUITÉRIA DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1287, 'SANTA RITA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1288, 'SANTANA DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1289, 'SANTO AMARO DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1290, 'SANTO ANTÔNIO DOS LOPES', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1291, 'SÃO BENEDITO DO RIO PRETO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1292, 'SÃO BENTO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1293, 'SÃO BERNARDO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1294, 'SÃO DOMINGOS DO AZEITÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1295, 'SÃO DOMINGOS DO MARANHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1296, 'SÃO FÉLIX DE BALSAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1297, 'SÃO FRANCISCO DO BREJÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1298, 'SÃO FRANCISCO DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1299, 'SÃO JOÃO BATISTA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1300, 'SÃO JOÃO DO CARÚ' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1301, 'SÃO JOÃO DO PARAÍSO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1302, 'SÃO JOÃO DO SOTER', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1303, 'SÃO JOÃO DOS PATOS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1304, 'SÃO JOSÉ DE RIBAMAR', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1305, 'SÃO JOSÉ DOS BASÍLIOS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1306, 'SÃO LUÍS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1307, 'SÃO LUÍS GONZAGA DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1308, 'SÃO MATEUS DO MARANHÃO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1309, 'SÃO PEDRO DA ÁGUA BRANCA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1310, 'SÃO PEDRO DOS CRENTES', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1311, 'SÃO RAIMUNDO DAS MANGABEIRAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1312, 'SÃO RAIMUNDO DO DOCA BEZERRA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1313, 'SÃO ROBERTO' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1314, 'SÃO VICENTE FERRER', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1315, 'SATUBINHA' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1316, 'SENADOR ALEXANDRE COSTA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1317, 'SENADOR LA ROCQUE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1318, 'SERRANO DO MARANHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1319, 'SÍTIO NOVO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1320, 'SUCUPIRA DO NORTE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1321, 'SUCUPIRA DO RIACHÃO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1322, 'TASSO FRAGOSO', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1323, 'TIMBIRAS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1324, 'TIMON', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1325, 'TRIZIDELA DO VALE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1326, 'TUFILÂNDIA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1327, 'TUNTUM', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1328, 'TURIAÇU' , 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1329, 'TURILÂNDIA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1330, 'TUTÓIA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1331, 'URBANO SANTOS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1332, 'VARGEM GRANDE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1333, 'VIANA', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1334, 'VILA NOVA DOS MARTÍRIOS', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1335, 'VITÓRIA DO MEARIM', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1336, 'VITORINO FREIRE', 15);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1337, 'ZÉ DOCA' , 15);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1338, 'ACORIZAL', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1339, 'ÁGUA BOA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1340, 'ALTA FLORESTA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1341, 'ALTO ARAGUAIA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1342, 'ALTO BOA VISTA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1343, 'ALTO GARÇAS' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1344, 'ALTO PARAGUAI', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1345, 'ALTO TAQUARI', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1346, 'APIACÁS' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1347, 'ARAGUAIANA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1348, 'ARAGUAINHA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1349, 'ARAPUTANGA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1350, 'ARENÁPOLIS', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1351, 'ARIPUANÃ', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1352, 'BARÃO DE MELGAÇO' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1353, 'BARRA DO BUGRES', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1354, 'BARRA DO GARÇAS', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1355, 'BRASNORTE' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1356, 'CÁCERES' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1357, 'CAMPINÁPOLIS', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1358, 'CAMPO NOVO DO PARECIS', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1359, 'CAMPO VERDE' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1360, 'CAMPOS DE JÚLIO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1361, 'CANABRAVA DO NORTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1362, 'CANARANA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1363, 'CARLINDA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1364, 'CASTANHEIRA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1365, 'CHAPADA DOS GUIMARÃES', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1366, 'CLÁUDIA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1367, 'COCALINHO' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1368, 'COLÍDER' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1369, 'COMODORO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1370, 'CONFRESA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1371, 'COTRIGUAÇU', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1372, 'CUIABÁ', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1373, 'DENISE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1374, 'DIAMANTINO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1375, 'DOM AQUINO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1376, 'FELIZ NATAL' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1377, 'FIGUEIRÓPOLIS D`OESTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1378, 'GAÚCHA DO NORTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1379, 'GENERAL CARNEIRO' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1380, 'GLÓRIA D`OESTE' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1381, 'GUARANTÃ DO NORTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1382, 'GUIRATINGA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1383, 'INDIAVAÍ', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1384, 'ITAÚBA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1385, 'ITIQUIRA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1386, 'JACIARA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1387, 'JANGADA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1388, 'JAURU', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1389, 'JUARA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1390, 'JUÍNA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1391, 'JURUENA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1392, 'JUSCIMEIRA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1393, 'LAMBARI D`OESTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1394, 'LUCAS DO RIO VERDE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1395, 'LUCIÁRA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1396, 'MARCELÂNDIA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1397, 'MATUPÁ', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1398, 'MIRASSOL D`OESTE' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1399, 'NOBRES', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1400, 'NORTELÂNDIA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1401, 'NOSSA SENHORA DO LIVRAMENTO' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1402, 'NOVA BANDEIRANTES', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1403, 'NOVA BRASILÂNDIA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1404, 'NOVA CANAÃ DO NORTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1405, 'NOVA GUARITA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1406, 'NOVA LACERDA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1407, 'NOVA MARILÂNDIA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1408, 'NOVA MARINGÁ', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1409, 'NOVA MONTE VERDE' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1410, 'NOVA MUTUM', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1411, 'NOVA OLÍMPIA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1412, 'NOVA UBIRATÃ', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1413, 'NOVA XAVANTINA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1414, 'NOVO HORIZONTE DO NORTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1415, 'NOVO MUNDO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1416, 'NOVO SÃO JOAQUIM' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1417, 'PARANAÍTA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1418, 'PARANATINGA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1419, 'PEDRA PRETA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1420, 'PEIXOTO DE AZEVEDO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1421, 'PLANALTO DA SERRA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1422, 'POCONÉ', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1423, 'PONTAL DO ARAGUAIA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1424, 'PONTE BRANCA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1425, 'PONTES E LACERDA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1426, 'PORTO ALEGRE DO NORTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1427, 'PORTO DOS GAÚCHOS', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1428, 'PORTO ESPERIDIÃO' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1429, 'PORTO ESTRELA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1430, 'POXORÉO' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1431, 'PRIMAVERA DO LESTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1432, 'QUERÊNCIA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1433, 'RESERVA DO CABAÇAL', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1434, 'RIBEIRÃO CASCALHEIRA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1435, 'RIBEIRÃOZINHO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1436, 'RIO BRANCO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1437, 'RONDONÓPOLIS', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1438, 'ROSÁRIO OESTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1439, 'SALTO DO CÉU', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1440, 'SANTA CARMEM', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1441, 'SANTA TEREZINHA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1442, 'SANTO AFONSO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1443, 'SANTO ANTÔNIO DO LEVERGER', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1444, 'SÃO FÉLIX DO ARAGUAIA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1445, 'SÃO JOSÉ DO POVO' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1446, 'SÃO JOSÉ DO RIO CLARO', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1447, 'SÃO JOSÉ DO XINGU', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1448, 'SÃO JOSÉ DOS QUATRO MARCOS', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1449, 'SÃO PEDRO DA CIPA', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1450, 'SAPEZAL' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1451, 'SINOP', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1452, 'SORRISO' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1453, 'TABAPORÃ', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1454, 'TANGARÁ DA SERRA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1455, 'TAPURAH' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1456, 'TERRA NOVA DO NORTE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1457, 'TESOURO' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1458, 'TORIXORÉU' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1459, 'UNIÃO DO SUL', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1460, 'VÁRZEA GRANDE', 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1461, 'VERA' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1462, 'VILA BELA DA SANTÍSSIMA TRINDADE' , 16);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1463, 'VILA RICA' , 16);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1464, 'ÁGUA CLARA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1465, 'ALCINÓPOLIS' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1466, 'AMAMBAÍ' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1467, 'ANASTÁCIO' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1468, 'ANAURILÂNDIA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1469, 'ANGÉLICA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1470, 'ANTÔNIO JOÃO', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1471, 'APARECIDA DO TABOADO' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1472, 'AQUIDAUANA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1473, 'ARAL MOREIRA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1474, 'BANDEIRANTES', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1475, 'BATAGUASSU', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1476, 'BATAIPORÃ' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1477, 'BELA VISTA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1478, 'BODOQUENA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1479, 'BONITO', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1480, 'BRASILÂNDIA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1481, 'CAARAPÓ' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1482, 'CAMAPUÃ' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1483, 'CAMPO GRANDE', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1484, 'CARACOL' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1485, 'CASSILÂNDIA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1486, 'CHAPADÃO DO SUL', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1487, 'CORGUINHO' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1488, 'CORONEL SAPUCAIA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1489, 'CORUMBÁ' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1490, 'COSTA RICA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1491, 'COXIM', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1492, 'DEODÁPOLIS', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1493, 'DOIS IRMÃOS DO BURITI', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1494, 'DOURADINA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1495, 'DOURADOS', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1496, 'ELDORADO', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1497, 'FÁTIMA DO SUL', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1498, 'GLÓRIA DE DOURADOS', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1499, 'GUIA LOPES DA LAGUNA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1500, 'IGUATEMI', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1501, 'INOCÊNCIA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1502, 'ITAPORÃ' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1503, 'ITAQUIRAÍ' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1504, 'IVINHEMA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1505, 'JAPORÃ', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1506, 'JARAGUARI' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1507, 'JARDIM', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1508, 'JATEÍ', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1509, 'JUTI' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1510, 'LADÁRIO' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1511, 'LAGUNA CARAPÃ', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1512, 'MARACAJU', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1513, 'MIRANDA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1514, 'MUNDO NOVO', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1515, 'NAVIRAÍ' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1516, 'NIOAQUE' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1517, 'NOVA ALVORADA DO SUL' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1518, 'NOVA ANDRADINA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1519, 'NOVO HORIZONTE DO SUL', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1520, 'PARANAÍBA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1521, 'PARANHOS', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1522, 'PEDRO GOMES' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1523, 'PONTA PORÃ', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1524, 'PORTO MURTINHO' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1525, 'RIBAS DO RIO PARDO', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1526, 'RIO BRILHANTE', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1527, 'RIO NEGRO' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1528, 'RIO VERDE DE MATO GROSSO' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1529, 'ROCHEDO' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1530, 'SANTA RITA DO PARDO', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1531, 'SÃO GABRIEL DO OESTE' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1532, 'SELVÍRIA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1533, 'SETE QUEDAS' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1534, 'SIDROLÂNDIA' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1535, 'SONORA', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1536, 'TACURU', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1537, 'TAQUARUSSU', 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1538, 'TERENOS' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1539, 'TRÊS LAGOAS' , 17);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1540, 'VICENTINA' , 17);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1541, 'ABADIA DOS DOURADOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1542, 'ABAETÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1543, 'ABRE CAMPO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1544, 'ACAIACA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1545, 'AÇUCENA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1546, 'ÁGUA BOA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1547, 'ÁGUA COMPRIDA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1548, 'AGUANIL' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1549, 'ÁGUAS FORMOSAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1550, 'ÁGUAS VERMELHAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1551, 'AIMORÉS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1552, 'AIURUOCA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1553, 'ALAGOA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1554, 'ALBERTINA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1555, 'ALÉM PARAÍBA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1556, 'ALFENAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1557, 'ALFREDO VASCONCELOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1558, 'ALMENARA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1559, 'ALPERCATA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1560, 'ALPINÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1561, 'ALTEROSA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1562, 'ALTO CAPARAÓ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1563, 'ALTO JEQUITIBÁ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1564, 'ALTO RIO DOCE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1565, 'ALVARENGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1566, 'ALVINÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1567, 'ALVORADA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1568, 'AMPARO DO SERRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1569, 'ANDRADAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1570, 'ANDRELÂNDIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1571, 'ANGELÂNDIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1572, 'ANTÔNIO CARLOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1573, 'ANTÔNIO DIAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1574, 'ANTÔNIO PRADO DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1575, 'ARAÇAÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1576, 'ARACITABA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1577, 'ARAÇUAÍ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1578, 'ARAGUARI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1579, 'ARANTINA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1580, 'ARAPONGA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1581, 'ARAPORÃ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1582, 'ARAPUÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1583, 'ARAÚJOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1584, 'ARAXÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1585, 'ARCEBURGO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1586, 'ARCOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1587, 'AREADO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1588, 'ARGIRITA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1589, 'ARICANDUVA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1590, 'ARINOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1591, 'ASTOLFO DUTRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1592, 'ATALÉIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1593, 'AUGUSTO DE LIMA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1594, 'BAEPENDI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1595, 'BALDIM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1596, 'BAMBUÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1597, 'BANDEIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1598, 'BANDEIRA DO SUL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1599, 'BARÃO DE COCAIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1600, 'BARÃO DE MONTE ALTO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1601, 'BARBACENA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1602, 'BARRA LONGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1603, 'BARROSO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1604, 'BELA VISTA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1605, 'BELMIRO BRAGA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1606, 'BELO HORIZONTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1607, 'BELO ORIENTE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1608, 'BELO VALE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1609, 'BERILO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1610, 'BERIZAL' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1611, 'BERTÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1612, 'BETIM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1613, 'BIAS FORTES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1614, 'BICAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1615, 'BIQUINHAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1616, 'BOA ESPERANÇA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1617, 'BOCAINA DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1618, 'BOCAIÚVA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1619, 'BOM DESPACHO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1620, 'BOM JARDIM DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1621, 'BOM JESUS DA PENHA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1622, 'BOM JESUS DO AMPARO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1623, 'BOM JESUS DO GALHO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1624, 'BOM REPOUSO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1625, 'BOM SUCESSO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1626, 'BONFIM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1627, 'BONFINÓPOLIS DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1628, 'BONITO DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1629, 'BORDA DA MATA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1630, 'BOTELHOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1631, 'BOTUMIRIM' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1632, 'BRÁS PIRES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1633, 'BRASILÂNDIA DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1634, 'BRASÍLIA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1635, 'BRASÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1636, 'BRAÚNAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1637, 'BRUMADINHO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1638, 'BUENO BRANDÃO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1639, 'BUENÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1640, 'BUGRE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1641, 'BURITIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1642, 'BURITIZEIRO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1643, 'CABECEIRA GRANDE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1644, 'CABO VERDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1645, 'CACHOEIRA DA PRATA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1646, 'CACHOEIRA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1647, 'CACHOEIRA DE PAJEÚ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1648, 'CACHOEIRA DOURADA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1649, 'CAETANÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1650, 'CAETÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1651, 'CAIANA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1652, 'CAJURI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1653, 'CALDAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1654, 'CAMACHO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1655, 'CAMANDUCAIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1656, 'CAMBUÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1657, 'CAMBUQUIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1658, 'CAMPANÁRIO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1659, 'CAMPANHA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1660, 'CAMPESTRE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1661, 'CAMPINA VERDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1662, 'CAMPO AZUL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1663, 'CAMPO BELO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1664, 'CAMPO DO MEIO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1665, 'CAMPO FLORIDO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1666, 'CAMPOS ALTOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1667, 'CAMPOS GERAIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1668, 'CANA VERDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1669, 'CANAÃ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1670, 'CANÁPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1671, 'CANDEIAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1672, 'CANTAGALO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1673, 'CAPARAÓ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1674, 'CAPELA NOVA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1675, 'CAPELINHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1676, 'CAPETINGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1677, 'CAPIM BRANCO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1678, 'CAPINÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1679, 'CAPITÃO ANDRADE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1680, 'CAPITÃO ENÉAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1681, 'CAPITÓLIO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1682, 'CAPUTIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1683, 'CARAÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1684, 'CARANAÍBA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1685, 'CARANDAÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1686, 'CARANGOLA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1687, 'CARATINGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1688, 'CARBONITA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1689, 'CAREAÇU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1690, 'CARLOS CHAGAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1691, 'CARMÉSIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1692, 'CARMO DA CACHOEIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1693, 'CARMO DA MATA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1694, 'CARMO DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1695, 'CARMO DO CAJURU', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1696, 'CARMO DO PARANAÍBA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1697, 'CARMO DO RIO CLARO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1698, 'CARMÓPOLIS DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1699, 'CARNEIRINHO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1700, 'CARRANCAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1701, 'CARVALHÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1702, 'CARVALHOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1703, 'CASA GRANDE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1704, 'CASCALHO RICO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1705, 'CÁSSIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1706, 'CATAGUASES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1707, 'CATAS ALTAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1708, 'CATAS ALTAS DA NORUEGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1709, 'CATUJI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1710, 'CATUTI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1711, 'CAXAMBU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1712, 'CEDRO DO ABAETÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1713, 'CENTRAL DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1714, 'CENTRALINA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1715, 'CHÁCARA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1716, 'CHALÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1717, 'CHAPADA DO NORTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1718, 'CHAPADA GAÚCHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1719, 'CHIADOR' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1720, 'CIPOTÂNEA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1721, 'CLARAVAL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1722, 'CLARO DOS POÇÕES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1723, 'CLÁUDIO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1724, 'COIMBRA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1725, 'COLUNA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1726, 'COMENDADOR GOMES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1727, 'COMERCINHO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1728, 'CONCEIÇÃO DA APARECIDA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1729, 'CONCEIÇÃO DA BARRA DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1730, 'CONCEIÇÃO DAS ALAGOAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1731, 'CONCEIÇÃO DAS PEDRAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1732, 'CONCEIÇÃO DE IPANEMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1733, 'CONCEIÇÃO DO MATO DENTRO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1734, 'CONCEIÇÃO DO PARÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1735, 'CONCEIÇÃO DO RIO VERDE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1736, 'CONCEIÇÃO DOS OUROS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1737, 'CÔNEGO MARINHO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1738, 'CONFINS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1739, 'CONGONHAL' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1740, 'CONGONHAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1741, 'CONGONHAS DO NORTE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1742, 'CONQUISTA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1743, 'CONSELHEIRO LAFAIETE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1744, 'CONSELHEIRO PENA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1745, 'CONSOLAÇÃO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1746, 'CONTAGEM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1747, 'COQUEIRAL' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1748, 'CORAÇÃO DE JESUS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1749, 'CORDISBURGO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1750, 'CORDISLÂNDIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1751, 'CORINTO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1752, 'COROACI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1753, 'COROMANDEL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1754, 'CORONEL FABRICIANO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1755, 'CORONEL MURTA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1756, 'CORONEL PACHECO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1757, 'CORONEL XAVIER CHAVES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1758, 'CÓRREGO DANTA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1759, 'CÓRREGO DO BOM JESUS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1760, 'CÓRREGO FUNDO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1761, 'CÓRREGO NOVO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1762, 'COUTO DE MAGALHÃES DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1763, 'CRISÓLITA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1764, 'CRISTAIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1765, 'CRISTÁLIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1766, 'CRISTIANO OTONI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1767, 'CRISTINA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1768, 'CRUCILÂNDIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1769, 'CRUZEIRO DA FORTALEZA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1770, 'CRUZÍLIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1771, 'CUPARAQUE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1772, 'CURRAL DE DENTRO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1773, 'CURVELO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1774, 'DATAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1775, 'DELFIM MOREIRA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1776, 'DELFINÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1777, 'DELTA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1778, 'DESCOBERTO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1779, 'DESTERRO DE ENTRE RIOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1780, 'DESTERRO DO MELO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1781, 'DIAMANTINA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1782, 'DIOGO DE VASCONCELOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1783, 'DIONÍSIO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1784, 'DIVINÉSIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1785, 'DIVINO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1786, 'DIVINO DAS LARANJEIRAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1787, 'DIVINOLÂNDIA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1788, 'DIVINÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1789, 'DIVISA ALEGRE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1790, 'DIVISA NOVA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1791, 'DIVISÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1792, 'DOM BOSCO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1793, 'DOM CAVATI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1794, 'DOM JOAQUIM' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1795, 'DOM SILVÉRIO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1796, 'DOM VIÇOSO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1797, 'DONA EUSÉBIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1798, 'DORES DE CAMPOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1799, 'DORES DE GUANHÃES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1800, 'DORES DO INDAIÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1801, 'DORES DO TURVO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1802, 'DORESÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1803, 'DOURADOQUARA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1804, 'DURANDÉ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1805, 'ELÓI MENDES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1806, 'ENGENHEIRO CALDAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1807, 'ENGENHEIRO NAVARRO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1808, 'ENTRE FOLHAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1809, 'ENTRE RIOS DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1810, 'ERVÁLIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1811, 'ESMERALDAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1812, 'ESPERA FELIZ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1813, 'ESPINOSA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1814, 'ESPÍRITO SANTO DO DOURADO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1815, 'ESTIVA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1816, 'ESTRELA DALVA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1817, 'ESTRELA DO INDAIÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1818, 'ESTRELA DO SUL' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1819, 'EUGENÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1820, 'EWBANK DA CÂMARA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1821, 'EXTREMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1822, 'FAMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1823, 'FARIA LEMOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1824, 'FELÍCIO DOS SANTOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1825, 'FELISBURGO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1826, 'FELIXLÂNDIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1827, 'FERNANDES TOURINHO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1828, 'FERROS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1829, 'FERVEDOURO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1830, 'FLORESTAL' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1831, 'FORMIGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1832, 'FORMOSO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1833, 'FORTALEZA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1834, 'FORTUNA DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1835, 'FRANCISCO BADARÓ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1836, 'FRANCISCO DUMONT' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1837, 'FRANCISCO SÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1838, 'FRANCISCÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1839, 'FREI GASPAR' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1840, 'FREI INOCÊNCIO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1841, 'FREI LAGONEGRO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1842, 'FRONTEIRA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1843, 'FRONTEIRA DOS VALES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1844, 'FRUTA DE LEITE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1845, 'FRUTAL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1846, 'FUNILÂNDIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1847, 'GALILÉIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1848, 'GAMELEIRAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1849, 'GLAUCILÂNDIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1850, 'GOIABEIRA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1851, 'GOIANÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1852, 'GONÇALVES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1853, 'GONZAGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1854, 'GOUVEIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1855, 'GOVERNADOR VALADARES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1856, 'GRÃO MOGOL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1857, 'GRUPIARA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1858, 'GUANHÃES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1859, 'GUAPÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1860, 'GUARACIABA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1861, 'GUARACIAMA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1862, 'GUARANÉSIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1863, 'GUARANI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1864, 'GUARARÁ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1865, 'GUARDA-MOR', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1866, 'GUAXUPÉ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1867, 'GUIDOVAL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1868, 'GUIMARÂNIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1869, 'GUIRICEMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1870, 'GURINHATÃ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1871, 'HELIODORA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1872, 'IAPU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1873, 'IBERTIOGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1874, 'IBIÁ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1875, 'IBIAÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1876, 'IBIRACATU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1877, 'IBIRACI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1878, 'IBIRITÉ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1879, 'IBITIÚRA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1880, 'IBITURUNA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1881, 'ICARAÍ DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1882, 'IGARAPÉ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1883, 'IGARATINGA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1884, 'IGUATAMA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1885, 'IJACI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1886, 'ILICÍNEA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1887, 'IMBÉ DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1888, 'INCONFIDENTES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1889, 'INDAIABIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1890, 'INDIANÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1891, 'INGAÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1892, 'INHAPIM' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1893, 'INHAÚMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1894, 'INIMUTABA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1895, 'IPABA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1896, 'IPANEMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1897, 'IPATINGA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1898, 'IPIAÇU', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1899, 'IPUIÚNA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1900, 'IRAÍ DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1901, 'ITABIRA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1902, 'ITABIRINHA DE MANTENA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1903, 'ITABIRITO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1904, 'ITACAMBIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1905, 'ITACARAMBI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1906, 'ITAGUARA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1907, 'ITAIPÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1908, 'ITAJUBÁ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1909, 'ITAMARANDIBA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1910, 'ITAMARATI DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1911, 'ITAMBACURI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1912, 'ITAMBÉ DO MATO DENTRO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1913, 'ITAMOGI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1914, 'ITAMONTE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1915, 'ITANHANDU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1916, 'ITANHOMI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1917, 'ITAOBIM' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1918, 'ITAPAGIPE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1919, 'ITAPECERICA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1920, 'ITAPEVA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1921, 'ITATIAIUÇU', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1922, 'ITAÚ DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1923, 'ITAÚNA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1924, 'ITAVERAVA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1925, 'ITINGA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1926, 'ITUETA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1927, 'ITUIUTABA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1928, 'ITUMIRIM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1929, 'ITURAMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1930, 'ITUTINGA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1931, 'JABOTICATUBAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1932, 'JACINTO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1933, 'JACUÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1934, 'JACUTINGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1935, 'JAGUARAÇU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1936, 'JAÍBA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1937, 'JAMPRUCA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1938, 'JANAÚBA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1939, 'JANUÁRIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1940, 'JAPARAÍBA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1941, 'JAPONVAR', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1942, 'JECEABA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1943, 'JENIPAPO DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1944, 'JEQUERI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1945, 'JEQUITAÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1946, 'JEQUITIBÁ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1947, 'JEQUITINHONHA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1948, 'JESUÂNIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1949, 'JOAÍMA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1950, 'JOANÉSIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1951, 'JOÃO MONLEVADE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1952, 'JOÃO PINHEIRO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1953, 'JOAQUIM FELÍCIO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1954, 'JORDÂNIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1955, 'JOSÉ GONÇALVES DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1956, 'JOSÉ RAYDAN' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1957, 'JOSENÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1958, 'JUATUBA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1959, 'JUIZ DE FORA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1960, 'JURAMENTO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1961, 'JURUAIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1962, 'JUVENÍLIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1963, 'LADAINHA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1964, 'LAGAMAR' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1965, 'LAGOA DA PRATA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1966, 'LAGOA DOS PATOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1967, 'LAGOA DOURADA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1968, 'LAGOA FORMOSA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1969, 'LAGOA GRANDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1970, 'LAGOA SANTA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1971, 'LAJINHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1972, 'LAMBARI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1973, 'LAMIM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1974, 'LARANJAL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1975, 'LASSANCE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1976, 'LAVRAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1977, 'LEANDRO FERREIRA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1978, 'LEME DO PRADO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1979, 'LEOPOLDINA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1980, 'LIBERDADE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1981, 'LIMA DUARTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1982, 'LIMEIRA DO OESTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1983, 'LONTRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1984, 'LUISBURGO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1985, 'LUISLÂNDIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1986, 'LUMINÁRIAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1987, 'LUZ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1988, 'MACHACALIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1989, 'MACHADO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1990, 'MADRE DE DEUS DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1991, 'MALACACHETA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1992, 'MAMONAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1993, 'MANGA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1994, 'MANHUAÇU', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1995, 'MANHUMIRIM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1996, 'MANTENA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1997, 'MAR DE ESPANHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1998, 'MARAVILHAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (1999, 'MARIA DA FÉ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2000, 'MARIANA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2001, 'MARILAC' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2002, 'MÁRIO CAMPOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2003, 'MARIPÁ DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2004, 'MARLIÉRIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2005, 'MARMELÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2006, 'MARTINHO CAMPOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2007, 'MARTINS SOARES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2008, 'MATA VERDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2009, 'MATERLÂNDIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2010, 'MATEUS LEME' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2011, 'MATHIAS LOBATO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2012, 'MATIAS BARBOSA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2013, 'MATIAS CARDOSO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2014, 'MATIPÓ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2015, 'MATO VERDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2016, 'MATOZINHOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2017, 'MATUTINA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2018, 'MEDEIROS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2019, 'MEDINA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2020, 'MENDES PIMENTEL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2021, 'MERCÊS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2022, 'MESQUITA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2023, 'MINAS NOVAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2024, 'MINDURI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2025, 'MIRABELA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2026, 'MIRADOURO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2027, 'MIRAÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2028, 'MIRAVÂNIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2029, 'MOEDA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2030, 'MOEMA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2031, 'MONJOLOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2032, 'MONSENHOR PAULO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2033, 'MONTALVÂNIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2034, 'MONTE ALEGRE DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2035, 'MONTE AZUL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2036, 'MONTE BELO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2037, 'MONTE CARMELO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2038, 'MONTE FORMOSO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2039, 'MONTE SANTO DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2040, 'MONTE SIÃO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2041, 'MONTES CLAROS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2042, 'MONTEZUMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2043, 'MORADA NOVA DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2044, 'MORRO DA GARÇA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2045, 'MORRO DO PILAR' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2046, 'MUNHOZ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2047, 'MURIAÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2048, 'MUTUM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2049, 'MUZAMBINHO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2050, 'NACIP RAYDAN', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2051, 'NANUQUE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2052, 'NAQUE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2053, 'NATALÂNDIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2054, 'NATÉRCIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2055, 'NAZARENO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2056, 'NEPOMUCENO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2057, 'NINHEIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2058, 'NOVA BELÉM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2059, 'NOVA ERA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2060, 'NOVA LIMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2061, 'NOVA MÓDICA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2062, 'NOVA PONTE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2063, 'NOVA PORTEIRINHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2064, 'NOVA RESENDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2065, 'NOVA SERRANA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2066, 'NOVA UNIÃO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2067, 'NOVO CRUZEIRO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2068, 'NOVO ORIENTE DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2069, 'NOVORIZONTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2070, 'OLARIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2071, 'OLHOS-D`ÁGUA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2072, 'OLÍMPIO NORONHA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2073, 'OLIVEIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2074, 'OLIVEIRA FORTES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2075, 'ONÇA DE PITANGUI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2076, 'ORATÓRIOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2077, 'ORIZÂNIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2078, 'OURO BRANCO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2079, 'OURO FINO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2080, 'OURO PRETO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2081, 'OURO VERDE DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2082, 'PADRE CARVALHO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2083, 'PADRE PARAÍSO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2084, 'PAI PEDRO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2085, 'PAINEIRAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2086, 'PAINS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2087, 'PAIVA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2088, 'PALMA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2089, 'PALMÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2090, 'PAPAGAIOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2091, 'PARÁ DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2092, 'PARACATU', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2093, 'PARAGUAÇU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2094, 'PARAISÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2095, 'PARAOPEBA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2096, 'PASSA QUATRO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2097, 'PASSA TEMPO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2098, 'PASSA-VINTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2099, 'PASSABÉM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2100, 'PASSOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2101, 'PATIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2102, 'PATOS DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2103, 'PATROCÍNIO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2104, 'PATROCÍNIO DO MURIAÉ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2105, 'PAULA CÂNDIDO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2106, 'PAULISTAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2107, 'PAVÃO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2108, 'PEÇANHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2109, 'PEDRA AZUL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2110, 'PEDRA BONITA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2111, 'PEDRA DO ANTA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2112, 'PEDRA DO INDAIÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2113, 'PEDRA DOURADA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2114, 'PEDRALVA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2115, 'PEDRAS DE MARIA DA CRUZ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2116, 'PEDRINÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2117, 'PEDRO LEOPOLDO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2118, 'PEDRO TEIXEIRA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2119, 'PEQUERI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2120, 'PEQUI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2121, 'PERDIGÃO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2122, 'PERDIZES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2123, 'PERDÕES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2124, 'PERIQUITO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2125, 'PESCADOR', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2126, 'PIAU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2127, 'PIEDADE DE CARATINGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2128, 'PIEDADE DE PONTE NOVA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2129, 'PIEDADE DO RIO GRANDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2130, 'PIEDADE DOS GERAIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2131, 'PIMENTA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2132, 'PINGO-D`ÁGUA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2133, 'PINTÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2134, 'PIRACEMA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2135, 'PIRAJUBA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2136, 'PIRANGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2137, 'PIRANGUÇU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2138, 'PIRANGUINHO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2139, 'PIRAPETINGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2140, 'PIRAPORA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2141, 'PIRAÚBA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2142, 'PITANGUI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2143, 'PIUMHI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2144, 'PLANURA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2145, 'POÇO FUNDO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2146, 'POÇOS DE CALDAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2147, 'POCRANE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2148, 'POMPÉU', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2149, 'PONTE NOVA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2150, 'PONTO CHIQUE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2151, 'PONTO DOS VOLANTES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2152, 'PORTEIRINHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2153, 'PORTO FIRME' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2154, 'POTÉ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2155, 'POUSO ALEGRE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2156, 'POUSO ALTO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2157, 'PRADOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2158, 'PRATA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2159, 'PRATÁPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2160, 'PRATINHA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2161, 'PRESIDENTE BERNARDES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2162, 'PRESIDENTE JUSCELINO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2163, 'PRESIDENTE KUBITSCHEK', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2164, 'PRESIDENTE OLEGÁRIO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2165, 'PRUDENTE DE MORAIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2166, 'QUARTEL GERAL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2167, 'QUELUZITO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2168, 'RAPOSOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2169, 'RAUL SOARES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2170, 'RECREIO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2171, 'REDUTO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2172, 'RESENDE COSTA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2173, 'RESPLENDOR', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2174, 'RESSAQUINHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2175, 'RIACHINHO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2176, 'RIACHO DOS MACHADOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2177, 'RIBEIRÃO DAS NEVES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2178, 'RIBEIRÃO VERMELHO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2179, 'RIO ACIMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2180, 'RIO CASCA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2181, 'RIO DO PRADO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2182, 'RIO DOCE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2183, 'RIO ESPERA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2184, 'RIO MANSO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2185, 'RIO NOVO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2186, 'RIO PARANAÍBA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2187, 'RIO PARDO DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2188, 'RIO PIRACICABA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2189, 'RIO POMBA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2190, 'RIO PRETO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2191, 'RIO VERMELHO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2192, 'RITÁPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2193, 'ROCHEDO DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2194, 'RODEIRO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2195, 'ROMARIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2196, 'ROSÁRIO DA LIMEIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2197, 'RUBELITA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2198, 'RUBIM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2199, 'SABARÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2200, 'SABINÓPOLIS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2201, 'SACRAMENTO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2202, 'SALINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2203, 'SALTO DA DIVISA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2204, 'SANTA BÁRBARA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2205, 'SANTA BÁRBARA DO LESTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2206, 'SANTA BÁRBARA DO MONTE VERDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2207, 'SANTA BÁRBARA DO TUGÚRIO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2208, 'SANTA CRUZ DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2209, 'SANTA CRUZ DE SALINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2210, 'SANTA CRUZ DO ESCALVADO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2211, 'SANTA EFIGÊNIA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2212, 'SANTA FÉ DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2213, 'SANTA HELENA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2214, 'SANTA JULIANA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2215, 'SANTA LUZIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2216, 'SANTA MARGARIDA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2217, 'SANTA MARIA DE ITABIRA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2218, 'SANTA MARIA DO SALTO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2219, 'SANTA MARIA DO SUAÇUÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2220, 'SANTA RITA DE CALDAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2221, 'SANTA RITA DE IBITIPOCA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2222, 'SANTA RITA DE JACUTINGA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2223, 'SANTA RITA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2224, 'SANTA RITA DO ITUETO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2225, 'SANTA RITA DO SAPUCAÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2226, 'SANTA ROSA DA SERRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2227, 'SANTA VITÓRIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2228, 'SANTANA DA VARGEM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2229, 'SANTANA DE CATAGUASES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2230, 'SANTANA DE PIRAPAMA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2231, 'SANTANA DO DESERTO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2232, 'SANTANA DO GARAMBÉU', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2233, 'SANTANA DO JACARÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2234, 'SANTANA DO MANHUAÇU', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2235, 'SANTANA DO PARAÍSO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2236, 'SANTANA DO RIACHO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2237, 'SANTANA DOS MONTES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2238, 'SANTO ANTÔNIO DO AMPARO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2239, 'SANTO ANTÔNIO DO AVENTUREIRO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2240, 'SANTO ANTÔNIO DO GRAMA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2241, 'SANTO ANTÔNIO DO ITAMBÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2242, 'SANTO ANTÔNIO DO JACINTO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2243, 'SANTO ANTÔNIO DO MONTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2244, 'SANTO ANTÔNIO DO RETIRO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2245, 'SANTO ANTÔNIO DO RIO ABAIXO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2246, 'SANTO HIPÓLITO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2247, 'SANTOS DUMONT', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2248, 'SÃO BENTO ABADE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2249, 'SÃO BRÁS DO SUAÇUÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2250, 'SÃO DOMINGOS DAS DORES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2251, 'SÃO DOMINGOS DO PRATA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2252, 'SÃO FÉLIX DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2253, 'SÃO FRANCISCO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2254, 'SÃO FRANCISCO DE PAULA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2255, 'SÃO FRANCISCO DE SALES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2256, 'SÃO FRANCISCO DO GLÓRIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2257, 'SÃO GERALDO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2258, 'SÃO GERALDO DA PIEDADE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2259, 'SÃO GERALDO DO BAIXIO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2260, 'SÃO GONÇALO DO ABAETÉ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2261, 'SÃO GONÇALO DO PARÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2262, 'SÃO GONÇALO DO RIO ABAIXO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2263, 'SÃO GONÇALO DO RIO PRETO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2264, 'SÃO GONÇALO DO SAPUCAÍ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2265, 'SÃO GOTARDO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2266, 'SÃO JOÃO BATISTA DO GLÓRIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2267, 'SÃO JOÃO DA LAGOA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2268, 'SÃO JOÃO DA MATA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2269, 'SÃO JOÃO DA PONTE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2270, 'SÃO JOÃO DAS MISSÕES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2271, 'SÃO JOÃO DEL REI' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2272, 'SÃO JOÃO DO MANHUAÇU' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2273, 'SÃO JOÃO DO MANTENINHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2274, 'SÃO JOÃO DO ORIENTE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2275, 'SÃO JOÃO DO PACUÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2276, 'SÃO JOÃO DO PARAÍSO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2277, 'SÃO JOÃO EVANGELISTA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2278, 'SÃO JOÃO NEPOMUCENO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2279, 'SÃO JOAQUIM DE BICAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2280, 'SÃO JOSÉ DA BARRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2281, 'SÃO JOSÉ DA LAPA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2282, 'SÃO JOSÉ DA SAFIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2283, 'SÃO JOSÉ DA VARGINHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2284, 'SÃO JOSÉ DO ALEGRE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2285, 'SÃO JOSÉ DO DIVINO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2286, 'SÃO JOSÉ DO GOIABAL', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2287, 'SÃO JOSÉ DO JACURI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2288, 'SÃO JOSÉ DO MANTIMENTO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2289, 'SÃO LOURENÇO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2290, 'SÃO MIGUEL DO ANTA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2291, 'SÃO PEDRO DA UNIÃO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2292, 'SÃO PEDRO DO SUAÇUÍ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2293, 'SÃO PEDRO DOS FERROS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2294, 'SÃO ROMÃO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2295, 'SÃO ROQUE DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2296, 'SÃO SEBASTIÃO DA BELA VISTA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2297, 'SÃO SEBASTIÃO DA VARGEM ALEGRE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2298, 'SÃO SEBASTIÃO DO ANTA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2299, 'SÃO SEBASTIÃO DO MARANHÃO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2300, 'SÃO SEBASTIÃO DO OESTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2301, 'SÃO SEBASTIÃO DO PARAÍSO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2302, 'SÃO SEBASTIÃO DO RIO PRETO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2303, 'SÃO SEBASTIÃO DO RIO VERDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2304, 'SÃO THOMÉ DAS LETRAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2305, 'SÃO TIAGO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2306, 'SÃO TOMÁS DE AQUINO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2307, 'SÃO VICENTE DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2308, 'SAPUCAÍ-MIRIM', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2309, 'SARDOÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2310, 'SARZEDO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2311, 'SEM-PEIXE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2312, 'SENADOR AMARAL' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2313, 'SENADOR CORTES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2314, 'SENADOR FIRMINO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2315, 'SENADOR JOSÉ BENTO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2316, 'SENADOR MODESTINO GONÇALVES' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2317, 'SENHORA DE OLIVEIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2318, 'SENHORA DO PORTO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2319, 'SENHORA DOS REMÉDIOS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2320, 'SERICITA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2321, 'SERITINGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2322, 'SERRA AZUL DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2323, 'SERRA DA SAUDADE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2324, 'SERRA DO SALITRE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2325, 'SERRA DOS AIMORÉS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2326, 'SERRANIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2327, 'SERRANÓPOLIS DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2328, 'SERRANOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2329, 'SERRO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2330, 'SETE LAGOAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2331, 'SETUBINHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2332, 'SILVEIRÂNIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2333, 'SILVIANÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2334, 'SIMÃO PEREIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2335, 'SIMONÉSIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2336, 'SOBRÁLIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2337, 'SOLEDADE DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2338, 'TABULEIRO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2339, 'TAIOBEIRAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2340, 'TAPARUBA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2341, 'TAPIRA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2342, 'TAPIRAÍ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2343, 'TAQUARAÇU DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2344, 'TARUMIRIM' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2345, 'TEIXEIRAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2346, 'TEÓFILO OTONI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2347, 'TIMÓTEO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2348, 'TIRADENTES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2349, 'TIROS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2350, 'TOCANTINS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2351, 'TOCOS DO MOJI', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2352, 'TOLEDO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2353, 'TOMBOS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2354, 'TRÊS CORAÇÕES', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2355, 'TRÊS MARIAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2356, 'TRÊS PONTAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2357, 'TUMIRITINGA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2358, 'TUPACIGUARA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2359, 'TURMALINA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2360, 'TURVOLÂNDIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2361, 'UBÁ', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2362, 'UBAÍ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2363, 'UBAPORANGA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2364, 'UBERABA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2365, 'UBERLÂNDIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2366, 'UMBURATIBA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2367, 'UNAÍ' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2368, 'UNIÃO DE MINAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2369, 'URUANA DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2370, 'URUCÂNIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2371, 'URUCUIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2372, 'VARGEM ALEGRE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2373, 'VARGEM BONITA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2374, 'VARGEM GRANDE DO RIO PARDO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2375, 'VARGINHA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2376, 'VARJÃO DE MINAS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2377, 'VÁRZEA DA PALMA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2378, 'VARZELÂNDIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2379, 'VAZANTE' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2380, 'VERDELÂNDIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2381, 'VEREDINHA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2382, 'VERÍSSIMO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2383, 'VERMELHO NOVO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2384, 'VESPASIANO', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2385, 'VIÇOSA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2386, 'VIEIRAS' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2387, 'VIRGEM DA LAPA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2388, 'VIRGÍNIA', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2389, 'VIRGINÓPOLIS', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2390, 'VIRGOLÂNDIA' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2391, 'VISCONDE DO RIO BRANCO' , 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2392, 'VOLTA GRANDE', 06);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2393, 'WENCESLAU BRAZ' , 06);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2394, 'ABAETETUBA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2395, 'ABEL FIGUEIREDO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2396, 'ACARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2397, 'AFUÁ' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2398, 'ÁGUA AZUL DO NORTE', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2399, 'ALENQUER', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2400, 'ALMEIRIM', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2401, 'ALTAMIRA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2402, 'ANAJÁS', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2403, 'ANANINDEUA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2404, 'ANAPU', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2405, 'AUGUSTO CORRÊA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2406, 'AURORA DO PARÁ' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2407, 'AVEIRO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2408, 'BAGRE', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2409, 'BAIÃO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2410, 'BANNACH' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2411, 'BARCARENA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2412, 'BELÉM', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2413, 'BELTERRA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2414, 'BENEVIDES' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2415, 'BOM JESUS DO TOCANTINS' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2416, 'BONITO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2417, 'BRAGANÇA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2418, 'BRASIL NOVO' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2419, 'BREJO GRANDE DO ARAGUAIA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2420, 'BREU BRANCO' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2421, 'BREVES', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2422, 'BUJARU', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2423, 'CACHOEIRA DO ARARI', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2424, 'CACHOEIRA DO PIRIÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2425, 'CAMETÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2426, 'CANAÃ DOS CARAJÁS', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2427, 'CAPANEMA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2428, 'CAPITÃO POÇO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2429, 'CASTANHAL' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2430, 'CHAVES', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2431, 'COLARES' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2432, 'CONCEIÇÃO DO ARAGUAIA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2433, 'CONCÓRDIA DO PARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2434, 'CUMARU DO NORTE', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2435, 'CURIONÓPOLIS', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2436, 'CURRALINHO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2437, 'CURUÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2438, 'CURUÇÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2439, 'DOM ELISEU', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2440, 'ELDORADO DOS CARAJÁS' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2441, 'FARO' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2442, 'FLORESTA DO ARAGUAIA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2443, 'GARRAFÃO DO NORTE', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2444, 'GOIANÉSIA DO PARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2445, 'GURUPÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2446, 'IGARAPÉ-AÇU' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2447, 'IGARAPÉ-MIRI', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2448, 'INHANGAPI' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2449, 'IPIXUNA DO PARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2450, 'IRITUIA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2451, 'ITAITUBA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2452, 'ITUPIRANGA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2453, 'JACAREACANGA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2454, 'JACUNDÁ' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2455, 'JURUTI', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2456, 'LIMOEIRO DO AJURU', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2457, 'MÃE DO RIO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2458, 'MAGALHÃES BARATA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2459, 'MARABÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2460, 'MARACANÃ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2461, 'MARAPANIM' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2462, 'MARITUBA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2463, 'MEDICILÂNDIA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2464, 'MELGAÇO' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2465, 'MOCAJUBA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2466, 'MOJU' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2467, 'MONTE ALEGRE', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2468, 'MUANÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2469, 'NOVA ESPERANÇA DO PIRIÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2470, 'NOVA IPIXUNA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2471, 'NOVA TIMBOTEUA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2472, 'NOVO PROGRESSO' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2473, 'NOVO REPARTIMENTO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2474, 'ÓBIDOS', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2475, 'OEIRAS DO PARÁ' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2476, 'ORIXIMINÁ' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2477, 'OURÉM', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2478, 'OURILÂNDIA DO NORTE', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2479, 'PACAJÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2480, 'PALESTINA DO PARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2481, 'PARAGOMINAS' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2482, 'PARAUAPEBAS' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2483, 'PAU D`ARCO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2484, 'PEIXE-BOI' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2485, 'PIÇARRA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2486, 'PLACAS', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2487, 'PONTA DE PEDRAS', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2488, 'PORTEL', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2489, 'PORTO DE MOZ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2490, 'PRAINHA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2491, 'PRIMAVERA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2492, 'QUATIPURU' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2493, 'REDENÇÃO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2494, 'RIO MARIA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2495, 'RONDON DO PARÁ' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2496, 'RURÓPOLIS' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2497, 'SALINÓPOLIS' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2498, 'SALVATERRA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2499, 'SANTA BÁRBARA DO PARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2500, 'SANTA CRUZ DO ARARI', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2501, 'SANTA ISABEL DO PARÁ' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2502, 'SANTA LUZIA DO PARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2503, 'SANTA MARIA DAS BARREIRAS', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2504, 'SANTA MARIA DO PARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2505, 'SANTANA DO ARAGUAIA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2506, 'SANTARÉM', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2507, 'SANTARÉM NOVO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2508, 'SANTO ANTÔNIO DO TAUÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2509, 'SÃO CAETANO DE ODIVELAS', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2510, 'SÃO DOMINGOS DO ARAGUAIA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2511, 'SÃO DOMINGOS DO CAPIM', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2512, 'SÃO FÉLIX DO XINGU', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2513, 'SÃO FRANCISCO DO PARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2514, 'SÃO GERALDO DO ARAGUAIA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2515, 'SÃO JOÃO DA PONTA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2516, 'SÃO JOÃO DE PIRABAS', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2517, 'SÃO JOÃO DO ARAGUAIA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2518, 'SÃO MIGUEL DO GUAMÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2519, 'SÃO SEBASTIÃO DA BOA VISTA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2520, 'SAPUCAIA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2521, 'SENADOR JOSÉ PORFÍRIO', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2522, 'SOURE', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2523, 'TAILÂNDIA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2524, 'TERRA ALTA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2525, 'TERRA SANTA' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2526, 'TOMÉ-AÇU', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2527, 'TRACUATEUA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2528, 'TRAIRÃO' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2529, 'TUCUMÃ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2530, 'TUCURUÍ' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2531, 'ULIANÓPOLIS' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2532, 'URUARÁ', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2533, 'VIGIA', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2534, 'VISEU', 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2535, 'VITÓRIA DO XINGU' , 19);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2536, 'XINGUARA', 19);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2537, 'ÁGUA BRANCA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2538, 'AGUIAR', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2539, 'ALAGOA GRANDE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2540, 'ALAGOA NOVA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2541, 'ALAGOINHA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2542, 'ALCANTIL', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2543, 'ALGODÃO DE JANDAÍRA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2544, 'ALHANDRA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2545, 'AMPARO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2546, 'APARECIDA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2547, 'ARAÇAGI' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2548, 'ARARA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2549, 'ARARUNA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2550, 'AREIA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2551, 'AREIA DE BARAÚNAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2552, 'AREIAL', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2553, 'AROEIRAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2554, 'ASSUNÇÃO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2555, 'BAÍA DA TRAIÇÃO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2556, 'BANANEIRAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2557, 'BARAÚNA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2558, 'BARRA DE SANTA ROSA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2559, 'BARRA DE SANTANA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2560, 'BARRA DE SÃO MIGUEL', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2561, 'BAYEUX', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2562, 'BELÉM', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2563, 'BELÉM DO BREJO DO CRUZ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2564, 'BERNARDINO BATISTA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2565, 'BOA VENTURA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2566, 'BOA VISTA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2567, 'BOM JESUS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2568, 'BOM SUCESSO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2569, 'BONITO DE SANTA FÉ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2570, 'BOQUEIRÃO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2571, 'BORBOREMA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2572, 'BREJO DO CRUZ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2573, 'BREJO DOS SANTOS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2574, 'CAAPORÃ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2575, 'CABACEIRAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2576, 'CABEDELO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2577, 'CACHOEIRA DOS ÍNDIOS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2578, 'CACIMBA DE AREIA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2579, 'CACIMBA DE DENTRO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2580, 'CACIMBAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2581, 'CAIÇARA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2582, 'CAJAZEIRAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2583, 'CAJAZEIRINHAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2584, 'CALDAS BRANDÃO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2585, 'CAMALAÚ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2586, 'CAMPINA GRANDE' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2587, 'CAMPO DE SANTANA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2588, 'CAPIM', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2589, 'CARAÚBAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2590, 'CARRAPATEIRA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2591, 'CASSERENGUE' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2592, 'CATINGUEIRA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2593, 'CATOLÉ DO ROCHA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2594, 'CATURITÉ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2595, 'CONCEIÇÃO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2596, 'CONDADO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2597, 'CONDE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2598, 'CONGO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2599, 'COREMAS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2600, 'COXIXOLA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2601, 'CRUZ DO ESPÍRITO SANTO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2602, 'CUBATI', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2603, 'CUITÉ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2604, 'CUITÉ DE MAMANGUAPE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2605, 'CUITEGI' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2606, 'CURRAL DE CIMA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2607, 'CURRAL VELHO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2608, 'DAMIÃO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2609, 'DESTERRO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2610, 'DIAMANTE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2611, 'DONA INÊS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2612, 'DUAS ESTRADAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2613, 'EMAS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2614, 'ESPERANÇA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2615, 'FAGUNDES', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2616, 'FREI MARTINHO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2617, 'GADO BRAVO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2618, 'GUARABIRA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2619, 'GURINHÉM', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2620, 'GURJÃO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2621, 'IBIARA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2622, 'IGARACY' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2623, 'IMACULADA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2624, 'INGÁ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2625, 'ITABAIANA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2626, 'ITAPORANGA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2627, 'ITAPOROROCA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2628, 'ITATUBA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2629, 'JACARAÚ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2630, 'JERICÓ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2631, 'JOÃO PESSOA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2632, 'JUAREZ TÁVORA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2633, 'JUAZEIRINHO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2634, 'JUNCO DO SERIDÓ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2635, 'JURIPIRANGA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2636, 'JURU' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2637, 'LAGOA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2638, 'LAGOA DE DENTRO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2639, 'LAGOA SECA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2640, 'LASTRO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2641, 'LIVRAMENTO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2642, 'LOGRADOURO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2643, 'LUCENA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2644, 'MÃE D`ÁGUA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2645, 'MALTA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2646, 'MAMANGUAPE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2647, 'MANAÍRA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2648, 'MARCAÇÃO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2649, 'MARI' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2650, 'MARIZÓPOLIS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2651, 'MASSARANDUBA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2652, 'MATARACA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2653, 'MATINHAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2654, 'MATO GROSSO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2655, 'MATURÉIA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2656, 'MOGEIRO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2657, 'MONTADAS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2658, 'MONTE HOREBE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2659, 'MONTEIRO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2660, 'MULUNGU' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2661, 'NATUBA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2662, 'NAZAREZINHO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2663, 'NOVA FLORESTA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2664, 'NOVA OLINDA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2665, 'NOVA PALMEIRA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2666, 'OLHO D`ÁGUA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2667, 'OLIVEDOS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2668, 'OURO VELHO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2669, 'PARARI', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2670, 'PASSAGEM', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2671, 'PATOS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2672, 'PAULISTA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2673, 'PEDRA BRANCA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2674, 'PEDRA LAVRADA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2675, 'PEDRAS DE FOGO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2676, 'PEDRO RÉGIS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2677, 'PIANCÓ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2678, 'PICUÍ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2679, 'PILAR', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2680, 'PILÕES', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2681, 'PILÕEZINHOS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2682, 'PIRPIRITUBA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2683, 'PITIMBU' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2684, 'POCINHOS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2685, 'POÇO DANTAS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2686, 'POÇO DE JOSÉ DE MOURA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2687, 'POMBAL', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2688, 'PRATA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2689, 'PRINCESA ISABEL', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2690, 'PUXINANÃ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2691, 'QUEIMADAS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2692, 'QUIXABÁ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2693, 'REMÍGIO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2694, 'RIACHÃO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2695, 'RIACHÃO DO BACAMARTE' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2696, 'RIACHÃO DO POÇO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2697, 'RIACHO DE SANTO ANTÔNIO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2698, 'RIACHO DOS CAVALOS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2699, 'RIO TINTO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2700, 'SALGADINHO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2701, 'SALGADO DE SÃO FÉLIX' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2702, 'SANTA CECÍLIA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2703, 'SANTA CRUZ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2704, 'SANTA HELENA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2705, 'SANTA INÊS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2706, 'SANTA LUZIA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2707, 'SANTA RITA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2708, 'SANTA TERESINHA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2709, 'SANTANA DE MANGUEIRA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2710, 'SANTANA DOS GARROTES' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2711, 'SANTARÉM', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2712, 'SANTO ANDRÉ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2713, 'SÃO BENTINHO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2714, 'SÃO BENTO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2715, 'SÃO DOMINGOS DE POMBAL' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2716, 'SÃO DOMINGOS DO CARIRI' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2717, 'SÃO FRANCISCO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2718, 'SÃO JOÃO DO CARIRI', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2719, 'SÃO JOÃO DO RIO DO PEIXE' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2720, 'SÃO JOÃO DO TIGRE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2721, 'SÃO JOSÉ DA LAGOA TAPADA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2722, 'SÃO JOSÉ DE CAIANA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2723, 'SÃO JOSÉ DE ESPINHARAS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2724, 'SÃO JOSÉ DE PIRANHAS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2725, 'SÃO JOSÉ DE PRINCESA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2726, 'SÃO JOSÉ DO BONFIM', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2727, 'SÃO JOSÉ DO BREJO DO CRUZ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2728, 'SÃO JOSÉ DO SABUGI', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2729, 'SÃO JOSÉ DOS CORDEIROS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2730, 'SÃO JOSÉ DOS RAMOS', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2731, 'SÃO MAMEDE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2732, 'SÃO MIGUEL DE TAIPU', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2733, 'SÃO SEBASTIÃO DE LAGOA DE ROÇA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2734, 'SÃO SEBASTIÃO DO UMBUZEIRO', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2735, 'SAPÉ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2736, 'SERIDÓ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2737, 'SERRA BRANCA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2738, 'SERRA DA RAIZ', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2739, 'SERRA GRANDE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2740, 'SERRA REDONDA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2741, 'SERRARIA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2742, 'SERTÃOZINHO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2743, 'SOBRADO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2744, 'SOLÂNEA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2745, 'SOLEDADE', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2746, 'SOSSÊGO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2747, 'SOUSA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2748, 'SUMÉ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2749, 'TAPEROÁ' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2750, 'TAVARES' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2751, 'TEIXEIRA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2752, 'TENÓRIO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2753, 'TRIUNFO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2754, 'UIRAÚNA' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2755, 'UMBUZEIRO' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2756, 'VÁRZEA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2757, 'VIEIRÓPOLIS' , 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2758, 'VISTA SERRANA', 18);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2759, 'ZABELÊ', 18);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2760, 'ABATIÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2761, 'ADRIANÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2762, 'AGUDOS DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2763, 'ALMIRANTE TAMANDARÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2764, 'ALTAMIRA DO PARANÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2765, 'ALTO PARANÁ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2766, 'ALTO PIQUIRI', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2767, 'ALTÔNIA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2768, 'ALVORADA DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2769, 'AMAPORÃ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2770, 'AMPÉRE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2771, 'ANAHY', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2772, 'ANDIRÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2773, 'ÂNGULO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2774, 'ANTONINA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2775, 'ANTÔNIO OLINTO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2776, 'APUCARANA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2777, 'ARAPONGAS' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2778, 'ARAPOTI' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2779, 'ARAPUÃ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2780, 'ARARUNA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2781, 'ARAUCÁRIA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2782, 'ARIRANHA DO IVAÍ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2783, 'ASSAÍ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2784, 'ASSIS CHATEAUBRIAND', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2785, 'ASTORGA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2786, 'ATALAIA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2787, 'BALSA NOVA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2788, 'BANDEIRANTES', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2789, 'BARBOSA FERRAZ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2790, 'BARRA DO JACARÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2791, 'BARRACÃO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2792, 'BELA VISTA DA CAROBA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2793, 'BELA VISTA DO PARAÍSO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2794, 'BITURUNA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2795, 'BOA ESPERANÇA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2796, 'BOA ESPERANÇA DO IGUAÇU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2797, 'BOA VENTURA DE SÃO ROQUE' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2798, 'BOA VISTA DA APARECIDA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2799, 'BOCAIÚVA DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2800, 'BOM JESUS DO SUL' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2801, 'BOM SUCESSO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2802, 'BOM SUCESSO DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2803, 'BORRAZÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2804, 'BRAGANEY', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2805, 'BRASILÂNDIA DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2806, 'CAFEARA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2807, 'CAFELÂNDIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2808, 'CAFEZAL DO SUL' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2809, 'CALIFÓRNIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2810, 'CAMBARÁ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2811, 'CAMBÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2812, 'CAMBIRA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2813, 'CAMPINA DA LAGOA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2814, 'CAMPINA DO SIMÃO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2815, 'CAMPINA GRANDE DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2816, 'CAMPO BONITO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2817, 'CAMPO DO TENENTE' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2818, 'CAMPO LARGO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2819, 'CAMPO MAGRO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2820, 'CAMPO MOURÃO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2821, 'CÂNDIDO DE ABREU' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2822, 'CANDÓI', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2823, 'CANTAGALO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2824, 'CAPANEMA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2825, 'CAPITÃO LEÔNIDAS MARQUES' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2826, 'CARAMBEÍ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2827, 'CARLÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2828, 'CASCAVEL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2829, 'CASTRO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2830, 'CATANDUVAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2831, 'CENTENÁRIO DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2832, 'CERRO AZUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2833, 'CÉU AZUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2834, 'CHOPINZINHO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2835, 'CIANORTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2836, 'CIDADES GAÚCHA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2837, 'CLEVELÂNDIA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2838, 'COLOMBO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2839, 'COLORADO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2840, 'CONGONHINHAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2841, 'CONSELHEIRO MAIRINCK' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2842, 'CONTENDA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2843, 'CORBÉLIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2844, 'CORNÉLIO PROCÓPIO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2845, 'CORONEL DOMINGOS SOARES', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2846, 'CORONEL VIVIDA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2847, 'CORUMBATAÍ DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2848, 'CRUZ MACHADO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2849, 'CRUZEIRO DO IGUAÇU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2850, 'CRUZEIRO DO OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2851, 'CRUZEIRO DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2852, 'CRUZMALTINA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2853, 'CURITIBA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2854, 'CURIÚVA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2855, 'DIAMANTE D`OESTE' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2856, 'DIAMANTE DO NORTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2857, 'DIAMANTE DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2858, 'DOIS VIZINHOS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2859, 'DOURADINA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2860, 'DOUTOR CAMARGO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2861, 'DOUTOR ULYSSES' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2862, 'ENÉAS MARQUES', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2863, 'ENGENHEIRO BELTRÃO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2864, 'ENTRE RIOS DO OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2865, 'ESPERANÇA NOVA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2866, 'ESPIGÃO ALTO DO IGUAÇU' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2867, 'FAROL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2868, 'FAXINAL' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2869, 'FAZENDA RIO GRANDE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2870, 'FÊNIX', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2871, 'FERNANDES PINHEIRO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2872, 'FIGUEIRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2873, 'FLOR DA SERRA DO SUL' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2874, 'FLORAÍ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2875, 'FLORESTA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2876, 'FLORESTÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2877, 'FLÓRIDA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2878, 'FORMOSA DO OESTE' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2879, 'FOZ DO IGUAÇU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2880, 'FOZ DO JORDÃO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2881, 'FRANCISCO ALVES', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2882, 'FRANCISCO BELTRÃO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2883, 'GENERAL CARNEIRO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2884, 'GODOY MOREIRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2885, 'GOIOERÊ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2886, 'GOIOXIM' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2887, 'GRANDES RIOS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2888, 'GUAÍRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2889, 'GUAIRAÇÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2890, 'GUAMIRANGA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2891, 'GUAPIRAMA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2892, 'GUAPOREMA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2893, 'GUARACI' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2894, 'GUARANIAÇU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2895, 'GUARAPUAVA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2896, 'GUARAQUEÇABA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2897, 'GUARATUBA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2898, 'HONÓRIO SERPA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2899, 'IBAITI', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2900, 'IBEMA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2901, 'IBIPORÃ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2902, 'ICARAÍMA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2903, 'IGUARAÇU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2904, 'IGUATU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2905, 'IMBAÚ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2906, 'IMBITUVA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2907, 'INÁCIO MARTINS' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2908, 'INAJÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2909, 'INDIANÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2910, 'IPIRANGA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2911, 'IPORÃ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2912, 'IRACEMA DO OESTE' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2913, 'IRATI', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2914, 'IRETAMA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2915, 'ITAGUAJÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2916, 'ITAIPULÂNDIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2917, 'ITAMBARACÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2918, 'ITAMBÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2919, 'ITAPEJARA D`OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2920, 'ITAPERUÇU' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2921, 'ITAÚNA DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2922, 'IVAÍ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2923, 'IVAIPORÃ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2924, 'IVATÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2925, 'IVATUBA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2926, 'JABOTI', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2927, 'JACAREZINHO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2928, 'JAGUAPITÃ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2929, 'JAGUARIAÍVA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2930, 'JANDAIA DO SUL' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2931, 'JANIÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2932, 'JAPIRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2933, 'JAPURÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2934, 'JARDIM ALEGRE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2935, 'JARDIM OLINDA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2936, 'JATAIZINHO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2937, 'JESUÍTAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2938, 'JOAQUIM TÁVORA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2939, 'JUNDIAÍ DO SUL' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2940, 'JURANDA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2941, 'JUSSARA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2942, 'KALORÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2943, 'LAPA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2944, 'LARANJAL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2945, 'LARANJEIRAS DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2946, 'LEÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2947, 'LIDIANÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2948, 'LINDOESTE' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2949, 'LOANDA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2950, 'LOBATO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2951, 'LONDRINA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2952, 'LUIZIANA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2953, 'LUNARDELLI', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2954, 'LUPIONÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2955, 'MALLET', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2956, 'MAMBORÊ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2957, 'MANDAGUAÇU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2958, 'MANDAGUARI', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2959, 'MANDIRITUBA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2960, 'MANFRINÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2961, 'MANGUEIRINHA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2962, 'MANOEL RIBAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2963, 'MARECHAL CÂNDIDO RONDON', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2964, 'MARIA HELENA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2965, 'MARIALVA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2966, 'MARILÂNDIA DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2967, 'MARILENA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2968, 'MARILUZ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2969, 'MARINGÁ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2970, 'MARIÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2971, 'MARIPÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2972, 'MARMELEIRO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2973, 'MARQUINHO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2974, 'MARUMBI' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2975, 'MATELÂNDIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2976, 'MATINHOS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2977, 'MATO RICO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2978, 'MAUÁ DA SERRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2979, 'MEDIANEIRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2980, 'MERCEDES', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2981, 'MIRADOR' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2982, 'MIRASELVA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2983, 'MISSAL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2984, 'MOREIRA SALES', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2985, 'MORRETES', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2986, 'MUNHOZ DE MELO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2987, 'NOSSA SENHORA DAS GRAÇAS' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2988, 'NOVA ALIANÇA DO IVAÍ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2989, 'NOVA AMÉRICA DA COLINA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2990, 'NOVA AURORA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2991, 'NOVA CANTU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2992, 'NOVA ESPERANÇA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2993, 'NOVA ESPERANÇA DO SUDOESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2994, 'NOVA FÁTIMA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2995, 'NOVA LARANJEIRAS' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2996, 'NOVA LONDRINA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2997, 'NOVA OLÍMPIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2998, 'NOVA PRATA DO IGUAÇU' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (2999, 'NOVA SANTA BÁRBARA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3000, 'NOVA SANTA ROSA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3001, 'NOVA TEBAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3002, 'NOVO ITACOLOMI' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3003, 'ORTIGUEIRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3004, 'OURIZONA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3005, 'OURO VERDE DO OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3006, 'PAIÇANDU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3007, 'PALMAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3008, 'PALMEIRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3009, 'PALMITAL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3010, 'PALOTINA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3011, 'PARAÍSO DO NORTE' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3012, 'PARANACITY', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3013, 'PARANAGUÁ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3014, 'PARANAPOEMA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3015, 'PARANAVAÍ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3016, 'PATO BRAGADO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3017, 'PATO BRANCO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3018, 'PAULA FREITAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3019, 'PAULO FRONTIN', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3020, 'PEABIRU' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3021, 'PEROBAL' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3022, 'PÉROLA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3023, 'PÉROLA D`OESTE' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3024, 'PIÊN' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3025, 'PINHAIS' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3026, 'PINHAL DE SÃO BENTO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3027, 'PINHALÃO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3028, 'PINHÃO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3029, 'PIRAÍ DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3030, 'PIRAQUARA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3031, 'PITANGA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3032, 'PITANGUEIRAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3033, 'PLANALTINA DO PARANÁ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3034, 'PLANALTO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3035, 'PONTA GROSSA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3036, 'PONTAL DO PARANÁ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3037, 'PORECATU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3038, 'PORTO AMAZONAS' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3039, 'PORTO BARREIRO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3040, 'PORTO RICO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3041, 'PORTO VITÓRIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3042, 'PRADO FERREIRA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3043, 'PRANCHITA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3044, 'PRESIDENTE CASTELO BRANCO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3045, 'PRIMEIRO DE MAIO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3046, 'PRUDENTÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3047, 'QUARTO CENTENÁRIO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3048, 'QUATIGUÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3049, 'QUATRO BARRAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3050, 'QUATRO PONTES', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3051, 'QUEDAS DO IGUAÇU' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3052, 'QUERÊNCIA DO NORTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3053, 'QUINTA DO SOL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3054, 'QUITANDINHA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3055, 'RAMILÂNDIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3056, 'RANCHO ALEGRE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3057, 'RANCHO ALEGRE D`OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3058, 'REALEZA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3059, 'REBOUÇAS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3060, 'RENASCENÇA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3061, 'RESERVA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3062, 'RESERVA DO IGUAÇU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3063, 'RIBEIRÃO CLARO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3064, 'RIBEIRÃO DO PINHAL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3065, 'RIO AZUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3066, 'RIO BOM' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3067, 'RIO BONITO DO IGUAÇU' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3068, 'RIO BRANCO DO IVAÍ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3069, 'RIO BRANCO DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3070, 'RIO NEGRO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3071, 'ROLÂNDIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3072, 'RONCADOR', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3073, 'RONDON', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3074, 'ROSÁRIO DO IVAÍ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3075, 'SABÁUDIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3076, 'SALGADO FILHO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3077, 'SALTO DO ITARARÉ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3078, 'SALTO DO LONTRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3079, 'SANTA AMÉLIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3080, 'SANTA CECÍLIA DO PAVÃO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3081, 'SANTA CRUZ DE MONTE CASTELO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3082, 'SANTA FÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3083, 'SANTA HELENA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3084, 'SANTA INÊS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3085, 'SANTA ISABEL DO IVAÍ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3086, 'SANTA IZABEL DO OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3087, 'SANTA LÚCIA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3088, 'SANTA MARIA DO OESTE' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3089, 'SANTA MARIANA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3090, 'SANTA MÔNICA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3091, 'SANTA TEREZA DO OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3092, 'SANTA TEREZINHA DE ITAIPU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3093, 'SANTANA DO ITARARÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3094, 'SANTO ANTÔNIO DA PLATINA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3095, 'SANTO ANTÔNIO DO CAIUÁ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3096, 'SANTO ANTÔNIO DO PARAÍSO' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3097, 'SANTO ANTÔNIO DO SUDOESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3098, 'SANTO INÁCIO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3099, 'SÃO CARLOS DO IVAÍ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3100, 'SÃO JERÔNIMO DA SERRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3101, 'SÃO JOÃO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3102, 'SÃO JOÃO DO CAIUÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3103, 'SÃO JOÃO DO IVAÍ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3104, 'SÃO JOÃO DO TRIUNFO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3105, 'SÃO JORGE D`OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3106, 'SÃO JORGE DO IVAÍ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3107, 'SÃO JORGE DO PATROCÍNIO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3108, 'SÃO JOSÉ DA BOA VISTA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3109, 'SÃO JOSÉ DAS PALMEIRAS' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3110, 'SÃO JOSÉ DOS PINHAIS' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3111, 'SÃO MANOEL DO PARANÁ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3112, 'SÃO MATEUS DO SUL', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3113, 'SÃO MIGUEL DO IGUAÇU' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3114, 'SÃO PEDRO DO IGUAÇU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3115, 'SÃO PEDRO DO IVAÍ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3116, 'SÃO PEDRO DO PARANÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3117, 'SÃO SEBASTIÃO DA AMOREIRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3118, 'SÃO TOMÉ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3119, 'SAPOPEMA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3120, 'SARANDI' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3121, 'SAUDADE DO IGUAÇU', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3122, 'SENGÉS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3123, 'SERRANÓPOLIS DO IGUAÇU' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3124, 'SERTANEJA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3125, 'SERTANÓPOLIS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3126, 'SIQUEIRA CAMPOS', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3127, 'SULINA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3128, 'TAMARANA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3129, 'TAMBOARA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3130, 'TAPEJARA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3131, 'TAPIRA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3132, 'TEIXEIRA SOARES', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3133, 'TELÊMACO BORBA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3134, 'TERRA BOA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3135, 'TERRA RICA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3136, 'TERRA ROXA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3137, 'TIBAGI', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3138, 'TIJUCAS DO SUL' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3139, 'TOLEDO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3140, 'TOMAZINA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3141, 'TRÊS BARRAS DO PARANÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3142, 'TUNAS DO PARANÁ', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3143, 'TUNEIRAS DO OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3144, 'TUPÃSSI' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3145, 'TURVO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3146, 'UBIRATÃ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3147, 'UMUARAMA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3148, 'UNIÃO DA VITÓRIA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3149, 'UNIFLOR' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3150, 'URAÍ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3151, 'VENTANIA', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3152, 'VERA CRUZ DO OESTE', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3153, 'VERÊ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3154, 'VILA ALTA' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3155, 'VIRMOND' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3156, 'VITORINO', 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3157, 'WENCESLAU BRAZ' , 07);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3158, 'XAMBRÊ', 07);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3159, 'ABREU E LIMA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3160, 'AFOGADOS DA INGAZEIRA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3161, 'AFRÂNIO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3162, 'AGRESTINA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3163, 'ÁGUA PRETA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3164, 'ÁGUAS BELAS' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3165, 'ALAGOINHA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3166, 'ALIANÇA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3167, 'ALTINHO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3168, 'AMARAJI' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3169, 'ANGELIM' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3170, 'ARAÇOIABA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3171, 'ARARIPINA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3172, 'ARCOVERDE' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3173, 'BARRA DE GUABIRABA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3174, 'BARREIROS' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3175, 'BELÉM DE MARIA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3176, 'BELÉM DE SÃO FRANCISCO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3177, 'BELO JARDIM' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3178, 'BETÂNIA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3179, 'BEZERROS', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3180, 'BODOCÓ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3181, 'BOM CONSELHO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3182, 'BOM JARDIM', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3183, 'BONITO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3184, 'BREJÃO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3185, 'BREJINHO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3186, 'BREJO DA MADRE DE DEUS' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3187, 'BUENOS AIRES', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3188, 'BUÍQUE', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3189, 'CABO DE SANTO AGOSTINHO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3190, 'CABROBÓ' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3191, 'CACHOEIRINHA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3192, 'CAETÉS', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3193, 'CALÇADO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3194, 'CALUMBI' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3195, 'CAMARAGIBE', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3196, 'CAMOCIM DE SÃO FÉLIX' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3197, 'CAMUTANGA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3198, 'CANHOTINHO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3199, 'CAPOEIRAS' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3200, 'CARNAÍBA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3201, 'CARNAUBEIRA DA PENHA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3202, 'CARPINA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3203, 'CARUARU' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3204, 'CASINHAS', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3205, 'CATENDE' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3206, 'CEDRO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3207, 'CHÃ DE ALEGRIA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3208, 'CHÃ GRANDE', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3209, 'CONDADO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3210, 'CORRENTES' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3211, 'CORTÊS', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3212, 'CUMARU', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3213, 'CUPIRA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3214, 'CUSTÓDIA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3215, 'DORMENTES' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3216, 'ESCADA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3217, 'EXU', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3218, 'FEIRA NOVA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3219, 'FERNANDO DE NORONHA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3220, 'FERREIROS' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3221, 'FLORES', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3222, 'FLORESTA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3223, 'FREI MIGUELINHO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3224, 'GAMELEIRA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3225, 'GARANHUNS' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3226, 'GLÓRIA DO GOITÁ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3227, 'GOIANA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3228, 'GRANITO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3229, 'GRAVATÁ' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3230, 'IATI' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3231, 'IBIMIRIM', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3232, 'IBIRAJUBA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3233, 'IGARASSU', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3234, 'IGUARACI', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3235, 'INAJÁ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3236, 'INGAZEIRA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3237, 'IPOJUCA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3238, 'IPUBI', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3239, 'ITACURUBA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3240, 'ITAÍBA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3241, 'ITAMARACÁ' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3242, 'ITAMBÉ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3243, 'ITAPETIM', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3244, 'ITAPISSUMA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3245, 'ITAQUITINGA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3246, 'JABOATÃO DOS GUARARAPES', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3247, 'JAQUEIRA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3248, 'JATAÚBA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3249, 'JATOBÁ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3250, 'JOÃO ALFREDO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3251, 'JOAQUIM NABUCO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3252, 'JUCATI', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3253, 'JUPI' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3254, 'JUREMA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3255, 'LAGOA DO CARRO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3256, 'LAGOA DO ITAENGA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3257, 'LAGOA DO OURO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3258, 'LAGOA DOS GATOS', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3259, 'LAGOA GRANDE', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3260, 'LAJEDO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3261, 'LIMOEIRO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3262, 'MACAPARANA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3263, 'MACHADOS', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3264, 'MANARI', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3265, 'MARAIAL' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3266, 'MIRANDIBA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3267, 'MOREILÂNDIA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3268, 'MORENO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3269, 'NAZARÉ DA MATA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3270, 'OLINDA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3271, 'OROBÓ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3272, 'OROCÓ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3273, 'OURICURI', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3274, 'PALMARES', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3275, 'PALMEIRINA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3276, 'PANELAS' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3277, 'PARANATAMA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3278, 'PARNAMIRIM', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3279, 'PASSIRA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3280, 'PAUDALHO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3281, 'PAULISTA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3282, 'PEDRA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3283, 'PESQUEIRA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3284, 'PETROLÂNDIA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3285, 'PETROLINA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3286, 'POÇÃO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3287, 'POMBOS', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3288, 'PRIMAVERA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3289, 'QUIPAPÁ' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3290, 'QUIXABA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3291, 'RECIFE', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3292, 'RIACHO DAS ALMAS' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3293, 'RIBEIRÃO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3294, 'RIO FORMOSO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3295, 'SAIRÉ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3296, 'SALGADINHO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3297, 'SALGUEIRO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3298, 'SALOÁ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3299, 'SANHARÓ' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3300, 'SANTA CRUZ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3301, 'SANTA CRUZ DA BAIXA VERDE', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3302, 'SANTA CRUZ DO CAPIBARIBE' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3303, 'SANTA FILOMENA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3304, 'SANTA MARIA DA BOA VISTA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3305, 'SANTA MARIA DO CAMBUCÁ' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3306, 'SANTA TEREZINHA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3307, 'SÃO BENEDITO DO SUL', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3308, 'SÃO BENTO DO UNA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3309, 'SÃO CAITANO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3310, 'SÃO JOÃO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3311, 'SÃO JOAQUIM DO MONTE' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3312, 'SÃO JOSÉ DA COROA GRANDE' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3313, 'SÃO JOSÉ DO BELMONTE' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3314, 'SÃO JOSÉ DO EGITO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3315, 'SÃO LOURENÇO DA MATA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3316, 'SÃO VICENTE FERRER', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3317, 'SERRA TALHADA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3318, 'SERRITA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3319, 'SERTÂNIA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3320, 'SIRINHAÉM' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3321, 'SOLIDÃO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3322, 'SURUBIM' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3323, 'TABIRA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3324, 'TACAIMBÓ', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3325, 'TACARATU', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3326, 'TAMANDARÉ' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3327, 'TAQUARITINGA DO NORTE', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3328, 'TEREZINHA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3329, 'TERRA NOVA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3330, 'TIMBAÚBA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3331, 'TORITAMA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3332, 'TRACUNHAÉM', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3333, 'TRINDADE', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3334, 'TRIUNFO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3335, 'TUPANATINGA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3336, 'TUPARETAMA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3337, 'VENTUROSA' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3338, 'VERDEJANTE', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3339, 'VERTENTE DO LÉRIO', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3340, 'VERTENTES' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3341, 'VICÊNCIA', 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3342, 'VITÓRIA DE SANTO ANTÃO' , 20);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3343, 'XEXÉU', 20);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3344, 'ACAUÃ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3345, 'AGRICOLÂNDIA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3346, 'ÁGUA BRANCA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3347, 'ALAGOINHA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3348, 'ALEGRETE DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3349, 'ALTO LONGÁ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3350, 'ALTOS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3351, 'ALVORADA DO GURGUÉIA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3352, 'AMARANTE', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3353, 'ANGICAL DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3354, 'ANÍSIO DE ABREU', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3355, 'ANTÔNIO ALMEIDA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3356, 'AROAZES' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3357, 'ARRAIAL' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3358, 'ASSUNÇÃO DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3359, 'AVELINO LOPES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3360, 'BAIXA GRANDE DO RIBEIRO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3361, 'BARRA D`ALCÂNTARA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3362, 'BARRAS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3363, 'BARREIRAS DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3364, 'BARRO DURO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3365, 'BATALHA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3366, 'BELA VISTA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3367, 'BELÉM DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3368, 'BENEDITINOS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3369, 'BERTOLÍNIA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3370, 'BETÂNIA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3371, 'BOA HORA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3372, 'BOCAINA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3373, 'BOM JESUS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3374, 'BOM PRINCÍPIO DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3375, 'BONFIM DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3376, 'BOQUEIRÃO DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3377, 'BRASILEIRA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3378, 'BREJO DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3379, 'BURITI DOS LOPES' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3380, 'BURITI DOS MONTES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3381, 'CABECEIRAS DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3382, 'CAJAZEIRAS DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3383, 'CAJUEIRO DA PRAIA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3384, 'CALDEIRÃO GRANDE DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3385, 'CAMPINAS DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3386, 'CAMPO ALEGRE DO FIDALGO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3387, 'CAMPO GRANDE DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3388, 'CAMPO LARGO DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3389, 'CAMPO MAIOR' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3390, 'CANAVIEIRA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3391, 'CANTO DO BURITI', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3392, 'CAPITÃO DE CAMPOS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3393, 'CAPITÃO GERVÁSIO OLIVEIRA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3394, 'CARACOL' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3395, 'CARAÚBAS DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3396, 'CARIDADE DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3397, 'CASTELO DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3398, 'CAXINGÓ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3399, 'COCAL', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3400, 'COCAL DE TELHA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3401, 'COCAL DOS ALVES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3402, 'COIVARAS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3403, 'COLÔNIA DO GURGUÉIA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3404, 'COLÔNIA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3405, 'CONCEIÇÃO DO CANINDÉ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3406, 'CORONEL JOSÉ DIAS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3407, 'CORRENTE', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3408, 'CRISTALÂNDIA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3409, 'CRISTINO CASTRO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3410, 'CURIMATÁ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3411, 'CURRAIS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3412, 'CURRAL NOVO DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3413, 'CURRALINHOS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3414, 'DEMERVAL LOBÃO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3415, 'DIRCEU ARCOVERDE' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3416, 'DOM EXPEDITO LOPES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3417, 'DOM INOCÊNCIO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3418, 'DOMINGOS MOURÃO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3419, 'ELESBÃO VELOSO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3420, 'ELISEU MARTINS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3421, 'ESPERANTINA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3422, 'FARTURA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3423, 'FLORES DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3424, 'FLORESTA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3425, 'FLORIANO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3426, 'FRANCINÓPOLIS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3427, 'FRANCISCO AYRES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3428, 'FRANCISCO MACEDO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3429, 'FRANCISCO SANTOS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3430, 'FRONTEIRAS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3431, 'GEMINIANO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3432, 'GILBUÉS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3433, 'GUADALUPE' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3434, 'GUARIBAS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3435, 'HUGO NAPOLEÃO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3436, 'ILHA GRANDE' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3437, 'INHUMA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3438, 'IPIRANGA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3439, 'ISAÍAS COELHO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3440, 'ITAINÓPOLIS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3441, 'ITAUEIRA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3442, 'JACOBINA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3443, 'JAICÓS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3444, 'JARDIM DO MULATO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3445, 'JATOBÁ DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3446, 'JERUMENHA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3447, 'JOÃO COSTA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3448, 'JOAQUIM PIRES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3449, 'JOCA MARQUES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3450, 'JOSÉ DE FREITAS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3451, 'JUAZEIRO DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3452, 'JÚLIO BORGES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3453, 'JUREMA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3454, 'LAGOA ALEGRE', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3455, 'LAGOA DE SÃO FRANCISCO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3456, 'LAGOA DO BARRO DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3457, 'LAGOA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3458, 'LAGOA DO SÍTIO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3459, 'LAGOINHA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3460, 'LANDRI SALES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3461, 'LUÍS CORREIA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3462, 'LUZILÂNDIA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3463, 'MADEIRO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3464, 'MANOEL EMÍDIO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3465, 'MARCOLÂNDIA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3466, 'MARCOS PARENTE' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3467, 'MASSAPÊ DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3468, 'MATIAS OLÍMPIO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3469, 'MIGUEL ALVES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3470, 'MIGUEL LEÃO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3471, 'MILTON BRANDÃO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3472, 'MONSENHOR GIL', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3473, 'MONSENHOR HIPÓLITO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3474, 'MONTE ALEGRE DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3475, 'MORRO CABEÇA NO TEMPO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3476, 'MORRO DO CHAPÉU DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3477, 'MURICI DOS PORTELAS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3478, 'NAZARÉ DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3479, 'NOSSA SENHORA DE NAZARÉ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3480, 'NOSSA SENHORA DOS REMÉDIOS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3481, 'NOVA SANTA RITA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3482, 'NOVO ORIENTE DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3483, 'NOVO SANTO ANTÔNIO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3484, 'OEIRAS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3485, 'OLHO D`ÁGUA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3486, 'PADRE MARCOS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3487, 'PAES LANDIM' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3488, 'PAJEÚ DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3489, 'PALMEIRA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3490, 'PALMEIRAIS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3491, 'PAQUETÁ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3492, 'PARNAGUÁ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3493, 'PARNAÍBA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3494, 'PASSAGEM FRANCA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3495, 'PATOS DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3496, 'PAULISTANA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3497, 'PAVUSSU' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3498, 'PEDRO II', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3499, 'PEDRO LAURENTINO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3500, 'PICOS', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3501, 'PIMENTEIRAS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3502, 'PIO IX', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3503, 'PIRACURUCA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3504, 'PIRIPIRI', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3505, 'PORTO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3506, 'PORTO ALEGRE DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3507, 'PRATA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3508, 'QUEIMADA NOVA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3509, 'REDENÇÃO DO GURGUÉIA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3510, 'REGENERAÇÃO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3511, 'RIACHO FRIO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3512, 'RIBEIRA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3513, 'RIBEIRO GONÇALVES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3514, 'RIO GRANDE DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3515, 'SANTA CRUZ DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3516, 'SANTA CRUZ DOS MILAGRES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3517, 'SANTA FILOMENA' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3518, 'SANTA LUZ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3519, 'SANTA ROSA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3520, 'SANTANA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3521, 'SANTO ANTÔNIO DE LISBOA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3522, 'SANTO ANTÔNIO DOS MILAGRES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3523, 'SANTO INÁCIO DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3524, 'SÃO BRAZ DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3525, 'SÃO FÉLIX DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3526, 'SÃO FRANCISCO DE ASSIS DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3527, 'SÃO FRANCISCO DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3528, 'SÃO GONÇALO DO GURGUÉIA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3529, 'SÃO GONÇALO DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3530, 'SÃO JOÃO DA CANABRAVA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3531, 'SÃO JOÃO DA FRONTEIRA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3532, 'SÃO JOÃO DA SERRA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3533, 'SÃO JOÃO DA VARJOTA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3534, 'SÃO JOÃO DO ARRAIAL', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3535, 'SÃO JOÃO DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3536, 'SÃO JOSÉ DO DIVINO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3537, 'SÃO JOSÉ DO PEIXE', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3538, 'SÃO JOSÉ DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3539, 'SÃO JULIÃO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3540, 'SÃO LOURENÇO DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3541, 'SÃO LUIS DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3542, 'SÃO MIGUEL DA BAIXA GRANDE', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3543, 'SÃO MIGUEL DO FIDALGO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3544, 'SÃO MIGUEL DO TAPUIO' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3545, 'SÃO PEDRO DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3546, 'SÃO RAIMUNDO NONATO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3547, 'SEBASTIÃO BARROS' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3548, 'SEBASTIÃO LEAL' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3549, 'SIGEFREDO PACHECO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3550, 'SIMÕES', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3551, 'SIMPLÍCIO MENDES' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3552, 'SOCORRO DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3553, 'SUSSUAPARA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3554, 'TAMBORIL DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3555, 'TANQUE DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3556, 'TERESINA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3557, 'UNIÃO', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3558, 'URUÇUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3559, 'VALENÇA DO PIAUÍ' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3560, 'VÁRZEA BRANCA', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3561, 'VÁRZEA GRANDE', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3562, 'VERA MENDES' , 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3563, 'VILA NOVA DO PIAUÍ', 21);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3564, 'WALL FERRAZ' , 21);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3565, 'ANGRA DOS REIS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3566, 'APERIBÉ' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3567, 'ARARUAMA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3568, 'AREAL', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3569, 'ARMAÇÃO DOS BÚZIOS', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3570, 'ARRAIAL DO CABO', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3571, 'BARRA DO PIRAÍ' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3572, 'BARRA MANSA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3573, 'BELFORD ROXO', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3574, 'BOM JARDIM', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3575, 'BOM JESUS DO ITABAPOANA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3576, 'CABO FRIO' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3577, 'CACHOEIRAS DE MACACU' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3578, 'CAMBUCI' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3579, 'CAMPOS DOS GOYTACAZES', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3580, 'CANTAGALO' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3581, 'CARAPEBUS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3582, 'CARDOSO MOREIRA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3583, 'CARMO', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3584, 'CASIMIRO DE ABREU', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3585, 'COMENDADOR LEVY GASPARIAN', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3586, 'CONCEIÇÃO DE MACABU', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3587, 'CORDEIRO', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3588, 'DUAS BARRAS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3589, 'DUQUE DE CAXIAS', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3590, 'ENGENHEIRO PAULO DE FRONTIN' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3591, 'GUAPIMIRIM', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3592, 'IGUABA GRANDE', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3593, 'ITABORAÍ', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3594, 'ITAGUAÍ' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3595, 'ITALVA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3596, 'ITAOCARA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3597, 'ITAPERUNA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3598, 'ITATIAIA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3599, 'JAPERI', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3600, 'LAJE DO MURIAÉ' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3601, 'MACAÉ', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3602, 'MACUCO', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3603, 'MAGÉ' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3604, 'MANGARATIBA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3605, 'MARICÁ', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3606, 'MENDES', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3607, 'MIGUEL PEREIRA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3608, 'MIRACEMA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3609, 'NATIVIDADE', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3610, 'NILÓPOLIS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3611, 'NITERÓI' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3612, 'NOVA FRIBURGO', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3613, 'NOVA IGUAÇU' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3614, 'PARACAMBI' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3615, 'PARAÍBA DO SUL' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3616, 'PARATI', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3617, 'PATY DO ALFERES', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3618, 'PETRÓPOLIS', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3619, 'PINHEIRAL' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3620, 'PIRAÍ', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3621, 'PORCIÚNCULA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3622, 'PORTO REAL', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3623, 'QUATIS', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3624, 'QUEIMADOS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3625, 'QUISSAMÃ', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3626, 'RESENDE' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3627, 'RIO BONITO', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3628, 'RIO CLARO' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3629, 'RIO DAS FLORES' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3630, 'RIO DAS OSTRAS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3631, 'RIO DE JANEIRO' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3632, 'SANTA MARIA MADALENA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3633, 'SANTO ANTÔNIO DE PÁDUA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3634, 'SÃO FIDÉLIS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3635, 'SÃO FRANCISCO DE ITABAPOANA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3636, 'SÃO GONÇALO' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3637, 'SÃO JOÃO DA BARRA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3638, 'SÃO JOÃO DE MERITI', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3639, 'SÃO JOSÉ DE UBÁ', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3640, 'SÃO JOSÉ DO VALE DO RIO PRETO' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3641, 'SÃO PEDRO DA ALDEIA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3642, 'SÃO SEBASTIÃO DO ALTO', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3643, 'SAPUCAIA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3644, 'SAQUAREMA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3645, 'SEROPÉDICA', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3646, 'SILVA JARDIM', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3647, 'SUMIDOURO' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3648, 'TANGUÁ', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3649, 'TERESÓPOLIS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3650, 'TRAJANO DE MORAIS', 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3651, 'TRÊS RIOS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3652, 'VALENÇA' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3653, 'VARRE-SAI' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3654, 'VASSOURAS' , 03);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3655, 'VOLTA REDONDA', 03);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3656, 'ACARI', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3657, 'AÇU', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3658, 'AFONSO BEZERRA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3659, 'ÁGUA NOVA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3660, 'ALEXANDRIA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3661, 'ALMINO AFONSO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3662, 'ALTO DO RODRIGUES', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3663, 'ANGICOS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3664, 'ANTÔNIO MARTINS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3665, 'APODI', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3666, 'AREIA BRANCA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3667, 'ARÊS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3668, 'AUGUSTO SEVERO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3669, 'BAÍA FORMOSA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3670, 'BARAÚNA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3671, 'BARCELONA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3672, 'BENTO FERNANDES', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3673, 'BODÓ' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3674, 'BOM JESUS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3675, 'BREJINHO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3676, 'CAIÇARA DO NORTE' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3677, 'CAIÇARA DO RIO DO VENTO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3678, 'CAICÓ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3679, 'CAMPO REDONDO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3680, 'CANGUARETAMA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3681, 'CARAÚBAS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3682, 'CARNAÚBA DOS DANTAS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3683, 'CARNAUBAIS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3684, 'CEARÁ-MIRIM' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3685, 'CERRO CORÁ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3686, 'CORONEL EZEQUIEL' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3687, 'CORONEL JOÃO PESSOA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3688, 'CRUZETA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3689, 'CURRAIS NOVOS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3690, 'DOUTOR SEVERIANO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3691, 'ENCANTO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3692, 'EQUADOR' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3693, 'ESPÍRITO SANTO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3694, 'EXTREMOZ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3695, 'FELIPE GUERRA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3696, 'FERNANDO PEDROZA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3697, 'FLORÂNIA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3698, 'FRANCISCO DANTAS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3699, 'FRUTUOSO GOMES' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3700, 'GALINHOS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3701, 'GOIANINHA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3702, 'GOVERNADOR DIX-SEPT ROSADO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3703, 'GROSSOS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3704, 'GUAMARÉ' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3705, 'IELMO MARINHO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3706, 'IPANGUAÇU' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3707, 'IPUEIRA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3708, 'ITAJÁ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3709, 'ITAÚ' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3710, 'JAÇANÃ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3711, 'JANDAÍRA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3712, 'JANDUÍS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3713, 'JANUÁRIO CICCO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3714, 'JAPI' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3715, 'JARDIM DE ANGICOS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3716, 'JARDIM DE PIRANHAS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3717, 'JARDIM DO SERIDÓ' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3718, 'JOÃO CÂMARA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3719, 'JOÃO DIAS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3720, 'JOSÉ DA PENHA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3721, 'JUCURUTU', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3722, 'LAGOA D`ANTA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3723, 'LAGOA DE PEDRAS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3724, 'LAGOA DE VELHOS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3725, 'LAGOA NOVA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3726, 'LAGOA SALGADA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3727, 'LAJES', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3728, 'LAJES PINTADAS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3729, 'LUCRÉCIA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3730, 'LUÍS GOMES', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3731, 'MACAÍBA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3732, 'MACAU', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3733, 'MAJOR SALES' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3734, 'MARCELINO VIEIRA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3735, 'MARTINS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3736, 'MAXARANGUAPE', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3737, 'MESSIAS TARGINO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3738, 'MONTANHAS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3739, 'MONTE ALEGRE', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3740, 'MONTE DAS GAMELEIRAS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3741, 'MOSSORÓ' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3742, 'NATAL', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3743, 'NÍSIA FLORESTA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3744, 'NOVA CRUZ' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3745, 'OLHO-D`ÁGUA DO BORGES', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3746, 'OURO BRANCO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3747, 'PARANÁ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3748, 'PARAÚ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3749, 'PARAZINHO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3750, 'PARELHAS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3751, 'PARNAMIRIM', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3752, 'PASSA E FICA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3753, 'PASSAGEM', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3754, 'PATU' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3755, 'PAU DOS FERROS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3756, 'PEDRA GRANDE', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3757, 'PEDRA PRETA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3758, 'PEDRO AVELINO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3759, 'PEDRO VELHO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3760, 'PENDÊNCIAS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3761, 'PILÕES', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3762, 'POÇO BRANCO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3763, 'PORTALEGRE', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3764, 'PORTO DO MANGUE', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3765, 'PRESIDENTE JUSCELINO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3766, 'PUREZA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3767, 'RAFAEL FERNANDES' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3768, 'RAFAEL GODEIRO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3769, 'RIACHO DA CRUZ' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3770, 'RIACHO DE SANTANA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3771, 'RIACHUELO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3772, 'RIO DO FOGO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3773, 'RODOLFO FERNANDES', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3774, 'RUY BARBOSA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3775, 'SANTA CRUZ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3776, 'SANTA MARIA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3777, 'SANTANA DO MATOS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3778, 'SANTANA DO SERIDÓ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3779, 'SANTO ANTÔNIO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3780, 'SÃO BENTO DO NORTE', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3781, 'SÃO BENTO DO TRAIRÍ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3782, 'SÃO FERNANDO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3783, 'SÃO FRANCISCO DO OESTE' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3784, 'SÃO GONÇALO DO AMARANTE', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3785, 'SÃO JOÃO DO SABUGI', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3786, 'SÃO JOSÉ DE MIPIBU', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3787, 'SÃO JOSÉ DO CAMPESTRE', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3788, 'SÃO JOSÉ DO SERIDÓ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3789, 'SÃO MIGUEL', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3790, 'SÃO MIGUEL DE TOUROS' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3791, 'SÃO PAULO DO POTENGI' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3792, 'SÃO PEDRO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3793, 'SÃO RAFAEL', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3794, 'SÃO TOMÉ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3795, 'SÃO VICENTE' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3796, 'SENADOR ELÓI DE SOUZA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3797, 'SENADOR GEORGINO AVELINO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3798, 'SERRA DE SÃO BENTO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3799, 'SERRA DO MEL', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3800, 'SERRA NEGRA DO NORTE' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3801, 'SERRINHA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3802, 'SERRINHA DOS PINTOS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3803, 'SEVERIANO MELO' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3804, 'SÍTIO NOVO', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3805, 'TABOLEIRO GRANDE' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3806, 'TAIPU', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3807, 'TANGARÁ' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3808, 'TENENTE ANANIAS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3809, 'TENENTE LAURENTINO CRUZ', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3810, 'TIBAU', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3811, 'TIBAU DO SUL', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3812, 'TIMBAÚBA DOS BATISTAS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3813, 'TOUROS', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3814, 'TRIUNFO POTIGUAR' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3815, 'UMARIZAL', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3816, 'UPANEMA' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3817, 'VÁRZEA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3818, 'VENHA-VER' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3819, 'VERA CRUZ' , 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3820, 'VIÇOSA', 22);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3821, 'VILA FLOR' , 22);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3822, 'ÁGUA SANTA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3823, 'AGUDO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3824, 'AJURICABA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3825, 'ALECRIM' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3826, 'ALEGRETE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3827, 'ALEGRIA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3828, 'ALPESTRE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3829, 'ALTO ALEGRE' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3830, 'ALTO FELIZ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3831, 'ALVORADA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3832, 'AMARAL FERRADOR', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3833, 'AMETISTA DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3834, 'ANDRÉ DA ROCHA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3835, 'ANTA GORDA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3836, 'ANTÔNIO PRADO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3837, 'ARAMBARÉ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3838, 'ARARICÁ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3839, 'ARATIBA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3840, 'ARROIO DO MEIO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3841, 'ARROIO DO SAL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3842, 'ARROIO DO TIGRE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3843, 'ARROIO DOS RATOS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3844, 'ARROIO GRANDE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3845, 'ARVOREZINHA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3846, 'AUGUSTO PESTANA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3847, 'ÁUREA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3848, 'BAGÉ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3849, 'BALNEÁRIO PINHAL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3850, 'BARÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3851, 'BARÃO DE COTEGIPE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3852, 'BARÃO DO TRIUNFO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3853, 'BARRA DO GUARITA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3854, 'BARRA DO QUARAÍ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3855, 'BARRA DO RIBEIRO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3856, 'BARRA DO RIO AZUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3857, 'BARRA FUNDA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3858, 'BARRACÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3859, 'BARROS CASSAL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3860, 'BENJAMIN CONSTANT DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3861, 'BENTO GONÇALVES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3862, 'BOA VISTA DAS MISSÕES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3863, 'BOA VISTA DO BURICÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3864, 'BOA VISTA DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3865, 'BOM JESUS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3866, 'BOM PRINCÍPIO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3867, 'BOM PROGRESSO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3868, 'BOM RETIRO DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3869, 'BOQUEIRÃO DO LEÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3870, 'BOSSOROCA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3871, 'BRAGA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3872, 'BROCHIER', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3873, 'BUTIÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3874, 'CAÇAPAVA DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3875, 'CACEQUI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3876, 'CACHOEIRA DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3877, 'CACHOEIRINHA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3878, 'CACIQUE DOBLE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3879, 'CAIBATÉ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3880, 'CAIÇARA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3881, 'CAMAQUÃ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3882, 'CAMARGO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3883, 'CAMBARÁ DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3884, 'CAMPESTRE DA SERRA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3885, 'CAMPINA DAS MISSÕES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3886, 'CAMPINAS DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3887, 'CAMPO BOM' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3888, 'CAMPO NOVO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3889, 'CAMPOS BORGES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3890, 'CANDELÁRIA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3891, 'CÂNDIDO GODÓI', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3892, 'CANDIOTA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3893, 'CANELA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3894, 'CANGUÇU' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3895, 'CANOAS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3896, 'CAPÃO DA CANOA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3897, 'CAPÃO DO LEÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3898, 'CAPELA DE SANTANA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3899, 'CAPITÃO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3900, 'CAPIVARI DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3901, 'CARAÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3902, 'CARAZINHO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3903, 'CARLOS BARBOSA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3904, 'CARLOS GOMES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3905, 'CASCA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3906, 'CASEIROS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3907, 'CATUÍPE' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3908, 'CAXIAS DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3909, 'CENTENÁRIO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3910, 'CERRITO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3911, 'CERRO BRANCO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3912, 'CERRO GRANDE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3913, 'CERRO GRANDE DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3914, 'CERRO LARGO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3915, 'CHAPADA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3916, 'CHARQUEADAS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3917, 'CHARRUA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3918, 'CHIAPETA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3919, 'CHUÍ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3920, 'CHUVISCA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3921, 'CIDREIRA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3922, 'CIRÍACO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3923, 'COLINAS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3924, 'COLORADO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3925, 'CONDOR', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3926, 'CONSTANTINA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3927, 'COQUEIROS DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3928, 'CORONEL BARROS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3929, 'CORONEL BICACO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3930, 'COTIPORÃ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3931, 'COXILHA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3932, 'CRISSIUMAL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3933, 'CRISTAL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3934, 'CRISTAL DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3935, 'CRUZ ALTA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3936, 'CRUZEIRO DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3937, 'DAVID CANABARRO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3938, 'DERRUBADAS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3939, 'DEZESSEIS DE NOVEMBRO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3940, 'DILERMANDO DE AGUIAR' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3941, 'DOIS IRMÃOS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3942, 'DOIS IRMÃOS DAS MISSÕES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3943, 'DOIS LAJEADOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3944, 'DOM FELICIANO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3945, 'DOM PEDRITO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3946, 'DOM PEDRO DE ALCÂNTARA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3947, 'DONA FRANCISCA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3948, 'DOUTOR MAURÍCIO CARDOSO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3949, 'DOUTOR RICARDO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3950, 'ELDORADO DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3951, 'ENCANTADO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3952, 'ENCRUZILHADA DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3953, 'ENGENHO VELHO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3954, 'ENTRE RIOS DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3955, 'ENTRE-IJUÍS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3956, 'EREBANGO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3957, 'ERECHIM' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3958, 'ERNESTINA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3959, 'ERVAL GRANDE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3960, 'ERVAL SECO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3961, 'ESMERALDA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3962, 'ESPERANÇA DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3963, 'ESPUMOSO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3964, 'ESTAÇÃO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3965, 'ESTÂNCIA VELHA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3966, 'ESTEIO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3967, 'ESTRELA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3968, 'ESTRELA VELHA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3969, 'EUGÊNIO DE CASTRO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3970, 'FAGUNDES VARELA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3971, 'FARROUPILHA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3972, 'FAXINAL DO SOTURNO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3973, 'FAXINALZINHO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3974, 'FAZENDA VILANOVA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3975, 'FELIZ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3976, 'FLORES DA CUNHA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3977, 'FLORIANO PEIXOTO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3978, 'FONTOURA XAVIER', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3979, 'FORMIGUEIRO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3980, 'FORTALEZA DOS VALOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3981, 'FREDERICO WESTPHALEN' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3982, 'GARIBALDI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3983, 'GARRUCHOS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3984, 'GAURAMA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3985, 'GENERAL CÂMARA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3986, 'GENTIL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3987, 'GETÚLIO VARGAS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3988, 'GIRUÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3989, 'GLORINHA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3990, 'GRAMADO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3991, 'GRAMADO DOS LOUREIROS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3992, 'GRAMADO XAVIER' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3993, 'GRAVATAÍ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3994, 'GUABIJU' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3995, 'GUAÍBA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3996, 'GUAPORÉ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3997, 'GUARANI DAS MISSÕES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3998, 'HARMONIA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (3999, 'HERVAL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4000, 'HERVEIRAS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4001, 'HORIZONTINA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4002, 'HULHA NEGRA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4003, 'HUMAITÁ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4004, 'IBARAMA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4005, 'IBIAÇÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4006, 'IBIRAIARAS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4007, 'IBIRAPUITÃ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4008, 'IBIRUBÁ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4009, 'IGREJINHA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4010, 'IJUÍ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4011, 'ILÓPOLIS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4012, 'IMBÉ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4013, 'IMIGRANTE' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4014, 'INDEPENDÊNCIA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4015, 'INHACORÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4016, 'IPÊ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4017, 'IPIRANGA DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4018, 'IRAÍ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4019, 'ITAARA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4020, 'ITACURUBI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4021, 'ITAPUCA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4022, 'ITAQUI', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4023, 'ITATIBA DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4024, 'IVORÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4025, 'IVOTI', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4026, 'JABOTICABA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4027, 'JACUTINGA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4028, 'JAGUARÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4029, 'JAGUARI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4030, 'JAQUIRANA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4031, 'JARI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4032, 'JÓIA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4033, 'JÚLIO DE CASTILHOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4034, 'LAGOA DOS TRÊS CANTOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4035, 'LAGOA VERMELHA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4036, 'LAGOÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4037, 'LAJEADO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4038, 'LAJEADO DO BUGRE' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4039, 'LAVRAS DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4040, 'LIBERATO SALZANO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4041, 'LINDOLFO COLLOR', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4042, 'LINHA NOVA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4043, 'MAÇAMBARA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4044, 'MACHADINHO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4045, 'MAMPITUBA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4046, 'MANOEL VIANA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4047, 'MAQUINÉ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4048, 'MARATÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4049, 'MARAU', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4050, 'MARCELINO RAMOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4051, 'MARIANA PIMENTEL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4052, 'MARIANO MORO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4053, 'MARQUES DE SOUZA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4054, 'MATA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4055, 'MATO CASTELHANO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4056, 'MATO LEITÃO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4057, 'MAXIMILIANO DE ALMEIDA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4058, 'MINAS DO LEÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4059, 'MIRAGUAÍ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4060, 'MONTAURI', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4061, 'MONTE ALEGRE DOS CAMPOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4062, 'MONTE BELO DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4063, 'MONTENEGRO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4064, 'MORMAÇO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4065, 'MORRINHOS DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4066, 'MORRO REDONDO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4067, 'MORRO REUTER', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4068, 'MOSTARDAS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4069, 'MUÇUM', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4070, 'MUITOS CAPÕES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4071, 'MULITERNO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4072, 'NÃO-ME-TOQUE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4073, 'NICOLAU VERGUEIRO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4074, 'NONOAI', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4075, 'NOVA ALVORADA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4076, 'NOVA ARAÇÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4077, 'NOVA BASSANO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4078, 'NOVA BOA VISTA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4079, 'NOVA BRÉSCIA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4080, 'NOVA CANDELÁRIA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4081, 'NOVA ESPERANÇA DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4082, 'NOVA HARTZ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4083, 'NOVA PÁDUA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4084, 'NOVA PALMA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4085, 'NOVA PETRÓPOLIS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4086, 'NOVA PRATA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4087, 'NOVA RAMADA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4088, 'NOVA ROMA DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4089, 'NOVA SANTA RITA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4090, 'NOVO BARREIRO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4091, 'NOVO CABRAIS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4092, 'NOVO HAMBURGO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4093, 'NOVO MACHADO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4094, 'NOVO TIRADENTES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4095, 'OSÓRIO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4096, 'PAIM FILHO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4097, 'PALMARES DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4098, 'PALMEIRA DAS MISSÕES' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4099, 'PALMITINHO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4100, 'PANAMBI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4101, 'PANTANO GRANDE' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4102, 'PARAÍ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4103, 'PARAÍSO DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4104, 'PARECI NOVO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4105, 'PAROBÉ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4106, 'PASSA SETE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4107, 'PASSO DO SOBRADO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4108, 'PASSO FUNDO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4109, 'PAVERAMA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4110, 'PEDRO OSÓRIO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4111, 'PEJUÇARA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4112, 'PELOTAS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4113, 'PICADA CAFÉ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4114, 'PINHAL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4115, 'PINHAL GRANDE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4116, 'PINHEIRINHO DO VALE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4117, 'PINHEIRO MACHADO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4118, 'PIRAPÓ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4119, 'PIRATINI', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4120, 'PLANALTO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4121, 'POÇO DAS ANTAS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4122, 'PONTÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4123, 'PONTE PRETA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4124, 'PORTÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4125, 'PORTO ALEGRE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4126, 'PORTO LUCENA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4127, 'PORTO MAUÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4128, 'PORTO VERA CRUZ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4129, 'PORTO XAVIER', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4130, 'POUSO NOVO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4131, 'PRESIDENTE LUCENA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4132, 'PROGRESSO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4133, 'PROTÁSIO ALVES' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4134, 'PUTINGA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4135, 'QUARAÍ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4136, 'QUEVEDOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4137, 'QUINZE DE NOVEMBRO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4138, 'REDENTORA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4139, 'RELVADO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4140, 'RESTINGA SECA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4141, 'RIO DOS ÍNDIOS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4142, 'RIO GRANDE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4143, 'RIO PARDO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4144, 'RIOZINHO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4145, 'ROCA SALES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4146, 'RODEIO BONITO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4147, 'ROLANTE' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4148, 'RONDA ALTA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4149, 'RONDINHA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4150, 'ROQUE GONZALES' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4151, 'ROSÁRIO DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4152, 'SAGRADA FAMÍLIA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4153, 'SALDANHA MARINHO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4154, 'SALTO DO JACUÍ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4155, 'SALVADOR DAS MISSÕES' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4156, 'SALVADOR DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4157, 'SANANDUVA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4158, 'SANTA BÁRBARA DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4159, 'SANTA CLARA DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4160, 'SANTA CRUZ DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4161, 'SANTA MARIA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4162, 'SANTA MARIA DO HERVAL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4163, 'SANTA ROSA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4164, 'SANTA TEREZA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4165, 'SANTA VITÓRIA DO PALMAR', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4166, 'SANTANA DA BOA VISTA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4167, 'SANTANA DO LIVRAMENTO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4168, 'SANTIAGO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4169, 'SANTO ÂNGELO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4170, 'SANTO ANTÔNIO DA PATRULHA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4171, 'SANTO ANTÔNIO DAS MISSÕES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4172, 'SANTO ANTÔNIO DO PALMA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4173, 'SANTO ANTÔNIO DO PLANALTO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4174, 'SANTO AUGUSTO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4175, 'SANTO CRISTO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4176, 'SANTO EXPEDITO DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4177, 'SÃO BORJA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4178, 'SÃO DOMINGOS DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4179, 'SÃO FRANCISCO DE ASSIS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4180, 'SÃO FRANCISCO DE PAULA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4181, 'SÃO GABRIEL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4182, 'SÃO JERÔNIMO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4183, 'SÃO JOÃO DA URTIGA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4184, 'SÃO JOÃO DO POLÊSINE' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4185, 'SÃO JORGE' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4186, 'SÃO JOSÉ DAS MISSÕES' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4187, 'SÃO JOSÉ DO HERVAL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4188, 'SÃO JOSÉ DO HORTÊNCIO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4189, 'SÃO JOSÉ DO INHACORÁ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4190, 'SÃO JOSÉ DO NORTE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4191, 'SÃO JOSÉ DO OURO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4192, 'SÃO JOSÉ DOS AUSENTES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4193, 'SÃO LEOPOLDO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4194, 'SÃO LOURENÇO DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4195, 'SÃO LUIZ GONZAGA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4196, 'SÃO MARCOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4197, 'SÃO MARTINHO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4198, 'SÃO MARTINHO DA SERRA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4199, 'SÃO MIGUEL DAS MISSÕES' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4200, 'SÃO NICOLAU' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4201, 'SÃO PAULO DAS MISSÕES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4202, 'SÃO PEDRO DA SERRA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4203, 'SÃO PEDRO DO BUTIÁ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4204, 'SÃO PEDRO DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4205, 'SÃO SEBASTIÃO DO CAÍ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4206, 'SÃO SEPÉ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4207, 'SÃO VALENTIM', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4208, 'SÃO VALENTIM DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4209, 'SÃO VALÉRIO DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4210, 'SÃO VENDELINO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4211, 'SÃO VICENTE DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4212, 'SAPIRANGA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4213, 'SAPUCAIA DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4214, 'SARANDI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4215, 'SEBERI', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4216, 'SEDE NOVA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4217, 'SEGREDO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4218, 'SELBACH' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4219, 'SENADOR SALGADO FILHO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4220, 'SENTINELA DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4221, 'SERAFINA CORRÊA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4222, 'SÉRIO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4223, 'SERTÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4224, 'SERTÃO SANTANA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4225, 'SETE DE SETEMBRO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4226, 'SEVERIANO DE ALMEIDA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4227, 'SILVEIRA MARTINS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4228, 'SINIMBU' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4229, 'SOBRADINHO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4230, 'SOLEDADE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4231, 'TABAÍ', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4232, 'TAPEJARA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4233, 'TAPERA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4234, 'TAPES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4235, 'TAQUARA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4236, 'TAQUARI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4237, 'TAQUARUÇU DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4238, 'TAVARES' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4239, 'TENENTE PORTELA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4240, 'TERRA DE AREIA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4241, 'TEUTÔNIA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4242, 'TIRADENTES DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4243, 'TOROPI', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4244, 'TORRES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4245, 'TRAMANDAÍ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4246, 'TRAVESSEIRO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4247, 'TRÊS ARROIOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4248, 'TRÊS CACHOEIRAS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4249, 'TRÊS COROAS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4250, 'TRÊS DE MAIO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4251, 'TRÊS FORQUILHAS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4252, 'TRÊS PALMEIRAS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4253, 'TRÊS PASSOS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4254, 'TRINDADE DO SUL', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4255, 'TRIUNFO' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4256, 'TUCUNDUVA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4257, 'TUNAS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4258, 'TUPANCI DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4259, 'TUPANCIRETÃ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4260, 'TUPANDI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4261, 'TUPARENDI' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4262, 'TURUÇU', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4263, 'UBIRETAMA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4264, 'UNIÃO DA SERRA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4265, 'UNISTALDA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4266, 'URUGUAIANA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4267, 'VACARIA' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4268, 'VALE DO SOL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4269, 'VALE REAL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4270, 'VALE VERDE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4271, 'VANINI', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4272, 'VENÂNCIO AIRES' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4273, 'VERA CRUZ' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4274, 'VERANÓPOLIS' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4275, 'VESPASIANO CORREA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4276, 'VIADUTOS', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4277, 'VIAMÃO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4278, 'VICENTE DUTRA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4279, 'VICTOR GRAEFF', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4280, 'VILA FLORES' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4281, 'VILA LÂNGARO', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4282, 'VILA MARIA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4283, 'VILA NOVA DO SUL' , 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4284, 'VISTA ALEGRE', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4285, 'VISTA ALEGRE DO PRATA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4286, 'VISTA GAÚCHA', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4287, 'VITÓRIA DAS MISSÕES', 23);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4288, 'XANGRI-LÁ' , 23);
									
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4289, 'ALTA FLORESTA D`OESTE', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4290, 'ALTO ALEGRE DOS PARECIS', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4291, 'ALTO PARAÍSO', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4292, 'ALVORADA D`OESTE' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4293, 'ARIQUEMES' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4294, 'BURITIS' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4295, 'CABIXI', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4296, 'CACAULÂNDIA' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4297, 'CACOAL', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4298, 'CAMPO NOVO DE RONDÔNIA' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4299, 'CANDEIAS DO JAMARI', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4300, 'CASTANHEIRAS', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4301, 'CEREJEIRAS', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4302, 'CHUPINGUAIA' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4303, 'COLORADO DO OESTE', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4304, 'CORUMBIARA', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4305, 'COSTA MARQUES', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4306, 'CUJUBIM' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4307, 'ESPIGÃO D`OESTE', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4308, 'GOVERNADOR JORGE TEIXEIRA', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4309, 'GUAJARÁ-MIRIM', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4310, 'ITAPUÃ DO OESTE', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4311, 'JARU' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4312, 'JI-PARANÁ' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4313, 'MACHADINHO D`OESTE', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4314, 'MINISTRO ANDREAZZA', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4315, 'MIRANTE DA SERRA' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4316, 'MONTE NEGRO' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4317, 'NOVA BRASILÂNDIA D`OESTE' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4318, 'NOVA MAMORÉ' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4319, 'NOVA UNIÃO', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4320, 'NOVO HORIZONTE DO OESTE', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4321, 'OURO PRETO DO OESTE', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4322, 'PARECIS' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4323, 'PIMENTA BUENO', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4324, 'PIMENTEIRAS DO OESTE' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4325, 'PORTO VELHO' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4326, 'PRESIDENTE MÉDICI', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4327, 'PRIMAVERA DE RONDÔNIA', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4328, 'RIO CRESPO', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4329, 'ROLIM DE MOURA' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4330, 'SANTA LUZIA D`OESTE', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4331, 'SÃO FELIPE D`OESTE', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4332, 'SÃO FRANCISCO DO GUAPORÉ' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4333, 'SÃO MIGUEL DO GUAPORÉ', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4334, 'SERINGUEIRAS', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4335, 'TEIXEIRÓPOLIS', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4336, 'THEOBROMA' , 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4337, 'URUPÁ', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4338, 'VALE DO ANARI', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4339, 'VALE DO PARAÍSO', 24);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4340, 'VILHENA' , 24);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4341, 'ALTO ALEGRE' , 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4342, 'AMAJARI' , 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4343, 'BOA VISTA' , 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4344, 'BONFIM', 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4345, 'CANTÁ', 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4346, 'CARACARAÍ' , 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4347, 'CAROEBE' , 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4348, 'IRACEMA' , 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4349, 'MUCAJAÍ' , 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4350, 'NORMANDIA' , 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4351, 'PACARAIMA' , 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4352, 'RORAINÓPOLIS', 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4353, 'SÃO JOÃO DA BALIZA', 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4354, 'SÃO LUIZ', 25);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4355, 'UIRAMUTÃ', 25);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4356, 'ABDON BATISTA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4357, 'ABELARDO LUZ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4358, 'AGROLÂNDIA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4359, 'AGRONÔMICA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4360, 'ÁGUA DOCE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4361, 'ÁGUAS DE CHAPECÓ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4362, 'ÁGUAS FRIAS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4363, 'ÁGUAS MORNAS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4364, 'ALFREDO WAGNER' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4365, 'ALTO BELA VISTA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4366, 'ANCHIETA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4367, 'ANGELINA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4368, 'ANITA GARIBALDI', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4369, 'ANITÁPOLIS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4370, 'ANTÔNIO CARLOS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4371, 'APIÚNA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4372, 'ARABUTÃ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4373, 'ARAQUARI', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4374, 'ARARANGUÁ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4375, 'ARMAZÉM' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4376, 'ARROIO TRINTA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4377, 'ARVOREDO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4378, 'ASCURRA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4379, 'ATALANTA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4380, 'AURORA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4381, 'BALNEÁRIO ARROIO DO SILVA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4382, 'BALNEÁRIO BARRA DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4383, 'BALNEÁRIO CAMBORIÚ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4384, 'BALNEÁRIO GAIVOTA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4385, 'BANDEIRANTE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4386, 'BARRA BONITA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4387, 'BARRA VELHA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4388, 'BELA VISTA DO TOLDO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4389, 'BELMONTE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4390, 'BENEDITO NOVO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4391, 'BIGUAÇU' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4392, 'BLUMENAU', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4393, 'BOCAINA DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4394, 'BOM JARDIM DA SERRA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4395, 'BOM JESUS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4396, 'BOM JESUS DO OESTE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4397, 'BOM RETIRO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4398, 'BOMBINHAS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4399, 'BOTUVERÁ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4400, 'BRAÇO DO NORTE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4401, 'BRAÇO DO TROMBUDO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4402, 'BRUNÓPOLIS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4403, 'BRUSQUE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4404, 'CAÇADOR' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4405, 'CAIBI', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4406, 'CALMON', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4407, 'CAMBORIÚ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4408, 'CAMPO ALEGRE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4409, 'CAMPO BELO DO SUL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4410, 'CAMPO ERÊ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4411, 'CAMPOS NOVOS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4412, 'CANELINHA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4413, 'CANOINHAS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4414, 'CAPÃO ALTO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4415, 'CAPINZAL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4416, 'CAPIVARI DE BAIXO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4417, 'CATANDUVAS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4418, 'CAXAMBU DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4419, 'CELSO RAMOS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4420, 'CERRO NEGRO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4421, 'CHAPADÃO DO LAGEADO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4422, 'CHAPECÓ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4423, 'COCAL DO SUL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4424, 'CONCÓRDIA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4425, 'CORDILHEIRA ALTA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4426, 'CORONEL FREITAS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4427, 'CORONEL MARTINS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4428, 'CORREIA PINTO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4429, 'CORUPÁ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4430, 'CRICIÚMA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4431, 'CUNHA PORÃ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4432, 'CUNHATAÍ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4433, 'CURITIBANOS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4434, 'DESCANSO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4435, 'DIONÍSIO CERQUEIRA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4436, 'DONA EMMA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4437, 'DOUTOR PEDRINHO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4438, 'ENTRE RIOS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4439, 'ERMO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4440, 'ERVAL VELHO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4441, 'FAXINAL DOS GUEDES', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4442, 'FLOR DO SERTÃO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4443, 'FLORIANÓPOLIS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4444, 'FORMOSA DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4445, 'FORQUILHINHA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4446, 'FRAIBURGO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4447, 'FREI ROGÉRIO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4448, 'GALVÃO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4449, 'GAROPABA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4450, 'GARUVA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4451, 'GASPAR', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4452, 'GOVERNADOR CELSO RAMOS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4453, 'GRÃO PARÁ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4454, 'GRAVATAL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4455, 'GUABIRUBA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4456, 'GUARACIABA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4457, 'GUARAMIRIM', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4458, 'GUARUJÁ DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4459, 'GUATAMBÚ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4460, 'HERVAL D`OESTE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4461, 'IBIAM', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4462, 'IBICARÉ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4463, 'IBIRAMA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4464, 'IÇARA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4465, 'ILHOTA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4466, 'IMARUÍ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4467, 'IMBITUBA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4468, 'IMBUIA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4469, 'INDAIAL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4470, 'IOMERÊ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4471, 'IPIRA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4472, 'IPORÃ DO OESTE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4473, 'IPUAÇU', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4474, 'IPUMIRIM', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4475, 'IRACEMINHA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4476, 'IRANI', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4477, 'IRATI', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4478, 'IRINEÓPOLIS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4479, 'ITÁ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4480, 'ITAIÓPOLIS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4481, 'ITAJAÍ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4482, 'ITAPEMA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4483, 'ITAPIRANGA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4484, 'ITAPOÁ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4485, 'ITUPORANGA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4486, 'JABORÁ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4487, 'JACINTO MACHADO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4488, 'JAGUARUNA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4489, 'JARAGUÁ DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4490, 'JARDINÓPOLIS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4491, 'JOAÇABA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4492, 'JOINVILLE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4493, 'JOSÉ BOITEUX', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4494, 'JUPIÁ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4495, 'LACERDÓPOLIS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4496, 'LAGES', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4497, 'LAGUNA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4498, 'LAJEADO GRANDE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4499, 'LAURENTINO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4500, 'LAURO MULLER', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4501, 'LEBON RÉGIS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4502, 'LEOBERTO LEAL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4503, 'LINDÓIA DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4504, 'LONTRAS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4505, 'LUIZ ALVES', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4506, 'LUZERNA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4507, 'MACIEIRA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4508, 'MAFRA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4509, 'MAJOR GERCINO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4510, 'MAJOR VIEIRA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4511, 'MARACAJÁ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4512, 'MARAVILHA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4513, 'MAREMA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4514, 'MASSARANDUBA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4515, 'MATOS COSTA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4516, 'MELEIRO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4517, 'MIRIM DOCE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4518, 'MODELO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4519, 'MONDAÍ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4520, 'MONTE CARLO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4521, 'MONTE CASTELO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4522, 'MORRO DA FUMAÇA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4523, 'MORRO GRANDE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4524, 'NAVEGANTES', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4525, 'NOVA ERECHIM', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4526, 'NOVA ITABERABA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4527, 'NOVA TRENTO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4528, 'NOVA VENEZA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4529, 'NOVO HORIZONTE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4530, 'ORLEANS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4531, 'OTACÍLIO COSTA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4532, 'OURO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4533, 'OURO VERDE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4534, 'PAIAL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4535, 'PAINEL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4536, 'PALHOÇA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4537, 'PALMA SOLA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4538, 'PALMEIRA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4539, 'PALMITOS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4540, 'PAPANDUVA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4541, 'PARAÍSO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4542, 'PASSO DE TORRES', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4543, 'PASSOS MAIA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4544, 'PAULO LOPES' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4545, 'PEDRAS GRANDES' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4546, 'PENHA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4547, 'PERITIBA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4548, 'PETROLÂNDIA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4549, 'PIÇARRAS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4550, 'PINHALZINHO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4551, 'PINHEIRO PRETO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4552, 'PIRATUBA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4553, 'PLANALTO ALEGRE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4554, 'POMERODE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4555, 'PONTE ALTA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4556, 'PONTE ALTA DO NORTE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4557, 'PONTE SERRADA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4558, 'PORTO BELO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4559, 'PORTO UNIÃO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4560, 'POUSO REDONDO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4561, 'PRAIA GRANDE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4562, 'PRESIDENTE CASTELO BRANCO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4563, 'PRESIDENTE GETÚLIO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4564, 'PRESIDENTE NEREU' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4565, 'PRINCESA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4566, 'QUILOMBO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4567, 'RANCHO QUEIMADO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4568, 'RIO DAS ANTAS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4569, 'RIO DO CAMPO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4570, 'RIO DO OESTE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4571, 'RIO DO SUL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4572, 'RIO DOS CEDROS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4573, 'RIO FORTUNA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4574, 'RIO NEGRINHO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4575, 'RIO RUFINO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4576, 'RIQUEZA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4577, 'RODEIO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4578, 'ROMELÂNDIA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4579, 'SALETE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4580, 'SALTINHO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4581, 'SALTO VELOSO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4582, 'SANGÃO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4583, 'SANTA CECÍLIA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4584, 'SANTA HELENA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4585, 'SANTA ROSA DE LIMA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4586, 'SANTA ROSA DO SUL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4587, 'SANTA TEREZINHA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4588, 'SANTA TEREZINHA DO PROGRESSO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4589, 'SANTIAGO DO SUL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4590, 'SANTO AMARO DA IMPERATRIZ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4591, 'SÃO BENTO DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4592, 'SÃO BERNARDINO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4593, 'SÃO BONIFÁCIO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4594, 'SÃO CARLOS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4595, 'SÃO CRISTOVÃO DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4596, 'SÃO DOMINGOS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4597, 'SÃO FRANCISCO DO SUL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4598, 'SÃO JOÃO BATISTA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4599, 'SÃO JOÃO DO ITAPERIÚ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4600, 'SÃO JOÃO DO OESTE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4601, 'SÃO JOÃO DO SUL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4602, 'SÃO JOAQUIM' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4603, 'SÃO JOSÉ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4604, 'SÃO JOSÉ DO CEDRO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4605, 'SÃO JOSÉ DO CERRITO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4606, 'SÃO LOURENÇO DO OESTE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4607, 'SÃO LUDGERO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4608, 'SÃO MARTINHO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4609, 'SÃO MIGUEL DA BOA VISTA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4610, 'SÃO MIGUEL DO OESTE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4611, 'SÃO PEDRO DE ALCÂNTARA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4612, 'SAUDADES', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4613, 'SCHROEDER' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4614, 'SEARA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4615, 'SERRA ALTA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4616, 'SIDERÓPOLIS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4617, 'SOMBRIO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4618, 'SUL BRASIL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4619, 'TAIÓ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4620, 'TANGARÁ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4621, 'TIGRINHOS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4622, 'TIJUCAS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4623, 'TIMBÉ DO SUL', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4624, 'TIMBÓ', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4625, 'TIMBÓ GRANDE', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4626, 'TRÊS BARRAS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4627, 'TREVISO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4628, 'TREZE DE MAIO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4629, 'TREZE TÍLIAS', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4630, 'TROMBUDO CENTRAL' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4631, 'TUBARÃO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4632, 'TUNÁPOLIS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4633, 'TURVO', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4634, 'UNIÃO DO OESTE' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4635, 'URUBICI' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4636, 'URUPEMA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4637, 'URUSSANGA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4638, 'VARGEÃO' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4639, 'VARGEM', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4640, 'VARGEM BONITA', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4641, 'VIDAL RAMOS' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4642, 'VIDEIRA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4643, 'VITOR MEIRELES' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4644, 'WITMARSUM' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4645, 'XANXERÊ' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4646, 'XAVANTINA' , 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4647, 'XAXIM', 26);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4648, 'ZORTÉA', 26);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4649, 'ADAMANTINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4650, 'ADOLFO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4651, 'AGUAÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4652, 'ÁGUAS DA PRATA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4653, 'ÁGUAS DE LINDÓIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4654, 'ÁGUAS DE SANTA BÁRBARA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4655, 'ÁGUAS DE SÃO PEDRO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4656, 'AGUDOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4657, 'ALAMBARI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4658, 'ALFREDO MARCONDES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4659, 'ALTAIR', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4660, 'ALTINÓPOLIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4661, 'ALTO ALEGRE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4662, 'ALUMÍNIO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4663, 'ÁLVARES FLORENCE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4664, 'ÁLVARES MACHADO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4665, 'ÁLVARO DE CARVALHO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4666, 'ALVINLÂNDIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4667, 'AMERICANA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4668, 'AMÉRICO BRASILIENSE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4669, 'AMÉRICO DE CAMPOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4670, 'AMPARO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4671, 'ANALÂNDIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4672, 'ANDRADINA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4673, 'ANGATUBA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4674, 'ANHEMBI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4675, 'ANHUMAS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4676, 'APARECIDA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4677, 'APARECIDA D`OESTE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4678, 'APIAÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4679, 'ARAÇARIGUAMA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4680, 'ARAÇATUBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4681, 'ARAÇOIABA DA SERRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4682, 'ARAMINA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4683, 'ARANDU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4684, 'ARAPEÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4685, 'ARARAQUARA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4686, 'ARARAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4687, 'ARCO-ÍRIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4688, 'AREALVA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4689, 'AREIAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4690, 'AREIÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4691, 'ARIRANHA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4692, 'ARTUR NOGUEIRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4693, 'ARUJÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4694, 'ASPÁSIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4695, 'ASSIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4696, 'ATIBAIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4697, 'AURIFLAMA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4698, 'AVAÍ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4699, 'AVANHANDAVA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4700, 'AVARÉ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4701, 'BADY BASSITT', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4702, 'BALBINOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4703, 'BÁLSAMO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4704, 'BANANAL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4705, 'BARÃO DE ANTONINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4706, 'BARBOSA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4707, 'BARIRI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4708, 'BARRA BONITA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4709, 'BARRA DO CHAPÉU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4710, 'BARRA DO TURVO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4711, 'BARRETOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4712, 'BARRINHA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4713, 'BARUERI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4714, 'BASTOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4715, 'BATATAIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4716, 'BAURU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4717, 'BEBEDOURO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4718, 'BENTO DE ABREU' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4719, 'BERNARDINO DE CAMPOS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4720, 'BERTIOGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4721, 'BILAC', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4722, 'BIRIGUI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4723, 'BIRITIBA-MIRIM' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4724, 'BOA ESPERANÇA DO SUL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4725, 'BOCAINA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4726, 'BOFETE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4727, 'BOITUVA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4728, 'BOM JESUS DOS PERDÕES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4729, 'BOM SUCESSO DE ITARARÉ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4730, 'BORÁ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4731, 'BORACÉIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4732, 'BORBOREMA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4733, 'BOREBI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4734, 'BOTUCATU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4735, 'BRAGANÇA PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4736, 'BRAÚNA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4737, 'BREJO ALEGRE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4738, 'BRODOWSKI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4739, 'BROTAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4740, 'BURI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4741, 'BURITAMA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4742, 'BURITIZAL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4743, 'CABRÁLIA PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4744, 'CABREÚVA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4745, 'CAÇAPAVA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4746, 'CACHOEIRA PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4747, 'CACONDE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4748, 'CAFELÂNDIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4749, 'CAIABU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4750, 'CAIEIRAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4751, 'CAIUÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4752, 'CAJAMAR' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4753, 'CAJATI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4754, 'CAJOBI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4755, 'CAJURU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4756, 'CAMPINA DO MONTE ALEGRE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4757, 'CAMPINAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4758, 'CAMPO LIMPO PAULISTA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4759, 'CAMPOS DO JORDÃO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4760, 'CAMPOS NOVOS PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4761, 'CANANÉIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4762, 'CANAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4763, 'CÂNDIDO MOTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4764, 'CÂNDIDO RODRIGUES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4765, 'CANITAR' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4766, 'CAPÃO BONITO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4767, 'CAPELA DO ALTO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4768, 'CAPIVARI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4769, 'CARAGUATATUBA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4770, 'CARAPICUÍBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4771, 'CARDOSO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4772, 'CASA BRANCA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4773, 'CÁSSIA DOS COQUEIROS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4774, 'CASTILHO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4775, 'CATANDUVA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4776, 'CATIGUÁ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4777, 'CEDRAL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4778, 'CERQUEIRA CÉSAR', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4779, 'CERQUILHO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4780, 'CESÁRIO LANGE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4781, 'CHARQUEADA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4782, 'CHAVANTES' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4783, 'CLEMENTINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4784, 'COLINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4785, 'COLÔMBIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4786, 'CONCHAL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4787, 'CONCHAS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4788, 'CORDEIRÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4789, 'COROADOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4790, 'CORONEL MACEDO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4791, 'CORUMBATAÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4792, 'COSMÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4793, 'COSMORAMA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4794, 'COTIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4795, 'CRAVINHOS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4796, 'CRISTAIS PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4797, 'CRUZÁLIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4798, 'CRUZEIRO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4799, 'CUBATÃO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4800, 'CUNHA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4801, 'DESCALVADO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4802, 'DIADEMA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4803, 'DIRCE REIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4804, 'DIVINOLÂNDIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4805, 'DOBRADA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4806, 'DOIS CÓRREGOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4807, 'DOLCINÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4808, 'DOURADO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4809, 'DRACENA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4810, 'DUARTINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4811, 'DUMONT', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4812, 'ECHAPORÃ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4813, 'ELDORADO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4814, 'ELIAS FAUSTO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4815, 'ELISIÁRIO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4816, 'EMBAÚBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4817, 'EMBU' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4818, 'EMBU-GUAÇU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4819, 'EMILIANÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4820, 'ENGENHEIRO COELHO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4821, 'ESPÍRITO SANTO DO PINHAL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4822, 'ESPÍRITO SANTO DO TURVO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4823, 'ESTIVA GERBI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4824, 'ESTRELA D`OESTE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4825, 'ESTRELA DO NORTE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4826, 'EUCLIDES DA CUNHA PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4827, 'FARTURA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4828, 'FERNANDO PRESTES' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4829, 'FERNANDÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4830, 'FERNÃO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4831, 'FERRAZ DE VASCONCELOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4832, 'FLORA RICA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4833, 'FLOREAL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4834, 'FLORÍNIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4835, 'FLÓRIDA PAULISTA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4836, 'FRANCA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4837, 'FRANCISCO MORATO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4838, 'FRANCO DA ROCHA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4839, 'GABRIEL MONTEIRO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4840, 'GÁLIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4841, 'GARÇA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4842, 'GASTÃO VIDIGAL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4843, 'GAVIÃO PEIXOTO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4844, 'GENERAL SALGADO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4845, 'GETULINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4846, 'GLICÉRIO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4847, 'GUAIÇARA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4848, 'GUAIMBÊ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4849, 'GUAÍRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4850, 'GUAPIAÇU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4851, 'GUAPIARA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4852, 'GUARÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4853, 'GUARAÇAÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4854, 'GUARACI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4855, 'GUARANI D`OESTE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4856, 'GUARANTÃ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4857, 'GUARARAPES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4858, 'GUARAREMA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4859, 'GUARATINGUETÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4860, 'GUAREÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4861, 'GUARIBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4862, 'GUARUJÁ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4863, 'GUARULHOS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4864, 'GUATAPARÁ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4865, 'GUZOLÂNDIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4866, 'HERCULÂNDIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4867, 'HOLAMBRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4868, 'HORTOLÂNDIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4869, 'IACANGA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4870, 'IACRI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4871, 'IARAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4872, 'IBATÉ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4873, 'IBIRÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4874, 'IBIRAREMA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4875, 'IBITINGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4876, 'IBIÚNA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4877, 'ICÉM' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4878, 'IEPÊ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4879, 'IGARAÇU DO TIETÊ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4880, 'IGARAPAVA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4881, 'IGARATÁ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4882, 'IGUAPE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4883, 'ILHA COMPRIDA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4884, 'ILHA SOLTEIRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4885, 'ILHABELA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4886, 'INDAIATUBA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4887, 'INDIANA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4888, 'INDIAPORÃ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4889, 'INÚBIA PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4890, 'IPAUÇU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4891, 'IPERÓ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4892, 'IPEÚNA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4893, 'IPIGUÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4894, 'IPORANGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4895, 'IPUÃ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4896, 'IRACEMÁPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4897, 'IRAPUÃ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4898, 'IRAPURU' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4899, 'ITABERÁ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4900, 'ITAÍ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4901, 'ITAJOBI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4902, 'ITAJU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4903, 'ITANHAÉM', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4904, 'ITAÓCA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4905, 'ITAPECERICA DA SERRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4906, 'ITAPETININGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4907, 'ITAPEVA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4908, 'ITAPEVI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4909, 'ITAPIRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4910, 'ITAPIRAPUÃ PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4911, 'ITÁPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4912, 'ITAPORANGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4913, 'ITAPUÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4914, 'ITAPURA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4915, 'ITAQUAQUECETUBA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4916, 'ITARARÉ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4917, 'ITARIRI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4918, 'ITATIBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4919, 'ITATINGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4920, 'ITIRAPINA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4921, 'ITIRAPUÃ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4922, 'ITOBI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4923, 'ITU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4924, 'ITUPEVA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4925, 'ITUVERAVA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4926, 'JABORANDI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4927, 'JABOTICABAL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4928, 'JACAREÍ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4929, 'JACI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4930, 'JACUPIRANGA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4931, 'JAGUARIÚNA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4932, 'JALES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4933, 'JAMBEIRO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4934, 'JANDIRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4935, 'JARDINÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4936, 'JARINU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4937, 'JAÚ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4938, 'JERIQUARA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4939, 'JOANÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4940, 'JOÃO RAMALHO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4941, 'JOSÉ BONIFÁCIO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4942, 'JÚLIO MESQUITA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4943, 'JUMIRIM' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4944, 'JUNDIAÍ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4945, 'JUNQUEIRÓPOLIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4946, 'JUQUIÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4947, 'JUQUITIBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4948, 'LAGOINHA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4949, 'LARANJAL PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4950, 'LAVÍNIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4951, 'LAVRINHAS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4952, 'LEME' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4953, 'LENÇÓIS PAULISTA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4954, 'LIMEIRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4955, 'LINDÓIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4956, 'LINS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4957, 'LORENA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4958, 'LOURDES' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4959, 'LOUVEIRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4960, 'LUCÉLIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4961, 'LUCIANÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4962, 'LUÍS ANTÔNIO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4963, 'LUIZIÂNIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4964, 'LUPÉRCIO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4965, 'LUTÉCIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4966, 'MACATUBA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4967, 'MACAUBAL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4968, 'MACEDÔNIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4969, 'MAGDA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4970, 'MAIRINQUE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4971, 'MAIRIPORÃ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4972, 'MANDURI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4973, 'MARABÁ PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4974, 'MARACAÍ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4975, 'MARAPOAMA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4976, 'MARIÁPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4977, 'MARÍLIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4978, 'MARINÓPOLIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4979, 'MARTINÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4980, 'MATÃO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4981, 'MAUÁ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4982, 'MENDONÇA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4983, 'MERIDIANO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4984, 'MESÓPOLIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4985, 'MIGUELÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4986, 'MINEIROS DO TIETÊ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4987, 'MIRA ESTRELA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4988, 'MIRACATU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4989, 'MIRANDÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4990, 'MIRANTE DO PARANAPANEMA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4991, 'MIRASSOL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4992, 'MIRASSOLÂNDIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4993, 'MOCOCA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4994, 'MOGI DAS CRUZES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4995, 'MOGI GUAÇU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4996, 'MOGI-MIRIM', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4997, 'MOMBUCA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4998, 'MONÇÕES' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (4999, 'MONGAGUÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5000, 'MONTE ALEGRE DO SUL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5001, 'MONTE ALTO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5002, 'MONTE APRAZÍVEL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5003, 'MONTE AZUL PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5004, 'MONTE CASTELO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5005, 'MONTE MOR' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5006, 'MONTEIRO LOBATO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5007, 'MORRO AGUDO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5008, 'MORUNGABA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5009, 'MOTUCA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5010, 'MURUTINGA DO SUL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5011, 'NANTES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5012, 'NARANDIBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5013, 'NATIVIDADE DA SERRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5014, 'NAZARÉ PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5015, 'NEVES PAULISTA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5016, 'NHANDEARA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5017, 'NIPOÃ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5018, 'NOVA ALIANÇA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5019, 'NOVA CAMPINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5020, 'NOVA CANAÃ PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5021, 'NOVA CASTILHO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5022, 'NOVA EUROPA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5023, 'NOVA GRANADA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5024, 'NOVA GUATAPORANGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5025, 'NOVA INDEPENDÊNCIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5026, 'NOVA LUZITÂNIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5027, 'NOVA ODESSA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5028, 'NOVAIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5029, 'NOVO HORIZONTE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5030, 'NUPORANGA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5031, 'OCAUÇU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5032, 'ÓLEO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5033, 'OLÍMPIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5034, 'ONDA VERDE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5035, 'ORIENTE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5036, 'ORINDIÚVA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5037, 'ORLÂNDIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5038, 'OSASCO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5039, 'OSCAR BRESSANE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5040, 'OSVALDO CRUZ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5041, 'OURINHOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5042, 'OURO VERDE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5043, 'OUROESTE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5044, 'PACAEMBU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5045, 'PALESTINA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5046, 'PALMARES PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5047, 'PALMEIRA D`OESTE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5048, 'PALMITAL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5049, 'PANORAMA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5050, 'PARAGUAÇU PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5051, 'PARAIBUNA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5052, 'PARAÍSO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5053, 'PARANAPANEMA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5054, 'PARANAPUÃ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5055, 'PARAPUÃ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5056, 'PARDINHO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5057, 'PARIQUERA-AÇU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5058, 'PARISI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5059, 'PATROCÍNIO PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5060, 'PAULICÉIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5061, 'PAULÍNIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5062, 'PAULISTÂNIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5063, 'PAULO DE FARIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5064, 'PEDERNEIRAS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5065, 'PEDRA BELA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5066, 'PEDRANÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5067, 'PEDREGULHO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5068, 'PEDREIRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5069, 'PEDRINHAS PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5070, 'PEDRO DE TOLEDO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5071, 'PENÁPOLIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5072, 'PEREIRA BARRETO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5073, 'PEREIRAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5074, 'PERUÍBE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5075, 'PIACATU' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5076, 'PIEDADE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5077, 'PILAR DO SUL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5078, 'PINDAMONHANGABA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5079, 'PINDORAMA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5080, 'PINHALZINHO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5081, 'PIQUEROBI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5082, 'PIQUETE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5083, 'PIRACAIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5084, 'PIRACICABA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5085, 'PIRAJU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5086, 'PIRAJUÍ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5087, 'PIRANGI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5088, 'PIRAPORA DO BOM JESUS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5089, 'PIRAPOZINHO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5090, 'PIRASSUNUNGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5091, 'PIRATININGA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5092, 'PITANGUEIRAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5093, 'PLANALTO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5094, 'PLATINA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5095, 'POÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5096, 'POLONI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5097, 'POMPÉIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5098, 'PONGAÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5099, 'PONTAL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5100, 'PONTALINDA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5101, 'PONTES GESTAL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5102, 'POPULINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5103, 'PORANGABA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5104, 'PORTO FELIZ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5105, 'PORTO FERREIRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5106, 'POTIM', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5107, 'POTIRENDABA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5108, 'PRACINHA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5109, 'PRADÓPOLIS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5110, 'PRAIA GRANDE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5111, 'PRATÂNIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5112, 'PRESIDENTE ALVES' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5113, 'PRESIDENTE BERNARDES' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5114, 'PRESIDENTE EPITÁCIO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5115, 'PRESIDENTE PRUDENTE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5116, 'PRESIDENTE VENCESLAU' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5117, 'PROMISSÃO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5118, 'QUADRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5119, 'QUATÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5120, 'QUEIROZ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5121, 'QUELUZ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5122, 'QUINTANA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5123, 'RAFARD', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5124, 'RANCHARIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5125, 'REDENÇÃO DA SERRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5126, 'REGENTE FEIJÓ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5127, 'REGINÓPOLIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5128, 'REGISTRO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5129, 'RESTINGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5130, 'RIBEIRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5131, 'RIBEIRÃO BONITO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5132, 'RIBEIRÃO BRANCO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5133, 'RIBEIRÃO CORRENTE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5134, 'RIBEIRÃO DO SUL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5135, 'RIBEIRÃO DOS ÍNDIOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5136, 'RIBEIRÃO GRANDE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5137, 'RIBEIRÃO PIRES' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5138, 'RIBEIRÃO PRETO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5139, 'RIFAINA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5140, 'RINCÃO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5141, 'RINÓPOLIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5142, 'RIO CLARO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5143, 'RIO DAS PEDRAS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5144, 'RIO GRANDE DA SERRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5145, 'RIOLÂNDIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5146, 'RIVERSUL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5147, 'ROSANA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5148, 'ROSEIRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5149, 'RUBIÁCEA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5150, 'RUBINÉIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5151, 'SABINO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5152, 'SAGRES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5153, 'SALES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5154, 'SALES OLIVEIRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5155, 'SALESÓPOLIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5156, 'SALMOURÃO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5157, 'SALTINHO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5158, 'SALTO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5159, 'SALTO DE PIRAPORA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5160, 'SALTO GRANDE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5161, 'SANDOVALINA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5162, 'SANTA ADÉLIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5163, 'SANTA ALBERTINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5164, 'SANTA BÁRBARA D`OESTE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5165, 'SANTA BRANCA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5166, 'SANTA CLARA D`OESTE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5167, 'SANTA CRUZ DA CONCEIÇÃO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5168, 'SANTA CRUZ DA ESPERANÇA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5169, 'SANTA CRUZ DAS PALMEIRAS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5170, 'SANTA CRUZ DO RIO PARDO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5171, 'SANTA ERNESTINA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5172, 'SANTA FÉ DO SUL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5173, 'SANTA GERTRUDES', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5174, 'SANTA ISABEL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5175, 'SANTA LÚCIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5176, 'SANTA MARIA DA SERRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5177, 'SANTA MERCEDES' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5178, 'SANTA RITA D`OESTE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5179, 'SANTA RITA DO PASSA QUATRO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5180, 'SANTA ROSA DE VITERBO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5181, 'SANTA SALETE', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5182, 'SANTANA DA PONTE PENSA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5183, 'SANTANA DE PARNAÍBA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5184, 'SANTO ANASTÁCIO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5185, 'SANTO ANDRÉ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5186, 'SANTO ANTÔNIO DA ALEGRIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5187, 'SANTO ANTÔNIO DE POSSE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5188, 'SANTO ANTÔNIO DO ARACANGUÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5189, 'SANTO ANTÔNIO DO JARDIM', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5190, 'SANTO ANTÔNIO DO PINHAL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5191, 'SANTO EXPEDITO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5192, 'SANTÓPOLIS DO AGUAPEÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5193, 'SANTOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5194, 'SÃO BENTO DO SAPUCAÍ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5195, 'SÃO BERNARDO DO CAMPO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5196, 'SÃO CAETANO DO SUL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5197, 'SÃO CARLOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5198, 'SÃO FRANCISCO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5199, 'SÃO JOÃO DA BOA VISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5200, 'SÃO JOÃO DAS DUAS PONTES' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5201, 'SÃO JOÃO DE IRACEMA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5202, 'SÃO JOÃO DO PAU D`ALHO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5203, 'SÃO JOAQUIM DA BARRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5204, 'SÃO JOSÉ DA BELA VISTA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5205, 'SÃO JOSÉ DO BARREIRO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5206, 'SÃO JOSÉ DO RIO PARDO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5207, 'SÃO JOSÉ DO RIO PRETO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5208, 'SÃO JOSÉ DOS CAMPOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5209, 'SÃO LOURENÇO DA SERRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5210, 'SÃO LUÍS DO PARAITINGA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5211, 'SÃO MANUEL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5212, 'SÃO MIGUEL ARCANJO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5213, 'SÃO PAULO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5214, 'SÃO PEDRO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5215, 'SÃO PEDRO DO TURVO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5216, 'SÃO ROQUE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5217, 'SÃO SEBASTIÃO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5218, 'SÃO SEBASTIÃO DA GRAMA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5219, 'SÃO SIMÃO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5220, 'SÃO VICENTE' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5221, 'SARAPUÍ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5222, 'SARUTAIÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5223, 'SEBASTIANÓPOLIS DO SUL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5224, 'SERRA AZUL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5225, 'SERRA NEGRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5226, 'SERRANA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5227, 'SERTÃOZINHO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5228, 'SETE BARRAS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5229, 'SEVERÍNIA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5230, 'SILVEIRAS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5231, 'SOCORRO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5232, 'SOROCABA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5233, 'SUD MENNUCCI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5234, 'SUMARÉ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5235, 'SUZANÁPOLIS' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5236, 'SUZANO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5237, 'TABAPUÃ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5238, 'TABATINGA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5239, 'TABOÃO DA SERRA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5240, 'TACIBA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5241, 'TAGUAÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5242, 'TAIAÇU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5243, 'TAIÚVA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5244, 'TAMBAÚ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5245, 'TANABI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5246, 'TAPIRAÍ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5247, 'TAPIRATIBA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5248, 'TAQUARAL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5249, 'TAQUARITINGA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5250, 'TAQUARITUBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5251, 'TAQUARIVAÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5252, 'TARABAI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5253, 'TARUMÃ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5254, 'TATUÍ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5255, 'TAUBATÉ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5256, 'TEJUPÁ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5257, 'TEODORO SAMPAIO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5258, 'TERRA ROXA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5259, 'TIETÊ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5260, 'TIMBURI' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5261, 'TORRE DE PEDRA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5262, 'TORRINHA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5263, 'TRABIJU' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5264, 'TREMEMBÉ', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5265, 'TRÊS FRONTEIRAS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5266, 'TUIUTI', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5267, 'TUPÃ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5268, 'TUPI PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5269, 'TURIÚBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5270, 'TURMALINA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5271, 'UBARANA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5272, 'UBATUBA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5273, 'UBIRAJARA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5274, 'UCHOA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5275, 'UNIÃO PAULISTA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5276, 'URÂNIA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5277, 'URU', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5278, 'URUPÊS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5279, 'VALENTIM GENTIL', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5280, 'VALINHOS', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5281, 'VALPARAÍSO', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5282, 'VARGEM', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5283, 'VARGEM GRANDE DO SUL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5284, 'VARGEM GRANDE PAULISTA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5285, 'VÁRZEA PAULISTA', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5286, 'VERA CRUZ' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5287, 'VINHEDO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5288, 'VIRADOURO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5289, 'VISTA ALEGRE DO ALTO' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5290, 'VITÓRIA BRASIL' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5291, 'VOTORANTIM', 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5292, 'VOTUPORANGA' , 02);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5293, 'ZACARIAS', 02);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5294, 'AMPARO DE SÃO FRANCISCO', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5295, 'AQUIDABÃ', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5296, 'ARACAJU' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5297, 'ARAUÁ', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5298, 'AREIA BRANCA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5299, 'BARRA DOS COQUEIROS', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5300, 'BOQUIM', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5301, 'BREJO GRANDE', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5302, 'CAMPO DO BRITO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5303, 'CANHOBA' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5304, 'CANINDÉ DE SÃO FRANCISCO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5305, 'CAPELA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5306, 'CARIRA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5307, 'CARMÓPOLIS', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5308, 'CEDRO DE SÃO JOÃO', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5309, 'CRISTINÁPOLIS', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5310, 'CUMBE', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5311, 'DIVINA PASTORA' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5312, 'ESTÂNCIA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5313, 'FEIRA NOVA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5314, 'FREI PAULO', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5315, 'GARARU', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5316, 'GENERAL MAYNARD', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5317, 'GRACHO CARDOSO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5318, 'ILHA DAS FLORES', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5319, 'INDIAROBA' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5320, 'ITABAIANA' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5321, 'ITABAIANINHA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5322, 'ITABI', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5323, 'ITAPORANGA D`AJUDA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5324, 'JAPARATUBA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5325, 'JAPOATÃ' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5326, 'LAGARTO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5327, 'LARANJEIRAS' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5328, 'MACAMBIRA' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5329, 'MALHADA DOS BOIS' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5330, 'MALHADOR', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5331, 'MARUIM', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5332, 'MOITA BONITA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5333, 'MONTE ALEGRE DE SERGIPE', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5334, 'MURIBECA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5335, 'NEÓPOLIS', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5336, 'NOSSA SENHORA APARECIDA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5337, 'NOSSA SENHORA DA GLÓRIA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5338, 'NOSSA SENHORA DAS DORES', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5339, 'NOSSA SENHORA DE LOURDES' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5340, 'NOSSA SENHORA DO SOCORRO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5341, 'PACATUBA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5342, 'PEDRA MOLE', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5343, 'PEDRINHAS' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5344, 'PINHÃO', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5345, 'PIRAMBU' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5346, 'POÇO REDONDO', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5347, 'POÇO VERDE', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5348, 'PORTO DA FOLHA' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5349, 'PROPRIÁ' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5350, 'RIACHÃO DO DANTAS', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5351, 'RIACHUELO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5352, 'RIBEIRÓPOLIS', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5353, 'ROSÁRIO DO CATETE', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5354, 'SALGADO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5355, 'SANTA LUZIA DO ITANHY', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5356, 'SANTA ROSA DE LIMA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5357, 'SANTANA DO SÃO FRANCISCO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5358, 'SANTO AMARO DAS BROTAS' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5359, 'SÃO CRISTÓVÃO', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5360, 'SÃO DOMINGOS', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5361, 'SÃO FRANCISCO', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5362, 'SÃO MIGUEL DO ALEIXO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5363, 'SIMÃO DIAS', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5364, 'SIRIRI', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5365, 'TELHA', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5366, 'TOBIAS BARRETO' , 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5367, 'TOMAR DO GERU', 27);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5368, 'UMBAÚBA' , 27);

INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5369, 'ABREULÂNDIA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5370, 'AGUIARNÓPOLIS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5371, 'ALIANÇA DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5372, 'ALMAS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5373, 'ALVORADA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5374, 'ANANÁS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5375, 'ANGICO', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5376, 'APARECIDA DO RIO NEGRO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5377, 'ARAGOMINAS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5378, 'ARAGUACEMA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5379, 'ARAGUAÇU', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5380, 'ARAGUAÍNA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5381, 'ARAGUANÃ', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5382, 'ARAGUATINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5383, 'ARAPOEMA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5384, 'ARRAIAS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5385, 'AUGUSTINÓPOLIS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5386, 'AURORA DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5387, 'AXIXÁ DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5388, 'BABAÇULÂNDIA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5389, 'BANDEIRANTES DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5390, 'BARRA DO OURO', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5391, 'BARROLÂNDIA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5392, 'BERNARDO SAYÃO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5393, 'BOM JESUS DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5394, 'BRASILÂNDIA DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5395, 'BREJINHO DE NAZARÉ', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5396, 'BURITI DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5397, 'CACHOEIRINHA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5398, 'CAMPOS LINDOS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5399, 'CARIRI DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5400, 'CARMOLÂNDIA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5401, 'CARRASCO BONITO', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5402, 'CASEARA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5403, 'CENTENÁRIO', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5404, 'CHAPADA DA NATIVIDADE', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5405, 'CHAPADA DE AREIA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5406, 'COLINAS DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5407, 'COLMÉIA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5408, 'COMBINADO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5409, 'CONCEIÇÃO DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5410, 'COUTO DE MAGALHÃES', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5411, 'CRISTALÂNDIA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5412, 'CRIXÁS DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5413, 'DARCINÓPOLIS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5414, 'DIANÓPOLIS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5415, 'DIVINÓPOLIS DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5416, 'DOIS IRMÃOS DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5417, 'DUERÉ', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5418, 'ESPERANTINA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5419, 'FÁTIMA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5420, 'FIGUEIRÓPOLIS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5421, 'FILADÉLFIA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5422, 'FORMOSO DO ARAGUAIA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5423, 'FORTALEZA DO TABOCÃO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5424, 'GOIANORTE' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5425, 'GOIATINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5426, 'GUARAÍ', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5427, 'GURUPI', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5428, 'IPUEIRAS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5429, 'ITACAJÁ' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5430, 'ITAGUATINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5431, 'ITAPIRATINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5432, 'ITAPORÃ DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5433, 'JAÚ DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5434, 'JUARINA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5435, 'LAGOA DA CONFUSÃO', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5436, 'LAGOA DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5437, 'LAJEADO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5438, 'LAVANDEIRA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5439, 'LIZARDA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5440, 'LUZINÓPOLIS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5441, 'MARIANÓPOLIS DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5442, 'MATEIROS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5443, 'MAURILÂNDIA DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5444, 'MIRACEMA DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5445, 'MIRANORTE' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5446, 'MONTE DO CARMO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5447, 'MONTE SANTO DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5448, 'MURICILÂNDIA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5449, 'NATIVIDADE', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5450, 'NAZARÉ', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5451, 'NOVA OLINDA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5452, 'NOVA ROSALÂNDIA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5453, 'NOVO ACORDO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5454, 'NOVO ALEGRE' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5455, 'NOVO JARDIM' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5456, 'OLIVEIRA DE FÁTIMA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5457, 'PALMAS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5458, 'PALMEIRANTE' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5459, 'PALMEIRAS DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5460, 'PALMEIRÓPOLIS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5461, 'PARAÍSO DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5462, 'PARANÃ', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5463, 'PAU D`ARCO', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5464, 'PEDRO AFONSO', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5465, 'PEIXE', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5466, 'PEQUIZEIRO', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5467, 'PINDORAMA DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5468, 'PIRAQUÊ' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5469, 'PIUM' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5470, 'PONTE ALTA DO BOM JESUS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5471, 'PONTE ALTA DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5472, 'PORTO ALEGRE DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5473, 'PORTO NACIONAL' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5474, 'PRAIA NORTE' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5475, 'PRESIDENTE KENNEDY', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5476, 'PUGMIL', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5477, 'RECURSOLÂNDIA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5478, 'RIACHINHO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5479, 'RIO DA CONCEIÇÃO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5480, 'RIO DOS BOIS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5481, 'RIO SONO', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5482, 'SAMPAIO' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5483, 'SANDOLÂNDIA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5484, 'SANTA FÉ DO ARAGUAIA' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5485, 'SANTA MARIA DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5486, 'SANTA RITA DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5487, 'SANTA ROSA DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5488, 'SANTA TEREZA DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5489, 'SANTA TEREZINHA DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5490, 'SÃO BENTO DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5491, 'SÃO FÉLIX DO TOCANTINS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5492, 'SÃO MIGUEL DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5493, 'SÃO SALVADOR DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5494, 'SÃO SEBASTIÃO DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5495, 'SÃO VALÉRIO DA NATIVIDADE', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5496, 'SILVANÓPOLIS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5497, 'SÍTIO NOVO DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5498, 'SUCUPIRA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5499, 'TAGUATINGA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5500, 'TAIPAS DO TOCANTINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5501, 'TALISMÃ' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5502, 'TOCANTÍNIA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5503, 'TOCANTINÓPOLIS' , 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5504, 'TUPIRAMA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5505, 'TUPIRATINS', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5506, 'WANDERLÂNDIA', 05);
INSERT INTO CIDADES (IDCIDADE, NOMECIDADE, IDUF) VALUES (5507, 'XAMBIOÁ' , 05);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5508, 'BRAZLANDIA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5509, 'CANDANGOLANDIA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5510, 'CEILANDIA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5511, 'CRUZEIRO', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5512, 'GAMA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5513, 'GUARA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5514, 'LAGO NORTE', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5515, 'LAGO SUL', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5516, 'NUCLEO BANDEIRANTE', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5517, 'PARANOA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5518, 'PLANALTINA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5519, 'RECANTO DAS EMAS', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5520, 'RIACHO FUNDO', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5521, 'SAMAMBAIA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5522, 'SANTA MARIA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5523, 'SAO SEBASTIAO', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5524, 'SOBRADINHO', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5525, 'TAGUATINGA', 1);
INSERT INTO CIDADES (IDCIDADE,NOMECIDADE,IDUF) VALUES (5526, 'ABADIA DE GOIÁS', 4);

-- ALTERACOES ADICIONAIS PARTE 5 - CITSMART 2.0
-- SCRIPT ORIGEM: citsmart5_2.0_oracle_corrigido.sql

ALTER TABLE ENDERECO 
	MODIFY LOGRADOURO VARCHAR2(200);

ALTER TABLE INFOCATALOGOSERVICO 
	ADD NOMEINFOCATALOGOSERVICO VARCHAR2(200);

/*
FOREIGN KEY NAO EXISTE
ALTER TABLE FORNECEDORPRODUTO 
	DROP CONSTRAINT FORNECEDORPRODUTO_IBFK_1;
*/

ALTER TABLE EXTERNALCONNECTION 
	ADD DELETED CHAR(1);

ALTER TABLE CONTRATOS_HIST 
	MODIFY CRIADOPOR VARCHAR2(256) DEFAULT NULL;

ALTER TABLE CONTRATOS_HIST
	MODIFY MODIFICADOPOR VARCHAR2(256) DEFAULT NULL;

ALTER TABLE SERVICO_HIST 
	MODIFY CRIADOPOR VARCHAR2(255);
 
ALTER TABLE SERVICO_HIST 
	MODIFY MODIFICADOPOR VARCHAR2(255);


-- ALTERACOES EXTRA - CITSMART 2.0
-- SCRIPT ORIGEM: extras_citsmart_desenvolvimento_oracle.sql

ALTER TABLE ENDERECO MODIFY LOGRADOURO VARCHAR2(200) NULL;

CREATE INDEX INDEX_MENU_NOME ON MENU
(
   NOME,
   ORDEM
);
 
CREATE INDEX INDEX_MENU_LINK ON MENU
(
   LINK
);
 
CREATE INDEX INDEX_MENU_RAPIDO ON MENU
(
   MENURAPIDO
);
 
CREATE INDEX INDEX_DIC_NOME ON DICIONARIO
(
   NOME
);
 
CREATE INDEX INDEX_DIC_VALOR ON DICIONARIO
(
   VALOR
);

ALTER TABLE BPM_ELEMENTOFLUXO ADD (DESTINATARIOSEMAIL CLOB);

ALTER TABLE BPM_ITEMTRABALHOFLUXO MODIFY DATAHORAEXECUCAO TIMESTAMP;

UPDATE BPM_ITEMTRABALHOFLUXO SET DATAHORAEXECUCAO = NULL WHERE DATAHORAEXECUCAO = '0000-00-00 00:00:00';

INSERT INTO LINGUA (idlingua,nome,sigla,datainicio,datafim) VALUES (1,'Português','PT','30/01/2013',NULL);
INSERT INTO LINGUA (idlingua,nome,sigla,datainicio,datafim) VALUES (3,'Inglês','EN','30/01/2013',NULL);


-- SCRIPT PARA CRIAÇÃO O RECURSO DE AUTO INCREMENTO NO ORACLE
-- OBS: SE FOR NECESSARIO INFORMAR O ESQUEMA USE "SCHEMA"."OBJETO",
-- ENTENDA-SE A PALAVRA OBJETO COMO UMA TRIGGER, TABELA, ETC.

-- CREATE OR REPLACE TRIGGER "CITSMART"."LOGDADOS_IDLOG_TRG" BEFORE INSERT ON logdados
CREATE SEQUENCE logdados_idlog_SEQ;

CREATE OR REPLACE TRIGGER "ADMCITSMART"."LOGDADOS_IDLOG_TRG" BEFORE INSERT ON logdados
FOR EACH ROW
DECLARE
v_newVal NUMBER(12) := 0;
v_incval NUMBER(12) := 0;
BEGIN
IF INSERTING AND :new.idlog IS NULL THEN
SELECT logdados_idlog_SEQ.NEXTVAL INTO v_newVal FROM DUAL;
IF v_newVal = 1 THEN
SELECT NVL(max(idlog),0) INTO v_newVal FROM logdados;
v_newVal := v_newVal + 1;
LOOP
EXIT WHEN v_incval>=v_newVal;
SELECT logdados_idlog_SEQ.nextval INTO v_incval FROM dual;
END LOOP;
END IF;
:new.idlog := v_newVal;
END IF;
END;
/
ALTER TRIGGER "ADMCITSMART"."LOGDADOS_IDLOG_TRG" ENABLE;
-- NAO RETIRE A / ACIMA POIS SENAO A TRIGGER NAO SERA CRIADA.

-- ALTER TRIGGER "CITSMART"."LOGDADOS_IDLOG_TRG" ENABLE;
ALTER TRIGGER LOGDADOS_IDLOG_TRG ENABLE;

ALTER TABLE LIMITEALCADA MODIFY LIMITEVALORITEM NUMBER(11,2);
ALTER TABLE LIMITEALCADA MODIFY LIMITEVALORMENSAL NUMBER(11,2) DEFAULT NULL;

-- ALTERANDO O NOME DA COLUNA PARA FICAR DE ACORDO COM O BANCO DE CITSMART_HOMOLOGACAO.
ALTER TABLE PAIS RENAME COLUMN NOME TO NOMEPAIS;

-- RETIRANDO A RESTRIÇÃO A VALORES NULOS NAS COLUNAS TITULO E TIPOVINCULACAO DA TABELA VISAORELACIONADA.
ALTER TABLE VISAORELACIONADA MODIFY (TITULO NULL);
ALTER TABLE VISAORELACIONADA MODIFY (TIPOVINCULACAO NULL);

ALTER TABLE ANEXOBASECONHECIMENTO  
MODIFY (DESCRICAO NULL);

ALTER TABLE ANEXOBASECONHECIMENTO  
MODIFY (NOME NULL);

ALTER TABLE HISTORICOBASECONHECIMENTO 
DROP CONSTRAINT SYS_C0043598;

ALTER TABLE HISTORICOBASECONHECIMENTO
ADD CONSTRAINT HISTORICOBASECONHECIMENTO_PK PRIMARY KEY 
(
  IDHISTORICOBASECONHECIMENTO 
, IDBASECONHECIMENTO 
)
ENABLE;

alter table visaorelacionada drop constraint FK_VISAOREL_REF2_VISAO;
alter table grupovisaocamposnegocio drop constraint FK_REFERENCE_181;
alter table vinculovisao drop constraint FK_VINCULOV_REF2_GRUPOVIS;

delete from matrizvisao;
delete from scriptsvisao;
delete from botaoacaovisao;
delete from htmlcodevisao;
delete from grupovisaocamposnegocioligacao;
delete from valorvisaocamposnegocio;
delete from grupovisaocamposnegocio;
delete from vinculovisao;
delete from grupovisao;
delete from visao;
delete from visaorelacionada;

ALTER TABLE VALORVISAOCAMPOSNEGOCIO  MODIFY (VALOR NULL);

delete from baseconhecimento;
delete from anexobaseconhecimento;

SET DEFINE ON;
