INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (1,'CONTRACT_ID', 'Contract ID')
	ON DUPLICATE KEY UPDATE
		description = 'Contract ID';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (2, 'ORIGIN_ID', 'Origin ID')
	ON DUPLICATE KEY UPDATE
		description = 'Origin ID';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (3, 'REQUEST_ID', 'Type of demand ID for requests')
	ON DUPLICATE KEY UPDATE
		description = 'Type of demand ID for requests';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (4, 'INCIDENT_ID', 'Type of demand ID for incidents')
	ON DUPLICATE KEY UPDATE
		description = 'Type of demand ID for incidents';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (5, 'DEFAULT_DEPTO_ID', 'Default dept ID')
	ON DUPLICATE KEY UPDATE
		description = 'Default dept ID';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (6, 'DEFAULT_SLA', 'Default ID to service level agreement')
	ON DUPLICATE KEY UPDATE
		description = 'Default ID to service level agreement';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (56, 'DEFAULT_REASON_ID', 'Default ID justification to change the situation')
	ON DUPLICATE KEY UPDATE
		description = 'Default ID justification to change the situation';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (106, 'DEFAULT_SERVICE_ID', 'Default Service ID')
	ON DUPLICATE KEY UPDATE
		description = 'Default Service ID';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (107, 'CHANGE_USER', 'Allows modification of the requestor')
	ON DUPLICATE KEY UPDATE
		description = 'Allows modification of the requestor';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (108, 'CHANGE_GROUP', 'Allows redirection')
	ON DUPLICATE KEY UPDATE
		description = 'Allows redirection';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (109, 'CHANGE_SERVICE', 'Allows reclassification')
	ON DUPLICATE KEY UPDATE
		description = 'Allows reclassification';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (156, 'DEFAULT_GROUP_ID', 'Group ID default executor')
	ON DUPLICATE KEY UPDATE
		description = 'Group ID default executor';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (157, 'DEFAULT_DESCRIPTION', 'Standard complement description')
	ON DUPLICATE KEY UPDATE
		description = 'Standard complement description';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (356, 'USER', 'SQL retrieve user login')
	ON DUPLICATE KEY UPDATE
		description = 'SQL retrieve user login';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (357, 'REQUEST_BY_ID', 'SQL recover request / incident by ID')
	ON DUPLICATE KEY UPDATE
		description = 'SQL recover request / incident by ID';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (358, 'REQUEST_BY_DESCRIPTION', 'SQL recover request / incident by description')
	ON DUPLICATE KEY UPDATE
		description = 'SQL recover request / incident by description';
		

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'addServiceRequest', 
			'Create service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Create service request';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'listTasks', 
			'Listing Tasks',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestListTasks', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Listing Tasks';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getByUser', 
			'Return notification list for mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Return notification list for mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getById', 
			'Returns details of a notification to Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Returns details of a notification to Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_feedback', 
			'Processes feedback from a notification to Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Processes feedback from a notification to Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_new', 
			'Create a notification to Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Create a notification to Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getReasons', 
			'Returns possible justifications for a notification',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Returns possible justifications for a notification';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'bicitsmart_recuperarTabelas', 
			'Returns all data of the required tables to the BI Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestBICitsmart', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Returns all data of the required tables to the BI Citsmart';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_coordinates', 
			'Gets the unit coordinate check in Unit',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Gets the unit coordinate check in Unit';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listContracts', 
			'Return list of active Citsmart contracts',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Return list of active Citsmart contracts';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listDeniedReasons', 
			'List justifications',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'List justifications';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listSolicitationStatus', 
			'List status of service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'List status of service request';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listUnits', 
			'List of contract unit',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'List of contract unit';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_attendantLocation', 
			'Location of an attendant',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Location of an attendant';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getNewest', 
			'New request list',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'New request list';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getOldest', 
			'Request list intended for new user',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Request list intended for new user';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_checkin', 
			'Check-in request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Check-in request';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_checkinDenied', 
			'Denial Check - in a service request suggestion',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Denial Check - in a service request suggestion';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_checkout', 
			'Check-out, completion of a service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Check-out, completion of a service request';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getByCoordinates', 
			'New request list - Coordinates',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'New request list - Coordinates';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_attendRequest', 
			'Attending Request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Attending Request';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_deviceDisassociate', 
			'Disassociate device attendant',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Disassociate device attendant';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_updateNotification', 
			'Restore tasks and permissions of a service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Restore tasks and permissions of a service request';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getById_v2', 
			'Returns details of a notification for Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Returns details of a notification for Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_create', 
			'Create new service requests',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Create new service requests';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_update', 
			'Change service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Change service request';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_updateStatus', 
			'Updates status of a request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Updates status of a request';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_getByUser', 
			'Consultation requests per user',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Consultation requests per user';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_getById', 
			'Request details by the number',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Request details by the number';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_create_occurrence', 
			'Create a request for incidents',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Create a request for incidents';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_list_occurrences', 
			'List instances of a request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'List instances of a request';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_getNotSynchronized', 
			'Recover unsynchronized requests',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Recover unsynchronized requests';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'synchronize', 
			'Data synchronization',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Data synchronization';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'occurrence_getNotSynchronized', 
			'Recover unsynchronized events',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Recover unsynchronized events';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'occurrence_synchronize', 
			'Synchronizes events',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Synchronizes events';


SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'synchronize_find', 
			'Retrieve synchronization objects list',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Retrieve synchronization objects list';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'synchronize_delete', 
			'Delete synchronization',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Delete synchronization';
	

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'data_query', 
			'Execute queries on the database',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Execute queries on the database';
	

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_buscaNotificacao', 
			'Search service of requests to the mobile Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Search service of requests to the mobile Citsmart';
	


SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CONTRACT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CONTRACT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CONTRACT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'ORIGIN_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '7')
	ON DUPLICATE KEY UPDATE
		value = '7';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'ORIGIN_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '10')
	ON DUPLICATE KEY UPDATE
		value = '10';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'INCIDENT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'INCIDENT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'INCIDENT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_SLA');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1421')
	ON DUPLICATE KEY UPDATE
		value = '1421';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_SLA');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1421')
	ON DUPLICATE KEY UPDATE
		value = '1421';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_REASON_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_updateStatus');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '7')
	ON DUPLICATE KEY UPDATE
		value = '7';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_SERVICE_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '5136')
	ON DUPLICATE KEY UPDATE
		value = '5136';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CHANGE_USER');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'N')
	ON DUPLICATE KEY UPDATE
		value = 'N';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CHANGE_GROUP');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'N')
	ON DUPLICATE KEY UPDATE
		value = 'N';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CHANGE_SERVICE');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'N')
	ON DUPLICATE KEY UPDATE
		value = 'N';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_GROUP_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '159')
	ON DUPLICATE KEY UPDATE
		value = '159';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_DESCRIPTION');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'Requisition created by ESI centralizer')
	ON DUPLICATE KEY UPDATE
		value = 'Requisition created by ESI centralizer';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'USER');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'data_query');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}')
	ON DUPLICATE KEY UPDATE
		value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_BY_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'data_query');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}')
	ON DUPLICATE KEY UPDATE
		value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_BY_DESCRIPTION');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'data_query');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}')
	ON DUPLICATE KEY UPDATE
		value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}';
