INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (1,'CONTRACT_ID', 'ID del contrato')
	ON DUPLICATE KEY UPDATE
		description = 'ID del contrato';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (2, 'ORIGIN_ID', 'ID del origen')
	ON DUPLICATE KEY UPDATE
		description = 'ID del origen';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (3, 'REQUEST_ID', 'ID del tipo de demanda para solicitudes')
	ON DUPLICATE KEY UPDATE
		description = 'ID del tipo de demanda para solicitudes';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (4, 'INCIDENT_ID', 'ID del tipo de demanda para incidentes')
	ON DUPLICATE KEY UPDATE
		description = 'ID del tipo de demanda para incidentes';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (5, 'DEFAULT_DEPTO_ID', 'ID normalizado de la unidad')
	ON DUPLICATE KEY UPDATE
		description = 'ID normalizado de la unidad';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (6, 'DEFAULT_SLA', 'ID normalizado del acuerdo de nivel de servicio')
	ON DUPLICATE KEY UPDATE
		description = 'ID normalizado del acuerdo de nivel de servicio';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (56, 'DEFAULT_REASON_ID', 'ID justificacin normalizada para alteracin de situacin')
	ON DUPLICATE KEY UPDATE
		description = 'ID justificacin normalizada para alteracin de situacin';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (106, 'DEFAULT_SERVICE_ID', 'ID del servicio normalizado')
	ON DUPLICATE KEY UPDATE
		description = 'ID del servicio normalizado';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (107, 'CHANGE_USER', 'Permite alteracin del solicitante')
	ON DUPLICATE KEY UPDATE
		description = 'Permite alteracin del solicitante';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (108, 'CHANGE_GROUP', 'Permite redirecionamento')
	ON DUPLICATE KEY UPDATE
		description = 'Permite redirecionamento';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (109, 'CHANGE_SERVICE', 'Permite reclasificacin')
	ON DUPLICATE KEY UPDATE
		description = 'Permite reclassificao';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (156, 'DEFAULT_GROUP_ID', 'ID del grupo executor normalizado')
	ON DUPLICATE KEY UPDATE
		description = 'ID del grupo executor normalizado';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (157, 'DEFAULT_DESCRIPTION', 'Complemento normalizado de la descripcin')
	ON DUPLICATE KEY UPDATE
		description = 'Complemento normalizado de la descripcin';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (356, 'USER', 'SQL recupera usuario por el login')
	ON DUPLICATE KEY UPDATE
		description = 'SQL recupera usuario por el login';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (357, 'REQUEST_BY_ID', 'SQL recupera solicitud/incidente por el ID')
	ON DUPLICATE KEY UPDATE
		description = 'SQL recupera solicitud/incidente por el ID';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (358, 'REQUEST_BY_DESCRIPTION', 'SQL recupera solicitud/incidente por la descripcin')
	ON DUPLICATE KEY UPDATE
		description = 'SQL recupera solicitud/incidente por la descripcin';
		

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'addServiceRequest', 
			'Creacin de solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Creacin de solicitud de servicio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'listTasks', 
			'Listado de tareas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestListTasks', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Listado de tareas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getByUser', 
			'Retorna lista de notificaciones para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'notification_getByUser';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getById', 
			'Retorna detalles de una notificacin para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retorna detalles de una notificacin para Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_feedback', 
			'Procesa feedback de una notificacin para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Procesa feedback de una notificacin para Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_new', 
			'Crea una notificacin para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Crea una notificacin para Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getReasons', 
			'Retorna justificaciones posibles para una notificacin',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retorna justificaciones posibles para una notificacin';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'bicitsmart_recuperarTabelas', 
			'Retorna todos los datos de las tablas necesarias para el BI del Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestBICitsmart', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retorna todos los datos de las tablas necesarias para el BI del Citsmart';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_coordinates', 
			'Recibe la coordenada de la unidad check-in unidad',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Recibe la coordenada de la unidad check-in unidad';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listContracts', 
			'Retornar lista de Contratos activos del Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retornar lista de Contratos activos del Citsmart';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listDeniedReasons', 
			'Lista de Justificacin',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de Justificacin';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listSolicitationStatus', 
			'Lista estatus de la solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista estatus de la solicitud de servicio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listUnits', 
			'Lista de unidad de un contrato',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de unidad de un contrato';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_attendantLocation', 
			'Localizacin de un atendente',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Localizacin de un atendente';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getNewest', 
			'Lista de solicitudes nuevas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de solicitudes nuevas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getOldest', 
			'Lista de nuevas solicitudes destinadas al usuario',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de nuevas solicitudes destinadas al usuario';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_checkin', 
			'Check-in de la solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Check-in de la solicitud';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_checkinDenied', 
			'Negacin de check-in de una sugerencia de solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Negacin de check-in de una sugerencia de solicitud de servicio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_checkout', 
			'Check-out, finalizacin de una solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Check-out, finalizacin de una solicitud de servicio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getByCoordinates', 
			'Lista de solicitudes nuevas - coordenadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de solicitudes nuevas - coordenadas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_attendRequest', 
			'Atender solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Atender solicitud';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_deviceDisassociate', 
			'Desasociar device del atendente',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Desasociar device del atendente';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_updateNotification', 
			'Restaura tareas y permisos de una solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Restaura tareas y permisos de una solicitud de servicio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getById_v2', 
			'Retorna detalles de una notificacin para mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retorna detalles de una notificacin para mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_create', 
			'Crea nuevas solicitudes de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Crea nuevas solicitudes de servicio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_update', 
			'Altera solicitudes de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Altera solicitudes de servicio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_updateStatus', 
			'Actualiza estatus de una solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Actualiza estatus de una solicitud';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_getByUser', 
			'Consulta solicitudes por usuario',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Consulta solicitudes por usuario';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_getById', 
			'Detalla solicitud por el nmero',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Detalla solicitud por el nmero';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_create_occurrence', 
			'Crea una ocurrencia de solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Crea una ocurrencia de solicitud';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_list_occurrences', 
			'Lista las ocurrencias de una solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Lista las ocurrencias de una solicitud';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_getNotSynchronized', 
			'Recupera solicitudes no sincronizadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Recupera solicitudes no sincronizadas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'synchronize', 
			'Sincronizacin de datos',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Sincronizacin de datos';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'occurrence_getNotSynchronized', 
			'Recupera ocurrencias no sincronizadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Recupera ocurrencias no sincronizadas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'occurrence_synchronize', 
			'Sincroniza ocurrencias',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Sincroniza ocurrencias';


SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'synchronize_find', 
			'Recupera lista de objetos de sincronizacin',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Recupera lista de objetos de sincronizacin';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'synchronize_delete', 
			'Excluye sincronizacin',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Excluye sincronizacin';
	

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'data_query', 
			'Ejecuta consultas en la base de datos',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Ejecuta consultas en la base de datos';
	

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_buscaNotificacao', 
			'Servicio de bsqueda de solicitudes para el citsmart mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Servicio de bsqueda de solicitudes para el citsmart mobile';
	


SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CONTRACT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CONTRACT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CONTRACT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'ORIGIN_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '7')
	ON DUPLICATE KEY UPDATE
		value = '7';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'ORIGIN_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '10')
	ON DUPLICATE KEY UPDATE
		value = '10';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'INCIDENT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'INCIDENT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'INCIDENT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_SLA');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1421')
	ON DUPLICATE KEY UPDATE
		value = '1421';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_SLA');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1421')
	ON DUPLICATE KEY UPDATE
		value = '1421';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_REASON_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_updateStatus');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '7')
	ON DUPLICATE KEY UPDATE
		value = '7';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_SERVICE_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '5136')
	ON DUPLICATE KEY UPDATE
		value = '5136';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CHANGE_USER');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'N')
	ON DUPLICATE KEY UPDATE
		value = 'N';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CHANGE_GROUP');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'N')
	ON DUPLICATE KEY UPDATE
		value = 'N';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CHANGE_SERVICE');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'N')
	ON DUPLICATE KEY UPDATE
		value = 'N';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_GROUP_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '159')
	ON DUPLICATE KEY UPDATE
		value = '159';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_DESCRIPTION');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'Solicitud creada por ESI centralizador')
	ON DUPLICATE KEY UPDATE
		value = 'Solicitud creada por ESI centralizador';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'USER');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'data_query');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}')
	ON DUPLICATE KEY UPDATE
		value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_BY_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'data_query');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}')
	ON DUPLICATE KEY UPDATE
		value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_BY_DESCRIPTION');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'data_query');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}')
	ON DUPLICATE KEY UPDATE
		value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}';
