INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (1,'CONTRACT_ID', 'ID do contrato')
	ON DUPLICATE KEY UPDATE
		description = 'ID do contrato';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (2, 'ORIGIN_ID', 'ID da origem')
	ON DUPLICATE KEY UPDATE
		description = 'ID da origem';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (3, 'REQUEST_ID', 'ID do tipo de demanda para requisies')
	ON DUPLICATE KEY UPDATE
		description = 'ID do tipo de demanda para requisies';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (4, 'INCIDENT_ID', 'ID do tipo de demanda para incidentes')
	ON DUPLICATE KEY UPDATE
		description = 'ID do tipo de demanda para incidentes';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (5, 'DEFAULT_DEPTO_ID', 'ID padro da unidade')
	ON DUPLICATE KEY UPDATE
		description = 'ID padro da unidade';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (6, 'DEFAULT_SLA', 'ID padro do acordo de nvel de servio')
	ON DUPLICATE KEY UPDATE
		description = 'ID padro do acordo de nvel de servio';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (56, 'DEFAULT_REASON_ID', 'ID justificativa padro para alterao de situao')
	ON DUPLICATE KEY UPDATE
		description = 'ID justificativa padro para alterao de situao';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (106, 'DEFAULT_SERVICE_ID', 'ID do servio padro')
	ON DUPLICATE KEY UPDATE
		description = 'ID do servio padro';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (107, 'CHANGE_USER', 'Permite alterao do solicitante')
	ON DUPLICATE KEY UPDATE
		description = 'Permite alterao do solicitante';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (108, 'CHANGE_GROUP', 'Permite redirecionamento')
	ON DUPLICATE KEY UPDATE
		description = 'Permite redirecionamento';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (109, 'CHANGE_SERVICE', 'Permite reclassificao')
	ON DUPLICATE KEY UPDATE
		description = 'Permite reclassificao';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (156, 'DEFAULT_GROUP_ID', 'ID do grupo executor padro')
	ON DUPLICATE KEY UPDATE
		description = 'ID do grupo executor padro';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (157, 'DEFAULT_DESCRIPTION', 'Complemento padro da descrio')
	ON DUPLICATE KEY UPDATE
		description = 'Complemento padro da descrio';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (356, 'USER', 'SQL recupera usurio pelo login')
	ON DUPLICATE KEY UPDATE
		description = 'SQL recupera usurio pelo login';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (357, 'REQUEST_BY_ID', 'SQL recupera solicitao/incidente pelo ID')
	ON DUPLICATE KEY UPDATE
		description = 'SQL recupera solicitao/incidente pelo ID';
		
INSERT INTO rest_parameter 
	(idrestparameter, identifier, description) 
		VALUES (358, 'REQUEST_BY_DESCRIPTION', 'SQL recupera solicitao/incidente pela descrio')
	ON DUPLICATE KEY UPDATE
		description = 'SQL recupera solicitao/incidente pela descrio';
		

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'addServiceRequest', 
			'Criao de solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Criao de solicitao de servio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'listTasks', 
			'Listagem de tarefas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestListTasks', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Listagem de tarefas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getByUser', 
			'Retorna lista de notificaes para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retorna lista de notificaes para Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getById', 
			'Retorna detalhes de uma notificao para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retorna detalhes de uma notificao para Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_feedback', 
			'Processa feedback de uma notificao para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Processa feedback de uma notificao para Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_new', 
			'Cria uma notificao para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Cria uma notificao para Mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getReasons', 
			'Retorna justificativas possveis para uma notificao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retorna justificativas possveis para uma notificao';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'bicitsmart_recuperarTabelas', 
			'Retorna todos os dados das tabelas necessrias para o BI do Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestBICitsmart', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retorna todos os dados das tabelas necessrias para o BI do Citsmart';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_coordinates', 
			'Recebe a coordenada da unidade check-in unidade',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Recebe a coordenada da unidade check-in unidade';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listContracts', 
			'Retornar lista de  Contratos ativos do Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retornar lista de Contratos ativos do Citsmart';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listDeniedReasons', 
			'Lista de Justificativa',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de Justificativa';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listSolicitationStatus', 
			'Lista status da solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista status da solicitaes de servio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_listUnits', 
			'Lista de unidade de um contrato',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de unidade de um contrato';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_attendantLocation', 
			'Localizao de um atendente',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Localizao de um atendente';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getNewest', 
			'Lista de solicitaes novas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de solicitaes novas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getOldest', 
			'Lista de novas solicitaes destinadas ao usurio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de novas solicitaes destinadas ao usurio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_checkin', 
			'Check-in da solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Check-in da solicitao';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_checkinDenied', 
			'Negao de check-in de uma sugesto de solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Negao de check-in de uma sugesto de solicitao de servio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_checkout', 
			'Check-out, finalizao de uma solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Check-out, finalizao de uma solicitao de servio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getByCoordinates', 
			'Lista de solicitaes novas - coordenadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Lista de solicitaes novas - coordenadas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_attendRequest', 
			'Atender solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Atender solicitao';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'service_deviceDisassociate', 
			'Desassociar device do atendente',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Desassociar device do atendente';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_updateNotification', 
			'Restaura tarefas e permisses de uma solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Restaura tarefas e permisses de uma solicitao de servio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_getById_v2', 
			'Retorna detalhes de uma notificao para mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Retorna detalhes de uma notificao para mobile';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_create', 
			'Cria novas solicitaes de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Cria novas solicitaes de servio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_update', 
			'Altera solicitaes de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Altera solicitaes de servio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_updateStatus', 
			'Atualiza status de uma solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Atualiza status de uma solicitao';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_getByUser', 
			'Consulta requisies por usurio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Consulta requisies por usurio';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_getById', 
			'Detalha requisio pelo nmero',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Detalha requisio pelo nmero';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_create_occurrence', 
			'Cria uma ocorrncia de solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Cria uma ocorrncia de solicitao';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_list_occurrences', 
			'Lista as ocorrncias de uma solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Lista as ocorrncias de uma solicitao';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'request_getNotSynchronized', 
			'Recupera requisies no sincronizadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Recupera requisies no sincronizadas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'synchronize', 
			'Sincronizao de dados',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Sincronizao de dados';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'occurrence_getNotSynchronized', 
			'Recupera ocorrncias no sincronizadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Recupera ocorrncias no sincronizadas';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'occurrence_synchronize', 
			'Sincroniza ocorrncias',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Sincroniza ocorrncias';


SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'synchronize_find', 
			'Recupera lista de objetos de sincronizao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Recupera lista de objetos de sincronizao';

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'synchronize_delete', 
			'Exclui sincronizao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N')
ON DUPLICATE KEY UPDATE
	description = 'Exclui sincronizao';
	

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'data_query', 
			'Executa consultas no banco de dados',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Executa consultas no banco de dados';
	

SET @id:= (SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation);
INSERT INTO rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			@id,
			NULL, 'notification_buscaNotificacao', 
			'Servio de busca de solicitaes para o citsmart mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y')
ON DUPLICATE KEY UPDATE
	description = 'Servio de busca de solicitaes para o citsmart mobile';
	


SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CONTRACT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CONTRACT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CONTRACT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'ORIGIN_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '7')
	ON DUPLICATE KEY UPDATE
		value = '7';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'ORIGIN_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '10')
	ON DUPLICATE KEY UPDATE
		value = '10';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1')
	ON DUPLICATE KEY UPDATE
		value = '1';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'INCIDENT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'INCIDENT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'INCIDENT_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'addServiceRequest');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'notification_new');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '3')
	ON DUPLICATE KEY UPDATE
		value = '3';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_SLA');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1421')
	ON DUPLICATE KEY UPDATE
		value = '1421';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_SLA');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '1421')
	ON DUPLICATE KEY UPDATE
		value = '1421';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_REASON_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_updateStatus');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '7')
	ON DUPLICATE KEY UPDATE
		value = '7';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_SERVICE_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '5136')
	ON DUPLICATE KEY UPDATE
		value = '5136';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CHANGE_USER');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'N')
	ON DUPLICATE KEY UPDATE
		value = 'N';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CHANGE_GROUP');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'N')
	ON DUPLICATE KEY UPDATE
		value = 'N';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'CHANGE_SERVICE');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_update');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'N')
	ON DUPLICATE KEY UPDATE
		value = 'N';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_GROUP_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, '159')
	ON DUPLICATE KEY UPDATE
		value = '159';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'DEFAULT_DESCRIPTION');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'request_create');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'Requisio criada por ESI centralizador')
	ON DUPLICATE KEY UPDATE
		value = 'Requisio criada por ESI centralizador';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'USER');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'data_query');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}')
	ON DUPLICATE KEY UPDATE
		value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_BY_ID');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'data_query');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}')
	ON DUPLICATE KEY UPDATE
		value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}';
		
SET @idrestparameter := (SELECT rest_parameter.idrestparameter FROM rest_parameter
	WHERE rest_parameter.identifier LIKE 'REQUEST_BY_DESCRIPTION');
SET @idrestoperation := (SELECT rest_operation.idrestoperation FROM rest_operation
	WHERE rest_operation.name LIKE 'data_query');
INSERT INTO rest_domain 
	(idrestparameter, idrestoperation, value) 
		VALUES (@idrestparameter, @idrestoperation, 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}')
	ON DUPLICATE KEY UPDATE
		value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}';
