MERGE INTO rest_parameter a
	USING (SELECT 1 idrestparameter, 'CONTRACT_ID' identifier, 'Contract ID' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Contract ID';
		
MERGE INTO rest_parameter a
	USING (SELECT 2 idrestparameter, 'ORIGIN_ID' identifier, 'Origin ID' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Origin ID';
		
MERGE INTO rest_parameter a
	USING (SELECT 3 idrestparameter, 'REQUEST_ID' identifier, 'Type of demand ID for requests' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Type of demand ID for requests';

MERGE INTO rest_parameter a
	USING (SELECT 4 idrestparameter, 'INCIDENT_ID' identifier, 'Type of demand ID for incidents' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Type of demand ID for incidents';
		
MERGE INTO rest_parameter a
	USING (SELECT 5 idrestparameter, 'DEFAULT_DEPTO_ID' identifier, 'Default dept ID' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Default dept ID';

MERGE INTO rest_parameter a
	USING (SELECT 6 idrestparameter, 'DEFAULT_SLA' identifier, 'Default ID to service level agreement' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Default ID to service level agreement';

MERGE INTO rest_parameter a
	USING (SELECT 56 idrestparameter, 'DEFAULT_REASON_ID' identifier, 'Default ID justification to change the situation' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Default ID justification to change the situation';

MERGE INTO rest_parameter a
	USING (SELECT 106 idrestparameter, 'DEFAULT_SERVICE_ID' identifier, 'Default Service ID' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Default Service ID';

MERGE INTO rest_parameter a
	USING (SELECT 107 idrestparameter, 'CHANGE_USER' identifier, 'Allows modification of the requestor' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Allows modification of the requestor';
	
MERGE INTO rest_parameter a
	USING (SELECT 108 idrestparameter, 'CHANGE_GROUP' identifier, 'Allows redirection' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Allows redirection';
		
MERGE INTO rest_parameter a
	USING (SELECT 109 idrestparameter, 'CHANGE_SERVICE' identifier, 'Allows reclassification' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Allows reclassification';

MERGE INTO rest_parameter a
	USING (SELECT 156 idrestparameter, 'DEFAULT_GROUP_ID' identifier, 'Group ID default executor' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Group ID default executor';

MERGE INTO rest_parameter a
	USING (SELECT 157 idrestparameter, 'DEFAULT_DESCRIPTION' identifier, 'Standard complement description' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Standard complement description';

MERGE INTO rest_parameter a
	USING (SELECT 356 idrestparameter, 'USER' identifier, 'SQL retrieve user login' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'SQL retrieve user login';

MERGE INTO rest_parameter a
	USING (SELECT 357 idrestparameter, 'REQUEST_BY_ID' identifier, 'SQL recover request / incident by ID' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'SQL recover request / incident by ID';

MERGE INTO rest_parameter a
	USING (SELECT 358 idrestparameter, 'REQUEST_BY_DESCRIPTION' identifier, 'SQL recover request / incident by description' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'SQL recover request / incident by description';
		

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation,
			NULL idbatchprocessing, 'addServiceRequest' name, 
			'Create service request' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest' javaclass, NULL javascript, 'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Create service request';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'listTasks' name, 
			'Listing Tasks' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestListTasks' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Listing Tasks';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getByUser' name, 
			'Return notification list for mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Return notification list for mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getById' name, 
			'Returns details of a notification to Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Returns details of a notification to Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_feedback' name, 
			'Processes feedback from a notification to Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Processes feedback from a notification to Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_new' name, 
			'Create a notification to Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Create a notification to Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getReasons' name, 
			'Returns possible justifications for a notification' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Returns possible justifications for a notification';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'bicitsmart_recuperarTabelas' name, 
			'Returns all data of the required tables to the BI Citsmart' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestBICitsmart' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Returns all data of the required tables to the BI Citsmart';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_coordinates' name, 
			'Gets the unit coordinate check in Unit' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Gets the unit coordinate check in Unit';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listContracts' name, 
			'Return list of active Citsmart contracts' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Return list of active Citsmart contracts';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listDeniedReasons' name, 
			'List justifications' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'List justifications';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listSolicitationStatus' name, 
			'List status of service request' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'List status of service request';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listUnits' name, 
			'List of contract unit' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'List of contract unit';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_attendantLocation' name, 
			'Location of an attendant' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Location of an attendant';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getNewest' name, 
			'New request list' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'New request list';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getOldest' name, 
			'Request list intended for new user' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Request list intended for new user';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_checkin' name, 
			'Check-in request' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Check-in request';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_checkinDenied' name, 
			'Denial Check - in a service request suggestion' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Denial Check - in a service request suggestion';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_checkout' name, 
			'Check-out, completion of a service request' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Check-out, completion of a service request';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getByCoordinates' name, 
			'New request list - Coordinates' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'New request list - Coordinates';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_attendRequest' name, 
			'Attending Request' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Attending Request';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_deviceDisassociate' name, 
			'Disassociate device attendant' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Disassociate device attendant';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_updateNotification' name, 
			'Restore tasks and permissions of a service request' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Restore tasks and permissions of a service request';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getById_v2' name, 
			'Returns details of a notification for Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Returns details of a notification for Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_create' name, 
			'Create new service requests' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Create new service requests';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_update' name, 
			'Change service request' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Change service request';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_updateStatus' name, 
			'Updates status of a request' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Updates status of a request';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_getByUser' name, 
			'Consultation requests per user' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Consultation requests per user';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_getById' name, 
			'Request details by the number' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Request details by the number';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_create_occurrence' name, 
			'Create a request for incidents' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Create a request for incidents';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_list_occurrences' name, 
			'List instances of a request' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'List instances of a request';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_getNotSynchronized' name, 
			'Recover unsynchronized requests' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recover unsynchronized requests';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'synchronize' name, 
			'Data synchronization' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Data synchronization';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'occurrence_getNotSynchronized' name, 
			'Recover unsynchronized events' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recover unsynchronized events';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'occurrence_synchronize' name, 
			'Synchronizes events' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Synchronizes events';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'synchronize_find' name, 
			'Retrieve synchronization objects list' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retrieve synchronization objects list';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'synchronize_delete' name, 
			'Delete synchronization' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Delete synchronization';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'data_query' name, 
			'Execute queries on the database' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Execute queries on the database';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_buscaNotificacao' name, 
			'Search service of requests to the mobile Citsmart' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Search service of requests to the mobile Citsmart';


MERGE INTO rest_domain a
	USING (SELECT 1 idrestparameter, 
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';

MERGE INTO rest_domain a
	USING (SELECT 1 idrestparameter,  
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 1 idrestparameter,  
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 2 idrestparameter,   
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'7' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '7';
		
MERGE INTO rest_domain a
	USING (SELECT 2 idrestparameter,    
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'10' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '10';
		
MERGE INTO rest_domain a
	USING (SELECT 3 idrestparameter,     
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 3 idrestparameter,      
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 3 idrestparameter,       
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 4 idrestparameter,        
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 4 idrestparameter,         
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 4 idrestparameter,          
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 5 idrestparameter,           
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 5 idrestparameter,
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 6 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'1421' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1421';
		
MERGE INTO rest_domain a
	USING (SELECT 6 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'1421' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1421';
		
MERGE INTO rest_domain a
	USING (SELECT 56 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_updateStatus') idrestoperation, 
			'7' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '7';
		
MERGE INTO rest_domain a
	USING (SELECT 106 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'5136' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '5136';
		
MERGE INTO rest_domain a
	USING (SELECT 107 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'N' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'N';
		
MERGE INTO rest_domain a
	USING (SELECT 108 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'N' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'N';
		
MERGE INTO rest_domain a
	USING (SELECT 109 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'N' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'N';
		
MERGE INTO rest_domain a
	USING (SELECT 156 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'159' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '159';
		
MERGE INTO rest_domain a
	USING (SELECT 157 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'Requisition created by ESI centralizer' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'Requisition created by ESI centralizer';
		
MERGE INTO rest_domain a
	USING (SELECT 356 idrestparameter,
			(select idrestoperation from rest_operation where name like 'data_query') idrestoperation, 
			'select idusuario, login, nome, idempregado, status from usuario where login = ${login}' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}';
 
MERGE INTO rest_domain a
	USING (SELECT 357 idrestparameter, 
			(select idrestoperation from rest_operation where name like 'data_query') idrestoperation, 
			'SELECT      sol.idSolicitacaoServico,     sol.idbaseconhecimento,     sol.idServicoContrato,     sol.idSolicitante,     sol.idItemConfiguracao,     sol.idItemConfiguracaoFilho,     sol.idtipodemandaservico,     sol.idcontatosolicitacaoservico,     sol.idOrigem,     sol.idResponsavel,     sol.idTipoProblema,     sol.idPrioridade,     sol.idUnidade,     sol.idFaseAtual,     sol.idGrupoAtual,     sol.dataHoraSolicitacao,     sol.dataHoraLimite,     sol.atendimentoPresencial,     sol.prazoCapturaHH,     sol.prazoCapturaMM,     sol.prazoHH,     sol.prazoMM,     sol.descricao,     sol.resposta,     sol.dataHoraInicio,     sol.dataHoraFim,     sol.situacao,     sol.idSolicitacaoPai,     sol.detalhamentoCausa,     sol.idCausaIncidente,     sol.idCategoriaSolucao,     sol.seqreabertura,     sol.enviaEmailCriacao,     sol.enviaEmailFinalizacao,     sol.enviaEmailAcoes,     sol.idgruponivel1,     sol.solucaoTemporaria,     sol.houveMudanca,     sol.slaACombinar,     sol.prazohhAnterior,     sol.prazommAnterior,     sol.idCalendario,     sol.tempoDecorridoHH,     sol.tempoDecorridoMM,     sol.dataHoraSuspensao,     sol.dataHoraReativacao,     sol.impacto,     sol.urgencia,     sol.dataHoraCaptura,     sol.tempoCapturaHH,     sol.tempoCapturaMM,     sol.tempoAtrasoHH,     sol.tempoAtrasoMM,     sol.tempoAtendimentoHH,     sol.tempoAtendimentoMM,     sol.idacordonivelservico,     sol.idultimaaprovacao,     sol.datahorainiciosla,     sol.datahorasuspensaosla,     sol.datahorareativacaosla,     sol.situacaosla,     sol.idtarefaencerramento,     sol.justificativavencimentosla,     aprov.aprovacao,     s.idservico,     s.nomeServico,     td.idTipoDemandaServico,     td.nomeTipoDemandaServico,     c.idContrato,     c.numero as numeroContrato,     e1.nome as solicitante,     u1.nome as unidade,     e2.nome as responsavel,     g1.sigla as grupoAtual,     g2.sigla as grupoNivel1,     cs.nomecontato,     cs.emailcontato,     cs.telefonecontato,     cs.localizacaofisica,     cs.idlocalidade,     sol.idSolicitacaoRelacionada,     e3.email as emailResponsavel,     sol.codigoExterno FROM     solicitacaoservico sol         INNER JOIN     tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico         LEFT JOIN     servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato         LEFT JOIN     contratos c ON c.idcontrato = sc.idcontrato         LEFT JOIN     servico s ON s.idservico = sc.idservico         LEFT JOIN     empregados e1 ON e1.idempregado = sol.idsolicitante         LEFT JOIN     unidade u1 ON u1.idunidade = e1.idunidade         LEFT JOIN     usuario usu ON usu.idusuario = sol.idresponsavel         LEFT JOIN     empregados e2 ON e2.idempregado = usu.idempregado         LEFT JOIN     unidade u2 ON u2.idunidade = e2.idunidade         LEFT JOIN     origematendimento oa ON oa.idorigem = sol.idorigem         LEFT JOIN     prioridade p ON p.idprioridade = sol.idprioridade         LEFT JOIN     faseservico fs ON fs.idfase = sol.idfaseatual         LEFT JOIN     grupo g1 ON g1.idgrupo = sol.idgrupoatual         LEFT JOIN     grupo g2 ON g2.idgrupo = sol.idgruponivel1         LEFT JOIN     empregados e3 ON e3.idempregado = sol.idresponsavel         LEFT JOIN     contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico         LEFT JOIN     aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'SELECT      sol.idSolicitacaoServico,     sol.idbaseconhecimento,     sol.idServicoContrato,     sol.idSolicitante,     sol.idItemConfiguracao,     sol.idItemConfiguracaoFilho,     sol.idtipodemandaservico,     sol.idcontatosolicitacaoservico,     sol.idOrigem,     sol.idResponsavel,     sol.idTipoProblema,     sol.idPrioridade,     sol.idUnidade,     sol.idFaseAtual,     sol.idGrupoAtual,     sol.dataHoraSolicitacao,     sol.dataHoraLimite,     sol.atendimentoPresencial,     sol.prazoCapturaHH,     sol.prazoCapturaMM,     sol.prazoHH,     sol.prazoMM,     sol.descricao,     sol.resposta,     sol.dataHoraInicio,     sol.dataHoraFim,     sol.situacao,     sol.idSolicitacaoPai,     sol.detalhamentoCausa,     sol.idCausaIncidente,     sol.idCategoriaSolucao,     sol.seqreabertura,     sol.enviaEmailCriacao,     sol.enviaEmailFinalizacao,     sol.enviaEmailAcoes,     sol.idgruponivel1,     sol.solucaoTemporaria,     sol.houveMudanca,     sol.slaACombinar,     sol.prazohhAnterior,     sol.prazommAnterior,     sol.idCalendario,     sol.tempoDecorridoHH,     sol.tempoDecorridoMM,     sol.dataHoraSuspensao,     sol.dataHoraReativacao,     sol.impacto,     sol.urgencia,     sol.dataHoraCaptura,     sol.tempoCapturaHH,     sol.tempoCapturaMM,     sol.tempoAtrasoHH,     sol.tempoAtrasoMM,     sol.tempoAtendimentoHH,     sol.tempoAtendimentoMM,     sol.idacordonivelservico,     sol.idultimaaprovacao,     sol.datahorainiciosla,     sol.datahorasuspensaosla,     sol.datahorareativacaosla,     sol.situacaosla,     sol.idtarefaencerramento,     sol.justificativavencimentosla,     aprov.aprovacao,     s.idservico,     s.nomeServico,     td.idTipoDemandaServico,     td.nomeTipoDemandaServico,     c.idContrato,     c.numero as numeroContrato,     e1.nome as solicitante,     u1.nome as unidade,     e2.nome as responsavel,     g1.sigla as grupoAtual,     g2.sigla as grupoNivel1,     cs.nomecontato,     cs.emailcontato,     cs.telefonecontato,     cs.localizacaofisica,     cs.idlocalidade,     sol.idSolicitacaoRelacionada,     e3.email as emailResponsavel,     sol.codigoExterno FROM     solicitacaoservico sol         INNER JOIN     tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico         LEFT JOIN     servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato         LEFT JOIN     contratos c ON c.idcontrato = sc.idcontrato         LEFT JOIN     servico s ON s.idservico = sc.idservico         LEFT JOIN     empregados e1 ON e1.idempregado = sol.idsolicitante         LEFT JOIN     unidade u1 ON u1.idunidade = e1.idunidade         LEFT JOIN     usuario usu ON usu.idusuario = sol.idresponsavel         LEFT JOIN     empregados e2 ON e2.idempregado = usu.idempregado         LEFT JOIN     unidade u2 ON u2.idunidade = e2.idunidade         LEFT JOIN     origematendimento oa ON oa.idorigem = sol.idorigem         LEFT JOIN     prioridade p ON p.idprioridade = sol.idprioridade         LEFT JOIN     faseservico fs ON fs.idfase = sol.idfaseatual         LEFT JOIN     grupo g1 ON g1.idgrupo = sol.idgrupoatual         LEFT JOIN     grupo g2 ON g2.idgrupo = sol.idgruponivel1         LEFT JOIN     empregados e3 ON e3.idempregado = sol.idresponsavel         LEFT JOIN     contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico         LEFT JOIN     aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}';
		
MERGE INTO rest_domain a
	USING (SELECT 358 idrestparameter, 
			(select idrestoperation from rest_operation where name like 'data_query') idrestoperation, 
			'SELECT      sol.idSolicitacaoServico,     sol.idbaseconhecimento,     sol.idServicoContrato,     sol.idSolicitante,     sol.idItemConfiguracao,     sol.idItemConfiguracaoFilho,     sol.idtipodemandaservico,     sol.idcontatosolicitacaoservico,     sol.idOrigem,     sol.idResponsavel,     sol.idTipoProblema,     sol.idPrioridade,     sol.idUnidade,     sol.idFaseAtual,     sol.idGrupoAtual,     sol.dataHoraSolicitacao,     sol.dataHoraLimite,     sol.atendimentoPresencial,     sol.prazoCapturaHH,     sol.prazoCapturaMM,     sol.prazoHH,     sol.prazoMM,     sol.descricao,     sol.resposta,     sol.dataHoraInicio,     sol.dataHoraFim,     sol.situacao,     sol.idSolicitacaoPai,     sol.detalhamentoCausa,     sol.idCausaIncidente,     sol.idCategoriaSolucao,     sol.seqreabertura,     sol.enviaEmailCriacao,     sol.enviaEmailFinalizacao,     sol.enviaEmailAcoes,     sol.idgruponivel1,     sol.solucaoTemporaria,     sol.houveMudanca,     sol.slaACombinar,     sol.prazohhAnterior,     sol.prazommAnterior,     sol.idCalendario,     sol.tempoDecorridoHH,     sol.tempoDecorridoMM,     sol.dataHoraSuspensao,     sol.dataHoraReativacao,     sol.impacto,     sol.urgencia,     sol.dataHoraCaptura,     sol.tempoCapturaHH,     sol.tempoCapturaMM,     sol.tempoAtrasoHH,     sol.tempoAtrasoMM,     sol.tempoAtendimentoHH,     sol.tempoAtendimentoMM,     sol.idacordonivelservico,     sol.idultimaaprovacao,     sol.datahorainiciosla,     sol.datahorasuspensaosla,     sol.datahorareativacaosla,     sol.situacaosla,     sol.idtarefaencerramento,     sol.justificativavencimentosla,     aprov.aprovacao,     s.idservico,     s.nomeServico,     td.idTipoDemandaServico,     td.nomeTipoDemandaServico,     c.idContrato,     c.numero numeroContrato,     e1.nome solicitante,     u1.nome unidade,     e2.nome responsavel,     g1.sigla grupoAtual,     g2.sigla grupoNivel1,     cs.nomecontato,     cs.emailcontato,     cs.telefonecontato,     cs.localizacaofisica,     cs.idlocalidade,     sol.idSolicitacaoRelacionada,     e3.email as emailResponsavel,     sol.codigoExterno FROM     solicitacaoservico sol         INNER JOIN     tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico         LEFT JOIN     servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato         LEFT JOIN     contratos c ON c.idcontrato = sc.idcontrato         LEFT JOIN     servico s ON s.idservico = sc.idservico         LEFT JOIN     empregados e1 ON e1.idempregado = sol.idsolicitante         LEFT JOIN     unidade u1 ON u1.idunidade = e1.idunidade         LEFT JOIN     usuario usu ON usu.idusuario = sol.idresponsavel         LEFT JOIN     empregados e2 ON e2.idempregado = usu.idempregado         LEFT JOIN     unidade u2 ON u2.idunidade = e2.idunidade         LEFT JOIN     origematendimento oa ON oa.idorigem = sol.idorigem         LEFT JOIN     prioridade p ON p.idprioridade = sol.idprioridade         LEFT JOIN     faseservico fs ON fs.idfase = sol.idfaseatual         LEFT JOIN     grupo g1 ON g1.idgrupo = sol.idgrupoatual         LEFT JOIN     grupo g2 ON g2.idgrupo = sol.idgruponivel1         LEFT JOIN     empregados e3 ON e3.idempregado = sol.idresponsavel         LEFT JOIN     contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico         LEFT JOIN     aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'SELECT      sol.idSolicitacaoServico,     sol.idbaseconhecimento,     sol.idServicoContrato,     sol.idSolicitante,     sol.idItemConfiguracao,     sol.idItemConfiguracaoFilho,     sol.idtipodemandaservico,     sol.idcontatosolicitacaoservico,     sol.idOrigem,     sol.idResponsavel,     sol.idTipoProblema,     sol.idPrioridade,     sol.idUnidade,     sol.idFaseAtual,     sol.idGrupoAtual,     sol.dataHoraSolicitacao,     sol.dataHoraLimite,     sol.atendimentoPresencial,     sol.prazoCapturaHH,     sol.prazoCapturaMM,     sol.prazoHH,     sol.prazoMM,     sol.descricao,     sol.resposta,     sol.dataHoraInicio,     sol.dataHoraFim,     sol.situacao,     sol.idSolicitacaoPai,     sol.detalhamentoCausa,     sol.idCausaIncidente,     sol.idCategoriaSolucao,     sol.seqreabertura,     sol.enviaEmailCriacao,     sol.enviaEmailFinalizacao,     sol.enviaEmailAcoes,     sol.idgruponivel1,     sol.solucaoTemporaria,     sol.houveMudanca,     sol.slaACombinar,     sol.prazohhAnterior,     sol.prazommAnterior,     sol.idCalendario,     sol.tempoDecorridoHH,     sol.tempoDecorridoMM,     sol.dataHoraSuspensao,     sol.dataHoraReativacao,     sol.impacto,     sol.urgencia,     sol.dataHoraCaptura,     sol.tempoCapturaHH,     sol.tempoCapturaMM,     sol.tempoAtrasoHH,     sol.tempoAtrasoMM,     sol.tempoAtendimentoHH,     sol.tempoAtendimentoMM,     sol.idacordonivelservico,     sol.idultimaaprovacao,     sol.datahorainiciosla,     sol.datahorasuspensaosla,     sol.datahorareativacaosla,     sol.situacaosla,     sol.idtarefaencerramento,     sol.justificativavencimentosla,     aprov.aprovacao,     s.idservico,     s.nomeServico,     td.idTipoDemandaServico,     td.nomeTipoDemandaServico,     c.idContrato,     c.numero numeroContrato,     e1.nome solicitante,     u1.nome unidade,     e2.nome responsavel,     g1.sigla grupoAtual,     g2.sigla grupoNivel1,     cs.nomecontato,     cs.emailcontato,     cs.telefonecontato,     cs.localizacaofisica,     cs.idlocalidade,     sol.idSolicitacaoRelacionada,     e3.email as emailResponsavel,     sol.codigoExterno FROM     solicitacaoservico sol         INNER JOIN     tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico         LEFT JOIN     servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato         LEFT JOIN     contratos c ON c.idcontrato = sc.idcontrato         LEFT JOIN     servico s ON s.idservico = sc.idservico         LEFT JOIN     empregados e1 ON e1.idempregado = sol.idsolicitante         LEFT JOIN     unidade u1 ON u1.idunidade = e1.idunidade         LEFT JOIN     usuario usu ON usu.idusuario = sol.idresponsavel         LEFT JOIN     empregados e2 ON e2.idempregado = usu.idempregado         LEFT JOIN     unidade u2 ON u2.idunidade = e2.idunidade         LEFT JOIN     origematendimento oa ON oa.idorigem = sol.idorigem         LEFT JOIN     prioridade p ON p.idprioridade = sol.idprioridade         LEFT JOIN     faseservico fs ON fs.idfase = sol.idfaseatual         LEFT JOIN     grupo g1 ON g1.idgrupo = sol.idgrupoatual         LEFT JOIN     grupo g2 ON g2.idgrupo = sol.idgruponivel1         LEFT JOIN     empregados e3 ON e3.idempregado = sol.idresponsavel         LEFT JOIN     contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico         LEFT JOIN     aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}';