MERGE INTO rest_parameter a
	USING (SELECT 1 idrestparameter, 'CONTRACT_ID' identifier, 'ID del contrato' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID del contrato';
		
MERGE INTO rest_parameter a
	USING (SELECT 2 idrestparameter, 'ORIGIN_ID' identifier, 'ID del origen' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID del origen';
		
MERGE INTO rest_parameter a
	USING (SELECT 3 idrestparameter, 'REQUEST_ID' identifier, 'ID del tipo de demanda para solicitudes' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID del tipo de demanda para solicitudes';

MERGE INTO rest_parameter a
	USING (SELECT 4 idrestparameter, 'INCIDENT_ID' identifier, 'ID del tipo de demanda para incidentes' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID del tipo de demanda para incidentes';
		
MERGE INTO rest_parameter a
	USING (SELECT 5 idrestparameter, 'DEFAULT_DEPTO_ID' identifier, 'ID normalizado de la unidad' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID normalizado de la unidad';

MERGE INTO rest_parameter a
	USING (SELECT 6 idrestparameter, 'DEFAULT_SLA' identifier, 'ID normalizado del acuerdo de nivel de servicio' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID normalizado del acuerdo de nivel de servicio';

MERGE INTO rest_parameter a
	USING (SELECT 56 idrestparameter, 'DEFAULT_REASON_ID' identifier, 'ID justificacin normalizada para alteracin de situacin' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID justificacin normalizada para alteracin de situacin';

MERGE INTO rest_parameter a
	USING (SELECT 106 idrestparameter, 'DEFAULT_SERVICE_ID' identifier, 'ID del servicio normalizado' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID del servicio normalizado';

MERGE INTO rest_parameter a
	USING (SELECT 107 idrestparameter, 'CHANGE_USER' identifier, 'Permite alteracin del solicitante' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Permite alteracin del solicitante';
	
MERGE INTO rest_parameter a
	USING (SELECT 108 idrestparameter, 'CHANGE_GROUP' identifier, 'Permite redirecionamento' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Permite redirecionamento';
		
MERGE INTO rest_parameter a
	USING (SELECT 109 idrestparameter, 'CHANGE_SERVICE' identifier, 'Permite reclasificacin' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Permite reclasificacin';

MERGE INTO rest_parameter a
	USING (SELECT 156 idrestparameter, 'DEFAULT_GROUP_ID' identifier, 'ID del grupo executor normalizado' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID del grupo executor normalizado';

MERGE INTO rest_parameter a
	USING (SELECT 157 idrestparameter, 'DEFAULT_DESCRIPTION' identifier, 'Complemento normalizado de la descripcin' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Complemento normalizado de la descripcin';

MERGE INTO rest_parameter a
	USING (SELECT 356 idrestparameter, 'USER' identifier, 'SQL recupera usuario por el login' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'SQL recupera usuario por el login';

MERGE INTO rest_parameter a
	USING (SELECT 357 idrestparameter, 'REQUEST_BY_ID' identifier, 'SQL recupera solicitud/incidente por el ID' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'SQL recupera solicitud/incidente por el ID';

MERGE INTO rest_parameter a
	USING (SELECT 358 idrestparameter, 'REQUEST_BY_DESCRIPTION' identifier, 'SQL recupera solicitud/incidente por la descripcin' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'SQL recupera solicitud/incidente por la descripcin';
		

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation,
			NULL idbatchprocessing, 'addServiceRequest' name, 
			'Creacin de solicitud de servicio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest' javaclass, NULL javascript, 'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Creacin de solicitud de servicio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'listTasks' name, 
			'Listado de tareas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestListTasks' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Listado de tareas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getByUser' name, 
			'Retorna lista de notificaciones para Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna lista de notificaciones para Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getById' name, 
			'Retorna detalles de una notificacin para Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna detalles de una notificacin para Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_feedback' name, 
			'Procesa feedback de una notificacin para Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Procesa feedback de una notificacin para Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_new' name, 
			'Crea una notificacin para Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Crea una notificacin para Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getReasons' name, 
			'Retorna justificaciones posibles para una notificacin' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna justificaciones posibles para una notificacin';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'bicitsmart_recuperarTabelas' name, 
			'Retorna todos los datos de las tablas necesarias para el BI del Citsmart' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestBICitsmart' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna todos los datos de las tablas necesarias para el BI del Citsmart';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_coordinates' name, 
			'Recibe la coordenada de la unidad check-in unidad' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recibe la coordenada de la unidad check-in unidad';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listContracts' name, 
			'Retornar lista de Contratos activos del Citsmart' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retornar lista de Contratos activos del Citsmart';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listDeniedReasons' name, 
			'Lista de Justificacin' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de Justificacin';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listSolicitationStatus' name, 
			'Lista estatus de la solicitud de servicio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista estatus de la solicitud de servicio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listUnits' name, 
			'Lista de unidad de un contrato' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de unidad de un contrato';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_attendantLocation' name, 
			'Localizacin de un atendente' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Localizacin de un atendente';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getNewest' name, 
			'Lista de solicitudes nuevas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de solicitudes nuevas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getOldest' name, 
			'Lista de nuevas solicitudes destinadas al usuario' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de nuevas solicitudes destinadas al usuario';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_checkin' name, 
			'Check-in de la solicitud' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Check-in de la solicitud';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_checkinDenied' name, 
			'Negacin de check-in de una sugerencia de solicitud de servicio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Negacin de check-in de una sugerencia de solicitud de servicio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_checkout' name, 
			'Check-out, finalizacin de una solicitud de servicio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Check-out, finalizacin de una solicitud de servicio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getByCoordinates' name, 
			'Lista de solicitudes nuevas - coordenadas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de solicitudes nuevas - coordenadas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_attendRequest' name, 
			'Atender solicitud' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Atender solicitud';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_deviceDisassociate' name, 
			'Desasociar device del atendente' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Desasociar device del atendente';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_updateNotification' name, 
			'Restaura tareas y permisos de una solicitud de servicio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Restaura tareas y permisos de una solicitud de servicio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getById_v2' name, 
			'Retorna detalles de una notificacin para mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna detalles de una notificacin para mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_create' name, 
			'Crea nuevas solicitudes de servicio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Crea nuevas solicitudes de servicio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_update' name, 
			'Altera solicitudes de servicio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Altera solicitudes de servicio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_updateStatus' name, 
			'Actualiza estatus de una solicitud' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Actualiza estatus de una solicitud';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_getByUser' name, 
			'Consulta solicitudes por usuario' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Consulta solicitudes por usuario';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_getById' name, 
			'Detalla solicitud por el nmero' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Detalla solicitud por el nmero';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_create_occurrence' name, 
			'Crea una ocurrencia de solicitud' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Crea una ocurrencia de solicitud';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_list_occurrences' name, 
			'Lista las ocurrencias de una solicitud' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista las ocurrencias de una solicitud';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_getNotSynchronized' name, 
			'Recupera solicitudes no sincronizadas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recupera solicitudes no sincronizadas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'synchronize' name, 
			'Sincronizacin de datos' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Sincronizacin de datos';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'occurrence_getNotSynchronized' name, 
			'Recupera ocurrencias no sincronizadas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recupera ocurrencias no sincronizadas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'occurrence_synchronize' name, 
			'Sincroniza ocurrencias' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Sincroniza ocurrencias';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'synchronize_find' name, 
			'Recupera lista de objetos de sincronizacin' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recupera lista de objetos de sincronizacin';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'synchronize_delete' name, 
			'Excluye sincronizacin' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Excluye sincronizacin';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'data_query' name, 
			'Ejecuta consultas en la base de datos' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Ejecuta consultas en la base de datos';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_buscaNotificacao' name, 
			'Servicio de bsqueda de solicitudes para el citsmart mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Servicio de bsqueda de solicitudes para el citsmart mobile';


MERGE INTO rest_domain a
	USING (SELECT 1 idrestparameter, 
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';

MERGE INTO rest_domain a
	USING (SELECT 1 idrestparameter,  
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 1 idrestparameter,  
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 2 idrestparameter,   
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'7' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '7';
		
MERGE INTO rest_domain a
	USING (SELECT 2 idrestparameter,    
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'10' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '10';
		
MERGE INTO rest_domain a
	USING (SELECT 3 idrestparameter,     
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 3 idrestparameter,      
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 3 idrestparameter,       
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 4 idrestparameter,        
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 4 idrestparameter,         
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 4 idrestparameter,          
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 5 idrestparameter,           
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 5 idrestparameter,
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 6 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'1421' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1421';
		
MERGE INTO rest_domain a
	USING (SELECT 6 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'1421' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1421';
		
MERGE INTO rest_domain a
	USING (SELECT 56 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_updateStatus') idrestoperation, 
			'7' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '7';
		
MERGE INTO rest_domain a
	USING (SELECT 106 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'5136' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '5136';
		
MERGE INTO rest_domain a
	USING (SELECT 107 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'N' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'N';
		
MERGE INTO rest_domain a
	USING (SELECT 108 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'N' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'N';
		
MERGE INTO rest_domain a
	USING (SELECT 109 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'N' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'N';
		
MERGE INTO rest_domain a
	USING (SELECT 156 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'159' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '159';
		
MERGE INTO rest_domain a
	USING (SELECT 157 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'Solicitud creada por ESI centralizador' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'Solicitud creada por ESI centralizador';
		
MERGE INTO rest_domain a
	USING (SELECT 356 idrestparameter,
			(select idrestoperation from rest_operation where name like 'data_query') idrestoperation, 
			'select idusuario, login, nome, idempregado, status from usuario where login = ${login}' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}';
 
MERGE INTO rest_domain a
	USING (SELECT 357 idrestparameter, 
			(select idrestoperation from rest_operation where name like 'data_query') idrestoperation, 
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}';
		
MERGE INTO rest_domain a
	USING (SELECT 358 idrestparameter, 
			(select idrestoperation from rest_operation where name like 'data_query') idrestoperation, 
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}';