MERGE INTO rest_parameter a
	USING (SELECT 1 idrestparameter, 'CONTRACT_ID' identifier, 'ID do contrato' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID do contrato';
		
MERGE INTO rest_parameter a
	USING (SELECT 2 idrestparameter, 'ORIGIN_ID' identifier, 'ID da origem' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID da origem';
		
MERGE INTO rest_parameter a
	USING (SELECT 3 idrestparameter, 'REQUEST_ID' identifier, 'ID do tipo de demanda para requisies' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID do tipo de demanda para requisies';

MERGE INTO rest_parameter a
	USING (SELECT 4 idrestparameter, 'INCIDENT_ID' identifier, 'ID do tipo de demanda para incidentes' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID do tipo de demanda para incidentes';
		
MERGE INTO rest_parameter a
	USING (SELECT 5 idrestparameter, 'DEFAULT_DEPTO_ID' identifier, 'ID padro da unidade' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID padro da unidade';

MERGE INTO rest_parameter a
	USING (SELECT 6 idrestparameter, 'DEFAULT_SLA' identifier, 'ID padro do acordo de nvel de servio' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID padro do acordo de nvel de servio';

MERGE INTO rest_parameter a
	USING (SELECT 56 idrestparameter, 'DEFAULT_REASON_ID' identifier, 'ID justificativa padro para alterao de situao' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID justificativa padro para alterao de situao';

MERGE INTO rest_parameter a
	USING (SELECT 106 idrestparameter, 'DEFAULT_SERVICE_ID' identifier, 'ID do servio padro' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID do servio padro';

MERGE INTO rest_parameter a
	USING (SELECT 107 idrestparameter, 'CHANGE_USER' identifier, 'Permite alterao do solicitante' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Permite alterao do solicitante';
	
MERGE INTO rest_parameter a
	USING (SELECT 108 idrestparameter, 'CHANGE_GROUP' identifier, 'Permite redirecionamento' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Permite redirecionamento';
		
MERGE INTO rest_parameter a
	USING (SELECT 109 idrestparameter, 'CHANGE_SERVICE' identifier, 'Permite reclassificao' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Permite reclassificao';

MERGE INTO rest_parameter a
	USING (SELECT 156 idrestparameter, 'DEFAULT_GROUP_ID' identifier, 'ID do grupo executor padro' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'ID do grupo executor padro';

MERGE INTO rest_parameter a
	USING (SELECT 157 idrestparameter, 'DEFAULT_DESCRIPTION' identifier, 'Complemento padro da descrio' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Complemento padro da descrio';

MERGE INTO rest_parameter a
	USING (SELECT 356 idrestparameter, 'USER' identifier, 'SQL recupera usurio pelo login' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'SQL recupera usurio pelo login';

MERGE INTO rest_parameter a
	USING (SELECT 357 idrestparameter, 'REQUEST_BY_ID' identifier, 'SQL recupera solicitao/incidente pelo ID' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'SQL recupera solicitao/incidente pelo ID';

MERGE INTO rest_parameter a
	USING (SELECT 358 idrestparameter, 'REQUEST_BY_DESCRIPTION' identifier, 'SQL recupera solicitao/incidente pela descrio' description
			FROM dual) b
	ON (a.idrestparameter = b.idrestparameter)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.identifier, b.description)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'SQL recupera solicitao/incidente pela descrio';
		

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation,
			NULL idbatchprocessing, 'addServiceRequest' name, 
			'Criao de solicitao de servio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest' javaclass, NULL javascript, 'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Criao de solicitao de servio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'listTasks' name, 
			'Listagem de tarefas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestListTasks' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Listagem de tarefas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getByUser' name, 
			'Retorna lista de notificaes para Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna lista de notificaes para Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getById' name, 
			'Retorna detalhes de uma notificao para Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna detalhes de uma notificao para Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_feedback' name, 
			'Processa feedback de uma notificao para Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Processa feedback de uma notificao para Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_new' name, 
			'Cria uma notificao para Mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Cria uma notificao para Mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getReasons' name, 
			'Retorna justificativas possveis para uma notificao' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna justificativas possveis para uma notificao';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'bicitsmart_recuperarTabelas' name, 
			'Retorna todos os dados das tabelas necessrias para o BI do Citsmart' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.operation.RestBICitsmart' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna todos os dados das tabelas necessrias para o BI do Citsmart';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_coordinates' name, 
			'Recebe a coordenada da unidade check-in unidade' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recebe a coordenada da unidade check-in unidade';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listContracts' name, 
			'Retornar lista de  Contratos ativos do Citsmart' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retornar lista de Contratos ativos do Citsmart';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listDeniedReasons' name, 
			'Lista de Justificativa' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de Justificativa';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listSolicitationStatus' name, 
			'Lista status da solicitao de servio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista status da solicitaes de servio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_listUnits' name, 
			'Lista de unidade de um contrato' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de unidade de um contrato';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_attendantLocation' name, 
			'Localizao de um atendente' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Localizao de um atendente';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getNewest' name, 
			'Lista de solicitaes novas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de solicitaes novas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getOldest' name, 
			'Lista de novas solicitaes destinadas ao usurio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de novas solicitaes destinadas ao usurio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_checkin' name, 
			'Check-in da solicitao' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Check-in da solicitao';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_checkinDenied' name, 
			'Negao de check-in de uma sugesto de solicitao de servio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Negao de check-in de uma sugesto de solicitao de servio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_checkout' name, 
			'Check-out, finalizao de uma solicitao de servio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Check-out, finalizao de uma solicitao de servio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getByCoordinates' name, 
			'Lista de solicitaes novas - coordenadas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista de solicitaes novas - coordenadas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_attendRequest' name, 
			'Atender solicitao' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Atender solicitao';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'service_deviceDisassociate' name, 
			'Desassociar device do atendente' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Desassociar device do atendente';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_updateNotification' name, 
			'Restaura tarefas e permisses de uma solicitao de servio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Restaura tarefas e permisses de uma solicitao de servio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_getById_v2' name, 
			'Retorna detalhes de uma notificao para mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Retorna detalhes de uma notificao para mobile';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_create' name, 
			'Cria novas solicitaes de servio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Cria novas solicitaes de servio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_update' name, 
			'Altera solicitaes de servio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Altera solicitaes de servio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_updateStatus' name, 
			'Atualiza status de uma solicitao' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Atualiza status de uma solicitao';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_getByUser' name, 
			'Consulta requisies por usurio' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Consulta requisies por usurio';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_getById' name, 
			'Detalha requisio pelo nmero' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Detalha requisio pelo nmero';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_create_occurrence' name, 
			'Cria uma ocorrncia de solicitao' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Cria uma ocorrncia de solicitao';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_list_occurrences' name, 
			'Lista as ocorrncias de uma solicitao' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Lista as ocorrncias de uma solicitao';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'request_getNotSynchronized' name, 
			'Recupera requisies no sincronizadas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recupera requisies no sincronizadas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'synchronize' name, 
			'Sincronizao de dados' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Sincronizao de dados';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'occurrence_getNotSynchronized' name, 
			'Recupera ocorrncias no sincronizadas' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript, 
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recupera ocorrncias no sincronizadas';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'occurrence_synchronize' name, 
			'Sincroniza ocorrncias' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Sincroniza ocorrncias';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'synchronize_find' name, 
			'Recupera lista de objetos de sincronizao' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Recupera lista de objetos de sincronizao';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'synchronize_delete' name, 
			'Exclui sincronizao' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize' javaclass, NULL javascript,
			'A' status, 'N' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Exclui sincronizao';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'data_query' name, 
			'Executa consultas no banco de dados' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery' javaclass, NULL javascript,
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Executa consultas no banco de dados';

MERGE INTO rest_operation a
	USING (SELECT 
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation) idrestoperation, 
			NULL idbatchprocessing, 'notification_buscaNotificacao' name, 
			'Servio de busca de solicitaes para o citsmart mobile' description, 'Sync' operationtype, 'Java' classtype, 
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile' javaclass, NULL javascript, 
			'A' status, 'Y' generatelog
			FROM dual) b
	ON (a.name = b.name)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestoperation, b.idbatchprocessing, b.name,
				b.description, b.operationtype, b.classtype,
				b.javaclass, b.javascript, b.status, b.generatelog)
	WHEN MATCHED THEN
		UPDATE SET a.description = 'Servio de busca de solicitaes para o citsmart mobile';


MERGE INTO rest_domain a
	USING (SELECT 1 idrestparameter, 
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';

MERGE INTO rest_domain a
	USING (SELECT 1 idrestparameter,  
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 1 idrestparameter,  
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 2 idrestparameter,   
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'7' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '7';
		
MERGE INTO rest_domain a
	USING (SELECT 2 idrestparameter,    
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'10' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '10';
		
MERGE INTO rest_domain a
	USING (SELECT 3 idrestparameter,     
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 3 idrestparameter,      
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 3 idrestparameter,       
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'1' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1';
		
MERGE INTO rest_domain a
	USING (SELECT 4 idrestparameter,        
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 4 idrestparameter,         
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 4 idrestparameter,          
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 5 idrestparameter,           
			(select idrestoperation from rest_operation where name like 'addServiceRequest') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 5 idrestparameter,
			(select idrestoperation from rest_operation where name like 'notification_new') idrestoperation, 
			'3' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '3';
		
MERGE INTO rest_domain a
	USING (SELECT 6 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'1421' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1421';
		
MERGE INTO rest_domain a
	USING (SELECT 6 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'1421' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '1421';
		
MERGE INTO rest_domain a
	USING (SELECT 56 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_updateStatus') idrestoperation, 
			'7' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '7';
		
MERGE INTO rest_domain a
	USING (SELECT 106 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'5136' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '5136';
		
MERGE INTO rest_domain a
	USING (SELECT 107 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'N' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'N';
		
MERGE INTO rest_domain a
	USING (SELECT 108 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'N' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'N';
		
MERGE INTO rest_domain a
	USING (SELECT 109 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_update') idrestoperation, 
			'N' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'N';
		
MERGE INTO rest_domain a
	USING (SELECT 156 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'159' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = '159';
		
MERGE INTO rest_domain a
	USING (SELECT 157 idrestparameter,
			(select idrestoperation from rest_operation where name like 'request_create') idrestoperation, 
			'Requisio criada por ESI centralizador' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'Requisio criada por ESI centralizador';
		
MERGE INTO rest_domain a
	USING (SELECT 356 idrestparameter,
			(select idrestoperation from rest_operation where name like 'data_query') idrestoperation, 
			'select idusuario, login, nome, idempregado, status from usuario where login = ${login}' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}';
 
MERGE INTO rest_domain a
	USING (SELECT 357 idrestparameter, 
			(select idrestoperation from rest_operation where name like 'data_query') idrestoperation, 
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}';
		
MERGE INTO rest_domain a
	USING (SELECT 358 idrestparameter, 
			(select idrestoperation from rest_operation where name like 'data_query') idrestoperation, 
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}' value
			FROM dual) b
	ON (
		(a.idrestparameter = b.idrestparameter) AND
		(a.idrestoperation = b.idrestoperation)
		)
	WHEN NOT MATCHED THEN
		INSERT VALUES (b.idrestparameter, b.idrestoperation, b.value)
	WHEN MATCHED THEN
		UPDATE SET a.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}';