UPDATE rest_parameter SET description = 'Contract ID'
	WHERE identifier ILIKE 'CONTRACT_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	1 ,'CONTRACT_ID', 'Contract ID' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID');


UPDATE rest_parameter SET description = 'Origin ID'
	WHERE identifier ILIKE 'ORIGIN_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 2, 'ORIGIN_ID', 'Origin ID' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID');
	
	
UPDATE rest_parameter SET description = 'Type of demand ID for requests'
	WHERE identifier ILIKE 'INCIDENT_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	4, 'INCIDENT_ID', 'Type of demand ID for requests'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID');
	
	
UPDATE rest_parameter SET description = 'Type of demand ID for incidents'
	WHERE identifier ILIKE 'REQUEST_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	3, 'REQUEST_ID', 'Type of demand ID for incidents'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID');
	
	
UPDATE rest_parameter SET description = 'Default dept ID'
	WHERE identifier ILIKE 'DEFAULT_DEPTO_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 5, 'DEFAULT_DEPTO_ID', 'Default dept ID' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID');
	

UPDATE rest_parameter SET description = 'Default ID to service level agreement'
	WHERE identifier ILIKE 'DEFAULT_SLA';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 6, 'DEFAULT_SLA', 'Default ID to service level agreement' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA');
	

UPDATE rest_parameter SET description = 'Default ID justification to change the situation'
	WHERE identifier ILIKE 'DEFAULT_REASON_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 56, 'DEFAULT_REASON_ID', 'Default ID justification to change the situation' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID');
	

UPDATE rest_parameter SET description = 'Default Service ID'
	WHERE identifier ILIKE 'DEFAULT_SERVICE_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 106, 'DEFAULT_SERVICE_ID', 'Default Service ID' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID');
	

UPDATE rest_parameter SET description = 'Allows modification of the requestor'
	WHERE identifier ILIKE 'CHANGE_USER';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 107, 'CHANGE_USER', 'Allows modification of the requestor' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER');
	

UPDATE rest_parameter SET description = 'Allows redirection'
	WHERE identifier ILIKE 'CHANGE_GROUP';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 108, 'CHANGE_GROUP', 'Allows redirection'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP');
	

UPDATE rest_parameter SET description = 'Allows reclassification'
	WHERE identifier ILIKE 'CHANGE_SERVICE';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 109, 'CHANGE_SERVICE', 'Allows reclassification' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE');
	

UPDATE rest_parameter SET description = 'Group ID default executor'
	WHERE identifier ILIKE 'DEFAULT_GROUP_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 156, 'DEFAULT_GROUP_ID', 'Group ID default executor'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID');
	

UPDATE rest_parameter SET description = 'Standard complement description'
	WHERE identifier ILIKE 'DEFAULT_DESCRIPTION';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 157, 'DEFAULT_DESCRIPTION', 'Standard complement description' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION');
	

UPDATE rest_parameter SET description = 'SQL retrieve user login'
	WHERE identifier ILIKE 'USER';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 356, 'USER', 'SQL retrieve user login'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'USER');
	

UPDATE rest_parameter SET description = 'SQL recover request / incident by ID'
	WHERE identifier ILIKE 'REQUEST_BY_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 357, 'REQUEST_BY_ID', 'SQL recover request / incident by ID'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID');
	

UPDATE rest_parameter SET description = 'SQL recover request / incident by description'
	WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 358, 'REQUEST_BY_DESCRIPTION', 'SQL recover request / incident by description'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION');


UPDATE rest_operation SET description = 'Create service request'
	WHERE name ILIKE 'addServiceRequest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	 NULL, 'addServiceRequest',
	'Create service request', 'Sync', 'Java', 
	'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'addServiceRequest');


UPDATE rest_operation SET description = 'Listing Tasks'
	WHERE name ILIKE 'listTasks';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'listTasks', 
	'Listing Tasks',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestListTasks', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'listTasks');
	

UPDATE rest_operation SET description = 'Return notification list for mobile'
	WHERE name ILIKE 'notification_getByUser';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getByUser', 
	'Return notification list for mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getByUser');
	

UPDATE rest_operation SET description = 'Returns details of a notification to Mobile'
	WHERE name ILIKE 'notification_getById';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getById', 
	'Returns details of a notification to Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getById');
	

UPDATE rest_operation SET description = 'Processes feedback from a notification to Mobile'
	WHERE name ILIKE 'notification_feedback';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_feedback', 
	'Processes feedback from a notification to Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_feedback');
	

UPDATE rest_operation SET description = 'Create a notification to Mobile'
	WHERE name ILIKE 'notification_new';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_new', 
	'Create a notification to Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_new');
	

UPDATE rest_operation SET description = 'Returns possible justifications for a notification'
	WHERE name ILIKE 'notification_getReasons';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getReasons', 
	'Returns possible justifications for a notification',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getReasons');
	

UPDATE rest_operation SET description = 'Returns all data of the required tables to the BI Citsmart'
	WHERE name ILIKE 'bicitsmart_recuperarTabelas';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'bicitsmart_recuperarTabelas', 
	'Returns all data of the required tables to the BI Citsmart',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestBICitsmart', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'bicitsmart_recuperarTabelas');
	

UPDATE rest_operation SET description = 'Gets the unit coordinate check in Unit'
	WHERE name ILIKE 'service_coordinates';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_coordinates', 
	'Gets the unit coordinate check in Unit',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_coordinates');
	

UPDATE rest_operation SET description = 'Return list of active Citsmart contracts'
	WHERE name ILIKE 'service_listContracts';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listContracts', 
	'Return list of active Citsmart contracts',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listContracts');
	

UPDATE rest_operation SET description = 'List justifications'
	WHERE name ILIKE 'service_listDeniedReasons';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listDeniedReasons', 
	'List justifications',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listDeniedReasons');
	

UPDATE rest_operation SET description = 'List status of service request'
	WHERE name ILIKE 'service_listSolicitationStatus';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listSolicitationStatus', 
	'List status of service request',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listSolicitationStatus');
	

UPDATE rest_operation SET description = 'List of contract unit'
	WHERE name ILIKE 'service_listUnits';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listUnits', 
	'List of contract unit',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listUnits');
	

UPDATE rest_operation SET description = 'Location of an attendant'
	WHERE name ILIKE 'notification_attendantLocation';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_attendantLocation', 
	'Location of an attendant',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_attendantLocation');
	

UPDATE rest_operation SET description = 'New request list'
	WHERE name ILIKE 'notification_getNewest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getNewest', 
	'New request list',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getNewest');
	

UPDATE rest_operation SET description = 'Request list intended for new user'
	WHERE name ILIKE 'notification_getOldest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getOldest', 
	'Request list intended for new user',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getOldest');
	

UPDATE rest_operation SET description = 'Check-in request'
	WHERE name ILIKE 'notification_checkin';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_checkin', 
	'Check-in request',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_checkin');
	

UPDATE rest_operation SET description = 'Denial Check - in a service request suggestion'
	WHERE name ILIKE 'notification_checkinDenied';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_checkinDenied', 
	'Denial Check - in a service request suggestion',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_checkinDenied');
	

UPDATE rest_operation SET description = 'Check-out, completion of a service request'
	WHERE name ILIKE 'notification_checkout';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_checkout', 
	'Check-out, completion of a service request',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_checkout');
	

UPDATE rest_operation SET description = 'New request list - Coordinates'
	WHERE name ILIKE 'notification_getByCoordinates';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getByCoordinates', 
	'New request list - Coordinates',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getByCoordinates');
	

UPDATE rest_operation SET description = 'Attending Request'
	WHERE name ILIKE 'notification_attendRequest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_attendRequest', 
	'Attending Request',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_attendRequest');
	

UPDATE rest_operation SET description = 'Disassociate device attendant'
	WHERE name ILIKE 'service_deviceDisassociate';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_deviceDisassociate', 
	'Disassociate device attendant',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_deviceDisassociate');
	

UPDATE rest_operation SET description = 'Restore tasks and permissions of a service request'
	WHERE name ILIKE 'notification_updateNotification';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_updateNotification', 
	'Restore tasks and permissions of a service request',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_updateNotification');
	

UPDATE rest_operation SET description = 'Returns details of a notification for Mobile'
	WHERE name ILIKE 'notification_getById_v2';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getById_v2', 
	'Returns details of a notification for Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getById_v2');
	

UPDATE rest_operation SET description = 'Create new service requests'
	WHERE name ILIKE 'request_create';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_create', 
	'Create new service requests',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_create');
	

UPDATE rest_operation SET description = 'Change service request'
	WHERE name ILIKE 'request_update';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_update', 
	'Change service request',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_update');
	

UPDATE rest_operation SET description = 'Updates status of a request'
	WHERE name ILIKE 'request_updateStatus';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_updateStatus', 
	'Updates status of a request',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_updateStatus');
	

UPDATE rest_operation SET description = 'Consultation requests per user'
	WHERE name ILIKE 'request_getByUser';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_getByUser', 
	'Consultation requests per user',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_getByUser');
	

UPDATE rest_operation SET description = 'Request details by the number'
	WHERE name ILIKE 'request_getById';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_getById', 
	'Request details by the number',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_getById');
	

UPDATE rest_operation SET description = 'Create a request for incidents'
	WHERE name ILIKE 'request_create_occurrence';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_create_occurrence', 
	'Create a request for incidents',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_create_occurrence');
	

UPDATE rest_operation SET description = 'List instances of a request'
	WHERE name ILIKE 'request_list_occurrences';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_list_occurrences', 
	'List instances of a request',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_list_occurrences');
	

UPDATE rest_operation SET description = 'Recover unsynchronized requests'
	WHERE name ILIKE 'request_getNotSynchronized';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_getNotSynchronized', 
	'Recover unsynchronized requests',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_getNotSynchronized');
	

UPDATE rest_operation SET description = 'Data synchronization'
	WHERE name ILIKE 'synchronize';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'synchronize', 
	'Data synchronization',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'synchronize');
	

UPDATE rest_operation SET description = 'Recover unsynchronized events'
	WHERE name ILIKE 'occurrence_getNotSynchronized';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'occurrence_getNotSynchronized', 
	'Recover unsynchronized events',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'occurrence_getNotSynchronized');
	

UPDATE rest_operation SET description = 'Synchronizes events'
	WHERE name ILIKE 'occurrence_synchronize';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'occurrence_synchronize', 
	'Synchronizes events',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'occurrence_synchronize');
	

UPDATE rest_operation SET description = 'Retrieve synchronization objects list'
	WHERE name ILIKE 'synchronize_find';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'synchronize_find', 
	'Retrieve synchronization objects list',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'synchronize_find');
	

UPDATE rest_operation SET description = 'Delete synchronization'
	WHERE name ILIKE 'synchronize_delete';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'synchronize_delete', 
	'Delete synchronization',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'synchronize_delete');
	

UPDATE rest_operation SET description = 'Execute queries on the database'
	WHERE name ILIKE 'data_query';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'data_query', 
	'Execute queries on the database',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'data_query');
	

UPDATE rest_operation SET description = 'Search service of requests to the mobile Citsmart'
	WHERE name ILIKE 'notification_buscaNotificacao';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_buscaNotificacao', 
	'Search service of requests to the mobile Citsmart',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_buscaNotificacao');
	

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '7' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'7'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '10' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'10'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));


UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '1421' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'1421'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '1421' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'1421'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = '7' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_updateStatus');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_updateStatus'),
	'7'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_updateStatus'));
		

UPDATE rest_domain SET value = '5136' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'5136'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = 'N' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = 'N' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = 'N' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = '159' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'159'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = 'Requisition created by ESI centralizer' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'Requisition created by ESI centralizer'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'USER') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'USER'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'),
	'select idusuario, login, nome, idempregado, status from usuario where login = ${login}'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'USER') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'));
		

UPDATE rest_domain SET value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'),
	'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'));
		

UPDATE rest_domain SET value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'),
	'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'));

