UPDATE rest_parameter SET description = 'ID del contrato'
	WHERE identifier ILIKE 'CONTRACT_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	1 ,'CONTRACT_ID', 'ID del contrato' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID');


UPDATE rest_parameter SET description = 'ID del origen'
	WHERE identifier ILIKE 'ORIGIN_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 2, 'ORIGIN_ID', 'ID del origen' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID');
	
	
UPDATE rest_parameter SET description = 'ID del tipo de demanda para solicitudes'
	WHERE identifier ILIKE 'INCIDENT_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	4, 'INCIDENT_ID', 'ID del tipo de demanda para solicitudes'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID');
	
	
UPDATE rest_parameter SET description = 'ID del tipo de demanda para incidentes'
	WHERE identifier ILIKE 'REQUEST_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	3, 'REQUEST_ID', 'ID del tipo de demanda para incidentes'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID');
	
	
UPDATE rest_parameter SET description = 'ID normalizado de la unidad'
	WHERE identifier ILIKE 'DEFAULT_DEPTO_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 5, 'DEFAULT_DEPTO_ID', 'ID normalizado de la unidad' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID');
	

UPDATE rest_parameter SET description = 'ID normalizado del acuerdo de nivel de servicio'
	WHERE identifier ILIKE 'DEFAULT_SLA';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 6, 'DEFAULT_SLA', 'ID normalizado del acuerdo de nivel de servicio' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA');
	

UPDATE rest_parameter SET description = 'ID justificacin normalizada para alteracin de situacin'
	WHERE identifier ILIKE 'DEFAULT_REASON_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 56, 'DEFAULT_REASON_ID', 'ID justificacin normalizada para alteracin de situacin' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID');
	

UPDATE rest_parameter SET description = 'ID del servicio normalizado'
	WHERE identifier ILIKE 'DEFAULT_SERVICE_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 106, 'DEFAULT_SERVICE_ID', 'ID del servicio normalizado' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID');
	

UPDATE rest_parameter SET description = 'Permite alteracin del solicitante'
	WHERE identifier ILIKE 'CHANGE_USER';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 107, 'CHANGE_USER', 'Permite alteracin del solicitante' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER');
	

UPDATE rest_parameter SET description = 'Permite redirecionamento'
	WHERE identifier ILIKE 'CHANGE_GROUP';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 108, 'CHANGE_GROUP', 'Permite redirecionamento'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP');
	

UPDATE rest_parameter SET description = 'Permite reclasificacin'
	WHERE identifier ILIKE 'CHANGE_SERVICE';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 109, 'CHANGE_SERVICE', 'Permite reclasificacin' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE');
	

UPDATE rest_parameter SET description = 'ID del grupo executor normalizado'
	WHERE identifier ILIKE 'DEFAULT_GROUP_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 156, 'DEFAULT_GROUP_ID', 'ID del grupo executor normalizado'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID');
	

UPDATE rest_parameter SET description = 'Complemento normalizado de la descripcin'
	WHERE identifier ILIKE 'DEFAULT_DESCRIPTION';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 157, 'DEFAULT_DESCRIPTION', 'Complemento normalizado de la descripcin' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION');
	

UPDATE rest_parameter SET description = 'SQL recupera usuario por el login'
	WHERE identifier ILIKE 'USER';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 356, 'USER', 'SQL recupera usuario por el login'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'USER');
	

UPDATE rest_parameter SET description = 'SQL recover request / incident by ID'
	WHERE identifier ILIKE 'REQUEST_BY_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 357, 'REQUEST_BY_ID', 'SQL recover request / incident by ID'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID');
	

UPDATE rest_parameter SET description = 'SQL recupera solicitud/incidente por el ID'
	WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 358, 'REQUEST_BY_DESCRIPTION', 'SQL recupera solicitud/incidente por la descripcin'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION');


UPDATE rest_operation SET description = 'Creacin de solicitud de servicio'
	WHERE name ILIKE 'addServiceRequest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	 NULL, 'addServiceRequest',
	'Creacin de solicitud de servicio', 'Sync', 'Java', 
	'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'addServiceRequest');


UPDATE rest_operation SET description = 'Listado de tareas'
	WHERE name ILIKE 'listTasks';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'listTasks', 
	'Listado de tareas',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestListTasks', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'listTasks');
	

UPDATE rest_operation SET description = 'Retorna lista de notificaciones para Mobile'
	WHERE name ILIKE 'notification_getByUser';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getByUser', 
	'Retorna lista de notificaciones para Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getByUser');
	

UPDATE rest_operation SET description = 'Retorna detalles de una notificacin para Mobile'
	WHERE name ILIKE 'notification_getById';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getById', 
	'Retorna detalles de una notificacin para Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getById');
	

UPDATE rest_operation SET description = 'Procesa feedback de una notificacin para Mobile'
	WHERE name ILIKE 'notification_feedback';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_feedback', 
	'Procesa feedback de una notificacin para Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_feedback');
	

UPDATE rest_operation SET description = 'Crea una notificacin para Mobile'
	WHERE name ILIKE 'notification_new';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_new', 
	'Crea una notificacin para Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_new');
	

UPDATE rest_operation SET description = 'Retorna justificaciones posibles para una notificacin'
	WHERE name ILIKE 'notification_getReasons';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getReasons', 
	'Retorna justificaciones posibles para una notificacin',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getReasons');
	

UPDATE rest_operation SET description = 'Retorna todos los datos de las tablas necesarias para el BI del Citsmart'
	WHERE name ILIKE 'bicitsmart_recuperarTabelas';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'bicitsmart_recuperarTabelas', 
	'Retorna todos los datos de las tablas necesarias para el BI del Citsmart',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestBICitsmart', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'bicitsmart_recuperarTabelas');
	

UPDATE rest_operation SET description = 'Recibe la coordenada de la unidad check-in unidad'
	WHERE name ILIKE 'service_coordinates';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_coordinates', 
	'Recibe la coordenada de la unidad check-in unidad',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_coordinates');
	

UPDATE rest_operation SET description = 'Retornar lista de Contratos activos del Citsmart'
	WHERE name ILIKE 'service_listContracts';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listContracts', 
	'Retornar lista de Contratos activos del Citsmart',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listContracts');
	

UPDATE rest_operation SET description = 'Lista de Justificacin'
	WHERE name ILIKE 'service_listDeniedReasons';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listDeniedReasons', 
	'Lista de Justificacin',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listDeniedReasons');
	

UPDATE rest_operation SET description = 'Lista estatus de la solicitud de servicio'
	WHERE name ILIKE 'service_listSolicitationStatus';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listSolicitationStatus', 
	'Lista estatus de la solicitud de servicio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listSolicitationStatus');
	

UPDATE rest_operation SET description = 'Lista de unidad de un contrato'
	WHERE name ILIKE 'service_listUnits';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listUnits', 
	'Lista de unidad de un contrato',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listUnits');
	

UPDATE rest_operation SET description = 'Localizacin de un atendente'
	WHERE name ILIKE 'notification_attendantLocation';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_attendantLocation', 
	'Localizacin de un atendente',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_attendantLocation');
	

UPDATE rest_operation SET description = 'Lista de solicitudes nuevas'
	WHERE name ILIKE 'notification_getNewest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getNewest', 
	'Lista de solicitudes nuevas',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getNewest');
	

UPDATE rest_operation SET description = 'Lista de nuevas solicitudes destinadas al usuario'
	WHERE name ILIKE 'notification_getOldest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getOldest', 
	'Lista de nuevas solicitudes destinadas al usuario',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getOldest');
	

UPDATE rest_operation SET description = 'Check-in de la solicitud'
	WHERE name ILIKE 'notification_checkin';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_checkin', 
	'Check-in de la solicitud',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_checkin');
	

UPDATE rest_operation SET description = 'Negacin de check-in de una sugerencia de solicitud de servicio'
	WHERE name ILIKE 'notification_checkinDenied';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_checkinDenied', 
	'Negacin de check-in de una sugerencia de solicitud de servicio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_checkinDenied');
	

UPDATE rest_operation SET description = 'Check-out, finalizacin de una solicitud de servicio'
	WHERE name ILIKE 'notification_checkout';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_checkout', 
	'Check-out, finalizacin de una solicitud de servicio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_checkout');
	

UPDATE rest_operation SET description = 'Lista de solicitudes nuevas - coordenadas'
	WHERE name ILIKE 'notification_getByCoordinates';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'Lista de solicitudes nuevas - coordenadas', 
	'New request list - Coordinates',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getByCoordinates');
	

UPDATE rest_operation SET description = 'Atender solicitud'
	WHERE name ILIKE 'notification_attendRequest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_attendRequest', 
	'Atender solicitud',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_attendRequest');
	

UPDATE rest_operation SET description = 'Desasociar device del atendente'
	WHERE name ILIKE 'service_deviceDisassociate';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_deviceDisassociate', 
	'Desasociar device del atendente',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_deviceDisassociate');
	

UPDATE rest_operation SET description = 'Restaura tareas y permisos de una solicitud de servicio'
	WHERE name ILIKE 'notification_updateNotification';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_updateNotification', 
	'Restaura tareas y permisos de una solicitud de servicio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_updateNotification');
	

UPDATE rest_operation SET description = 'Retorna detalles de una notificacin para mobile'
	WHERE name ILIKE 'notification_getById_v2';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getById_v2', 
	'Retorna detalles de una notificacin para mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getById_v2');
	

UPDATE rest_operation SET description = 'Crea nuevas solicitudes de servicio'
	WHERE name ILIKE 'request_create';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_create', 
	'Crea nuevas solicitudes de servicio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_create');
	

UPDATE rest_operation SET description = 'Altera solicitudes de servicio'
	WHERE name ILIKE 'request_update';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_update', 
	'Altera solicitudes de servicio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_update');
	

UPDATE rest_operation SET description = 'Actualiza estatus de una solicitud'
	WHERE name ILIKE 'request_updateStatus';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_updateStatus', 
	'Actualiza estatus de una solicitud',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_updateStatus');
	

UPDATE rest_operation SET description = 'Consultation requests per user'
	WHERE name ILIKE 'request_getByUser';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_getByUser', 
	'Consultation requests per user',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_getByUser');
	

UPDATE rest_operation SET description = 'Detalla solicitud por el nmero'
	WHERE name ILIKE 'request_getById';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_getById', 
	'Detalla solicitud por el nmero',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_getById');
	

UPDATE rest_operation SET description = 'Crea una ocurrencia de solicitud'
	WHERE name ILIKE 'request_create_occurrence';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_create_occurrence', 
	'Crea una ocurrencia de solicitud',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_create_occurrence');
	

UPDATE rest_operation SET description = 'Lista las ocurrencias de una solicitud'
	WHERE name ILIKE 'request_list_occurrences';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_list_occurrences', 
	'Lista las ocurrencias de una solicitud',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_list_occurrences');
	

UPDATE rest_operation SET description = 'Recupera solicitudes no sincronizadas'
	WHERE name ILIKE 'request_getNotSynchronized';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_getNotSynchronized', 
	'Recupera solicitudes no sincronizadas',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_getNotSynchronized');
	

UPDATE rest_operation SET description = 'Sincronizacin de datos'
	WHERE name ILIKE 'synchronize';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'synchronize', 
	'Sincronizacin de datos',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'synchronize');
	

UPDATE rest_operation SET description = 'Recupera ocurrencias no sincronizadas'
	WHERE name ILIKE 'occurrence_getNotSynchronized';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'occurrence_getNotSynchronized', 
	'Recupera ocurrencias no sincronizadas',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'occurrence_getNotSynchronized');
	

UPDATE rest_operation SET description = 'Sincroniza ocurrencias'
	WHERE name ILIKE 'occurrence_synchronize';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'occurrence_synchronize', 
	'Sincroniza ocurrencias',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'occurrence_synchronize');
	

UPDATE rest_operation SET description = 'Recupera lista de objetos de sincronizacin'
	WHERE name ILIKE 'synchronize_find';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'synchronize_find', 
	'Recupera lista de objetos de sincronizacin',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'synchronize_find');
	

UPDATE rest_operation SET description = 'Excluye sincronizacin'
	WHERE name ILIKE 'synchronize_delete';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'synchronize_delete', 
	'Excluye sincronizacin',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'synchronize_delete');
	

UPDATE rest_operation SET description = 'Ejecuta consultas en la base de datos'
	WHERE name ILIKE 'data_query';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'data_query', 
	'Ejecuta consultas en la base de datos',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'data_query');
	

UPDATE rest_operation SET description = 'Servicio de bsqueda de solicitudes para el citsmart mobile'
	WHERE name ILIKE 'notification_buscaNotificacao';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_buscaNotificacao', 
	'Servicio de bsqueda de solicitudes para el citsmart mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_buscaNotificacao');
	

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '7' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'7'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '10' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'10'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));


UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '1421' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'1421'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '1421' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'1421'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = '7' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_updateStatus');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_updateStatus'),
	'7'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_updateStatus'));
		

UPDATE rest_domain SET value = '5136' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'5136'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = 'N' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = 'N' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = 'N' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = '159' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'159'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = 'Solicitud creada por ESI centralizador' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'Solicitud creada por ESI centralizador'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'USER') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'USER'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'),
	'select idusuario, login, nome, idempregado, status from usuario where login = ${login}'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'USER') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'));
		

UPDATE rest_domain SET value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'),
	'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'));
		

UPDATE rest_domain SET value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'),
	'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'));

