UPDATE rest_parameter SET description = 'ID do contrato'
	WHERE identifier ILIKE 'CONTRACT_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	1 ,'CONTRACT_ID', 'ID do contrato' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID');


UPDATE rest_parameter SET description = 'ID da origem'
	WHERE identifier ILIKE 'ORIGIN_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 2, 'ORIGIN_ID', 'ID da origem' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID');
	
	
UPDATE rest_parameter SET description = 'ID do tipo de demanda para incidentes'
	WHERE identifier ILIKE 'INCIDENT_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	4, 'INCIDENT_ID', 'ID do tipo de demanda para incidentes'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID');
	
	
UPDATE rest_parameter SET description = 'ID do tipo de demanda para requisies'
	WHERE identifier ILIKE 'REQUEST_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	3, 'REQUEST_ID', 'ID do tipo de demanda para requisies'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID');
	
	
UPDATE rest_parameter SET description = 'ID padro da unidade'
	WHERE identifier ILIKE 'DEFAULT_DEPTO_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 5, 'DEFAULT_DEPTO_ID', 'ID padro da unidade' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID');
	

UPDATE rest_parameter SET description = 'ID padro do acordo de nvel de servio'
	WHERE identifier ILIKE 'DEFAULT_SLA';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 6, 'DEFAULT_SLA', 'ID padro do acordo de nvel de servio' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA');
	

UPDATE rest_parameter SET description = 'ID justificativa padro para alterao de situao'
	WHERE identifier ILIKE 'DEFAULT_REASON_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 56, 'DEFAULT_REASON_ID', 'ID justificativa padro para alterao de situao' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID');
	

UPDATE rest_parameter SET description = 'ID do servio padro'
	WHERE identifier ILIKE 'DEFAULT_SERVICE_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 106, 'DEFAULT_SERVICE_ID', 'ID do servio padro' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID');
	

UPDATE rest_parameter SET description = 'Permite alterao do solicitante'
	WHERE identifier ILIKE 'CHANGE_USER';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 107, 'CHANGE_USER', 'Permite alterao do solicitante' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER');
	

UPDATE rest_parameter SET description = 'Permite redirecionamento'
	WHERE identifier ILIKE 'CHANGE_GROUP';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 108, 'CHANGE_GROUP', 'Permite redirecionamento'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP');
	

UPDATE rest_parameter SET description = 'Permite reclassificao'
	WHERE identifier ILIKE 'CHANGE_SERVICE';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 109, 'CHANGE_SERVICE', 'Permite reclassificao' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE');
	

UPDATE rest_parameter SET description = 'ID do grupo executor padro'
	WHERE identifier ILIKE 'DEFAULT_GROUP_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 156, 'DEFAULT_GROUP_ID', 'ID do grupo executor padro'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID');
	

UPDATE rest_parameter SET description = 'Complemento padro da descrio'
	WHERE identifier ILIKE 'DEFAULT_DESCRIPTION';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 157, 'DEFAULT_DESCRIPTION', 'Complemento padro da descrio' 
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION');
	

UPDATE rest_parameter SET description = 'SQL recupera usurio pelo login'
	WHERE identifier ILIKE 'USER';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 356, 'USER', 'SQL recupera usurio pelo login'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'USER');
	

UPDATE rest_parameter SET description = 'SQL recupera solicitao/incidente pelo ID'
	WHERE identifier ILIKE 'REQUEST_BY_ID';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 357, 'REQUEST_BY_ID', 'SQL recupera solicitao/incidente pelo ID'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID');
	

UPDATE rest_parameter SET description = 'SQL recupera solicitao/incidente pela descrio'
	WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION';
INSERT INTO rest_parameter(
	idrestparameter, identifier, description) 
SELECT 
	 358, 'REQUEST_BY_DESCRIPTION', 'SQL recupera solicitao/incidente pela descrio'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION');


UPDATE rest_operation SET description = 'Criao de solicitao de servio'
	WHERE name ILIKE 'addServiceRequest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	 NULL, 'addServiceRequest',
	'Criao de solicitao de servio', 'Sync', 'Java', 
	'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'addServiceRequest');


UPDATE rest_operation SET description = 'Listagem de tarefas'
	WHERE name ILIKE 'listTasks';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'listTasks', 
	'Listagem de tarefas',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestListTasks', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'listTasks');
	

UPDATE rest_operation SET description = 'Retorna lista de notificaes para Mobile'
	WHERE name ILIKE 'notification_getByUser';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getByUser', 
	'Retorna lista de notificaes para Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getByUser');
	

UPDATE rest_operation SET description = 'Retorna detalhes de uma notificao para Mobile'
	WHERE name ILIKE 'notification_getById';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getById', 
	'Retorna detalhes de uma notificao para Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getById');
	

UPDATE rest_operation SET description = 'Processa feedback de uma notificao para Mobile'
	WHERE name ILIKE 'notification_feedback';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_feedback', 
	'Processa feedback de uma notificao para Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_feedback');
	

UPDATE rest_operation SET description = 'Cria uma notificao para Mobile'
	WHERE name ILIKE 'notification_new';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_new', 
	'Cria uma notificao para Mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_new');
	

UPDATE rest_operation SET description = 'Retorna justificativas possveis para uma notificao'
	WHERE name ILIKE 'notification_getReasons';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getReasons', 
	'Retorna justificativas possveis para uma notificao',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getReasons');
	

UPDATE rest_operation SET description = 'Retorna todos os dados das tabelas necessrias para o BI do Citsmart'
	WHERE name ILIKE 'bicitsmart_recuperarTabelas';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'bicitsmart_recuperarTabelas', 
	'Retorna todos os dados das tabelas necessrias para o BI do Citsmart',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.operation.RestBICitsmart', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'bicitsmart_recuperarTabelas');
	

UPDATE rest_operation SET description = 'Recebe a coordenada da unidade check-in unidade'
	WHERE name ILIKE 'service_coordinates';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_coordinates', 
	'Recebe a coordenada da unidade check-in unidade',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_coordinates');
	

UPDATE rest_operation SET description = 'Retornar lista de Contratos ativos do Citsmart'
	WHERE name ILIKE 'service_listContracts';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listContracts', 
	'Retornar lista de  Contratos ativos do Citsmart',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listContracts');
	

UPDATE rest_operation SET description = 'Lista de Justificativa'
	WHERE name ILIKE 'service_listDeniedReasons';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listDeniedReasons', 
	'Lista de Justificativa',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listDeniedReasons');
	

UPDATE rest_operation SET description = 'Lista status da solicitaes de servio'
	WHERE name ILIKE 'service_listSolicitationStatus';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listSolicitationStatus', 
	'Lista status da solicitao de servio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listSolicitationStatus');
	

UPDATE rest_operation SET description = 'Lista de unidade de um contrato'
	WHERE name ILIKE 'service_listUnits';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_listUnits', 
	'Lista de unidade de um contrato',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_listUnits');
	

UPDATE rest_operation SET description = 'Localizao de um atendente'
	WHERE name ILIKE 'notification_attendantLocation';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_attendantLocation', 
	'Localizao de um atendente',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_attendantLocation');
	

UPDATE rest_operation SET description = 'Lista de solicitaes novas'
	WHERE name ILIKE 'notification_getNewest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getNewest', 
	'Lista de solicitaes novas',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getNewest');
	

UPDATE rest_operation SET description = 'Lista de novas solicitaes destinadas ao usurio'
	WHERE name ILIKE 'notification_getOldest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getOldest', 
	'Lista de novas solicitaes destinadas ao usurio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getOldest');
	

UPDATE rest_operation SET description = 'Check-in da solicitao'
	WHERE name ILIKE 'notification_checkin';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_checkin', 
	'Check-in da solicitao',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_checkin');
	

UPDATE rest_operation SET description = 'Negao de check-in de uma sugesto de solicitao de servio'
	WHERE name ILIKE 'notification_checkinDenied';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_checkinDenied', 
	'Negao de check-in de uma sugesto de solicitao de servio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_checkinDenied');
	

UPDATE rest_operation SET description = 'Check-out, finalizao de uma solicitao de servio'
	WHERE name ILIKE 'notification_checkout';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_checkout', 
	'Check-out, finalizao de uma solicitao de servio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_checkout');
	

UPDATE rest_operation SET description = 'Lista de solicitaes novas - coordenadas'
	WHERE name ILIKE 'notification_getByCoordinates';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getByCoordinates', 
	'Lista de solicitaes novas - coordenadas',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getByCoordinates');
	

UPDATE rest_operation SET description = 'Atender solicitao'
	WHERE name ILIKE 'notification_attendRequest';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_attendRequest', 
	'Atender solicitao',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_attendRequest');
	

UPDATE rest_operation SET description = 'Desassociar device do atendente'
	WHERE name ILIKE 'service_deviceDisassociate';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'service_deviceDisassociate', 
	'Desassociar device do atendente',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'service_deviceDisassociate');
	

UPDATE rest_operation SET description = 'Restaura tarefas e permisses de uma solicitao de servio'
	WHERE name ILIKE 'notification_updateNotification';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_updateNotification', 
	'Restaura tarefas e permisses de uma solicitao de servio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_updateNotification');
	

UPDATE rest_operation SET description = 'Retorna detalhes de uma notificao para mobile'
	WHERE name ILIKE 'notification_getById_v2';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_getById_v2', 
	'Retorna detalhes de uma notificao para mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_getById_v2');
	

UPDATE rest_operation SET description = 'Cria novas solicitaes de servio'
	WHERE name ILIKE 'request_create';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_create', 
	'Cria novas solicitaes de servio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_create');
	

UPDATE rest_operation SET description = 'Altera solicitaes de servio'
	WHERE name ILIKE 'request_update';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_update', 
	'Altera solicitaes de servio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_update');
	

UPDATE rest_operation SET description = 'Atualiza status de uma solicitao'
	WHERE name ILIKE 'request_updateStatus';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_updateStatus', 
	'Atualiza status de uma solicitao',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_updateStatus');
	

UPDATE rest_operation SET description = 'Consulta requisies por usurio'
	WHERE name ILIKE 'request_getByUser';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_getByUser', 
	'Consulta requisies por usurio',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_getByUser');
	

UPDATE rest_operation SET description = 'Detalha requisio pelo nmero'
	WHERE name ILIKE 'request_getById';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_getById', 
	'Detalha requisio pelo nmero',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_getById');
	

UPDATE rest_operation SET description = 'Cria uma ocorrncia de solicitao'
	WHERE name ILIKE 'request_create_occurrence';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_create_occurrence', 
	'Cria uma ocorrncia de solicitao',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_create_occurrence');
	

UPDATE rest_operation SET description = 'Lista as ocorrncias de uma solicitao'
	WHERE name ILIKE 'request_list_occurrences';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_list_occurrences', 
	'Lista as ocorrncias de uma solicitao',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_list_occurrences');
	

UPDATE rest_operation SET description = 'Recupera requisies no sincronizadas'
	WHERE name ILIKE 'request_getNotSynchronized';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'request_getNotSynchronized', 
	'Recupera requisies no sincronizadas',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'request_getNotSynchronized');
	

UPDATE rest_operation SET description = 'Sincronizao de dados'
	WHERE name ILIKE 'synchronize';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'synchronize', 
	'Sincronizao de dados',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'synchronize');
	

UPDATE rest_operation SET description = 'Recupera ocorrncias no sincronizadas'
	WHERE name ILIKE 'occurrence_getNotSynchronized';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'occurrence_getNotSynchronized', 
	'Recupera ocorrncias no sincronizadas',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'occurrence_getNotSynchronized');
	

UPDATE rest_operation SET description = 'Sincroniza ocorrncias'
	WHERE name ILIKE 'occurrence_synchronize';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'occurrence_synchronize', 
	'Sincroniza ocorrncias',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'occurrence_synchronize');
	

UPDATE rest_operation SET description = 'Recupera lista de objetos de sincronizao'
	WHERE name ILIKE 'synchronize_find';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'synchronize_find', 
	'Recupera lista de objetos de sincronizao',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'synchronize_find');
	

UPDATE rest_operation SET description = 'Exclui sincronizao'
	WHERE name ILIKE 'synchronize_delete';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'synchronize_delete', 
	'Exclui sincronizao',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'synchronize_delete');
	

UPDATE rest_operation SET description = 'Executa consultas no banco de dados'
	WHERE name ILIKE 'data_query';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'data_query', 
	'Executa consultas no banco de dados',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'data_query');
	

UPDATE rest_operation SET description = 'Servio de busca de solicitaes para o citsmart mobile'
	WHERE name ILIKE 'notification_buscaNotificacao';
INSERT INTO rest_operation(
	idrestoperation, idbatchprocessing, name,
	description, operationtype, classtype,
	javaclass, javascript, status, generatelog)
SELECT 
	(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
	NULL, 'notification_buscaNotificacao', 
	'Servio de busca de solicitaes para o citsmart mobile',
	'Sync', 'Java',
	'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_operation WHERE name ILIKE 'notification_buscaNotificacao');
	

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CONTRACT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '7' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'7'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '10' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'10'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'ORIGIN_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));


UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '1' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'1'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'INCIDENT_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'addServiceRequest'));
		

UPDATE rest_domain SET value = '3' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'),
	'3'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DEPTO_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'notification_new'));
		

UPDATE rest_domain SET value = '1421' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'1421'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = '1421' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'1421'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SLA') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = '7' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_updateStatus');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_updateStatus'),
	'7'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_REASON_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_updateStatus'));
		

UPDATE rest_domain SET value = '5136' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'5136'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_SERVICE_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = 'N' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_USER') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = 'N' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_GROUP') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = 'N' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'),
	'N'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'CHANGE_SERVICE') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_update'));
		

UPDATE rest_domain SET value = '159' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'159'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_GROUP_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = 'Requisio criada por ESI centralizador' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'),
	'Requisio criada por ESI centralizador'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'DEFAULT_DESCRIPTION') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'request_create'));
		

UPDATE rest_domain SET value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'USER') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'USER'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'),
	'select idusuario, login, nome, idempregado, status from usuario where login = ${login}'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'USER') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'));
		

UPDATE rest_domain SET value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'),
	'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_ID') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'));
		

UPDATE rest_domain SET value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}' WHERE 
	idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION') AND
	idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query');
INSERT INTO rest_domain (
	idrestparameter, idrestoperation, value)
SELECT
	(SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION'),
	(SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'),
	'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}'
WHERE NOT EXISTS(
	SELECT 1 FROM rest_domain WHERE 
		idrestparameter = (SELECT idrestparameter FROM rest_parameter WHERE identifier ILIKE 'REQUEST_BY_DESCRIPTION') AND
		idrestoperation = (SELECT idrestoperation FROM rest_operation WHERE name ILIKE 'data_query'));

