UPDATE dbo.rest_parameter SET description = 'Contract ID'
	WHERE identifier LIKE 'CONTRACT_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (1, 'CONTRACT_ID', 'Contract ID');

UPDATE dbo.rest_parameter SET description = 'Origin ID'
	WHERE identifier LIKE 'ORIGIN_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (2, 'ORIGIN_ID', 'Origin ID');

UPDATE dbo.rest_parameter SET description = 'Type of demand ID for requests'
	WHERE identifier LIKE 'REQUEST_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (3, 'REQUEST_ID', 'Type of demand ID for requests');

UPDATE dbo.rest_parameter SET description = 'Type of demand ID for incidents'
	WHERE identifier LIKE 'INCIDENT_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (4, 'INCIDENT_ID', 'Type of demand ID for incidents');

UPDATE dbo.rest_parameter SET description = 'Default dept ID'
	WHERE identifier LIKE 'DEFAULT_DEPTO_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (5, 'DEFAULT_DEPTO_ID', 'Default dept ID');

UPDATE dbo.rest_parameter SET description = 'Default ID to service level agreement'
	WHERE identifier LIKE 'DEFAULT_SLA'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (6, 'DEFAULT_SLA', 'Default ID to service level agreement');

UPDATE dbo.rest_parameter SET description = 'Default ID justification to change the situation'
	WHERE identifier LIKE 'DEFAULT_REASON_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (56, 'DEFAULT_REASON_ID', 'Default ID justification to change the situation');

UPDATE dbo.rest_parameter SET description = 'Default Service ID'
	WHERE identifier LIKE 'DEFAULT_SERVICE_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (106, 'DEFAULT_SERVICE_ID', 'Default Service ID');

UPDATE dbo.rest_parameter SET description = 'Allows modification of the requestor'
	WHERE identifier LIKE 'CHANGE_USER'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (107, 'CHANGE_USER', 'Allows modification of the requestor');

UPDATE dbo.rest_parameter SET description = 'Allows redirection'
	WHERE identifier LIKE 'CHANGE_GROUP'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (108, 'CHANGE_GROUP', 'Allows redirection');

UPDATE dbo.rest_parameter SET description = 'Allows reclassification'
	WHERE identifier LIKE 'CHANGE_SERVICE'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (109, 'CHANGE_SERVICE', 'Allows reclassification');

UPDATE dbo.rest_parameter SET description = 'Group ID default executor'
	WHERE identifier LIKE 'DEFAULT_GROUP_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (156, 'DEFAULT_GROUP_ID', 'Group ID default executor');

UPDATE dbo.rest_parameter SET description = 'Standard complement description'
	WHERE identifier LIKE 'DEFAULT_DESCRIPTION'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (157, 'DEFAULT_DESCRIPTION', 'Standard complement description');

UPDATE dbo.rest_parameter SET description = 'SQL retrieve user login'
	WHERE identifier LIKE 'USER'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (356, 'USER', 'SQL retrieve user login');

UPDATE dbo.rest_parameter SET description = 'SQL recover request / incident by ID'
	WHERE identifier LIKE 'REQUEST_BY_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (357, 'REQUEST_BY_ID', 'SQL recover request / incident by ID');

UPDATE dbo.rest_parameter SET description = 'SQL recover request / incident by description'
	WHERE identifier LIKE 'REQUEST_BY_DESCRIPTION'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (358, 'REQUEST_BY_DESCRIPTION', 'SQL recover request / incident by description');


UPDATE dbo.rest_operation SET description = 'Create service request'
	WHERE name LIKE 'addServiceRequest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'addServiceRequest', 
			'Create service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest', NULL, 'A', 'Y');	

UPDATE dbo.rest_operation SET description = 'Listing Tasks'
	WHERE name LIKE 'listTasks'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'listTasks', 
			'Listing Tasks',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestListTasks', NULL, 'A', 'Y');

UPDATE dbo.rest_operation SET description = 'Return notification list for mobile'
	WHERE name LIKE 'notification_getByUser'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getByUser', 
			'Return notification list for mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Returns details of a notification to Mobile'
	WHERE name LIKE 'notification_getById'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getById', 
			'Returns details of a notification to Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Processes feedback from a notification to Mobile'
	WHERE name LIKE 'notification_feedback'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_feedback', 
			'Processes feedback from a notification to Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Create a notification to Mobile'
	WHERE name LIKE 'notification_new'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_new', 
			'Create a notification to Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Returns possible justifications for a notification'
	WHERE name LIKE 'notification_getReasons'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getReasons', 
			'Returns possible justifications for a notification',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Returns all data of the required tables to the BI Citsmart'
	WHERE name LIKE 'bicitsmart_recuperarTabelas'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'bicitsmart_recuperarTabelas', 
			'Returns all data of the required tables to the BI Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestBICitsmart', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Gets the unit coordinate check in Unit'
	WHERE name LIKE 'service_coordinates'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_coordinates', 
			'Gets the unit coordinate check in Unit',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Return list of active Citsmart contracts'
	WHERE name LIKE 'service_listContracts'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listContracts', 
			'Return list of active Citsmart contracts',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'List justifications'
	WHERE name LIKE 'service_listDeniedReasons'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listDeniedReasons', 
			'List justifications',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'List status of service request'
	WHERE name LIKE 'service_listSolicitationStatus'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listSolicitationStatus', 
			'List status of service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'List of contract unit'
	WHERE name LIKE 'service_listUnits'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listUnits', 
			'List of contract unit',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Location of an attendant'
	WHERE name LIKE 'notification_attendantLocation'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_attendantLocation', 
			'Location of an attendant',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'New request list'
	WHERE name LIKE 'notification_getNewest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getNewest', 
			'New request list',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Request list intended for new user'
	WHERE name LIKE 'notification_getOldest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getOldest', 
			'Request list intended for new user',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Check-in request'
	WHERE name LIKE 'notification_checkin'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_checkin', 
			'Check-in request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Denial Check - in a service request suggestion'
	WHERE name LIKE 'notification_checkinDenied'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_checkinDenied', 
			'Denial Check - in a service request suggestion',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Check-out, completion of a service request'
	WHERE name LIKE 'notification_checkout'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_checkout', 
			'Check-out, completion of a service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'New request list - Coordinates'
	WHERE name LIKE 'notification_getByCoordinates'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getByCoordinates', 
			'New request list - Coordinates',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Attending Request'
	WHERE name LIKE 'notification_attendRequest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_attendRequest', 
			'Attending Request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Disassociate device attendant'
	WHERE name LIKE 'service_deviceDisassociate'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_deviceDisassociate', 
			'Disassociate device attendant',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Restore tasks and permissions of a service request'
	WHERE name LIKE 'notification_updateNotification'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_updateNotification', 
			'Restore tasks and permissions of a service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Returns details of a notification for Mobile'
	WHERE name LIKE 'notification_getById_v2'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getById_v2', 
			'Returns details of a notification for Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Create new service requests'
	WHERE name LIKE 'request_create'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_create', 
			'Create new service requests',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Change service request'
	WHERE name LIKE 'request_update'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_update', 
			'Change service request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Updates status of a request'
	WHERE name LIKE 'request_updateStatus'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_updateStatus', 
			'Updates status of a request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Consultation requests per user'
	WHERE name LIKE 'request_getByUser'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_getByUser', 
			'Consultation requests per user',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Request details by the number'
	WHERE name LIKE 'request_getById'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_getById', 
			'Request details by the number',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Create a request for incidents'
	WHERE name LIKE 'request_create_occurrence'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_create_occurrence', 
			'Create a request for incidents',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'List instances of a request'
	WHERE name LIKE 'request_list_occurrences'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_list_occurrences', 
			'List instances of a request',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Recover unsynchronized requests'
	WHERE name LIKE 'request_getNotSynchronized'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_getNotSynchronized', 
			'Recover unsynchronized requests',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Data synchronization'
	WHERE name LIKE 'synchronize'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'synchronize', 
			'Data synchronization',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Recover unsynchronized events'
	WHERE name LIKE 'occurrence_getNotSynchronized'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'occurrence_getNotSynchronized', 
			'Recover unsynchronized events',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Synchronizes events'
	WHERE name LIKE 'occurrence_synchronize'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'occurrence_synchronize', 
			'Synchronizes events',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Retrieve synchronization objects list'
	WHERE name LIKE 'synchronize_find'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'synchronize_find', 
			'Retrieve synchronization objects list',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Delete synchronization'
	WHERE name LIKE 'synchronize_delete'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'synchronize_delete', 
			'Delete synchronization',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Execute queries on the database'
	WHERE name LIKE 'data_query'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'data_query', 
			'Execute queries on the database',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Search service of requests to the mobile Citsmart'
	WHERE name LIKE 'notification_buscaNotificacao'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_buscaNotificacao', 
			'Search service of requests to the mobile Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '7'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'7');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '10'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'10');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1421'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'1421');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1421'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'1421');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '7'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_REASON_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_updateStatus'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_REASON_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_updateStatus'),
			'7');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '5136'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SERVICE_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SERVICE_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'5136');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'N'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_USER')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_USER'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'N');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'N'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_GROUP')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_GROUP'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'N');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'N'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_SERVICE')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_SERVICE'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'N');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '159'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_GROUP_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_GROUP_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'159');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'Requisition created by ESI centralizer'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DESCRIPTION')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DESCRIPTION'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'Requisition created by ESI centralizer');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'USER')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'USER'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'),
			'select idusuario, login, nome, idempregado, status from usuario where login = ${login}');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'),
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_DESCRIPTION')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_DESCRIPTION'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'),
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}');
