UPDATE dbo.rest_parameter SET description = 'ID del contrato'
	WHERE identifier LIKE 'CONTRACT_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (1, 'CONTRACT_ID', 'ID del contrato');

UPDATE dbo.rest_parameter SET description = 'ID del origen'
	WHERE identifier LIKE 'ORIGIN_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (2, 'ORIGIN_ID', 'ID del origen');

UPDATE dbo.rest_parameter SET description = 'ID del tipo de demanda para solicitudes'
	WHERE identifier LIKE 'REQUEST_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (3, 'REQUEST_ID', 'ID del tipo de demanda para solicitudes');

UPDATE dbo.rest_parameter SET description = 'ID del tipo de demanda para incidentes'
	WHERE identifier LIKE 'INCIDENT_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (4, 'INCIDENT_ID', 'ID del tipo de demanda para incidentes');

UPDATE dbo.rest_parameter SET description = 'ID normalizado de la unidad'
	WHERE identifier LIKE 'DEFAULT_DEPTO_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (5, 'DEFAULT_DEPTO_ID', 'ID normalizado de la unidad');

UPDATE dbo.rest_parameter SET description = 'ID normalizado del acuerdo de nivel de servicio'
	WHERE identifier LIKE 'DEFAULT_SLA'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (6, 'DEFAULT_SLA', 'ID normalizado del acuerdo de nivel de servicio');

UPDATE dbo.rest_parameter SET description = 'ID justificacin normalizada para alteracin de situacin'
	WHERE identifier LIKE 'DEFAULT_REASON_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (56, 'DEFAULT_REASON_ID', 'ID justificacin normalizada para alteracin de situacin');

UPDATE dbo.rest_parameter SET description = 'ID del servicio normalizado'
	WHERE identifier LIKE 'DEFAULT_SERVICE_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (106, 'DEFAULT_SERVICE_ID', 'ID del servicio normalizado');

UPDATE dbo.rest_parameter SET description = 'Permite alteracin del solicitante'
	WHERE identifier LIKE 'CHANGE_USER'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (107, 'CHANGE_USER', 'Permite alteracin del solicitante');

UPDATE dbo.rest_parameter SET description = 'Permite redirecionamento'
	WHERE identifier LIKE 'CHANGE_GROUP'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (108, 'CHANGE_GROUP', 'Permite redirecionamento');

UPDATE dbo.rest_parameter SET description = 'Permite reclasificacin'
	WHERE identifier LIKE 'CHANGE_SERVICE'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (109, 'CHANGE_SERVICE', 'Permite reclasificacin');

UPDATE dbo.rest_parameter SET description = 'ID del grupo executor normalizado'
	WHERE identifier LIKE 'DEFAULT_GROUP_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (156, 'DEFAULT_GROUP_ID', 'ID del grupo executor normalizado');

UPDATE dbo.rest_parameter SET description = 'Complemento normalizado de la descripcin'
	WHERE identifier LIKE 'DEFAULT_DESCRIPTION'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (157, 'DEFAULT_DESCRIPTION', 'Complemento normalizado de la descripcin');

UPDATE dbo.rest_parameter SET description = 'SQL recupera usuario por el login'
	WHERE identifier LIKE 'USER'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (356, 'USER', 'SQL recupera usuario por el login');

UPDATE dbo.rest_parameter SET description = 'SQL recupera solicitud/incidente por el ID'
	WHERE identifier LIKE 'REQUEST_BY_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (357, 'REQUEST_BY_ID', 'SQL recupera solicitud/incidente por el ID');

UPDATE dbo.rest_parameter SET description = 'SQL recupera solicitud/incidente por la descripcin'
	WHERE identifier LIKE 'REQUEST_BY_DESCRIPTION'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (358, 'REQUEST_BY_DESCRIPTION', 'SQL recupera solicitud/incidente por la descripcin');


UPDATE dbo.rest_operation SET description = 'Creacin de solicitud de servicio'
	WHERE name LIKE 'addServiceRequest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'addServiceRequest', 
			'Creacin de solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest', NULL, 'A', 'Y');	

UPDATE dbo.rest_operation SET description = 'Listado de tareas'
	WHERE name LIKE 'listTasks'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'listTasks', 
			'Listado de tareas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestListTasks', NULL, 'A', 'Y');

UPDATE dbo.rest_operation SET description = 'Retorna lista de notificaciones para Mobile'
	WHERE name LIKE 'notification_getByUser'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getByUser', 
			'Retorna lista de notificaciones para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retorna detalles de una notificacin para Mobile'
	WHERE name LIKE 'notification_getById'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getById', 
			'Retorna detalles de una notificacin para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Procesa feedback de una notificacin para Mobile'
	WHERE name LIKE 'notification_feedback'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_feedback', 
			'Procesa feedback de una notificacin para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Crea una notificacin para Mobile'
	WHERE name LIKE 'notification_new'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_new', 
			'Crea una notificacin para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retorna justificaciones posibles para una notificacin'
	WHERE name LIKE 'notification_getReasons'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getReasons', 
			'Retorna justificaciones posibles para una notificacin',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retorna todos los datos de las tablas necesarias para el BI del Citsmart'
	WHERE name LIKE 'bicitsmart_recuperarTabelas'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'bicitsmart_recuperarTabelas', 
			'Retorna todos los datos de las tablas necesarias para el BI del Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestBICitsmart', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Recibe la coordenada de la unidad check-in unidad'
	WHERE name LIKE 'service_coordinates'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_coordinates', 
			'Recibe la coordenada de la unidad check-in unidad',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retornar lista de Contratos activos del Citsmart'
	WHERE name LIKE 'service_listContracts'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listContracts', 
			'Retornar lista de Contratos activos del Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de Justificacin'
	WHERE name LIKE 'service_listDeniedReasons'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listDeniedReasons', 
			'Lista de Justificacin',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista estatus de la solicitud de servicio'
	WHERE name LIKE 'service_listSolicitationStatus'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listSolicitationStatus', 
			'Lista estatus de la solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de unidad de un contrato'
	WHERE name LIKE 'service_listUnits'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listUnits', 
			'Lista de unidad de un contrato',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Localizacin de un atendente'
	WHERE name LIKE 'notification_attendantLocation'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_attendantLocation', 
			'Localizacin de un atendente',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de solicitudes nuevas'
	WHERE name LIKE 'notification_getNewest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getNewest', 
			'Lista de solicitudes nuevas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de nuevas solicitudes destinadas al usuario'
	WHERE name LIKE 'notification_getOldest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getOldest', 
			'Lista de nuevas solicitudes destinadas al usuario',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Check-in de la solicitud'
	WHERE name LIKE 'notification_checkin'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_checkin', 
			'Check-in de la solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Negacin de check-in de una sugerencia de solicitud de servicio'
	WHERE name LIKE 'notification_checkinDenied'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_checkinDenied', 
			'Negacin de check-in de una sugerencia de solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Check-out, finalizacin de una solicitud de servicio'
	WHERE name LIKE 'notification_checkout'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_checkout', 
			'Check-out, finalizacin de una solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de solicitudes nuevas - coordenadas'
	WHERE name LIKE 'notification_getByCoordinates'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getByCoordinates', 
			'Lista de solicitudes nuevas - coordenadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Atender solicitud'
	WHERE name LIKE 'notification_attendRequest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_attendRequest', 
			'Atender solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Desasociar device del atendente'
	WHERE name LIKE 'service_deviceDisassociate'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_deviceDisassociate', 
			'Desasociar device del atendente',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Restaura tareas y permisos de una solicitud de servicio'
	WHERE name LIKE 'notification_updateNotification'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_updateNotification', 
			'Restaura tareas y permisos de una solicitud de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retorna detalles de una notificacin para mobile'
	WHERE name LIKE 'notification_getById_v2'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getById_v2', 
			'Retorna detalles de una notificacin para mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Crea nuevas solicitudes de servicio'
	WHERE name LIKE 'request_create'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_create', 
			'Crea nuevas solicitudes de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Altera solicitudes de servicio'
	WHERE name LIKE 'request_update'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_update', 
			'Altera solicitudes de servicio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Actualiza estatus de una solicitud'
	WHERE name LIKE 'request_updateStatus'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_updateStatus', 
			'Actualiza estatus de una solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Consulta solicitudes por usuario'
	WHERE name LIKE 'request_getByUser'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_getByUser', 
			'Consulta solicitudes por usuario',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Detalla solicitud por el nmero'
	WHERE name LIKE 'request_getById'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_getById', 
			'Detalla solicitud por el nmero',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Crea una ocurrencia de solicitud'
	WHERE name LIKE 'request_create_occurrence'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_create_occurrence', 
			'Crea una ocurrencia de solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Lista las ocurrencias de una solicitud'
	WHERE name LIKE 'request_list_occurrences'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_list_occurrences', 
			'Lista las ocurrencias de una solicitud',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Recupera solicitudes no sincronizadas'
	WHERE name LIKE 'request_getNotSynchronized'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_getNotSynchronized', 
			'Recupera solicitudes no sincronizadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Sincronizacin de datos'
	WHERE name LIKE 'synchronize'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'synchronize', 
			'Sincronizacin de datos',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Recupera ocurrencias no sincronizadas'
	WHERE name LIKE 'occurrence_getNotSynchronized'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'occurrence_getNotSynchronized', 
			'Recupera ocurrencias no sincronizadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Sincroniza ocurrencias'
	WHERE name LIKE 'occurrence_synchronize'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'occurrence_synchronize', 
			'Sincroniza ocurrencias',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Recupera lista de objetos de sincronizacin'
	WHERE name LIKE 'synchronize_find'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'synchronize_find', 
			'Recupera lista de objetos de sincronizacin',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Excluye sincronizacin'
	WHERE name LIKE 'synchronize_delete'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'synchronize_delete', 
			'Excluye sincronizacin',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Ejecuta consultas en la base de datos'
	WHERE name LIKE 'data_query'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'data_query', 
			'Ejecuta consultas en la base de datos',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Servicio de bsqueda de solicitudes para el citsmart mobile'
	WHERE name LIKE 'notification_buscaNotificacao'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_buscaNotificacao', 
			'Servicio de bsqueda de solicitudes para el citsmart mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '7'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'7');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '10'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'10');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1421'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'1421');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1421'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'1421');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '7'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_REASON_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_updateStatus'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_REASON_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_updateStatus'),
			'7');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '5136'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SERVICE_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SERVICE_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'5136');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'N'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_USER')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_USER'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'N');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'N'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_GROUP')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_GROUP'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'N');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'N'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_SERVICE')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_SERVICE'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'N');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '159'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_GROUP_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_GROUP_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'159');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'Solicitud creada por ESI centralizador'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DESCRIPTION')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DESCRIPTION'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'Solicitud creada por ESI centralizador');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'USER')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'USER'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'),
			'select idusuario, login, nome, idempregado, status from usuario where login = ${login}');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'),
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_DESCRIPTION')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_DESCRIPTION'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'),
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}');
