UPDATE dbo.rest_parameter SET description = 'ID do contrato'
	WHERE identifier LIKE 'CONTRACT_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (1, 'CONTRACT_ID', 'ID do contrato');

UPDATE dbo.rest_parameter SET description = 'ID da origem'
	WHERE identifier LIKE 'ORIGIN_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (2, 'ORIGIN_ID', 'ID da origem');

UPDATE dbo.rest_parameter SET description = 'ID do tipo de demanda para requisies'
	WHERE identifier LIKE 'REQUEST_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (3, 'REQUEST_ID', 'ID do tipo de demanda para requisies');

UPDATE dbo.rest_parameter SET description = 'ID do tipo de demanda para incidentes'
	WHERE identifier LIKE 'INCIDENT_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (4, 'INCIDENT_ID', 'ID do tipo de demanda para incidentes');

UPDATE dbo.rest_parameter SET description = 'ID padro da unidade'
	WHERE identifier LIKE 'DEFAULT_DEPTO_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (5, 'DEFAULT_DEPTO_ID', 'ID padro da unidade');

UPDATE dbo.rest_parameter SET description = 'ID padro do acordo de nvel de servio'
	WHERE identifier LIKE 'DEFAULT_SLA'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (6, 'DEFAULT_SLA', 'ID padro do acordo de nvel de servio');

UPDATE dbo.rest_parameter SET description = 'ID justificativa padro para alterao de situao'
	WHERE identifier LIKE 'DEFAULT_REASON_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (56, 'DEFAULT_REASON_ID', 'ID justificativa padro para alterao de situao');

UPDATE dbo.rest_parameter SET description = 'ID do servio padro'
	WHERE identifier LIKE 'DEFAULT_SERVICE_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (106, 'DEFAULT_SERVICE_ID', 'ID do servio padro');

UPDATE dbo.rest_parameter SET description = 'Permite alterao do solicitante'
	WHERE identifier LIKE 'CHANGE_USER'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (107, 'CHANGE_USER', 'Permite alterao do solicitante');

UPDATE dbo.rest_parameter SET description = 'Permite redirecionamento'
	WHERE identifier LIKE 'CHANGE_GROUP'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (108, 'CHANGE_GROUP', 'Permite redirecionamento');

UPDATE dbo.rest_parameter SET description = 'Permite reclassificao'
	WHERE identifier LIKE 'CHANGE_SERVICE'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (109, 'CHANGE_SERVICE', 'Permite reclassificao');

UPDATE dbo.rest_parameter SET description = 'ID do grupo executor padro'
	WHERE identifier LIKE 'DEFAULT_GROUP_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (156, 'DEFAULT_GROUP_ID', 'ID do grupo executor padro');

UPDATE dbo.rest_parameter SET description = 'Complemento padro da descrio'
	WHERE identifier LIKE 'DEFAULT_DESCRIPTION'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (157, 'DEFAULT_DESCRIPTION', 'Complemento padro da descrio');

UPDATE dbo.rest_parameter SET description = 'SQL recupera usurio pelo login'
	WHERE identifier LIKE 'USER'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (356, 'USER', 'SQL recupera usurio pelo login');

UPDATE dbo.rest_parameter SET description = 'SQL recupera solicitao/incidente pelo ID'
	WHERE identifier LIKE 'REQUEST_BY_ID'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (357, 'REQUEST_BY_ID', 'SQL recupera solicitao/incidente pelo ID');

UPDATE dbo.rest_parameter SET description = 'SQL recupera solicitao/incidente pela descrio'
	WHERE identifier LIKE 'REQUEST_BY_DESCRIPTION'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_parameter (idrestparameter, identifier, description)
	VALUES (358, 'REQUEST_BY_DESCRIPTION', 'SQL recupera solicitao/incidente pela descrio');



	UPDATE dbo.rest_operation SET description = 'Criao de solicitao de servio'
	WHERE name LIKE 'addServiceRequest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'addServiceRequest', 
			'Criao de solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestAddServiceRequest', NULL, 'A', 'Y');	

UPDATE dbo.rest_operation SET description = 'Listagem de tarefas'
	WHERE name LIKE 'listTasks'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'listTasks', 
			'Listagem de tarefas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestListTasks', NULL, 'A', 'Y');

UPDATE dbo.rest_operation SET description = 'Retorna lista de notificaes para Mobile'
	WHERE name LIKE 'notification_getByUser'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getByUser', 
			'Retorna lista de notificaes para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retorna detalhes de uma notificao para Mobile'
	WHERE name LIKE 'notification_getById'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getById', 
			'Retorna detalhes de uma notificao para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Processa feedback de uma notificao para Mobile'
	WHERE name LIKE 'notification_feedback'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_feedback', 
			'Processa feedback de uma notificao para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Cria uma notificao para Mobile'
	WHERE name LIKE 'notification_new'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_new', 
			'Cria uma notificao para Mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retorna justificativas possveis para uma notificao'
	WHERE name LIKE 'notification_getReasons'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getReasons', 
			'Retorna justificativas possveis para uma notificao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retorna todos os dados das tabelas necessrias para o BI do Citsmart'
	WHERE name LIKE 'bicitsmart_recuperarTabelas'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'bicitsmart_recuperarTabelas', 
			'Retorna todos os dados das tabelas necessrias para o BI do Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.operation.RestBICitsmart', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Recebe a coordenada da unidade check-in unidade'
	WHERE name LIKE 'service_coordinates'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_coordinates', 
			'Recebe a coordenada da unidade check-in unidade',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retornar lista de Contratos ativos do Citsmart'
	WHERE name LIKE 'service_listContracts'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listContracts', 
			'Retornar lista de  Contratos ativos do Citsmart',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de Justificativa'
	WHERE name LIKE 'service_listDeniedReasons'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listDeniedReasons', 
			'Lista de Justificativa',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista status da solicitaes de servio'
	WHERE name LIKE 'service_listSolicitationStatus'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listSolicitationStatus', 
			'Lista status da solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de unidade de um contrato'
	WHERE name LIKE 'service_listUnits'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_listUnits', 
			'Lista de unidade de um contrato',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Localizao de um atendente'
	WHERE name LIKE 'notification_attendantLocation'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_attendantLocation', 
			'Localizao de um atendente',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de solicitaes novas'
	WHERE name LIKE 'notification_getNewest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getNewest', 
			'Lista de solicitaes novas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de novas solicitaes destinadas ao usurio'
	WHERE name LIKE 'notification_getOldest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getOldest', 
			'Lista de novas solicitaes destinadas ao usurio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Check-in da solicitao'
	WHERE name LIKE 'notification_checkin'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_checkin', 
			'Check-in da solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Negao de check-in de uma sugesto de solicitao de servio'
	WHERE name LIKE 'notification_checkinDenied'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_checkinDenied', 
			'Negao de check-in de uma sugesto de solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Check-out, finalizao de uma solicitao de servio'
	WHERE name LIKE 'notification_checkout'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_checkout', 
			'Check-out, finalizao de uma solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Lista de solicitaes novas - coordenadas'
	WHERE name LIKE 'notification_getByCoordinates'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getByCoordinates', 
			'Lista de solicitaes novas - coordenadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Atender solicitao'
	WHERE name LIKE 'notification_attendRequest'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_attendRequest', 
			'Atender solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Desassociar device do atendente'
	WHERE name LIKE 'service_deviceDisassociate'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'service_deviceDisassociate', 
			'Desassociar device do atendente',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Restaura tarefas e permisses de uma solicitao de servio'
	WHERE name LIKE 'notification_updateNotification'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_updateNotification', 
			'Restaura tarefas e permisses de uma solicitao de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Retorna detalhes de uma notificao para mobile'
	WHERE name LIKE 'notification_getById_v2'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_getById_v2', 
			'Retorna detalhes de uma notificao para mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Cria novas solicitaes de servio'
	WHERE name LIKE 'request_create'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_create', 
			'Cria novas solicitaes de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Altera solicitaes de servio'
	WHERE name LIKE 'request_update'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_update', 
			'Altera solicitaes de servio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Atualiza status de uma solicitao'
	WHERE name LIKE 'request_updateStatus'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_updateStatus', 
			'Atualiza status de uma solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Consulta requisies por usurio'
	WHERE name LIKE 'request_getByUser'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_getByUser', 
			'Consulta requisies por usurio',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Detalha requisio pelo nmero'
	WHERE name LIKE 'request_getById'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_getById', 
			'Detalha requisio pelo nmero',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Cria uma ocorrncia de solicitao'
	WHERE name LIKE 'request_create_occurrence'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_create_occurrence', 
			'Cria uma ocorrncia de solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Lista as ocorrncias de uma solicitao'
	WHERE name LIKE 'request_list_occurrences'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_list_occurrences', 
			'Lista as ocorrncias de uma solicitao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTOperation', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Recupera requisies no sincronizadas'
	WHERE name LIKE 'request_getNotSynchronized'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'request_getNotSynchronized', 
			'Recupera requisies no sincronizadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Sincronizao de dados'
	WHERE name LIKE 'synchronize'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'synchronize', 
			'Sincronizao de dados',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Recupera ocorrncias no sincronizadas'
	WHERE name LIKE 'occurrence_getNotSynchronized'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'occurrence_getNotSynchronized', 
			'Recupera ocorrncias no sincronizadas',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Sincroniza ocorrncias'
	WHERE name LIKE 'occurrence_synchronize'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'occurrence_synchronize', 
			'Sincroniza ocorrncias',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Recupera lista de objetos de sincronizao'
	WHERE name LIKE 'synchronize_find'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'synchronize_find', 
			'Recupera lista de objetos de sincronizao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Exclui sincronizao'
	WHERE name LIKE 'synchronize_delete'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'synchronize_delete', 
			'Exclui sincronizao',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTSynchronize', NULL, 'A', 'N');
			
UPDATE dbo.rest_operation SET description = 'Executa consultas no banco de dados'
	WHERE name LIKE 'data_query'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'data_query', 
			'Executa consultas no banco de dados',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v3.operation.RESTDataQuery', NULL, 'A', 'Y');
			
UPDATE dbo.rest_operation SET description = 'Servio de busca de solicitaes para o citsmart mobile'
	WHERE name LIKE 'notification_buscaNotificacao'
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_operation (
			idrestoperation,
			idbatchprocessing, name, 
			description, operationtype, classtype, 
			javaclass, javascript, status, generatelog)
	VALUES (
			(SELECT (CASE count(idrestoperation) WHEN 0 THEN 1 ELSE max(idrestoperation)+1 END ) FROM rest_operation),
			NULL, 'notification_buscaNotificacao', 
			'Servio de busca de solicitaes para o citsmart mobile',
			'Sync', 'Java',
			'br.com.centralit.citsmart.rest.v2.operation.RESTMobile', NULL, 'A', 'Y');
			

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CONTRACT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '7'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'7');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '10'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'ORIGIN_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'10');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'1');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'INCIDENT_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'addServiceRequest'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '3'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DEPTO_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'notification_new'),
			'3');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1421'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'1421');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '1421'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SLA'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'1421');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '7'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_REASON_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_updateStatus'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_REASON_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_updateStatus'),
			'7');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '5136'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SERVICE_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_SERVICE_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'5136');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'N'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_USER')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_USER'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'N');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'N'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_GROUP')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_GROUP'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'N');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'N'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_SERVICE')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'CHANGE_SERVICE'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_update'),
			'N');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = '159'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_GROUP_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_GROUP_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'159');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'Requisio criada por ESI centralizador'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DESCRIPTION')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'DEFAULT_DESCRIPTION'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'request_create'),
			'Requisio criada por ESI centralizador');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'select idusuario, login, nome, idempregado, status from usuario where login = ${login}'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'USER')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'USER'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'),
			'select idusuario, login, nome, idempregado, status from usuario where login = ${login}');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_ID')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_ID'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'),
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento,sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero as numeroContrato, e1.nome as solicitante, u1.nome as unidade, e2.nome as responsavel, g1.sigla as grupoAtual, g2.sigla as grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.idsolicitacaoservico = ${id}');

UPDATE dbo.rest_domain SET dbo.rest_domain.value = 'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar,sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}'
	WHERE (dbo.rest_domain.idrestparameter = (
			SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter 
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_DESCRIPTION')
			) AND
		(dbo.rest_domain.idrestoperation = (
			SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'
			)
		)
IF @@ROWCOUNT = 0
	INSERT INTO dbo.rest_domain (
			dbo.rest_domain.idrestparameter, dbo.rest_domain.idrestoperation, dbo.rest_domain.value)
	VALUES (
			(SELECT dbo.rest_parameter.idrestparameter FROM dbo.rest_parameter
				WHERE dbo.rest_parameter.identifier LIKE 'REQUEST_BY_DESCRIPTION'),
			(SELECT dbo.rest_operation.idrestoperation FROM dbo.rest_operation 
				WHERE dbo.rest_operation.name LIKE 'data_query'),
			'SELECT sol.idSolicitacaoServico, sol.idbaseconhecimento, sol.idServicoContrato, sol.idSolicitante, sol.idItemConfiguracao, sol.idItemConfiguracaoFilho, sol.idtipodemandaservico, sol.idcontatosolicitacaoservico, sol.idOrigem, sol.idResponsavel, sol.idTipoProblema, sol.idPrioridade, sol.idUnidade, sol.idFaseAtual, sol.idGrupoAtual, sol.dataHoraSolicitacao, sol.dataHoraLimite, sol.atendimentoPresencial, sol.prazoCapturaHH, sol.prazoCapturaMM, sol.prazoHH, sol.prazoMM, sol.descricao, sol.resposta, sol.dataHoraInicio, sol.dataHoraFim, sol.situacao, sol.idSolicitacaoPai, sol.detalhamentoCausa, sol.idCausaIncidente, sol.idCategoriaSolucao, sol.seqreabertura, sol.enviaEmailCriacao, sol.enviaEmailFinalizacao, sol.enviaEmailAcoes, sol.idgruponivel1, sol.solucaoTemporaria, sol.houveMudanca, sol.slaACombinar, sol.prazohhAnterior, sol.prazommAnterior, sol.idCalendario, sol.tempoDecorridoHH, sol.tempoDecorridoMM, sol.dataHoraSuspensao, sol.dataHoraReativacao, sol.impacto, sol.urgencia, sol.dataHoraCaptura, sol.tempoCapturaHH, sol.tempoCapturaMM, sol.tempoAtrasoHH, sol.tempoAtrasoMM, sol.tempoAtendimentoHH, sol.tempoAtendimentoMM, sol.idacordonivelservico, sol.idultimaaprovacao, sol.datahorainiciosla, sol.datahorasuspensaosla, sol.datahorareativacaosla, sol.situacaosla, sol.idtarefaencerramento, sol.justificativavencimentosla, aprov.aprovacao, s.idservico, s.nomeServico, td.idTipoDemandaServico, td.nomeTipoDemandaServico, c.idContrato, c.numero numeroContrato, e1.nome solicitante, u1.nome unidade, e2.nome responsavel, g1.sigla grupoAtual, g2.sigla grupoNivel1, cs.nomecontato, cs.emailcontato, cs.telefonecontato, cs.localizacaofisica, cs.idlocalidade, sol.idSolicitacaoRelacionada, e3.email as emailResponsavel, sol.codigoExterno FROM solicitacaoservico sol INNER JOIN tipodemandaservico td ON td.idtipodemandaservico = sol.idtipodemandaservico LEFT JOIN servicocontrato sc ON sc.idservicocontrato = sol.idservicocontrato LEFT JOIN contratos c ON c.idcontrato = sc.idcontrato LEFT JOIN servico s ON s.idservico = sc.idservico LEFT JOIN empregados e1 ON e1.idempregado = sol.idsolicitante LEFT JOIN unidade u1 ON u1.idunidade = e1.idunidade LEFT JOIN usuario usu ON usu.idusuario = sol.idresponsavel LEFT JOIN empregados e2 ON e2.idempregado = usu.idempregado LEFT JOIN unidade u2 ON u2.idunidade = e2.idunidade LEFT JOIN origematendimento oa ON oa.idorigem = sol.idorigem LEFT JOIN prioridade p ON p.idprioridade = sol.idprioridade LEFT JOIN faseservico fs ON fs.idfase = sol.idfaseatual LEFT JOIN grupo g1 ON g1.idgrupo = sol.idgrupoatual LEFT JOIN grupo g2 ON g2.idgrupo = sol.idgruponivel1 LEFT JOIN empregados e3 ON e3.idempregado = sol.idresponsavel LEFT JOIN contatosolicitacaoservico cs ON cs.idcontatosolicitacaoservico = sol.idcontatosolicitacaoservico LEFT JOIN aprovacaosolicitacaoservico aprov ON aprov.idaprovacaosolicitacaoservico = sol.idultimaaprovacao WHERE sol.descricao like ${description}');
