/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.agents;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import br.com.centralit.bean.HostContent;
import br.com.centralit.bean.HostItem;
import br.com.centralit.bean.InventoryConfig;
import br.com.centralit.util.xml.XPathReader;

public class DotNetAgent implements IAgent {

	private static final Logger LOGGER = Logger.getLogger(DotNetAgent.class);

	private static final String KEY_CONTENT = "/REQUEST/CONTENT";

	@Override
	public HostContent doInventory(final InventoryConfig config, final String hostToInventoryNameIP) {
		LOGGER.debug(String.format("Citsmart Inventory > DotNetAgent realizando inventario para host de IP/nome %s. Inicio.", hostToInventoryNameIP));

		HostContent host = new HostContent();

		boolean hasLocalAgent = false;

		// Primeiro: pelo Agente Local da máquina (Atualmente é o CitAgente)
		try {
			Socket socket = new Socket(hostToInventoryNameIP, config.getPortaAgenteDotNet());
			host = this.doInventory(socket, "localhost");
			hasLocalAgent = true;

			socket.close();
			socket = null;
		} catch (final ConnectException e) {
			LOGGER.debug(String.format("Citsmart Inventory > Erro na conexão. Nao foi possivel inventariar por agente local no host de IP/nome %s. Mensagem: %s.", hostToInventoryNameIP,
					(e.getMessage() != null ? e.getMessage() : "Nao informada")));
		} catch (final IOException e) {
			LOGGER.debug(String.format("Citsmart Inventory > Nao foi possivel inventariar por agente local no host de IP/nome %s. Mensagem: %s.", hostToInventoryNameIP,
					(e.getMessage() != null ? e.getMessage() : "Nao informada")));
		}

		// Segundo: pelo Server Agente (Um computador que está trabalhando como
		// servidor para o CitAgente)
		if (!hasLocalAgent) {
			try {
				Socket socket = new Socket(config.getIpServidorInv(), config.getPortaAgenteDotNet());
				host = this.doInventory(socket, hostToInventoryNameIP);

				socket.close();
				socket = null;
			} catch (final ConnectException e) {
				LOGGER.debug(String.format("Citsmart Inventory > Não foi possivel inventariar por agente servidor para host de IP/nome %s. Mensagem: Erro na conexao. %s.", hostToInventoryNameIP,
						(e.getMessage() != null ? e.getMessage() : "Nao informada")));
			} catch (final IOException e) {
				LOGGER.debug(e.getMessage());
			}
		}

		LOGGER.debug(String.format("Citsmart Inventory > DotNetAgent realizando inventario para host de IP/nome %s. Fim.", hostToInventoryNameIP));

		return host;
	}

	private HostContent doInventory(final Socket socket, final String hostToInventoryNameIP) {
		HostContent host = new HostContent();
		final StringBuilder retorno = new StringBuilder();

		try {
			final OutputStreamWriter os = new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8);
			final InputStreamReader is = new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8);
			final BufferedWriter bw = new BufferedWriter(os);
			final PrintWriter pw = new PrintWriter(bw, true);
			final BufferedReader br = new BufferedReader(is);

			pw.println("GETINVENT:" + hostToInventoryNameIP + "\n");
			final String answer = br.readLine();
			if (answer != null) {
				if (answer.trim().equalsIgnoreCase("NOK")) {
					pw.println("INVENTORY:" + hostToInventoryNameIP + "\n");
				} else {
					retorno.append(answer);
				}
			}

			retorno.append(this.getResultContentFromReader(br));

			host = this.getHostContentFromXML(retorno.toString());

			try {
				br.close();
				pw.close();
				bw.close();
				is.close();
				os.close();
			} catch (Exception e) {
			}
		} catch (final IOException e) {
			LOGGER.debug(e.getMessage(), e);
		}

		return host;
	}

	private String getResultContentFromReader(final BufferedReader reader) throws IOException {
		String line = null;
		final StringBuilder result = new StringBuilder();
		while (true) {
			line = reader.readLine().trim();
			if (line == null) {
				break;
			}
			if (line.trim().equalsIgnoreCase("NOK")) {
				break;
			}
			result.append(line);
			if (line.trim().equalsIgnoreCase("</CONTENT>")) {
				result.append("</REQUEST>");
				break;
			}
		}
		return result.toString();
	}

	private HostContent getHostContentFromXML(final String xmlAgenteDotNet) {
		
		
		HostContent host = new HostContent();
		
		if (xmlAgenteDotNet!=null && !xmlAgenteDotNet.trim().isEmpty()) {
			try {
				final XPathReader reader = new XPathReader(xmlAgenteDotNet);
				final Node nodeContent = reader.getNode(KEY_CONTENT);
				final NodeList nodeItems = nodeContent.getChildNodes();
				for (int items = 0; items < nodeItems.getLength(); items++) {
					final Node nodeItem = nodeItems.item(items);
					final HostItem item = new HostItem();
					item.setName(nodeItem.getNodeName());
					final Map<String, String> detail = new HashMap<>();
					final NodeList properties = nodeItem.getChildNodes();
					for (int property = 0; property < properties.getLength(); property++) {
						final Node propertyItem = properties.item(property);
						detail.put(propertyItem.getNodeName(), propertyItem.getTextContent().trim());
					}
					item.setProperties(detail);
					host.getHostContent().add(item);
				}
			} catch (ParserConfigurationException | SAXException | IOException e) {
				LOGGER.debug(String.format("Citsmart Inventory > Erro ao processar host do xml. Mensagem: %s.", (e.getMessage() != null ? e.getMessage() : "Nao informada")));
				host = new HostContent();
			}
			
		}


		return host;
	}

}
