/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.batch;


/**
 * Classe utilitária utilizada para armazenar os IC´s descobertos ou que devem
 * ser analisados pelo sistema.
 *
 * @author euler.ramos
 *
 */
public class NetMap {

    public static String INDEFINIDO = "X";
    public static String ATIVO = "A";
    public static String INATIVO = "I";

	// Pode ser passado tanto o Nome/Identificação do Hardware ou o seu endereço IP.
    private String nomeHostIP;
    private boolean novo;
    private String statusPing = NetMap.INDEFINIDO;

    public NetMap() {
        this.setNovo(true);
    }

    public NetMap(final String nomeHostIP) {
        super();
        this.nomeHostIP = nomeHostIP;
    }

    public String getNomeHostIP() {
        return nomeHostIP;
    }

    public void setNomeHostIP(final String nomeHostIP) {
        this.nomeHostIP = nomeHostIP;
    }

    public boolean isNovo() {
        return novo;
    }

    public void setNovo(final boolean novo) {
        this.novo = novo;
    }

    public String getStatusPing() {
        return statusPing;
    }

    public void setStatusPing(final boolean statusPing) {
        if (statusPing) {
            this.statusPing = NetMap.ATIVO;
        } else {
            this.statusPing = NetMap.INATIVO;
        }
    }

	@Override
    public boolean equals(final Object obj) {
        NetMap netMap = new NetMap();
        if (obj != null) {
            netMap = (NetMap) obj;
        }
        return nomeHostIP.equals(netMap.getNomeHostIP());
    }

}
