/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.bean;

import java.io.Serializable;

public class InventoryConfig implements Serializable {

	private static final long serialVersionUID = -7608116037051480567L;

	private String faixa;
	private boolean completo;
	private int portaAgenteDotNet;
	private int portaSNMP;
	private String diretorioArquivos;
	private String ipServidorInv;
	private String destino;
	private boolean gravarArquivo = true;
	private boolean transmitirViaWS = true;
	private String expressaoCron;
	private boolean conexaoFalhou;
	private boolean destinoParaEVM;
	private String conexaoEventMonitorSenha;
	private String conexaoEventMonitorUrl;
	private String conexaoEventMonitorUsuario;
	private String conexaoEventMonitorIdentificador;
	private String ignorarIcsInventariados;
	private Integer tempoIgnorarIcs;
	private Integer tipoIgnorarIcs;
	private Integer idConexao;

	public String getConexaoEventMonitorIdentificador() {
		return conexaoEventMonitorIdentificador;
	}

	public void setConexaoEventMonitorIdentificador(String conexaoEventMonitorIdentificador) {
		this.conexaoEventMonitorIdentificador = conexaoEventMonitorIdentificador;
	}

	public String getConexaoEventMonitorSenha() {
		return conexaoEventMonitorSenha;
	}

	public void setConexaoEventMonitorSenha(String conexaoEventMonitorSenha) {
		this.conexaoEventMonitorSenha = conexaoEventMonitorSenha;
	}

	public String getConexaoEventMonitorUrl() {
		return conexaoEventMonitorUrl;
	}

	public void setConexaoEventMonitorUrl(String conexaoEventMonitorUrl) {
		this.conexaoEventMonitorUrl = conexaoEventMonitorUrl;
	}

	public String getConexaoEventMonitorUsuario() {
		return conexaoEventMonitorUsuario;
	}

	public void setConexaoEventMonitorUsuario(String conexaoEventMonitorUsuario) {
		this.conexaoEventMonitorUsuario = conexaoEventMonitorUsuario;
	}

	public static Builder builder() {
		return new Builder();
	}

	public String getFaixa() {
		return faixa;
	}

	private void setFaixa(final String faixa) {
		this.faixa = faixa;
	}

	public boolean isCompleto() {
		return completo;
	}

	private void setCompleto(final boolean completo) {
		this.completo = completo;
	}

	public int getPortaAgenteDotNet() {
		return portaAgenteDotNet;
	}

	private void setPortaAgenteDotNet(final int portaAgenteDotNet) {
		this.portaAgenteDotNet = portaAgenteDotNet;
	}

	public int getPortaSNMP() {
		return portaSNMP;
	}

	private void setPortaSNMP(final int portaSNMP) {
		this.portaSNMP = portaSNMP;
	}

	public String getDiretorioArquivos() {
		return diretorioArquivos;
	}

	private void setDiretorioArquivos(final String diretorioArquivos) {
		this.diretorioArquivos = diretorioArquivos;
	}

	public String getIpServidorInv() {
		return ipServidorInv;
	}

	public void setIpServidorInv(String ipServidorInv) {
		this.ipServidorInv = ipServidorInv;
	}

	public String getDestino() {
		return destino;
	}

	private void setDestino(final String destino) {
		this.destino = destino;
	}

	public boolean isGravarArquivo() {
		return gravarArquivo;
	}

	private void setGravarArquivo(final boolean gravarArquivo) {
		this.gravarArquivo = gravarArquivo;
	}

	public boolean isTransmitirViaWS() {
		return transmitirViaWS;
	}

	private void setTransmitirViaWS(final boolean transmitirViaWS) {
		this.transmitirViaWS = transmitirViaWS;
	}

	public String getExpressaoCron() {
		return expressaoCron;
	}

	public void setExpressaoCron(String expressaoCron) {
		this.expressaoCron = expressaoCron;
	}

	public boolean isConexaoFalhou() {
		return conexaoFalhou;
	}

	public void setConexaoFalhou(boolean conexaoFalhou) {
		this.conexaoFalhou = conexaoFalhou;
	}

	public boolean isDestinoParaEVM() {
		return destinoParaEVM;
	}

	public void setDestinoParaEVM(boolean destinoParaEVM) {
		this.destinoParaEVM = destinoParaEVM;
	}

	public String getIgnorarIcsInventariados() {
		return ignorarIcsInventariados;
	}

	public void setIgnorarIcsInventariados(String ignorarIcsInventariados) {
		this.ignorarIcsInventariados = ignorarIcsInventariados;
	}

	public Integer getTempoIgnorarIcs() {
		return tempoIgnorarIcs;
	}

	public void setTempoIgnorarIcs(Integer tempoIgnorarIcs) {
		this.tempoIgnorarIcs = tempoIgnorarIcs;
	}

	public Integer getTipoIgnorarIcs() {
		return tipoIgnorarIcs;
	}

	public void setTipoIgnorarIcs(Integer tipoIgnorarIcs) {
		this.tipoIgnorarIcs = tipoIgnorarIcs;
	}

	public Integer getIdConexao() {
		return idConexao;
	}

	public void setIdConexao(Integer idConexao) {
		this.idConexao = idConexao;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (obj == null) {
			return false;
		}

		if (getClass() != obj.getClass()) {
			return false;
		}

		InventoryConfig other = (InventoryConfig) obj;

		if (destino == null) {
			if (other.destino != null) {
				return false;
			}
		} else if (!destino.equals(other.destino)) {
			return false;
		}

		if (expressaoCron == null) {
			if (other.expressaoCron != null) {
				return false;
			}
		} else if (!expressaoCron.equals(other.expressaoCron)) {
			return false;
		}

		if (faixa == null) {
			if (other.faixa != null) {
				return false;
			}
		} else if (!faixa.equals(other.faixa)) {
			return false;
		}

		if (ipServidorInv == null) {
			if (other.ipServidorInv != null) {
				return false;
			}
		} else if (!ipServidorInv.equals(other.ipServidorInv)) {
			return false;
		}

		if (portaAgenteDotNet != other.portaAgenteDotNet) {
			return false;
		}

		if (portaSNMP != other.portaSNMP) {
			return false;
		}

		return true;
	}

	/**
	 * Builder para facilitar a criação de um {@link InventoryConfig}
	 *
	 * @author bruno.ribeiro - <a
	 *         href="mailto:bruno.ribeiro@centrait.com.br">bruno
	 *         .ribeiro@centrait.com.br</a>
	 * @since 08/01/2015
	 *
	 */
	public static class Builder {

		private final InventoryConfig config;

		private Builder() {
			config = new InventoryConfig();
		}

		public Builder faixa(final String faixa) {
			config.setFaixa(faixa);
			return this;
		}

		public Builder completo(final boolean completo) {
			config.setCompleto(completo);
			return this;
		}

		public Builder portaAgenteDotNet(final int portaAgenteDotNet) {
			config.setPortaAgenteDotNet(portaAgenteDotNet);
			return this;
		}

		public Builder portaSNMP(final int portaSNMP) {
			config.setPortaSNMP(portaSNMP);
			return this;
		}

		public Builder diretorioArquivos(final String diretorioArquivos) {
			config.setDiretorioArquivos(diretorioArquivos);
			return this;
		}

		public Builder ipServidor(final String ipServidor) {
			config.setIpServidorInv(ipServidor);
			return this;
		}

		public Builder destino(final String destino) {
			config.setDestino(destino);
			return this;
		}

		public Builder gravarArquivo(final boolean gravarArquivo) {
			config.setGravarArquivo(gravarArquivo);
			return this;
		}

		public Builder transmitirViaWS(final boolean transmitirViaWS) {
			config.setTransmitirViaWS(transmitirViaWS);
			return this;
		}

		public InventoryConfig build() {
			return config;
		}

		public Builder expressaoCron(final String expressaoCron) {
			config.setExpressaoCron(expressaoCron);
			return this;
		}

		public Builder conexaoFalhou(final boolean conexaoFalhou) {
			config.setConexaoFalhou(conexaoFalhou);
			return this;
		}

		public Builder destinoParaEVM(final boolean destinoParaEVM) {
			config.setDestinoParaEVM(destinoParaEVM);
			return this;
		}

	}

}
