/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.fila;

import javax.ejb.Stateless;

import org.apache.log4j.Logger;

import br.com.centralit.enums.Queue;
import br.com.centralit.mongodb.MongoDBUtils;

@Stateless
public class InventoryProducer implements IInventoryProducer {

	private static final Logger LOGGER = Logger.getLogger(InventoryProducer.class);

	@Override
	public void send(String message) {
		try {
			Fila f = new Fila();
			f.setMessage(message);
			f.setDone(false);

			MongoDBUtils.getInstance().create(f, Queue.INVENTORY_QUEUE.getName());

			LOGGER.debug("Citsmart Inventory > Nova mensagem enviada para a fila.");
		} catch (final Exception e) {
			LOGGER.error("Citsmart Inventory > Nao foi enviar a mensagem.", e);
		}
	}

}
