/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.icmp4j.platform.unix.jna;

import java.util.Arrays;
import java.util.List;

import com.sun.jna.Library;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;

public interface IcmpLibrary extends Library {
	
	public void icmp4j_exist(PointerByReference val);
	public void icmp4j_exist_free(Pointer p);
	
	public static class Icmp4jStruct extends Structure {
		public static class ByReference extends Icmp4jStruct implements Structure.ByReference {}
		
		public String		host;
		public int			ttl;
		public int			packetSize;
		public NativeLong 	timeOut;
		
		public int			retCode;
		public int			hasTimeout;
		public int			bytes;
		public int			returnTtl;
		public int			rtt;
		public String		address;
		public String		errorMsg;
		public int			errno;
		
		@Override
		protected List<String> getFieldOrder() {
			return Arrays.asList (new String[] {"host", "ttl", "packetSize", "timeOut", "retCode", "hasTimeout",
					"bytes", "returnTtl", "rtt", "address", "errorMsg", "errno"});
		}
	} 
	public void icmp4j_start(Icmp4jStruct.ByReference sval);
	public void icmp4j_free(Icmp4jStruct.ByReference sval);

}
