/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.icmp4j.tool;

import br.com.centralit.icmp4j.IcmpPingRequest;
import br.com.centralit.icmp4j.IcmpPingResponse;
import br.com.centralit.icmp4j.IcmpPingUtil;

// Sample class, copyright 2009 and beyond, icmp4j
public class Sample {
  
  // the java entry point
  public static void main (final String[] args)
    throws Exception {

    // request
    final IcmpPingRequest request = IcmpPingUtil.createIcmpPingRequest ();
    request.setHost ("www.google.org");

    // repeat a few times
    for (int count = 1; count <= 4; count ++) {

      // delegate
      final IcmpPingResponse response = IcmpPingUtil.executePingRequest (request);

      // log
      final String formattedResponse = IcmpPingUtil.formatResponse (response);
      System.out.println (formattedResponse);

      // rest
      Thread.sleep (1000);
    }
  }
}
