/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.util;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class Enumerados implements Serializable {

	private static final long serialVersionUID = 2466679077707063321L;

	/**
	 * Enumerado para armazenar os Tipos de Data.
	 * 
	 * DATE_DEFAULT: dd/MM/yyyy ou MM/dd/yyyy, TIMESTAMP_DEFAULT: dd/MM/yyyy HH:mm ou MM/dd/yyyy HH:mm, TIMESTAMP_WITH_SECONDS: dd/MM/yyyy HH:mm:ss ou MM/dd/yyyy HH:mm:ss, FORMAT_DATABASE: yyyy-MM-dd
	 * 
	 * @author valdoilo.damasceno
	 * @since 04.02.2013
	 */
	public enum TipoDate {
		DATE_DEFAULT("DATE_DEFAULT"), TIMESTAMP_DEFAULT("TIMESTAMP_DEFAULT"), TIMESTAMP_WITH_SECONDS("TIMESTAMP_WITH_SECONDS"), FORMAT_DATABASE("FORMAT_DATABASE"), FORMAT_DATABASE_WITH_HOUR_AND_SECOND("FORMAT_DATABASE_WITH_HOUR_AND_SECOND");

		private String tipoData;

		TipoDate(String tipoDate) {
			this.tipoData = tipoDate;
		}

		public String getTipoDate() {
			return tipoData;
		}
	}

	/**
	 * Enumerados que contém o nome da sigla de datas em inglês e em português para que seja realizado a conversão
	 * 
	 * @author thyen.chang
	 * @since 11/03/2015
	 */
	public enum DiaData {
		SEGUNDA("Mon", "Seg"), TERCA("Tue", "Ter"), QUARTA("Wed", "Qua"), QUINTA("Thu", "Qui"), SEXTA("Fri", "Sex"), SABADO("Sat", "Sab"), DOMINGO("Sun", "Dom");

		final String diaEn, diaPt;

		private DiaData(final String diaEn, final String diaPt) {
			this.diaEn = diaEn;
			this.diaPt = diaPt;
		}

		public String getDiaEn() {
			return this.diaEn;
		}

		public String getDiaPt() {
			return this.diaPt;
		}
	} //Este enumerado foi criado para contornar o problema de se ter mais de um encoding para as telas do citsmart

	//com este enumerado podemos setar encodings diferentes para a tela de upload.

	/**
	 * Define os tipos de inventários que podem ser executados.
	 * 
	 * @author rodrigo.acorse
	 * @since 29/10/215
	 */
	public enum TipoInventario {
		COMPLETO("COMPLETO"), DEMANDA("DEMANDA");

		private String tipoInventario;

		TipoInventario(String tipoInventario) {
			this.tipoInventario = tipoInventario;
		}

		public String getTipoInventario() {
			return tipoInventario;
		}
	}

	public enum TipoTempo {
		MINUTOS(1, TimeUnit.MINUTES), HORAS(2, TimeUnit.HOURS), DIAS(3, TimeUnit.DAYS);

		private Integer id;
		private TimeUnit timeUnit;

		TipoTempo(Integer id, TimeUnit timeUnit) {
			this.id = id;
			this.timeUnit = timeUnit;
		}

		public Integer getId() {
			return this.id;
		}

		public TimeUnit getTimeUnit() {
			return this.timeUnit;
		}

		public static TipoTempo fromId(Integer id) {
			for (TipoTempo tipoTempo : TipoTempo.values()) {
				if (tipoTempo.getId().equals(id)) {
					return tipoTempo;
				}
			}

			return null;
		}
	}
	
	public enum StatusInventario {
		INVENTARIADA(1, "inventario.status.inventariada"),
		IGNORADA(2, "inventario.status.ignorada"),
		INACESSIVEL(3, "inventario.status.inacessivel"),
		EMEXECUCAO(4, "citcorpore.comum.emExecucao"),
		NAOINVENTARIADA(5, "inventario.status.naoInventariada");

		private final Integer id;
		private final String chave;
	
		private StatusInventario(final Integer id, final String chave) {
			this.id = id;
			this.chave = chave;
		}
	
		public Integer getId() {
			return id;
		}
	
		public String getChave() {
			return chave;
		}
	}
}
