/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.util;

public enum StatusIC {

    ATIVADO(1, "Ativado", "baseItemConfiguracao.Ativado"),
    DESATIVADO(2, "Desativado", "baseItemConfiguracao.Desativado"),
    EM_MANUTENCAO(3, "Em Manutenção", "baseItemConfiguracao.Em_Manutenção"),
    IMPLANTACAO(4, "Implantação", "baseItemConfiguracao.Implantação"),
    HOMOLOGACAO(5, "Homologação", "baseItemConfiguracao.Homologação"),
    EM_DESENVOLVIMENTO(6, "Em Desenvolvimento", "baseItemConfiguracao.Em_Desenvolvimento"),
    ARQUIVADO(7, "Arquivado", "baseItemConfiguracao.Arquivado"),
    VALIDAR(8, "Validar Item", "baseItemConfiguracao.Validar_Item");

    private final Integer id;
    private final String descricao;
    private final String chaveInternacionalizacao;

    private StatusIC(final Integer id, final String descricao, final String chaveInternacionalizacao) {
        this.id = id;
        this.descricao = descricao;
        this.chaveInternacionalizacao = chaveInternacionalizacao;
    }

    public Integer getId() {
        return id;
    }

    public String getDescricao() {
        return descricao;
    }

    public String getChaveInternacionalizacao() {
        return chaveInternacionalizacao;
    }

    public static StatusIC fromID(final Integer id) {
        StatusIC result = null;
        final StatusIC[] values = StatusIC.values();
        for (final StatusIC status : values) {
            if (status.getId().equals(id)) {
                result = status;
                break;
            }
        }
        return result;
    }

}
