/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.util.net;


public class IPAddress {

    public static int PING_TIMEOUT = 6000;
    private final Long value;
    public static final boolean isUnix = !System.getProperty("os.name").startsWith("Windows");

    public IPAddress(final Long value) {
        this.value = value;
    }

    public IPAddress(String stringValue) {
        if (stringValue == null) {
            stringValue = "";
        }
        stringValue = stringValue.trim();
        final String[] parts = stringValue.split("\\.");
        if (parts.length != 4) {
            throw new IllegalArgumentException();
        }
        value = (long) (Integer.parseInt(parts[0], 10) << 8 * 3 & 0xFF000000 | Integer.parseInt(parts[1], 10) << 8 * 2 & 0x00FF0000 | Integer.parseInt(parts[2], 10) << 8 * 1
                & 0x0000FF00 | Integer.parseInt(parts[3], 10) << 8 * 0 & 0x000000FF);
    }

    public int getOctet(final int i) {
        if (i < 0 || i >= 4) {
            throw new IndexOutOfBoundsException();
        }

        return (int) (value >> i * 8 & 0x000000FF);
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();

        for (int i = 3; i >= 0; --i) {
            sb.append(this.getOctet(i));
            if (i != 0) {
                sb.append(".");
            }
        }

        return sb.toString();
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj instanceof IPAddress) {
            return value == ((IPAddress) obj).value;
        }
        return false;
    }

    public Long getValue() {
        return value;
    }

    public IPAddress next() {
        return new IPAddress(value + 1);
    }

    public boolean ping() {
        return NetPing.isReachablebyPing(this.toString());
    }

}
