/**********************************LICENCA*GPLv2********************************************************************
* Copyright [2011,2012,2013,2014,2015,2016] da CentralIT Tecnologia da Informao Ltda (www.centralit.com.br)      *
*                                                                                                                  *
* Este arquivo  parte do programa/software: Citsmart (www.citsmart.com.br)                                        *
*                                                                                                                  *
* O Citsmart  um software livre; voc pode redistribui-lo e/ou modific-lo dentro dos termos da Licena           *
* Pblica Geral GNU como publicada pela Fundao do Software Livre (FSF); na verso 2 da Licena.                  *
*                                                                                                                  *
* Este programa/software  distribudo na esperana que possa ser til, mas SEM NENHUMA GARANTIA; sem uma          *
* garantia implcita de ADEQUAO a qualquer MERCADO ou APLICAO EM PARTICULAR. Veja a Licena Pblica Geral      *
* GNU/GPL em portugus para maiores detalhes.                                                                      *
*                                                                                                                  *
* Voc deve ter recebido uma cpia da Licena Pblica Geral GNU, sob o ttulo 'LICENCA.txt', junto com este        *
* programa/software, se no, acesse o Portal do Software Pblico Brasileiro no endereo www.softwarepublico.gov.br *
* ou escreva para a Fundao do Software Livre (FSF) Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301,USA  *
********************************************************************************************************************/
package br.com.centralit.util.net;

import java.io.IOException;
import java.util.List;

import org.apache.log4j.Logger;

/**
 * Classe utilitária responsável por implementar a rotina que realiza um ping em
 * um Item de configuração, ela foi retirada da classe IPAddress porque o ping
 * pode utilizar o nome para alcançar um IC e se tal nome for utilizado para
 * representar um número IP, gerará uma excessão na hora de transformá-lo em
 * valor numérico.
 *
 * @author euler.ramos
 *
 */
public class NetPing {
	private static final Logger LOGGER = Logger.getLogger(NetPing.class);

	public static boolean isReachablebyPing(final String nomeHostIP) {
		try {
			String command = "ping -c 2 " + nomeHostIP; // For Linux and OSX

			if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
				command = "ping -n 2 " + nomeHostIP; // For Windows
			}

			LOGGER.debug("Citsmart Inventory > Executando ping: " + command);

			final Process proc = Runtime.getRuntime().exec(command);
			final StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT");
			outputGobbler.start();

			proc.waitFor();
			return NetPing.checkAvailability(outputGobbler.getOutputLines());
		} catch (IOException | InterruptedException ex) {
			LOGGER.debug(ex.getMessage(), ex);
		}

		return false;
	}

	private static boolean checkAvailability(final List<String> outputLines) {
		for (final String line : outputLines) {
			final int icmpReqIndex = line.indexOf("icmp_req=");
			final int icmpSeqIndex = line.indexOf("icmp_seq=");
			final int TTLIndex = line.indexOf("TTL=");
			final int ttlIndex = line.indexOf("ttl=");

			if (icmpReqIndex < 0 && icmpSeqIndex < 0 && TTLIndex < 0 && ttlIndex < 0) {
				continue;
			} else {
				return true;
			}
		}

		return false;
	}

	/*public static boolean isReachablebyPing(final String nomeHostIP) {
		//TODO Testar implementação em ambientes unix
		try {
			final IcmpPingRequest request = IcmpPingUtil.createIcmpPingRequest();
			request.setHost(nomeHostIP);
	
			IcmpPingResponse response = null;
			response = IcmpPingUtil.executePingRequest(request);
	
			if (!response.getSuccessFlag()) {
				Thread.sleep(1000);
				response = IcmpPingUtil.executePingRequest(request);
			}
	
			return (response != null ? response.getSuccessFlag() : false);
		} catch (Exception e) {
			LOGGER.debug(e.getMessage(), e);
		}
	
		return false;
	}*/
}
